# Analog

<!-- prettier-ignore-start -->
<!-- ALL-CONTRIBUTORS-BADGE:START - Do not remove or modify this section -->
[![All Contributors](https://img.shields.io/badge/all_contributors-127-orange.svg?style=flat-square)](#contributors-)
<!-- ALL-CONTRIBUTORS-BADGE:END -->
<!-- prettier-ignore-end -->

[![Discord server](https://dcbadge.vercel.app/api/server/mKC2Ec48U5?style=flat-square)](https://chat.analogjs.org/) [![Twitter](https://img.shields.io/twitter/follow/analogjs)](https://twitter.com/analogjs)

Analog is the meta-framework for building applications and websites with [Angular](https://angular.dev).

Similar to other meta-frameworks such as Next.JS, Nuxt, SvelteKit, Qwik City, and others, Analog provides a similar experience, building on top of Angular.

## Documentation

Visit the docs at [https://analogjs.org](https://analogjs.org)

## Features

- Powered by Vite
- Supports Vitest/Storybook
- Server and deployment integrations powered by [Nitro](https://nitro.unjs.io)
- File-based routing
- Server-side data fetching
- Support for using markdown as content routes
- Integrated API/server routes
- Hybrid SSR/SSG support
- Supports Angular CLI and Nx workspaces

## Getting Started

Use your package manager of choice to create a new project

With npm:

```sh
npm create analog@latest
```

With pnpm:

```sh
pnpm create analog@latest
```

With Bun:

```sh
bun create analog@latest
```

With Yarn:

```sh
yarn create analog
```

Follow the prompts to scaffold the project and start the development server.

[![Open in StackBlitz](https://developer.stackblitz.com/img/open_in_stackblitz.svg)](https://analogjs.org/new)

### Partners

<a href="https://zerops.io?utm_source=analog&utm_medium=github&utm_campaign=partnership" target="_blank">
  <img src="https://github.com/analogjs/analog/blob/main/apps/docs-app/static/img/logos/zerops-logo.svg" width="100px" height="100px" alt="Zerops" />
</a>

### Sponsors

<a href="https://github.blog/2023-04-12-github-accelerator-our-first-cohort-and-whats-next/" target="_blank">
  <img src="https://github.com/analogjs/analog/blob/main/apps/docs-app/static/img/logos/github-logo.svg" width="100px" height="100px" alt="GitHub Accelerator" />
</a>

<a href="https://nx.dev" target="_blank">
  <img src="https://github.com/analogjs/analog/blob/main/apps/docs-app/static/img/logos/nx-logo.dark.svg" width="100px" height="100px" alt="NxDevTools" />
</a>

<a href="https://houseofangular.io" target="_blank">
  <img src="https://github.com/analogjs/analog/blob/main/apps/docs-app/static/img/logos/house-of-angular.png" width="100px" height="100px" alt="House of Angular" />
</a>

<a href="https://code.build" target="_blank">
  <img src="https://github.com/analogjs/analog/blob/main/apps/docs-app/static/img/logos/code.build-1x1.svg" width="100px" height="100px" alt="Code.Build" />
</a>

<a href="https://snyder.tech/" target="_blank">
  <img src="https://media.licdn.com/dms/image/C4E0BAQG4hMvLznt6_Q/company-logo_200_200/0/1630618311041/snydertechnologies_logo?e=2147483647&v=beta&t=TFq6VKWAgb5oI0FmbvaeTPFzMJR9S94_LvnLnlRqfLI" width="100px" height="100px" alt="Snyder Tech" />
</a>

## Supporting Analog

- Star the [GitHub Repo](https://github.com/analogjs/analog)
- Join the [Discord](https://chat.analogjs.org)
- Follow us on [Twitter](https://twitter.com/analogjs)
- Become a [Sponsor](https://analogjs.org/docs/sponsoring)

## Contributing

Analog welcomes contributors! Please read the [contributing doc](https://github.com/analogjs/analog/blob/main/CONTRIBUTING.md) for details.

## Credits

The name was inspired by this project https://github.com/rrdelaney/Analog.

## Contributors ✨

Thanks goes to these wonderful people for contributing to Analog ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tbody>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://brandonroberts.dev"><img src="https://avatars.githubusercontent.com/u/42211?v=4?s=100" width="100px;" alt="Brandon"/><br /><sub><b>Brandon</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=brandonroberts" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=brandonroberts" title="Documentation">📖</a> <a href="#ideas-brandonroberts" title="Ideas, Planning, & Feedback">🤔</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://dev.to/layzee"><img src="https://avatars.githubusercontent.com/u/6364586?v=4?s=100" width="100px;" alt="Lars Gyrup Brink Nielsen"/><br /><sub><b>Lars Gyrup Brink Nielsen</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=LayZeeDK" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=LayZeeDK" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://dev.to/markostanimirovic"><img src="https://avatars.githubusercontent.com/u/17877290?v=4?s=100" width="100px;" alt="Marko Stanimirović"/><br /><sub><b>Marko Stanimirović</b></sub></a><br /><a href="#tool-markostanimirovic" title="Tools">🔧</a> <a href="#infra-markostanimirovic" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=markostanimirovic" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=markostanimirovic" title="Code">💻</a> <a href="#design-markostanimirovic" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jasonhodges"><img src="https://avatars.githubusercontent.com/u/1988476?v=4?s=100" width="100px;" alt="Jason Hodges"/><br /><sub><b>Jason Hodges</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=jasonhodges" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://timdeschryver.dev"><img src="https://avatars.githubusercontent.com/u/28659384?v=4?s=100" width="100px;" alt="Tim Deschryver"/><br /><sub><b>Tim Deschryver</b></sub></a><br /><a href="#infra-timdeschryver" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://dalenguyen.me"><img src="https://avatars.githubusercontent.com/u/14116156?v=4?s=100" width="100px;" alt="Dale Nguyen"/><br /><sub><b>Dale Nguyen</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=dalenguyen" title="Code">💻</a> <a href="#design-dalenguyen" title="Design">🎨</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Villanuevand"><img src="https://avatars.githubusercontent.com/u/1209238?v=4?s=100" width="100px;" alt="Andrés Villanueva"/><br /><sub><b>Andrés Villanueva</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Villanuevand" title="Documentation">📖</a> <a href="#translation-Villanuevand" title="Translation">🌍</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://umairhafeez.com"><img src="https://avatars.githubusercontent.com/u/6948878?v=4?s=100" width="100px;" alt="Umair Hafeez"/><br /><sub><b>Umair Hafeez</b></sub></a><br /><a href="#infra-umairhm" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Yberion"><img src="https://avatars.githubusercontent.com/u/4186385?v=4?s=100" width="100px;" alt="Brandon Largeau"/><br /><sub><b>Brandon Largeau</b></sub></a><br /><a href="#infra-Yberion" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://mainawycliffe.dev/"><img src="https://avatars.githubusercontent.com/u/12270550?v=4?s=100" width="100px;" alt="Maina Wycliffe"/><br /><sub><b>Maina Wycliffe</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=mainawycliffe" title="Code">💻</a> <a href="#infra-mainawycliffe" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.prestonlamb.com"><img src="https://avatars.githubusercontent.com/u/2006222?v=4?s=100" width="100px;" alt="Preston Lamb"/><br /><sub><b>Preston Lamb</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=pjlamb12" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=pjlamb12" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://iamandrewluca.com"><img src="https://avatars.githubusercontent.com/u/1881266?v=4?s=100" width="100px;" alt="Andrew Luca"/><br /><sub><b>Andrew Luca</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=iamandrewluca" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nartc.me"><img src="https://avatars.githubusercontent.com/u/25516557?v=4?s=100" width="100px;" alt="Chau Tran"/><br /><sub><b>Chau Tran</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nartc" title="Code">💻</a> <a href="#infra-nartc" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/simitch1"><img src="https://avatars.githubusercontent.com/u/20285365?v=4?s=100" width="100px;" alt="Simone "/><br /><sub><b>Simone </b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=simitch1" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://kylerjohnson.dev"><img src="https://avatars.githubusercontent.com/u/75549176?v=4?s=100" width="100px;" alt="Kyler Johnson"/><br /><sub><b>Kyler Johnson</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=KylerJohnsonDev" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://marcjulian.de/?ref=github"><img src="https://avatars.githubusercontent.com/u/8985933?v=4?s=100" width="100px;" alt="Marc"/><br /><sub><b>Marc</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=marcjulian" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=marcjulian" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/himyjan"><img src="https://avatars.githubusercontent.com/u/51815522?v=4?s=100" width="100px;" alt="himyjan"/><br /><sub><b>himyjan</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=himyjan" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/TicTak21"><img src="https://avatars.githubusercontent.com/u/44474697?v=4?s=100" width="100px;" alt="Alex Kovalev"/><br /><sub><b>Alex Kovalev</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=TicTak21" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.linkedin.com/in/nuhmanpk"><img src="https://avatars.githubusercontent.com/u/62880706?v=4?s=100" width="100px;" alt="Nuhman Pk"/><br /><sub><b>Nuhman Pk</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nuhmanpk" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/miluoshi"><img src="https://avatars.githubusercontent.com/u/1130547?v=4?s=100" width="100px;" alt="Miloš Lajtman"/><br /><sub><b>Miloš Lajtman</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=miluoshi" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.youtube.com/c/CodeShotsWithProfanis"><img src="https://avatars.githubusercontent.com/u/7045092?v=4?s=100" width="100px;" alt="profanis"/><br /><sub><b>profanis</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=profanis" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/hrmcdonald"><img src="https://avatars.githubusercontent.com/u/39349270?v=4?s=100" width="100px;" alt="Reece McDonald"/><br /><sub><b>Reece McDonald</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=hrmcdonald" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ilteoood.xyz/"><img src="https://avatars.githubusercontent.com/u/6383527?v=4?s=100" width="100px;" alt="Matteo Pietro Dazzi"/><br /><sub><b>Matteo Pietro Dazzi</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ilteoood" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://lukasmatta.com"><img src="https://avatars.githubusercontent.com/u/4323927?v=4?s=100" width="100px;" alt="Lukáš Matta"/><br /><sub><b>Lukáš Matta</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=lukasmatta" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://ngrome.io"><img src="https://avatars.githubusercontent.com/u/281553?v=4?s=100" width="100px;" alt="Luciano"/><br /><sub><b>Luciano</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=lucianomurr" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=lucianomurr" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://goetzrobin.github.io"><img src="https://avatars.githubusercontent.com/u/35136007?v=4?s=100" width="100px;" alt="Robin Goetz"/><br /><sub><b>Robin Goetz</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=goetzrobin" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ch1ffa"><img src="https://avatars.githubusercontent.com/u/17417010?v=4?s=100" width="100px;" alt="Vadim Evseev"/><br /><sub><b>Vadim Evseev</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ch1ffa" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://k9n.dev"><img src="https://avatars.githubusercontent.com/u/4279702?v=4?s=100" width="100px;" alt="Danny Koppenhagen"/><br /><sub><b>Danny Koppenhagen</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=d-koppenhagen" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=d-koppenhagen" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://tomwebwalker.pl/"><img src="https://avatars.githubusercontent.com/u/11270899?v=4?s=100" width="100px;" alt="Tomasz Flis"/><br /><sub><b>Tomasz Flis</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=TomWebwalker" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/AdditionAddict"><img src="https://avatars.githubusercontent.com/u/48436581?v=4?s=100" width="100px;" alt="AdditionAddict"/><br /><sub><b>AdditionAddict</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=AdditionAddict" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=AdditionAddict" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/sander-t-0a461458"><img src="https://avatars.githubusercontent.com/u/17591696?v=4?s=100" width="100px;" alt="Sander"/><br /><sub><b>Sander</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=sand4rt" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://perko.dev"><img src="https://avatars.githubusercontent.com/u/5384791?v=4?s=100" width="100px;" alt="Chris Perko"/><br /><sub><b>Chris Perko</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=BaronVonPerko" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=BaronVonPerko" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://christianlydemann.com"><img src="https://avatars.githubusercontent.com/u/9210691?v=4?s=100" width="100px;" alt="Christian Lüdemann"/><br /><sub><b>Christian Lüdemann</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=lydemann" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://yasser.page"><img src="https://avatars.githubusercontent.com/u/9917969?v=4?s=100" width="100px;" alt="Yasser"/><br /><sub><b>Yasser</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=yassernasc" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/MDyrcz5"><img src="https://avatars.githubusercontent.com/u/23345904?v=4?s=100" width="100px;" alt="Michał Dyrcz"/><br /><sub><b>Michał Dyrcz</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=MDyrcz5" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/otonielguajardo"><img src="https://avatars.githubusercontent.com/u/23427095?v=4?s=100" width="100px;" alt="Otoniel Guajardo"/><br /><sub><b>Otoniel Guajardo</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=otonielguajardo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/gergobergo"><img src="https://avatars.githubusercontent.com/u/25322572?v=4?s=100" width="100px;" alt="gergobergo"/><br /><sub><b>gergobergo</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=gergobergo" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=gergobergo" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/saurajit"><img src="https://avatars.githubusercontent.com/u/3590300?v=4?s=100" width="100px;" alt="saurajit"/><br /><sub><b>saurajit</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=saurajit" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.monocube.com"><img src="https://avatars.githubusercontent.com/u/2464830?v=4?s=100" width="100px;" alt="Mircea Rilă"/><br /><sub><b>Mircea Rilă</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=zawasp" title="Documentation">📖</a> <a href="#infra-zawasp" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://dafnik.me"><img src="https://avatars.githubusercontent.com/u/16242839?v=4?s=100" width="100px;" alt="Dominik"/><br /><sub><b>Dominik</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Dafnik" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=Dafnik" title="Code">💻</a> <a href="#infra-Dafnik" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://henriquecustodia.dev"><img src="https://avatars.githubusercontent.com/u/5140430?v=4?s=100" width="100px;" alt="Henrique Custódia"/><br /><sub><b>Henrique Custódia</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=henriquecustodia" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://isoden.dev"><img src="https://avatars.githubusercontent.com/u/3771988?v=4?s=100" width="100px;" alt="ISODA Yu"/><br /><sub><b>ISODA Yu</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=isoden" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://cynthia-developer.netlify.com"><img src="https://avatars.githubusercontent.com/u/37863089?v=4?s=100" width="100px;" alt="Cynthia Iradukunda"/><br /><sub><b>Cynthia Iradukunda</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ciradu2204" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Drunkenpilot"><img src="https://avatars.githubusercontent.com/u/2257567?v=4?s=100" width="100px;" alt="Drunkenpilot"/><br /><sub><b>Drunkenpilot</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Drunkenpilot" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=Drunkenpilot" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jeremyhofer"><img src="https://avatars.githubusercontent.com/u/17076628?v=4?s=100" width="100px;" alt="Jeremy Hofer"/><br /><sub><b>Jeremy Hofer</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=jeremyhofer" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=jeremyhofer" title="Code">💻</a> <a href="#infra-jeremyhofer" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.routechnology.tech"><img src="https://avatars.githubusercontent.com/u/61606062?v=4?s=100" width="100px;" alt="Olalekan Raheem"/><br /><sub><b>Olalekan Raheem</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=SOG-web" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/luishcastroc"><img src="https://avatars.githubusercontent.com/u/13698269?v=4?s=100" width="100px;" alt="Luis Castro"/><br /><sub><b>Luis Castro</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=luishcastroc" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=luishcastroc" title="Documentation">📖</a> <a href="#translation-luishcastroc" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/QuantariusRay"><img src="https://avatars.githubusercontent.com/u/31900736?v=4?s=100" width="100px;" alt="Q"/><br /><sub><b>Q</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=QuantariusRay" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=QuantariusRay" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/cskiwi"><img src="https://avatars.githubusercontent.com/u/847540?v=4?s=100" width="100px;" alt="Glenn Latomme"/><br /><sub><b>Glenn Latomme</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=cskiwi" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="http://www.justinrassier.com"><img src="https://avatars.githubusercontent.com/u/1228424?v=4?s=100" width="100px;" alt="Justin Rassier"/><br /><sub><b>Justin Rassier</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=justinrassier" title="Documentation">📖</a> <a href="https://github.com/analogjs/analog/commits?author=justinrassier" title="Code">💻</a> <a href="#infra-justinrassier" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://riegler.fr"><img src="https://avatars.githubusercontent.com/u/1300985?v=4?s=100" width="100px;" alt="Matthieu Riegler"/><br /><sub><b>Matthieu Riegler</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=JeanMeche" title="Documentation">📖</a> <a href="#infra-JeanMeche" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=JeanMeche" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ashley-hunter"><img src="https://avatars.githubusercontent.com/u/20795331?v=4?s=100" width="100px;" alt="Ashley Hunter"/><br /><sub><b>Ashley Hunter</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ashley-hunter" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://ng-guru.io"><img src="https://avatars.githubusercontent.com/u/7337691?v=4?s=100" width="100px;" alt="Artur Androsovych"/><br /><sub><b>Artur Androsovych</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=arturovt" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=arturovt" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://bjornlu.com"><img src="https://avatars.githubusercontent.com/u/34116392?v=4?s=100" width="100px;" alt="Bjorn Lu"/><br /><sub><b>Bjorn Lu</b></sub></a><br /><a href="#infra-bluwy" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/omarbelkhodja"><img src="https://avatars.githubusercontent.com/u/2501093?v=4?s=100" width="100px;" alt="Omar BELKHODJA"/><br /><sub><b>Omar BELKHODJA</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=omarbelkhodja" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/deepakrudrapaul"><img src="https://avatars.githubusercontent.com/u/25549935?v=4?s=100" width="100px;" alt="Deepak Rudra Paul"/><br /><sub><b>Deepak Rudra Paul</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=deepakrudrapaul" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/mavrukin"><img src="https://avatars.githubusercontent.com/u/239147?v=4?s=100" width="100px;" alt="Michael Avrukin"/><br /><sub><b>Michael Avrukin</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=mavrukin" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/rlmestre"><img src="https://avatars.githubusercontent.com/u/277805?v=4?s=100" width="100px;" alt="Rafael Mestre"/><br /><sub><b>Rafael Mestre</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=rlmestre" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=rlmestre" title="Documentation">📖</a> <a href="#infra-rlmestre" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/santoshyadavdev"><img src="https://avatars.githubusercontent.com/u/11923975?v=4?s=100" width="100px;" alt="Santosh Yadav"/><br /><sub><b>Santosh Yadav</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=santoshyadavdev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Tenessy"><img src="https://avatars.githubusercontent.com/u/65855673?v=4?s=100" width="100px;" alt="Tenessy"/><br /><sub><b>Tenessy</b></sub></a><br /><a href="#infra-Tenessy" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=Tenessy" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=Tenessy" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Jad31"><img src="https://avatars.githubusercontent.com/u/46532649?v=4?s=100" width="100px;" alt="Jad Chahed"/><br /><sub><b>Jad Chahed</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Jad31" title="Documentation">📖</a> <a href="#translation-Jad31" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.gta-sa.com.br/"><img src="https://avatars.githubusercontent.com/u/40439982?v=4?s=100" width="100px;" alt="Gesiel Rosa"/><br /><sub><b>Gesiel Rosa</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=gesielrosa" title="Documentation">📖</a> <a href="#translation-gesielrosa" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://besimgurbuz.dev/"><img src="https://avatars.githubusercontent.com/u/33575384?v=4?s=100" width="100px;" alt="Besim Gürbüz"/><br /><sub><b>Besim Gürbüz</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=besimgurbuz" title="Documentation">📖</a> <a href="#translation-besimgurbuz" title="Translation">🌍</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lukasnys"><img src="https://avatars.githubusercontent.com/u/22593230?v=4?s=100" width="100px;" alt="Lukas Nys"/><br /><sub><b>Lukas Nys</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=lukasnys" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alaendle"><img src="https://avatars.githubusercontent.com/u/969523?v=4?s=100" width="100px;" alt="Andreas Ländle"/><br /><sub><b>Andreas Ländle</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=alaendle" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ksgn.dev"><img src="https://avatars.githubusercontent.com/u/498197?v=4?s=100" width="100px;" alt="Pascal Küsgen"/><br /><sub><b>Pascal Küsgen</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Pascalmh" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://alejandrocuba.com"><img src="https://avatars.githubusercontent.com/u/6283346?v=4?s=100" width="100px;" alt="Alejandro Cuba Ruiz"/><br /><sub><b>Alejandro Cuba Ruiz</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=alejandrocuba" title="Documentation">📖</a> <a href="#translation-alejandrocuba" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Shreyas0410"><img src="https://avatars.githubusercontent.com/u/70795867?v=4?s=100" width="100px;" alt="Shreyas0410"/><br /><sub><b>Shreyas0410</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Shreyas0410" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Den-dp"><img src="https://avatars.githubusercontent.com/u/1770529?v=4?s=100" width="100px;" alt="Denis Bendrikov"/><br /><sub><b>Denis Bendrikov</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Den-dp" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/iancharlesdouglas"><img src="https://avatars.githubusercontent.com/u/3481593?v=4?s=100" width="100px;" alt="iancharlesdouglas"/><br /><sub><b>iancharlesdouglas</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=iancharlesdouglas" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://twitter.com/OCombe"><img src="https://avatars.githubusercontent.com/u/265378?v=4?s=100" width="100px;" alt="Olivier Combe"/><br /><sub><b>Olivier Combe</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ocombe" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sasidharansd"><img src="https://avatars.githubusercontent.com/u/47988127?v=4?s=100" width="100px;" alt="Sasidharan SD"/><br /><sub><b>Sasidharan SD</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=sasidharansd" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://beta.ajitpanigrahi.com"><img src="https://avatars.githubusercontent.com/u/19947758?v=4?s=100" width="100px;" alt="Ajit Panigrahi"/><br /><sub><b>Ajit Panigrahi</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ajitzero" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nemu69"><img src="https://avatars.githubusercontent.com/u/43633395?v=4?s=100" width="100px;" alt="nepage-l"/><br /><sub><b>nepage-l</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nemu69" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://jeffreysmith.ninja"><img src="https://avatars.githubusercontent.com/u/5161547?v=4?s=100" width="100px;" alt="Jeff"/><br /><sub><b>Jeff</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Jefftopia" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://sammymohamed.com"><img src="https://avatars.githubusercontent.com/u/22568206?v=4?s=100" width="100px;" alt="Sammy Mohamed"/><br /><sub><b>Sammy Mohamed</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=thatsamsonkid" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.joshmorony.com"><img src="https://avatars.githubusercontent.com/u/2578009?v=4?s=100" width="100px;" alt="Josh Morony"/><br /><sub><b>Josh Morony</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=joshuamorony" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ilirbeqirii"><img src="https://avatars.githubusercontent.com/u/24731032?v=4?s=100" width="100px;" alt="Ilir Beqiri"/><br /><sub><b>Ilir Beqiri</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ilirbeqirii" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/remes2000"><img src="https://avatars.githubusercontent.com/u/26173223?v=4?s=100" width="100px;" alt="Michał Nieruchalski"/><br /><sub><b>Michał Nieruchalski</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=remes2000" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://angelfraga.com/"><img src="https://avatars.githubusercontent.com/u/11693938?v=4?s=100" width="100px;" alt="Angel Fraga Parodi"/><br /><sub><b>Angel Fraga Parodi</b></sub></a><br /><a href="#infra-angelfraga" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=angelfraga" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://alexfriesen.net/"><img src="https://avatars.githubusercontent.com/u/1307706?v=4?s=100" width="100px;" alt="Alex"/><br /><sub><b>Alex</b></sub></a><br /><a href="#infra-alexfriesen" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=alexfriesen" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/duluca"><img src="https://avatars.githubusercontent.com/u/822159?v=4?s=100" width="100px;" alt="Doguhan Uluca"/><br /><sub><b>Doguhan Uluca</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=duluca" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/nckirik"><img src="https://avatars.githubusercontent.com/u/53273233?v=4?s=100" width="100px;" alt="N. Can KIRIK"/><br /><sub><b>N. Can KIRIK</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nckirik" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ShPelles"><img src="https://avatars.githubusercontent.com/u/43875468?v=4?s=100" width="100px;" alt="ShPelles"/><br /><sub><b>ShPelles</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ShPelles" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://pavankjadda.dev"><img src="https://avatars.githubusercontent.com/u/17564080?v=4?s=100" width="100px;" alt="Pavan Kumar Jadda"/><br /><sub><b>Pavan Kumar Jadda</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=pavankjadda" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://monacodelisa.com/"><img src="https://avatars.githubusercontent.com/u/64324417?v=4?s=100" width="100px;" alt="Esther White"/><br /><sub><b>Esther White</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=monacodelisa" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=monacodelisa" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Micha-Richter"><img src="https://avatars.githubusercontent.com/u/12509902?v=4?s=100" width="100px;" alt="Michael Richter"/><br /><sub><b>Michael Richter</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Micha-Richter" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://a21.dev"><img src="https://avatars.githubusercontent.com/u/24437129?v=4?s=100" width="100px;" alt="Rafael Triantafillidis"/><br /><sub><b>Rafael Triantafillidis</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=alator21" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/pi0"><img src="https://avatars.githubusercontent.com/u/5158436?v=4?s=100" width="100px;" alt="Pooya Parsa"/><br /><sub><b>Pooya Parsa</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=pi0" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://crutchcorn.dev"><img src="https://avatars.githubusercontent.com/u/9100169?v=4?s=100" width="100px;" alt="Corbin Crutchley"/><br /><sub><b>Corbin Crutchley</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=crutchcorn" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://www.robusthaven.com"><img src="https://avatars.githubusercontent.com/u/730804?v=4?s=100" width="100px;" alt="Leblanc Meneses"/><br /><sub><b>Leblanc Meneses</b></sub></a><br /><a href="#infra-leblancmeneses" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=leblancmeneses" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=leblancmeneses" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/jculvey"><img src="https://avatars.githubusercontent.com/u/204386?v=4?s=100" width="100px;" alt="James Culveyhouse"/><br /><sub><b>James Culveyhouse</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=jculvey" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/naaajii"><img src="https://avatars.githubusercontent.com/u/54370141?v=4?s=100" width="100px;" alt="Naji"/><br /><sub><b>Naji</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=naaajii" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://honey.glass/"><img src="https://avatars.githubusercontent.com/u/1880749?v=4?s=100" width="100px;" alt="Bitcollage"/><br /><sub><b>Bitcollage</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=SerkanSipahi" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/sonukapoor"><img src="https://avatars.githubusercontent.com/u/59734?v=4?s=100" width="100px;" alt="Sonu Kapoor"/><br /><sub><b>Sonu Kapoor</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=sonukapoor" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.linkedin.com/in/ezzabuzaid"><img src="https://avatars.githubusercontent.com/u/29958503?v=4?s=100" width="100px;" alt="ezzabuzaid"/><br /><sub><b>ezzabuzaid</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ezzabuzaid" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://eduardoroth.dev"><img src="https://avatars.githubusercontent.com/u/5419161?v=4?s=100" width="100px;" alt="Eduardo Roth"/><br /><sub><b>Eduardo Roth</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=eduardoRoth" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://ryanclements.dev/"><img src="https://avatars.githubusercontent.com/u/20916810?v=4?s=100" width="100px;" alt="Ryan Clements"/><br /><sub><b>Ryan Clements</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=RyanClementsHax" title="Documentation">📖</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://byeonggi.vercel.app/"><img src="https://avatars.githubusercontent.com/u/11059706?v=4?s=100" width="100px;" alt="ByeongGi"/><br /><sub><b>ByeongGi</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ByeongGi" title="Documentation">📖</a> <a href="#translation-ByeongGi" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://marmicode.io"><img src="https://avatars.githubusercontent.com/u/2674658?v=4?s=100" width="100px;" alt="Younes Jaaidi"/><br /><sub><b>Younes Jaaidi</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=yjaaidi" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=yjaaidi" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://boogiemonsta.com/"><img src="https://avatars.githubusercontent.com/u/73052877?v=4?s=100" width="100px;" alt="BoogMon"/><br /><sub><b>BoogMon</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=BoogieMonsta" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://www.anthonygarera.com"><img src="https://avatars.githubusercontent.com/u/6021169?v=4?s=100" width="100px;" alt="Anthony Garera"/><br /><sub><b>Anthony Garera</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=AmGarera" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://stewan.io"><img src="https://avatars.githubusercontent.com/u/719763?v=4?s=100" width="100px;" alt="Stewan"/><br /><sub><b>Stewan</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=stewones" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=stewones" title="Tests">⚠️</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://naterad.com"><img src="https://avatars.githubusercontent.com/u/130445?v=4?s=100" width="100px;" alt="Nate Radebaugh"/><br /><sub><b>Nate Radebaugh</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=NateRadebaugh" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://angularexamples.wolsok.de/"><img src="https://avatars.githubusercontent.com/u/8589105?v=4?s=100" width="100px;" alt="Wolfram Sokollek"/><br /><sub><b>Wolfram Sokollek</b></sub></a><br /><a href="#infra-WolfSoko" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/muhammaduxair"><img src="https://avatars.githubusercontent.com/u/64395440?v=4?s=100" width="100px;" alt="Muhammad Uzair"/><br /><sub><b>Muhammad Uzair</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=muhammaduxair" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://pranavramesh.dev"><img src="https://avatars.githubusercontent.com/u/23617187?v=4?s=100" width="100px;" alt="Pranav Ramesh"/><br /><sub><b>Pranav Ramesh</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Laphatize" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://snyder.tech"><img src="https://avatars.githubusercontent.com/u/707567?v=4?s=100" width="100px;" alt="Ben Snyder"/><br /><sub><b>Ben Snyder</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=benpsnyder" title="Documentation">📖</a> <a href="#infra-benpsnyder" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://wordman.dev"><img src="https://avatars.githubusercontent.com/u/6104311?v=4?s=100" width="100px;" alt="Jan-Niklas W."/><br /><sub><b>Jan-Niklas W.</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=niklas-wortmann" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/gultyayev"><img src="https://avatars.githubusercontent.com/u/22374911?v=4?s=100" width="100px;" alt="Sergey Gultyayev (Serhii Hultiaiev)"/><br /><sub><b>Sergey Gultyayev (Serhii Hultiaiev)</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=gultyayev" title="Code">💻</a> <a href="https://github.com/analogjs/analog/commits?author=gultyayev" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://andersonmfjr.com"><img src="https://avatars.githubusercontent.com/u/66845464?v=4?s=100" width="100px;" alt="Anderson Feitosa"/><br /><sub><b>Anderson Feitosa</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=andersonmfjr" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/reboot25"><img src="https://avatars.githubusercontent.com/u/5337080?v=4?s=100" width="100px;" alt="Jun"/><br /><sub><b>Jun</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=reboot25" title="Documentation">📖</a> <a href="#translation-reboot25" title="Translation">🌍</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/DerHerrGammler"><img src="https://avatars.githubusercontent.com/u/30802629?v=4?s=100" width="100px;" alt="Felix Herold"/><br /><sub><b>Felix Herold</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=DerHerrGammler" title="Documentation">📖</a> <a href="#translation-DerHerrGammler" title="Translation">🌍</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://soheilnazari.de"><img src="https://avatars.githubusercontent.com/u/113988347?v=4?s=100" width="100px;" alt="Soheil Nazari [CHECK24]"/><br /><sub><b>Soheil Nazari [CHECK24]</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=s0h311" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/illunix"><img src="https://avatars.githubusercontent.com/u/42069493?v=4?s=100" width="100px;" alt="Maksymilian Szokalski"/><br /><sub><b>Maksymilian Szokalski</b></sub></a><br /><a href="#infra-illunix" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a> <a href="https://github.com/analogjs/analog/commits?author=illunix" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/osnoser1"><img src="https://avatars.githubusercontent.com/u/1179744?v=4?s=100" width="100px;" alt="Alfonso Andrés López Molina"/><br /><sub><b>Alfonso Andrés López Molina</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=osnoser1" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://arjunaditya.xyz"><img src="https://avatars.githubusercontent.com/u/73933669?v=4?s=100" width="100px;" alt="Nermal"/><br /><sub><b>Nermal</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nermalcat69" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://tobiasegli.ch"><img src="https://avatars.githubusercontent.com/u/20181671?v=4?s=100" width="100px;" alt="tobiasegli"/><br /><sub><b>tobiasegli</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=tobiasegli" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/lars0n"><img src="https://avatars.githubusercontent.com/u/15248125?v=4?s=100" width="100px;" alt="Larson"/><br /><sub><b>Larson</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=lars0n" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/ilyassFouih"><img src="https://avatars.githubusercontent.com/u/33469478?v=4?s=100" width="100px;" alt="Ilyass "/><br /><sub><b>Ilyass </b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=ilyassFouih" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://bradbodine.dev"><img src="https://avatars.githubusercontent.com/u/2924609?v=4?s=100" width="100px;" alt="Brad Bodine"/><br /><sub><b>Brad Bodine</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=bbodine1" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/kilesh-mhzn"><img src="https://avatars.githubusercontent.com/u/78723506?v=4?s=100" width="100px;" alt="Kilesh Maharjan"/><br /><sub><b>Kilesh Maharjan</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=kilesh-mhzn" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/redfox-mx"><img src="https://avatars.githubusercontent.com/u/20145660?v=4?s=100" width="100px;" alt="Diego Jesús"/><br /><sub><b>Diego Jesús</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=redfox-mx" title="Code">💻</a> <a href="#infra-redfox-mx" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/Rockerturner"><img src="https://avatars.githubusercontent.com/u/25847930?v=4?s=100" width="100px;" alt="Rockerturner"/><br /><sub><b>Rockerturner</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=Rockerturner" title="Code">💻</a></td>
      <td align="center" valign="top" width="14.28%"><a href="http://gillespie59.github.io/"><img src="https://avatars.githubusercontent.com/u/555768?v=4?s=100" width="100px;" alt="Emmanuel DEMEY"/><br /><sub><b>Emmanuel DEMEY</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=EmmanuelDemey" title="Documentation">📖</a></td>
      <td align="center" valign="top" width="14.28%"><a href="https://nickyt.co"><img src="https://avatars.githubusercontent.com/u/833231?v=4?s=100" width="100px;" alt="Nick Taylor"/><br /><sub><b>Nick Taylor</b></sub></a><br /><a href="https://github.com/analogjs/analog/commits?author=nickytonline" title="Code">💻</a></td>
    </tr>
    <tr>
      <td align="center" valign="top" width="14.28%"><a href="https://github.com/alexrosepizant"><img src="https://avatars.githubusercontent.com/u/7753376?v=4?s=100" width="100px;" alt="Alex Rose-Pizant"/><br /><sub><b>Alex Rose-Pizant</b></sub></a><br /><a href="#infra-alexrosepizant" title="Infrastructure (Hosting, Build-Tools, etc)">🚇</a></td>
    </tr>
  </tbody>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
