const words = new Set([
  "چس",
  "گوز",
  "ان",
  "لجن",
  "کثافت",
  "بی شرف",
  "بیشعور",
  "گوه",
  "کون",
  "کیری",
  "کسکش",
  "سگ پدر",
  "پدرسگ",
  "شاش",
  "ریدن",
  "ریدی",
  "دیوس",
  "انی",
  "گهی",
  "بی پدر",
  "مادرسگ",
  "جنده",
  "گایدی",
  "گایدن",
  "کیر",
  "عمتو",
  "خفه شو",
  "خفه",
  "خفه خون",
  "مرض داری",
  "مرضداری",
  "گردن دراز",
  "خری",
  "گاوی",
  "اسبی",
  "سگی",
  "حیوانی",
  "دهنتوببند",
  "انگل",
  "آشغال",
  "خرفت",
  "پپه",
  "خنگ",
  "دکل",
  "دله",
  "قرتی",
  "گوزو",
  "کونده",
  "کون ده",
  "گاگول",
  "ابله",
  "گنده گوز",
  "کس",
  "خارکیونی",
  "کله کاندومی",
  "گشاد",
  "دخترقرتی",
  "خواهرجنده",
  "مادرجنده",
  "لخت",
  "بخورش",
  "بپرسرش",
  "بپرروش",
  "بیابخورش",
  "میخوریش",
  "بمال",
  "دیوس خان",
  "زرنزن",
  "زنشو",
  "زنتو",
  "زن جنده",
  "بکنمت",
  "بکن",
  "بکن توش",
  "بکنش",
  "لز",
  "سکس",
  "سکسی",
  "ساک",
  "ساک بزن",
  "پورن",
  "سکسیی",
  "کونن",
  "کیرر",
  "بدبخت",
  "خایه",
  "خایه مال",
  "خایه خور",
  "ممه",
  "ممه خور",
  "دخترجنده",
  "کس ننت",
  "کیردوس",
  "مادرکونی",
  "خارکسده",
  "خارکس ده",
  "کیروکس",
  "کس و کیر",
  "زنا",
  "زنازاده",
  "ولدزنا",
  "ملنگ",
  "سادیسمی",
  "فاحشه",
  "خانم جنده",
  "فاحشه خانم",
  "سیکتیر",
  "سسکی",
  "کس خیس",
  "حشری",
  "گاییدن",
  "بکارت",
  "داف",
  "بچه کونی",
  "کسشعر",
  "سرکیر",
  "سوراخ کون",
  "حشری شدن",
  "کس کردن",
  "کس دادن",
  "بکن بکن",
  "شق کردن",
  "کس لیسیدن",
  "آب کیر",
  "جاکش",
  "جلق زدن",
  "جنده خانه",
  "شهوتی",
  "عن",
  "قس",
  "کردن",
  "کردنی",
  "کس کش",
  "کوس",
  "کیرمکیدن",
  "لاکونی",
  "پستان",
  "پستون",
  "آلت",
  "آلت تناسلی",
  "نرکده",
  "مالوندن",
  "سولاخ",
  "جنسی",
  "دوجنسه",
  "سگ تو روحت",
  "بی غیرت",
  "نعشه",
  "بی عفت",
  "مادرقهوه",
  "پلشت",
  "پریود",
  "کله کیری",
  "کیرناز",
  "پشمام",
  "لختی",
  "کسکیر",
  "دوست دختر",
  "دوست پسر",
  "کونشو",
  "دول",
  "شنگول",
  "کیردراز",
  "داف ناز",
  "سکسیم",
  "کوص",
  "ساکونی",
  "کون گنده",
  "سکسی باش",
  "کسخل",
  "کصخل",
  "کصکلک بازی",
  "صیغه ای",
  "گوش دراز",
  "درازگوش",
  "خز",
  "ماچ",
  "ماچ کردنی",
  "اسکل",
  "هیز",
  "بیناموس",
  "بی آبرو",
  "لاشی",
  "لاش گوشت",
  "باسن",
  "جکس",
  "سگ صفت",
  "کصکش",
  "مشروب",
  "عرق خور",
  "سکس چت",
  "جوون",
  "سرخور",
  "کلفت",
  "حشر",
  "لاس",
  "زارت",
  "رشتی",
  "ترک",
  "فارس",
  "لر",
  "عرب",
  "خر",
  "گاو",
  "اسب",
  "گوسفند",
  "کرم",
  "الاق",
  "الاغ",
  "احمق",
  "بی شعور",
  "حرومزاده",
  "کونی",
  "گه",
  "مادر جنده",
  "کث",
  "کص",
  "پسون",
  "خارکسّه",
  "دهن گاییده",
  "دهن سرویس",
  "پدر سگ",
  "پدر سوخته",
  "پدر صلواتی",
  "لامصب",
  "زنیکه",
  "مرتیکه",
  "مردیکه",
  "بی خایه",
  "عوضی",
  "اسگل",
  "اوسکل",
  "اوسگل",
  "اوصگل",
  "اوصکل",
  "دیوث",
  "دیوص",
  "قرمصاق",
  "قرمساق",
  "غرمساق",
  "غرمصاق",
  "فیلم سوپر",
  "چاقال",
  "چاغال",
  "چس خور",
  "کس خور",
  "کس خل",
  "کوس خور",
  "کوس خل",
  "کص لیس",
  "کث لیس",
  "کس لیس",
  "کوص لیس",
  "کوث لیس",
  "کوس لیس",
  "اوبی",
  "خارکونی",
  "کونی مقام",
  "شاش خالی",
  "دلقک",
  "عن دونی",
  "خار سولاخی",
  "سولاخ مادر",
  "عمه ننه",
  "خارتو",
  "بو زنا",
  "شاش بند",
  "کیونی",
  "کصپدر",
  "شغال",
  "خپل",
  "ساکر",
  "زن قوه",
  "پشم کون",
  "جنده پولی",
  "حرومی",
  "دودول طلا",
  "چوسو",
  "هزار پدر",
  "بی فانوس",
  "پرده زن",
  "آبم اومد",
  "چس خوری",
  "زاخار",
  "گی مادر",
  "ظنا",
  "بی پدرو مادر",
  "کیرم دهنت",
  "بکیرم",
  "به تخم اقام",
  "کیر خر",
  "ننه مرده",
  "سلیطه",
  "لاشخور",
  "هرزه",
  "حروم‌لقمه",
  "پاچه‌خوار",
  "ارگاسم",
  "دول ننه",
  "مادر فاکر",
  "کصپولی",
  "ننه هزار کیر",
  "قرمدنگ",
  "توله سگ",
  "جفنگ",
  "ریدم",
  "شومبول",
  "دهنتو گاییدم",
  "چسو",
  "بی عرضه",
  "بی مصرف",
  "بدطینت",
  "خبیث",
  "زالو",
  "مغز پریودی",
  "کسپولی",
  "ناکس",
  "مفت‌خور",
  "چرب کنش",
  "اوب",
  "فرو کن",
  "بچه کیونی",
]);

const PersianSwear = {
  isBad: (text) => words.has(text),
  hasSwear: (text) => text.split(" ").some((word) => words.has(word)),
  filterWords: (text, symbol = "*") => {
    return text
      .split(" ")
      .map((word) => (words.has(word) ? symbol.repeat(word.length) : word))
      .join(" ");
  },
};

export default PersianSwear;
