<?php
/**
 * Contains \jamesiarmes\PhpEws\ClassMap.
 *
 * This class is generated using the build-classmap.php script. To make changes
 * to this file should be made there or in the ClassMap.mustache template.
 *
 * Last updated on: 2018-11-30 04:32:49 UTC
 */

namespace jamesiarmes\PhpEws;

/**
 * Mapping of complex types to class implementations.
 *
 * @package php-ews\ClassMap
 */
class ClassMap
{
    /**
     * Returns the PHP EWS class map to be used for processing SOAP calls.
     *
     * @return string[]
     *
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    public function getMap()
    {
        return array(
            // Map for ArrayType classes.
            'ArrayOfExtendedPropertyAttributedValueType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfExtendedPropertyAttributedValueType',
            'ArrayOfPeopleQuerySource' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPeopleQuerySource',
            'NonEmptyArrayOfItemChangesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfItemChangesType',
            'NonEmptyArrayOfUploadItemsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfUploadItemsType',
            'ArrayOfBinaryType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfBinaryType',
            'ArrayOfMailboxData' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfMailboxData',
            'NonEmptyArrayOfBaseFolderIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfBaseFolderIdsType',
            'ArrayOfTrackingPropertiesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfTrackingPropertiesType',
            'ArrayOfDiscoverySearchConfigurationType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfDiscoverySearchConfigurationType',
            'ArrayOfMailTipsResponseMessageType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfMailTipsResponseMessageType',
            'ArrayOfMailboxHoldStatusType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfMailboxHoldStatusType',
            'NonEmptyArrayOfAllItemsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfAllItemsType',
            'NonEmptyArrayOfFolderChangesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfFolderChangesType',
            'ArrayOfSuggestion' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSuggestion',
            'ArrayOfSmtpAddressType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSmtpAddressType',
            'NonEmptyArrayOfPathsToElementType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfPathsToElementType',
            'ArrayOfRuleOperationErrorsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRuleOperationErrorsType',
            'NonEmptyArrayOfPropertyValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfPropertyValuesType',
            'NonEmptyArrayOfNotificationsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfNotificationsType',
            'ArrayOfStringsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfStringsType',
            'NonEmptyArrayOfSubscriptionIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfSubscriptionIdsType',
            'ArrayOfFolderIdType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfFolderIdType',
            'ArrayOfRecipientsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRecipientsType',
            'ArrayOfNonIndexableItemDetailsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfNonIndexableItemDetailsType',
            'NonEmptyArrayOfAttendeesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfAttendeesType',
            'ArrayOfGroupedItemsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfGroupedItemsType',
            'ArrayOfPrivateCatalogAddInsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPrivateCatalogAddInsType',
            'NonEmptyArrayOfPeriodsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfPeriodsType',
            'ArrayOfKeywordStatisticsSearchResultsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfKeywordStatisticsSearchResultsType',
            'ArrayOfExtendedAttributesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfExtendedAttributesType',
            'ArrayOfTransitionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfTransitionsType',
            'NonEmptyArrayOfDeletedOccurrencesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfDeletedOccurrencesType',
            'NonEmptyArrayofLegacyDNsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayofLegacyDNsType',
            'ArrayOfFoldersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfFoldersType',
            'ArrayOfArraysOfTrackingPropertiesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfArraysOfTrackingPropertiesType',
            'ArrayOfAppsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfAppsType',
            'ArrayOfRuleValidationErrorsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRuleValidationErrorsType',
            'NonEmptyArrayOfItemIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfItemIdsType',
            'ArrayOfBaseItemIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfBaseItemIdsType',
            'ArrayOfAttendeeConflictData' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfAttendeeConflictData',
            'ArrayOfTransitionsGroupsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfTransitionsGroupsType',
            'NonEmptyArrayOfItemChangeDescriptionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfItemChangeDescriptionsType',
            'ArrayOfValueAttributionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfValueAttributionsType',
            'NonEmptyArrayOfFolderChangeDescriptionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfFolderChangeDescriptionsType',
            'NonEmptyArrayOfNotificationEventTypesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfNotificationEventTypesType',
            'ArrayOfItemClassType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfItemClassType',
            'ArrayOfStringArrayAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfStringArrayAttributedValuesType',
            'NonEmptyArrayOfExtendedFieldURIs' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfExtendedFieldURIs',
            'NonEmptyArrayOfBaseItemIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfBaseItemIdsType',
            'ArrayOfImGroupType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfImGroupType',
            'ArrayOfEmailAddressesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfEmailAddressesType',
            'ArrayOfRetentionPolicyTagsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRetentionPolicyTagsType',
            'ArrayOfRecipientTrackingEventType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRecipientTrackingEventType',
            'NonEmptyArrayOfMailboxQueriesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfMailboxQueriesType',
            'NonEmptyArrayOfMailboxSearchScopesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfMailboxSearchScopesType',
            'ArrayOfUnknownEntriesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfUnknownEntriesType',
            'ArrayOfInvalidRecipientsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfInvalidRecipientsType',
            'NonEmptyArrayOfRequestAttachmentIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfRequestAttachmentIdsType',
            'ArrayOfStringAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfStringAttributedValuesType',
            'ArrayOfOccurrenceRangesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfOccurrenceRangesType',
            'ArrayOfTimeZoneDefinitionType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfTimeZoneDefinitionType',
            'ArrayOfBodyContentAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfBodyContentAttributedValuesType',
            'NonEmptyArrayOfFieldOrdersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfFieldOrdersType',
            'ArrayOfUserIdType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfUserIdType',
            'NonEmptyArrayOfClientAccessTokenRequestsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfClientAccessTokenRequestsType',
            'NonEmptyArrayOfExtendedPropertyType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfExtendedPropertyType',
            'ArrayOfAppManifestsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfAppManifestsType',
            'ArrayOfServiceConfigurationType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfServiceConfigurationType',
            'ArrayOfPhoneNumberAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPhoneNumberAttributedValuesType',
            'ArrayOfRemindersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRemindersType',
            'ArrayOfCalendarEvent' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfCalendarEvent',
            'NonEmptyArrayOfFolderNamesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfFolderNamesType',
            'ArrayOfSuggestionDayResult' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSuggestionDayResult',
            'ArrayOfRulesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRulesType',
            'ArrayOfRoomsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRoomsType',
            'NonEmptyArrayOfReminderItemActionType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfReminderItemActionType',
            'ArrayOfFailedSearchMailboxesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfFailedSearchMailboxesType',
            'ArrayOfContextProperty' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfContextProperty',
            'ArrayOfSearchItemKindsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSearchItemKindsType',
            'ArrayOfFreeBusyResponse' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfFreeBusyResponse',
            'NonEmptyArrayOfResponseObjectsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfResponseObjectsType',
            'ArrayOfSearchableMailboxesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSearchableMailboxesType',
            'ArrayOfResolutionType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfResolutionType',
            'NonEmptyArrayOfGroupIdentifiersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfGroupIdentifiersType',
            'NonEmptyArrayOfInternetHeadersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfInternetHeadersType',
            'ArrayOfDelegateUserResponseMessageType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfDelegateUserResponseMessageType',
            'NonEmptyArrayOfFoldersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfFoldersType',
            'ArrayOfProtectionRulesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfProtectionRulesType',
            'ArrayOfResponseMessagesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfResponseMessagesType',
            'NonEmptyArrayOfApplyConversationActionType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfApplyConversationActionType',
            'ArrayOfUserMailboxesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfUserMailboxesType',
            'ArrayOfCalendarPermissionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfCalendarPermissionsType',
            'ArrayOfEmailAddressAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfEmailAddressAttributedValuesType',
            'ArrayOfRuleOperationsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRuleOperationsType',
            'ArrayOfAttachmentsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfAttachmentsType',
            'NonEmptyArrayOfAttachmentsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfAttachmentsType',
            'ArrayOfEncryptedSharedFolderDataType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfEncryptedSharedFolderDataType',
            'ArrayOfRealItemsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfRealItemsType',
            'ArrayOfConversationsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfConversationsType',
            'ArrayOfPeopleType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPeopleType',
            'NonEmptyArrayOfTimeZoneIdType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfTimeZoneIdType',
            'ArrayOfConversationNodesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfConversationNodesType',
            'ArrayOfPermissionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPermissionsType',
            'NonEmptyArrayOfOccurrenceInfoType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfOccurrenceInfoType',
            'ArrayOfServiceConfigurationResponseMessageType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfServiceConfigurationResponseMessageType',
            'ArrayOfPersonaAttributionsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPersonaAttributionsType',
            'ArrayOfFindMessageTrackingSearchResultType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfFindMessageTrackingSearchResultType',
            'ArrayOfPostalAddressAttributedValuesType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfPostalAddressAttributedValuesType',
            'NonEmptyArrayOfAlternateIdsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfAlternateIdsType',
            'ArrayOfNonIndexableItemStatisticsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfNonIndexableItemStatisticsType',
            'ArrayOfWorkingPeriod' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfWorkingPeriod',
            'ArrayOfDLExpansionType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfDLExpansionType',
            'ArrayOfSearchPreviewItemsType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfSearchPreviewItemsType',
            'ArrayOfDelegateUserType' => '\\jamesiarmes\\PhpEws\\ArrayType\\ArrayOfDelegateUserType',
            'NonEmptyArrayOfRestrictedGroupIdentifiersType' => '\\jamesiarmes\\PhpEws\\ArrayType\\NonEmptyArrayOfRestrictedGroupIdentifiersType',
            // Map for Request classes.
            'BaseMoveCopyItemType' => '\\jamesiarmes\\PhpEws\\Request\\BaseMoveCopyItemType',
            'SetUserOofSettingsRequest' => '\\jamesiarmes\\PhpEws\\Request\\SetUserOofSettingsRequest',
            'PerformReminderActionType' => '\\jamesiarmes\\PhpEws\\Request\\PerformReminderActionType',
            'DeleteUserConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\DeleteUserConfigurationType',
            'GetServiceConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\GetServiceConfigurationType',
            'GetServerTimeZonesType' => '\\jamesiarmes\\PhpEws\\Request\\GetServerTimeZonesType',
            'GetImItemsType' => '\\jamesiarmes\\PhpEws\\Request\\GetImItemsType',
            'AddImGroupType' => '\\jamesiarmes\\PhpEws\\Request\\AddImGroupType',
            'CreateFolderType' => '\\jamesiarmes\\PhpEws\\Request\\CreateFolderType',
            'UpdateUserConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\UpdateUserConfigurationType',
            'GetUserAvailabilityRequestType' => '\\jamesiarmes\\PhpEws\\Request\\GetUserAvailabilityRequestType',
            'GetUserConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\GetUserConfigurationType',
            'CopyFolderType' => '\\jamesiarmes\\PhpEws\\Request\\CopyFolderType',
            'GetSharingMetadataType' => '\\jamesiarmes\\PhpEws\\Request\\GetSharingMetadataType',
            'GetSearchableMailboxesType' => '\\jamesiarmes\\PhpEws\\Request\\GetSearchableMailboxesType',
            'RemoveDelegateType' => '\\jamesiarmes\\PhpEws\\Request\\RemoveDelegateType',
            'SyncFolderItemsType' => '\\jamesiarmes\\PhpEws\\Request\\SyncFolderItemsType',
            'AddImContactToGroup' => '\\jamesiarmes\\PhpEws\\Request\\AddImContactToGroup',
            'AddDistributionGroupToImListType' => '\\jamesiarmes\\PhpEws\\Request\\AddDistributionGroupToImListType',
            'BaseMoveCopyFolderType' => '\\jamesiarmes\\PhpEws\\Request\\BaseMoveCopyFolderType',
            'GetUserPhotoType' => '\\jamesiarmes\\PhpEws\\Request\\GetUserPhotoType',
            'ExpandDLType' => '\\jamesiarmes\\PhpEws\\Request\\ExpandDLType',
            'GetPersonaType' => '\\jamesiarmes\\PhpEws\\Request\\GetPersonaType',
            'GetNonIndexableItemDetailsType' => '\\jamesiarmes\\PhpEws\\Request\\GetNonIndexableItemDetailsType',
            'SyncFolderHierarchyType' => '\\jamesiarmes\\PhpEws\\Request\\SyncFolderHierarchyType',
            'UploadItemsType' => '\\jamesiarmes\\PhpEws\\Request\\UploadItemsType',
            'MarkAllItemsAsRead' => '\\jamesiarmes\\PhpEws\\Request\\MarkAllItemsAsRead',
            'GetClientAccessTokenType' => '\\jamesiarmes\\PhpEws\\Request\\GetClientAccessTokenType',
            'SendItemType' => '\\jamesiarmes\\PhpEws\\Request\\SendItemType',
            'GetPasswordExpirationDateType' => '\\jamesiarmes\\PhpEws\\Request\\GetPasswordExpirationDateType',
            'AddNewTelUriContactToGroupType' => '\\jamesiarmes\\PhpEws\\Request\\AddNewTelUriContactToGroupType',
            'UpdateDelegateType' => '\\jamesiarmes\\PhpEws\\Request\\UpdateDelegateType',
            'GetEventsType' => '\\jamesiarmes\\PhpEws\\Request\\GetEventsType',
            'FindMessageTrackingReportRequestType' => '\\jamesiarmes\\PhpEws\\Request\\FindMessageTrackingReportRequestType',
            'GetImItemListType' => '\\jamesiarmes\\PhpEws\\Request\\GetImItemListType',
            'GetSharingFolderType' => '\\jamesiarmes\\PhpEws\\Request\\GetSharingFolderType',
            'SubscribeType' => '\\jamesiarmes\\PhpEws\\Request\\SubscribeType',
            'FindConversationType' => '\\jamesiarmes\\PhpEws\\Request\\FindConversationType',
            'UpdateFolderType' => '\\jamesiarmes\\PhpEws\\Request\\UpdateFolderType',
            'AddDelegateType' => '\\jamesiarmes\\PhpEws\\Request\\AddDelegateType',
            'UninstallAppType' => '\\jamesiarmes\\PhpEws\\Request\\UninstallAppType',
            'GetStreamingEventsType' => '\\jamesiarmes\\PhpEws\\Request\\GetStreamingEventsType',
            'GetInboxRulesRequestType' => '\\jamesiarmes\\PhpEws\\Request\\GetInboxRulesRequestType',
            'DeleteFolderType' => '\\jamesiarmes\\PhpEws\\Request\\DeleteFolderType',
            'CreateManagedFolderRequestType' => '\\jamesiarmes\\PhpEws\\Request\\CreateManagedFolderRequestType',
            'GetUserOofSettingsRequest' => '\\jamesiarmes\\PhpEws\\Request\\GetUserOofSettingsRequest',
            'CreateUserConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\CreateUserConfigurationType',
            'EmptyFolderType' => '\\jamesiarmes\\PhpEws\\Request\\EmptyFolderType',
            'BaseRequestType' => '\\jamesiarmes\\PhpEws\\Request\\BaseRequestType',
            'UnsubscribeType' => '\\jamesiarmes\\PhpEws\\Request\\UnsubscribeType',
            'RemoveContactFromImListType' => '\\jamesiarmes\\PhpEws\\Request\\RemoveContactFromImListType',
            'RefreshSharingFolderType' => '\\jamesiarmes\\PhpEws\\Request\\RefreshSharingFolderType',
            'FindPeopleType' => '\\jamesiarmes\\PhpEws\\Request\\FindPeopleType',
            'GetDelegateType' => '\\jamesiarmes\\PhpEws\\Request\\GetDelegateType',
            'MoveItemType' => '\\jamesiarmes\\PhpEws\\Request\\MoveItemType',
            'GetFolderType' => '\\jamesiarmes\\PhpEws\\Request\\GetFolderType',
            'GetRoomListsType' => '\\jamesiarmes\\PhpEws\\Request\\GetRoomListsType',
            'DeleteAttachmentType' => '\\jamesiarmes\\PhpEws\\Request\\DeleteAttachmentType',
            'GetRoomsType' => '\\jamesiarmes\\PhpEws\\Request\\GetRoomsType',
            'ApplyConversationActionType' => '\\jamesiarmes\\PhpEws\\Request\\ApplyConversationActionType',
            'RemoveDistributionGroupFromImListType' => '\\jamesiarmes\\PhpEws\\Request\\RemoveDistributionGroupFromImListType',
            'SetImGroupType' => '\\jamesiarmes\\PhpEws\\Request\\SetImGroupType',
            'GetRemindersType' => '\\jamesiarmes\\PhpEws\\Request\\GetRemindersType',
            'CreateAttachmentType' => '\\jamesiarmes\\PhpEws\\Request\\CreateAttachmentType',
            'BaseDelegateType' => '\\jamesiarmes\\PhpEws\\Request\\BaseDelegateType',
            'MarkAsJunkType' => '\\jamesiarmes\\PhpEws\\Request\\MarkAsJunkType',
            'FindItemType' => '\\jamesiarmes\\PhpEws\\Request\\FindItemType',
            'GetConversationItemsType' => '\\jamesiarmes\\PhpEws\\Request\\GetConversationItemsType',
            'ResolveNamesType' => '\\jamesiarmes\\PhpEws\\Request\\ResolveNamesType',
            'ArchiveItemType' => '\\jamesiarmes\\PhpEws\\Request\\ArchiveItemType',
            'RemoveImContactFromGroupType' => '\\jamesiarmes\\PhpEws\\Request\\RemoveImContactFromGroupType',
            'GetDiscoverySearchConfigurationType' => '\\jamesiarmes\\PhpEws\\Request\\GetDiscoverySearchConfigurationType',
            'GetMessageTrackingReportRequestType' => '\\jamesiarmes\\PhpEws\\Request\\GetMessageTrackingReportRequestType',
            'GetItemType' => '\\jamesiarmes\\PhpEws\\Request\\GetItemType',
            'GetAttachmentType' => '\\jamesiarmes\\PhpEws\\Request\\GetAttachmentType',
            'FindMailboxStatisticsByKeywordsType' => '\\jamesiarmes\\PhpEws\\Request\\FindMailboxStatisticsByKeywordsType',
            'UpdateItemType' => '\\jamesiarmes\\PhpEws\\Request\\UpdateItemType',
            'DisableAppType' => '\\jamesiarmes\\PhpEws\\Request\\DisableAppType',
            'RemoveImGroupType' => '\\jamesiarmes\\PhpEws\\Request\\RemoveImGroupType',
            'FindFolderType' => '\\jamesiarmes\\PhpEws\\Request\\FindFolderType',
            'ConvertIdType' => '\\jamesiarmes\\PhpEws\\Request\\ConvertIdType',
            'GetAppMarketplaceUrl' => '\\jamesiarmes\\PhpEws\\Request\\GetAppMarketplaceUrl',
            'GetMailTipsType' => '\\jamesiarmes\\PhpEws\\Request\\GetMailTipsType',
            'AddNewImContactToGroup' => '\\jamesiarmes\\PhpEws\\Request\\AddNewImContactToGroup',
            'GetAppManifestsType' => '\\jamesiarmes\\PhpEws\\Request\\GetAppManifestsType',
            'GetHoldOnMailboxesType' => '\\jamesiarmes\\PhpEws\\Request\\GetHoldOnMailboxesType',
            'CreateItemType' => '\\jamesiarmes\\PhpEws\\Request\\CreateItemType',
            'MoveFolderType' => '\\jamesiarmes\\PhpEws\\Request\\MoveFolderType',
            'InstallAppType' => '\\jamesiarmes\\PhpEws\\Request\\InstallAppType',
            'SetHoldOnMailboxesType' => '\\jamesiarmes\\PhpEws\\Request\\SetHoldOnMailboxesType',
            'SearchMailboxesType' => '\\jamesiarmes\\PhpEws\\Request\\SearchMailboxesType',
            'UpdateInboxRulesRequestType' => '\\jamesiarmes\\PhpEws\\Request\\UpdateInboxRulesRequestType',
            'GetUserRetentionPolicyTagsType' => '\\jamesiarmes\\PhpEws\\Request\\GetUserRetentionPolicyTagsType',
            'DisconnectPhoneCallType' => '\\jamesiarmes\\PhpEws\\Request\\DisconnectPhoneCallType',
            'DeleteItemType' => '\\jamesiarmes\\PhpEws\\Request\\DeleteItemType',
            'PlayOnPhoneType' => '\\jamesiarmes\\PhpEws\\Request\\PlayOnPhoneType',
            'ExportItemsType' => '\\jamesiarmes\\PhpEws\\Request\\ExportItemsType',
            'CopyItemType' => '\\jamesiarmes\\PhpEws\\Request\\CopyItemType',
            'CreateFolderPathType' => '\\jamesiarmes\\PhpEws\\Request\\CreateFolderPathType',
            'GetNonIndexableItemStatisticsType' => '\\jamesiarmes\\PhpEws\\Request\\GetNonIndexableItemStatisticsType',
            'GetPhoneCallInformationType' => '\\jamesiarmes\\PhpEws\\Request\\GetPhoneCallInformationType',
            // Map for Response classes.
            'ArchiveItemResponse' => '\\jamesiarmes\\PhpEws\\Response\\ArchiveItemResponse',
            'ResolveNamesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ResolveNamesResponseMessageType',
            'GetMailTipsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetMailTipsResponseMessageType',
            'SetHoldOnMailboxesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SetHoldOnMailboxesResponseMessageType',
            'ApplyConversationActionResponseType' => '\\jamesiarmes\\PhpEws\\Response\\ApplyConversationActionResponseType',
            'ConvertIdResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ConvertIdResponseMessageType',
            'GetConversationItemsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetConversationItemsResponseType',
            'SubscribeResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SubscribeResponseType',
            'SyncFolderHierarchyResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SyncFolderHierarchyResponseType',
            'GetUserPhotoResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserPhotoResponseType',
            'RemoveContactFromImListResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RemoveContactFromImListResponseMessageType',
            'CreateUserConfigurationResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateUserConfigurationResponseType',
            'CopyFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CopyFolderResponseType',
            'FolderInfoResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FolderInfoResponseMessageType',
            'UpdateDelegateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateDelegateResponseMessageType',
            'CopyItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CopyItemResponseType',
            'SearchMailboxesResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SearchMailboxesResponseType',
            'ExportItemsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ExportItemsResponseMessageType',
            'GetNonIndexableItemStatisticsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetNonIndexableItemStatisticsResponseMessageType',
            'FindMailboxStatisticsByKeywordsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindMailboxStatisticsByKeywordsResponseMessageType',
            'GetPersonaResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetPersonaResponseMessageType',
            'AttachmentInfoResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AttachmentInfoResponseMessageType',
            'GetInboxRulesResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetInboxRulesResponseType',
            'SetImGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SetImGroupResponseMessageType',
            'RemoveDelegateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RemoveDelegateResponseMessageType',
            'UpdateUserConfigurationResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateUserConfigurationResponseType',
            'GetServiceConfigurationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetServiceConfigurationResponseMessageType',
            'FindFolderResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindFolderResponseMessageType',
            'AddDelegateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AddDelegateResponseMessageType',
            'AddNewImContactToGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AddNewImContactToGroupResponseMessageType',
            'GetImItemListResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetImItemListResponseMessageType',
            'CreateFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateFolderResponseType',
            'GetConversationItemsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetConversationItemsResponseMessageType',
            'RefreshSharingFolderResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RefreshSharingFolderResponseMessageType',
            'SearchMailboxesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SearchMailboxesResponseMessageType',
            'GetStreamingEventsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetStreamingEventsResponseType',
            'GetAppMarketplaceUrlResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetAppMarketplaceUrlResponseMessageType',
            'RemoveImGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RemoveImGroupResponseMessageType',
            'BaseDelegateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\BaseDelegateResponseMessageType',
            'MoveItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\MoveItemResponseType',
            'GetUserAvailabilityResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserAvailabilityResponseType',
            'GetHoldOnMailboxesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetHoldOnMailboxesResponseMessageType',
            'FindItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\FindItemResponseType',
            'FindMessageTrackingReportResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindMessageTrackingReportResponseMessageType',
            'UpdateItemResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateItemResponseMessageType',
            'GetUserPhotoResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserPhotoResponseMessageType',
            'GetRoomListsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetRoomListsResponseMessageType',
            'GetUserRetentionPolicyTagsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserRetentionPolicyTagsResponseMessageType',
            'SetUserOofSettingsResponse' => '\\jamesiarmes\\PhpEws\\Response\\SetUserOofSettingsResponse',
            'SendNotificationResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SendNotificationResponseType',
            'FindConversationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindConversationResponseMessageType',
            'SendNotificationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SendNotificationResponseMessageType',
            'GetImItemsResponse' => '\\jamesiarmes\\PhpEws\\Response\\GetImItemsResponse',
            'SendItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SendItemResponseType',
            'GetRemindersResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetRemindersResponseMessageType',
            'GetFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetFolderResponseType',
            'AddNewTelUriContactToGroupResponse' => '\\jamesiarmes\\PhpEws\\Response\\AddNewTelUriContactToGroupResponse',
            'GetNonIndexableItemDetailsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetNonIndexableItemDetailsResponseMessageType',
            'SyncFolderHierarchyResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SyncFolderHierarchyResponseMessageType',
            'GetSharingMetadataResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetSharingMetadataResponseMessageType',
            'GetAppManifestsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetAppManifestsResponseType',
            'ExportItemsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\ExportItemsResponseType',
            'AddDistributionGroupToImListResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AddDistributionGroupToImListResponseMessageType',
            'PerformReminderActionResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\PerformReminderActionResponseMessageType',
            'ApplyConversationActionResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ApplyConversationActionResponseMessageType',
            'GetItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetItemResponseType',
            'GetStreamingEventsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetStreamingEventsResponseMessageType',
            'UpdateFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateFolderResponseType',
            'AddImGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AddImGroupResponseMessageType',
            'ConvertIdResponseType' => '\\jamesiarmes\\PhpEws\\Response\\ConvertIdResponseType',
            'AddImContactToGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\AddImContactToGroupResponseMessageType',
            'DisconnectPhoneCallResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\DisconnectPhoneCallResponseMessageType',
            'GetDiscoverySearchConfigurationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetDiscoverySearchConfigurationResponseMessageType',
            'FindFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\FindFolderResponseType',
            'GetClientAccessTokenResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetClientAccessTokenResponseType',
            'MarkAsJunkResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\MarkAsJunkResponseMessageType',
            'MarkAllItemsAsReadResponseType' => '\\jamesiarmes\\PhpEws\\Response\\MarkAllItemsAsReadResponseType',
            'DeleteAttachmentResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\DeleteAttachmentResponseMessageType',
            'RemoveDistributionGroupFromImListResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RemoveDistributionGroupFromImListResponseMessageType',
            'GetUserConfigurationResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserConfigurationResponseType',
            'CreateFolderPathResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateFolderPathResponseType',
            'DeleteFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\DeleteFolderResponseType',
            'ResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ResponseMessageType',
            'GetSearchableMailboxesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetSearchableMailboxesResponseMessageType',
            'ExpandDLResponseType' => '\\jamesiarmes\\PhpEws\\Response\\ExpandDLResponseType',
            'DeleteItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\DeleteItemResponseType',
            'GetServerTimeZonesResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetServerTimeZonesResponseType',
            'CreateManagedFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateManagedFolderResponseType',
            'PlayOnPhoneResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\PlayOnPhoneResponseMessageType',
            'GetRoomsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetRoomsResponseMessageType',
            'GetUserConfigurationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetUserConfigurationResponseMessageType',
            'InstallAppResponseType' => '\\jamesiarmes\\PhpEws\\Response\\InstallAppResponseType',
            'GetDelegateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetDelegateResponseMessageType',
            'GetAttachmentResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetAttachmentResponseType',
            'CreateItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateItemResponseType',
            'DeleteUserConfigurationResponseType' => '\\jamesiarmes\\PhpEws\\Response\\DeleteUserConfigurationResponseType',
            'GetServerTimeZonesResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetServerTimeZonesResponseMessageType',
            'GetSharingFolderResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetSharingFolderResponseMessageType',
            'FindMailboxStatisticsByKeywordsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\FindMailboxStatisticsByKeywordsResponseType',
            'GetMessageTrackingReportResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetMessageTrackingReportResponseMessageType',
            'EmptyFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\EmptyFolderResponseType',
            'CreateAttachmentResponseType' => '\\jamesiarmes\\PhpEws\\Response\\CreateAttachmentResponseType',
            'SyncFolderItemsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SyncFolderItemsResponseMessageType',
            'DeleteAttachmentResponseType' => '\\jamesiarmes\\PhpEws\\Response\\DeleteAttachmentResponseType',
            'GetClientAccessTokenResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetClientAccessTokenResponseMessageType',
            'GetEventsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\GetEventsResponseType',
            'UnsubscribeResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UnsubscribeResponseType',
            'MailTipsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\MailTipsResponseMessageType',
            'GetEventsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetEventsResponseMessageType',
            'MoveFolderResponseType' => '\\jamesiarmes\\PhpEws\\Response\\MoveFolderResponseType',
            'UninstallAppResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UninstallAppResponseType',
            'ExpandDLResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ExpandDLResponseMessageType',
            'ItemInfoResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ItemInfoResponseMessageType',
            'ServiceConfigurationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\ServiceConfigurationResponseMessageType',
            'FindItemResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindItemResponseMessageType',
            'UploadItemsResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\UploadItemsResponseMessageType',
            'SubscribeResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\SubscribeResponseMessageType',
            'UploadItemsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UploadItemsResponseType',
            'MarkAsJunkResponseType' => '\\jamesiarmes\\PhpEws\\Response\\MarkAsJunkResponseType',
            'GetPhoneCallInformationResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetPhoneCallInformationResponseMessageType',
            'DisableAppResponseType' => '\\jamesiarmes\\PhpEws\\Response\\DisableAppResponseType',
            'GetUserOofSettingsResponse' => '\\jamesiarmes\\PhpEws\\Response\\GetUserOofSettingsResponse',
            'UpdateItemResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateItemResponseType',
            'RemoveImContactFromGroupResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\RemoveImContactFromGroupResponseMessageType',
            'ResolveNamesResponseType' => '\\jamesiarmes\\PhpEws\\Response\\ResolveNamesResponseType',
            'UpdateInboxRulesResponseType' => '\\jamesiarmes\\PhpEws\\Response\\UpdateInboxRulesResponseType',
            'DelegateUserResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\DelegateUserResponseMessageType',
            'FindPeopleResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\FindPeopleResponseMessageType',
            'SyncFolderItemsResponseType' => '\\jamesiarmes\\PhpEws\\Response\\SyncFolderItemsResponseType',
            'GetPasswordExpirationDateResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\GetPasswordExpirationDateResponseMessageType',
            'BaseResponseMessageType' => '\\jamesiarmes\\PhpEws\\Response\\BaseResponseMessageType',
            // Map for Type classes.
            'AppendToItemFieldType' => '\\jamesiarmes\\PhpEws\\Type\\AppendToItemFieldType',
            'UnifiedMessageServiceConfiguration' => '\\jamesiarmes\\PhpEws\\Type\\UnifiedMessageServiceConfiguration',
            'ModifiedEventType' => '\\jamesiarmes\\PhpEws\\Type\\ModifiedEventType',
            'SingleRecipientType' => '\\jamesiarmes\\PhpEws\\Type\\SingleRecipientType',
            'MimeContentType' => '\\jamesiarmes\\PhpEws\\Type\\MimeContentType',
            'DistinguishedGroupByType' => '\\jamesiarmes\\PhpEws\\Type\\DistinguishedGroupByType',
            'TentativelyAcceptItemType' => '\\jamesiarmes\\PhpEws\\Type\\TentativelyAcceptItemType',
            'ItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\ItemIdType',
            'DiscoverySearchConfigurationType' => '\\jamesiarmes\\PhpEws\\Type\\DiscoverySearchConfigurationType',
            'GroupedItemsType' => '\\jamesiarmes\\PhpEws\\Type\\GroupedItemsType',
            'BaseGroupByType' => '\\jamesiarmes\\PhpEws\\Type\\BaseGroupByType',
            'CompleteNameType' => '\\jamesiarmes\\PhpEws\\Type\\CompleteNameType',
            'SmartResponseType' => '\\jamesiarmes\\PhpEws\\Type\\SmartResponseType',
            'SearchParametersType' => '\\jamesiarmes\\PhpEws\\Type\\SearchParametersType',
            'OutOfOfficeMailTip' => '\\jamesiarmes\\PhpEws\\Type\\OutOfOfficeMailTip',
            'AlternateIdType' => '\\jamesiarmes\\PhpEws\\Type\\AlternateIdType',
            'WeeklyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\WeeklyRecurrencePatternType',
            'MeetingRequestMessageType' => '\\jamesiarmes\\PhpEws\\Type\\MeetingRequestMessageType',
            'MailTipsServiceConfiguration' => '\\jamesiarmes\\PhpEws\\Type\\MailTipsServiceConfiguration',
            'ProtectionRuleAndType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleAndType',
            'BaseItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\BaseItemIdType',
            'TaskType' => '\\jamesiarmes\\PhpEws\\Type\\TaskType',
            'SearchPreviewItemType' => '\\jamesiarmes\\PhpEws\\Type\\SearchPreviewItemType',
            'BaseEmailAddressType' => '\\jamesiarmes\\PhpEws\\Type\\BaseEmailAddressType',
            'PhoneCallInformationType' => '\\jamesiarmes\\PhpEws\\Type\\PhoneCallInformationType',
            'RuleOperationType' => '\\jamesiarmes\\PhpEws\\Type\\RuleOperationType',
            'WellKnownResponseObjectType' => '\\jamesiarmes\\PhpEws\\Type\\WellKnownResponseObjectType',
            'AlternatePublicFolderIdType' => '\\jamesiarmes\\PhpEws\\Type\\AlternatePublicFolderIdType',
            'WorkingPeriod' => '\\jamesiarmes\\PhpEws\\Type\\WorkingPeriod',
            'DirectoryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\DirectoryEntryType',
            'MemberType' => '\\jamesiarmes\\PhpEws\\Type\\MemberType',
            'TimeChangeType' => '\\jamesiarmes\\PhpEws\\Type\\TimeChangeType',
            'OccurrencesRangeType' => '\\jamesiarmes\\PhpEws\\Type\\OccurrencesRangeType',
            'SyncFolderItemsChangesType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderItemsChangesType',
            'OpenAsAdminOrSystemServiceType' => '\\jamesiarmes\\PhpEws\\Type\\OpenAsAdminOrSystemServiceType',
            'ContactItemType' => '\\jamesiarmes\\PhpEws\\Type\\ContactItemType',
            'ResponseObjectCoreType' => '\\jamesiarmes\\PhpEws\\Type\\ResponseObjectCoreType',
            'MeetingResponseMessageType' => '\\jamesiarmes\\PhpEws\\Type\\MeetingResponseMessageType',
            'SuggestionsViewOptionsType' => '\\jamesiarmes\\PhpEws\\Type\\SuggestionsViewOptionsType',
            'ConnectingSIDType' => '\\jamesiarmes\\PhpEws\\Type\\ConnectingSIDType',
            'SyncFolderHierarchyChangesType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderHierarchyChangesType',
            'SerializableTimeZoneTime' => '\\jamesiarmes\\PhpEws\\Type\\SerializableTimeZoneTime',
            'BasePermissionType' => '\\jamesiarmes\\PhpEws\\Type\\BasePermissionType',
            'RecurrencePatternBaseType' => '\\jamesiarmes\\PhpEws\\Type\\RecurrencePatternBaseType',
            'PreviewItemMailboxType' => '\\jamesiarmes\\PhpEws\\Type\\PreviewItemMailboxType',
            'AbsoluteMonthlyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\AbsoluteMonthlyRecurrencePatternType',
            'MailboxData' => '\\jamesiarmes\\PhpEws\\Type\\MailboxData',
            'RequestServerVersion' => '\\jamesiarmes\\PhpEws\\Type\\RequestServerVersion',
            'SendNotificationResultType' => '\\jamesiarmes\\PhpEws\\Type\\SendNotificationResultType',
            'RulePredicateDateRangeType' => '\\jamesiarmes\\PhpEws\\Type\\RulePredicateDateRangeType',
            'TrackingPropertyType' => '\\jamesiarmes\\PhpEws\\Type\\TrackingPropertyType',
            'RulePredicatesType' => '\\jamesiarmes\\PhpEws\\Type\\RulePredicatesType',
            'IsLessThanType' => '\\jamesiarmes\\PhpEws\\Type\\IsLessThanType',
            'ServiceConfiguration' => '\\jamesiarmes\\PhpEws\\Type\\ServiceConfiguration',
            'NonIndexableItemDetailResultType' => '\\jamesiarmes\\PhpEws\\Type\\NonIndexableItemDetailResultType',
            'SearchExpressionType' => '\\jamesiarmes\\PhpEws\\Type\\SearchExpressionType',
            'SerializableTimeZone' => '\\jamesiarmes\\PhpEws\\Type\\SerializableTimeZone',
            'SmtpDomain' => '\\jamesiarmes\\PhpEws\\Type\\SmtpDomain',
            'RecurringDateTransitionType' => '\\jamesiarmes\\PhpEws\\Type\\RecurringDateTransitionType',
            'DailyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\DailyRecurrencePatternType',
            'AttendeeType' => '\\jamesiarmes\\PhpEws\\Type\\AttendeeType',
            'UserConfigurationType' => '\\jamesiarmes\\PhpEws\\Type\\UserConfigurationType',
            'ContextPropertyType' => '\\jamesiarmes\\PhpEws\\Type\\ContextPropertyType',
            'SerializedSecurityContextType' => '\\jamesiarmes\\PhpEws\\Type\\SerializedSecurityContextType',
            'SmtpDomainList' => '\\jamesiarmes\\PhpEws\\Type\\SmtpDomainList',
            'Duration' => '\\jamesiarmes\\PhpEws\\Type\\Duration',
            'RemoveItemType' => '\\jamesiarmes\\PhpEws\\Type\\RemoveItemType',
            'UserIdType' => '\\jamesiarmes\\PhpEws\\Type\\UserIdType',
            'TaskRecurrenceType' => '\\jamesiarmes\\PhpEws\\Type\\TaskRecurrenceType',
            'FindFolderParentType' => '\\jamesiarmes\\PhpEws\\Type\\FindFolderParentType',
            'PostItemType' => '\\jamesiarmes\\PhpEws\\Type\\PostItemType',
            'ConstantValueType' => '\\jamesiarmes\\PhpEws\\Type\\ConstantValueType',
            'EmailAddressAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\EmailAddressAttributedValueType',
            'Suggestion' => '\\jamesiarmes\\PhpEws\\Type\\Suggestion',
            'SetFolderFieldType' => '\\jamesiarmes\\PhpEws\\Type\\SetFolderFieldType',
            'ItemChangeDescriptionType' => '\\jamesiarmes\\PhpEws\\Type\\ItemChangeDescriptionType',
            'ProtectionRuleActionType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleActionType',
            'DelegatePermissionsType' => '\\jamesiarmes\\PhpEws\\Type\\DelegatePermissionsType',
            'AcceptSharingInvitationType' => '\\jamesiarmes\\PhpEws\\Type\\AcceptSharingInvitationType',
            'UserConfigurationNameType' => '\\jamesiarmes\\PhpEws\\Type\\UserConfigurationNameType',
            'ExcludesType' => '\\jamesiarmes\\PhpEws\\Type\\ExcludesType',
            'FolderResponseShapeType' => '\\jamesiarmes\\PhpEws\\Type\\FolderResponseShapeType',
            'AttendeeConflictData' => '\\jamesiarmes\\PhpEws\\Type\\AttendeeConflictData',
            'MailboxSearchScopeType' => '\\jamesiarmes\\PhpEws\\Type\\MailboxSearchScopeType',
            'SuggestionDayResult' => '\\jamesiarmes\\PhpEws\\Type\\SuggestionDayResult',
            'TargetFolderIdType' => '\\jamesiarmes\\PhpEws\\Type\\TargetFolderIdType',
            'PhysicalAddressDictionaryType' => '\\jamesiarmes\\PhpEws\\Type\\PhysicalAddressDictionaryType',
            'DeclineItemType' => '\\jamesiarmes\\PhpEws\\Type\\DeclineItemType',
            'CalendarEventDetails' => '\\jamesiarmes\\PhpEws\\Type\\CalendarEventDetails',
            'PullSubscriptionRequestType' => '\\jamesiarmes\\PhpEws\\Type\\PullSubscriptionRequestType',
            'ProtectionRuleRecipientIsType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleRecipientIsType',
            'RequestAttachmentIdType' => '\\jamesiarmes\\PhpEws\\Type\\RequestAttachmentIdType',
            'UnknownAttendeeConflictData' => '\\jamesiarmes\\PhpEws\\Type\\UnknownAttendeeConflictData',
            'AppMetadata' => '\\jamesiarmes\\PhpEws\\Type\\AppMetadata',
            'WorkingHours' => '\\jamesiarmes\\PhpEws\\Type\\WorkingHours',
            'SearchMailboxesResultType' => '\\jamesiarmes\\PhpEws\\Type\\SearchMailboxesResultType',
            'RoomType' => '\\jamesiarmes\\PhpEws\\Type\\RoomType',
            'PersonaPostalAddressType' => '\\jamesiarmes\\PhpEws\\Type\\PersonaPostalAddressType',
            'RecurrenceType' => '\\jamesiarmes\\PhpEws\\Type\\RecurrenceType',
            'NotType' => '\\jamesiarmes\\PhpEws\\Type\\NotType',
            'MailboxHoldStatusType' => '\\jamesiarmes\\PhpEws\\Type\\MailboxHoldStatusType',
            'OrType' => '\\jamesiarmes\\PhpEws\\Type\\OrType',
            'WeeklyRegeneratingPatternType' => '\\jamesiarmes\\PhpEws\\Type\\WeeklyRegeneratingPatternType',
            'ExchangeImpersonationType' => '\\jamesiarmes\\PhpEws\\Type\\ExchangeImpersonationType',
            'DelegateUserType' => '\\jamesiarmes\\PhpEws\\Type\\DelegateUserType',
            'SetItemFieldType' => '\\jamesiarmes\\PhpEws\\Type\\SetItemFieldType',
            'PushSubscriptionRequestType' => '\\jamesiarmes\\PhpEws\\Type\\PushSubscriptionRequestType',
            'BaseNotificationEventType' => '\\jamesiarmes\\PhpEws\\Type\\BaseNotificationEventType',
            'ContainsExpressionType' => '\\jamesiarmes\\PhpEws\\Type\\ContainsExpressionType',
            'MessageType' => '\\jamesiarmes\\PhpEws\\Type\\MessageType',
            'ContactsFolderType' => '\\jamesiarmes\\PhpEws\\Type\\ContactsFolderType',
            'FreeBusyView' => '\\jamesiarmes\\PhpEws\\Type\\FreeBusyView',
            'ManagedFolderInformationType' => '\\jamesiarmes\\PhpEws\\Type\\ManagedFolderInformationType',
            'RelativeYearlyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\RelativeYearlyRecurrencePatternType',
            'RecurrenceRangeBaseType' => '\\jamesiarmes\\PhpEws\\Type\\RecurrenceRangeBaseType',
            'PhysicalAddressDictionaryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\PhysicalAddressDictionaryEntryType',
            'NonIndexableItemDetailType' => '\\jamesiarmes\\PhpEws\\Type\\NonIndexableItemDetailType',
            'AppType' => '\\jamesiarmes\\PhpEws\\Type\\AppType',
            'CreateRuleOperationType' => '\\jamesiarmes\\PhpEws\\Type\\CreateRuleOperationType',
            'MonthlyRegeneratingPatternType' => '\\jamesiarmes\\PhpEws\\Type\\MonthlyRegeneratingPatternType',
            'ConversationResponseType' => '\\jamesiarmes\\PhpEws\\Type\\ConversationResponseType',
            'DeleteFolderFieldType' => '\\jamesiarmes\\PhpEws\\Type\\DeleteFolderFieldType',
            'ExtendedPropertyAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\ExtendedPropertyAttributedValueType',
            'ConversationType' => '\\jamesiarmes\\PhpEws\\Type\\ConversationType',
            'IsGreaterThanType' => '\\jamesiarmes\\PhpEws\\Type\\IsGreaterThanType',
            'DailyRegeneratingPatternType' => '\\jamesiarmes\\PhpEws\\Type\\DailyRegeneratingPatternType',
            'StreamingSubscriptionRequest' => '\\jamesiarmes\\PhpEws\\Type\\StreamingSubscriptionRequest',
            'RecipientTrackingEventType' => '\\jamesiarmes\\PhpEws\\Type\\RecipientTrackingEventType',
            'AppendToFolderFieldType' => '\\jamesiarmes\\PhpEws\\Type\\AppendToFolderFieldType',
            'DistinguishedFolderIdType' => '\\jamesiarmes\\PhpEws\\Type\\DistinguishedFolderIdType',
            'AddressListIdType' => '\\jamesiarmes\\PhpEws\\Type\\AddressListIdType',
            'FindMessageTrackingSearchResultType' => '\\jamesiarmes\\PhpEws\\Type\\FindMessageTrackingSearchResultType',
            'SuppressReadReceiptType' => '\\jamesiarmes\\PhpEws\\Type\\SuppressReadReceiptType',
            'ProtectionRuleArgumentType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleArgumentType',
            'ExistsType' => '\\jamesiarmes\\PhpEws\\Type\\ExistsType',
            'NonIndexableItemStatisticType' => '\\jamesiarmes\\PhpEws\\Type\\NonIndexableItemStatisticType',
            'RecurringTimeTransitionType' => '\\jamesiarmes\\PhpEws\\Type\\RecurringTimeTransitionType',
            'CalendarFolderType' => '\\jamesiarmes\\PhpEws\\Type\\CalendarFolderType',
            'ProtectionRuleSenderDepartmentsType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleSenderDepartmentsType',
            'UserOofSettings' => '\\jamesiarmes\\PhpEws\\Type\\UserOofSettings',
            'RuleType' => '\\jamesiarmes\\PhpEws\\Type\\RuleType',
            'PersonaResponseShapeType' => '\\jamesiarmes\\PhpEws\\Type\\PersonaResponseShapeType',
            'MailboxStatisticsSearchResultType' => '\\jamesiarmes\\PhpEws\\Type\\MailboxStatisticsSearchResultType',
            'FolderChangeDescriptionType' => '\\jamesiarmes\\PhpEws\\Type\\FolderChangeDescriptionType',
            'RuleActionsType' => '\\jamesiarmes\\PhpEws\\Type\\RuleActionsType',
            'UserConfigurationDictionaryType' => '\\jamesiarmes\\PhpEws\\Type\\UserConfigurationDictionaryType',
            'TooBigGroupAttendeeConflictData' => '\\jamesiarmes\\PhpEws\\Type\\TooBigGroupAttendeeConflictData',
            'ProtectionRuleConditionType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleConditionType',
            'DeletedOccurrenceInfoType' => '\\jamesiarmes\\PhpEws\\Type\\DeletedOccurrenceInfoType',
            'ItemChangeType' => '\\jamesiarmes\\PhpEws\\Type\\ItemChangeType',
            'ConversationActionType' => '\\jamesiarmes\\PhpEws\\Type\\ConversationActionType',
            'AndType' => '\\jamesiarmes\\PhpEws\\Type\\AndType',
            'BasePathToElementType' => '\\jamesiarmes\\PhpEws\\Type\\BasePathToElementType',
            'PrivateCatalogAddInsType' => '\\jamesiarmes\\PhpEws\\Type\\PrivateCatalogAddInsType',
            'NoEndRecurrenceRangeType' => '\\jamesiarmes\\PhpEws\\Type\\NoEndRecurrenceRangeType',
            'QueryStringType' => '\\jamesiarmes\\PhpEws\\Type\\QueryStringType',
            'RecurringMasterItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\RecurringMasterItemIdType',
            'RootItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\RootItemIdType',
            'SidAndAttributesType' => '\\jamesiarmes\\PhpEws\\Type\\SidAndAttributesType',
            'SyncFolderHierarchyDeleteType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderHierarchyDeleteType',
            'MembersListType' => '\\jamesiarmes\\PhpEws\\Type\\MembersListType',
            'AlternateIdBaseType' => '\\jamesiarmes\\PhpEws\\Type\\AlternateIdBaseType',
            'PersonaPhoneNumberType' => '\\jamesiarmes\\PhpEws\\Type\\PersonaPhoneNumberType',
            'ReminderItemActionType' => '\\jamesiarmes\\PhpEws\\Type\\ReminderItemActionType',
            'ConversationNodeType' => '\\jamesiarmes\\PhpEws\\Type\\ConversationNodeType',
            'SuggestionsResponseType' => '\\jamesiarmes\\PhpEws\\Type\\SuggestionsResponseType',
            'PhoneNumberAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\PhoneNumberAttributedValueType',
            'EmailAddressType' => '\\jamesiarmes\\PhpEws\\Type\\EmailAddressType',
            'FreeBusyViewOptionsType' => '\\jamesiarmes\\PhpEws\\Type\\FreeBusyViewOptionsType',
            'FindItemParentType' => '\\jamesiarmes\\PhpEws\\Type\\FindItemParentType',
            'OccurrenceInfoType' => '\\jamesiarmes\\PhpEws\\Type\\OccurrenceInfoType',
            'MailboxHoldResultType' => '\\jamesiarmes\\PhpEws\\Type\\MailboxHoldResultType',
            'AttachmentResponseShapeType' => '\\jamesiarmes\\PhpEws\\Type\\AttachmentResponseShapeType',
            'ExtendedAttributeType' => '\\jamesiarmes\\PhpEws\\Type\\ExtendedAttributeType',
            'ExcludesValueType' => '\\jamesiarmes\\PhpEws\\Type\\ExcludesValueType',
            'AbsoluteDateTransitionType' => '\\jamesiarmes\\PhpEws\\Type\\AbsoluteDateTransitionType',
            'SyncFolderItemsDeleteType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderItemsDeleteType',
            'ContactsViewType' => '\\jamesiarmes\\PhpEws\\Type\\ContactsViewType',
            'PathToIndexedFieldType' => '\\jamesiarmes\\PhpEws\\Type\\PathToIndexedFieldType',
            'NumberedRecurrenceRangeType' => '\\jamesiarmes\\PhpEws\\Type\\NumberedRecurrenceRangeType',
            'ForwardItemType' => '\\jamesiarmes\\PhpEws\\Type\\ForwardItemType',
            'PreviewItemResponseShapeType' => '\\jamesiarmes\\PhpEws\\Type\\PreviewItemResponseShapeType',
            'PersonaAttributionType' => '\\jamesiarmes\\PhpEws\\Type\\PersonaAttributionType',
            'TimeZoneDefinitionType' => '\\jamesiarmes\\PhpEws\\Type\\TimeZoneDefinitionType',
            'CalendarPermissionType' => '\\jamesiarmes\\PhpEws\\Type\\CalendarPermissionType',
            'ReferenceItemResponseType' => '\\jamesiarmes\\PhpEws\\Type\\ReferenceItemResponseType',
            'PhoneNumberDictionaryType' => '\\jamesiarmes\\PhpEws\\Type\\PhoneNumberDictionaryType',
            'PostReplyItemType' => '\\jamesiarmes\\PhpEws\\Type\\PostReplyItemType',
            'BaseFolderIdType' => '\\jamesiarmes\\PhpEws\\Type\\BaseFolderIdType',
            'IsEqualToType' => '\\jamesiarmes\\PhpEws\\Type\\IsEqualToType',
            'ProtectionRulesServiceConfiguration' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRulesServiceConfiguration',
            'ServerVersionInfo' => '\\jamesiarmes\\PhpEws\\Type\\ServerVersionInfo',
            'IndividualAttendeeConflictData' => '\\jamesiarmes\\PhpEws\\Type\\IndividualAttendeeConflictData',
            'DeleteItemFieldType' => '\\jamesiarmes\\PhpEws\\Type\\DeleteItemFieldType',
            'SmartResponseBaseType' => '\\jamesiarmes\\PhpEws\\Type\\SmartResponseBaseType',
            'BodyContentType' => '\\jamesiarmes\\PhpEws\\Type\\BodyContentType',
            'UserConfigurationDictionaryObjectType' => '\\jamesiarmes\\PhpEws\\Type\\UserConfigurationDictionaryObjectType',
            'IsNotEqualToType' => '\\jamesiarmes\\PhpEws\\Type\\IsNotEqualToType',
            'ReplyAllToItemType' => '\\jamesiarmes\\PhpEws\\Type\\ReplyAllToItemType',
            'FieldURIOrConstantType' => '\\jamesiarmes\\PhpEws\\Type\\FieldURIOrConstantType',
            'RetentionPolicyTagType' => '\\jamesiarmes\\PhpEws\\Type\\RetentionPolicyTagType',
            'AggregateOnType' => '\\jamesiarmes\\PhpEws\\Type\\AggregateOnType',
            'ItemType' => '\\jamesiarmes\\PhpEws\\Type\\ItemType',
            'FailedSearchMailboxType' => '\\jamesiarmes\\PhpEws\\Type\\FailedSearchMailboxType',
            'EndDateRecurrenceRangeType' => '\\jamesiarmes\\PhpEws\\Type\\EndDateRecurrenceRangeType',
            'SeekToConditionPageViewType' => '\\jamesiarmes\\PhpEws\\Type\\SeekToConditionPageViewType',
            'ConflictResultsType' => '\\jamesiarmes\\PhpEws\\Type\\ConflictResultsType',
            'PermissionSetType' => '\\jamesiarmes\\PhpEws\\Type\\PermissionSetType',
            'SearchFolderType' => '\\jamesiarmes\\PhpEws\\Type\\SearchFolderType',
            'OccurrenceItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\OccurrenceItemIdType',
            'MailTips' => '\\jamesiarmes\\PhpEws\\Type\\MailTips',
            'ProtectionRuleType' => '\\jamesiarmes\\PhpEws\\Type\\ProtectionRuleType',
            'SetRuleOperationType' => '\\jamesiarmes\\PhpEws\\Type\\SetRuleOperationType',
            'FileAttachmentType' => '\\jamesiarmes\\PhpEws\\Type\\FileAttachmentType',
            'TransitionTargetType' => '\\jamesiarmes\\PhpEws\\Type\\TransitionTargetType',
            'IntervalRecurrencePatternBaseType' => '\\jamesiarmes\\PhpEws\\Type\\IntervalRecurrencePatternBaseType',
            'RulePredicateSizeRangeType' => '\\jamesiarmes\\PhpEws\\Type\\RulePredicateSizeRangeType',
            'ConversationShape' => '\\jamesiarmes\\PhpEws\\Type\\ConversationShape',
            'ItemResponseShapeType' => '\\jamesiarmes\\PhpEws\\Type\\ItemResponseShapeType',
            'PostalAddressAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\PostalAddressAttributedValueType',
            'FolderChangeType' => '\\jamesiarmes\\PhpEws\\Type\\FolderChangeType',
            'AttachmentType' => '\\jamesiarmes\\PhpEws\\Type\\AttachmentType',
            'AbsoluteYearlyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\AbsoluteYearlyRecurrencePatternType',
            'MeetingCancellationMessageType' => '\\jamesiarmes\\PhpEws\\Type\\MeetingCancellationMessageType',
            'CalendarEvent' => '\\jamesiarmes\\PhpEws\\Type\\CalendarEvent',
            'RuleValidationErrorType' => '\\jamesiarmes\\PhpEws\\Type\\RuleValidationErrorType',
            'BodyType' => '\\jamesiarmes\\PhpEws\\Type\\BodyType',
            'CalendarItemType' => '\\jamesiarmes\\PhpEws\\Type\\CalendarItemType',
            'FreeBusyResponseType' => '\\jamesiarmes\\PhpEws\\Type\\FreeBusyResponseType',
            'ItemAttachmentType' => '\\jamesiarmes\\PhpEws\\Type\\ItemAttachmentType',
            'RuleOperationErrorType' => '\\jamesiarmes\\PhpEws\\Type\\RuleOperationErrorType',
            'CancelCalendarItemType' => '\\jamesiarmes\\PhpEws\\Type\\CancelCalendarItemType',
            'MessageTrackingReportType' => '\\jamesiarmes\\PhpEws\\Type\\MessageTrackingReportType',
            'FieldOrderType' => '\\jamesiarmes\\PhpEws\\Type\\FieldOrderType',
            'RegeneratingPatternBaseType' => '\\jamesiarmes\\PhpEws\\Type\\RegeneratingPatternBaseType',
            'DistributionListType' => '\\jamesiarmes\\PhpEws\\Type\\DistributionListType',
            'PhoneCallIdType' => '\\jamesiarmes\\PhpEws\\Type\\PhoneCallIdType',
            'FolderIdType' => '\\jamesiarmes\\PhpEws\\Type\\FolderIdType',
            'AlternatePublicFolderItemIdType' => '\\jamesiarmes\\PhpEws\\Type\\AlternatePublicFolderItemIdType',
            'NotificationType' => '\\jamesiarmes\\PhpEws\\Type\\NotificationType',
            'ImItemListType' => '\\jamesiarmes\\PhpEws\\Type\\ImItemListType',
            'MovedCopiedEventType' => '\\jamesiarmes\\PhpEws\\Type\\MovedCopiedEventType',
            'ExtendedPropertyType' => '\\jamesiarmes\\PhpEws\\Type\\ExtendedPropertyType',
            'SyncFolderItemsReadFlagType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderItemsReadFlagType',
            'ProposeNewTimeType' => '\\jamesiarmes\\PhpEws\\Type\\ProposeNewTimeType',
            'ReplyBody' => '\\jamesiarmes\\PhpEws\\Type\\ReplyBody',
            'ClientAccessTokenRequestType' => '\\jamesiarmes\\PhpEws\\Type\\ClientAccessTokenRequestType',
            'StringAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\StringAttributedValueType',
            'AttachmentIdType' => '\\jamesiarmes\\PhpEws\\Type\\AttachmentIdType',
            'ChangeDescriptionType' => '\\jamesiarmes\\PhpEws\\Type\\ChangeDescriptionType',
            'String' => '\\jamesiarmes\\PhpEws\\Type\\StringType',
            'ResponseObjectType' => '\\jamesiarmes\\PhpEws\\Type\\ResponseObjectType',
            'TasksFolderType' => '\\jamesiarmes\\PhpEws\\Type\\TasksFolderType',
            'MeetingMessageType' => '\\jamesiarmes\\PhpEws\\Type\\MeetingMessageType',
            'IsLessThanOrEqualToType' => '\\jamesiarmes\\PhpEws\\Type\\IsLessThanOrEqualToType',
            'GroupByType' => '\\jamesiarmes\\PhpEws\\Type\\GroupByType',
            'InternetHeaderType' => '\\jamesiarmes\\PhpEws\\Type\\InternetHeaderType',
            'ResolutionType' => '\\jamesiarmes\\PhpEws\\Type\\ResolutionType',
            'SyncFolderHierarchyCreateOrUpdateType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderHierarchyCreateOrUpdateType',
            'ReminderType' => '\\jamesiarmes\\PhpEws\\Type\\ReminderType',
            'AcceptItemType' => '\\jamesiarmes\\PhpEws\\Type\\AcceptItemType',
            'MailboxQueryType' => '\\jamesiarmes\\PhpEws\\Type\\MailboxQueryType',
            'UserMailboxType' => '\\jamesiarmes\\PhpEws\\Type\\UserMailboxType',
            'CalendarPermissionSetType' => '\\jamesiarmes\\PhpEws\\Type\\CalendarPermissionSetType',
            'PersonaType' => '\\jamesiarmes\\PhpEws\\Type\\PersonaType',
            'EffectiveRightsType' => '\\jamesiarmes\\PhpEws\\Type\\EffectiveRightsType',
            'TimeZoneContextType' => '\\jamesiarmes\\PhpEws\\Type\\TimeZoneContextType',
            'MultipleOperandBooleanExpressionType' => '\\jamesiarmes\\PhpEws\\Type\\MultipleOperandBooleanExpressionType',
            'RecurringMasterItemIdRanges' => '\\jamesiarmes\\PhpEws\\Type\\RecurringMasterItemIdRanges',
            'PostReplyItemBaseType' => '\\jamesiarmes\\PhpEws\\Type\\PostReplyItemBaseType',
            'RecurringDayTransitionType' => '\\jamesiarmes\\PhpEws\\Type\\RecurringDayTransitionType',
            'EmailAddressDictionaryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\EmailAddressDictionaryEntryType',
            'RestrictionType' => '\\jamesiarmes\\PhpEws\\Type\\RestrictionType',
            'BaseFolderType' => '\\jamesiarmes\\PhpEws\\Type\\BaseFolderType',
            'TimeZoneType' => '\\jamesiarmes\\PhpEws\\Type\\TimeZoneType',
            'BaseObjectChangedEventType' => '\\jamesiarmes\\PhpEws\\Type\\BaseObjectChangedEventType',
            'PathToExtendedFieldType' => '\\jamesiarmes\\PhpEws\\Type\\PathToExtendedFieldType',
            'EmailAddressDictionaryType' => '\\jamesiarmes\\PhpEws\\Type\\EmailAddressDictionaryType',
            'BasePagingType' => '\\jamesiarmes\\PhpEws\\Type\\BasePagingType',
            'ImAddressDictionaryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\ImAddressDictionaryEntryType',
            'YearlyRegeneratingPatternType' => '\\jamesiarmes\\PhpEws\\Type\\YearlyRegeneratingPatternType',
            'TwoOperandExpressionType' => '\\jamesiarmes\\PhpEws\\Type\\TwoOperandExpressionType',
            'InvalidRecipientType' => '\\jamesiarmes\\PhpEws\\Type\\InvalidRecipientType',
            'ReplyToItemType' => '\\jamesiarmes\\PhpEws\\Type\\ReplyToItemType',
            'CalendarViewType' => '\\jamesiarmes\\PhpEws\\Type\\CalendarViewType',
            'SearchableMailboxType' => '\\jamesiarmes\\PhpEws\\Type\\SearchableMailboxType',
            'RelativeMonthlyRecurrencePatternType' => '\\jamesiarmes\\PhpEws\\Type\\RelativeMonthlyRecurrencePatternType',
            'PermissionType' => '\\jamesiarmes\\PhpEws\\Type\\PermissionType',
            'PhoneNumberDictionaryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\PhoneNumberDictionaryEntryType',
            'BaseSubscriptionRequestType' => '\\jamesiarmes\\PhpEws\\Type\\BaseSubscriptionRequestType',
            'PathToUnindexedFieldType' => '\\jamesiarmes\\PhpEws\\Type\\PathToUnindexedFieldType',
            'EncryptedSharedFolderDataType' => '\\jamesiarmes\\PhpEws\\Type\\EncryptedSharedFolderDataType',
            'ClientAccessTokenType' => '\\jamesiarmes\\PhpEws\\Type\\ClientAccessTokenType',
            'KeywordStatisticsSearchResultType' => '\\jamesiarmes\\PhpEws\\Type\\KeywordStatisticsSearchResultType',
            'ImGroupType' => '\\jamesiarmes\\PhpEws\\Type\\ImGroupType',
            'DeleteRuleOperationType' => '\\jamesiarmes\\PhpEws\\Type\\DeleteRuleOperationType',
            'ImAddressDictionaryType' => '\\jamesiarmes\\PhpEws\\Type\\ImAddressDictionaryType',
            'FractionalPageViewType' => '\\jamesiarmes\\PhpEws\\Type\\FractionalPageViewType',
            'IndexedPageViewType' => '\\jamesiarmes\\PhpEws\\Type\\IndexedPageViewType',
            'IsGreaterThanOrEqualToType' => '\\jamesiarmes\\PhpEws\\Type\\IsGreaterThanOrEqualToType',
            'FolderType' => '\\jamesiarmes\\PhpEws\\Type\\FolderType',
            'UserConfigurationDictionaryEntryType' => '\\jamesiarmes\\PhpEws\\Type\\UserConfigurationDictionaryEntryType',
            'GroupAttendeeConflictData' => '\\jamesiarmes\\PhpEws\\Type\\GroupAttendeeConflictData',
            'PeriodType' => '\\jamesiarmes\\PhpEws\\Type\\PeriodType',
            'SyncFolderItemsCreateOrUpdateType' => '\\jamesiarmes\\PhpEws\\Type\\SyncFolderItemsCreateOrUpdateType',
            'BodyContentAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\BodyContentAttributedValueType',
            'UploadItemType' => '\\jamesiarmes\\PhpEws\\Type\\UploadItemType',
            'InstalledAppType' => '\\jamesiarmes\\PhpEws\\Type\\InstalledAppType',
            'StringArrayAttributedValueType' => '\\jamesiarmes\\PhpEws\\Type\\StringArrayAttributedValueType',
            'TransitionType' => '\\jamesiarmes\\PhpEws\\Type\\TransitionType',
        );
    }
}
