<?php
namespace amirsanni\phpewswrapper\Messages;

use jamesiarmes\PhpEws\Enumeration\ResponseClassType;
use jamesiarmes\PhpEws\Enumeration\DistinguishedFolderIdNameType;

// use amirsanni\phpewswrapper\Messages\Message;

class Mail extends Message{
    private $sender_email;

    public $sender_name;
    public $recipient;
    public $recipient_name;
    public $cc;
    public $bcc;
    public $subject;
    public $body;
    public $attach;
    public $send_as_email;
    public $reply_to;
    public $limit;

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function __construct($ews, $email){
        parent::__construct($ews);

        $this->sender_email = $email;
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    private function __setAndCreateMessage($save_only=FALSE){
        $this->setSender($this->sender_email, $this->sender_name, $this->send_as_email);
        $this->setSubject($this->subject);
        $this->setMsgBody($this->body);
        $this->setItemType($this->attach, $save_only);
        $this->setRecipients($this->recipient, $this->recipient_name);
        $this->cc ? $this->setCc($this->cc) : "";
        $this->bcc ? $this->setBcc($this->bcc) : "";
        $this->reply_to ? $this->setReplyTo($this->reply_to) : "";

        $this->createMessage();
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    /**
     * Send email message
     * Handles the sending of new messages or a message from draft
     *
     * @param string $message_id
     * @param string $change_key
     * @return void
     */
    public function send(string $message_id='', string $change_key=''){
        if($message_id && $change_key){
            return $this->sendSavedMsg($message_id, $change_key);
        }

        else if($this->body){
            $this->__setAndCreateMessage();

            if($this->attach){
                //add attachment and send
                $message_id = $this->getCreatedMessageId();
                $change_key = $this->attachFiles($message_id, $this->attach);

                return $this->sendSavedMsg($message_id, $change_key);
            }

            else{
                return $this->response->ResponseMessages->CreateItemResponseMessage[0]->ResponseClass == ResponseClassType::SUCCESS;
            }
        }

        else{
            return ['status'=>0, 'msg'=>"Property 'body' (Message body) cannot be empty"];
        }
    }
    
    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function save(){
        $this->__setAndCreateMessage(TRUE);

        if($this->attach){
            //attach files to the created message
            $message_id = $this->getCreatedMessageId();            

            $this->attachFiles($message_id, $this->attach);
        }
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function inbox(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::INBOX, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function sent(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::SENT, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function draft(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::DRAFTS, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function outbox(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::OUTBOX, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function favourites(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::FAVORITES, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function favorites(int $page_number=1){
        return $this->favourites();
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function conversationHistory(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::CONVERSATION_HISTORY, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function junk(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::JUNK, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function archived(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::ARCHIVE_INBOX, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function deleted(int $page_number=1){
        return $this->getMessages($page_number, DistinguishedFolderIdNameType::DELETED, $this->limit);
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    public function unread(int $page_number=1){
        $response = $this->getMessages($page_number, DistinguishedFolderIdNameType::INBOX, $this->limit);

        $res = new \stdClass();

        if($response->status === 1 && $response->messages){
            $unread_messages = [];

            foreach($response->messages as $message){
                if($message->is_read){
                    continue;
                }

                array_push($unread_messages, $message);
            }

            $res->status = 1;
            $res->msg = "success";
            $res->messages = $unread_messages;

            return $res;
        }

        else if($response->status === 1){
            //no message in inbox
            $res->status = 0;
            $res->msg = "No message found";

            return $res;
        }

        else{
            //there is an error
            return $response;
        }
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    /**
     * Mark message as read
     * @param string $message_id
     * @param string $change_key
     */
    public function markAsRead(string $message_id, string $change_key){
        return $this->updateMessageReadStatus($message_id, $change_key, 'read');
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    /**
     * Mark message as unread
     * @param string $message_id
     * @param string $change_key
     */
    public function markAsUnread(string $message_id, string $change_key){
        return $this->updateMessageReadStatus($message_id, $change_key, 'unread');
    }

    /*
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    ********************************************************************************************************************************
    */

    /**
     * Delete message
     * @param string $message_id
     */
    public function delete(string $message_id){
        return $this->deleteMessage($message_id);
    }
}