# Amazon Linux 2023 Release Notes

-----
*****Copyright &copy; Amazon Web Services, Inc. and/or its affiliates. All rights reserved.*****

-----
Amazon's trademarks and trade dress may not be used in
connection with any product or service that is not Amazon's,
in any manner that is likely to cause confusion among customers,
or in any manner that disparages or discredits Amazon. All other
trademarks not owned by Amazon are the property of their respective
owners, who may or may not be affiliated with, connected to, or
sponsored by Amazon.

-----
## Contents
+ [Amazon Linux 2023 release notes](#relnotes)
   + [Amazon Linux 2023 version 2023.1.20230719 release notes](#relnotes-2023.1.20230719)
   + [Amazon Linux 2023 RPM packages as of the 2023.1.20230719 release](#all-packages-AL2023.1-2023.1.20230719)
   + [Summary of package changes in Amazon Linux 2023](#summary)
   + [New Packages in AL2023](#new-packages)
      + [New packages in AL2023.1 since AL1](#new-AL1-AL2023.1)
      + [New packages in AL2023.1 since AL2](#new-AL2-AL2023.1)
      + [New packages in AL2023.1 since AL2023.0](#new-AL2023.0-AL2023.1)
   + [Upgraded packages in AL2023](#vercmp)
      + [AL2023.1 upgrades from AL1](#vercmp-AL1-AL2023.1)
      + [AL2023.1 upgrades from AL2](#vercmp-AL2-AL2023.1)
      + [AL2023.1 upgrades from AL2023.0](#vercmp-AL2023.0-AL2023.1)
   + 
   # Amazon Linux 2023 version 2023\.1\.20230719 release notes<a name="relnotes-2023.1.20230719"></a>

This topic includes Amazon Linux 2023 \(AL2023\) release notes updates for the 2023\.1\.20230719 release

## Major updates<a name="major-updates-2023.1.20230719"></a>

This release represents an update to AL2023\.1\. AL2023 is the next generation of Amazon Linux\. It comes with five years of support and brings features such as Deterministic updates, better optimizations for Graviton processors, and others into Amazon Linux\. AL2023 is ready for customer production workloads, and customers are encouraged to start migrations from previous versions of Amazon Linux today\.

For information about UEFI Secure Boot on AL2023, see [Amazon Linux announces support for secure boot with AL2023\.1](http://aws.amazon.com/about-aws/whats-new/2023/06/amazon-linux-secure-boot-al2023-1/)\.

AL2023 includes the following major updates\.
+ For an in\-depth look at the changes since Amazon Linux 2, see [Comparing Amazon Linux 2 and AL2023](https://docs.aws.amazon.com/linux/al2023/ug/compare-with-al2.html)\.

**Known Issues**
+ AL2023 is not yet FIPS certified\. AL2023 is in the process of being certified for FIPS 140\-3\.

**Security Updates**
+ For information on the CVEs addressed in this release, refer to the [Amazon Linux Security Center](https://alas.aws.amazon.com/alas2023.html)\.
+ For visibility into the status of CVE's that haven't been addressed yet, refer to [Amazon Linux Security Center](https://explore.alas.aws.amazon.com/)\.

**Contact us**

If you find a security issue, contact [our security team](https://github.com/amazonlinux/amazon-linux-2023/security/policy) rather than opening a GitHub issue\.

We use GitHub issues to gather feedback about AL2023 and to track bug reports and feature requests\. You can look at [existing issues](https://github.com/amazonlinux/amazon-linux-2023/issues) to see whether your concern is already known\. If it is not, open a [new issue](https://github.com/amazonlinux/amazon-linux-2023/issues/new/choose)\. 

If you only have questions about AL2023, feel free to start or join a [discussion](https://github.com/amazonlinux/amazon-linux-2023/discussions)\. Feedback on AL2023 can also be provided through your designated AWS representative\.

**Topics**
+ [Major updates](#major-updates-2023.1.20230719)
+ [Repository](#amis-2023.1.20230719.repository)
+ [Docker container image](#amis-2023.1.20230719.container-image)
+ [Default AMI](#amis-2023.1.20230719.default-ami)
+ [Minimal AMI](#amis-2023.1.20230719.minimal-ami)

## Repository<a name="amis-2023.1.20230719.repository"></a>

The repository includes the following packages that were **added** since the last release\.

The repository includes the following packages that were **updated** since the last release\.

|  | 
| --- |
|  `bind-32:9.16.42-1.amzn2023.0.1` \(previous `bind-32:9.16.38-1.amzn2023.0.1`\)  | 
|  `binutils-2.39-6.amzn2023.0.7` \(previous `binutils-2.39-6.amzn2023.0.6`\)  | 
|  `bluez-5.62-2.amzn2023.0.4` \(previous `bluez-5.62-2.amzn2023.0.3`\)  | 
|  `containerd-1.7.2-1.amzn2023.0.1` \(previous `containerd-1.6.19-1.amzn2023.0.1`\)  | 
|  `cups-1:2.3.3op2-18.amzn2023.0.5` \(previous `cups-1:2.3.3op2-18.amzn2023.0.4`\)  | 
|  `docker-20.10.25-1.amzn2023.0.1` \(previous `docker-20.10.23-1.amzn2023.0.1`\)  | 
|  `dotnet6.0-6.0.118-1.amzn2023.0.1` \(previous `dotnet6.0-6.0.111-1.amzn2023.0.3`\)  | 
|  `dracut-055-6.amzn2023.0.8` \(previous `dracut-055-6.amzn2023.0.7`\)  | 
|  `ecs-init-1.73.1-1.amzn2023` \(previous `ecs-init-1.72.0-1.amzn2023`\)  | 
|  `gnutls-3.8.0-376.amzn2023.0.2` \(previous `gnutls-3.8.0-375.amzn2023.0.1`\)  | 
|  `ImageMagick-1:6.9.12.82-1.amzn2023.0.3` \(previous `ImageMagick-1:6.9.12.82-1.amzn2023.0.2`\)  | 
|  `jackson-core-2.11.4-7.amzn2023.0.2` \(previous `jackson-core-2.11.4-7.amzn2023.0.1`\)  | 
|  `java-1.8.0-amazon-corretto-1:1.8.0_382.b05-1.amzn2023` \(previous `java-1.8.0-amazon-corretto-1:1.8.0_372.b07-1.amzn2023`\)  | 
|  `java-11-amazon-corretto-1:11.0.20+8-1.amzn2023` \(previous `java-11-amazon-corretto-1:11.0.19+7-1.amzn2023`\)  | 
|  `java-17-amazon-corretto-1:17.0.8+7-1.amzn2023.1` \(previous `java-17-amazon-corretto-1:17.0.7+7-1.amzn2023.1`\)  | 
|  `kernel-6.1.38-59.109.amzn2023` \(previous `kernel-6.1.34-59.116.amzn2023`\)  | 
|  `libarchive-3.5.3-2.amzn2023.0.3` \(previous `libarchive-3.5.3-2.amzn2023.0.2`\)  | 
|  `libtiff-4.4.0-4.amzn2023.0.7` \(previous `libtiff-4.4.0-4.amzn2023.0.5`\)  | 
|  `libX11-1.7.2-3.amzn2023.0.3` \(previous `libX11-1.7.2-3.amzn2023.0.2`\)  | 
|  `nodejs-1:18.12.1-1.amzn2023.0.7` \(previous `nodejs-1:18.12.1-1.amzn2023.0.5`\)  | 
|  `nss-3.88.1-1.amzn2023.0.2` \(previous `nss-3.88.1-1.amzn2023.0.1`\)  | 
|  `open-vm-tools-12.2.5-1.amzn2023` \(previous `open-vm-tools-12.1.5-2.amzn2023.0.1`\)  | 
|  `perl-HTTP-Daemon-6.16-1.amzn2023` \(previous `perl-HTTP-Daemon-6.12-4.amzn2023.0.2`\)  | 
|  `php8.1-8.1.21-1.amzn2023.0.1` \(previous `php8.1-8.1.16-1.amzn2023.0.2`\)  | 
|  `postgresql15-15.0-1.amzn2023.0.3` \(previous `postgresql15-15.0-1.amzn2023.0.2`\)  | 
|  `python3.11-3.11.2-2.amzn2023.0.7` \(previous `python3.11-3.11.2-2.amzn2023.0.6`\)  | 
|  `python-configobj-5.0.6-23.amzn2023.0.3` \(previous `python-configobj-5.0.6-23.amzn2023.0.2`\)  | 
|  `python-requests-2.25.1-1.amzn2023.0.3` \(previous `python-requests-2.25.1-1.amzn2023.0.2`\)  | 
|  `python-setuptools-59.6.0-2.amzn2023.0.4` \(previous `python-setuptools-59.6.0-2.amzn2023.0.3`\)  | 
|  `python-tornado-6.1.0-2.amzn2023.0.3` \(previous `python-tornado-6.1.0-2.amzn2023.0.2`\)  | 
|  `python-wheel-1:0.37.1-1.amzn2023.0.3` \(previous `python-wheel-1:0.37.1-1.amzn2023.0.2`\)  | 
|  `system-release-2023.1.20230719-0.amzn2023` \(previous `system-release-2023.1.20230705-0.amzn2023`\)  | 
|  `tomcat9-1:9.0.71-1.amzn2023.0.3` \(previous `tomcat9-1:9.0.71-1.amzn2023.0.2`\)  | 
|  `yajl-2.1.0-16.amzn2023.0.4` \(previous `yajl-2.1.0-16.amzn2023.0.3`\)  | 
|  `zstd-1.5.2-1.amzn2023.0.3` \(previous `zstd-1.5.2-1.amzn2023.0.2`\)  | 

## Docker container image<a name="amis-2023.1.20230719.container-image"></a>
+ `amazon-linux-repo-cdn-2023.1.20230719-0.amzn2023`
+ `libarchive-3.5.3-2.amzn2023.0.3`
+ `libzstd-1.5.2-1.amzn2023.0.3`
+ `python3-setuptools-wheel-59.6.0-2.amzn2023.0.4`
+ `system-release-2023.1.20230719-0.amzn2023`

## Default AMI<a name="amis-2023.1.20230719.default-ami"></a>

|  | 
| --- |
|  `amazon-linux-repo-s3-2023.1.20230719-0.amzn2023`  | 
|  `bind-libs-32:9.16.42-1.amzn2023.0.1`  | 
|  `bind-license-32:9.16.42-1.amzn2023.0.1`  | 
|  `bind-utils-32:9.16.42-1.amzn2023.0.1`  | 
|  `binutils-2.39-6.amzn2023.0.7`  | 
|  `dracut-055-6.amzn2023.0.8`  | 
|  `dracut-config-generic-055-6.amzn2023.0.8`  | 
|  `gnutls-3.8.0-376.amzn2023.0.2`  | 
|  `kernel-6.1.38-59.109.amzn2023`  | 
|  `kernel-livepatch-repo-s3-2023.1.20230719-0.amzn2023`  | 
|  `kernel-tools-6.1.38-59.109.amzn2023`  | 
|  `libarchive-3.5.3-2.amzn2023.0.3`  | 
|  `libzstd-1.5.2-1.amzn2023.0.3`  | 
|  `nspr-4.35.0-4.amzn2023.0.2`  | 
|  `nss-3.88.1-1.amzn2023.0.2`  | 
|  `nss-softokn-3.88.1-1.amzn2023.0.2`  | 
|  `nss-softokn-freebl-3.88.1-1.amzn2023.0.2`  | 
|  `nss-sysinit-3.88.1-1.amzn2023.0.2`  | 
|  `nss-util-3.88.1-1.amzn2023.0.2`  | 
|  `python3-configobj-5.0.6-23.amzn2023.0.3`  | 
|  `python3-requests-2.25.1-1.amzn2023.0.3`  | 
|  `python3-setuptools-59.6.0-2.amzn2023.0.4`  | 
|  `python3-setuptools-wheel-59.6.0-2.amzn2023.0.4`  | 
|  `system-release-2023.1.20230719-0.amzn2023`  | 
|  `zstd-1.5.2-1.amzn2023.0.3`  | 

## Minimal AMI<a name="amis-2023.1.20230719.minimal-ami"></a>

|  | 
| --- |
|  `amazon-linux-repo-s3-2023.1.20230719-0.amzn2023`  | 
|  `dracut-055-6.amzn2023.0.8`  | 
|  `dracut-config-generic-055-6.amzn2023.0.8`  | 
|  `gnutls-3.8.0-376.amzn2023.0.2`  | 
|  `kernel-6.1.38-59.109.amzn2023`  | 
|  `kernel-livepatch-repo-s3-2023.1.20230719-0.amzn2023`  | 
|  `libarchive-3.5.3-2.amzn2023.0.3`  | 
|  `libzstd-1.5.2-1.amzn2023.0.3`  | 
|  `python3-configobj-5.0.6-23.amzn2023.0.3`  | 
|  `python3-requests-2.25.1-1.amzn2023.0.3`  | 
|  `python3-setuptools-59.6.0-2.amzn2023.0.4`  | 
|  `python3-setuptools-wheel-59.6.0-2.amzn2023.0.4`  | 
|  `system-release-2023.1.20230719-0.amzn2023`  | 
|  `zstd-1.5.2-1.amzn2023.0.3`  | 

# Amazon Linux 2023 RPM packages as of the 2023\.1\.20230719 release<a name="all-packages-AL2023.1-2023.1.20230719"></a>

The following list includes all packages for Amazon Linux 2023 release [2023\.1\.20230719](relnotes-2023.1.20230719.md)\.

## All AL2023\.1 packages<a name="AL2023.1"></a>

Each AL2023 major version receives 5 years of long\-term support\. Some packages closely follow their upstream release cadence and support model, and thus have an earlier end of life\. For details, see [AL2023 package support statements](https://docs.aws.amazon.com/linux/al2023/release-notes/support-info-by-support-statement.html) 

For more information about support for major versions of AL2023, see [AL2023 release cadence](https://docs.aws.amazon.com/linux/al2023/ug/release-cadence.html)\.

## All packages<a name="list-packages"></a>

AL2023 contains the following packages across different architectures\.


| Package Type | Count | 
| --- | --- | 
| Source | 2220 | 
| Total Binary RPMs | 15750 | 
|  aarch64 binary RPMs | 3253 | 
|  noarch binary RPMs | 9189 | 
|  x86\_64 binary RPMs | 3308 | 

The following list includes all the packages for AL2023\.


| RPM Package | Architecture | Source RPM | Version | 
| --- | --- | --- | --- | 
|  a2ps  |  aarch64  |  a2ps  |  4\.14\-48\.amzn2023\.0\.2  | 
|  a2ps  |  x86\_64  |  a2ps  |  4\.14\-48\.amzn2023\.0\.2  | 
|  abattis\-cantarell\-fonts  |  noarch  |  abattis\-cantarell\-fonts  |  0\.301\-2\.amzn2023\.0\.1  | 
|  abseil\-cpp  |  aarch64  |  abseil\-cpp  |  20210324\.2\-5\.amzn2023\.0\.3  | 
|  abseil\-cpp  |  x86\_64  |  abseil\-cpp  |  20210324\.2\-5\.amzn2023\.0\.3  | 
|  abseil\-cpp\-devel  |  aarch64  |  abseil\-cpp  |  20210324\.2\-5\.amzn2023\.0\.3  | 
|  abseil\-cpp\-devel  |  x86\_64  |  abseil\-cpp  |  20210324\.2\-5\.amzn2023\.0\.3  | 
|  acl  |  aarch64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  acl  |  x86\_64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  libacl  |  aarch64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  libacl  |  x86\_64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  libacl\-devel  |  aarch64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  libacl\-devel  |  x86\_64  |  acl  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  acpica\-tools  |  aarch64  |  acpica\-tools  |  20210604\-1\.amzn2023\.0\.2  | 
|  acpica\-tools  |  x86\_64  |  acpica\-tools  |  20210604\-1\.amzn2023\.0\.2  | 
|  acpid  |  aarch64  |  acpid  |  2\.0\.32\-4\.amzn2023\.0\.2  | 
|  acpid  |  x86\_64  |  acpid  |  2\.0\.32\-4\.amzn2023\.0\.2  | 
|  adcli  |  aarch64  |  adcli  |  0\.9\.1\-10\.amzn2023\.0\.3  | 
|  adcli  |  x86\_64  |  adcli  |  0\.9\.1\-10\.amzn2023\.0\.3  | 
|  adcli\-doc  |  noarch  |  adcli  |  0\.9\.1\-10\.amzn2023\.0\.3  | 
|  adobe\-afdko  |  aarch64  |  adobe\-afdko  |  3\.6\.1\-1\.amzn2023\.0\.2  | 
|  adobe\-afdko  |  x86\_64  |  adobe\-afdko  |  3\.6\.1\-1\.amzn2023\.0\.2  | 
|  adobe\-mappings\-cmap  |  noarch  |  adobe\-mappings\-cmap  |  20190730\-1\.amzn2023\.0\.2  | 
|  adobe\-mappings\-cmap\-deprecated  |  noarch  |  adobe\-mappings\-cmap  |  20190730\-1\.amzn2023\.0\.2  | 
|  adobe\-mappings\-cmap\-devel  |  noarch  |  adobe\-mappings\-cmap  |  20190730\-1\.amzn2023\.0\.2  | 
|  adobe\-mappings\-pdf  |  noarch  |  adobe\-mappings\-pdf  |  20180407\-8\.amzn2023\.0\.2  | 
|  adobe\-mappings\-pdf\-devel  |  noarch  |  adobe\-mappings\-pdf  |  20180407\-8\.amzn2023\.0\.2  | 
|  adobe\-source\-code\-pro\-fonts  |  noarch  |  adobe\-source\-code\-pro\-fonts  |  2\.030\.1\.050\-10\.amzn2023\.0\.2  | 
|  adobe\-source\-sans\-pro\-fonts  |  noarch  |  adobe\-source\-sans\-pro\-fonts  |  3\.046\-1\.amzn2023\.0\.2  | 
|  adwaita\-cursor\-theme  |  noarch  |  adwaita\-icon\-theme  |  40\.1\.1\-1\.amzn2023\.0\.2  | 
|  adwaita\-icon\-theme  |  noarch  |  adwaita\-icon\-theme  |  40\.1\.1\-1\.amzn2023\.0\.2  | 
|  adwaita\-icon\-theme\-devel  |  noarch  |  adwaita\-icon\-theme  |  40\.1\.1\-1\.amzn2023\.0\.2  | 
|  aide  |  aarch64  |  aide  |  0\.17\.4\-1\.amzn2023\.0\.2  | 
|  aide  |  x86\_64  |  aide  |  0\.17\.4\-1\.amzn2023\.0\.2  | 
|  alsa\-lib  |  aarch64  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-lib  |  x86\_64  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-lib\-devel  |  aarch64  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-lib\-devel  |  x86\_64  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-topology  |  noarch  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-ucm  |  noarch  |  alsa\-lib  |  1\.2\.7\.2\-1\.amzn2023\.0\.2  | 
|  alsa\-plugins\-arcamav  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-arcamav  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-maemo  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-maemo  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-oss  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-oss  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-pulseaudio  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-pulseaudio  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-speex  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-speex  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-usbstream  |  aarch64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-plugins\-usbstream  |  x86\_64  |  alsa\-plugins  |  1\.2\.7\.1\-1\.amzn2023\.0\.3  | 
|  alsa\-topology\-utils  |  aarch64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-topology\-utils  |  x86\_64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-ucm\-utils  |  aarch64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-ucm\-utils  |  x86\_64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-utils  |  aarch64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-utils  |  x86\_64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-utils\-alsabat  |  aarch64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  alsa\-utils\-alsabat  |  x86\_64  |  alsa\-utils  |  1\.2\.7\-1\.amzn2023\.0\.3  | 
|  amazon\-cloudwatch\-agent  |  aarch64  |  amazon\-cloudwatch\-agent  |  1\.247358\.0\-1\.amzn2023  | 
|  amazon\-cloudwatch\-agent  |  x86\_64  |  amazon\-cloudwatch\-agent  |  1\.247358\.0\-1\.amzn2023  | 
|  amazon\-ec2\-net\-utils  |  noarch  |  amazon\-ec2\-net\-utils  |  2\.3\.0\-1\.amzn2023\.0\.2  | 
|  amazon\-ecr\-credential\-helper  |  aarch64  |  amazon\-ecr\-credential\-helper  |  0\.6\.0\-1\.amzn2023  | 
|  amazon\-ecr\-credential\-helper  |  x86\_64  |  amazon\-ecr\-credential\-helper  |  0\.6\.0\-1\.amzn2023  | 
|  amazon\-efs\-utils  |  noarch  |  amazon\-efs\-utils  |  1\.35\.0\-1\.amzn2023  | 
|  amazon\-linux\-onprem  |  noarch  |  amazon\-linux\-onprem  |  1\.0\-0\.amzn2023  | 
|  amazon\-onprem\-network  |  noarch  |  amazon\-linux\-onprem  |  1\.0\-0\.amzn2023  | 
|  amazon\-linux\-sb\-keys  |  noarch  |  amazon\-linux\-sb\-keys  |  2023\.1\-1\.amzn2023\.0\.3  | 
|  amazon\-rpm\-config  |  noarch  |  amazon\-rpm\-config  |  228\-3\.amzn2023\.0\.2  | 
|  amazon\-ssm\-agent  |  aarch64  |  amazon\-ssm\-agent  |  3\.1\.1927\.0\-1\.amzn2023  | 
|  amazon\-ssm\-agent  |  x86\_64  |  amazon\-ssm\-agent  |  3\.1\.1927\.0\-1\.amzn2023  | 
|  annobin\-annocheck  |  aarch64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-annocheck  |  x86\_64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-docs  |  noarch  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-libannocheck  |  aarch64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-libannocheck  |  x86\_64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-clang  |  aarch64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-clang  |  x86\_64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-gcc  |  aarch64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-gcc  |  x86\_64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-llvm  |  aarch64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  annobin\-plugin\-llvm  |  x86\_64  |  annobin  |  10\.93\-1\.amzn2023\.0\.1  | 
|  ant  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-antlr  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-bcel  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-bsf  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-oro  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-regexp  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-resolver  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-apache\-xalan2  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-commons\-logging  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-commons\-net  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-imageio  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-javadoc  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-javamail  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-jdepend  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-jmf  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-jsch  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-junit  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-junit5  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-lib  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-manual  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-swing  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-testutil  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  ant\-xz  |  noarch  |  ant  |  1\.10\.12\-5\.amzn2023\.0\.4  | 
|  anthy  |  aarch64  |  anthy  |  9100h\-45\.amzn2023\.0\.2  | 
|  anthy  |  x86\_64  |  anthy  |  9100h\-45\.amzn2023\.0\.2  | 
|  anthy\-devel  |  aarch64  |  anthy  |  9100h\-45\.amzn2023\.0\.2  | 
|  anthy\-devel  |  x86\_64  |  anthy  |  9100h\-45\.amzn2023\.0\.2  | 
|  anthy\-unicode  |  aarch64  |  anthy\-unicode  |  1\.0\.0\.20211224\-1\.amzn2023\.0\.2  | 
|  anthy\-unicode  |  x86\_64  |  anthy\-unicode  |  1\.0\.0\.20211224\-1\.amzn2023\.0\.2  | 
|  anthy\-unicode\-devel  |  aarch64  |  anthy\-unicode  |  1\.0\.0\.20211224\-1\.amzn2023\.0\.2  | 
|  anthy\-unicode\-devel  |  x86\_64  |  anthy\-unicode  |  1\.0\.0\.20211224\-1\.amzn2023\.0\.2  | 
|  emacs\-anthy\-unicode  |  noarch  |  anthy\-unicode  |  1\.0\.0\.20211224\-1\.amzn2023\.0\.2  | 
|  antlr\-C\+\+  |  aarch64  |  antlr  |  2\.7\.7\-69\.amzn2023\.0\.3  | 
|  antlr\-C\+\+  |  x86\_64  |  antlr  |  2\.7\.7\-69\.amzn2023\.0\.3  | 
|  antlr\-javadoc  |  noarch  |  antlr  |  2\.7\.7\-69\.amzn2023\.0\.3  | 
|  antlr\-manual  |  noarch  |  antlr  |  2\.7\.7\-69\.amzn2023\.0\.3  | 
|  antlr\-tool  |  noarch  |  antlr  |  2\.7\.7\-69\.amzn2023\.0\.3  | 
|  aopalliance  |  noarch  |  aopalliance  |  1\.0\-28\.amzn2023\.0\.3  | 
|  aopalliance\-javadoc  |  noarch  |  aopalliance  |  1\.0\-28\.amzn2023\.0\.3  | 
|  apache\-commons\-beanutils  |  noarch  |  apache\-commons\-beanutils  |  1\.9\.4\-10\.amzn2023\.0\.3  | 
|  apache\-commons\-beanutils\-javadoc  |  noarch  |  apache\-commons\-beanutils  |  1\.9\.4\-10\.amzn2023\.0\.3  | 
|  apache\-commons\-cli  |  noarch  |  apache\-commons\-cli  |  1\.5\.0\-3\.amzn2023\.0\.3  | 
|  apache\-commons\-cli\-javadoc  |  noarch  |  apache\-commons\-cli  |  1\.5\.0\-3\.amzn2023\.0\.3  | 
|  apache\-commons\-codec  |  noarch  |  apache\-commons\-codec  |  1\.15\-6\.amzn2023\.0\.3  | 
|  apache\-commons\-codec\-javadoc  |  noarch  |  apache\-commons\-codec  |  1\.15\-6\.amzn2023\.0\.3  | 
|  apache\-commons\-collections  |  noarch  |  apache\-commons\-collections  |  3\.2\.2\-27\.amzn2023\.0\.3  | 
|  apache\-commons\-collections\-javadoc  |  noarch  |  apache\-commons\-collections  |  3\.2\.2\-27\.amzn2023\.0\.3  | 
|  apache\-commons\-collections\-testframework  |  noarch  |  apache\-commons\-collections  |  3\.2\.2\-27\.amzn2023\.0\.3  | 
|  apache\-commons\-compress  |  noarch  |  apache\-commons\-compress  |  1\.21\-4\.amzn2023\.0\.3  | 
|  apache\-commons\-compress\-javadoc  |  noarch  |  apache\-commons\-compress  |  1\.21\-4\.amzn2023\.0\.3  | 
|  apache\-commons\-exec  |  noarch  |  apache\-commons\-exec  |  1\.3\-22\.amzn2023\.0\.2  | 
|  apache\-commons\-exec\-javadoc  |  noarch  |  apache\-commons\-exec  |  1\.3\-22\.amzn2023\.0\.2  | 
|  apache\-commons\-io  |  noarch  |  apache\-commons\-io  |  2\.8\.0\-7\.amzn2023\.0\.4  | 
|  apache\-commons\-io\-javadoc  |  noarch  |  apache\-commons\-io  |  2\.8\.0\-7\.amzn2023\.0\.4  | 
|  apache\-commons\-jxpath  |  noarch  |  apache\-commons\-jxpath  |  1\.3\-43\.amzn2023\.0\.3  | 
|  apache\-commons\-jxpath\-javadoc  |  noarch  |  apache\-commons\-jxpath  |  1\.3\-43\.amzn2023\.0\.3  | 
|  apache\-commons\-lang3  |  noarch  |  apache\-commons\-lang3  |  3\.12\.0\-7\.amzn2023\.0\.3  | 
|  apache\-commons\-lang3\-javadoc  |  noarch  |  apache\-commons\-lang3  |  3\.12\.0\-7\.amzn2023\.0\.3  | 
|  apache\-commons\-logging  |  noarch  |  apache\-commons\-logging  |  1\.2\-30\.amzn2023\.0\.3  | 
|  apache\-commons\-logging\-javadoc  |  noarch  |  apache\-commons\-logging  |  1\.2\-30\.amzn2023\.0\.3  | 
|  apache\-commons\-net  |  noarch  |  apache\-commons\-net  |  3\.6\-17\.amzn2023\.0\.1  | 
|  apache\-commons\-net\-javadoc  |  noarch  |  apache\-commons\-net  |  3\.6\-17\.amzn2023\.0\.1  | 
|  apache\-commons\-parent  |  noarch  |  apache\-commons\-parent  |  52\-6\.amzn2023\.0\.3  | 
|  apache\-ivy  |  noarch  |  apache\-ivy  |  2\.5\.1\-1\.amzn2023\.0\.1  | 
|  apache\-ivy\-javadoc  |  noarch  |  apache\-ivy  |  2\.5\.1\-1\.amzn2023\.0\.1  | 
|  apache\-parent  |  noarch  |  apache\-parent  |  23\-8\.amzn2023\.0\.3  | 
|  apache\-resource\-bundles  |  noarch  |  apache\-resource\-bundles  |  30\-5\.amzn2023\.0\.3  | 
|  apiguardian  |  noarch  |  apiguardian  |  1\.1\.2\-3\.amzn2023\.0\.3  | 
|  apiguardian\-javadoc  |  noarch  |  apiguardian  |  1\.1\.2\-3\.amzn2023\.0\.3  | 
|  appstream  |  aarch64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream  |  x86\_64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-compose  |  aarch64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-compose  |  x86\_64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-compose\-devel  |  aarch64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-compose\-devel  |  x86\_64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-devel  |  aarch64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-devel  |  x86\_64  |  appstream  |  0\.14\.5\-1\.amzn2023\.0\.3  | 
|  appstream\-data  |  noarch  |  appstream\-data  |  34\-3\.amzn2023\.0\.2  | 
|  apr  |  aarch64  |  apr  |  1\.7\.2\-2\.amzn2023\.0\.2  | 
|  apr  |  x86\_64  |  apr  |  1\.7\.2\-2\.amzn2023\.0\.2  | 
|  apr\-devel  |  aarch64  |  apr  |  1\.7\.2\-2\.amzn2023\.0\.2  | 
|  apr\-devel  |  x86\_64  |  apr  |  1\.7\.2\-2\.amzn2023\.0\.2  | 
|  apr\-util  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-devel  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-devel  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-ldap  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-ldap  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-mysql  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-mysql  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-odbc  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-odbc  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-openssl  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-openssl  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-pgsql  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-pgsql  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-sqlite  |  aarch64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  apr\-util\-sqlite  |  x86\_64  |  apr\-util  |  1\.6\.3\-1\.amzn2023\.0\.1  | 
|  aqute\-bnd  |  noarch  |  aqute\-bnd  |  5\.2\.0\-9\.amzn2023\.0\.3  | 
|  aqute\-bnd\-javadoc  |  noarch  |  aqute\-bnd  |  5\.2\.0\-9\.amzn2023\.0\.3  | 
|  aqute\-bndlib  |  noarch  |  aqute\-bnd  |  5\.2\.0\-9\.amzn2023\.0\.3  | 
|  bnd\-maven\-plugin  |  noarch  |  aqute\-bnd  |  5\.2\.0\-9\.amzn2023\.0\.3  | 
|  argon2  |  aarch64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  argon2  |  x86\_64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  libargon2  |  aarch64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  libargon2  |  x86\_64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  libargon2\-devel  |  aarch64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  libargon2\-devel  |  x86\_64  |  argon2  |  20171227\-9\.amzn2023\.0\.2  | 
|  args4j  |  noarch  |  args4j  |  2\.33\-19\.amzn2023\.0\.1  | 
|  args4j\-javadoc  |  noarch  |  args4j  |  2\.33\-19\.amzn2023\.0\.1  | 
|  asciidoc  |  noarch  |  asciidoc  |  9\.1\.0\-1\.amzn2023\.0\.2  | 
|  asciidoc\-doc  |  noarch  |  asciidoc  |  9\.1\.0\-1\.amzn2023\.0\.2  | 
|  asciidoc\-latex  |  noarch  |  asciidoc  |  9\.1\.0\-1\.amzn2023\.0\.2  | 
|  aspell  |  aarch64  |  aspell  |  0\.60\.8\-7\.amzn2023\.0\.2  | 
|  aspell  |  x86\_64  |  aspell  |  0\.60\.8\-7\.amzn2023\.0\.2  | 
|  aspell\-devel  |  aarch64  |  aspell  |  0\.60\.8\-7\.amzn2023\.0\.2  | 
|  aspell\-devel  |  x86\_64  |  aspell  |  0\.60\.8\-7\.amzn2023\.0\.2  | 
|  aspell\-en  |  aarch64  |  aspell\-en  |  2020\.12\.07\-3\.amzn2023\.0\.2  | 
|  aspell\-en  |  x86\_64  |  aspell\-en  |  2020\.12\.07\-3\.amzn2023\.0\.2  | 
|  assertj\-core  |  noarch  |  assertj\-core  |  3\.19\.0\-5\.amzn2023\.0\.3  | 
|  assertj\-core\-javadoc  |  noarch  |  assertj\-core  |  3\.19\.0\-5\.amzn2023\.0\.3  | 
|  at  |  aarch64  |  at  |  3\.1\.23\-6\.amzn2023\.0\.2  | 
|  at  |  x86\_64  |  at  |  3\.1\.23\-6\.amzn2023\.0\.2  | 
|  atf\-tests  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  atf\-tests  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\+\+  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\+\+  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\+\+\-devel  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\+\+\-devel  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\-devel  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-c\-devel  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-sh  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-sh  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-sh\-devel  |  aarch64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  libatf\-sh\-devel  |  x86\_64  |  atf  |  0\.20\-17\.amzn2023\.0\.2  | 
|  atinject  |  noarch  |  atinject  |  1\.0\.5\-3\.amzn2023\.0\.3  | 
|  atinject\-javadoc  |  noarch  |  atinject  |  1\.0\.5\-3\.amzn2023\.0\.3  | 
|  atk  |  aarch64  |  atk  |  2\.36\.0\-3\.amzn2023\.0\.2  | 
|  atk  |  x86\_64  |  atk  |  2\.36\.0\-3\.amzn2023\.0\.2  | 
|  atk\-devel  |  aarch64  |  atk  |  2\.36\.0\-3\.amzn2023\.0\.2  | 
|  atk\-devel  |  x86\_64  |  atk  |  2\.36\.0\-3\.amzn2023\.0\.2  | 
|  atkmm  |  aarch64  |  atkmm  |  2\.28\.2\-1\.amzn2023\.0\.2  | 
|  atkmm  |  x86\_64  |  atkmm  |  2\.28\.2\-1\.amzn2023\.0\.2  | 
|  atkmm\-devel  |  aarch64  |  atkmm  |  2\.28\.2\-1\.amzn2023\.0\.2  | 
|  atkmm\-devel  |  x86\_64  |  atkmm  |  2\.28\.2\-1\.amzn2023\.0\.2  | 
|  atkmm\-doc  |  noarch  |  atkmm  |  2\.28\.2\-1\.amzn2023\.0\.2  | 
|  atlas  |  aarch64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-corei2  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-corei2\-devel  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-corei2\-static  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-devel  |  aarch64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-devel  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-static  |  aarch64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  atlas\-static  |  x86\_64  |  atlas  |  3\.10\.3\-18\.amzn2023\.0\.2  | 
|  at\-spi2\-atk  |  aarch64  |  at\-spi2\-atk  |  2\.38\.0\-2\.amzn2023\.0\.2  | 
|  at\-spi2\-atk  |  x86\_64  |  at\-spi2\-atk  |  2\.38\.0\-2\.amzn2023\.0\.2  | 
|  at\-spi2\-atk\-devel  |  aarch64  |  at\-spi2\-atk  |  2\.38\.0\-2\.amzn2023\.0\.2  | 
|  at\-spi2\-atk\-devel  |  x86\_64  |  at\-spi2\-atk  |  2\.38\.0\-2\.amzn2023\.0\.2  | 
|  at\-spi2\-core  |  aarch64  |  at\-spi2\-core  |  2\.40\.3\-1\.amzn2023\.0\.1  | 
|  at\-spi2\-core  |  x86\_64  |  at\-spi2\-core  |  2\.40\.3\-1\.amzn2023\.0\.1  | 
|  at\-spi2\-core\-devel  |  aarch64  |  at\-spi2\-core  |  2\.40\.3\-1\.amzn2023\.0\.1  | 
|  at\-spi2\-core\-devel  |  x86\_64  |  at\-spi2\-core  |  2\.40\.3\-1\.amzn2023\.0\.1  | 
|  attr  |  aarch64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  attr  |  x86\_64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  libattr  |  aarch64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  libattr  |  x86\_64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  libattr\-devel  |  aarch64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  libattr\-devel  |  x86\_64  |  attr  |  2\.5\.1\-3\.amzn2023\.0\.2  | 
|  audispd\-plugins  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audispd\-plugins  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audispd\-plugins\-zos  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audispd\-plugins\-zos  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit\-libs  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit\-libs  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit\-libs\-devel  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  audit\-libs\-devel  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  python3\-audit  |  aarch64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  python3\-audit  |  x86\_64  |  audit  |  3\.0\.6\-1\.amzn2023\.0\.2  | 
|  augeas  |  aarch64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas  |  x86\_64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-devel  |  aarch64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-devel  |  x86\_64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-libs  |  aarch64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-libs  |  x86\_64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-static  |  aarch64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  augeas\-static  |  x86\_64  |  augeas  |  1\.13\.0\-1\.amzn2023\.0\.2  | 
|  authselect  |  aarch64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect  |  x86\_64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-compat  |  aarch64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-compat  |  x86\_64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-devel  |  aarch64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-devel  |  x86\_64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-libs  |  aarch64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  authselect\-libs  |  x86\_64  |  authselect  |  1\.2\.3\-1\.amzn2023\.0\.2  | 
|  autoconf  |  noarch  |  autoconf  |  2\.69\-36\.amzn2023\.0\.3  | 
|  autoconf\-archive  |  noarch  |  autoconf\-archive  |  2019\.01\.06\-7\.amzn2023\.0\.2  | 
|  autofs  |  aarch64  |  autofs  |  5\.1\.7\-21\.amzn2023\.0\.3  | 
|  autofs  |  x86\_64  |  autofs  |  5\.1\.7\-21\.amzn2023\.0\.3  | 
|  automake  |  noarch  |  automake  |  1\.16\.5\-9\.amzn2023\.0\.3  | 
|  autotrace  |  aarch64  |  autotrace  |  0\.31\.9\-86\.amzn2023\.0\.1  | 
|  autotrace  |  x86\_64  |  autotrace  |  0\.31\.9\-86\.amzn2023\.0\.1  | 
|  autotrace\-devel  |  aarch64  |  autotrace  |  0\.31\.9\-86\.amzn2023\.0\.1  | 
|  autotrace\-devel  |  x86\_64  |  autotrace  |  0\.31\.9\-86\.amzn2023\.0\.1  | 
|  avahi  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-autoipd  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-autoipd  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-howl  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-howl  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-howl\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-howl\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-libdns\_sd  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-libdns\_sd  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-libdns\_sd\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-compat\-libdns\_sd\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-dnsconfd  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-dnsconfd  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-glib  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-glib  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-glib\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-glib\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-gobject  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-gobject  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-gobject\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-gobject\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-libs  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-libs  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-tools  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-tools  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-ui\-devel  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-ui\-devel  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-ui\-gtk3  |  aarch64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  avahi\-ui\-gtk3  |  x86\_64  |  avahi  |  0\.8\-14\.amzn2023\.0\.7  | 
|  aws\-cfn\-bootstrap  |  noarch  |  aws\-cfn\-bootstrap  |  2\.0\-23\.amzn2023  | 
|  awscli\-2  |  noarch  |  awscli\-2  |  2\.9\.19\-1\.amzn2023\.0\.1  | 
|  aws\-kinesis\-agent  |  noarch  |  aws\-kinesis\-agent  |  2\.0\.8\-2\.amzn2023  | 
|  aws\-nitro\-enclaves\-acm  |  aarch64  |  aws\-nitro\-enclaves\-acm  |  1\.2\.0\-2\.amzn2023  | 
|  aws\-nitro\-enclaves\-acm  |  x86\_64  |  aws\-nitro\-enclaves\-acm  |  1\.2\.0\-1\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli  |  aarch64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli  |  x86\_64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli\-devel  |  aarch64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli\-devel  |  x86\_64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli\-integration\-tests  |  aarch64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  aws\-nitro\-enclaves\-cli\-integration\-tests  |  x86\_64  |  aws\-nitro\-enclaves\-cli  |  1\.2\.2\-0\.amzn2023  | 
|  babel  |  noarch  |  babel  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  babel\-doc  |  noarch  |  babel  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  python3\-babel  |  noarch  |  babel  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  babeltrace  |  aarch64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  babeltrace  |  x86\_64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  libbabeltrace  |  aarch64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  libbabeltrace  |  x86\_64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  libbabeltrace\-devel  |  aarch64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  libbabeltrace\-devel  |  x86\_64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  python3\-babeltrace  |  aarch64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  python3\-babeltrace  |  x86\_64  |  babeltrace  |  1\.5\.8\-6\.amzn2023\.0\.2  | 
|  baekmuk\-ttf\-batang\-fonts  |  noarch  |  baekmuk\-ttf\-fonts  |  2\.2\-54\.amzn2023\.0\.2  | 
|  baekmuk\-ttf\-dotum\-fonts  |  noarch  |  baekmuk\-ttf\-fonts  |  2\.2\-54\.amzn2023\.0\.2  | 
|  baekmuk\-ttf\-fonts\-common  |  noarch  |  baekmuk\-ttf\-fonts  |  2\.2\-54\.amzn2023\.0\.2  | 
|  baekmuk\-ttf\-gulim\-fonts  |  noarch  |  baekmuk\-ttf\-fonts  |  2\.2\-54\.amzn2023\.0\.2  | 
|  baekmuk\-ttf\-hline\-fonts  |  noarch  |  baekmuk\-ttf\-fonts  |  2\.2\-54\.amzn2023\.0\.2  | 
|  basesystem  |  noarch  |  basesystem  |  11\-11\.amzn2023\.0\.2  | 
|  bash  |  aarch64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash  |  x86\_64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash\-devel  |  aarch64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash\-devel  |  x86\_64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash\-doc  |  aarch64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash\-doc  |  x86\_64  |  bash  |  5\.2\.15\-1\.amzn2023\.0\.2  | 
|  bash\-completion  |  noarch  |  bash\-completion  |  2\.11\-2\.amzn2023\.0\.2  | 
|  bc  |  aarch64  |  bc  |  1\.07\.1\-14\.amzn2023\.0\.2  | 
|  bc  |  x86\_64  |  bc  |  1\.07\.1\-14\.amzn2023\.0\.2  | 
|  bcache\-tools  |  aarch64  |  bcache\-tools  |  1\.1\-0\.amzn2023\.0\.2  | 
|  bcache\-tools  |  x86\_64  |  bcache\-tools  |  1\.1\-0\.amzn2023\.0\.2  | 
|  bcc  |  aarch64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc  |  x86\_64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc\-devel  |  aarch64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc\-devel  |  x86\_64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc\-doc  |  noarch  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc\-tools  |  aarch64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcc\-tools  |  x86\_64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  libbpf\-tools  |  aarch64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  libbpf\-tools  |  x86\_64  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  python3\-bcc  |  noarch  |  bcc  |  0\.26\.0\-1\.amzn2023\.0\.1  | 
|  bcel  |  noarch  |  bcel  |  6\.5\.0\-3\.amzn2023\.0\.2  | 
|  bcel\-javadoc  |  noarch  |  bcel  |  6\.5\.0\-3\.amzn2023\.0\.2  | 
|  bdftopcf  |  aarch64  |  bdftopcf  |  1\.1\-2\.amzn2023\.0\.2  | 
|  bdftopcf  |  x86\_64  |  bdftopcf  |  1\.1\-2\.amzn2023\.0\.2  | 
|  beakerlib  |  noarch  |  beakerlib  |  1\.28\-1\.amzn2023\.0\.2  | 
|  beakerlib\-vim\-syntax  |  noarch  |  beakerlib  |  1\.28\-1\.amzn2023\.0\.2  | 
|  beust\-jcommander  |  noarch  |  beust\-jcommander  |  1\.78\-9\.amzn2023\.0\.3  | 
|  beust\-jcommander\-javadoc  |  noarch  |  beust\-jcommander  |  1\.78\-9\.amzn2023\.0\.3  | 
|  biber  |  noarch  |  biber  |  2\.17\-5\.amzn2023\.0\.2  | 
|  biber\-tests  |  noarch  |  biber  |  2\.17\-5\.amzn2023\.0\.2  | 
|  bind  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-chroot  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-chroot  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-devel  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-devel  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-filesystem  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-filesystem  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-ldap  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-ldap  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-mysql  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-mysql  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-sqlite3  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dlz\-sqlite3  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dnssec\-doc  |  noarch  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dnssec\-utils  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-dnssec\-utils  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-doc  |  noarch  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-libs  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-libs  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-license  |  noarch  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-devel  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-devel  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-libs  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-libs  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-utils  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-pkcs11\-utils  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-utils  |  aarch64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  bind\-utils  |  x86\_64  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  python3\-bind  |  noarch  |  bind  |  9\.16\.42\-1\.amzn2023\.0\.1  | 
|  binutils  |  aarch64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  binutils  |  x86\_64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  binutils\-devel  |  aarch64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  binutils\-devel  |  x86\_64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  binutils\-gprofng  |  aarch64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  binutils\-gprofng  |  x86\_64  |  binutils  |  2\.39\-6\.amzn2023\.0\.7  | 
|  bison  |  aarch64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bison  |  x86\_64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bison\-devel  |  aarch64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bison\-devel  |  x86\_64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bison\-runtime  |  aarch64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bison\-runtime  |  x86\_64  |  bison  |  3\.7\.4\-2\.amzn2023\.0\.2  | 
|  bitstream\-vera\-fonts\-all  |  noarch  |  bitstream\-vera\-fonts  |  1\.10\-44\.amzn2023\.0\.2  | 
|  bitstream\-vera\-sans\-fonts  |  noarch  |  bitstream\-vera\-fonts  |  1\.10\-44\.amzn2023\.0\.2  | 
|  bitstream\-vera\-sans\-mono\-fonts  |  noarch  |  bitstream\-vera\-fonts  |  1\.10\-44\.amzn2023\.0\.2  | 
|  bitstream\-vera\-serif\-fonts  |  noarch  |  bitstream\-vera\-fonts  |  1\.10\-44\.amzn2023\.0\.2  | 
|  blis  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-devel  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-devel  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-openmp  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-openmp  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-openmp64  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-openmp64  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-serial64  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-serial64  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-srpm\-macros  |  noarch  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-threads  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-threads  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-threads64  |  aarch64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blis\-threads64  |  x86\_64  |  blis  |  0\.7\.0\-7\.amzn2023\.0\.2  | 
|  blktrace  |  aarch64  |  blktrace  |  1\.2\.0\-17\.amzn2023\.0\.2  | 
|  blktrace  |  x86\_64  |  blktrace  |  1\.2\.0\-17\.amzn2023\.0\.2  | 
|  iowatcher  |  aarch64  |  blktrace  |  1\.2\.0\-17\.amzn2023\.0\.2  | 
|  iowatcher  |  x86\_64  |  blktrace  |  1\.2\.0\-17\.amzn2023\.0\.2  | 
|  bluez  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-cups  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-cups  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-deprecated  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-deprecated  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-hid2hci  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-hid2hci  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-libs  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-libs  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-libs\-devel  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-libs\-devel  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-mesh  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-mesh  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-obexd  |  aarch64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  bluez\-obexd  |  x86\_64  |  bluez  |  5\.62\-2\.amzn2023\.0\.4  | 
|  boost  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-atomic  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-atomic  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-b2  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-b2  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-build  |  noarch  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-chrono  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-chrono  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-container  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-container  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-context  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-context  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-contract  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-contract  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-coroutine  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-coroutine  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-date\-time  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-date\-time  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-devel  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-devel  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-doc  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-doc  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-doctools  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-doctools  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-examples  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-examples  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-fiber  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-fiber  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-filesystem  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-filesystem  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph\-mpich  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph\-mpich  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph\-openmpi  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-graph\-openmpi  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-iostreams  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-iostreams  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-json  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-json  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-locale  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-locale  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-log  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-log  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-math  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-math  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-devel  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-devel  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-python3  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-python3  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-python3\-devel  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-mpich\-python3\-devel  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-nowide  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-nowide  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-numpy3  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-numpy3  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-devel  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-devel  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-python3  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-python3  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-python3\-devel  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-openmpi\-python3\-devel  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-program\-options  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-program\-options  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-python3  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-python3  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-random  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-random  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-regex  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-regex  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-serialization  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-serialization  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-stacktrace  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-stacktrace  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-static  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-static  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-system  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-system  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-test  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-test  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-thread  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-thread  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-timer  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-timer  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-type\_erasure  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-type\_erasure  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-wave  |  aarch64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  boost\-wave  |  x86\_64  |  boost  |  1\.75\.0\-4\.amzn2023\.0\.2  | 
|  bouncycastle  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-javadoc  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-mail  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-pg  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-pkix  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-tls  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bouncycastle\-util  |  noarch  |  bouncycastle  |  1\.70\-4\.amzn2023\.0\.2  | 
|  bpftrace  |  aarch64  |  bpftrace  |  0\.17\.0\-1\.amzn2023  | 
|  bpftrace  |  x86\_64  |  bpftrace  |  0\.17\.0\-1\.amzn2023  | 
|  brotli  |  aarch64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  brotli  |  x86\_64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  brotli\-devel  |  aarch64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  brotli\-devel  |  x86\_64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  libbrotli  |  aarch64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  libbrotli  |  x86\_64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  python3\-brotli  |  aarch64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  python3\-brotli  |  x86\_64  |  brotli  |  1\.0\.9\-4\.amzn2023\.0\.2  | 
|  bsf  |  noarch  |  bsf  |  2\.4\.0\-44\.amzn2023\.0\.2  | 
|  bsh  |  noarch  |  bsh  |  2\.1\.0\-5\.amzn2023\.0\.2  | 
|  bsh\-javadoc  |  noarch  |  bsh  |  2\.1\.0\-5\.amzn2023\.0\.2  | 
|  bsh\-manual  |  noarch  |  bsh  |  2\.1\.0\-5\.amzn2023\.0\.2  | 
|  bubblewrap  |  aarch64  |  bubblewrap  |  0\.4\.1\-3\.amzn2023\.0\.2  | 
|  bubblewrap  |  x86\_64  |  bubblewrap  |  0\.4\.1\-3\.amzn2023\.0\.2  | 
|  byacc  |  aarch64  |  byacc  |  2\.0\.20210109\-2\.amzn2023\.0\.3  | 
|  byacc  |  x86\_64  |  byacc  |  2\.0\.20210109\-2\.amzn2023\.0\.3  | 
|  byaccj  |  aarch64  |  byaccj  |  1\.15\-25\.amzn2023\.0\.2  | 
|  byaccj  |  x86\_64  |  byaccj  |  1\.15\-25\.amzn2023\.0\.2  | 
|  byte\-buddy  |  noarch  |  byte\-buddy  |  1\.12\.0\-3\.amzn2023\.0\.4  | 
|  byte\-buddy\-agent  |  noarch  |  byte\-buddy  |  1\.12\.0\-3\.amzn2023\.0\.4  | 
|  byte\-buddy\-javadoc  |  noarch  |  byte\-buddy  |  1\.12\.0\-3\.amzn2023\.0\.4  | 
|  byte\-buddy\-maven\-plugin  |  noarch  |  byte\-buddy  |  1\.12\.0\-3\.amzn2023\.0\.4  | 
|  byte\-buddy\-parent  |  noarch  |  byte\-buddy  |  1\.12\.0\-3\.amzn2023\.0\.4  | 
|  byteman  |  noarch  |  byteman  |  4\.0\.16\-4\.amzn2023\.0\.3  | 
|  byteman\-bmunit  |  noarch  |  byteman  |  4\.0\.16\-4\.amzn2023\.0\.3  | 
|  byteman\-dtest  |  noarch  |  byteman  |  4\.0\.16\-4\.amzn2023\.0\.3  | 
|  byteman\-javadoc  |  noarch  |  byteman  |  4\.0\.16\-4\.amzn2023\.0\.3  | 
|  byteman\-rulecheck\-maven\-plugin  |  noarch  |  byteman  |  4\.0\.16\-4\.amzn2023\.0\.3  | 
|  bzip2  |  aarch64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2  |  x86\_64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-devel  |  aarch64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-devel  |  x86\_64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-libs  |  aarch64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-libs  |  x86\_64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-static  |  aarch64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  bzip2\-static  |  x86\_64  |  bzip2  |  1\.0\.8\-6\.amzn2023\.0\.2  | 
|  ca\-certificates  |  noarch  |  ca\-certificates  |  2023\.2\.60\-1\.0\.amzn2023\.0\.2  | 
|  cairo  |  aarch64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo  |  x86\_64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-devel  |  aarch64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-devel  |  x86\_64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-gobject  |  aarch64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-gobject  |  x86\_64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-gobject\-devel  |  aarch64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-gobject\-devel  |  x86\_64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-tools  |  aarch64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairo\-tools  |  x86\_64  |  cairo  |  1\.17\.4\-3\.amzn2023\.0\.2  | 
|  cairomm  |  aarch64  |  cairomm  |  1\.14\.2\-116\.amzn2023\.0\.2  | 
|  cairomm  |  x86\_64  |  cairomm  |  1\.14\.2\-116\.amzn2023\.0\.2  | 
|  cairomm\-devel  |  aarch64  |  cairomm  |  1\.14\.2\-116\.amzn2023\.0\.2  | 
|  cairomm\-devel  |  x86\_64  |  cairomm  |  1\.14\.2\-116\.amzn2023\.0\.2  | 
|  cairomm\-doc  |  noarch  |  cairomm  |  1\.14\.2\-116\.amzn2023\.0\.2  | 
|  capstone  |  aarch64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  capstone  |  x86\_64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  capstone\-devel  |  aarch64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  capstone\-devel  |  x86\_64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  capstone\-java  |  noarch  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  python3\-capstone  |  aarch64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  python3\-capstone  |  x86\_64  |  capstone  |  4\.0\.2\-9\.amzn2023\.0\.3  | 
|  c\-ares  |  aarch64  |  c\-ares  |  1\.19\.0\-1\.amzn2023  | 
|  c\-ares  |  x86\_64  |  c\-ares  |  1\.19\.0\-1\.amzn2023  | 
|  c\-ares\-devel  |  aarch64  |  c\-ares  |  1\.19\.0\-1\.amzn2023  | 
|  c\-ares\-devel  |  x86\_64  |  c\-ares  |  1\.19\.0\-1\.amzn2023  | 
|  cdi\-api  |  noarch  |  cdi\-api  |  2\.0\.2\-6\.amzn2023\.0\.3  | 
|  cdi\-api\-javadoc  |  noarch  |  cdi\-api  |  2\.0\.2\-6\.amzn2023\.0\.3  | 
|  cereal\-devel  |  aarch64  |  cereal  |  1\.3\.2\-1\.amzn2023\.0\.2  | 
|  cereal\-devel  |  x86\_64  |  cereal  |  1\.3\.2\-1\.amzn2023\.0\.2  | 
|  cglib  |  noarch  |  cglib  |  3\.3\.0\-7\.amzn2023\.0\.3  | 
|  cglib\-javadoc  |  noarch  |  cglib  |  3\.3\.0\-7\.amzn2023\.0\.3  | 
|  check  |  aarch64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check  |  x86\_64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check\-checkmk  |  noarch  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check\-devel  |  aarch64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check\-devel  |  x86\_64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check\-static  |  aarch64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  check\-static  |  x86\_64  |  check  |  0\.15\.2\-5\.amzn2023\.0\.3  | 
|  checkpolicy  |  aarch64  |  checkpolicy  |  3\.4\-3\.amzn2023\.0\.2  | 
|  checkpolicy  |  x86\_64  |  checkpolicy  |  3\.4\-3\.amzn2023\.0\.2  | 
|  checksec  |  noarch  |  checksec  |  2\.4\.0\-2\.amzn2023\.0\.2  | 
|  alternatives  |  aarch64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  alternatives  |  x86\_64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  chkconfig  |  aarch64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  chkconfig  |  x86\_64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  ntsysv  |  aarch64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  ntsysv  |  x86\_64  |  chkconfig  |  1\.15\-2\.amzn2023\.0\.2  | 
|  chkrootkit  |  aarch64  |  chkrootkit  |  0\.55\-3\.amzn2023\.0\.4  | 
|  chkrootkit  |  x86\_64  |  chkrootkit  |  0\.55\-3\.amzn2023\.0\.4  | 
|  amazon\-chrony\-config  |  noarch  |  chrony  |  4\.3\-1\.amzn2023\.0\.4  | 
|  chrony  |  aarch64  |  chrony  |  4\.3\-1\.amzn2023\.0\.4  | 
|  chrony  |  x86\_64  |  chrony  |  4\.3\-1\.amzn2023\.0\.4  | 
|  chrpath  |  aarch64  |  chrpath  |  0\.16\-15\.amzn2023\.0\.2  | 
|  chrpath  |  x86\_64  |  chrpath  |  0\.16\-15\.amzn2023\.0\.2  | 
|  cifs\-utils  |  aarch64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cifs\-utils  |  x86\_64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cifs\-utils\-devel  |  aarch64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cifs\-utils\-devel  |  x86\_64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cifs\-utils\-info  |  aarch64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cifs\-utils\-info  |  x86\_64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  pam\_cifscreds  |  aarch64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  pam\_cifscreds  |  x86\_64  |  cifs\-utils  |  6\.15\-1\.amzn2023\.0\.2  | 
|  cjkuni\-uming\-fonts  |  noarch  |  cjkuni\-uming\-fonts  |  0\.2\.20080216\.1\-66\.amzn2023\.0\.2  | 
|  clamav  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-data  |  noarch  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-devel  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-devel  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-doc  |  noarch  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-filesystem  |  noarch  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-lib  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-lib  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-milter  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-milter  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-update  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamav\-update  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamd  |  aarch64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clamd  |  x86\_64  |  clamav  |  0\.103\.8\-1\.amzn2023\.0\.2  | 
|  clang  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-analyzer  |  noarch  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-devel  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-devel  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-libs  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-libs  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-resource\-filesystem  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-resource\-filesystem  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-tools\-extra  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-tools\-extra  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-tools\-extra\-devel  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  clang\-tools\-extra\-devel  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  git\-clang\-format  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  git\-clang\-format  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  python3\-clang  |  aarch64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  python3\-clang  |  x86\_64  |  clang  |  15\.0\.6\-3\.amzn2023\.0\.2  | 
|  cldr\-emoji\-annotation  |  noarch  |  cldr\-emoji\-annotation  |  39\-1\.amzn2023\.0\.2  | 
|  cldr\-emoji\-annotation\-devel  |  noarch  |  cldr\-emoji\-annotation  |  39\-1\.amzn2023\.0\.2  | 
|  cldr\-emoji\-annotation\-dtd  |  noarch  |  cldr\-emoji\-annotation  |  39\-1\.amzn2023\.0\.2  | 
|  cloud\-init  |  noarch  |  cloud\-init  |  22\.2\.2\-1\.amzn2023\.1\.8  | 
|  cloud\-utils\-growpart  |  aarch64  |  cloud\-utils  |  0\.31\-8\.amzn2023\.0\.3  | 
|  cloud\-utils\-growpart  |  x86\_64  |  cloud\-utils  |  0\.31\-8\.amzn2023\.0\.3  | 
|  cmake  |  aarch64  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake  |  x86\_64  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake\-data  |  noarch  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake\-doc  |  noarch  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake\-filesystem  |  aarch64  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake\-filesystem  |  x86\_64  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  cmake\-rpm\-macros  |  noarch  |  cmake  |  3\.22\.2\-1\.amzn2023\.0\.4  | 
|  libcmocka  |  aarch64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  libcmocka  |  x86\_64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  libcmocka\-devel  |  aarch64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  libcmocka\-devel  |  x86\_64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  libcmocka\-static  |  aarch64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  libcmocka\-static  |  x86\_64  |  cmocka  |  1\.1\.5\-8\.amzn2023\.0\.2  | 
|  cni\-plugins  |  aarch64  |  cni\-plugins  |  1\.2\.0\-1\.amzn2023\.0\.1  | 
|  cni\-plugins  |  x86\_64  |  cni\-plugins  |  1\.2\.0\-1\.amzn2023\.0\.1  | 
|  codehaus\-parent  |  noarch  |  codehaus\-parent  |  4\-23\.amzn2023\.0\.2  | 
|  collectd  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-apache  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-apache  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-bind  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-bind  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-ceph  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-ceph  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-chrony  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-chrony  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl\_json  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl\_json  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl\_xml  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-curl\_xml  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-dbi  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-dbi  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-disk  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-disk  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-dns  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-dns  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-drbd  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-drbd  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-email  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-email  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-generic\-jmx  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-generic\-jmx  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-hugepages  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-hugepages  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-iptables  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-iptables  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-java  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-java  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-log\_logstash  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-log\_logstash  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-lua  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-lua  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mcelog  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mcelog  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mdevents  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mdevents  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mysql  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-mysql  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-netlink  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-netlink  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-nginx  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-nginx  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-notify\_desktop  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-notify\_desktop  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-notify\_email  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-notify\_email  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-openldap  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-openldap  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-postgresql  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-postgresql  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-python  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-python  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-rrdcached  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-rrdcached  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-rrdtool  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-rrdtool  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-sensors  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-sensors  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-smart  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-smart  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-synproxy  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-synproxy  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-utils  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-utils  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-web  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-web  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_http  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_http  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_prometheus  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_prometheus  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_sensu  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_sensu  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_syslog  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_syslog  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_tsdb  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-write\_tsdb  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-zookeeper  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  collectd\-zookeeper  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  libcollectdclient  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  libcollectdclient  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  libcollectdclient\-devel  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  libcollectdclient\-devel  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  perl\-Collectd  |  aarch64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  perl\-Collectd  |  x86\_64  |  collectd  |  5\.12\.0\-16\.amzn2023\.0\.2  | 
|  colm  |  aarch64  |  colm  |  0\.13\.0\.7\-4\.amzn2023\.0\.2  | 
|  colm  |  x86\_64  |  colm  |  0\.13\.0\.7\-4\.amzn2023\.0\.2  | 
|  colm\-devel  |  aarch64  |  colm  |  0\.13\.0\.7\-4\.amzn2023\.0\.2  | 
|  colm\-devel  |  x86\_64  |  colm  |  0\.13\.0\.7\-4\.amzn2023\.0\.2  | 
|  colord  |  aarch64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord  |  x86\_64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-devel  |  aarch64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-devel  |  x86\_64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-devel\-docs  |  noarch  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-extra\-profiles  |  noarch  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-libs  |  aarch64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-libs  |  x86\_64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-tests  |  aarch64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  colord\-tests  |  x86\_64  |  colord  |  1\.4\.5\-2\.amzn2023\.0\.2  | 
|  color\-filesystem  |  noarch  |  color\-filesystem  |  1\-26\.amzn2023\.0\.2  | 
|  compiler\-rt  |  aarch64  |  compiler\-rt  |  15\.0\.6\-2\.amzn2023\.0\.1  | 
|  compiler\-rt  |  x86\_64  |  compiler\-rt  |  15\.0\.6\-2\.amzn2023\.0\.1  | 
|  conntrack\-tools  |  aarch64  |  conntrack\-tools  |  1\.4\.6\-2\.amzn2023\.0\.2  | 
|  conntrack\-tools  |  x86\_64  |  conntrack\-tools  |  1\.4\.6\-2\.amzn2023\.0\.2  | 
|  bdf2psf  |  noarch  |  console\-setup  |  1\.200\-2\.amzn2023\.0\.2  | 
|  console\-setup  |  noarch  |  console\-setup  |  1\.200\-2\.amzn2023\.0\.2  | 
|  containerd  |  aarch64  |  containerd  |  1\.7\.2\-1\.amzn2023\.0\.1  | 
|  containerd  |  x86\_64  |  containerd  |  1\.7\.2\-1\.amzn2023\.0\.1  | 
|  containerd\-stress  |  aarch64  |  containerd  |  1\.7\.2\-1\.amzn2023\.0\.1  | 
|  containerd\-stress  |  x86\_64  |  containerd  |  1\.7\.2\-1\.amzn2023\.0\.1  | 
|  container\-selinux  |  noarch  |  container\-selinux  |  2\.189\.0\-289\.amzn2023\.0\.2  | 
|  copy\-jdk\-configs  |  noarch  |  copy\-jdk\-configs  |  4\.0\-1\.amzn2023\.0\.2  | 
|  coreutils  |  aarch64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  coreutils  |  x86\_64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  coreutils\-common  |  aarch64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  coreutils\-common  |  x86\_64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  coreutils\-single  |  aarch64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  coreutils\-single  |  x86\_64  |  coreutils  |  8\.32\-30\.amzn2023\.0\.3  | 
|  cowsay  |  noarch  |  cowsay  |  3\.04\-17\.amzn2023\.0\.2  | 
|  cpio  |  aarch64  |  cpio  |  2\.13\-13\.amzn2023\.0\.2  | 
|  cpio  |  x86\_64  |  cpio  |  2\.13\-13\.amzn2023\.0\.2  | 
|  cppcheck  |  aarch64  |  cppcheck  |  2\.7\.4\-2\.amzn2023\.0\.3  | 
|  cppcheck  |  x86\_64  |  cppcheck  |  2\.7\.4\-2\.amzn2023\.0\.3  | 
|  cppcheck\-htmlreport  |  aarch64  |  cppcheck  |  2\.7\.4\-2\.amzn2023\.0\.3  | 
|  cppcheck\-htmlreport  |  x86\_64  |  cppcheck  |  2\.7\.4\-2\.amzn2023\.0\.3  | 
|  cppunit  |  aarch64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cppunit  |  x86\_64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cppunit\-devel  |  aarch64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cppunit\-devel  |  x86\_64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cppunit\-doc  |  aarch64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cppunit\-doc  |  x86\_64  |  cppunit  |  1\.15\.1\-5\.amzn2023\.0\.2  | 
|  cpuid  |  x86\_64  |  cpuid  |  20230120\-70\.amzn2023  | 
|  cracklib  |  aarch64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  cracklib  |  x86\_64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  cracklib\-devel  |  aarch64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  cracklib\-devel  |  x86\_64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  cracklib\-dicts  |  aarch64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  cracklib\-dicts  |  x86\_64  |  cracklib  |  2\.9\.6\-27\.amzn2023\.0\.2  | 
|  crash  |  aarch64  |  crash  |  8\.0\.2\-3\.amzn2023\.0\.1  | 
|  crash  |  x86\_64  |  crash  |  8\.0\.2\-3\.amzn2023\.0\.1  | 
|  crash\-devel  |  aarch64  |  crash  |  8\.0\.2\-3\.amzn2023\.0\.1  | 
|  crash\-devel  |  x86\_64  |  crash  |  8\.0\.2\-3\.amzn2023\.0\.1  | 
|  createrepo\_c  |  aarch64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  createrepo\_c  |  x86\_64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  createrepo\_c\-devel  |  aarch64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  createrepo\_c\-devel  |  x86\_64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  createrepo\_c\-libs  |  aarch64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  createrepo\_c\-libs  |  x86\_64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  python3\-createrepo\_c  |  aarch64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  python3\-createrepo\_c  |  x86\_64  |  createrepo\_c  |  0\.20\.0\-1\.amzn2023\.0\.3  | 
|  credentials\-fetcher  |  aarch64  |  credentials\-fetcher  |  1\.2\.0\-1\.amzn2023  | 
|  credentials\-fetcher  |  x86\_64  |  credentials\-fetcher  |  1\.2\.0\-1\.amzn2023  | 
|  crit  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  crit  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-devel  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-devel  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-libs  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-libs  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-ns  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  criu\-ns  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  python3\-criu  |  aarch64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  python3\-criu  |  x86\_64  |  criu  |  3\.17\.1\-1\.amzn2023\.0\.3  | 
|  cronie  |  aarch64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  cronie  |  x86\_64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  cronie\-anacron  |  aarch64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  cronie\-anacron  |  x86\_64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  cronie\-noanacron  |  aarch64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  cronie\-noanacron  |  x86\_64  |  cronie  |  1\.5\.7\-1\.amzn2023\.0\.2  | 
|  crontabs  |  noarch  |  crontabs  |  1\.11\-24\.20190603git\.amzn2023\.0\.2  | 
|  crypto\-policies  |  noarch  |  crypto\-policies  |  20220428\-1\.gitdfb10ea\.amzn2023\.0\.2  | 
|  crypto\-policies\-scripts  |  noarch  |  crypto\-policies  |  20220428\-1\.gitdfb10ea\.amzn2023\.0\.2  | 
|  cryptsetup  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-devel  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-devel  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-libs  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-libs  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-ssh\-token  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cryptsetup\-ssh\-token  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  integritysetup  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  integritysetup  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  veritysetup  |  aarch64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  veritysetup  |  x86\_64  |  cryptsetup  |  2\.6\.1\-1\.amzn2023\.0\.1  | 
|  cscope  |  aarch64  |  cscope  |  15\.9\-15\.amzn2023\.0\.3  | 
|  cscope  |  x86\_64  |  cscope  |  15\.9\-15\.amzn2023\.0\.3  | 
|  csnappy  |  aarch64  |  csnappy  |  0\-20\.20191203gitcbd205b\.amzn2023\.0\.3  | 
|  csnappy  |  x86\_64  |  csnappy  |  0\-20\.20191203gitcbd205b\.amzn2023\.0\.3  | 
|  csnappy\-devel  |  aarch64  |  csnappy  |  0\-20\.20191203gitcbd205b\.amzn2023\.0\.3  | 
|  csnappy\-devel  |  x86\_64  |  csnappy  |  0\-20\.20191203gitcbd205b\.amzn2023\.0\.3  | 
|  ctags  |  aarch64  |  ctags  |  5\.9\-1\.20210725\.0\.amzn2023\.0\.2  | 
|  ctags  |  x86\_64  |  ctags  |  5\.9\-1\.20210725\.0\.amzn2023\.0\.2  | 
|  CUnit  |  aarch64  |  CUnit  |  2\.1\.3\-23\.amzn2023\.0\.2  | 
|  CUnit  |  x86\_64  |  CUnit  |  2\.1\.3\-23\.amzn2023\.0\.2  | 
|  CUnit\-devel  |  aarch64  |  CUnit  |  2\.1\.3\-23\.amzn2023\.0\.2  | 
|  CUnit\-devel  |  x86\_64  |  CUnit  |  2\.1\.3\-23\.amzn2023\.0\.2  | 
|  cups  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-client  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-client  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-devel  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-devel  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-filesystem  |  noarch  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-ipptool  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-ipptool  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-libs  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-libs  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-lpd  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-lpd  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-printerapp  |  aarch64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-printerapp  |  x86\_64  |  cups  |  2\.3\.3op2\-18\.amzn2023\.0\.5  | 
|  cups\-filters  |  aarch64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  cups\-filters  |  x86\_64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  cups\-filters\-devel  |  aarch64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  cups\-filters\-devel  |  x86\_64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  cups\-filters\-libs  |  aarch64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  cups\-filters\-libs  |  x86\_64  |  cups\-filters  |  1\.28\.16\-3\.amzn2023\.0\.1  | 
|  curl  |  aarch64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  curl  |  x86\_64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  curl\-minimal  |  aarch64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  curl\-minimal  |  x86\_64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl  |  aarch64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl  |  x86\_64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl\-devel  |  aarch64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl\-devel  |  x86\_64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl\-minimal  |  aarch64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  libcurl\-minimal  |  x86\_64  |  curl  |  8\.0\.1\-1\.amzn2023  | 
|  cvs  |  aarch64  |  cvs  |  1\.11\.23\-56\.amzn2023\.0\.3  | 
|  cvs  |  x86\_64  |  cvs  |  1\.11\.23\-56\.amzn2023\.0\.3  | 
|  cvs\-doc  |  noarch  |  cvs  |  1\.11\.23\-56\.amzn2023\.0\.3  | 
|  cvsps  |  aarch64  |  cvsps  |  2\.2\-0\.28\.b1\.amzn2023\.0\.2  | 
|  cvsps  |  x86\_64  |  cvsps  |  2\.2\-0\.28\.b1\.amzn2023\.0\.2  | 
|  cyrus\-sasl  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-devel  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-devel  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-gs2  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-gs2  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-gssapi  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-gssapi  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-ldap  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-ldap  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-lib  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-lib  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-md5  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-md5  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-ntlm  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-ntlm  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-plain  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-plain  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-scram  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-scram  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-sql  |  aarch64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  cyrus\-sasl\-sql  |  x86\_64  |  cyrus\-sasl  |  2\.1\.27\-18\.amzn2023\.0\.3  | 
|  emacs\-cython\-mode  |  noarch  |  Cython  |  0\.29\.21\-5\.amzn2023\.0\.2  | 
|  python3\-Cython  |  aarch64  |  Cython  |  0\.29\.21\-5\.amzn2023\.0\.2  | 
|  python3\-Cython  |  x86\_64  |  Cython  |  0\.29\.21\-5\.amzn2023\.0\.2  | 
|  daemonize  |  aarch64  |  daemonize  |  1\.7\.8\-5\.amzn2023  | 
|  daemonize  |  x86\_64  |  daemonize  |  1\.7\.8\-5\.amzn2023  | 
|  datefudge  |  aarch64  |  datefudge  |  1\.24\-2\.amzn2023\.0\.2  | 
|  datefudge  |  x86\_64  |  datefudge  |  1\.24\-2\.amzn2023\.0\.2  | 
|  dblatex  |  noarch  |  dblatex  |  0\.3\.12\-2\.amzn2023\.0\.2  | 
|  dbus  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-common  |  noarch  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-daemon  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-daemon  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-devel  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-devel  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-doc  |  noarch  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-libs  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-libs  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-tests  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-tests  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-tools  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-tools  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-x11  |  aarch64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-x11  |  x86\_64  |  dbus  |  1\.12\.28\-1\.amzn2023\.0\.1  | 
|  dbus\-broker  |  aarch64  |  dbus\-broker  |  32\-1\.amzn2023\.0\.2  | 
|  dbus\-broker  |  x86\_64  |  dbus\-broker  |  32\-1\.amzn2023\.0\.2  | 
|  dbus\-glib  |  aarch64  |  dbus\-glib  |  0\.110\-11\.amzn2023\.0\.2  | 
|  dbus\-glib  |  x86\_64  |  dbus\-glib  |  0\.110\-11\.amzn2023\.0\.2  | 
|  dbus\-glib\-devel  |  aarch64  |  dbus\-glib  |  0\.110\-11\.amzn2023\.0\.2  | 
|  dbus\-glib\-devel  |  x86\_64  |  dbus\-glib  |  0\.110\-11\.amzn2023\.0\.2  | 
|  dbus\-python\-devel  |  aarch64  |  dbus\-python  |  1\.2\.18\-1\.amzn2023\.0\.2  | 
|  dbus\-python\-devel  |  x86\_64  |  dbus\-python  |  1\.2\.18\-1\.amzn2023\.0\.2  | 
|  python3\-dbus  |  aarch64  |  dbus\-python  |  1\.2\.18\-1\.amzn2023\.0\.2  | 
|  python3\-dbus  |  x86\_64  |  dbus\-python  |  1\.2\.18\-1\.amzn2023\.0\.2  | 
|  dconf  |  aarch64  |  dconf  |  0\.40\.0\-3\.amzn2023\.0\.2  | 
|  dconf  |  x86\_64  |  dconf  |  0\.40\.0\-3\.amzn2023\.0\.2  | 
|  dconf\-devel  |  aarch64  |  dconf  |  0\.40\.0\-3\.amzn2023\.0\.2  | 
|  dconf\-devel  |  x86\_64  |  dconf  |  0\.40\.0\-3\.amzn2023\.0\.2  | 
|  debugedit  |  aarch64  |  debugedit  |  5\.0\-2\.amzn2023\.0\.2  | 
|  debugedit  |  x86\_64  |  debugedit  |  5\.0\-2\.amzn2023\.0\.2  | 
|  dejagnu  |  noarch  |  dejagnu  |  1\.6\.1\-9\.amzn2023\.0\.2  | 
|  dejavu\-fonts\-all  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-fonts\-doc  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-lgc\-fonts\-all  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-lgc\-sans\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-lgc\-sans\-mono\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-lgc\-serif\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-sans\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-sans\-mono\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  dejavu\-serif\-fonts  |  noarch  |  dejavu\-fonts  |  2\.37\-16\.amzn2023\.0\.2  | 
|  desktop\-file\-utils  |  aarch64  |  desktop\-file\-utils  |  0\.26\-3\.amzn2023\.0\.2  | 
|  desktop\-file\-utils  |  x86\_64  |  desktop\-file\-utils  |  0\.26\-3\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath\-devel  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath\-devel  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath\-libs  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-multipath\-libs  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  kpartx  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  kpartx  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  libdmmp  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  libdmmp  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  libdmmp\-devel  |  aarch64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  libdmmp\-devel  |  x86\_64  |  device\-mapper\-multipath  |  0\.8\.7\-16\.amzn2023\.0\.2  | 
|  device\-mapper\-persistent\-data  |  aarch64  |  device\-mapper\-persistent\-data  |  0\.9\.0\-7\.amzn2023\.0\.2  | 
|  device\-mapper\-persistent\-data  |  x86\_64  |  device\-mapper\-persistent\-data  |  0\.9\.0\-7\.amzn2023\.0\.2  | 
|  diffstat  |  aarch64  |  diffstat  |  1\.64\-4\.amzn2023\.0\.2  | 
|  diffstat  |  x86\_64  |  diffstat  |  1\.64\-4\.amzn2023\.0\.2  | 
|  diffutils  |  aarch64  |  diffutils  |  3\.8\-1\.amzn2023\.0\.2  | 
|  diffutils  |  x86\_64  |  diffutils  |  3\.8\-1\.amzn2023\.0\.2  | 
|  libbasicobjects  |  aarch64  |  ding\-libs  |  0\.1\.1\-47\.amzn2023\.0\.2  | 
|  libbasicobjects  |  x86\_64  |  ding\-libs  |  0\.1\.1\-47\.amzn2023\.0\.2  | 
|  libbasicobjects\-devel  |  aarch64  |  ding\-libs  |  0\.1\.1\-47\.amzn2023\.0\.2  | 
|  libbasicobjects\-devel  |  x86\_64  |  ding\-libs  |  0\.1\.1\-47\.amzn2023\.0\.2  | 
|  libcollection  |  aarch64  |  ding\-libs  |  0\.7\.0\-47\.amzn2023\.0\.2  | 
|  libcollection  |  x86\_64  |  ding\-libs  |  0\.7\.0\-47\.amzn2023\.0\.2  | 
|  libcollection\-devel  |  aarch64  |  ding\-libs  |  0\.7\.0\-47\.amzn2023\.0\.2  | 
|  libcollection\-devel  |  x86\_64  |  ding\-libs  |  0\.7\.0\-47\.amzn2023\.0\.2  | 
|  libdhash  |  aarch64  |  ding\-libs  |  0\.5\.0\-47\.amzn2023\.0\.2  | 
|  libdhash  |  x86\_64  |  ding\-libs  |  0\.5\.0\-47\.amzn2023\.0\.2  | 
|  libdhash\-devel  |  aarch64  |  ding\-libs  |  0\.5\.0\-47\.amzn2023\.0\.2  | 
|  libdhash\-devel  |  x86\_64  |  ding\-libs  |  0\.5\.0\-47\.amzn2023\.0\.2  | 
|  libini\_config  |  aarch64  |  ding\-libs  |  1\.3\.1\-47\.amzn2023\.0\.2  | 
|  libini\_config  |  x86\_64  |  ding\-libs  |  1\.3\.1\-47\.amzn2023\.0\.2  | 
|  libini\_config\-devel  |  aarch64  |  ding\-libs  |  1\.3\.1\-47\.amzn2023\.0\.2  | 
|  libini\_config\-devel  |  x86\_64  |  ding\-libs  |  1\.3\.1\-47\.amzn2023\.0\.2  | 
|  libpath\_utils  |  aarch64  |  ding\-libs  |  0\.2\.1\-47\.amzn2023\.0\.2  | 
|  libpath\_utils  |  x86\_64  |  ding\-libs  |  0\.2\.1\-47\.amzn2023\.0\.2  | 
|  libpath\_utils\-devel  |  aarch64  |  ding\-libs  |  0\.2\.1\-47\.amzn2023\.0\.2  | 
|  libpath\_utils\-devel  |  x86\_64  |  ding\-libs  |  0\.2\.1\-47\.amzn2023\.0\.2  | 
|  libref\_array  |  aarch64  |  ding\-libs  |  0\.1\.5\-47\.amzn2023\.0\.2  | 
|  libref\_array  |  x86\_64  |  ding\-libs  |  0\.1\.5\-47\.amzn2023\.0\.2  | 
|  libref\_array\-devel  |  aarch64  |  ding\-libs  |  0\.1\.5\-47\.amzn2023\.0\.2  | 
|  libref\_array\-devel  |  x86\_64  |  ding\-libs  |  0\.1\.5\-47\.amzn2023\.0\.2  | 
|  disruptor  |  noarch  |  disruptor  |  3\.4\.4\-3\.amzn2023\.0\.2  | 
|  disruptor\-javadoc  |  noarch  |  disruptor  |  3\.4\.4\-3\.amzn2023\.0\.2  | 
|  dkms  |  noarch  |  dkms  |  3\.0\.3\-2\.amzn2023\.0\.2  | 
|  dmidecode  |  aarch64  |  dmidecode  |  3\.3\-1\.amzn2023\.0\.2  | 
|  dmidecode  |  x86\_64  |  dmidecode  |  3\.3\-1\.amzn2023\.0\.2  | 
|  dmraid  |  aarch64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid  |  x86\_64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-devel  |  aarch64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-devel  |  x86\_64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-events  |  aarch64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-events  |  x86\_64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-libs  |  aarch64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dmraid\-libs  |  x86\_64  |  dmraid  |  1\.0\.0\.rc16\-50\.amzn2023\.0\.2  | 
|  dnf  |  noarch  |  dnf  |  4\.12\.0\-2\.amzn2023\.0\.4  | 
|  dnf\-automatic  |  noarch  |  dnf  |  4\.12\.0\-2\.amzn2023\.0\.4  | 
|  dnf\-data  |  noarch  |  dnf  |  4\.12\.0\-2\.amzn2023\.0\.4  | 
|  python3\-dnf  |  noarch  |  dnf  |  4\.12\.0\-2\.amzn2023\.0\.4  | 
|  yum  |  noarch  |  dnf  |  4\.12\.0\-2\.amzn2023\.0\.4  | 
|  dnf\-plugin\-release\-notification  |  noarch  |  dnf\-plugin\-release\-notification  |  1\.2\-1\.amzn2023\.0\.2  | 
|  dnf\-plugins\-core  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  dnf\-utils  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-leaves  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-local  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-modulesync  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-post\-transaction\-actions  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugins\-core  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-show\-leaves  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  python3\-dnf\-plugin\-versionlock  |  noarch  |  dnf\-plugins\-core  |  4\.1\.0\-1\.amzn2023\.0\.3  | 
|  dnf\-plugin\-support\-info  |  noarch  |  dnf\-plugin\-support\-info  |  1\.2\-1\.amzn2023  | 
|  dnsmasq  |  aarch64  |  dnsmasq  |  2\.86\-10\.amzn2023\.0\.3  | 
|  dnsmasq  |  x86\_64  |  dnsmasq  |  2\.86\-10\.amzn2023\.0\.3  | 
|  dnsmasq\-utils  |  aarch64  |  dnsmasq  |  2\.86\-10\.amzn2023\.0\.3  | 
|  dnsmasq\-utils  |  x86\_64  |  dnsmasq  |  2\.86\-10\.amzn2023\.0\.3  | 
|  docbook5\-schemas  |  noarch  |  docbook5\-schemas  |  5\.1\-3\.amzn2023\.0\.2  | 
|  docbook5\-style\-xsl  |  noarch  |  docbook5\-style\-xsl  |  1\.79\.2\-11\.amzn2023\.0\.2  | 
|  docbook\-dtds  |  noarch  |  docbook\-dtds  |  1\.0\-77\.amzn2023\.0\.2  | 
|  docbook\-style\-dsssl  |  noarch  |  docbook\-style\-dsssl  |  1\.79\-31\.amzn2023\.0\.2  | 
|  docbook\-style\-xsl  |  noarch  |  docbook\-style\-xsl  |  1\.79\.2\-14\.amzn2023\.0\.2  | 
|  docbook\-utils  |  noarch  |  docbook\-utils  |  0\.6\.14\-52\.amzn2023\.0\.2  | 
|  docbook\-utils\-pdf  |  noarch  |  docbook\-utils  |  0\.6\.14\-52\.amzn2023\.0\.2  | 
|  docker  |  aarch64  |  docker  |  20\.10\.25\-1\.amzn2023\.0\.1  | 
|  docker  |  x86\_64  |  docker  |  20\.10\.25\-1\.amzn2023\.0\.1  | 
|  dom4j  |  noarch  |  dom4j  |  2\.0\.3\-4\.amzn2023\.0\.1  | 
|  dom4j\-javadoc  |  noarch  |  dom4j  |  2\.0\.3\-4\.amzn2023\.0\.1  | 
|  dos2unix  |  aarch64  |  dos2unix  |  7\.4\.2\-2\.amzn2023\.0\.2  | 
|  dos2unix  |  x86\_64  |  dos2unix  |  7\.4\.2\-2\.amzn2023\.0\.2  | 
|  dosfstools  |  aarch64  |  dosfstools  |  4\.2\-1\.amzn2023\.0\.2  | 
|  dosfstools  |  x86\_64  |  dosfstools  |  4\.2\-1\.amzn2023\.0\.2  | 
|  dotconf  |  aarch64  |  dotconf  |  1\.3\-26\.amzn2023\.0\.2  | 
|  dotconf  |  x86\_64  |  dotconf  |  1\.3\-26\.amzn2023\.0\.2  | 
|  dotconf\-devel  |  aarch64  |  dotconf  |  1\.3\-26\.amzn2023\.0\.2  | 
|  dotconf\-devel  |  x86\_64  |  dotconf  |  1\.3\-26\.amzn2023\.0\.2  | 
|  aspnetcore\-runtime\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  aspnetcore\-runtime\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  aspnetcore\-targeting\-pack\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  aspnetcore\-targeting\-pack\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet  |  aarch64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet  |  x86\_64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-apphost\-pack\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-apphost\-pack\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-host  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-host  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-hostfxr\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-hostfxr\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-runtime\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-runtime\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-sdk\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-sdk\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-sdk\-6\.0\-source\-built\-artifacts  |  aarch64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-sdk\-6\.0\-source\-built\-artifacts  |  x86\_64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-targeting\-pack\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-targeting\-pack\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.18\-1\.amzn2023\.0\.1  | 
|  dotnet\-templates\-6\.0  |  aarch64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dotnet\-templates\-6\.0  |  x86\_64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  netstandard\-targeting\-pack\-2\.1  |  aarch64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  netstandard\-targeting\-pack\-2\.1  |  x86\_64  |  dotnet6\.0  |  6\.0\.118\-1\.amzn2023\.0\.1  | 
|  dovecot  |  aarch64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot  |  x86\_64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-devel  |  aarch64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-devel  |  x86\_64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-mysql  |  aarch64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-mysql  |  x86\_64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-pgsql  |  aarch64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-pgsql  |  x86\_64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-pigeonhole  |  aarch64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  dovecot\-pigeonhole  |  x86\_64  |  dovecot  |  2\.3\.20\-1\.amzn2023\.0\.1  | 
|  doxygen  |  aarch64  |  doxygen  |  1\.9\.4\-1\.amzn2023\.0\.3  | 
|  doxygen  |  x86\_64  |  doxygen  |  1\.9\.4\-1\.amzn2023\.0\.3  | 
|  doxygen\-latex  |  aarch64  |  doxygen  |  1\.9\.4\-1\.amzn2023\.0\.3  | 
|  doxygen\-latex  |  x86\_64  |  doxygen  |  1\.9\.4\-1\.amzn2023\.0\.3  | 
|  dracut  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-caps  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-caps  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-config\-generic  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-config\-generic  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-config\-rescue  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-config\-rescue  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-squash  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-squash  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-tools  |  aarch64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-tools  |  x86\_64  |  dracut  |  055\-6\.amzn2023\.0\.8  | 
|  dracut\-config\-ec2  |  noarch  |  dracut\-config\-ec2  |  3\.0\-4\.amzn2023\.0\.2  | 
|  dtc  |  aarch64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  dtc  |  x86\_64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt  |  aarch64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt  |  x86\_64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt\-devel  |  aarch64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt\-devel  |  x86\_64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt\-static  |  aarch64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  libfdt\-static  |  x86\_64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  python3\-libfdt  |  aarch64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  python3\-libfdt  |  x86\_64  |  dtc  |  1\.6\.1\-4\.amzn2023\.0\.2  | 
|  dwarves  |  aarch64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  dwarves  |  x86\_64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  libdwarves1  |  aarch64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  libdwarves1  |  x86\_64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  libdwarves1\-devel  |  aarch64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  libdwarves1\-devel  |  x86\_64  |  dwarves  |  1\.22\-1\.amzn2023\.0\.2  | 
|  dwz  |  aarch64  |  dwz  |  0\.14\-6\.amzn2023\.0\.2  | 
|  dwz  |  x86\_64  |  dwz  |  0\.14\-6\.amzn2023\.0\.2  | 
|  dyninst  |  aarch64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst  |  x86\_64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-devel  |  aarch64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-devel  |  x86\_64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-doc  |  aarch64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-doc  |  x86\_64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-testsuite  |  aarch64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  dyninst\-testsuite  |  x86\_64  |  dyninst  |  10\.2\.1\-6\.amzn2023\.0\.2  | 
|  e2fsprogs  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-devel  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-devel  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-libs  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-libs  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-static  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2fsprogs\-static  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2scrub  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  e2scrub  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libcom\_err  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libcom\_err  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libcom\_err\-devel  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libcom\_err\-devel  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libss  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libss  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libss\-devel  |  aarch64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  libss\-devel  |  x86\_64  |  e2fsprogs  |  1\.46\.5\-2\.amzn2023\.0\.2  | 
|  easymock  |  noarch  |  easymock  |  4\.2\-7\.amzn2023\.0\.3  | 
|  easymock\-javadoc  |  noarch  |  easymock  |  4\.2\-7\.amzn2023\.0\.3  | 
|  ebtables\-legacy  |  aarch64  |  ebtables  |  2\.0\.11\-9\.amzn2023\.0\.2  | 
|  ebtables\-legacy  |  x86\_64  |  ebtables  |  2\.0\.11\-9\.amzn2023\.0\.2  | 
|  ebtables\-services  |  aarch64  |  ebtables  |  2\.0\.11\-9\.amzn2023\.0\.2  | 
|  ebtables\-services  |  x86\_64  |  ebtables  |  2\.0\.11\-9\.amzn2023\.0\.2  | 
|  ec2\-hibinit\-agent  |  noarch  |  ec2\-hibinit\-agent  |  1\.0\.4\-0\.amzn2023\.0\.2  | 
|  ec2\-instance\-connect  |  noarch  |  ec2\-instance\-connect  |  1\.1\-19\.amzn2023  | 
|  ec2\-instance\-connect\-selinux  |  noarch  |  ec2\-instance\-connect\-selinux  |  1\.1\-19\.amzn2023  | 
|  ec2\-utils  |  noarch  |  ec2\-utils  |  2\.1\.0\-1\.amzn2023\.0\.1  | 
|  ecj  |  noarch  |  ecj  |  4\.23\-1\.amzn2023\.0\.4  | 
|  ecs\-init  |  aarch64  |  ecs\-init  |  1\.73\.1\-1\.amzn2023  | 
|  ecs\-init  |  x86\_64  |  ecs\-init  |  1\.73\.1\-1\.amzn2023  | 
|  ecs\-service\-connect\-agent  |  aarch64  |  ecs\-service\-connect\-agent  |  v1\.25\.4\.0\-1\.amzn2023  | 
|  ecs\-service\-connect\-agent  |  x86\_64  |  ecs\-service\-connect\-agent  |  v1\.25\.4\.0\-1\.amzn2023  | 
|  ed  |  aarch64  |  ed  |  1\.14\.2\-10\.amzn2023\.0\.2  | 
|  ed  |  x86\_64  |  ed  |  1\.14\.2\-10\.amzn2023\.0\.2  | 
|  efi\-filesystem  |  noarch  |  efi\-rpm\-macros  |  5\-4\.amzn2023\.0\.5  | 
|  efi\-srpm\-macros  |  noarch  |  efi\-rpm\-macros  |  5\-4\.amzn2023\.0\.5  | 
|  efitools  |  aarch64  |  efitools  |  1\.9\.2\-7\.amzn2023\.0\.2  | 
|  efitools  |  x86\_64  |  efitools  |  1\.9\.2\-7\.amzn2023\.0\.2  | 
|  efivar  |  aarch64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  efivar  |  x86\_64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  efivar\-devel  |  aarch64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  efivar\-devel  |  x86\_64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  efivar\-libs  |  aarch64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  efivar\-libs  |  x86\_64  |  efivar  |  38\-2\.amzn2023\.0\.1  | 
|  eglexternalplatform\-devel  |  noarch  |  eglexternalplatform  |  1\.1\-4\.amzn2023  | 
|  egl\-wayland  |  aarch64  |  egl\-wayland  |  1\.1\.11\-2\.amzn2023  | 
|  egl\-wayland  |  x86\_64  |  egl\-wayland  |  1\.1\.11\-2\.amzn2023  | 
|  egl\-wayland\-devel  |  aarch64  |  egl\-wayland  |  1\.1\.11\-2\.amzn2023  | 
|  egl\-wayland\-devel  |  x86\_64  |  egl\-wayland  |  1\.1\.11\-2\.amzn2023  | 
|  eigen3\-devel  |  noarch  |  eigen3  |  3\.3\.9\-4\.amzn2023\.0\.2  | 
|  eigen3\-doc  |  noarch  |  eigen3  |  3\.3\.9\-4\.amzn2023\.0\.2  | 
|  elfutils  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod\-client  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod\-client  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod\-client\-devel  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-debuginfod\-client\-devel  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-default\-yama\-scope  |  noarch  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-devel  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-devel  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libelf  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libelf  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libelf\-devel  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libelf\-devel  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libs  |  aarch64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elfutils\-libs  |  x86\_64  |  elfutils  |  0\.188\-3\.amzn2023\.0\.2  | 
|  elinks  |  aarch64  |  elinks  |  0\.12\-0\.65\.pre6\.amzn2023\.0\.2  | 
|  elinks  |  x86\_64  |  elinks  |  0\.12\-0\.65\.pre6\.amzn2023\.0\.2  | 
|  emacs  |  aarch64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs  |  x86\_64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-common  |  aarch64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-common  |  x86\_64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-devel  |  aarch64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-devel  |  x86\_64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-filesystem  |  noarch  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-lucid  |  aarch64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-lucid  |  x86\_64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-nox  |  aarch64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-nox  |  x86\_64  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-terminal  |  noarch  |  emacs  |  28\.2\-3\.amzn2023\.0\.6  | 
|  emacs\-auctex  |  noarch  |  emacs\-auctex  |  12\.3\-1\.amzn2023\.0\.2  | 
|  emacs\-auctex\-doc  |  noarch  |  emacs\-auctex  |  12\.3\-1\.amzn2023\.0\.2  | 
|  tex\-preview  |  noarch  |  emacs\-auctex  |  12\.3\-1\.amzn2023\.0\.2  | 
|  enchant  |  aarch64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant  |  x86\_64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-aspell  |  aarch64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-aspell  |  x86\_64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-devel  |  aarch64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-devel  |  x86\_64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-voikko  |  aarch64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant\-voikko  |  x86\_64  |  enchant  |  1\.6\.0\-27\.amzn2023\.0\.1  | 
|  enchant2  |  aarch64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2  |  x86\_64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-aspell  |  aarch64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-aspell  |  x86\_64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-devel  |  aarch64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-devel  |  x86\_64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-voikko  |  aarch64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  enchant2\-voikko  |  x86\_64  |  enchant2  |  2\.2\.15\-5\.amzn2023\.0\.2  | 
|  environment\-modules  |  aarch64  |  environment\-modules  |  4\.8\.0\-1\.amzn2023\.0\.2  | 
|  environment\-modules  |  x86\_64  |  environment\-modules  |  4\.8\.0\-1\.amzn2023\.0\.2  | 
|  environment\-modules\-compat  |  aarch64  |  environment\-modules  |  4\.8\.0\-1\.amzn2023\.0\.2  | 
|  environment\-modules\-compat  |  x86\_64  |  environment\-modules  |  4\.8\.0\-1\.amzn2023\.0\.2  | 
|  esmtp  |  aarch64  |  esmtp  |  1\.2\-17\.amzn2023\.0\.2  | 
|  esmtp  |  x86\_64  |  esmtp  |  1\.2\-17\.amzn2023\.0\.2  | 
|  esmtp\-local\-delivery  |  aarch64  |  esmtp  |  1\.2\-17\.amzn2023\.0\.2  | 
|  esmtp\-local\-delivery  |  x86\_64  |  esmtp  |  1\.2\-17\.amzn2023\.0\.2  | 
|  ethtool  |  aarch64  |  ethtool  |  5\.15\-1\.amzn2023\.0\.2  | 
|  ethtool  |  x86\_64  |  ethtool  |  5\.15\-1\.amzn2023\.0\.2  | 
|  exec\-maven\-plugin  |  noarch  |  exec\-maven\-plugin  |  3\.0\.0\-4\.amzn2023\.0\.1  | 
|  exec\-maven\-plugin\-javadoc  |  noarch  |  exec\-maven\-plugin  |  3\.0\.0\-4\.amzn2023\.0\.1  | 
|  execstack  |  aarch64  |  execstack  |  0\.5\.0\-20\.amzn2023\.0\.2  | 
|  execstack  |  x86\_64  |  execstack  |  0\.5\.0\-20\.amzn2023\.0\.2  | 
|  expat  |  aarch64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expat  |  x86\_64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expat\-devel  |  aarch64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expat\-devel  |  x86\_64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expat\-static  |  aarch64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expat\-static  |  x86\_64  |  expat  |  2\.5\.0\-1\.amzn2023\.0\.2  | 
|  expect  |  aarch64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  expect  |  x86\_64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  expect\-devel  |  aarch64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  expect\-devel  |  x86\_64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  expectk  |  aarch64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  expectk  |  x86\_64  |  expect  |  5\.45\.4\-13\.amzn2023\.0\.2  | 
|  fakeroot  |  aarch64  |  fakeroot  |  1\.26\-4\.amzn2023\.0\.2  | 
|  fakeroot  |  x86\_64  |  fakeroot  |  1\.26\-4\.amzn2023\.0\.2  | 
|  fakeroot\-libs  |  aarch64  |  fakeroot  |  1\.26\-4\.amzn2023\.0\.2  | 
|  fakeroot\-libs  |  x86\_64  |  fakeroot  |  1\.26\-4\.amzn2023\.0\.2  | 
|  fasterxml\-oss\-parent  |  noarch  |  fasterxml\-oss\-parent  |  41\-5\.amzn2023\.0\.2  | 
|  fcgi  |  aarch64  |  fcgi  |  2\.4\.0\-39\.amzn2023\.0\.2  | 
|  fcgi  |  x86\_64  |  fcgi  |  2\.4\.0\-39\.amzn2023\.0\.2  | 
|  fcgi\-devel  |  aarch64  |  fcgi  |  2\.4\.0\-39\.amzn2023\.0\.2  | 
|  fcgi\-devel  |  x86\_64  |  fcgi  |  2\.4\.0\-39\.amzn2023\.0\.2  | 
|  fdupes  |  aarch64  |  fdupes  |  2\.1\.1\-2\.amzn2023\.0\.2  | 
|  fdupes  |  x86\_64  |  fdupes  |  2\.1\.1\-2\.amzn2023\.0\.2  | 
|  felix\-parent  |  noarch  |  felix\-parent  |  7\-8\.amzn2023\.0\.3  | 
|  felix\-utils  |  noarch  |  felix\-utils  |  1\.11\.6\-5\.amzn2023\.0\.3  | 
|  felix\-utils\-javadoc  |  noarch  |  felix\-utils  |  1\.11\.6\-5\.amzn2023\.0\.3  | 
|  fftw  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-devel  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-devel  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-doc  |  noarch  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-double  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-double  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-long  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-long  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-quad  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-single  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-libs\-single  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-devel  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-devel  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-double  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-double  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-long  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-long  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-single  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-libs\-single  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-static  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-mpich\-static  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-devel  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-devel  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-double  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-double  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-long  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-long  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-single  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-libs\-single  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-static  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-openmpi\-static  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-static  |  aarch64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  fftw\-static  |  x86\_64  |  fftw  |  3\.3\.8\-10\.amzn2023\.0\.2  | 
|  file  |  aarch64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file  |  x86\_64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-devel  |  aarch64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-devel  |  x86\_64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-libs  |  aarch64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-libs  |  x86\_64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-static  |  aarch64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  file\-static  |  x86\_64  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  python3\-file\-magic  |  noarch  |  file  |  5\.39\-7\.amzn2023\.0\.2  | 
|  filesystem  |  aarch64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem  |  x86\_64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-afs  |  aarch64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-afs  |  x86\_64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-content  |  aarch64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-content  |  x86\_64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-locales  |  aarch64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  filesystem\-locales  |  x86\_64  |  filesystem  |  3\.14\-5\.amzn2023\.0\.3  | 
|  findutils  |  aarch64  |  findutils  |  4\.8\.0\-2\.amzn2023\.0\.2  | 
|  findutils  |  x86\_64  |  findutils  |  4\.8\.0\-2\.amzn2023\.0\.2  | 
|  fio  |  aarch64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-dev\-dax  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-http  |  aarch64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-http  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-libaio  |  aarch64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-libaio  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-libpmem  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-pmemblk  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-rdma  |  aarch64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  fio\-engine\-rdma  |  x86\_64  |  fio  |  3\.32\-2\.amzn2023\.0\.3  | 
|  firewalld  |  noarch  |  firewalld  |  1\.2\.3\-1\.amzn2023  | 
|  firewalld\-filesystem  |  noarch  |  firewalld  |  1\.2\.3\-1\.amzn2023  | 
|  firewalld\-test  |  noarch  |  firewalld  |  1\.2\.3\-1\.amzn2023  | 
|  python3\-firewall  |  noarch  |  firewalld  |  1\.2\.3\-1\.amzn2023  | 
|  flac  |  aarch64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flac  |  x86\_64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flac\-devel  |  aarch64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flac\-devel  |  x86\_64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flac\-libs  |  aarch64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flac\-libs  |  x86\_64  |  flac  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  flex  |  aarch64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  flex  |  x86\_64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  flex\-doc  |  aarch64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  flex\-doc  |  x86\_64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl2  |  aarch64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl2  |  x86\_64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl\-devel  |  aarch64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl\-devel  |  x86\_64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl\-static  |  aarch64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  libfl\-static  |  x86\_64  |  flex  |  2\.6\.4\-7\.amzn2023\.0\.2  | 
|  flexiblas  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-atlas  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-atlas  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-openmp  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-openmp  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-openmp64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-openmp64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-serial  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-serial  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-serial64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-serial64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-threads  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-threads  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-threads64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-blis\-threads64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-devel  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-devel  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-hook\-profile  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-hook\-profile  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-hook\-profile64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-hook\-profile64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-netlib  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-netlib  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-netlib64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-netlib64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-openmp  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-openmp  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-openmp64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-openmp64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-serial  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-serial  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-serial64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-serial64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-threads  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-threads  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-threads64  |  aarch64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  flexiblas\-openblas\-threads64  |  x86\_64  |  flexiblas  |  3\.0\.4\-3\.amzn2023\.0\.2  | 
|  fltk  |  aarch64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk  |  x86\_64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-devel  |  aarch64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-devel  |  x86\_64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-fluid  |  aarch64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-fluid  |  x86\_64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-static  |  aarch64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  fltk\-static  |  x86\_64  |  fltk  |  1\.3\.6\-1\.amzn2023\.0\.2  | 
|  foma  |  aarch64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  foma  |  x86\_64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  libfoma  |  aarch64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  libfoma  |  x86\_64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  libfoma\-devel  |  aarch64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  libfoma\-devel  |  x86\_64  |  foma  |  0\.9\.18\-0\.10\.20200928gitb44022c\.amzn2023\.0\.2  | 
|  fontawesome\-fonts  |  noarch  |  fontawesome\-fonts  |  4\.7\.0\-11\.amzn2023\.0\.2  | 
|  fontawesome\-fonts\-web  |  noarch  |  fontawesome\-fonts  |  4\.7\.0\-11\.amzn2023\.0\.2  | 
|  fontconfig  |  aarch64  |  fontconfig  |  2\.13\.94\-2\.amzn2023\.0\.2  | 
|  fontconfig  |  x86\_64  |  fontconfig  |  2\.13\.94\-2\.amzn2023\.0\.2  | 
|  fontconfig\-devel  |  aarch64  |  fontconfig  |  2\.13\.94\-2\.amzn2023\.0\.2  | 
|  fontconfig\-devel  |  x86\_64  |  fontconfig  |  2\.13\.94\-2\.amzn2023\.0\.2  | 
|  fontconfig\-devel\-doc  |  noarch  |  fontconfig  |  2\.13\.94\-2\.amzn2023\.0\.2  | 
|  fontforge  |  aarch64  |  fontforge  |  20201107\-3\.amzn2023\.0\.2  | 
|  fontforge  |  x86\_64  |  fontforge  |  20201107\-3\.amzn2023\.0\.2  | 
|  fontforge\-devel  |  aarch64  |  fontforge  |  20201107\-3\.amzn2023\.0\.2  | 
|  fontforge\-devel  |  x86\_64  |  fontforge  |  20201107\-3\.amzn2023\.0\.2  | 
|  fontforge\-doc  |  noarch  |  fontforge  |  20201107\-3\.amzn2023\.0\.2  | 
|  fonts\-filesystem  |  noarch  |  fonts\-rpm\-macros  |  2\.0\.5\-5\.amzn2023\.0\.2  | 
|  fonts\-rpm\-macros  |  noarch  |  fonts\-rpm\-macros  |  2\.0\.5\-5\.amzn2023\.0\.2  | 
|  fonts\-rpm\-templates  |  noarch  |  fonts\-rpm\-macros  |  2\.0\.5\-5\.amzn2023\.0\.2  | 
|  fonts\-srpm\-macros  |  noarch  |  fonts\-rpm\-macros  |  2\.0\.5\-5\.amzn2023\.0\.2  | 
|  fonttools  |  noarch  |  fonttools  |  4\.19\.1\-1\.amzn2023\.0\.2  | 
|  python3\-fonttools  |  noarch  |  fonttools  |  4\.19\.1\-1\.amzn2023\.0\.2  | 
|  python3\-fonttools\+ufo  |  noarch  |  fonttools  |  4\.19\.1\-1\.amzn2023\.0\.2  | 
|  python3\-fonttools\+unicode  |  noarch  |  fonttools  |  4\.19\.1\-1\.amzn2023\.0\.2  | 
|  fonttosfnt  |  aarch64  |  fonttosfnt  |  1\.2\.2\-1\.amzn2023\.0\.2  | 
|  fonttosfnt  |  x86\_64  |  fonttosfnt  |  1\.2\.2\-1\.amzn2023\.0\.2  | 
|  fpc\-srpm\-macros  |  noarch  |  fpc\-srpm\-macros  |  1\.3\-3\.amzn2023\.0\.2  | 
|  freeglut  |  aarch64  |  freeglut  |  3\.2\.1\-7\.amzn2023\.0\.2  | 
|  freeglut  |  x86\_64  |  freeglut  |  3\.2\.1\-7\.amzn2023\.0\.2  | 
|  freeglut\-devel  |  aarch64  |  freeglut  |  3\.2\.1\-7\.amzn2023\.0\.2  | 
|  freeglut\-devel  |  x86\_64  |  freeglut  |  3\.2\.1\-7\.amzn2023\.0\.2  | 
|  freetype  |  aarch64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  freetype  |  x86\_64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  freetype\-demos  |  aarch64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  freetype\-demos  |  x86\_64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  freetype\-devel  |  aarch64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  freetype\-devel  |  x86\_64  |  freetype  |  2\.13\.0\-2\.amzn2023\.0\.1  | 
|  fribidi  |  aarch64  |  fribidi  |  1\.0\.11\-3\.amzn2023\.0\.2  | 
|  fribidi  |  x86\_64  |  fribidi  |  1\.0\.11\-3\.amzn2023\.0\.2  | 
|  fribidi\-devel  |  aarch64  |  fribidi  |  1\.0\.11\-3\.amzn2023\.0\.2  | 
|  fribidi\-devel  |  x86\_64  |  fribidi  |  1\.0\.11\-3\.amzn2023\.0\.2  | 
|  fstrm  |  aarch64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm  |  x86\_64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm\-devel  |  aarch64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm\-devel  |  x86\_64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm\-doc  |  noarch  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm\-utils  |  aarch64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fstrm\-utils  |  x86\_64  |  fstrm  |  0\.6\.1\-2\.amzn2023\.0\.2  | 
|  fuse  |  aarch64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse  |  x86\_64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse\-devel  |  aarch64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse\-devel  |  x86\_64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse\-libs  |  aarch64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse\-libs  |  x86\_64  |  fuse  |  2\.9\.9\-13\.amzn2023\.0\.2  | 
|  fuse3  |  aarch64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse3  |  x86\_64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse3\-devel  |  aarch64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse3\-devel  |  x86\_64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse3\-libs  |  aarch64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse3\-libs  |  x86\_64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse\-common  |  aarch64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fuse\-common  |  x86\_64  |  fuse3  |  3\.10\.4\-1\.amzn2023\.0\.2  | 
|  fusesource\-pom  |  noarch  |  fusesource\-pom  |  1\.12\-10\.amzn2023\.0\.4  | 
|  python3\-future  |  noarch  |  future  |  0\.18\.3\-1\.amzn2023\.0\.1  | 
|  gawk  |  aarch64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk  |  x86\_64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk\-all\-langpacks  |  aarch64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk\-all\-langpacks  |  x86\_64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk\-devel  |  aarch64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk\-devel  |  x86\_64  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gawk\-doc  |  noarch  |  gawk  |  5\.1\.0\-3\.amzn2023\.0\.2  | 
|  gc  |  aarch64  |  gc  |  8\.0\.4\-5\.amzn2023\.0\.2  | 
|  gc  |  x86\_64  |  gc  |  8\.0\.4\-5\.amzn2023\.0\.2  | 
|  gc\-devel  |  aarch64  |  gc  |  8\.0\.4\-5\.amzn2023\.0\.2  | 
|  gc\-devel  |  x86\_64  |  gc  |  8\.0\.4\-5\.amzn2023\.0\.2  | 
|  cpp  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  cpp  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-c\+\+  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-c\+\+  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-gdb\-plugin  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-gdb\-plugin  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-gfortran  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-gfortran  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-offload\-nvptx  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-plugin\-devel  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcc\-plugin\-devel  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libasan  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libasan  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libasan\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libasan\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libatomic  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libatomic  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libatomic\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libatomic\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgcc  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgcc  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgccjit  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgccjit  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgccjit\-devel  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgccjit\-devel  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgfortran  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgfortran  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgfortran\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgfortran\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgomp  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgomp  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libgomp\-offload\-nvptx  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm\-devel  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm\-devel  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libitm\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  liblsan  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  liblsan  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  liblsan\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  liblsan\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libquadmath  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libquadmath\-devel  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libquadmath\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-devel  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-devel  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-docs  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-docs  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libstdc\+\+\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libtsan  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libtsan  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libtsan\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libtsan\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libubsan  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libubsan  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libubsan\-static  |  aarch64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  libubsan\-static  |  x86\_64  |  gcc  |  11\.3\.1\-4\.amzn2023\.0\.3  | 
|  gcr  |  aarch64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gcr  |  x86\_64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gcr\-base  |  aarch64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gcr\-base  |  x86\_64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gcr\-devel  |  aarch64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gcr\-devel  |  x86\_64  |  gcr  |  3\.40\.0\-1\.amzn2023\.0\.3  | 
|  gd  |  aarch64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gd  |  x86\_64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gd\-devel  |  aarch64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gd\-devel  |  x86\_64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gd\-progs  |  aarch64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gd\-progs  |  x86\_64  |  gd  |  2\.3\.3\-5\.amzn2023\.0\.3  | 
|  gdb  |  aarch64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb  |  x86\_64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-doc  |  noarch  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-gdbserver  |  aarch64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-gdbserver  |  x86\_64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-headless  |  aarch64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-headless  |  x86\_64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-minimal  |  aarch64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdb\-minimal  |  x86\_64  |  gdb  |  12\.1\-5\.amzn2023\.0\.3  | 
|  gdbm  |  aarch64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdbm  |  x86\_64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdbm\-devel  |  aarch64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdbm\-devel  |  x86\_64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdbm\-libs  |  aarch64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdbm\-libs  |  x86\_64  |  gdbm  |  1\.19\-2\.amzn2023\.0\.2  | 
|  gdisk  |  aarch64  |  gdisk  |  1\.0\.8\-1\.amzn2023\.0\.2  | 
|  gdisk  |  x86\_64  |  gdisk  |  1\.0\.8\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2  |  aarch64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2  |  x86\_64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-devel  |  aarch64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-devel  |  x86\_64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-modules  |  aarch64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-modules  |  x86\_64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-tests  |  aarch64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  gdk\-pixbuf2\-tests  |  x86\_64  |  gdk\-pixbuf2  |  2\.42\.6\-1\.amzn2023\.0\.2  | 
|  generic\-logos  |  noarch  |  generic\-logos  |  18\.0\.0\-12\.amzn2023\.0\.3  | 
|  generic\-logos\-httpd  |  noarch  |  generic\-logos  |  18\.0\.0\-12\.amzn2023\.0\.3  | 
|  emacs\-gettext  |  noarch  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext  |  aarch64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext  |  x86\_64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext\-common\-devel  |  noarch  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext\-devel  |  aarch64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext\-devel  |  x86\_64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext\-libs  |  aarch64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  gettext\-libs  |  x86\_64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  libtextstyle  |  aarch64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  libtextstyle  |  x86\_64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  libtextstyle\-devel  |  aarch64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  libtextstyle\-devel  |  x86\_64  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  msghack  |  noarch  |  gettext  |  0\.21\-4\.amzn2023\.0\.2  | 
|  ghc\-srpm\-macros  |  noarch  |  ghc\-srpm\-macros  |  1\.5\.0\-4\.amzn2023\.0\.2  | 
|  ghostscript  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-doc  |  noarch  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-gtk  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-gtk  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-dvipdf  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-dvipdf  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-fonts  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-fonts  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-printing  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-tools\-printing  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-x11  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  ghostscript\-x11  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  libgs  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  libgs  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  libgs\-devel  |  aarch64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  libgs\-devel  |  x86\_64  |  ghostscript  |  9\.56\.1\-7\.amzn2023\.0\.1  | 
|  giflib  |  aarch64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  giflib  |  x86\_64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  giflib\-devel  |  aarch64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  giflib\-devel  |  x86\_64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  giflib\-utils  |  aarch64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  giflib\-utils  |  x86\_64  |  giflib  |  5\.2\.1\-9\.amzn2023  | 
|  git  |  aarch64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git  |  x86\_64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-all  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-core  |  aarch64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-core  |  x86\_64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-core\-doc  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-credential\-libsecret  |  aarch64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-credential\-libsecret  |  x86\_64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-cvs  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-daemon  |  aarch64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-daemon  |  x86\_64  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-email  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-gui  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-instaweb  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  gitk  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-p4  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-subtree  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  git\-svn  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  gitweb  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  perl\-Git  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  perl\-Git\-SVN  |  noarch  |  git  |  2\.40\.1\-1\.amzn2023\.0\.1  | 
|  glew  |  aarch64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  glew  |  x86\_64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  glew\-devel  |  aarch64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  glew\-devel  |  x86\_64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  libGLEW  |  aarch64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  libGLEW  |  x86\_64  |  glew  |  2\.1\.0\-9\.amzn2023\.0\.2  | 
|  glib2  |  aarch64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2  |  x86\_64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-devel  |  aarch64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-devel  |  x86\_64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-doc  |  noarch  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-static  |  aarch64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-static  |  x86\_64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-tests  |  aarch64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  glib2\-tests  |  x86\_64  |  glib2  |  2\.74\.7\-688\.amzn2023\.0\.1  | 
|  compat\-libpthread\-nonshared  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  compat\-libpthread\-nonshared  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-all\-langpacks  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-all\-langpacks  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-benchtests  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-benchtests  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-common  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-common  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-devel  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-devel  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-doc  |  noarch  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-gconv\-extra  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-gconv\-extra  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-headers\-x86  |  noarch  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-aa  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-aa  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-af  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-af  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-agr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-agr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ak  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ak  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-am  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-am  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-an  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-an  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-anp  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-anp  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ar  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ar  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-as  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-as  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ast  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ast  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ayc  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ayc  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-az  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-az  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-be  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-be  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bem  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bem  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ber  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ber  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bg  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bg  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bhb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bhb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bho  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bho  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-br  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-br  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-brx  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-brx  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bs  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-bs  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-byn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-byn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ca  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ca  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ce  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ce  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-chr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-chr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ckb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ckb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cmn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cmn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-crh  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-crh  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cs  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cs  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-csb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-csb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cv  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cv  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cy  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-cy  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-da  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-da  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-de  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-de  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-doi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-doi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dsb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dsb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dv  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dv  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dz  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-dz  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-el  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-el  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-en  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-en  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-eo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-eo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-es  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-es  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-et  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-et  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-eu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-eu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fa  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fa  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ff  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ff  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fil  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fil  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fur  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fur  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fy  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-fy  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ga  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ga  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gd  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gd  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gez  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gez  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gv  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-gv  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ha  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ha  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hak  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hak  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-he  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-he  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hif  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hif  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hne  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hne  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hsb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hsb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ht  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ht  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hy  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-hy  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ia  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ia  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-id  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-id  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ig  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ig  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ik  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ik  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-is  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-is  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-it  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-it  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-iu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-iu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ja  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ja  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ka  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ka  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kab  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kab  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kk  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kk  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-km  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-km  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ko  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ko  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kok  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kok  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ks  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ks  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ku  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ku  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-kw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ky  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ky  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lg  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lg  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-li  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-li  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lij  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lij  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ln  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ln  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lt  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lt  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lv  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lv  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lzh  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-lzh  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mag  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mag  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mai  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mai  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mfe  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mfe  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mg  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mg  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mhr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mhr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-miq  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-miq  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mjw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mjw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mk  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mk  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ml  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ml  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mni  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mni  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mnw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mnw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ms  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ms  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mt  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-mt  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-my  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-my  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nan  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nan  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nb  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nb  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nds  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nds  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ne  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ne  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nhn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nhn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-niu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-niu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nso  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-nso  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-oc  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-oc  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-om  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-om  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-or  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-or  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-os  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-os  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pa  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pa  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pap  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pap  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ps  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ps  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pt  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-pt  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-quz  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-quz  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-raj  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-raj  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ro  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ro  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ru  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ru  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-rw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-rw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sa  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sa  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sah  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sah  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sat  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sat  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sc  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sc  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sd  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sd  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-se  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-se  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sgs  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sgs  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-shn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-shn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-shs  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-shs  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-si  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-si  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sid  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sid  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sk  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sk  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sm  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sm  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-so  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-so  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sq  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sq  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ss  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ss  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-st  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-st  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sv  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sv  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-sw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-szl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-szl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ta  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ta  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tcy  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tcy  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-te  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-te  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tg  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tg  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-th  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-th  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-the  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-the  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ti  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ti  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tig  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tig  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tk  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tk  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tn  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tn  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-to  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-to  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tpi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tpi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tr  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tr  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ts  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ts  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tt  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-tt  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ug  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ug  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-uk  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-uk  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-unm  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-unm  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ur  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ur  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-uz  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-uz  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ve  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-ve  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-vi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-vi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wa  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wa  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wae  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wae  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wal  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wal  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-wo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-xh  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-xh  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yi  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yi  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yo  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yo  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yue  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yue  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yuw  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-yuw  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-zh  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-zh  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-zu  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-langpack\-zu  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-locale\-source  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-locale\-source  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-minimal\-langpack  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-minimal\-langpack  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-nss\-devel  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-nss\-devel  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-static  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-static  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-utils  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibc\-utils  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  libnsl  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  libnsl  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nscd  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nscd  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nss\_db  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nss\_db  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nss\_hesiod  |  aarch64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  nss\_hesiod  |  x86\_64  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  sysroot\-aarch64\-fc34\-glibc  |  noarch  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  sysroot\-i386\-fc34\-glibc  |  noarch  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  sysroot\-x86\_64\-fc34\-glibc  |  noarch  |  glibc  |  2\.34\-52\.amzn2023\.0\.3  | 
|  glibmm24  |  aarch64  |  glibmm24  |  2\.66\.2\-1\.amzn2023\.0\.2  | 
|  glibmm24  |  x86\_64  |  glibmm24  |  2\.66\.2\-1\.amzn2023\.0\.2  | 
|  glibmm24\-devel  |  aarch64  |  glibmm24  |  2\.66\.2\-1\.amzn2023\.0\.2  | 
|  glibmm24\-devel  |  x86\_64  |  glibmm24  |  2\.66\.2\-1\.amzn2023\.0\.2  | 
|  glibmm24\-doc  |  noarch  |  glibmm24  |  2\.66\.2\-1\.amzn2023\.0\.2  | 
|  glib\-networking  |  aarch64  |  glib\-networking  |  2\.68\.2\-1\.amzn2023\.0\.3  | 
|  glib\-networking  |  x86\_64  |  glib\-networking  |  2\.68\.2\-1\.amzn2023\.0\.3  | 
|  glib\-networking\-tests  |  aarch64  |  glib\-networking  |  2\.68\.2\-1\.amzn2023\.0\.3  | 
|  glib\-networking\-tests  |  x86\_64  |  glib\-networking  |  2\.68\.2\-1\.amzn2023\.0\.3  | 
|  gl\-manpages  |  noarch  |  gl\-manpages  |  1\.1\-22\.20190306\.amzn2023\.0\.2  | 
|  glslang  |  aarch64  |  glslang  |  11\.6\.0\-1\.20210825\.git2fb89a0\.amzn2023\.0\.2  | 
|  glslang  |  x86\_64  |  glslang  |  11\.6\.0\-1\.20210825\.git2fb89a0\.amzn2023\.0\.2  | 
|  glslang\-devel  |  aarch64  |  glslang  |  11\.6\.0\-1\.20210825\.git2fb89a0\.amzn2023\.0\.2  | 
|  glslang\-devel  |  x86\_64  |  glslang  |  11\.6\.0\-1\.20210825\.git2fb89a0\.amzn2023\.0\.2  | 
|  gmp  |  aarch64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp  |  x86\_64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-c\+\+  |  aarch64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-c\+\+  |  x86\_64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-devel  |  aarch64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-devel  |  x86\_64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-static  |  aarch64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gmp\-static  |  x86\_64  |  gmp  |  6\.2\.1\-2\.amzn2023\.0\.2  | 
|  gnat\-srpm\-macros  |  noarch  |  gnat\-srpm\-macros  |  4\-13\.amzn2023\.0\.2  | 
|  gnu\-efi  |  aarch64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi  |  x86\_64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi\-compat  |  aarch64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi\-compat  |  x86\_64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi\-devel  |  noarch  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi\-utils  |  aarch64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  gnu\-efi\-utils  |  x86\_64  |  gnu\-efi  |  3\.0\.11\-9\.amzn2023\.0\.1  | 
|  git\-merge\-changelog  |  aarch64  |  gnulib  |  0\-43\.20220212git\.amzn2023\.0\.2  | 
|  git\-merge\-changelog  |  x86\_64  |  gnulib  |  0\-43\.20220212git\.amzn2023\.0\.2  | 
|  gnulib\-devel  |  noarch  |  gnulib  |  0\-43\.20220212git\.amzn2023\.0\.2  | 
|  gnulib\-docs  |  noarch  |  gnulib  |  0\-43\.20220212git\.amzn2023\.0\.2  | 
|  gnupg2  |  aarch64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnupg2  |  x86\_64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnupg2\-minimal  |  aarch64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnupg2\-minimal  |  x86\_64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnupg2\-smime  |  aarch64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnupg2\-smime  |  x86\_64  |  gnupg2  |  2\.3\.7\-1\.amzn2023\.0\.4  | 
|  gnuplot\-common  |  aarch64  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnuplot\-common  |  x86\_64  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnuplot\-doc  |  noarch  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnuplot\-latex  |  noarch  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnuplot\-minimal  |  aarch64  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnuplot\-minimal  |  x86\_64  |  gnuplot  |  5\.4\.3\-3\.amzn2023\.0\.3  | 
|  gnutls  |  aarch64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls  |  x86\_64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-c\+\+  |  aarch64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-c\+\+  |  x86\_64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-dane  |  aarch64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-dane  |  x86\_64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-devel  |  aarch64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-devel  |  x86\_64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-utils  |  aarch64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gnutls\-utils  |  x86\_64  |  gnutls  |  3\.8\.0\-376\.amzn2023\.0\.2  | 
|  gobject\-introspection  |  aarch64  |  gobject\-introspection  |  1\.73\.0\-2\.amzn2023\.0\.2  | 
|  gobject\-introspection  |  x86\_64  |  gobject\-introspection  |  1\.73\.0\-2\.amzn2023\.0\.2  | 
|  gobject\-introspection\-devel  |  aarch64  |  gobject\-introspection  |  1\.73\.0\-2\.amzn2023\.0\.2  | 
|  gobject\-introspection\-devel  |  x86\_64  |  gobject\-introspection  |  1\.73\.0\-2\.amzn2023\.0\.2  | 
|  golang  |  aarch64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang  |  x86\_64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-bin  |  aarch64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-bin  |  x86\_64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-docs  |  noarch  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-misc  |  noarch  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-race  |  x86\_64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-shared  |  aarch64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-shared  |  x86\_64  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-src  |  noarch  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-tests  |  noarch  |  golang  |  1\.19\.9\-1\.amzn2023\.0\.1  | 
|  golang\-github\-burntsushi\-toml  |  aarch64  |  golang\-github\-burntsushi\-toml  |  0\.3\.1\-9\.amzn2023\.0\.2  | 
|  golang\-github\-burntsushi\-toml  |  x86\_64  |  golang\-github\-burntsushi\-toml  |  0\.3\.1\-9\.amzn2023\.0\.2  | 
|  golang\-github\-burntsushi\-toml\-devel  |  noarch  |  golang\-github\-burntsushi\-toml  |  0\.3\.1\-9\.amzn2023\.0\.2  | 
|  golang\-github\-burntsushi\-toml\-test  |  aarch64  |  golang\-github\-burntsushi\-toml\-test  |  0\.2\.0\-8\.amzn2023\.0\.2  | 
|  golang\-github\-burntsushi\-toml\-test  |  x86\_64  |  golang\-github\-burntsushi\-toml\-test  |  0\.2\.0\-8\.amzn2023\.0\.2  | 
|  golang\-github\-burntsushi\-toml\-test\-devel  |  noarch  |  golang\-github\-burntsushi\-toml\-test  |  0\.2\.0\-8\.amzn2023\.0\.2  | 
|  compat\-golang\-github\-cpuguy83\-md2man\-2\-devel  |  noarch  |  golang\-github\-cpuguy83\-md2man  |  2\.0\.2\-22\.amzn2023\.0\.2  | 
|  golang\-github\-cpuguy83\-md2man  |  aarch64  |  golang\-github\-cpuguy83\-md2man  |  2\.0\.2\-22\.amzn2023\.0\.2  | 
|  golang\-github\-cpuguy83\-md2man  |  x86\_64  |  golang\-github\-cpuguy83\-md2man  |  2\.0\.2\-22\.amzn2023\.0\.2  | 
|  golang\-github\-cpuguy83\-md2man\-devel  |  noarch  |  golang\-github\-cpuguy83\-md2man  |  2\.0\.2\-22\.amzn2023\.0\.2  | 
|  compat\-golang\-github\-codegangsta\-cli\-devel  |  noarch  |  golang\-github\-urfave\-cli  |  1\.22\.5\-2\.amzn2023\.0\.3  | 
|  compat\-golang\-gopkg\-urfave\-cli\-1\-devel  |  noarch  |  golang\-github\-urfave\-cli  |  1\.22\.5\-2\.amzn2023\.0\.3  | 
|  golang\-github\-urfave\-cli\-devel  |  noarch  |  golang\-github\-urfave\-cli  |  1\.22\.5\-2\.amzn2023\.0\.3  | 
|  compat\-golang\-github\-russross\-blackfriday\-2\-devel  |  noarch  |  golang\-gopkg\-russross\-blackfriday\-2  |  2\.1\.0\-2\.amzn2023\.0\.2  | 
|  golang\-gopkg\-russross\-blackfriday\-2\-devel  |  noarch  |  golang\-gopkg\-russross\-blackfriday\-2  |  2\.1\.0\-2\.amzn2023\.0\.2  | 
|  compat\-golang\-gopkg\-2\-yaml\-devel  |  noarch  |  golang\-gopkg\-yaml\-2  |  2\.4\.0\-2\.amzn2023\.0\.2  | 
|  golang\-gopkg\-yaml\-2\-devel  |  noarch  |  golang\-gopkg\-yaml\-2  |  2\.4\.0\-2\.amzn2023\.0\.2  | 
|  golist  |  aarch64  |  golist  |  0\.10\.1\-11\.amzn2023\.0\.3  | 
|  golist  |  x86\_64  |  golist  |  0\.10\.1\-11\.amzn2023\.0\.3  | 
|  google\-crc32c  |  aarch64  |  google\-crc32c  |  1\.1\.2\-7\.amzn2023  | 
|  google\-crc32c  |  x86\_64  |  google\-crc32c  |  1\.1\.2\-7\.amzn2023  | 
|  google\-crc32c\-devel  |  aarch64  |  google\-crc32c  |  1\.1\.2\-7\.amzn2023  | 
|  google\-crc32c\-devel  |  x86\_64  |  google\-crc32c  |  1\.1\.2\-7\.amzn2023  | 
|  google\-droid\-fonts\-all  |  noarch  |  google\-droid\-fonts  |  20200215\-9\.amzn2023\.0\.2  | 
|  google\-droid\-sans\-fonts  |  noarch  |  google\-droid\-fonts  |  20200215\-9\.amzn2023\.0\.2  | 
|  google\-droid\-sans\-mono\-fonts  |  noarch  |  google\-droid\-fonts  |  20200215\-9\.amzn2023\.0\.2  | 
|  google\-droid\-serif\-fonts  |  noarch  |  google\-droid\-fonts  |  20200215\-9\.amzn2023\.0\.2  | 
|  google\-gson  |  noarch  |  google\-gson  |  2\.9\.0\-1\.amzn2023\.0\.2  | 
|  google\-guice  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  google\-guice\-javadoc  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-assistedinject  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-bom  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-extensions  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-grapher  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-jmx  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-jndi  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-multibindings  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-parent  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-servlet  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  guice\-throwingproviders  |  noarch  |  google\-guice  |  4\.2\.3\-8\.amzn2023\.0\.6  | 
|  google\-noto\-cjk\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-cjk\-fonts\-common  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-hk\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-jp\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-kr\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-sc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-tc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cjk\-ttc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hk\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-jp\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kr\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-cjk\-hk\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-cjk\-jp\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-cjk\-kr\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-cjk\-sc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-cjk\-tc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-cjk\-jp\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-cjk\-kr\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-cjk\-sc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-cjk\-tc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-cjk\-ttc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-jp\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-kr\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-sc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tc\-fonts  |  noarch  |  google\-noto\-cjk\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-emoji\-color\-fonts  |  noarch  |  google\-noto\-emoji\-fonts  |  20200916\-2\.amzn2023\.0\.2  | 
|  google\-noto\-emoji\-fonts  |  noarch  |  google\-noto\-emoji\-fonts  |  20200916\-2\.amzn2023\.0\.2  | 
|  google\-noto\-fonts\-common  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-kufi\-arabic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-kufi\-arabic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-music\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-naskh\-arabic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-naskh\-arabic\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-naskh\-arabic\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-naskh\-arabic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-nastaliq\-urdu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-rashi\-hebrew\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-rashi\-hebrew\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-adlam\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-adlam\-unjoined\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-adlam\-unjoined\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-adlam\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-anatolian\-hieroglyphs\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-anatolian\-hieroglyphs\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-arabic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-arabic\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-arabic\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-arabic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-armenian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-armenian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-avestan\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-avestan\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-balinese\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-balinese\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bamum\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bamum\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bassa\-vah\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bassa\-vah\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-batak\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bengali\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bengali\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bengali\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bengali\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-bhaiksuki\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-brahmi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-buginese\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-buginese\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-buhid\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-buhid\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-canadian\-aboriginal\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-canadian\-aboriginal\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-carian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-carian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-caucasian\-albanian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-chakma\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cham\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cham\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cherokee\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cherokee\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-coptic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cuneiform\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cuneiform\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cypriot\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-cypriot\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-deseret\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-deseret\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-devanagari\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-devanagari\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-devanagari\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-devanagari\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-display\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-display\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-duployan\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-egyptian\-hieroglyphs\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-egyptian\-hieroglyphs\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-elbasan\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-elymaic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-elymaic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ethiopic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ethiopic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-georgian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-georgian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-glagolitic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gothic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gothic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-grantha\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gujarati\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gujarati\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gunjala\-gondi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gurmukhi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gurmukhi\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gurmukhi\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-gurmukhi\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hanifi\-rohingya\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hanifi\-rohingya\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hanunoo\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hatran\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hatran\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hebrew\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-hebrew\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-imperial\-aramaic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-imperial\-aramaic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-indic\-siyaq\-numbers\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-inscriptional\-pahlavi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-inscriptional\-parthian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-javanese\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kaithi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kannada\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kannada\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kannada\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kannada\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kayah\-li\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kayah\-li\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-kharoshthi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khmer\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khmer\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khmer\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khmer\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khojki\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-khudawadi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-looped\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-looped\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lao\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lepcha\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-limbu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-linear\-a\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-linear\-a\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-linear\-b\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-linear\-b\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lisu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lisu\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lycian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lycian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lydian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-lydian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mahajani\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-malayalam\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-malayalam\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-malayalam\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-malayalam\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mandaic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mandaic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-manichaean\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-marchen\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-marchen\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-masaram\-gondi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-math\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-math\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mayan\-numerals\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mayan\-numerals\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-medefaidrin\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-medefaidrin\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-meetei\-mayek\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-meeteimayek\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mende\-kikakui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-meroitic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-miao\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-modi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mongolian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mono\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mro\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-mro\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-multani\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-multani\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-myanmar\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-myanmar\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-myanmar\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-myanmar\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-nabataean\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-nabataean\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-newa\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-new\-tai\-lue\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-new\-tai\-lue\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-nko\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-nushu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ogham\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ogham\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ol\-chiki\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ol\-chiki\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-hungarian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-italic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-north\-arabian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-permic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-persian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-sogdian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-south\-arabian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-old\-turkic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-oriya\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-oriya\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-osage\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-osmanya\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-osmanya\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-pahawh\-hmong\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-palmyrene\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-pau\-cin\-hau\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-phags\-pa\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-phoenician\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-phoenician\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-psalter\-pahlavi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-rejang\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-runic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-runic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-samaritan\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-saurashtra\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sharada\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-shavian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-shavian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-siddham\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-signwriting\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sinhala\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sinhala\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sinhala\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sinhala\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sogdian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sora\-sompeng\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sora\-sompeng\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-soyombo\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-soyombo\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sundanese\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-sundanese\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-syloti\-nagri\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-symbols2\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-symbols\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-symbols\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-syriac\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tagalog\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tagbanwa\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tagbanwa\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tai\-le\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tai\-tham\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tai\-tham\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tai\-viet\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-takri\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-takri\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-supplement\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-supplement\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tamil\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-telugu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-telugu\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-telugu\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-telugu\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thaana\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thaana\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thai\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thai\-looped\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sansthai\-looped\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thai\-ui\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thai\-ui\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-thai\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-adrar\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-agraw\-imazighen\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-ahaggar\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-air\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-apt\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-azawagh\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-ghat\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-hawad\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-rhissa\-ixa\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-sil\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tifinagh\-tawellemmet\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-tirhuta\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ugaritic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-ugaritic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-vai\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-vai\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-wancho\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-wancho\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-warang\-citi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-warang\-citi\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-yi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-yi\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-zanabazar\-square\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-sans\-zanabazar\-square\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-ahom\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-armenian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-armenian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-balinese\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-bengali\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-bengali\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-devanagari\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-devanagari\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-display\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-display\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-dogra\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-ethiopic\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-ethiopic\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-georgian\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-georgian\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-grantha\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-gujarati\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-gujarati\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-gurmukhi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-gurmukhi\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-hebrew\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-hebrew\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-kannada\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-kannada\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-khmer\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-khmer\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-khojki\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-khojki\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-lao\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-lao\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-malayalam\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-malayalam\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-myanmar\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-nyiakeng\-puachue\-hmong\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-nyiakeng\-puachue\-hmong\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-sinhala\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-sinhala\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tamil\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tamil\-slanted\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tamil\-slanted\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tamil\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tangut\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tangut\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-telugu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-telugu\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-thai\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-thai\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tibetan\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-tibetan\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-yezidi\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-serif\-yezidi\-vf\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-noto\-traditional\-nushu\-fonts  |  noarch  |  google\-noto\-fonts  |  20201206\-2\.amzn2023\.0\.2  | 
|  google\-roboto\-slab\-fonts  |  noarch  |  google\-roboto\-slab\-fonts  |  1\.100263\-0\.15\.20150923git\.amzn2023\.0\.2  | 
|  go\-filesystem  |  aarch64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-filesystem  |  x86\_64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-rpm\-macros  |  aarch64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-rpm\-macros  |  x86\_64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-rpm\-templates  |  aarch64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-rpm\-templates  |  x86\_64  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  go\-srpm\-macros  |  noarch  |  go\-rpm\-macros  |  3\.1\.0\-32\.amzn2023\.0\.2  | 
|  gperf  |  aarch64  |  gperf  |  3\.1\-11\.amzn2023\.0\.2  | 
|  gperf  |  x86\_64  |  gperf  |  3\.1\-11\.amzn2023\.0\.2  | 
|  gperftools  |  aarch64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gperftools  |  x86\_64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gperftools\-devel  |  aarch64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gperftools\-devel  |  x86\_64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gperftools\-libs  |  aarch64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gperftools\-libs  |  x86\_64  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  pprof  |  noarch  |  gperftools  |  2\.9\.1\-1\.amzn2023\.0\.2  | 
|  gpgme  |  aarch64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgme  |  x86\_64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgme\-devel  |  aarch64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgme\-devel  |  x86\_64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgmepp  |  aarch64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgmepp  |  x86\_64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgmepp\-devel  |  aarch64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpgmepp\-devel  |  x86\_64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  python3\-gpg  |  aarch64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  python3\-gpg  |  x86\_64  |  gpgme  |  1\.15\.1\-6\.amzn2023\.0\.3  | 
|  gpm  |  aarch64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm  |  x86\_64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-devel  |  aarch64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-devel  |  x86\_64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-libs  |  aarch64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-libs  |  x86\_64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-static  |  aarch64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  gpm\-static  |  x86\_64  |  gpm  |  1\.20\.7\-26\.amzn2023\.amzn2023\.0\.3  | 
|  GraphicsMagick  |  aarch64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick  |  x86\_64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-c\+\+  |  aarch64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-c\+\+  |  x86\_64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-c\+\+\-devel  |  aarch64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-c\+\+\-devel  |  x86\_64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-devel  |  aarch64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-devel  |  x86\_64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-doc  |  noarch  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-perl  |  aarch64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  GraphicsMagick\-perl  |  x86\_64  |  GraphicsMagick  |  1\.3\.38\-1\.amzn2023\.0\.4  | 
|  graphite2  |  aarch64  |  graphite2  |  1\.3\.14\-7\.amzn2023\.0\.2  | 
|  graphite2  |  x86\_64  |  graphite2  |  1\.3\.14\-7\.amzn2023\.0\.2  | 
|  graphite2\-devel  |  aarch64  |  graphite2  |  1\.3\.14\-7\.amzn2023\.0\.2  | 
|  graphite2\-devel  |  x86\_64  |  graphite2  |  1\.3\.14\-7\.amzn2023\.0\.2  | 
|  graphviz  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-devel  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-devel  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-doc  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-doc  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-gd  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-gd  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-graphs  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-graphs  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-java  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-java  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-lua  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-lua  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-ocaml  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-ocaml  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-perl  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-perl  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-tcl  |  aarch64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  graphviz\-tcl  |  x86\_64  |  graphviz  |  2\.44\.0\-25\.amzn2023\.0\.6  | 
|  grep  |  aarch64  |  grep  |  3\.8\-1\.amzn2023\.0\.4  | 
|  grep  |  x86\_64  |  grep  |  3\.8\-1\.amzn2023\.0\.4  | 
|  groff  |  aarch64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff  |  x86\_64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-base  |  aarch64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-base  |  x86\_64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-doc  |  noarch  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-perl  |  aarch64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-perl  |  x86\_64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-x11  |  aarch64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  groff\-x11  |  x86\_64  |  groff  |  1\.22\.4\-7\.amzn2023\.0\.2  | 
|  grpc  |  aarch64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc  |  x86\_64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-cpp  |  aarch64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-cpp  |  x86\_64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-data  |  noarch  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-devel  |  aarch64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-devel  |  x86\_64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-doc  |  noarch  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-plugins  |  aarch64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grpc\-plugins  |  x86\_64  |  grpc  |  1\.41\.1\-9\.amzn2023  | 
|  grub2\-common  |  noarch  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-aa64  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-aa64\-cdboot  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-aa64\-ec2  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-aa64\-modules  |  noarch  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-x64  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-x64\-cdboot  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-x64\-ec2  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-efi\-x64\-modules  |  noarch  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-emu  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-emu  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-emu\-modules  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-emu\-modules  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-pc  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-pc\-modules  |  noarch  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools\-efi  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools\-extra  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools\-extra  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools\-minimal  |  aarch64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grub2\-tools\-minimal  |  x86\_64  |  grub2  |  2\.06\-61\.amzn2023\.0\.7  | 
|  grubby  |  aarch64  |  grubby  |  8\.40\-51\.amzn2023\.0\.4  | 
|  grubby  |  x86\_64  |  grubby  |  8\.40\-51\.amzn2023\.0\.4  | 
|  grubby\-deprecated  |  aarch64  |  grubby  |  8\.40\-51\.amzn2023\.0\.4  | 
|  grubby\-deprecated  |  x86\_64  |  grubby  |  8\.40\-51\.amzn2023\.0\.4  | 
|  gsettings\-desktop\-schemas  |  aarch64  |  gsettings\-desktop\-schemas  |  40\.0\-1\.amzn2023\.0\.3  | 
|  gsettings\-desktop\-schemas  |  x86\_64  |  gsettings\-desktop\-schemas  |  40\.0\-1\.amzn2023\.0\.3  | 
|  gsettings\-desktop\-schemas\-devel  |  aarch64  |  gsettings\-desktop\-schemas  |  40\.0\-1\.amzn2023\.0\.3  | 
|  gsettings\-desktop\-schemas\-devel  |  x86\_64  |  gsettings\-desktop\-schemas  |  40\.0\-1\.amzn2023\.0\.3  | 
|  gsl  |  aarch64  |  gsl  |  2\.6\-4\.amzn2023\.0\.3  | 
|  gsl  |  x86\_64  |  gsl  |  2\.6\-4\.amzn2023\.0\.3  | 
|  gsl\-devel  |  aarch64  |  gsl  |  2\.6\-4\.amzn2023\.0\.3  | 
|  gsl\-devel  |  x86\_64  |  gsl  |  2\.6\-4\.amzn2023\.0\.3  | 
|  gsm  |  aarch64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gsm  |  x86\_64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gsm\-devel  |  aarch64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gsm\-devel  |  x86\_64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gsm\-tools  |  aarch64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gsm\-tools  |  x86\_64  |  gsm  |  1\.0\.19\-5\.amzn2023\.0\.3  | 
|  gssdp  |  aarch64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp  |  x86\_64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp\-devel  |  aarch64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp\-devel  |  x86\_64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp\-docs  |  noarch  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp\-utils  |  aarch64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssdp\-utils  |  x86\_64  |  gssdp  |  1\.2\.3\-3\.amzn2023\.0\.3  | 
|  gssproxy  |  aarch64  |  gssproxy  |  0\.8\.4\-2\.amzn2023\.0\.3  | 
|  gssproxy  |  x86\_64  |  gssproxy  |  0\.8\.4\-2\.amzn2023\.0\.3  | 
|  gmock  |  aarch64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gmock  |  x86\_64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gmock\-devel  |  aarch64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gmock\-devel  |  x86\_64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gtest  |  aarch64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gtest  |  x86\_64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gtest\-devel  |  aarch64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gtest\-devel  |  x86\_64  |  gtest  |  1\.11\.0\-1\.amzn2023\.0\.3  | 
|  gtk3  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-devel  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-devel  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-devel\-docs  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-devel\-docs  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-immodules  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-immodules  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-immodule\-xim  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-immodule\-xim  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-tests  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk3\-tests  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk\-update\-icon\-cache  |  aarch64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk\-update\-icon\-cache  |  x86\_64  |  gtk3  |  3\.24\.30\-4\.amzn2023\.0\.4  | 
|  gtk\-doc  |  aarch64  |  gtk\-doc  |  1\.33\.2\-3\.amzn2023\.0\.4  | 
|  gtk\-doc  |  x86\_64  |  gtk\-doc  |  1\.33\.2\-3\.amzn2023\.0\.4  | 
|  guava  |  noarch  |  guava  |  31\.0\.1\-3\.amzn2023\.0\.4  | 
|  guava\-javadoc  |  noarch  |  guava  |  31\.0\.1\-3\.amzn2023\.0\.4  | 
|  guava\-testlib  |  noarch  |  guava  |  31\.0\.1\-3\.amzn2023\.0\.4  | 
|  guile22  |  aarch64  |  guile22  |  2\.2\.7\-2\.amzn2023\.0\.2  | 
|  guile22  |  x86\_64  |  guile22  |  2\.2\.7\-2\.amzn2023\.0\.2  | 
|  guile22\-devel  |  aarch64  |  guile22  |  2\.2\.7\-2\.amzn2023\.0\.2  | 
|  guile22\-devel  |  x86\_64  |  guile22  |  2\.2\.7\-2\.amzn2023\.0\.2  | 
|  gv  |  aarch64  |  gv  |  3\.7\.4\-25\.amzn2023\.0\.3  | 
|  gv  |  x86\_64  |  gv  |  3\.7\.4\-25\.amzn2023\.0\.3  | 
|  gzip  |  aarch64  |  gzip  |  1\.12\-1\.amzn2023\.0\.1  | 
|  gzip  |  x86\_64  |  gzip  |  1\.12\-1\.amzn2023\.0\.1  | 
|  hamcrest  |  noarch  |  hamcrest  |  2\.2\-7\.amzn2023\.0\.3  | 
|  hamcrest\-javadoc  |  noarch  |  hamcrest  |  2\.2\-7\.amzn2023\.0\.3  | 
|  haproxy  |  aarch64  |  haproxy  |  2\.8\.0\-1\.amzn2023\.0\.1  | 
|  haproxy  |  x86\_64  |  haproxy  |  2\.8\.0\-1\.amzn2023\.0\.1  | 
|  harfbuzz  |  aarch64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  harfbuzz  |  x86\_64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  harfbuzz\-devel  |  aarch64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  harfbuzz\-devel  |  x86\_64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  harfbuzz\-icu  |  aarch64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  harfbuzz\-icu  |  x86\_64  |  harfbuzz  |  7\.0\.0\-2\.amzn2023\.0\.1  | 
|  hawtjni  |  noarch  |  hawtjni  |  1\.18\-4\.amzn2023\.0\.2  | 
|  hawtjni\-javadoc  |  noarch  |  hawtjni  |  1\.18\-4\.amzn2023\.0\.2  | 
|  hawtjni\-runtime  |  noarch  |  hawtjni  |  1\.18\-4\.amzn2023\.0\.2  | 
|  maven\-hawtjni\-plugin  |  noarch  |  hawtjni  |  1\.18\-4\.amzn2023\.0\.2  | 
|  hdparm  |  aarch64  |  hdparm  |  9\.65\-1\.amzn2023\.0\.1  | 
|  hdparm  |  x86\_64  |  hdparm  |  9\.65\-1\.amzn2023\.0\.1  | 
|  help2man  |  noarch  |  help2man  |  1\.48\.5\-1\.amzn2023\.0\.3  | 
|  hicolor\-icon\-theme  |  noarch  |  hicolor\-icon\-theme  |  0\.17\-10\.amzn2023\.0\.3  | 
|  hidapi  |  aarch64  |  hidapi  |  0\.10\.1\-3\.amzn2023\.0\.3  | 
|  hidapi  |  x86\_64  |  hidapi  |  0\.10\.1\-3\.amzn2023\.0\.3  | 
|  hidapi\-devel  |  aarch64  |  hidapi  |  0\.10\.1\-3\.amzn2023\.0\.3  | 
|  hidapi\-devel  |  x86\_64  |  hidapi  |  0\.10\.1\-3\.amzn2023\.0\.3  | 
|  highlight  |  aarch64  |  highlight  |  4\.2\-2\.amzn2023\.0\.4  | 
|  highlight  |  x86\_64  |  highlight  |  4\.2\-2\.amzn2023\.0\.4  | 
|  hostname  |  aarch64  |  hostname  |  3\.23\-4\.amzn2023\.0\.3  | 
|  hostname  |  x86\_64  |  hostname  |  3\.23\-4\.amzn2023\.0\.3  | 
|  html2ps  |  noarch  |  html2ps  |  1\.0\-0\.39\.b7\.amzn2023\.0\.3  | 
|  xhtml2ps  |  noarch  |  html2ps  |  1\.0\-0\.39\.b7\.amzn2023\.0\.3  | 
|  htop  |  aarch64  |  htop  |  3\.2\.1\-87\.amzn2023\.0\.3  | 
|  htop  |  x86\_64  |  htop  |  3\.2\.1\-87\.amzn2023\.0\.3  | 
|  httpcomponents\-client  |  noarch  |  httpcomponents\-client  |  4\.5\.13\-4\.amzn2023\.0\.4  | 
|  httpcomponents\-client\-javadoc  |  noarch  |  httpcomponents\-client  |  4\.5\.13\-4\.amzn2023\.0\.4  | 
|  httpcomponents\-core  |  noarch  |  httpcomponents\-core  |  4\.4\.13\-6\.amzn2023\.0\.3  | 
|  httpcomponents\-core\-javadoc  |  noarch  |  httpcomponents\-core  |  4\.4\.13\-6\.amzn2023\.0\.3  | 
|  httpcomponents\-project  |  noarch  |  httpcomponents\-project  |  12\-6\.amzn2023\.0\.3  | 
|  httpd  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-core  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-core  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-devel  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-devel  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-filesystem  |  noarch  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-manual  |  noarch  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-tools  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  httpd\-tools  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_ldap  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_ldap  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_lua  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_lua  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_proxy\_html  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_proxy\_html  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_session  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_session  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_ssl  |  aarch64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  mod\_ssl  |  x86\_64  |  httpd  |  2\.4\.56\-1\.amzn2023  | 
|  hunspell  |  aarch64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell  |  x86\_64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell\-devel  |  aarch64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell\-devel  |  x86\_64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell\-filesystem  |  aarch64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell\-filesystem  |  x86\_64  |  hunspell  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  hunspell\-en  |  noarch  |  hunspell\-en  |  0\.20140811\.1\-18\.amzn2023\.0\.3  | 
|  hunspell\-en\-GB  |  noarch  |  hunspell\-en  |  0\.20140811\.1\-18\.amzn2023\.0\.3  | 
|  hunspell\-en\-US  |  noarch  |  hunspell\-en  |  0\.20140811\.1\-18\.amzn2023\.0\.3  | 
|  hwdata  |  noarch  |  hwdata  |  0\.353\-1\.amzn2023\.0\.3  | 
|  hwloc  |  aarch64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc  |  x86\_64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-devel  |  aarch64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-devel  |  x86\_64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-gui  |  aarch64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-gui  |  x86\_64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-libs  |  aarch64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-libs  |  x86\_64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-plugins  |  aarch64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  hwloc\-plugins  |  x86\_64  |  hwloc  |  2\.4\.1\-3\.amzn2023\.0\.3  | 
|  ibus  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-desktop\-testing  |  noarch  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-devel  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-devel  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-devel\-docs  |  noarch  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-gtk3  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-gtk3  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-libs  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-libs  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-setup  |  noarch  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-tests  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-tests  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-wayland  |  aarch64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-wayland  |  x86\_64  |  ibus  |  1\.5\.26\-7\.amzn2023\.0\.4  | 
|  ibus\-anthy  |  aarch64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy  |  x86\_64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy\-devel  |  aarch64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy\-devel  |  x86\_64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy\-python  |  noarch  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy\-tests  |  aarch64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-anthy\-tests  |  x86\_64  |  ibus\-anthy  |  1\.5\.14\-4\.amzn2023\.0\.1  | 
|  ibus\-hangul  |  aarch64  |  ibus\-hangul  |  1\.5\.4\-5\.amzn2023\.0\.4  | 
|  ibus\-hangul  |  x86\_64  |  ibus\-hangul  |  1\.5\.4\-5\.amzn2023\.0\.4  | 
|  ibus\-hangul\-tests  |  aarch64  |  ibus\-hangul  |  1\.5\.4\-5\.amzn2023\.0\.4  | 
|  ibus\-hangul\-tests  |  x86\_64  |  ibus\-hangul  |  1\.5\.4\-5\.amzn2023\.0\.4  | 
|  ibus\-libpinyin  |  aarch64  |  ibus\-libpinyin  |  1\.12\.0\-3\.amzn2023\.0\.3  | 
|  ibus\-libpinyin  |  x86\_64  |  ibus\-libpinyin  |  1\.12\.0\-3\.amzn2023\.0\.3  | 
|  ibus\-libzhuyin  |  aarch64  |  ibus\-libzhuyin  |  1\.10\.0\-2\.amzn2023\.0\.3  | 
|  ibus\-libzhuyin  |  x86\_64  |  ibus\-libzhuyin  |  1\.10\.0\-2\.amzn2023\.0\.3  | 
|  ibus\-m17n  |  aarch64  |  ibus\-m17n  |  1\.4\.5\-1\.amzn2023\.0\.4  | 
|  ibus\-m17n  |  x86\_64  |  ibus\-m17n  |  1\.4\.5\-1\.amzn2023\.0\.4  | 
|  ibus\-table  |  noarch  |  ibus\-table  |  1\.16\.8\-1\.amzn2023\.0\.5  | 
|  ibus\-table\-devel  |  noarch  |  ibus\-table  |  1\.16\.8\-1\.amzn2023\.0\.5  | 
|  ibus\-table\-tests  |  noarch  |  ibus\-table  |  1\.16\.8\-1\.amzn2023\.0\.5  | 
|  ibus\-table\-chinese  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-array  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-cangjie  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-cantonese  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-cantonyale  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-easy  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-erbi  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-quick  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-scj  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-stroke5  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-wu  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-wubi\-haifeng  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-wubi\-jidian  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-chinese\-yong  |  noarch  |  ibus\-table\-chinese  |  1\.8\.8\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-code  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-cyrillic  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-latin  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-mathwriter  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-mongol  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-others  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-translit  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  ibus\-table\-tv  |  noarch  |  ibus\-table\-others  |  1\.3\.13\-1\.amzn2023\.0\.4  | 
|  icc\-profiles\-openicc  |  noarch  |  icc\-profiles\-openicc  |  1\.3\.1\-20\.amzn2023\.0\.3  | 
|  icu  |  aarch64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  icu  |  x86\_64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  libicu  |  aarch64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  libicu  |  x86\_64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  libicu\-devel  |  aarch64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  libicu\-devel  |  x86\_64  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  libicu\-doc  |  noarch  |  icu  |  67\.1\-7\.amzn2023\.0\.3  | 
|  iftop  |  aarch64  |  iftop  |  1\.0\-0\.30\.pre4\.amzn2023  | 
|  iftop  |  x86\_64  |  iftop  |  1\.0\-0\.30\.pre4\.amzn2023  | 
|  ima\-evm\-utils  |  aarch64  |  ima\-evm\-utils  |  1\.4\-7\.amzn2023  | 
|  ima\-evm\-utils  |  x86\_64  |  ima\-evm\-utils  |  1\.4\-7\.amzn2023  | 
|  ima\-evm\-utils\-devel  |  aarch64  |  ima\-evm\-utils  |  1\.4\-7\.amzn2023  | 
|  ima\-evm\-utils\-devel  |  x86\_64  |  ima\-evm\-utils  |  1\.4\-7\.amzn2023  | 
|  ImageMagick  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-c\+\+  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-c\+\+  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-c\+\+\-devel  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-c\+\+\-devel  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-devel  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-devel  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-doc  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-doc  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-libs  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-libs  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-perl  |  aarch64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  ImageMagick\-perl  |  x86\_64  |  ImageMagick  |  6\.9\.12\.82\-1\.amzn2023\.0\.3  | 
|  imath  |  aarch64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  imath  |  x86\_64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  imath\-devel  |  aarch64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  imath\-devel  |  x86\_64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  python3\-imath  |  aarch64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  python3\-imath  |  x86\_64  |  imath  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  indent  |  aarch64  |  indent  |  2\.2\.12\-7\.amzn2023\.0\.3  | 
|  indent  |  x86\_64  |  indent  |  2\.2\.12\-7\.amzn2023\.0\.3  | 
|  infinipath\-psm  |  x86\_64  |  infinipath\-psm  |  3\.3\-26\_g604758e\_open\.6\.amzn2023\.3\.0\.3  | 
|  infinipath\-psm\-devel  |  x86\_64  |  infinipath\-psm  |  3\.3\-26\_g604758e\_open\.6\.amzn2023\.3\.0\.3  | 
|  inih  |  aarch64  |  inih  |  49\-3\.amzn2023\.0\.2  | 
|  inih  |  x86\_64  |  inih  |  49\-3\.amzn2023\.0\.2  | 
|  inih\-devel  |  aarch64  |  inih  |  49\-3\.amzn2023\.0\.2  | 
|  inih\-devel  |  x86\_64  |  inih  |  49\-3\.amzn2023\.0\.2  | 
|  initscripts  |  aarch64  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  initscripts  |  x86\_64  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  netconsole\-service  |  noarch  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  network\-scripts  |  aarch64  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  network\-scripts  |  x86\_64  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  readonly\-root  |  noarch  |  initscripts  |  10\.09\-1\.amzn2023\.0\.2  | 
|  inotify\-tools  |  aarch64  |  inotify\-tools  |  3\.22\.1\.0\-4\.amzn2023  | 
|  inotify\-tools  |  x86\_64  |  inotify\-tools  |  3\.22\.1\.0\-4\.amzn2023  | 
|  inotify\-tools\-devel  |  aarch64  |  inotify\-tools  |  3\.22\.1\.0\-4\.amzn2023  | 
|  inotify\-tools\-devel  |  x86\_64  |  inotify\-tools  |  3\.22\.1\.0\-4\.amzn2023  | 
|  intltool  |  noarch  |  intltool  |  0\.51\.0\-18\.amzn2023\.0\.3  | 
|  iotop  |  aarch64  |  iotop  |  0\.6\-29\.amzn2023\.0\.3  | 
|  iotop  |  x86\_64  |  iotop  |  0\.6\-29\.amzn2023\.0\.3  | 
|  ipcalc  |  aarch64  |  ipcalc  |  1\.0\.1\-1\.amzn2023\.0\.5  | 
|  ipcalc  |  x86\_64  |  ipcalc  |  1\.0\.1\-1\.amzn2023\.0\.5  | 
|  iperf3  |  aarch64  |  iperf3  |  3\.11\-1\.amzn2023\.0\.3  | 
|  iperf3  |  x86\_64  |  iperf3  |  3\.11\-1\.amzn2023\.0\.3  | 
|  iperf3\-devel  |  aarch64  |  iperf3  |  3\.11\-1\.amzn2023\.0\.3  | 
|  iperf3\-devel  |  x86\_64  |  iperf3  |  3\.11\-1\.amzn2023\.0\.3  | 
|  iproute  |  aarch64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  iproute  |  x86\_64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  iproute\-devel  |  aarch64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  iproute\-devel  |  x86\_64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  iproute\-tc  |  aarch64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  iproute\-tc  |  x86\_64  |  iproute  |  5\.10\.0\-2\.amzn2023\.0\.5  | 
|  ipset  |  aarch64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset  |  x86\_64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset\-devel  |  aarch64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset\-devel  |  x86\_64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset\-libs  |  aarch64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset\-libs  |  x86\_64  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  ipset\-service  |  noarch  |  ipset  |  7\.11\-1\.amzn2023\.0\.3  | 
|  iptables\-devel  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-devel  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy\-devel  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy\-devel  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy\-libs  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-legacy\-libs  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-libs  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-libs  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-nft  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-nft  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-services  |  noarch  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-utils  |  aarch64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iptables\-utils  |  x86\_64  |  iptables  |  1\.8\.8\-3\.amzn2023\.0\.2  | 
|  iputils  |  aarch64  |  iputils  |  20210202\-2\.amzn2023\.0\.3  | 
|  iputils  |  x86\_64  |  iputils  |  20210202\-2\.amzn2023\.0\.3  | 
|  iputils\-ninfod  |  aarch64  |  iputils  |  20210202\-2\.amzn2023\.0\.3  | 
|  iputils\-ninfod  |  x86\_64  |  iputils  |  20210202\-2\.amzn2023\.0\.3  | 
|  ipvsadm  |  aarch64  |  ipvsadm  |  1\.31\-9\.amzn2023\.0\.1  | 
|  ipvsadm  |  x86\_64  |  ipvsadm  |  1\.31\-9\.amzn2023\.0\.1  | 
|  irqbalance  |  aarch64  |  irqbalance  |  1\.9\.0\-1\.amzn2023\.0\.3  | 
|  irqbalance  |  x86\_64  |  irqbalance  |  1\.9\.0\-1\.amzn2023\.0\.3  | 
|  iscsi\-initiator\-utils  |  aarch64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  iscsi\-initiator\-utils  |  x86\_64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  iscsi\-initiator\-utils\-devel  |  aarch64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  iscsi\-initiator\-utils\-devel  |  x86\_64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  iscsi\-initiator\-utils\-iscsiuio  |  aarch64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  iscsi\-initiator\-utils\-iscsiuio  |  x86\_64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  python3\-iscsi\-initiator\-utils  |  aarch64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  python3\-iscsi\-initiator\-utils  |  x86\_64  |  iscsi\-initiator\-utils  |  6\.2\.1\.4\-10\.git2a8f9d8\.amzn2023  | 
|  isl  |  aarch64  |  isl  |  0\.16\.1\-13\.amzn2023\.0\.3  | 
|  isl  |  x86\_64  |  isl  |  0\.16\.1\-13\.amzn2023\.0\.3  | 
|  isl\-devel  |  aarch64  |  isl  |  0\.16\.1\-13\.amzn2023\.0\.3  | 
|  isl\-devel  |  x86\_64  |  isl  |  0\.16\.1\-13\.amzn2023\.0\.3  | 
|  isns\-utils  |  aarch64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  isns\-utils  |  x86\_64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  isns\-utils\-devel  |  aarch64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  isns\-utils\-devel  |  x86\_64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  isns\-utils\-libs  |  aarch64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  isns\-utils\-libs  |  x86\_64  |  isns\-utils  |  0\.101\-6\.amzn2023  | 
|  iso\-codes  |  noarch  |  iso\-codes  |  4\.6\.0\-1\.amzn2023\.0\.3  | 
|  iso\-codes\-devel  |  noarch  |  iso\-codes  |  4\.6\.0\-1\.amzn2023\.0\.3  | 
|  itstool  |  noarch  |  itstool  |  2\.0\.6\-5\.amzn2023\.0\.3  | 
|  jackson\-annotations  |  noarch  |  jackson\-annotations  |  2\.11\.4\-6\.amzn2023\.0\.1  | 
|  jackson\-annotations\-javadoc  |  noarch  |  jackson\-annotations  |  2\.11\.4\-6\.amzn2023\.0\.1  | 
|  jackson\-bom  |  noarch  |  jackson\-bom  |  2\.11\.4\-5\.amzn2023\.0\.1  | 
|  jackson\-core  |  noarch  |  jackson\-core  |  2\.11\.4\-7\.amzn2023\.0\.2  | 
|  jackson\-databind  |  noarch  |  jackson\-databind  |  2\.11\.4\-6\.amzn2023\.0\.1  | 
|  jackson\-parent  |  noarch  |  jackson\-parent  |  2\.11\-7\.amzn2023\.0\.1  | 
|  jakarta\-activation  |  noarch  |  jakarta\-activation  |  1\.2\.2\-6\.amzn2023\.0\.1  | 
|  jakarta\-activation\-javadoc  |  noarch  |  jakarta\-activation  |  1\.2\.2\-6\.amzn2023\.0\.1  | 
|  jakarta\-annotations  |  noarch  |  jakarta\-annotations  |  1\.3\.5\-13\.amzn2023\.0\.3  | 
|  jakarta\-annotations\-javadoc  |  noarch  |  jakarta\-annotations  |  1\.3\.5\-13\.amzn2023\.0\.3  | 
|  jakarta\-el  |  noarch  |  jakarta\-el  |  4\.0\.0\-7\.amzn2023\.0\.1  | 
|  jakarta\-el\-api  |  noarch  |  jakarta\-el  |  4\.0\.0\-7\.amzn2023\.0\.1  | 
|  jakarta\-el\-javadoc  |  noarch  |  jakarta\-el  |  4\.0\.0\-7\.amzn2023\.0\.1  | 
|  jakarta\-interceptors  |  noarch  |  jakarta\-interceptors  |  2\.0\.0\-5\.amzn2023\.0\.1  | 
|  jakarta\-interceptors\-javadoc  |  noarch  |  jakarta\-interceptors  |  2\.0\.0\-5\.amzn2023\.0\.1  | 
|  jakarta\-mail  |  noarch  |  jakarta\-mail  |  1\.6\.5\-8\.amzn2023\.0\.1  | 
|  jakarta\-oro  |  noarch  |  jakarta\-oro  |  2\.0\.8\-36\.amzn2023\.0\.1  | 
|  jakarta\-oro\-javadoc  |  noarch  |  jakarta\-oro  |  2\.0\.8\-36\.amzn2023\.0\.1  | 
|  jakarta\-saaj  |  noarch  |  jakarta\-saaj  |  1\.4\.2\-6\.amzn2023\.0\.2  | 
|  jakarta\-saaj\-javadoc  |  noarch  |  jakarta\-saaj  |  1\.4\.2\-6\.amzn2023\.0\.2  | 
|  jakarta\-server\-pages  |  noarch  |  jakarta\-server\-pages  |  2\.3\.6\-7\.amzn2023\.0\.1  | 
|  jakarta\-server\-pages\-api  |  noarch  |  jakarta\-server\-pages  |  2\.3\.6\-7\.amzn2023\.0\.1  | 
|  jakarta\-server\-pages\-javadoc  |  noarch  |  jakarta\-server\-pages  |  2\.3\.6\-7\.amzn2023\.0\.1  | 
|  jakarta\-servlet  |  noarch  |  jakarta\-servlet  |  5\.0\.0\-10\.amzn2023\.0\.3  | 
|  jakarta\-servlet\-javadoc  |  noarch  |  jakarta\-servlet  |  5\.0\.0\-10\.amzn2023\.0\.3  | 
|  commons\-compiler  |  noarch  |  janino  |  3\.1\.7\-1\.amzn2023\.0\.1  | 
|  commons\-compiler\-jdk  |  noarch  |  janino  |  3\.1\.7\-1\.amzn2023\.0\.1  | 
|  janino  |  noarch  |  janino  |  3\.1\.7\-1\.amzn2023\.0\.1  | 
|  janino\-javadoc  |  noarch  |  janino  |  3\.1\.7\-1\.amzn2023\.0\.1  | 
|  jansi  |  aarch64  |  jansi  |  2\.4\.0\-3\.amzn2023\.0\.3  | 
|  jansi  |  x86\_64  |  jansi  |  2\.4\.0\-3\.amzn2023\.0\.3  | 
|  jansi\-javadoc  |  aarch64  |  jansi  |  2\.4\.0\-3\.amzn2023\.0\.3  | 
|  jansi\-javadoc  |  x86\_64  |  jansi  |  2\.4\.0\-3\.amzn2023\.0\.3  | 
|  jansi1  |  noarch  |  jansi1  |  1\.18\-11\.amzn2023\.0\.1  | 
|  jansi1\-javadoc  |  noarch  |  jansi1  |  1\.18\-11\.amzn2023\.0\.1  | 
|  jansi\-native  |  aarch64  |  jansi\-native  |  1\.8\-9\.amzn2023\.0\.2  | 
|  jansi\-native  |  x86\_64  |  jansi\-native  |  1\.8\-9\.amzn2023\.0\.2  | 
|  jansi\-native\-javadoc  |  noarch  |  jansi\-native  |  1\.8\-9\.amzn2023\.0\.2  | 
|  jansson  |  aarch64  |  jansson  |  2\.14\-0\.amzn2023  | 
|  jansson  |  x86\_64  |  jansson  |  2\.14\-0\.amzn2023  | 
|  jansson\-devel  |  aarch64  |  jansson  |  2\.14\-0\.amzn2023  | 
|  jansson\-devel  |  x86\_64  |  jansson  |  2\.14\-0\.amzn2023  | 
|  jansson\-devel\-doc  |  noarch  |  jansson  |  2\.14\-0\.amzn2023  | 
|  jasper  |  aarch64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper  |  x86\_64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-devel  |  aarch64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-devel  |  x86\_64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-libs  |  aarch64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-libs  |  x86\_64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-utils  |  aarch64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  jasper\-utils  |  x86\_64  |  jasper  |  2\.0\.33\-1\.amzn2023\.0\.1  | 
|  java\_cup  |  noarch  |  java\_cup  |  0\.11b\-21\.amzn2023\.0\.3  | 
|  java\_cup\-javadoc  |  noarch  |  java\_cup  |  0\.11b\-21\.amzn2023\.0\.3  | 
|  java\_cup\-manual  |  noarch  |  java\_cup  |  0\.11b\-21\.amzn2023\.0\.3  | 
|  java\-1\.8\.0\-amazon\-corretto  |  aarch64  |  java\-1\.8\.0\-amazon\-corretto  |  1\.8\.0\_382\.b05\-1\.amzn2023  | 
|  java\-1\.8\.0\-amazon\-corretto  |  x86\_64  |  java\-1\.8\.0\-amazon\-corretto  |  1\.8\.0\_382\.b05\-1\.amzn2023  | 
|  java\-1\.8\.0\-amazon\-corretto\-devel  |  aarch64  |  java\-1\.8\.0\-amazon\-corretto  |  1\.8\.0\_382\.b05\-1\.amzn2023  | 
|  java\-1\.8\.0\-amazon\-corretto\-devel  |  x86\_64  |  java\-1\.8\.0\-amazon\-corretto  |  1\.8\.0\_382\.b05\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto  |  aarch64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto  |  x86\_64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-devel  |  aarch64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-devel  |  x86\_64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-headless  |  aarch64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-headless  |  x86\_64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-javadoc  |  aarch64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-javadoc  |  x86\_64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-jmods  |  aarch64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-11\-amazon\-corretto\-jmods  |  x86\_64  |  java\-11\-amazon\-corretto  |  11\.0\.20\+8\-1\.amzn2023  | 
|  java\-17\-amazon\-corretto  |  aarch64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto  |  x86\_64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-devel  |  aarch64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-devel  |  x86\_64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-headless  |  aarch64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-headless  |  x86\_64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-javadoc  |  aarch64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-javadoc  |  x86\_64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-jmods  |  aarch64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  java\-17\-amazon\-corretto\-jmods  |  x86\_64  |  java\-17\-amazon\-corretto  |  17\.0\.8\+7\-1\.amzn2023\.1  | 
|  javacc  |  noarch  |  javacc  |  7\.0\.4\-11\.amzn2023\.0\.1  | 
|  javacc\-demo  |  noarch  |  javacc  |  7\.0\.4\-11\.amzn2023\.0\.1  | 
|  javacc\-javadoc  |  noarch  |  javacc  |  7\.0\.4\-11\.amzn2023\.0\.1  | 
|  javacc\-manual  |  noarch  |  javacc  |  7\.0\.4\-11\.amzn2023\.0\.1  | 
|  javacc\-maven\-plugin  |  noarch  |  javacc\-maven\-plugin  |  2\.6\-35\.amzn2023\.0\.1  | 
|  javacc\-maven\-plugin\-javadoc  |  noarch  |  javacc\-maven\-plugin  |  2\.6\-35\.amzn2023\.0\.1  | 
|  javapackages\-bootstrap  |  noarch  |  javapackages\-bootstrap  |  1\.5\.0^20220105\.git9f283b7\-3\.amzn2023\.0\.2  | 
|  javapackages\-filesystem  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  javapackages\-generators  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  javapackages\-local  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  javapackages\-tools  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  maven\-local  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  maven\-local\-amazon\-corretto11  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  maven\-local\-amazon\-corretto17  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  maven\-local\-amazon\-corretto8  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  python3\-javapackages  |  noarch  |  javapackages\-tools  |  6\.0\.0\-7\.amzn2023\.0\.5  | 
|  javaparser  |  noarch  |  javaparser  |  3\.22\.0\-3\.amzn2023\.0\.1  | 
|  javaparser\-javadoc  |  noarch  |  javaparser  |  3\.22\.0\-3\.amzn2023\.0\.1  | 
|  javassist  |  noarch  |  javassist  |  3\.28\.0\-4\.amzn2023\.0\.1  | 
|  javassist\-javadoc  |  noarch  |  javassist  |  3\.28\.0\-4\.amzn2023\.0\.1  | 
|  jaxb\-codemodel  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-codemodel\-annotation\-compiler  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-relaxng\-datatype  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-rngom  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-runtime  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-txw2  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-txwc2  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-xjc  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-xsom  |  noarch  |  jaxb  |  2\.3\.5\-5\.amzn2023\.0\.2  | 
|  jaxb\-api  |  noarch  |  jaxb\-api  |  2\.3\.3\-6\.amzn2023\.0\.1  | 
|  jaxb\-dtd\-parser  |  noarch  |  jaxb\-dtd\-parser  |  1\.5\.0\-1\.amzn2023\.0\.2  | 
|  jaxb\-dtd\-parser\-javadoc  |  noarch  |  jaxb\-dtd\-parser  |  1\.5\.0\-1\.amzn2023\.0\.2  | 
|  FastInfoset  |  noarch  |  jaxb\-fi  |  1\.2\.18\-7\.amzn2023\.0\.1  | 
|  FastInfosetRoundTripTests  |  noarch  |  jaxb\-fi  |  1\.2\.18\-7\.amzn2023\.0\.1  | 
|  FastInfosetSamples  |  noarch  |  jaxb\-fi  |  1\.2\.18\-7\.amzn2023\.0\.1  | 
|  FastInfosetUtilities  |  noarch  |  jaxb\-fi  |  1\.2\.18\-7\.amzn2023\.0\.1  | 
|  import\-properties\-plugin  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-buildtools  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-maven\-plugin  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-runtime  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-soimp  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-test  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  istack\-commons\-tools  |  noarch  |  jaxb\-istack\-commons  |  3\.0\.12\-3\.amzn2023\.0\.1  | 
|  jaxb\-stax\-ex  |  noarch  |  jaxb\-stax\-ex  |  1\.8\.3\-8\.amzn2023\.0\.1  | 
|  jaxb\-stax\-ex\-javadoc  |  noarch  |  jaxb\-stax\-ex  |  1\.8\.3\-8\.amzn2023\.0\.1  | 
|  jaxen  |  noarch  |  jaxen  |  1\.2\.0\-10\.amzn2023\.0\.1  | 
|  jaxen\-demo  |  noarch  |  jaxen  |  1\.2\.0\-10\.amzn2023\.0\.1  | 
|  jaxen\-javadoc  |  noarch  |  jaxen  |  1\.2\.0\-10\.amzn2023\.0\.1  | 
|  jbig2dec  |  aarch64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbig2dec  |  x86\_64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbig2dec\-devel  |  aarch64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbig2dec\-devel  |  x86\_64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbig2dec\-libs  |  aarch64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbig2dec\-libs  |  x86\_64  |  jbig2dec  |  0\.19\-4\.amzn2023\.0\.1  | 
|  jbigkit  |  aarch64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jbigkit  |  x86\_64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jbigkit\-devel  |  aarch64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jbigkit\-devel  |  x86\_64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jbigkit\-libs  |  aarch64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jbigkit\-libs  |  x86\_64  |  jbigkit  |  2\.1\-21\.amzn2023\.0\.1  | 
|  jboss\-parent  |  noarch  |  jboss\-parent  |  20\-14\.amzn2023\.0\.1  | 
|  jboss\-servlet\-3\.0\-api  |  noarch  |  jboss\-servlet\-3\.0\-api  |  1\.0\.2\-16\.amzn2023\.0\.1  | 
|  jboss\-servlet\-3\.0\-api\-javadoc  |  noarch  |  jboss\-servlet\-3\.0\-api  |  1\.0\.2\-16\.amzn2023\.0\.1  | 
|  jcip\-annotations  |  noarch  |  jcip\-annotations  |  1\-35\.20060626\.amzn2023\.0\.2  | 
|  jcip\-annotations\-javadoc  |  noarch  |  jcip\-annotations  |  1\-35\.20060626\.amzn2023\.0\.2  | 
|  jctools  |  noarch  |  jctools  |  3\.3\.0\-5\.amzn2023\.0\.3  | 
|  jctools\-javadoc  |  noarch  |  jctools  |  3\.3\.0\-5\.amzn2023\.0\.3  | 
|  jdepend  |  noarch  |  jdepend  |  2\.9\.1\-29\.amzn2023\.0\.2  | 
|  jdepend\-demo  |  noarch  |  jdepend  |  2\.9\.1\-29\.amzn2023\.0\.2  | 
|  jdepend\-javadoc  |  noarch  |  jdepend  |  2\.9\.1\-29\.amzn2023\.0\.2  | 
|  jdependency  |  noarch  |  jdependency  |  2\.8\.0\-1\.amzn2023\.0\.2  | 
|  jdependency\-javadoc  |  noarch  |  jdependency  |  2\.8\.0\-1\.amzn2023\.0\.2  | 
|  jdom  |  noarch  |  jdom  |  1\.1\.3\-30\.amzn2023\.0\.3  | 
|  jdom\-demo  |  noarch  |  jdom  |  1\.1\.3\-30\.amzn2023\.0\.3  | 
|  jdom\-javadoc  |  noarch  |  jdom  |  1\.1\.3\-30\.amzn2023\.0\.3  | 
|  jdom2  |  noarch  |  jdom2  |  2\.0\.6\-27\.amzn2023\.0\.3  | 
|  jdom2\-javadoc  |  noarch  |  jdom2  |  2\.0\.6\-27\.amzn2023\.0\.3  | 
|  jemalloc  |  aarch64  |  jemalloc  |  5\.2\.1\-7\.amzn2023  | 
|  jemalloc  |  x86\_64  |  jemalloc  |  5\.2\.1\-7\.amzn2023  | 
|  jemalloc\-devel  |  aarch64  |  jemalloc  |  5\.2\.1\-7\.amzn2023  | 
|  jemalloc\-devel  |  x86\_64  |  jemalloc  |  5\.2\.1\-7\.amzn2023  | 
|  jflex  |  noarch  |  jflex  |  1\.7\.0\-10\.amzn2023\.0\.3  | 
|  jflex\-javadoc  |  noarch  |  jflex  |  1\.7\.0\-10\.amzn2023\.0\.3  | 
|  jFormatString  |  noarch  |  jFormatString  |  0\-0\.41\.20131227gitf159b88\.amzn2023\.0\.4  | 
|  jitterentropy  |  aarch64  |  jitterentropy  |  3\.4\.1\-4\.amzn2023  | 
|  jitterentropy  |  x86\_64  |  jitterentropy  |  3\.4\.1\-4\.amzn2023  | 
|  jitterentropy\-devel  |  aarch64  |  jitterentropy  |  3\.4\.1\-4\.amzn2023  | 
|  jitterentropy\-devel  |  x86\_64  |  jitterentropy  |  3\.4\.1\-4\.amzn2023  | 
|  jline2  |  noarch  |  jline2  |  2\.14\.6\-5\.amzn2023\.0\.1  | 
|  jline2\-javadoc  |  noarch  |  jline2  |  2\.14\.6\-5\.amzn2023\.0\.1  | 
|  jna  |  aarch64  |  jna  |  5\.9\.0\-1\.amzn2023\.0\.2  | 
|  jna  |  x86\_64  |  jna  |  5\.9\.0\-1\.amzn2023\.0\.2  | 
|  jna\-contrib  |  noarch  |  jna  |  5\.9\.0\-1\.amzn2023\.0\.2  | 
|  jna\-javadoc  |  noarch  |  jna  |  5\.9\.0\-1\.amzn2023\.0\.2  | 
|  jomolhari\-fonts  |  noarch  |  jomolhari\-fonts  |  0\.003\-32\.amzn2023\.0\.1  | 
|  jq  |  aarch64  |  jq  |  1\.6\-10\.amzn2023\.0\.2  | 
|  jq  |  x86\_64  |  jq  |  1\.6\-10\.amzn2023\.0\.2  | 
|  jq\-devel  |  aarch64  |  jq  |  1\.6\-10\.amzn2023\.0\.2  | 
|  jq\-devel  |  x86\_64  |  jq  |  1\.6\-10\.amzn2023\.0\.2  | 
|  jsch  |  noarch  |  jsch  |  0\.1\.55\-7\.amzn2023\.0\.1  | 
|  jsch\-javadoc  |  noarch  |  jsch  |  0\.1\.55\-7\.amzn2023\.0\.1  | 
|  json\-c  |  aarch64  |  json\-c  |  0\.14\-8\.amzn2023\.0\.2  | 
|  json\-c  |  x86\_64  |  json\-c  |  0\.14\-8\.amzn2023\.0\.2  | 
|  json\-c\-devel  |  aarch64  |  json\-c  |  0\.14\-8\.amzn2023\.0\.2  | 
|  json\-c\-devel  |  x86\_64  |  json\-c  |  0\.14\-8\.amzn2023\.0\.2  | 
|  json\-c\-doc  |  noarch  |  json\-c  |  0\.14\-8\.amzn2023\.0\.2  | 
|  jsoncpp  |  aarch64  |  jsoncpp  |  1\.9\.4\-3\.amzn2023\.0\.2  | 
|  jsoncpp  |  x86\_64  |  jsoncpp  |  1\.9\.4\-3\.amzn2023\.0\.2  | 
|  jsoncpp\-devel  |  aarch64  |  jsoncpp  |  1\.9\.4\-3\.amzn2023\.0\.2  | 
|  jsoncpp\-devel  |  x86\_64  |  jsoncpp  |  1\.9\.4\-3\.amzn2023\.0\.2  | 
|  jsoncpp\-doc  |  noarch  |  jsoncpp  |  1\.9\.4\-3\.amzn2023\.0\.2  | 
|  json\-glib  |  aarch64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  json\-glib  |  x86\_64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  json\-glib\-devel  |  aarch64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  json\-glib\-devel  |  x86\_64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  json\-glib\-tests  |  aarch64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  json\-glib\-tests  |  x86\_64  |  json\-glib  |  1\.6\.6\-1\.amzn2023\.0\.2  | 
|  jsoup  |  noarch  |  jsoup  |  1\.13\.1\-9\.amzn2023\.0\.4  | 
|  jsoup\-javadoc  |  noarch  |  jsoup  |  1\.13\.1\-9\.amzn2023\.0\.4  | 
|  jsr\-305  |  noarch  |  jsr\-305  |  3\.0\.2\-5\.amzn2023\.0\.4  | 
|  jsr\-305\-javadoc  |  noarch  |  jsr\-305  |  3\.0\.2\-5\.amzn2023\.0\.4  | 
|  jtidy  |  noarch  |  jtidy  |  1\.0\-0\.38\.20100930svn1125\.amzn2023\.0\.1  | 
|  jtidy\-javadoc  |  noarch  |  jtidy  |  1\.0\-0\.38\.20100930svn1125\.amzn2023\.0\.1  | 
|  Judy  |  aarch64  |  Judy  |  1\.0\.5\-25\.amzn2023\.0\.3  | 
|  Judy  |  x86\_64  |  Judy  |  1\.0\.5\-25\.amzn2023\.0\.3  | 
|  Judy\-devel  |  aarch64  |  Judy  |  1\.0\.5\-25\.amzn2023\.0\.3  | 
|  Judy\-devel  |  x86\_64  |  Judy  |  1\.0\.5\-25\.amzn2023\.0\.3  | 
|  junit  |  noarch  |  junit  |  4\.13\.1\-7\.amzn2023\.0\.3  | 
|  junit\-javadoc  |  noarch  |  junit  |  4\.13\.1\-7\.amzn2023\.0\.3  | 
|  junit\-manual  |  noarch  |  junit  |  4\.13\.1\-7\.amzn2023\.0\.3  | 
|  junit5  |  noarch  |  junit5  |  5\.7\.1\-5\.amzn2023\.0\.3  | 
|  junit5\-guide  |  noarch  |  junit5  |  5\.7\.1\-5\.amzn2023\.0\.3  | 
|  junit5\-javadoc  |  noarch  |  junit5  |  5\.7\.1\-5\.amzn2023\.0\.3  | 
|  jzlib  |  noarch  |  jzlib  |  1\.1\.3\-21\.amzn2023\.0\.1  | 
|  jzlib\-demo  |  noarch  |  jzlib  |  1\.1\.3\-21\.amzn2023\.0\.1  | 
|  jzlib\-javadoc  |  noarch  |  jzlib  |  1\.1\.3\-21\.amzn2023\.0\.1  | 
|  kasumi  |  aarch64  |  kasumi  |  2\.5\-37\.amzn2023\.0\.4  | 
|  kasumi  |  x86\_64  |  kasumi  |  2\.5\-37\.amzn2023\.0\.4  | 
|  kasumi\-common  |  noarch  |  kasumi  |  2\.5\-37\.amzn2023\.0\.4  | 
|  kasumi\-unicode  |  aarch64  |  kasumi  |  2\.5\-37\.amzn2023\.0\.4  | 
|  kasumi\-unicode  |  x86\_64  |  kasumi  |  2\.5\-37\.amzn2023\.0\.4  | 
|  kbd  |  aarch64  |  kbd  |  2\.4\.0\-2\.amzn2023\.0\.3  | 
|  kbd  |  x86\_64  |  kbd  |  2\.4\.0\-2\.amzn2023\.0\.3  | 
|  kbd\-legacy  |  noarch  |  kbd  |  2\.4\.0\-2\.amzn2023\.0\.3  | 
|  kbd\-misc  |  noarch  |  kbd  |  2\.4\.0\-2\.amzn2023\.0\.3  | 
|  kde\-filesystem  |  aarch64  |  kde\-filesystem  |  4\-65\.amzn2023\.0\.3  | 
|  kde\-filesystem  |  x86\_64  |  kde\-filesystem  |  4\-65\.amzn2023\.0\.3  | 
|  keepalived  |  aarch64  |  keepalived  |  2\.2\.7\-6\.amzn2023\.0\.1  | 
|  keepalived  |  x86\_64  |  keepalived  |  2\.2\.7\-6\.amzn2023\.0\.1  | 
|  bpftool  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  bpftool  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-devel  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-devel  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-headers  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-headers  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf\-devel  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf\-devel  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf\-static  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-libbpf\-static  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-tools  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-tools  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-tools\-devel  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-tools\-devel  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  perf  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  perf  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  python3\-perf  |  aarch64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  python3\-perf  |  x86\_64  |  kernel  |  6\.1\.38\-59\.109\.amzn2023  | 
|  kernel\-rpm\-macros  |  noarch  |  kernel\-srpm\-macros  |  205\-14\.amzn2023\.0\.2  | 
|  kernel\-srpm\-macros  |  noarch  |  kernel\-srpm\-macros  |  1\.0\-14\.amzn2023\.0\.2  | 
|  kexec\-tools  |  aarch64  |  kexec\-tools  |  2\.0\.23\-4\.amzn2023\.0\.4  | 
|  kexec\-tools  |  x86\_64  |  kexec\-tools  |  2\.0\.23\-4\.amzn2023\.0\.4  | 
|  keyutils  |  aarch64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  keyutils  |  x86\_64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  keyutils\-libs  |  aarch64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  keyutils\-libs  |  x86\_64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  keyutils\-libs\-devel  |  aarch64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  keyutils\-libs\-devel  |  x86\_64  |  keyutils  |  1\.6\.3\-1\.amzn2023  | 
|  khmer\-os\-battambang\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-bokor\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-content\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-fasthand\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-fonts\-all  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-freehand\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-handwritten\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-metal\-chrieng\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-muol\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-muol\-fonts\-all  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-muol\-pali\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-siemreap\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  khmer\-os\-system\-fonts  |  noarch  |  khmer\-os\-fonts  |  5\.0\-32\.amzn2023\.0\.3  | 
|  kmod  |  aarch64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kmod  |  x86\_64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kmod\-devel  |  aarch64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kmod\-devel  |  x86\_64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kmod\-libs  |  aarch64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kmod\-libs  |  x86\_64  |  kmod  |  29\-2\.amzn2023\.0\.5  | 
|  kpatch\-build  |  aarch64  |  kpatch  |  0\.9\.7\-12\.amzn2023\.0\.3  | 
|  kpatch\-build  |  x86\_64  |  kpatch  |  0\.9\.7\-12\.amzn2023\.0\.3  | 
|  kpatch\-dnf  |  aarch64  |  kpatch  |  0\.4\-12\.amzn2023\.0\.3  | 
|  kpatch\-dnf  |  x86\_64  |  kpatch  |  0\.4\-12\.amzn2023\.0\.3  | 
|  kpatch\-runtime  |  noarch  |  kpatch  |  0\.9\.7\-12\.amzn2023\.0\.3  | 
|  krb5\-devel  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-devel  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-libs  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-libs  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-pkinit  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-pkinit  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-server  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-server  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-server\-ldap  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-server\-ldap  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-workstation  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  krb5\-workstation  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  libkadm5  |  aarch64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  libkadm5  |  x86\_64  |  krb5  |  1\.20\.1\-8\.amzn2023\.0\.2  | 
|  ksh  |  aarch64  |  ksh  |  20120801\-255\.amzn2023\.0\.2  | 
|  ksh  |  x86\_64  |  ksh  |  20120801\-255\.amzn2023\.0\.2  | 
|  kyua  |  aarch64  |  kyua  |  0\.13\-7\.amzn2023\.0\.3  | 
|  kyua  |  x86\_64  |  kyua  |  0\.13\-7\.amzn2023\.0\.3  | 
|  kyua\-tests  |  aarch64  |  kyua  |  0\.13\-7\.amzn2023\.0\.3  | 
|  kyua\-tests  |  x86\_64  |  kyua  |  0\.13\-7\.amzn2023\.0\.3  | 
|  langpacks\-af  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-am  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ar  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-as  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ast  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-be  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-bg  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-bn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-bo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-br  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-bs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ca  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-chr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-af  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-am  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ar  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-as  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ast  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-be  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-bg  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-bn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-bo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-br  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-bs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ca  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-chr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-cs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-cy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-da  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-de  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-dv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-dz  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-el  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-en  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-en\_GB  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-eo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-es  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-et  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-eu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-fa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-fi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-af  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-am  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ar  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-as  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ast  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-be  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-bg  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-bn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-bo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-br  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-bs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ca  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-chr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-cs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-cy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-da  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-de  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-dv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-dz  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-el  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-en  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-eo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-es  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-et  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-eu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-fa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-fi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-fr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ga  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-gl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-gu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-he  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-hi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-hr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-hu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-hy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ia  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-id  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-is  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-it  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-iu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ja  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ka  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-kk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-km  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-kn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ko  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ku  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-lo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-lt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-lv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-mai  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-mk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ml  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-mr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ms  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-my  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-nb  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ne  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-nl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-nn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-nr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-nso  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-or  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-pa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-pl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-pt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ro  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ru  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-si  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-sk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-sl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-sq  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-sr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ss  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-sv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ta  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-te  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-th  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-tn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-tr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ts  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-uk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ur  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-ve  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-vi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-xh  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-yi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-zh\_CN  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-zh\_HK  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-zh\_TW  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-font\-zu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-fr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ga  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-gl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-gu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-he  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-hi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-hr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-hu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-hy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ia  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-id  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-is  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-it  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-iu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ja  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ka  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-kk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-km  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-kn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ko  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ku  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-lo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-lt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-lv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-mai  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-mk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ml  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-mr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ms  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-my  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-nb  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ne  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-nl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-nn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-nr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-nso  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-or  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-pa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-pl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-pt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-pt\_BR  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ro  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ru  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-si  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-sk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-sl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-sq  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-sr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ss  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-sv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ta  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-te  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-th  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-tn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-tr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ts  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-uk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ur  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-ve  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-vi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-xh  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-yi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-zh\_CN  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-zh\_HK  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-zh\_TW  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-core\-zu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-cs  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-cy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-da  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-de  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-dv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-dz  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-el  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-en  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-en\_GB  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-eo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-es  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-et  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-eu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-fa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-fi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-fr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ga  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-gl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-gu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-he  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-hi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-hr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-hu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-hy  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ia  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-id  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-is  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-it  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-iu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ja  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ka  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-kk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-km  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-kn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ko  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ku  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-lo  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-lt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-lv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-mai  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-mk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ml  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-mr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ms  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-my  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-nb  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ne  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-nl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-nn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-nr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-nso  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-or  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-pa  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-pl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-pt  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-pt\_BR  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ro  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ru  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-si  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-sk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-sl  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-sq  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-sr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ss  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-sv  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ta  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-te  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-th  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-tn  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-tr  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ts  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-uk  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ur  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-ve  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-vi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-xh  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-yi  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-zh\_CN  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-zh\_HK  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-zh\_TW  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  langpacks\-zu  |  noarch  |  langpacks  |  3\.0\-21\.amzn2023\.0\.4  | 
|  blas  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas64  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas64  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas64\_  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas64\_  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas\-devel  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas\-devel  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas\-static  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  blas\-static  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack64  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack64  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack64\_  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack64\_  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack\-devel  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack\-devel  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack\-static  |  aarch64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  lapack\-static  |  x86\_64  |  lapack  |  3\.10\.0\-4\.amzn2023\.0\.3  | 
|  latex2html  |  noarch  |  latex2html  |  2020\.2\-3\.amzn2023\.0\.3  | 
|  latexmk  |  noarch  |  latexmk  |  4\.75\-1\.amzn2023\.0\.3  | 
|  lato\-fonts  |  noarch  |  lato\-fonts  |  2\.015\-11\.amzn2023\.0\.3  | 
|  lcms2  |  aarch64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  lcms2  |  x86\_64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  lcms2\-devel  |  aarch64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  lcms2\-devel  |  x86\_64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  lcms2\-utils  |  aarch64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  lcms2\-utils  |  x86\_64  |  lcms2  |  2\.12\-1\.amzn2023\.0\.3  | 
|  less  |  aarch64  |  less  |  608\-2\.amzn2023\.0\.1  | 
|  less  |  x86\_64  |  less  |  608\-2\.amzn2023\.0\.1  | 
|  lftp  |  aarch64  |  lftp  |  4\.9\.2\-2\.amzn2023  | 
|  lftp  |  x86\_64  |  lftp  |  4\.9\.2\-2\.amzn2023  | 
|  lftp\-scripts  |  noarch  |  lftp  |  4\.9\.2\-2\.amzn2023  | 
|  libabigail  |  aarch64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libabigail  |  x86\_64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libabigail\-devel  |  aarch64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libabigail\-devel  |  x86\_64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libabigail\-doc  |  aarch64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libabigail\-doc  |  x86\_64  |  libabigail  |  2\.3\-1\.amzn2023\.0\.1  | 
|  libaio  |  aarch64  |  libaio  |  0\.3\.111\-11\.amzn2023\.0\.2  | 
|  libaio  |  x86\_64  |  libaio  |  0\.3\.111\-11\.amzn2023\.0\.2  | 
|  libaio\-devel  |  aarch64  |  libaio  |  0\.3\.111\-11\.amzn2023\.0\.2  | 
|  libaio\-devel  |  x86\_64  |  libaio  |  0\.3\.111\-11\.amzn2023\.0\.2  | 
|  libao  |  aarch64  |  libao  |  1\.2\.0\-20\.amzn2023\.0\.2  | 
|  libao  |  x86\_64  |  libao  |  1\.2\.0\-20\.amzn2023\.0\.2  | 
|  libao\-devel  |  aarch64  |  libao  |  1\.2\.0\-20\.amzn2023\.0\.2  | 
|  libao\-devel  |  x86\_64  |  libao  |  1\.2\.0\-20\.amzn2023\.0\.2  | 
|  libappstream\-glib  |  aarch64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  libappstream\-glib  |  x86\_64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  libappstream\-glib\-builder  |  aarch64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  libappstream\-glib\-builder  |  x86\_64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  libappstream\-glib\-devel  |  aarch64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  libappstream\-glib\-devel  |  x86\_64  |  libappstream\-glib  |  0\.7\.18\-2\.amzn2023\.0\.2  | 
|  bsdcat  |  aarch64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  bsdcat  |  x86\_64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  bsdcpio  |  aarch64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  bsdcpio  |  x86\_64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  bsdtar  |  aarch64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  bsdtar  |  x86\_64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  libarchive  |  aarch64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  libarchive  |  x86\_64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  libarchive\-devel  |  aarch64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  libarchive\-devel  |  x86\_64  |  libarchive  |  3\.5\.3\-2\.amzn2023\.0\.3  | 
|  libasr  |  aarch64  |  libasr  |  1\.0\.4\-5\.amzn2023\.0\.2  | 
|  libasr  |  x86\_64  |  libasr  |  1\.0\.4\-5\.amzn2023\.0\.2  | 
|  libasr\-devel  |  aarch64  |  libasr  |  1\.0\.4\-5\.amzn2023\.0\.2  | 
|  libasr\-devel  |  x86\_64  |  libasr  |  1\.0\.4\-5\.amzn2023\.0\.2  | 
|  libassuan  |  aarch64  |  libassuan  |  2\.5\.5\-1\.amzn2023\.0\.2  | 
|  libassuan  |  x86\_64  |  libassuan  |  2\.5\.5\-1\.amzn2023\.0\.2  | 
|  libassuan\-devel  |  aarch64  |  libassuan  |  2\.5\.5\-1\.amzn2023\.0\.2  | 
|  libassuan\-devel  |  x86\_64  |  libassuan  |  2\.5\.5\-1\.amzn2023\.0\.2  | 
|  libasyncns  |  aarch64  |  libasyncns  |  0\.8\-20\.amzn2023\.0\.2  | 
|  libasyncns  |  x86\_64  |  libasyncns  |  0\.8\-20\.amzn2023\.0\.2  | 
|  libasyncns\-devel  |  aarch64  |  libasyncns  |  0\.8\-20\.amzn2023\.0\.2  | 
|  libasyncns\-devel  |  x86\_64  |  libasyncns  |  0\.8\-20\.amzn2023\.0\.2  | 
|  libatasmart  |  aarch64  |  libatasmart  |  0\.19\-20\.amzn2023\.0\.2  | 
|  libatasmart  |  x86\_64  |  libatasmart  |  0\.19\-20\.amzn2023\.0\.2  | 
|  libatasmart\-devel  |  aarch64  |  libatasmart  |  0\.19\-20\.amzn2023\.0\.2  | 
|  libatasmart\-devel  |  x86\_64  |  libatasmart  |  0\.19\-20\.amzn2023\.0\.2  | 
|  libatomic\_ops  |  aarch64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libatomic\_ops  |  x86\_64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libatomic\_ops\-devel  |  aarch64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libatomic\_ops\-devel  |  x86\_64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libatomic\_ops\-static  |  aarch64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libatomic\_ops\-static  |  x86\_64  |  libatomic\_ops  |  7\.6\.10\-7\.amzn2023\.0\.2  | 
|  libblockdev  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-crypto  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-crypto  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-crypto\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-crypto\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-dm  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-dm  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-dm\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-dm\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-fs  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-fs  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-fs\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-fs\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-kbd  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-kbd  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-kbd\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-kbd\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-loop  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-loop  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-loop\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-loop\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-dbus  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-dbus  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-dbus\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-dbus\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-lvm\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mdraid  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mdraid  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mdraid\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mdraid\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mpath  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mpath  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mpath\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-mpath\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-nvdimm  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-nvdimm  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-nvdimm\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-nvdimm\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-part  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-part  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-part\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-part\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-plugins\-all  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-plugins\-all  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-swap  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-swap  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-swap\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-swap\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-tools  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-tools  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-utils  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-utils  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-utils\-devel  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libblockdev\-utils\-devel  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  python3\-blockdev  |  aarch64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  python3\-blockdev  |  x86\_64  |  libblockdev  |  2\.28\-2\.amzn2023\.0\.1  | 
|  libbsd  |  aarch64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  libbsd  |  x86\_64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  libbsd\-ctor\-static  |  aarch64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  libbsd\-ctor\-static  |  x86\_64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  libbsd\-devel  |  aarch64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  libbsd\-devel  |  x86\_64  |  libbsd  |  0\.10\.0\-7\.amzn2023\.0\.2  | 
|  cdrskin  |  aarch64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  cdrskin  |  x86\_64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libburn  |  aarch64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libburn  |  x86\_64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libburn\-devel  |  aarch64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libburn\-devel  |  x86\_64  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libburn\-doc  |  noarch  |  libburn  |  1\.5\.4\-2\.amzn2023\.0\.2  | 
|  libbytesize  |  aarch64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libbytesize  |  x86\_64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libbytesize\-devel  |  aarch64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libbytesize\-devel  |  x86\_64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libbytesize\-tools  |  aarch64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libbytesize\-tools  |  x86\_64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  python3\-bytesize  |  aarch64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  python3\-bytesize  |  x86\_64  |  libbytesize  |  2\.6\-1\.amzn2023\.0\.2  | 
|  libcap  |  aarch64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap  |  x86\_64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap\-devel  |  aarch64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap\-devel  |  x86\_64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap\-static  |  aarch64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap\-static  |  x86\_64  |  libcap  |  2\.48\-2\.amzn2023\.0\.3  | 
|  libcap\-ng  |  aarch64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng  |  x86\_64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-devel  |  aarch64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-devel  |  x86\_64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-python3  |  aarch64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-python3  |  x86\_64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-utils  |  aarch64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcap\-ng\-utils  |  x86\_64  |  libcap\-ng  |  0\.8\.2\-4\.amzn2023\.0\.2  | 
|  libcbor  |  aarch64  |  libcbor  |  0\.7\.0\-3\.amzn2023\.0\.2  | 
|  libcbor  |  x86\_64  |  libcbor  |  0\.7\.0\-3\.amzn2023\.0\.2  | 
|  libcbor\-devel  |  aarch64  |  libcbor  |  0\.7\.0\-3\.amzn2023\.0\.2  | 
|  libcbor\-devel  |  x86\_64  |  libcbor  |  0\.7\.0\-3\.amzn2023\.0\.2  | 
|  libcerf  |  aarch64  |  libcerf  |  2\.1\-1\.amzn2023\.0\.2  | 
|  libcerf  |  x86\_64  |  libcerf  |  2\.1\-1\.amzn2023\.0\.2  | 
|  libcerf\-devel  |  aarch64  |  libcerf  |  2\.1\-1\.amzn2023\.0\.2  | 
|  libcerf\-devel  |  x86\_64  |  libcerf  |  2\.1\-1\.amzn2023\.0\.2  | 
|  libcgroup  |  aarch64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup  |  x86\_64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-devel  |  aarch64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-devel  |  x86\_64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-pam  |  aarch64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-pam  |  x86\_64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-tools  |  aarch64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libcgroup\-tools  |  x86\_64  |  libcgroup  |  3\.0\-1\.amzn2023\.0\.1  | 
|  libclc  |  aarch64  |  libclc  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libclc  |  x86\_64  |  libclc  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libclc\-devel  |  aarch64  |  libclc  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libclc\-devel  |  x86\_64  |  libclc  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libcloudproviders  |  aarch64  |  libcloudproviders  |  0\.3\.1\-3\.amzn2023\.0\.2  | 
|  libcloudproviders  |  x86\_64  |  libcloudproviders  |  0\.3\.1\-3\.amzn2023\.0\.2  | 
|  libcloudproviders\-devel  |  aarch64  |  libcloudproviders  |  0\.3\.1\-3\.amzn2023\.0\.2  | 
|  libcloudproviders\-devel  |  x86\_64  |  libcloudproviders  |  0\.3\.1\-3\.amzn2023\.0\.2  | 
|  libcomps  |  aarch64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  libcomps  |  x86\_64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  libcomps\-devel  |  aarch64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  libcomps\-devel  |  x86\_64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  libcomps\-doc  |  noarch  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  python3\-libcomps  |  aarch64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  python3\-libcomps  |  x86\_64  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  python\-libcomps\-doc  |  noarch  |  libcomps  |  0\.1\.18\-1\.amzn2023\.0\.2  | 
|  libconfig  |  aarch64  |  libconfig  |  1\.7\.2\-7\.amzn2023\.0\.2  | 
|  libconfig  |  x86\_64  |  libconfig  |  1\.7\.2\-7\.amzn2023\.0\.2  | 
|  libconfig\-devel  |  aarch64  |  libconfig  |  1\.7\.2\-7\.amzn2023\.0\.2  | 
|  libconfig\-devel  |  x86\_64  |  libconfig  |  1\.7\.2\-7\.amzn2023\.0\.2  | 
|  libdaemon  |  aarch64  |  libdaemon  |  0\.14\-21\.amzn2023\.0\.2  | 
|  libdaemon  |  x86\_64  |  libdaemon  |  0\.14\-21\.amzn2023\.0\.2  | 
|  libdaemon\-devel  |  aarch64  |  libdaemon  |  0\.14\-21\.amzn2023\.0\.2  | 
|  libdaemon\-devel  |  x86\_64  |  libdaemon  |  0\.14\-21\.amzn2023\.0\.2  | 
|  libdatrie  |  aarch64  |  libdatrie  |  0\.2\.13\-1\.amzn2023\.0\.2  | 
|  libdatrie  |  x86\_64  |  libdatrie  |  0\.2\.13\-1\.amzn2023\.0\.2  | 
|  libdatrie\-devel  |  aarch64  |  libdatrie  |  0\.2\.13\-1\.amzn2023\.0\.2  | 
|  libdatrie\-devel  |  x86\_64  |  libdatrie  |  0\.2\.13\-1\.amzn2023\.0\.2  | 
|  libdazzle  |  aarch64  |  libdazzle  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  libdazzle  |  x86\_64  |  libdazzle  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  libdazzle\-devel  |  aarch64  |  libdazzle  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  libdazzle\-devel  |  x86\_64  |  libdazzle  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  libdb  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-cxx  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-cxx  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-cxx\-devel  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-cxx\-devel  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-devel  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-devel  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-devel\-doc  |  noarch  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-devel\-static  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-devel\-static  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-sql  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-sql  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-sql\-devel  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-sql\-devel  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-tcl  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-tcl  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-tcl\-devel  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-tcl\-devel  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-utils  |  aarch64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdb\-utils  |  x86\_64  |  libdb  |  5\.3\.28\-49\.amzn2023\.0\.2  | 
|  libdbi  |  aarch64  |  libdbi  |  0\.9\.0\-20\.amzn2023\.0\.1  | 
|  libdbi  |  x86\_64  |  libdbi  |  0\.9\.0\-20\.amzn2023\.0\.1  | 
|  libdbi\-devel  |  aarch64  |  libdbi  |  0\.9\.0\-20\.amzn2023\.0\.1  | 
|  libdbi\-devel  |  x86\_64  |  libdbi  |  0\.9\.0\-20\.amzn2023\.0\.1  | 
|  libdbi\-doc  |  noarch  |  libdbi  |  0\.9\.0\-20\.amzn2023\.0\.1  | 
|  libdmx  |  aarch64  |  libdmx  |  1\.1\.4\-10\.amzn2023\.0\.2  | 
|  libdmx  |  x86\_64  |  libdmx  |  1\.1\.4\-10\.amzn2023\.0\.2  | 
|  libdmx\-devel  |  aarch64  |  libdmx  |  1\.1\.4\-10\.amzn2023\.0\.2  | 
|  libdmx\-devel  |  x86\_64  |  libdmx  |  1\.1\.4\-10\.amzn2023\.0\.2  | 
|  libdnf  |  aarch64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  libdnf  |  x86\_64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  libdnf\-devel  |  aarch64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  libdnf\-devel  |  x86\_64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  python3\-hawkey  |  aarch64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  python3\-hawkey  |  x86\_64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  python3\-libdnf  |  aarch64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  python3\-libdnf  |  x86\_64  |  libdnf  |  0\.67\.0\-1\.amzn2023\.0\.5  | 
|  drm\-utils  |  aarch64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  drm\-utils  |  x86\_64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  libdrm  |  aarch64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  libdrm  |  x86\_64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  libdrm\-devel  |  aarch64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  libdrm\-devel  |  x86\_64  |  libdrm  |  2\.4\.110\-1\.amzn2023\.0\.2  | 
|  libdwarf  |  aarch64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf  |  x86\_64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-devel  |  aarch64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-devel  |  x86\_64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-static  |  aarch64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-static  |  x86\_64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-tools  |  aarch64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libdwarf\-tools  |  x86\_64  |  libdwarf  |  0\.5\.0\-1\.amzn2023\.0\.2  | 
|  libecap  |  aarch64  |  libecap  |  1\.0\.1\-10\.amzn2023  | 
|  libecap  |  x86\_64  |  libecap  |  1\.0\.1\-10\.amzn2023  | 
|  libecap\-devel  |  aarch64  |  libecap  |  1\.0\.1\-10\.amzn2023  | 
|  libecap\-devel  |  x86\_64  |  libecap  |  1\.0\.1\-10\.amzn2023  | 
|  libeconf  |  aarch64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libeconf  |  x86\_64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libeconf\-devel  |  aarch64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libeconf\-devel  |  x86\_64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libeconf\-utils  |  aarch64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libeconf\-utils  |  x86\_64  |  libeconf  |  0\.4\.0\-1\.amzn2023\.0\.3  | 
|  libedit  |  aarch64  |  libedit  |  3\.1\-38\.20210714cvs\.amzn2023\.0\.2  | 
|  libedit  |  x86\_64  |  libedit  |  3\.1\-38\.20210714cvs\.amzn2023\.0\.2  | 
|  libedit\-devel  |  aarch64  |  libedit  |  3\.1\-38\.20210714cvs\.amzn2023\.0\.2  | 
|  libedit\-devel  |  x86\_64  |  libedit  |  3\.1\-38\.20210714cvs\.amzn2023\.0\.2  | 
|  libell  |  aarch64  |  libell  |  0\.43\-1\.amzn2023\.0\.2  | 
|  libell  |  x86\_64  |  libell  |  0\.43\-1\.amzn2023\.0\.2  | 
|  libell\-devel  |  aarch64  |  libell  |  0\.43\-1\.amzn2023\.0\.2  | 
|  libell\-devel  |  x86\_64  |  libell  |  0\.43\-1\.amzn2023\.0\.2  | 
|  libepoxy  |  aarch64  |  libepoxy  |  1\.5\.9\-1\.amzn2023\.0\.2  | 
|  libepoxy  |  x86\_64  |  libepoxy  |  1\.5\.9\-1\.amzn2023\.0\.2  | 
|  libepoxy\-devel  |  aarch64  |  libepoxy  |  1\.5\.9\-1\.amzn2023\.0\.2  | 
|  libepoxy\-devel  |  x86\_64  |  libepoxy  |  1\.5\.9\-1\.amzn2023\.0\.2  | 
|  liberation\-fonts  |  noarch  |  liberation\-fonts  |  2\.1\.5\-1\.amzn2023\.0\.2  | 
|  liberation\-fonts\-common  |  noarch  |  liberation\-fonts  |  2\.1\.5\-1\.amzn2023\.0\.2  | 
|  liberation\-mono\-fonts  |  noarch  |  liberation\-fonts  |  2\.1\.5\-1\.amzn2023\.0\.2  | 
|  liberation\-sans\-fonts  |  noarch  |  liberation\-fonts  |  2\.1\.5\-1\.amzn2023\.0\.2  | 
|  liberation\-serif\-fonts  |  noarch  |  liberation\-fonts  |  2\.1\.5\-1\.amzn2023\.0\.2  | 
|  libesmtp  |  aarch64  |  libesmtp  |  1\.0\.6\-25\.amzn2023\.0\.2  | 
|  libesmtp  |  x86\_64  |  libesmtp  |  1\.0\.6\-25\.amzn2023\.0\.2  | 
|  libesmtp\-devel  |  aarch64  |  libesmtp  |  1\.0\.6\-25\.amzn2023\.0\.2  | 
|  libesmtp\-devel  |  x86\_64  |  libesmtp  |  1\.0\.6\-25\.amzn2023\.0\.2  | 
|  libestr  |  aarch64  |  libestr  |  0\.1\.11\-1\.amzn2023\.0\.2  | 
|  libestr  |  x86\_64  |  libestr  |  0\.1\.11\-1\.amzn2023\.0\.2  | 
|  libestr\-devel  |  aarch64  |  libestr  |  0\.1\.11\-1\.amzn2023\.0\.2  | 
|  libestr\-devel  |  x86\_64  |  libestr  |  0\.1\.11\-1\.amzn2023\.0\.2  | 
|  libev  |  aarch64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev  |  x86\_64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev\-devel  |  aarch64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev\-devel  |  x86\_64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev\-libevent\-devel  |  aarch64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev\-libevent\-devel  |  x86\_64  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libev\-source  |  noarch  |  libev  |  4\.33\-3\.amzn2023\.0\.2  | 
|  libevdev  |  aarch64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevdev  |  x86\_64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevdev\-devel  |  aarch64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevdev\-devel  |  x86\_64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevdev\-utils  |  aarch64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevdev\-utils  |  x86\_64  |  libevdev  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libevent  |  aarch64  |  libevent  |  2\.1\.12\-3\.amzn2023\.0\.3  | 
|  libevent  |  x86\_64  |  libevent  |  2\.1\.12\-3\.amzn2023\.0\.3  | 
|  libevent\-devel  |  aarch64  |  libevent  |  2\.1\.12\-3\.amzn2023\.0\.3  | 
|  libevent\-devel  |  x86\_64  |  libevent  |  2\.1\.12\-3\.amzn2023\.0\.3  | 
|  libevent\-doc  |  noarch  |  libevent  |  2\.1\.12\-3\.amzn2023\.0\.3  | 
|  libexif  |  aarch64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libexif  |  x86\_64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libexif\-devel  |  aarch64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libexif\-devel  |  x86\_64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libexif\-doc  |  aarch64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libexif\-doc  |  x86\_64  |  libexif  |  0\.6\.22\-4\.amzn2023\.0\.2  | 
|  libfabric  |  aarch64  |  libfabric  |  1\.14\.0\-2\.amzn2023\.0\.2  | 
|  libfabric  |  x86\_64  |  libfabric  |  1\.14\.0\-2\.amzn2023\.0\.2  | 
|  libfabric\-devel  |  aarch64  |  libfabric  |  1\.14\.0\-2\.amzn2023\.0\.2  | 
|  libfabric\-devel  |  x86\_64  |  libfabric  |  1\.14\.0\-2\.amzn2023\.0\.2  | 
|  libfastjson  |  aarch64  |  libfastjson  |  0\.99\.9\-1\.amzn2023\.0\.3  | 
|  libfastjson  |  x86\_64  |  libfastjson  |  0\.99\.9\-1\.amzn2023\.0\.3  | 
|  libfastjson\-devel  |  aarch64  |  libfastjson  |  0\.99\.9\-1\.amzn2023\.0\.3  | 
|  libfastjson\-devel  |  x86\_64  |  libfastjson  |  0\.99\.9\-1\.amzn2023\.0\.3  | 
|  libffi  |  aarch64  |  libffi  |  3\.1\-28\.amzn2023\.0\.2  | 
|  libffi  |  x86\_64  |  libffi  |  3\.1\-28\.amzn2023\.0\.2  | 
|  libffi\-devel  |  aarch64  |  libffi  |  3\.1\-28\.amzn2023\.0\.2  | 
|  libffi\-devel  |  x86\_64  |  libffi  |  3\.1\-28\.amzn2023\.0\.2  | 
|  fido2\-tools  |  aarch64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  fido2\-tools  |  x86\_64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  libfido2  |  aarch64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  libfido2  |  x86\_64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  libfido2\-devel  |  aarch64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  libfido2\-devel  |  x86\_64  |  libfido2  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  libfontenc  |  aarch64  |  libfontenc  |  1\.1\.3\-15\.amzn2023\.0\.2  | 
|  libfontenc  |  x86\_64  |  libfontenc  |  1\.1\.3\-15\.amzn2023\.0\.2  | 
|  libfontenc\-devel  |  aarch64  |  libfontenc  |  1\.1\.3\-15\.amzn2023\.0\.2  | 
|  libfontenc\-devel  |  x86\_64  |  libfontenc  |  1\.1\.3\-15\.amzn2023\.0\.2  | 
|  libgcrypt  |  aarch64  |  libgcrypt  |  1\.10\.1\-7\.amzn2023\.0\.1  | 
|  libgcrypt  |  x86\_64  |  libgcrypt  |  1\.10\.1\-7\.amzn2023\.0\.1  | 
|  libgcrypt\-devel  |  aarch64  |  libgcrypt  |  1\.10\.1\-7\.amzn2023\.0\.1  | 
|  libgcrypt\-devel  |  x86\_64  |  libgcrypt  |  1\.10\.1\-7\.amzn2023\.0\.1  | 
|  libgit2  |  aarch64  |  libgit2  |  1\.6\.4\-114\.amzn2023\.0\.1  | 
|  libgit2  |  x86\_64  |  libgit2  |  1\.6\.4\-114\.amzn2023\.0\.1  | 
|  libgit2\-devel  |  aarch64  |  libgit2  |  1\.6\.4\-114\.amzn2023\.0\.1  | 
|  libgit2\-devel  |  x86\_64  |  libgit2  |  1\.6\.4\-114\.amzn2023\.0\.1  | 
|  libglvnd  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-core\-devel  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-core\-devel  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-devel  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-devel  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-egl  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-egl  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-gles  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-gles  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-glx  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-glx  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-opengl  |  aarch64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libglvnd\-opengl  |  x86\_64  |  libglvnd  |  1\.3\.4\-1\.amzn2023\.0\.2  | 
|  libgpg\-error  |  aarch64  |  libgpg\-error  |  1\.42\-1\.amzn2023\.0\.2  | 
|  libgpg\-error  |  x86\_64  |  libgpg\-error  |  1\.42\-1\.amzn2023\.0\.2  | 
|  libgpg\-error\-devel  |  aarch64  |  libgpg\-error  |  1\.42\-1\.amzn2023\.0\.2  | 
|  libgpg\-error\-devel  |  x86\_64  |  libgpg\-error  |  1\.42\-1\.amzn2023\.0\.2  | 
|  libgudev  |  aarch64  |  libgudev  |  237\-1\.amzn2023\.0\.2  | 
|  libgudev  |  x86\_64  |  libgudev  |  237\-1\.amzn2023\.0\.2  | 
|  libgudev\-devel  |  aarch64  |  libgudev  |  237\-1\.amzn2023\.0\.2  | 
|  libgudev\-devel  |  x86\_64  |  libgudev  |  237\-1\.amzn2023\.0\.2  | 
|  libgusb  |  aarch64  |  libgusb  |  0\.3\.8\-1\.amzn2023\.0\.2  | 
|  libgusb  |  x86\_64  |  libgusb  |  0\.3\.8\-1\.amzn2023\.0\.2  | 
|  libgusb\-devel  |  aarch64  |  libgusb  |  0\.3\.8\-1\.amzn2023\.0\.2  | 
|  libgusb\-devel  |  x86\_64  |  libgusb  |  0\.3\.8\-1\.amzn2023\.0\.2  | 
|  libhangul  |  aarch64  |  libhangul  |  0\.1\.0\-23\.amzn2023\.0\.3  | 
|  libhangul  |  x86\_64  |  libhangul  |  0\.1\.0\-23\.amzn2023\.0\.3  | 
|  libhangul\-devel  |  aarch64  |  libhangul  |  0\.1\.0\-23\.amzn2023\.0\.3  | 
|  libhangul\-devel  |  x86\_64  |  libhangul  |  0\.1\.0\-23\.amzn2023\.0\.3  | 
|  libical  |  aarch64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical  |  x86\_64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-devel  |  aarch64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-devel  |  x86\_64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-glib  |  aarch64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-glib  |  x86\_64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-glib\-devel  |  aarch64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-glib\-devel  |  x86\_64  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libical\-glib\-doc  |  noarch  |  libical  |  3\.0\.14\-1\.amzn2023\.0\.2  | 
|  libICE  |  aarch64  |  libICE  |  1\.0\.10\-6\.amzn2023\.0\.2  | 
|  libICE  |  x86\_64  |  libICE  |  1\.0\.10\-6\.amzn2023\.0\.2  | 
|  libICE\-devel  |  aarch64  |  libICE  |  1\.0\.10\-6\.amzn2023\.0\.2  | 
|  libICE\-devel  |  x86\_64  |  libICE  |  1\.0\.10\-6\.amzn2023\.0\.2  | 
|  libicns  |  aarch64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libicns  |  x86\_64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libicns\-devel  |  aarch64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libicns\-devel  |  x86\_64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libicns\-utils  |  aarch64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libicns\-utils  |  x86\_64  |  libicns  |  0\.8\.1\-21\.amzn2023\.0\.2  | 
|  libidn  |  aarch64  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  libidn  |  x86\_64  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  libidn\-devel  |  aarch64  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  libidn\-devel  |  x86\_64  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  libidn\-java  |  noarch  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  libidn\-javadoc  |  noarch  |  libidn  |  1\.38\-4\.amzn2023\.0\.3  | 
|  idn2  |  aarch64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  idn2  |  x86\_64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  libidn2  |  aarch64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  libidn2  |  x86\_64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  libidn2\-devel  |  aarch64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  libidn2\-devel  |  x86\_64  |  libidn2  |  2\.3\.2\-1\.amzn2023\.0\.2  | 
|  libijs  |  aarch64  |  libijs  |  0\.35\-13\.amzn2023\.0\.2  | 
|  libijs  |  x86\_64  |  libijs  |  0\.35\-13\.amzn2023\.0\.2  | 
|  libijs\-devel  |  aarch64  |  libijs  |  0\.35\-13\.amzn2023\.0\.2  | 
|  libijs\-devel  |  x86\_64  |  libijs  |  0\.35\-13\.amzn2023\.0\.2  | 
|  libijs\-doc  |  noarch  |  libijs  |  0\.35\-13\.amzn2023\.0\.2  | 
|  libimagequant  |  aarch64  |  libimagequant  |  2\.14\.1\-1\.amzn2023\.0\.2  | 
|  libimagequant  |  x86\_64  |  libimagequant  |  2\.14\.1\-1\.amzn2023\.0\.2  | 
|  libimagequant\-devel  |  aarch64  |  libimagequant  |  2\.14\.1\-1\.amzn2023\.0\.2  | 
|  libimagequant\-devel  |  x86\_64  |  libimagequant  |  2\.14\.1\-1\.amzn2023\.0\.2  | 
|  libinput  |  aarch64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput  |  x86\_64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-devel  |  aarch64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-devel  |  x86\_64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-test  |  aarch64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-test  |  x86\_64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-utils  |  aarch64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libinput\-utils  |  x86\_64  |  libinput  |  1\.19\.4\-1\.amzn2023\.0\.2  | 
|  libipt  |  x86\_64  |  libipt  |  2\.0\.4\-2\.amzn2023\.0\.2  | 
|  libipt\-devel  |  x86\_64  |  libipt  |  2\.0\.4\-2\.amzn2023\.0\.2  | 
|  libiscsi  |  aarch64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libiscsi  |  x86\_64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libiscsi\-devel  |  aarch64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libiscsi\-devel  |  x86\_64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libiscsi\-utils  |  aarch64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libiscsi\-utils  |  x86\_64  |  libiscsi  |  1\.19\.0\-7\.amzn2023  | 
|  libisofs  |  aarch64  |  libisofs  |  1\.5\.4\-1\.amzn2023\.0\.2  | 
|  libisofs  |  x86\_64  |  libisofs  |  1\.5\.4\-1\.amzn2023\.0\.2  | 
|  libisofs\-devel  |  aarch64  |  libisofs  |  1\.5\.4\-1\.amzn2023\.0\.2  | 
|  libisofs\-devel  |  x86\_64  |  libisofs  |  1\.5\.4\-1\.amzn2023\.0\.2  | 
|  libisofs\-doc  |  noarch  |  libisofs  |  1\.5\.4\-1\.amzn2023\.0\.2  | 
|  libjpeg\-turbo  |  aarch64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libjpeg\-turbo  |  x86\_64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libjpeg\-turbo\-devel  |  aarch64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libjpeg\-turbo\-devel  |  x86\_64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libjpeg\-turbo\-utils  |  aarch64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libjpeg\-turbo\-utils  |  x86\_64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  turbojpeg  |  aarch64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  turbojpeg  |  x86\_64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  turbojpeg\-devel  |  aarch64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  turbojpeg\-devel  |  x86\_64  |  libjpeg\-turbo  |  2\.1\.4\-2\.amzn2023\.0\.2  | 
|  libkcapi  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-devel  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-devel  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-doc  |  noarch  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-fipscheck  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-fipscheck  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-hmaccalc  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-hmaccalc  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-static  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-static  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-tests  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-tests  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-tools  |  aarch64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libkcapi\-tools  |  x86\_64  |  libkcapi  |  1\.4\.0\-105\.amzn2023\.0\.1  | 
|  libksba  |  aarch64  |  libksba  |  1\.6\.3\-1\.amzn2023\.0\.2  | 
|  libksba  |  x86\_64  |  libksba  |  1\.6\.3\-1\.amzn2023\.0\.2  | 
|  libksba\-devel  |  aarch64  |  libksba  |  1\.6\.3\-1\.amzn2023\.0\.2  | 
|  libksba\-devel  |  x86\_64  |  libksba  |  1\.6\.3\-1\.amzn2023\.0\.2  | 
|  ldb\-tools  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  ldb\-tools  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  libldb  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  libldb  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  libldb\-devel  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  libldb\-devel  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python3\-ldb  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python3\-ldb  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python3\-ldb\-devel  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python3\-ldb\-devel  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python\-ldb\-devel\-common  |  aarch64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  python\-ldb\-devel\-common  |  x86\_64  |  libldb  |  2\.6\.2\-1\.amzn2023\.0\.2  | 
|  liblockfile  |  aarch64  |  liblockfile  |  1\.14\-7\.amzn2023\.0\.2  | 
|  liblockfile  |  x86\_64  |  liblockfile  |  1\.14\-7\.amzn2023\.0\.2  | 
|  liblockfile\-devel  |  aarch64  |  liblockfile  |  1\.14\-7\.amzn2023\.0\.2  | 
|  liblockfile\-devel  |  x86\_64  |  liblockfile  |  1\.14\-7\.amzn2023\.0\.2  | 
|  liblognorm  |  aarch64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm  |  x86\_64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-devel  |  aarch64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-devel  |  x86\_64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-doc  |  aarch64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-doc  |  x86\_64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-utils  |  aarch64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblognorm\-utils  |  x86\_64  |  liblognorm  |  2\.0\.6\-1\.amzn2023\.0\.3  | 
|  liblqr\-1  |  aarch64  |  liblqr\-1  |  0\.4\.2\-16\.amzn2023\.0\.2  | 
|  liblqr\-1  |  x86\_64  |  liblqr\-1  |  0\.4\.2\-16\.amzn2023\.0\.2  | 
|  liblqr\-1\-devel  |  aarch64  |  liblqr\-1  |  0\.4\.2\-16\.amzn2023\.0\.2  | 
|  liblqr\-1\-devel  |  x86\_64  |  liblqr\-1  |  0\.4\.2\-16\.amzn2023\.0\.2  | 
|  libmaxminddb  |  aarch64  |  libmaxminddb  |  1\.5\.2\-1\.amzn2023\.0\.2  | 
|  libmaxminddb  |  x86\_64  |  libmaxminddb  |  1\.5\.2\-1\.amzn2023\.0\.2  | 
|  libmaxminddb\-devel  |  aarch64  |  libmaxminddb  |  1\.5\.2\-1\.amzn2023\.0\.2  | 
|  libmaxminddb\-devel  |  x86\_64  |  libmaxminddb  |  1\.5\.2\-1\.amzn2023\.0\.2  | 
|  libmbim  |  aarch64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmbim  |  x86\_64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmbim\-devel  |  aarch64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmbim\-devel  |  x86\_64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmbim\-utils  |  aarch64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmbim\-utils  |  x86\_64  |  libmbim  |  1\.26\.0\-1\.amzn2023\.0\.2  | 
|  libmetalink  |  aarch64  |  libmetalink  |  0\.1\.3\-14\.amzn2023\.0\.2  | 
|  libmetalink  |  x86\_64  |  libmetalink  |  0\.1\.3\-14\.amzn2023\.0\.2  | 
|  libmetalink\-devel  |  aarch64  |  libmetalink  |  0\.1\.3\-14\.amzn2023\.0\.2  | 
|  libmetalink\-devel  |  x86\_64  |  libmetalink  |  0\.1\.3\-14\.amzn2023\.0\.2  | 
|  libmicrohttpd  |  aarch64  |  libmicrohttpd  |  0\.9\.73\-1\.amzn2023\.0\.3  | 
|  libmicrohttpd  |  x86\_64  |  libmicrohttpd  |  0\.9\.73\-1\.amzn2023\.0\.3  | 
|  libmicrohttpd\-devel  |  aarch64  |  libmicrohttpd  |  0\.9\.73\-1\.amzn2023\.0\.3  | 
|  libmicrohttpd\-devel  |  x86\_64  |  libmicrohttpd  |  0\.9\.73\-1\.amzn2023\.0\.3  | 
|  libmicrohttpd\-doc  |  noarch  |  libmicrohttpd  |  0\.9\.73\-1\.amzn2023\.0\.3  | 
|  libmnl  |  aarch64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmnl  |  x86\_64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmnl\-devel  |  aarch64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmnl\-devel  |  x86\_64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmnl\-static  |  aarch64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmnl\-static  |  x86\_64  |  libmnl  |  1\.0\.4\-13\.amzn2023\.0\.2  | 
|  libmodulemd  |  aarch64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  libmodulemd  |  x86\_64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  libmodulemd\-devel  |  aarch64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  libmodulemd\-devel  |  x86\_64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  python3\-libmodulemd  |  aarch64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  python3\-libmodulemd  |  x86\_64  |  libmodulemd  |  2\.13\.0\-2\.amzn2023\.0\.2  | 
|  libmpc  |  aarch64  |  libmpc  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  libmpc  |  x86\_64  |  libmpc  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  libmpc\-devel  |  aarch64  |  libmpc  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  libmpc\-devel  |  x86\_64  |  libmpc  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  libmpc\-doc  |  noarch  |  libmpc  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  libmspack  |  aarch64  |  libmspack  |  0\.10\.1\-0\.8\.alpha\.amzn2023  | 
|  libmspack  |  x86\_64  |  libmspack  |  0\.10\.1\-0\.8\.alpha\.amzn2023  | 
|  libmspack\-devel  |  aarch64  |  libmspack  |  0\.10\.1\-0\.8\.alpha\.amzn2023  | 
|  libmspack\-devel  |  x86\_64  |  libmspack  |  0\.10\.1\-0\.8\.alpha\.amzn2023  | 
|  libnet  |  aarch64  |  libnet  |  1\.2\-2\.amzn2023\.0\.2  | 
|  libnet  |  x86\_64  |  libnet  |  1\.2\-2\.amzn2023\.0\.2  | 
|  libnet\-devel  |  aarch64  |  libnet  |  1\.2\-2\.amzn2023\.0\.2  | 
|  libnet\-devel  |  x86\_64  |  libnet  |  1\.2\-2\.amzn2023\.0\.2  | 
|  libnet\-doc  |  noarch  |  libnet  |  1\.2\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_conntrack  |  aarch64  |  libnetfilter\_conntrack  |  1\.0\.8\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_conntrack  |  x86\_64  |  libnetfilter\_conntrack  |  1\.0\.8\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_conntrack\-devel  |  aarch64  |  libnetfilter\_conntrack  |  1\.0\.8\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_conntrack\-devel  |  x86\_64  |  libnetfilter\_conntrack  |  1\.0\.8\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_cthelper  |  aarch64  |  libnetfilter\_cthelper  |  1\.0\.0\-21\.amzn2023\.0\.2  | 
|  libnetfilter\_cthelper  |  x86\_64  |  libnetfilter\_cthelper  |  1\.0\.0\-21\.amzn2023\.0\.2  | 
|  libnetfilter\_cthelper\-devel  |  aarch64  |  libnetfilter\_cthelper  |  1\.0\.0\-21\.amzn2023\.0\.2  | 
|  libnetfilter\_cthelper\-devel  |  x86\_64  |  libnetfilter\_cthelper  |  1\.0\.0\-21\.amzn2023\.0\.2  | 
|  libnetfilter\_cttimeout  |  aarch64  |  libnetfilter\_cttimeout  |  1\.0\.0\-19\.amzn2023\.0\.2  | 
|  libnetfilter\_cttimeout  |  x86\_64  |  libnetfilter\_cttimeout  |  1\.0\.0\-19\.amzn2023\.0\.2  | 
|  libnetfilter\_cttimeout\-devel  |  aarch64  |  libnetfilter\_cttimeout  |  1\.0\.0\-19\.amzn2023\.0\.2  | 
|  libnetfilter\_cttimeout\-devel  |  x86\_64  |  libnetfilter\_cttimeout  |  1\.0\.0\-19\.amzn2023\.0\.2  | 
|  libnetfilter\_queue  |  aarch64  |  libnetfilter\_queue  |  1\.0\.5\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_queue  |  x86\_64  |  libnetfilter\_queue  |  1\.0\.5\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_queue\-devel  |  aarch64  |  libnetfilter\_queue  |  1\.0\.5\-2\.amzn2023\.0\.2  | 
|  libnetfilter\_queue\-devel  |  x86\_64  |  libnetfilter\_queue  |  1\.0\.5\-2\.amzn2023\.0\.2  | 
|  libnfnetlink  |  aarch64  |  libnfnetlink  |  1\.0\.1\-19\.amzn2023\.0\.2  | 
|  libnfnetlink  |  x86\_64  |  libnfnetlink  |  1\.0\.1\-19\.amzn2023\.0\.2  | 
|  libnfnetlink\-devel  |  aarch64  |  libnfnetlink  |  1\.0\.1\-19\.amzn2023\.0\.2  | 
|  libnfnetlink\-devel  |  x86\_64  |  libnfnetlink  |  1\.0\.1\-19\.amzn2023\.0\.2  | 
|  libnfs  |  aarch64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnfs  |  x86\_64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnfs\-devel  |  aarch64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnfs\-devel  |  x86\_64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnfs\-utils  |  aarch64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnfs\-utils  |  x86\_64  |  libnfs  |  4\.0\.0\-4\.amzn2023\.0\.2  | 
|  libnftnl  |  aarch64  |  libnftnl  |  1\.2\.2\-2\.amzn2023\.0\.2  | 
|  libnftnl  |  x86\_64  |  libnftnl  |  1\.2\.2\-2\.amzn2023\.0\.2  | 
|  libnftnl\-devel  |  aarch64  |  libnftnl  |  1\.2\.2\-2\.amzn2023\.0\.2  | 
|  libnftnl\-devel  |  x86\_64  |  libnftnl  |  1\.2\.2\-2\.amzn2023\.0\.2  | 
|  libnl3  |  aarch64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3  |  x86\_64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-cli  |  aarch64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-cli  |  x86\_64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-devel  |  aarch64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-devel  |  x86\_64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-doc  |  aarch64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnl3\-doc  |  x86\_64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  python3\-libnl3  |  aarch64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  python3\-libnl3  |  x86\_64  |  libnl3  |  3\.5\.0\-6\.amzn2023\.0\.2  | 
|  libnotify  |  aarch64  |  libnotify  |  0\.7\.9\-4\.amzn2023\.0\.2  | 
|  libnotify  |  x86\_64  |  libnotify  |  0\.7\.9\-4\.amzn2023\.0\.2  | 
|  libnotify\-devel  |  aarch64  |  libnotify  |  0\.7\.9\-4\.amzn2023\.0\.2  | 
|  libnotify\-devel  |  x86\_64  |  libnotify  |  0\.7\.9\-4\.amzn2023\.0\.2  | 
|  libntlm  |  aarch64  |  libntlm  |  1\.6\-2\.amzn2023\.0\.2  | 
|  libntlm  |  x86\_64  |  libntlm  |  1\.6\-2\.amzn2023\.0\.2  | 
|  libntlm\-devel  |  aarch64  |  libntlm  |  1\.6\-2\.amzn2023\.0\.2  | 
|  libntlm\-devel  |  x86\_64  |  libntlm  |  1\.6\-2\.amzn2023\.0\.2  | 
|  libogg  |  aarch64  |  libogg  |  1\.3\.4\-4\.amzn2023\.0\.2  | 
|  libogg  |  x86\_64  |  libogg  |  1\.3\.4\-4\.amzn2023\.0\.2  | 
|  libogg\-devel  |  aarch64  |  libogg  |  1\.3\.4\-4\.amzn2023\.0\.2  | 
|  libogg\-devel  |  x86\_64  |  libogg  |  1\.3\.4\-4\.amzn2023\.0\.2  | 
|  libogg\-devel\-docs  |  noarch  |  libogg  |  1\.3\.4\-4\.amzn2023\.0\.2  | 
|  libomp  |  aarch64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomp  |  x86\_64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomp\-devel  |  aarch64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomp\-devel  |  x86\_64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomp\-test  |  aarch64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomp\-test  |  x86\_64  |  libomp  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  libomxil\-bellagio  |  aarch64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libomxil\-bellagio  |  x86\_64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libomxil\-bellagio\-devel  |  aarch64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libomxil\-bellagio\-devel  |  x86\_64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libomxil\-bellagio\-test  |  aarch64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libomxil\-bellagio\-test  |  x86\_64  |  libomxil\-bellagio  |  0\.9\.3\-26\.amzn2023\.0\.2  | 
|  libotf  |  aarch64  |  libotf  |  0\.9\.13\-18\.amzn2023\.0\.2  | 
|  libotf  |  x86\_64  |  libotf  |  0\.9\.13\-18\.amzn2023\.0\.2  | 
|  libotf\-devel  |  aarch64  |  libotf  |  0\.9\.13\-18\.amzn2023\.0\.2  | 
|  libotf\-devel  |  x86\_64  |  libotf  |  0\.9\.13\-18\.amzn2023\.0\.2  | 
|  libpaper  |  aarch64  |  libpaper  |  1\.1\.28\-2\.amzn2023\.0\.2  | 
|  libpaper  |  x86\_64  |  libpaper  |  1\.1\.28\-2\.amzn2023\.0\.2  | 
|  libpaper\-devel  |  aarch64  |  libpaper  |  1\.1\.28\-2\.amzn2023\.0\.2  | 
|  libpaper\-devel  |  x86\_64  |  libpaper  |  1\.1\.28\-2\.amzn2023\.0\.2  | 
|  libpcap  |  aarch64  |  libpcap  |  1\.10\.1\-1\.amzn2023\.0\.2  | 
|  libpcap  |  x86\_64  |  libpcap  |  1\.10\.1\-1\.amzn2023\.0\.2  | 
|  libpcap\-devel  |  aarch64  |  libpcap  |  1\.10\.1\-1\.amzn2023\.0\.2  | 
|  libpcap\-devel  |  x86\_64  |  libpcap  |  1\.10\.1\-1\.amzn2023\.0\.2  | 
|  libpciaccess  |  aarch64  |  libpciaccess  |  0\.16\-4\.amzn2023\.0\.2  | 
|  libpciaccess  |  x86\_64  |  libpciaccess  |  0\.16\-4\.amzn2023\.0\.2  | 
|  libpciaccess\-devel  |  aarch64  |  libpciaccess  |  0\.16\-4\.amzn2023\.0\.2  | 
|  libpciaccess\-devel  |  x86\_64  |  libpciaccess  |  0\.16\-4\.amzn2023\.0\.2  | 
|  libpeas  |  aarch64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas  |  x86\_64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-devel  |  aarch64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-devel  |  x86\_64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-gtk  |  aarch64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-gtk  |  x86\_64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-loader\-python3  |  aarch64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpeas\-loader\-python3  |  x86\_64  |  libpeas  |  1\.32\.0\-1\.amzn2023\.0\.3  | 
|  libpfm  |  aarch64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpfm  |  x86\_64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpfm\-devel  |  aarch64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpfm\-devel  |  x86\_64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpfm\-static  |  aarch64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpfm\-static  |  x86\_64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  python3\-libpfm  |  aarch64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  python3\-libpfm  |  x86\_64  |  libpfm  |  4\.11\.0\-4\.amzn2023\.0\.2  | 
|  libpinyin  |  aarch64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin  |  x86\_64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-data  |  aarch64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-data  |  x86\_64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-devel  |  aarch64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-devel  |  x86\_64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-tools  |  aarch64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpinyin\-tools  |  x86\_64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libzhuyin  |  aarch64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libzhuyin  |  x86\_64  |  libpinyin  |  2\.6\.0\-2\.amzn2023\.0\.3  | 
|  libpipeline  |  aarch64  |  libpipeline  |  1\.5\.3\-2\.amzn2023\.0\.2  | 
|  libpipeline  |  x86\_64  |  libpipeline  |  1\.5\.3\-2\.amzn2023\.0\.2  | 
|  libpipeline\-devel  |  aarch64  |  libpipeline  |  1\.5\.3\-2\.amzn2023\.0\.2  | 
|  libpipeline\-devel  |  x86\_64  |  libpipeline  |  1\.5\.3\-2\.amzn2023\.0\.2  | 
|  libplist  |  aarch64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  libplist  |  x86\_64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  libplist\-devel  |  aarch64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  libplist\-devel  |  x86\_64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  python3\-libplist  |  aarch64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  python3\-libplist  |  x86\_64  |  libplist  |  2\.2\.0\-3\.amzn2023\.0\.2  | 
|  libpng  |  aarch64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng  |  x86\_64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-devel  |  aarch64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-devel  |  x86\_64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-static  |  aarch64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-static  |  x86\_64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-tools  |  aarch64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpng\-tools  |  x86\_64  |  libpng  |  1\.6\.37\-10\.amzn2023\.0\.2  | 
|  libpq  |  aarch64  |  libpq  |  15\.0\-2\.amzn2023\.0\.1  | 
|  libpq  |  x86\_64  |  libpq  |  15\.0\-2\.amzn2023\.0\.1  | 
|  libpq\-devel  |  aarch64  |  libpq  |  15\.0\-2\.amzn2023\.0\.1  | 
|  libpq\-devel  |  x86\_64  |  libpq  |  15\.0\-2\.amzn2023\.0\.1  | 
|  libproxy  |  aarch64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libproxy  |  x86\_64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libproxy\-bin  |  aarch64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libproxy\-bin  |  x86\_64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libproxy\-devel  |  aarch64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libproxy\-devel  |  x86\_64  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  python3\-libproxy  |  noarch  |  libproxy  |  0\.4\.15\-30\.amzn2023\.0\.5  | 
|  libpsl  |  aarch64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  libpsl  |  x86\_64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  libpsl\-devel  |  aarch64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  libpsl\-devel  |  x86\_64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  psl  |  aarch64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  psl  |  x86\_64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  psl\-make\-dafsa  |  aarch64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  psl\-make\-dafsa  |  x86\_64  |  libpsl  |  0\.21\.1\-3\.amzn2023\.0\.2  | 
|  libpsm2  |  x86\_64  |  libpsm2  |  11\.2\.86\-8\.amzn2023\.0\.2  | 
|  libpsm2\-compat  |  x86\_64  |  libpsm2  |  11\.2\.86\-8\.amzn2023\.0\.2  | 
|  libpsm2\-devel  |  x86\_64  |  libpsm2  |  11\.2\.86\-8\.amzn2023\.0\.2  | 
|  libpwquality  |  aarch64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  libpwquality  |  x86\_64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  libpwquality\-devel  |  aarch64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  libpwquality\-devel  |  x86\_64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  python3\-pwquality  |  aarch64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  python3\-pwquality  |  x86\_64  |  libpwquality  |  1\.4\.4\-6\.amzn2023\.0\.2  | 
|  doxygen2man  |  aarch64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  doxygen2man  |  x86\_64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  libqb  |  aarch64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  libqb  |  x86\_64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  libqb\-devel  |  aarch64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  libqb\-devel  |  x86\_64  |  libqb  |  2\.0\.6\-1\.amzn2023  | 
|  libqrtr\-glib  |  aarch64  |  libqrtr\-glib  |  1\.0\.0\-1\.amzn2023\.0\.2  | 
|  libqrtr\-glib  |  x86\_64  |  libqrtr\-glib  |  1\.0\.0\-1\.amzn2023\.0\.2  | 
|  libqrtr\-glib\-devel  |  aarch64  |  libqrtr\-glib  |  1\.0\.0\-1\.amzn2023\.0\.2  | 
|  libqrtr\-glib\-devel  |  x86\_64  |  libqrtr\-glib  |  1\.0\.0\-1\.amzn2023\.0\.2  | 
|  libraqm  |  aarch64  |  libraqm  |  0\.7\.2\-1\.amzn2023\.0\.2  | 
|  libraqm  |  x86\_64  |  libraqm  |  0\.7\.2\-1\.amzn2023\.0\.2  | 
|  libraqm\-devel  |  aarch64  |  libraqm  |  0\.7\.2\-1\.amzn2023\.0\.2  | 
|  libraqm\-devel  |  x86\_64  |  libraqm  |  0\.7\.2\-1\.amzn2023\.0\.2  | 
|  libraqm\-docs  |  noarch  |  libraqm  |  0\.7\.2\-1\.amzn2023\.0\.2  | 
|  librepo  |  aarch64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  librepo  |  x86\_64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  librepo\-devel  |  aarch64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  librepo\-devel  |  x86\_64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  python3\-librepo  |  aarch64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  python3\-librepo  |  x86\_64  |  librepo  |  1\.14\.2\-1\.amzn2023\.0\.4  | 
|  libreport  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-anaconda  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-anaconda  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-centos  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-centos  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-cli  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-cli  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-devel  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-devel  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-fedora  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-fedora  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-filesystem  |  noarch  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-gtk  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-gtk  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-gtk\-devel  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-gtk\-devel  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-newt  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-newt  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-bugzilla  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-bugzilla  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-kerneloops  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-kerneloops  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-logger  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-logger  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-mailx  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-mailx  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-mantisbt  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-mantisbt  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-reportuploader  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-reportuploader  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-systemd\-journal  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-systemd\-journal  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-ureport  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-plugin\-ureport  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-web  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-web  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-web\-devel  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  libreport\-web\-devel  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  python3\-libreport  |  aarch64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  python3\-libreport  |  x86\_64  |  libreport  |  2\.15\.2\-2\.amzn2023\.0\.2  | 
|  librevenge  |  aarch64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge  |  x86\_64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge\-devel  |  aarch64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge\-devel  |  x86\_64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge\-doc  |  noarch  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge\-gdb  |  aarch64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librevenge\-gdb  |  x86\_64  |  librevenge  |  0\.0\.4\-20\.amzn2023\.0\.2  | 
|  librsvg2  |  aarch64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  librsvg2  |  x86\_64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  librsvg2\-devel  |  aarch64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  librsvg2\-devel  |  x86\_64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  librsvg2\-tools  |  aarch64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  librsvg2\-tools  |  x86\_64  |  librsvg2  |  2\.50\.7\-1\.amzn2023\.0\.2  | 
|  libseccomp  |  aarch64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libseccomp  |  x86\_64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libseccomp\-devel  |  aarch64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libseccomp\-devel  |  x86\_64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libseccomp\-static  |  aarch64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libseccomp\-static  |  x86\_64  |  libseccomp  |  2\.5\.3\-1\.amzn2023\.0\.2  | 
|  libsecret  |  aarch64  |  libsecret  |  0\.20\.4\-2\.amzn2023\.0\.2  | 
|  libsecret  |  x86\_64  |  libsecret  |  0\.20\.4\-2\.amzn2023\.0\.2  | 
|  libsecret\-devel  |  aarch64  |  libsecret  |  0\.20\.4\-2\.amzn2023\.0\.2  | 
|  libsecret\-devel  |  x86\_64  |  libsecret  |  0\.20\.4\-2\.amzn2023\.0\.2  | 
|  libselinux  |  aarch64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux  |  x86\_64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-devel  |  aarch64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-devel  |  x86\_64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-static  |  aarch64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-static  |  x86\_64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-utils  |  aarch64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libselinux\-utils  |  x86\_64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libselinux  |  aarch64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libselinux  |  x86\_64  |  libselinux  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage  |  aarch64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage  |  x86\_64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage\-devel  |  aarch64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage\-devel  |  x86\_64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage\-static  |  aarch64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsemanage\-static  |  x86\_64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libsemanage  |  aarch64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libsemanage  |  x86\_64  |  libsemanage  |  3\.4\-5\.amzn2023\.0\.2  | 
|  libsepol  |  aarch64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol  |  x86\_64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-devel  |  aarch64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-devel  |  x86\_64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-static  |  aarch64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-static  |  x86\_64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-utils  |  aarch64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libsepol\-utils  |  x86\_64  |  libsepol  |  3\.4\-3\.amzn2023\.0\.3  | 
|  libserf  |  aarch64  |  libserf  |  1\.3\.9\-23\.amzn2023\.0\.3  | 
|  libserf  |  x86\_64  |  libserf  |  1\.3\.9\-23\.amzn2023\.0\.3  | 
|  libserf\-devel  |  aarch64  |  libserf  |  1\.3\.9\-23\.amzn2023\.0\.3  | 
|  libserf\-devel  |  x86\_64  |  libserf  |  1\.3\.9\-23\.amzn2023\.0\.3  | 
|  libsigc\+\+20  |  aarch64  |  libsigc\+\+20  |  2\.10\.7\-1\.amzn2023\.0\.3  | 
|  libsigc\+\+20  |  x86\_64  |  libsigc\+\+20  |  2\.10\.7\-1\.amzn2023\.0\.3  | 
|  libsigc\+\+20\-devel  |  aarch64  |  libsigc\+\+20  |  2\.10\.7\-1\.amzn2023\.0\.3  | 
|  libsigc\+\+20\-devel  |  x86\_64  |  libsigc\+\+20  |  2\.10\.7\-1\.amzn2023\.0\.3  | 
|  libsigc\+\+20\-doc  |  noarch  |  libsigc\+\+20  |  2\.10\.7\-1\.amzn2023\.0\.3  | 
|  libsigsegv  |  aarch64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libsigsegv  |  x86\_64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libsigsegv\-devel  |  aarch64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libsigsegv\-devel  |  x86\_64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libsigsegv\-static  |  aarch64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libsigsegv\-static  |  x86\_64  |  libsigsegv  |  2\.13\-2\.amzn2023\.0\.2  | 
|  libSM  |  aarch64  |  libSM  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libSM  |  x86\_64  |  libSM  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libSM\-devel  |  aarch64  |  libSM  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libSM\-devel  |  x86\_64  |  libSM  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libsmi  |  aarch64  |  libsmi  |  0\.4\.8\-28\.amzn2023\.0\.2  | 
|  libsmi  |  x86\_64  |  libsmi  |  0\.4\.8\-28\.amzn2023\.0\.2  | 
|  libsmi\-devel  |  aarch64  |  libsmi  |  0\.4\.8\-28\.amzn2023\.0\.2  | 
|  libsmi\-devel  |  x86\_64  |  libsmi  |  0\.4\.8\-28\.amzn2023\.0\.2  | 
|  libsndfile  |  aarch64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsndfile  |  x86\_64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsndfile\-devel  |  aarch64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsndfile\-devel  |  x86\_64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsndfile\-utils  |  aarch64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsndfile\-utils  |  x86\_64  |  libsndfile  |  1\.0\.31\-6\.amzn2023\.0\.2  | 
|  libsolv  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-demo  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-demo  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-devel  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-devel  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-tools  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsolv\-tools  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  perl\-solv  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  perl\-solv  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  python3\-solv  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  python3\-solv  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  ruby\-solv  |  aarch64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  ruby\-solv  |  x86\_64  |  libsolv  |  0\.7\.22\-1\.amzn2023\.0\.2  | 
|  libsoup  |  aarch64  |  libsoup  |  2\.72\.0\-6\.amzn2023\.0\.2  | 
|  libsoup  |  x86\_64  |  libsoup  |  2\.72\.0\-6\.amzn2023\.0\.2  | 
|  libsoup\-devel  |  aarch64  |  libsoup  |  2\.72\.0\-6\.amzn2023\.0\.2  | 
|  libsoup\-devel  |  x86\_64  |  libsoup  |  2\.72\.0\-6\.amzn2023\.0\.2  | 
|  libsoup\-doc  |  noarch  |  libsoup  |  2\.72\.0\-6\.amzn2023\.0\.2  | 
|  libspiro  |  aarch64  |  libspiro  |  20200505\-3\.amzn2023\.0\.2  | 
|  libspiro  |  x86\_64  |  libspiro  |  20200505\-3\.amzn2023\.0\.2  | 
|  libspiro\-devel  |  aarch64  |  libspiro  |  20200505\-3\.amzn2023\.0\.2  | 
|  libspiro\-devel  |  x86\_64  |  libspiro  |  20200505\-3\.amzn2023\.0\.2  | 
|  libssh  |  aarch64  |  libssh  |  0\.10\.5\-1\.amzn2023\.0\.1  | 
|  libssh  |  x86\_64  |  libssh  |  0\.10\.5\-1\.amzn2023\.0\.1  | 
|  libssh\-config  |  noarch  |  libssh  |  0\.10\.5\-1\.amzn2023\.0\.1  | 
|  libssh\-devel  |  aarch64  |  libssh  |  0\.10\.5\-1\.amzn2023\.0\.1  | 
|  libssh\-devel  |  x86\_64  |  libssh  |  0\.10\.5\-1\.amzn2023\.0\.1  | 
|  libssh2  |  aarch64  |  libssh2  |  1\.10\.0\-1\.amzn2023\.0\.2  | 
|  libssh2  |  x86\_64  |  libssh2  |  1\.10\.0\-1\.amzn2023\.0\.2  | 
|  libssh2\-devel  |  aarch64  |  libssh2  |  1\.10\.0\-1\.amzn2023\.0\.2  | 
|  libssh2\-devel  |  x86\_64  |  libssh2  |  1\.10\.0\-1\.amzn2023\.0\.2  | 
|  libssh2\-docs  |  noarch  |  libssh2  |  1\.10\.0\-1\.amzn2023\.0\.2  | 
|  libstemmer  |  aarch64  |  libstemmer  |  0\-16\.585svn\.amzn2023\.0\.2  | 
|  libstemmer  |  x86\_64  |  libstemmer  |  0\-16\.585svn\.amzn2023\.0\.2  | 
|  libstemmer\-devel  |  aarch64  |  libstemmer  |  0\-16\.585svn\.amzn2023\.0\.2  | 
|  libstemmer\-devel  |  x86\_64  |  libstemmer  |  0\-16\.585svn\.amzn2023\.0\.2  | 
|  libstoragemgmt  |  aarch64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt  |  x86\_64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-arcconf\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-devel  |  aarch64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-devel  |  x86\_64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-hpsa\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-local\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-megaraid\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-nfs\-plugin  |  aarch64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-nfs\-plugin  |  x86\_64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-smis\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-targetd\-plugin  |  noarch  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-udev  |  aarch64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libstoragemgmt\-udev  |  x86\_64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libstoragemgmt  |  aarch64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  python3\-libstoragemgmt  |  x86\_64  |  libstoragemgmt  |  1\.9\.4\-5\.amzn2023\.0\.2  | 
|  libtalloc  |  aarch64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  libtalloc  |  x86\_64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  libtalloc\-devel  |  aarch64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  libtalloc\-devel  |  x86\_64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  python3\-talloc  |  aarch64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  python3\-talloc  |  x86\_64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  python3\-talloc\-devel  |  aarch64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  python3\-talloc\-devel  |  x86\_64  |  libtalloc  |  2\.3\.4\-1\.amzn2023\.0\.2  | 
|  libtasn1  |  aarch64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtasn1  |  x86\_64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtasn1\-devel  |  aarch64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtasn1\-devel  |  x86\_64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtasn1\-tools  |  aarch64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtasn1\-tools  |  x86\_64  |  libtasn1  |  4\.19\.0\-1\.amzn2023\.0\.1  | 
|  libtdb  |  aarch64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  libtdb  |  x86\_64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  libtdb\-devel  |  aarch64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  libtdb\-devel  |  x86\_64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  python3\-tdb  |  aarch64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  python3\-tdb  |  x86\_64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  tdb\-tools  |  aarch64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  tdb\-tools  |  x86\_64  |  libtdb  |  1\.4\.7\-1\.amzn2023\.0\.2  | 
|  libtevent  |  aarch64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  libtevent  |  x86\_64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  libtevent\-devel  |  aarch64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  libtevent\-devel  |  x86\_64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  python3\-tevent  |  aarch64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  python3\-tevent  |  x86\_64  |  libtevent  |  0\.13\.0\-1\.amzn2023\.0\.2  | 
|  libthai  |  aarch64  |  libthai  |  0\.1\.28\-6\.amzn2023\.0\.2  | 
|  libthai  |  x86\_64  |  libthai  |  0\.1\.28\-6\.amzn2023\.0\.2  | 
|  libthai\-devel  |  aarch64  |  libthai  |  0\.1\.28\-6\.amzn2023\.0\.2  | 
|  libthai\-devel  |  x86\_64  |  libthai  |  0\.1\.28\-6\.amzn2023\.0\.2  | 
|  libtheora  |  aarch64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  libtheora  |  x86\_64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  libtheora\-devel  |  aarch64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  libtheora\-devel  |  x86\_64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  libtheora\-devel\-docs  |  noarch  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  theora\-tools  |  aarch64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  theora\-tools  |  x86\_64  |  libtheora  |  1\.1\.1\-29\.amzn2023\.0\.3  | 
|  libtiff  |  aarch64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff  |  x86\_64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-devel  |  aarch64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-devel  |  x86\_64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-static  |  aarch64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-static  |  x86\_64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-tools  |  aarch64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtiff\-tools  |  x86\_64  |  libtiff  |  4\.4\.0\-4\.amzn2023\.0\.7  | 
|  libtirpc  |  aarch64  |  libtirpc  |  1\.3\.3\-0\.amzn2023  | 
|  libtirpc  |  x86\_64  |  libtirpc  |  1\.3\.3\-0\.amzn2023  | 
|  libtirpc\-devel  |  aarch64  |  libtirpc  |  1\.3\.3\-0\.amzn2023  | 
|  libtirpc\-devel  |  x86\_64  |  libtirpc  |  1\.3\.3\-0\.amzn2023  | 
|  libtomcrypt  |  aarch64  |  libtomcrypt  |  1\.18\.2\-12\.amzn2023\.0\.2  | 
|  libtomcrypt  |  x86\_64  |  libtomcrypt  |  1\.18\.2\-12\.amzn2023\.0\.2  | 
|  libtomcrypt\-devel  |  aarch64  |  libtomcrypt  |  1\.18\.2\-12\.amzn2023\.0\.2  | 
|  libtomcrypt\-devel  |  x86\_64  |  libtomcrypt  |  1\.18\.2\-12\.amzn2023\.0\.2  | 
|  libtomcrypt\-doc  |  noarch  |  libtomcrypt  |  1\.18\.2\-12\.amzn2023\.0\.2  | 
|  libtommath  |  aarch64  |  libtommath  |  1\.2\.0\-9\.amzn2023\.0\.1  | 
|  libtommath  |  x86\_64  |  libtommath  |  1\.2\.0\-9\.amzn2023\.0\.1  | 
|  libtommath\-devel  |  aarch64  |  libtommath  |  1\.2\.0\-9\.amzn2023\.0\.1  | 
|  libtommath\-devel  |  x86\_64  |  libtommath  |  1\.2\.0\-9\.amzn2023\.0\.1  | 
|  libtommath\-doc  |  noarch  |  libtommath  |  1\.2\.0\-9\.amzn2023\.0\.1  | 
|  libtool  |  aarch64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libtool  |  x86\_64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libtool\-ltdl  |  aarch64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libtool\-ltdl  |  x86\_64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libtool\-ltdl\-devel  |  aarch64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libtool\-ltdl\-devel  |  x86\_64  |  libtool  |  2\.4\.7\-1\.amzn2023\.0\.3  | 
|  libuninameslist  |  aarch64  |  libuninameslist  |  20200413\-3\.amzn2023\.0\.2  | 
|  libuninameslist  |  x86\_64  |  libuninameslist  |  20200413\-3\.amzn2023\.0\.2  | 
|  libuninameslist\-devel  |  aarch64  |  libuninameslist  |  20200413\-3\.amzn2023\.0\.2  | 
|  libuninameslist\-devel  |  x86\_64  |  libuninameslist  |  20200413\-3\.amzn2023\.0\.2  | 
|  libunistring  |  aarch64  |  libunistring  |  0\.9\.10\-10\.amzn2023\.0\.2  | 
|  libunistring  |  x86\_64  |  libunistring  |  0\.9\.10\-10\.amzn2023\.0\.2  | 
|  libunistring\-devel  |  aarch64  |  libunistring  |  0\.9\.10\-10\.amzn2023\.0\.2  | 
|  libunistring\-devel  |  x86\_64  |  libunistring  |  0\.9\.10\-10\.amzn2023\.0\.2  | 
|  libunwind  |  aarch64  |  libunwind  |  1\.4\.0\-5\.amzn2023\.0\.2  | 
|  libunwind  |  x86\_64  |  libunwind  |  1\.4\.0\-5\.amzn2023\.0\.2  | 
|  libunwind\-devel  |  aarch64  |  libunwind  |  1\.4\.0\-5\.amzn2023\.0\.2  | 
|  libunwind\-devel  |  x86\_64  |  libunwind  |  1\.4\.0\-5\.amzn2023\.0\.2  | 
|  liburing  |  aarch64  |  liburing  |  2\.0\-2\.amzn2023\.0\.2  | 
|  liburing  |  x86\_64  |  liburing  |  2\.0\-2\.amzn2023\.0\.2  | 
|  liburing\-devel  |  aarch64  |  liburing  |  2\.0\-2\.amzn2023\.0\.2  | 
|  liburing\-devel  |  x86\_64  |  liburing  |  2\.0\-2\.amzn2023\.0\.2  | 
|  libusb  |  aarch64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusb  |  x86\_64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusb\-devel  |  aarch64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusb\-devel  |  x86\_64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusb\-tests\-examples  |  aarch64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusb\-tests\-examples  |  x86\_64  |  libusb  |  0\.1\.7\-6\.amzn2023\.0\.2  | 
|  libusbx  |  aarch64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx  |  x86\_64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx\-devel  |  aarch64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx\-devel  |  x86\_64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx\-devel\-doc  |  noarch  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx\-tests\-examples  |  aarch64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libusbx\-tests\-examples  |  x86\_64  |  libusbx  |  1\.0\.24\-2\.amzn2023\.0\.2  | 
|  libuser  |  aarch64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  libuser  |  x86\_64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  libuser\-devel  |  aarch64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  libuser\-devel  |  x86\_64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  python3\-libuser  |  aarch64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  python3\-libuser  |  x86\_64  |  libuser  |  0\.63\-4\.amzn2023\.0\.2  | 
|  libutempter  |  aarch64  |  libutempter  |  1\.2\.1\-4\.amzn2023\.0\.2  | 
|  libutempter  |  x86\_64  |  libutempter  |  1\.2\.1\-4\.amzn2023\.0\.2  | 
|  libutempter\-devel  |  aarch64  |  libutempter  |  1\.2\.1\-4\.amzn2023\.0\.2  | 
|  libutempter\-devel  |  x86\_64  |  libutempter  |  1\.2\.1\-4\.amzn2023\.0\.2  | 
|  libuv  |  aarch64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libuv  |  x86\_64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libuv\-devel  |  aarch64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libuv\-devel  |  x86\_64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libuv\-static  |  aarch64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libuv\-static  |  x86\_64  |  libuv  |  1\.44\.1\-156\.amzn2023\.0\.2  | 
|  libva  |  aarch64  |  libva  |  2\.11\.0\-1\.amzn2023\.0\.2  | 
|  libva  |  x86\_64  |  libva  |  2\.11\.0\-1\.amzn2023\.0\.2  | 
|  libva\-devel  |  aarch64  |  libva  |  2\.11\.0\-1\.amzn2023\.0\.2  | 
|  libva\-devel  |  x86\_64  |  libva  |  2\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvdpau  |  aarch64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau  |  x86\_64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau\-devel  |  aarch64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau\-devel  |  x86\_64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau\-docs  |  noarch  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau\-trace  |  aarch64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libvdpau\-trace  |  x86\_64  |  libvdpau  |  1\.4\-4\.amzn2023\.0\.2  | 
|  libverto  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-devel  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-devel  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-glib  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-glib  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-glib\-devel  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-glib\-devel  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libev  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libev  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libev\-devel  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libev\-devel  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libevent  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libevent  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libevent\-devel  |  aarch64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libverto\-libevent\-devel  |  x86\_64  |  libverto  |  0\.3\.2\-1\.amzn2023\.0\.2  | 
|  libvoikko  |  aarch64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  libvoikko  |  x86\_64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  libvoikko\-devel  |  aarch64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  libvoikko\-devel  |  x86\_64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  python3\-libvoikko  |  noarch  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  voikko\-tools  |  aarch64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  voikko\-tools  |  x86\_64  |  libvoikko  |  4\.3\.1\-1\.amzn2023\.0\.2  | 
|  libvorbis  |  aarch64  |  libvorbis  |  1\.3\.7\-3\.amzn2023\.0\.2  | 
|  libvorbis  |  x86\_64  |  libvorbis  |  1\.3\.7\-3\.amzn2023\.0\.2  | 
|  libvorbis\-devel  |  aarch64  |  libvorbis  |  1\.3\.7\-3\.amzn2023\.0\.2  | 
|  libvorbis\-devel  |  x86\_64  |  libvorbis  |  1\.3\.7\-3\.amzn2023\.0\.2  | 
|  libvorbis\-devel\-docs  |  noarch  |  libvorbis  |  1\.3\.7\-3\.amzn2023\.0\.2  | 
|  libvpx  |  aarch64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvpx  |  x86\_64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvpx\-devel  |  aarch64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvpx\-devel  |  x86\_64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvpx\-utils  |  aarch64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libvpx\-utils  |  x86\_64  |  libvpx  |  1\.11\.0\-1\.amzn2023\.0\.2  | 
|  libwacom  |  aarch64  |  libwacom  |  1\.12\-1\.amzn2023\.0\.2  | 
|  libwacom  |  x86\_64  |  libwacom  |  1\.12\-1\.amzn2023\.0\.2  | 
|  libwacom\-data  |  noarch  |  libwacom  |  1\.12\-1\.amzn2023\.0\.2  | 
|  libwacom\-devel  |  aarch64  |  libwacom  |  1\.12\-1\.amzn2023\.0\.2  | 
|  libwacom\-devel  |  x86\_64  |  libwacom  |  1\.12\-1\.amzn2023\.0\.2  | 
|  libwebp  |  aarch64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp  |  x86\_64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-devel  |  aarch64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-devel  |  x86\_64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-java  |  aarch64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-java  |  x86\_64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-tools  |  aarch64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwebp\-tools  |  x86\_64  |  libwebp  |  1\.2\.4\-1\.amzn2023\.0\.4  | 
|  libwpd  |  aarch64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd  |  x86\_64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd\-devel  |  aarch64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd\-devel  |  x86\_64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd\-doc  |  noarch  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd\-tools  |  aarch64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libwpd\-tools  |  x86\_64  |  libwpd  |  0\.10\.3\-8\.amzn2023\.0\.2  | 
|  libX11  |  aarch64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11  |  x86\_64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11\-common  |  noarch  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11\-devel  |  aarch64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11\-devel  |  x86\_64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11\-xcb  |  aarch64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libX11\-xcb  |  x86\_64  |  libX11  |  1\.7\.2\-3\.amzn2023\.0\.3  | 
|  libXau  |  aarch64  |  libXau  |  1\.0\.9\-6\.amzn2023\.0\.2  | 
|  libXau  |  x86\_64  |  libXau  |  1\.0\.9\-6\.amzn2023\.0\.2  | 
|  libXau\-devel  |  aarch64  |  libXau  |  1\.0\.9\-6\.amzn2023\.0\.2  | 
|  libXau\-devel  |  x86\_64  |  libXau  |  1\.0\.9\-6\.amzn2023\.0\.2  | 
|  libXaw  |  aarch64  |  libXaw  |  1\.0\.13\-17\.amzn2023\.0\.2  | 
|  libXaw  |  x86\_64  |  libXaw  |  1\.0\.13\-17\.amzn2023\.0\.2  | 
|  libXaw\-devel  |  aarch64  |  libXaw  |  1\.0\.13\-17\.amzn2023\.0\.2  | 
|  libXaw\-devel  |  x86\_64  |  libXaw  |  1\.0\.13\-17\.amzn2023\.0\.2  | 
|  libxcb  |  aarch64  |  libxcb  |  1\.13\.1\-7\.amzn2023\.0\.2  | 
|  libxcb  |  x86\_64  |  libxcb  |  1\.13\.1\-7\.amzn2023\.0\.2  | 
|  libxcb\-devel  |  aarch64  |  libxcb  |  1\.13\.1\-7\.amzn2023\.0\.2  | 
|  libxcb\-devel  |  x86\_64  |  libxcb  |  1\.13\.1\-7\.amzn2023\.0\.2  | 
|  libxcb\-doc  |  noarch  |  libxcb  |  1\.13\.1\-7\.amzn2023\.0\.2  | 
|  libXcomposite  |  aarch64  |  libXcomposite  |  0\.4\.5\-5\.amzn2023\.0\.2  | 
|  libXcomposite  |  x86\_64  |  libXcomposite  |  0\.4\.5\-5\.amzn2023\.0\.2  | 
|  libXcomposite\-devel  |  aarch64  |  libXcomposite  |  0\.4\.5\-5\.amzn2023\.0\.2  | 
|  libXcomposite\-devel  |  x86\_64  |  libXcomposite  |  0\.4\.5\-5\.amzn2023\.0\.2  | 
|  libxcrypt  |  aarch64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt  |  x86\_64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-compat  |  aarch64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-compat  |  x86\_64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-devel  |  aarch64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-devel  |  x86\_64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-static  |  aarch64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libxcrypt\-static  |  x86\_64  |  libxcrypt  |  4\.4\.33\-7\.amzn2023  | 
|  libXcursor  |  aarch64  |  libXcursor  |  1\.2\.0\-5\.amzn2023\.0\.2  | 
|  libXcursor  |  x86\_64  |  libXcursor  |  1\.2\.0\-5\.amzn2023\.0\.2  | 
|  libXcursor\-devel  |  aarch64  |  libXcursor  |  1\.2\.0\-5\.amzn2023\.0\.2  | 
|  libXcursor\-devel  |  x86\_64  |  libXcursor  |  1\.2\.0\-5\.amzn2023\.0\.2  | 
|  libXdamage  |  aarch64  |  libXdamage  |  1\.1\.5\-5\.amzn2023\.0\.2  | 
|  libXdamage  |  x86\_64  |  libXdamage  |  1\.1\.5\-5\.amzn2023\.0\.2  | 
|  libXdamage\-devel  |  aarch64  |  libXdamage  |  1\.1\.5\-5\.amzn2023\.0\.2  | 
|  libXdamage\-devel  |  x86\_64  |  libXdamage  |  1\.1\.5\-5\.amzn2023\.0\.2  | 
|  libXdmcp  |  aarch64  |  libXdmcp  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXdmcp  |  x86\_64  |  libXdmcp  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXdmcp\-devel  |  aarch64  |  libXdmcp  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXdmcp\-devel  |  x86\_64  |  libXdmcp  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXext  |  aarch64  |  libXext  |  1\.3\.4\-6\.amzn2023\.0\.2  | 
|  libXext  |  x86\_64  |  libXext  |  1\.3\.4\-6\.amzn2023\.0\.2  | 
|  libXext\-devel  |  aarch64  |  libXext  |  1\.3\.4\-6\.amzn2023\.0\.2  | 
|  libXext\-devel  |  x86\_64  |  libXext  |  1\.3\.4\-6\.amzn2023\.0\.2  | 
|  libXfixes  |  aarch64  |  libXfixes  |  6\.0\.0\-1\.amzn2023\.0\.2  | 
|  libXfixes  |  x86\_64  |  libXfixes  |  6\.0\.0\-1\.amzn2023\.0\.2  | 
|  libXfixes\-devel  |  aarch64  |  libXfixes  |  6\.0\.0\-1\.amzn2023\.0\.2  | 
|  libXfixes\-devel  |  x86\_64  |  libXfixes  |  6\.0\.0\-1\.amzn2023\.0\.2  | 
|  libXfont2  |  aarch64  |  libXfont2  |  2\.0\.3\-10\.amzn2023\.0\.2  | 
|  libXfont2  |  x86\_64  |  libXfont2  |  2\.0\.3\-10\.amzn2023\.0\.2  | 
|  libXfont2\-devel  |  aarch64  |  libXfont2  |  2\.0\.3\-10\.amzn2023\.0\.2  | 
|  libXfont2\-devel  |  x86\_64  |  libXfont2  |  2\.0\.3\-10\.amzn2023\.0\.2  | 
|  libXft  |  aarch64  |  libXft  |  2\.3\.3\-6\.amzn2023\.0\.2  | 
|  libXft  |  x86\_64  |  libXft  |  2\.3\.3\-6\.amzn2023\.0\.2  | 
|  libXft\-devel  |  aarch64  |  libXft  |  2\.3\.3\-6\.amzn2023\.0\.2  | 
|  libXft\-devel  |  x86\_64  |  libXft  |  2\.3\.3\-6\.amzn2023\.0\.2  | 
|  libXi  |  aarch64  |  libXi  |  1\.7\.10\-6\.amzn2023\.0\.2  | 
|  libXi  |  x86\_64  |  libXi  |  1\.7\.10\-6\.amzn2023\.0\.2  | 
|  libXi\-devel  |  aarch64  |  libXi  |  1\.7\.10\-6\.amzn2023\.0\.2  | 
|  libXi\-devel  |  x86\_64  |  libXi  |  1\.7\.10\-6\.amzn2023\.0\.2  | 
|  libXinerama  |  aarch64  |  libXinerama  |  1\.1\.4\-8\.amzn2023\.0\.2  | 
|  libXinerama  |  x86\_64  |  libXinerama  |  1\.1\.4\-8\.amzn2023\.0\.2  | 
|  libXinerama\-devel  |  aarch64  |  libXinerama  |  1\.1\.4\-8\.amzn2023\.0\.2  | 
|  libXinerama\-devel  |  x86\_64  |  libXinerama  |  1\.1\.4\-8\.amzn2023\.0\.2  | 
|  libxkbcommon  |  aarch64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon  |  x86\_64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-devel  |  aarch64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-devel  |  x86\_64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-utils  |  aarch64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-utils  |  x86\_64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-x11  |  aarch64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-x11  |  x86\_64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-x11\-devel  |  aarch64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbcommon\-x11\-devel  |  x86\_64  |  libxkbcommon  |  1\.3\.0\-1\.amzn2023\.0\.2  | 
|  libxkbfile  |  aarch64  |  libxkbfile  |  1\.1\.0\-6\.amzn2023\.0\.2  | 
|  libxkbfile  |  x86\_64  |  libxkbfile  |  1\.1\.0\-6\.amzn2023\.0\.2  | 
|  libxkbfile\-devel  |  aarch64  |  libxkbfile  |  1\.1\.0\-6\.amzn2023\.0\.2  | 
|  libxkbfile\-devel  |  x86\_64  |  libxkbfile  |  1\.1\.0\-6\.amzn2023\.0\.2  | 
|  libxml2  |  aarch64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libxml2  |  x86\_64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libxml2\-devel  |  aarch64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libxml2\-devel  |  x86\_64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libxml2\-static  |  aarch64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libxml2\-static  |  x86\_64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  python3\-libxml2  |  aarch64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  python3\-libxml2  |  x86\_64  |  libxml2  |  2\.10\.4\-1\.amzn2023\.0\.1  | 
|  libXmu  |  aarch64  |  libXmu  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXmu  |  x86\_64  |  libXmu  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXmu\-devel  |  aarch64  |  libXmu  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXmu\-devel  |  x86\_64  |  libXmu  |  1\.1\.3\-6\.amzn2023\.0\.2  | 
|  libXpm  |  aarch64  |  libXpm  |  3\.5\.15\-2\.amzn2023\.0\.1  | 
|  libXpm  |  x86\_64  |  libXpm  |  3\.5\.15\-2\.amzn2023\.0\.1  | 
|  libXpm\-devel  |  aarch64  |  libXpm  |  3\.5\.15\-2\.amzn2023\.0\.1  | 
|  libXpm\-devel  |  x86\_64  |  libXpm  |  3\.5\.15\-2\.amzn2023\.0\.1  | 
|  libXrandr  |  aarch64  |  libXrandr  |  1\.5\.2\-6\.amzn2023\.0\.2  | 
|  libXrandr  |  x86\_64  |  libXrandr  |  1\.5\.2\-6\.amzn2023\.0\.2  | 
|  libXrandr\-devel  |  aarch64  |  libXrandr  |  1\.5\.2\-6\.amzn2023\.0\.2  | 
|  libXrandr\-devel  |  x86\_64  |  libXrandr  |  1\.5\.2\-6\.amzn2023\.0\.2  | 
|  libXrender  |  aarch64  |  libXrender  |  0\.9\.10\-14\.amzn2023\.0\.2  | 
|  libXrender  |  x86\_64  |  libXrender  |  0\.9\.10\-14\.amzn2023\.0\.2  | 
|  libXrender\-devel  |  aarch64  |  libXrender  |  0\.9\.10\-14\.amzn2023\.0\.2  | 
|  libXrender\-devel  |  x86\_64  |  libXrender  |  0\.9\.10\-14\.amzn2023\.0\.2  | 
|  libXres  |  aarch64  |  libXres  |  1\.2\.0\-12\.amzn2023\.0\.2  | 
|  libXres  |  x86\_64  |  libXres  |  1\.2\.0\-12\.amzn2023\.0\.2  | 
|  libXres\-devel  |  aarch64  |  libXres  |  1\.2\.0\-12\.amzn2023\.0\.2  | 
|  libXres\-devel  |  x86\_64  |  libXres  |  1\.2\.0\-12\.amzn2023\.0\.2  | 
|  libXScrnSaver  |  aarch64  |  libXScrnSaver  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libXScrnSaver  |  x86\_64  |  libXScrnSaver  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libXScrnSaver\-devel  |  aarch64  |  libXScrnSaver  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libXScrnSaver\-devel  |  x86\_64  |  libXScrnSaver  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  libxshmfence  |  aarch64  |  libxshmfence  |  1\.3\-8\.amzn2023\.0\.2  | 
|  libxshmfence  |  x86\_64  |  libxshmfence  |  1\.3\-8\.amzn2023\.0\.2  | 
|  libxshmfence\-devel  |  aarch64  |  libxshmfence  |  1\.3\-8\.amzn2023\.0\.2  | 
|  libxshmfence\-devel  |  x86\_64  |  libxshmfence  |  1\.3\-8\.amzn2023\.0\.2  | 
|  libxslt  |  aarch64  |  libxslt  |  1\.1\.34\-5\.amzn2023\.0\.2  | 
|  libxslt  |  x86\_64  |  libxslt  |  1\.1\.34\-5\.amzn2023\.0\.2  | 
|  libxslt\-devel  |  aarch64  |  libxslt  |  1\.1\.34\-5\.amzn2023\.0\.2  | 
|  libxslt\-devel  |  x86\_64  |  libxslt  |  1\.1\.34\-5\.amzn2023\.0\.2  | 
|  libXt  |  aarch64  |  libXt  |  1\.2\.0\-4\.amzn2023\.0\.2  | 
|  libXt  |  x86\_64  |  libXt  |  1\.2\.0\-4\.amzn2023\.0\.2  | 
|  libXt\-devel  |  aarch64  |  libXt  |  1\.2\.0\-4\.amzn2023\.0\.2  | 
|  libXt\-devel  |  x86\_64  |  libXt  |  1\.2\.0\-4\.amzn2023\.0\.2  | 
|  libXtst  |  aarch64  |  libXtst  |  1\.2\.3\-14\.amzn2023\.0\.2  | 
|  libXtst  |  x86\_64  |  libXtst  |  1\.2\.3\-14\.amzn2023\.0\.2  | 
|  libXtst\-devel  |  aarch64  |  libXtst  |  1\.2\.3\-14\.amzn2023\.0\.2  | 
|  libXtst\-devel  |  x86\_64  |  libXtst  |  1\.2\.3\-14\.amzn2023\.0\.2  | 
|  libXv  |  aarch64  |  libXv  |  1\.0\.11\-14\.amzn2023\.0\.2  | 
|  libXv  |  x86\_64  |  libXv  |  1\.0\.11\-14\.amzn2023\.0\.2  | 
|  libXv\-devel  |  aarch64  |  libXv  |  1\.0\.11\-14\.amzn2023\.0\.2  | 
|  libXv\-devel  |  x86\_64  |  libXv  |  1\.0\.11\-14\.amzn2023\.0\.2  | 
|  libXxf86dga  |  aarch64  |  libXxf86dga  |  1\.1\.5\-6\.amzn2023\.0\.2  | 
|  libXxf86dga  |  x86\_64  |  libXxf86dga  |  1\.1\.5\-6\.amzn2023\.0\.2  | 
|  libXxf86dga\-devel  |  aarch64  |  libXxf86dga  |  1\.1\.5\-6\.amzn2023\.0\.2  | 
|  libXxf86dga\-devel  |  x86\_64  |  libXxf86dga  |  1\.1\.5\-6\.amzn2023\.0\.2  | 
|  libXxf86vm  |  aarch64  |  libXxf86vm  |  1\.1\.4\-16\.amzn2023\.0\.2  | 
|  libXxf86vm  |  x86\_64  |  libXxf86vm  |  1\.1\.4\-16\.amzn2023\.0\.2  | 
|  libXxf86vm\-devel  |  aarch64  |  libXxf86vm  |  1\.1\.4\-16\.amzn2023\.0\.2  | 
|  libXxf86vm\-devel  |  x86\_64  |  libXxf86vm  |  1\.1\.4\-16\.amzn2023\.0\.2  | 
|  libyaml  |  aarch64  |  libyaml  |  0\.2\.5\-5\.amzn2023\.0\.2  | 
|  libyaml  |  x86\_64  |  libyaml  |  0\.2\.5\-5\.amzn2023\.0\.2  | 
|  libyaml\-devel  |  aarch64  |  libyaml  |  0\.2\.5\-5\.amzn2023\.0\.2  | 
|  libyaml\-devel  |  x86\_64  |  libyaml  |  0\.2\.5\-5\.amzn2023\.0\.2  | 
|  libzip  |  aarch64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  libzip  |  x86\_64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  libzip\-devel  |  aarch64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  libzip\-devel  |  x86\_64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  libzip\-tools  |  aarch64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  libzip\-tools  |  x86\_64  |  libzip  |  1\.7\.3\-4\.amzn2023\.0\.3  | 
|  linuxdoc\-tools  |  aarch64  |  linuxdoc\-tools  |  0\.9\.72\-11\.amzn2023\.0\.3  | 
|  linuxdoc\-tools  |  x86\_64  |  linuxdoc\-tools  |  0\.9\.72\-11\.amzn2023\.0\.3  | 
|  iwl1000\-firmware  |  noarch  |  linux\-firmware  |  39\.31\.5\.1\-117\.amzn2023\.0\.3  | 
|  iwl100\-firmware  |  noarch  |  linux\-firmware  |  39\.31\.5\.1\-117\.amzn2023\.0\.3  | 
|  iwl105\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl135\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl2000\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl2030\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl3160\-firmware  |  noarch  |  linux\-firmware  |  25\.30\.13\.0\-117\.amzn2023\.0\.3  | 
|  iwl3945\-firmware  |  noarch  |  linux\-firmware  |  15\.32\.2\.9\-117\.amzn2023\.0\.3  | 
|  iwl4965\-firmware  |  noarch  |  linux\-firmware  |  228\.61\.2\.24\-117\.amzn2023\.0\.3  | 
|  iwl5000\-firmware  |  noarch  |  linux\-firmware  |  8\.83\.5\.1\_1\-117\.amzn2023\.0\.3  | 
|  iwl5150\-firmware  |  noarch  |  linux\-firmware  |  8\.24\.2\.2\-117\.amzn2023\.0\.3  | 
|  iwl6000\-firmware  |  noarch  |  linux\-firmware  |  9\.221\.4\.1\-117\.amzn2023\.0\.3  | 
|  iwl6000g2a\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl6000g2b\-firmware  |  noarch  |  linux\-firmware  |  18\.168\.6\.1\-117\.amzn2023\.0\.3  | 
|  iwl6050\-firmware  |  noarch  |  linux\-firmware  |  41\.28\.5\.1\-117\.amzn2023\.0\.3  | 
|  iwl7260\-firmware  |  noarch  |  linux\-firmware  |  25\.30\.13\.0\-117\.amzn2023\.0\.3  | 
|  libertas\-sd8686\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  libertas\-sd8787\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  libertas\-usb8388\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  libertas\-usb8388\-olpc\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  linux\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  linux\-firmware\-whence  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  liquidio\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  netronome\-firmware  |  noarch  |  linux\-firmware  |  20210208\-117\.amzn2023\.0\.3  | 
|  lklug\-fonts  |  noarch  |  lklug\-fonts  |  0\.6\-24\.20090803cvs\.amzn2023\.0\.3  | 
|  lksctp\-tools  |  aarch64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lksctp\-tools  |  x86\_64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lksctp\-tools\-devel  |  aarch64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lksctp\-tools\-devel  |  x86\_64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lksctp\-tools\-doc  |  aarch64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lksctp\-tools\-doc  |  x86\_64  |  lksctp\-tools  |  1\.0\.18\-9\.amzn2023\.0\.3  | 
|  lld  |  aarch64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lld  |  x86\_64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lld\-devel  |  aarch64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lld\-devel  |  x86\_64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lld\-libs  |  aarch64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lld\-libs  |  x86\_64  |  lld  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lldb  |  aarch64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lldb  |  x86\_64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lldb\-devel  |  aarch64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  lldb\-devel  |  x86\_64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  python3\-lldb  |  aarch64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  python3\-lldb  |  x86\_64  |  lldb  |  15\.0\.6\-1\.amzn2023\.0\.3  | 
|  llvm  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-devel  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-devel  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-doc  |  noarch  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-googletest  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-googletest  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-libs  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-libs  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-static  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-static  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-test  |  aarch64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  llvm\-test  |  x86\_64  |  llvm  |  15\.0\.6\-2\.amzn2023\.0\.2  | 
|  lm\_sensors  |  aarch64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors  |  x86\_64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-devel  |  aarch64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-devel  |  x86\_64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-libs  |  aarch64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-libs  |  x86\_64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-sensord  |  aarch64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lm\_sensors\-sensord  |  x86\_64  |  lm\_sensors  |  3\.6\.0\-8\.amzn2023\.0\.3  | 
|  lmdb  |  aarch64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb  |  x86\_64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb\-devel  |  aarch64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb\-devel  |  x86\_64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb\-doc  |  noarch  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb\-libs  |  aarch64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  lmdb\-libs  |  x86\_64  |  lmdb  |  0\.9\.29\-1\.amzn2023\.0\.3  | 
|  Lmod  |  aarch64  |  Lmod  |  8\.4\.23\-1\.amzn2023\.0\.3  | 
|  Lmod  |  x86\_64  |  Lmod  |  8\.4\.23\-1\.amzn2023\.0\.3  | 
|  lockdev  |  aarch64  |  lockdev  |  1\.0\.4\-0\.35\.20111007git\.amzn2023\.0\.3  | 
|  lockdev  |  x86\_64  |  lockdev  |  1\.0\.4\-0\.35\.20111007git\.amzn2023\.0\.3  | 
|  lockdev\-devel  |  aarch64  |  lockdev  |  1\.0\.4\-0\.35\.20111007git\.amzn2023\.0\.3  | 
|  lockdev\-devel  |  x86\_64  |  lockdev  |  1\.0\.4\-0\.35\.20111007git\.amzn2023\.0\.3  | 
|  lockfile\-progs  |  aarch64  |  lockfile\-progs  |  0\.1\.17\-16\.amzn2023\.0\.1  | 
|  lockfile\-progs  |  x86\_64  |  lockfile\-progs  |  0\.1\.17\-16\.amzn2023\.0\.1  | 
|  log4j  |  noarch  |  log4j  |  2\.17\.2\-1\.amzn2023\.0\.4  | 
|  log4j\-jcl  |  noarch  |  log4j  |  2\.17\.2\-1\.amzn2023\.0\.4  | 
|  log4j\-slf4j  |  noarch  |  log4j  |  2\.17\.2\-1\.amzn2023\.0\.4  | 
|  logrotate  |  aarch64  |  logrotate  |  3\.20\.1\-2\.amzn2023\.0\.3  | 
|  logrotate  |  x86\_64  |  logrotate  |  3\.20\.1\-2\.amzn2023\.0\.3  | 
|  lohit\-assamese\-fonts  |  noarch  |  lohit\-assamese\-fonts  |  2\.91\.5\-11\.amzn2023\.0\.3  | 
|  lohit\-bengali\-fonts  |  noarch  |  lohit\-bengali\-fonts  |  2\.91\.5\-11\.amzn2023\.0\.3  | 
|  lohit\-devanagari\-fonts  |  noarch  |  lohit\-devanagari\-fonts  |  2\.95\.4\-12\.amzn2023\.0\.3  | 
|  lohit\-gujarati\-fonts  |  noarch  |  lohit\-gujarati\-fonts  |  2\.92\.4\-11\.amzn2023\.0\.3  | 
|  lohit\-kannada\-fonts  |  noarch  |  lohit\-kannada\-fonts  |  2\.5\.4\-10\.amzn2023\.0\.3  | 
|  lohit\-marathi\-fonts  |  noarch  |  lohit\-marathi\-fonts  |  2\.94\.2\-12\.amzn2023\.0\.3  | 
|  lohit\-odia\-fonts  |  noarch  |  lohit\-odia\-fonts  |  2\.91\.2\-11\.amzn2023\.0\.3  | 
|  lohit\-tamil\-fonts  |  noarch  |  lohit\-tamil\-fonts  |  2\.91\.3\-11\.amzn2023\.0\.3  | 
|  lohit\-telugu\-fonts  |  noarch  |  lohit\-telugu\-fonts  |  2\.5\.5\-10\.amzn2023\.0\.3  | 
|  low\-memory\-monitor  |  aarch64  |  low\-memory\-monitor  |  2\.1\-2\.amzn2023\.0\.3  | 
|  low\-memory\-monitor  |  x86\_64  |  low\-memory\-monitor  |  2\.1\-2\.amzn2023\.0\.3  | 
|  low\-memory\-monitor\-doc  |  noarch  |  low\-memory\-monitor  |  2\.1\-2\.amzn2023\.0\.3  | 
|  lshw  |  aarch64  |  lshw  |  B\.02\.19\.2\-7\.amzn2023\.0\.3  | 
|  lshw  |  x86\_64  |  lshw  |  B\.02\.19\.2\-7\.amzn2023\.0\.3  | 
|  lsof  |  aarch64  |  lsof  |  4\.94\.0\-1\.amzn2023\.0\.2  | 
|  lsof  |  x86\_64  |  lsof  |  4\.94\.0\-1\.amzn2023\.0\.2  | 
|  ltrace  |  aarch64  |  ltrace  |  0\.7\.91\-44\.amzn2023\.0\.2  | 
|  ltrace  |  x86\_64  |  ltrace  |  0\.7\.91\-44\.amzn2023\.0\.2  | 
|  lttng\-ust  |  aarch64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  lttng\-ust  |  x86\_64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  lttng\-ust\-devel  |  aarch64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  lttng\-ust\-devel  |  x86\_64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  python3\-lttngust  |  aarch64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  python3\-lttngust  |  x86\_64  |  lttng\-ust  |  2\.13\.1\-2\.amzn2023\.0\.1  | 
|  lua  |  aarch64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua  |  x86\_64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-devel  |  aarch64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-devel  |  x86\_64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-libs  |  aarch64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-libs  |  x86\_64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-static  |  aarch64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-static  |  x86\_64  |  lua  |  5\.4\.4\-3\.amzn2023\.0\.2  | 
|  lua\-filesystem  |  aarch64  |  lua\-filesystem  |  1\.8\.0\-4\.amzn2023\.0\.3  | 
|  lua\-filesystem  |  x86\_64  |  lua\-filesystem  |  1\.8\.0\-4\.amzn2023\.0\.3  | 
|  luajit  |  aarch64  |  luajit  |  2\.1\.0\-0\.19beta3\.amzn2023\.0\.2  | 
|  luajit  |  x86\_64  |  luajit  |  2\.1\.0\-0\.19beta3\.amzn2023\.0\.2  | 
|  luajit\-devel  |  aarch64  |  luajit  |  2\.1\.0\-0\.19beta3\.amzn2023\.0\.2  | 
|  luajit\-devel  |  x86\_64  |  luajit  |  2\.1\.0\-0\.19beta3\.amzn2023\.0\.2  | 
|  lua\-json  |  noarch  |  lua\-json  |  1\.3\.2\-17\.amzn2023\.0\.2  | 
|  lua\-lpeg  |  aarch64  |  lua\-lpeg  |  1\.0\.2\-6\.amzn2023\.0\.3  | 
|  lua\-lpeg  |  x86\_64  |  lua\-lpeg  |  1\.0\.2\-6\.amzn2023\.0\.3  | 
|  lua\-lunitx  |  noarch  |  lua\-lunitx  |  0\.8\.1\-3\.amzn2023\.0\.2  | 
|  lua\-posix  |  aarch64  |  lua\-posix  |  35\.0\-3\.amzn2023\.0\.2  | 
|  lua\-posix  |  x86\_64  |  lua\-posix  |  35\.0\-3\.amzn2023\.0\.2  | 
|  lua\-rpm\-macros  |  noarch  |  lua\-rpm\-macros  |  1\-4\.amzn2023\.0\.2  | 
|  lua\-srpm\-macros  |  noarch  |  lua\-rpm\-macros  |  1\-4\.amzn2023\.0\.2  | 
|  lua\-term  |  aarch64  |  lua\-term  |  0\.07\-13\.amzn2023\.0\.2  | 
|  lua\-term  |  x86\_64  |  lua\-term  |  0\.07\-13\.amzn2023\.0\.2  | 
|  lutok  |  aarch64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok  |  x86\_64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok\-devel  |  aarch64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok\-devel  |  x86\_64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok\-doc  |  noarch  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok\-tests  |  aarch64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  lutok\-tests  |  x86\_64  |  lutok  |  0\.4\-17\.amzn2023\.0\.3  | 
|  device\-mapper  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-devel  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-devel  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event\-devel  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event\-devel  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event\-libs  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-event\-libs  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-libs  |  aarch64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  device\-mapper\-libs  |  x86\_64  |  lvm2  |  1\.02\.185\-1\.amzn2023\.0\.4  | 
|  lvm2  |  aarch64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2  |  x86\_64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-dbusd  |  noarch  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-devel  |  aarch64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-devel  |  x86\_64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-libs  |  aarch64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-libs  |  x86\_64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-lockd  |  aarch64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-lockd  |  x86\_64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-testsuite  |  aarch64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lvm2\-testsuite  |  x86\_64  |  lvm2  |  2\.03\.16\-1\.amzn2023\.0\.4  | 
|  lynis  |  noarch  |  lynis  |  3\.0\.8\-3\.amzn2023  | 
|  lynx  |  aarch64  |  lynx  |  2\.8\.9\-13\.amzn2023\.0\.3  | 
|  lynx  |  x86\_64  |  lynx  |  2\.8\.9\-13\.amzn2023\.0\.3  | 
|  lz4  |  aarch64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4  |  x86\_64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-devel  |  aarch64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-devel  |  x86\_64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-libs  |  aarch64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-libs  |  x86\_64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-static  |  aarch64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lz4\-static  |  x86\_64  |  lz4  |  1\.9\.4\-1\.amzn2023\.0\.2  | 
|  lzip  |  aarch64  |  lzip  |  1\.22\-2\.amzn2023\.0\.2  | 
|  lzip  |  x86\_64  |  lzip  |  1\.22\-2\.amzn2023\.0\.2  | 
|  lzo  |  aarch64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzo  |  x86\_64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzo\-devel  |  aarch64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzo\-devel  |  x86\_64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzo\-minilzo  |  aarch64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzo\-minilzo  |  x86\_64  |  lzo  |  2\.10\-4\.amzn2023\.0\.2  | 
|  lzop  |  aarch64  |  lzop  |  1\.04\-6\.amzn2023\.0\.2  | 
|  lzop  |  x86\_64  |  lzop  |  1\.04\-6\.amzn2023\.0\.2  | 
|  m17n\-db  |  noarch  |  m17n\-db  |  1\.8\.0\-21\.amzn2023\.0\.3  | 
|  m17n\-db\-devel  |  noarch  |  m17n\-db  |  1\.8\.0\-21\.amzn2023\.0\.3  | 
|  m17n\-db\-extras  |  noarch  |  m17n\-db  |  1\.8\.0\-21\.amzn2023\.0\.3  | 
|  m17n\-lib  |  aarch64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib  |  x86\_64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-anthy  |  aarch64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-anthy  |  x86\_64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-devel  |  aarch64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-devel  |  x86\_64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-tools  |  aarch64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m17n\-lib\-tools  |  x86\_64  |  m17n\-lib  |  1\.8\.0\-9\.amzn2023\.0\.3  | 
|  m4  |  aarch64  |  m4  |  1\.4\.19\-2\.amzn2023\.0\.2  | 
|  m4  |  x86\_64  |  m4  |  1\.4\.19\-2\.amzn2023\.0\.2  | 
|  mailcap  |  noarch  |  mailcap  |  2\.1\.49\-3\.amzn2023\.0\.3  | 
|  nginx\-mimetypes  |  noarch  |  mailcap  |  2\.1\.49\-3\.amzn2023\.0\.3  | 
|  mailx  |  aarch64  |  mailx  |  12\.5\-37\.amzn2023\.0\.4  | 
|  mailx  |  x86\_64  |  mailx  |  12\.5\-37\.amzn2023\.0\.4  | 
|  make  |  aarch64  |  make  |  4\.3\-5\.amzn2023\.0\.2  | 
|  make  |  x86\_64  |  make  |  4\.3\-5\.amzn2023\.0\.2  | 
|  make\-devel  |  aarch64  |  make  |  4\.3\-5\.amzn2023\.0\.2  | 
|  make\-devel  |  x86\_64  |  make  |  4\.3\-5\.amzn2023\.0\.2  | 
|  mallard\-rng  |  noarch  |  mallard\-rng  |  1\.1\.0\-5\.amzn2023\.0\.3  | 
|  man\-db  |  aarch64  |  man\-db  |  2\.9\.3\-3\.amzn2023\.0\.3  | 
|  man\-db  |  x86\_64  |  man\-db  |  2\.9\.3\-3\.amzn2023\.0\.3  | 
|  man\-db\-cron  |  noarch  |  man\-db  |  2\.9\.3\-3\.amzn2023\.0\.3  | 
|  libmandoc\-devel  |  aarch64  |  mandoc  |  1\.14\.5\-14\.amzn2023\.0\.3  | 
|  libmandoc\-devel  |  x86\_64  |  mandoc  |  1\.14\.5\-14\.amzn2023\.0\.3  | 
|  mandoc  |  aarch64  |  mandoc  |  1\.14\.5\-14\.amzn2023\.0\.3  | 
|  mandoc  |  x86\_64  |  mandoc  |  1\.14\.5\-14\.amzn2023\.0\.3  | 
|  man\-pages  |  noarch  |  man\-pages  |  5\.10\-2\.amzn2023\.0\.3  | 
|  mariadb105  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-backup  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-backup  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-common  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-common  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-connect\-engine  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-connect\-engine  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-cracklib\-password\-check  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-cracklib\-password\-check  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-devel  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-devel  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-errmsg  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-errmsg  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-gssapi\-server  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-gssapi\-server  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-oqgraph\-engine  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-oqgraph\-engine  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-pam  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-pam  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-rocksdb\-engine  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-server  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-server  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-server\-utils  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-server\-utils  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-sphinx\-engine  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-sphinx\-engine  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-test  |  aarch64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb105\-test  |  x86\_64  |  mariadb105  |  10\.5\.18\-1\.amzn2023\.0\.1  | 
|  mariadb\-connector\-c  |  aarch64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c  |  x86\_64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c\-config  |  noarch  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c\-devel  |  aarch64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c\-devel  |  x86\_64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c\-test  |  aarch64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  mariadb\-connector\-c\-test  |  x86\_64  |  mariadb\-connector\-c  |  3\.1\.13\-1\.amzn2023\.0\.3  | 
|  marshalparser  |  noarch  |  marshalparser  |  0\.3\.0\-1\.amzn2023\.1\.4  | 
|  maven  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven\-amazon\-corretto11  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven\-amazon\-corretto17  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven\-amazon\-corretto8  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven\-javadoc  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven\-lib  |  noarch  |  maven  |  3\.8\.4\-3\.amzn2023\.0\.4  | 
|  maven2\-javadoc  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-artifact  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-artifact\-manager  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-model  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-monitor  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-plugin\-descriptor  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-plugin\-registry  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-profile  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-project  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-settings  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-toolchain  |  noarch  |  maven2  |  2\.2\.1\-70\.amzn2023\.0\.1  | 
|  maven\-antrun\-plugin  |  noarch  |  maven\-antrun\-plugin  |  3\.0\.0\-5\.amzn2023\.0\.3  | 
|  maven\-antrun\-plugin\-javadoc  |  noarch  |  maven\-antrun\-plugin  |  3\.0\.0\-5\.amzn2023\.0\.3  | 
|  maven\-archiver  |  noarch  |  maven\-archiver  |  3\.5\.1\-1\.amzn2023\.0\.2  | 
|  maven\-archiver\-javadoc  |  noarch  |  maven\-archiver  |  3\.5\.1\-1\.amzn2023\.0\.2  | 
|  maven\-artifact\-transfer  |  noarch  |  maven\-artifact\-transfer  |  0\.13\.1\-6\.amzn2023\.0\.3  | 
|  maven\-artifact\-transfer\-javadoc  |  noarch  |  maven\-artifact\-transfer  |  0\.13\.1\-6\.amzn2023\.0\.3  | 
|  maven\-assembly\-plugin  |  noarch  |  maven\-assembly\-plugin  |  3\.3\.0\-8\.amzn2023\.0\.3  | 
|  maven\-assembly\-plugin\-javadoc  |  noarch  |  maven\-assembly\-plugin  |  3\.3\.0\-8\.amzn2023\.0\.3  | 
|  maven\-clean\-plugin  |  noarch  |  maven\-clean\-plugin  |  3\.1\.0\-10\.amzn2023\.0\.1  | 
|  maven\-clean\-plugin\-javadoc  |  noarch  |  maven\-clean\-plugin  |  3\.1\.0\-10\.amzn2023\.0\.1  | 
|  maven\-common\-artifact\-filters  |  noarch  |  maven\-common\-artifact\-filters  |  3\.2\.0\-3\.amzn2023\.0\.3  | 
|  maven\-common\-artifact\-filters\-javadoc  |  noarch  |  maven\-common\-artifact\-filters  |  3\.2\.0\-3\.amzn2023\.0\.3  | 
|  maven\-compiler\-plugin  |  noarch  |  maven\-compiler\-plugin  |  3\.8\.1\-12\.amzn2023\.0\.3  | 
|  maven\-compiler\-plugin\-javadoc  |  noarch  |  maven\-compiler\-plugin  |  3\.8\.1\-12\.amzn2023\.0\.3  | 
|  maven\-dependency\-analyzer  |  noarch  |  maven\-dependency\-analyzer  |  1\.11\.3\-6\.amzn2023\.0\.3  | 
|  maven\-dependency\-analyzer\-javadoc  |  noarch  |  maven\-dependency\-analyzer  |  1\.11\.3\-6\.amzn2023\.0\.3  | 
|  maven\-dependency\-plugin  |  noarch  |  maven\-dependency\-plugin  |  3\.1\.2\-9\.amzn2023\.0\.3  | 
|  maven\-dependency\-plugin\-javadoc  |  noarch  |  maven\-dependency\-plugin  |  3\.1\.2\-9\.amzn2023\.0\.3  | 
|  maven\-dependency\-tree  |  noarch  |  maven\-dependency\-tree  |  3\.0\.1\-10\.amzn2023\.0\.3  | 
|  maven\-dependency\-tree\-javadoc  |  noarch  |  maven\-dependency\-tree  |  3\.0\.1\-10\.amzn2023\.0\.3  | 
|  maven\-doxia  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-core  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-javadoc  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-logging\-api  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-apt  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-confluence  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-docbook\-simple  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-fml  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-latex  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-rtf  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-modules  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-twiki  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-xdoc  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-xhtml  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-module\-xhtml5  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-sink\-api  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-test\-docs  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-tests  |  noarch  |  maven\-doxia  |  1\.9\.1\-7\.amzn2023\.0\.2  | 
|  maven\-doxia\-sitetools  |  noarch  |  maven\-doxia\-sitetools  |  1\.9\.2\-7\.amzn2023\.0\.1  | 
|  maven\-doxia\-sitetools\-javadoc  |  noarch  |  maven\-doxia\-sitetools  |  1\.9\.2\-7\.amzn2023\.0\.1  | 
|  maven\-enforcer  |  noarch  |  maven\-enforcer  |  3\.0\.0\~M3\-8\.amzn2023\.0\.3  | 
|  maven\-enforcer\-api  |  noarch  |  maven\-enforcer  |  3\.0\.0\~M3\-8\.amzn2023\.0\.3  | 
|  maven\-enforcer\-javadoc  |  noarch  |  maven\-enforcer  |  3\.0\.0\~M3\-8\.amzn2023\.0\.3  | 
|  maven\-enforcer\-plugin  |  noarch  |  maven\-enforcer  |  3\.0\.0\~M3\-8\.amzn2023\.0\.3  | 
|  maven\-enforcer\-rules  |  noarch  |  maven\-enforcer  |  3\.0\.0\~M3\-8\.amzn2023\.0\.3  | 
|  maven\-file\-management  |  noarch  |  maven\-file\-management  |  3\.0\.0\-17\.amzn2023\.0\.3  | 
|  maven\-file\-management\-javadoc  |  noarch  |  maven\-file\-management  |  3\.0\.0\-17\.amzn2023\.0\.3  | 
|  maven\-filtering  |  noarch  |  maven\-filtering  |  3\.2\.0\-5\.amzn2023\.0\.3  | 
|  maven\-filtering\-javadoc  |  noarch  |  maven\-filtering  |  3\.2\.0\-5\.amzn2023\.0\.3  | 
|  maven\-invoker  |  noarch  |  maven\-invoker  |  3\.1\.0\-3\.amzn2023\.0\.1  | 
|  maven\-invoker\-javadoc  |  noarch  |  maven\-invoker  |  3\.1\.0\-3\.amzn2023\.0\.1  | 
|  maven\-invoker\-plugin  |  noarch  |  maven\-invoker\-plugin  |  3\.2\.1\-8\.amzn2023\.0\.1  | 
|  maven\-invoker\-plugin\-javadoc  |  noarch  |  maven\-invoker\-plugin  |  3\.2\.1\-8\.amzn2023\.0\.1  | 
|  maven\-jar\-plugin  |  noarch  |  maven\-jar\-plugin  |  3\.2\.0\-9\.amzn2023\.0\.3  | 
|  maven\-jar\-plugin\-javadoc  |  noarch  |  maven\-jar\-plugin  |  3\.2\.0\-9\.amzn2023\.0\.3  | 
|  maven\-mapping  |  noarch  |  maven\-mapping  |  3\.0\.0\-16\.amzn2023\.0\.1  | 
|  maven\-mapping\-javadoc  |  noarch  |  maven\-mapping  |  3\.0\.0\-16\.amzn2023\.0\.1  | 
|  maven\-parent  |  noarch  |  maven\-parent  |  34\-10\.amzn2023\.0\.3  | 
|  maven\-plugin\-build\-helper  |  noarch  |  maven\-plugin\-build\-helper  |  3\.2\.0\-7\.amzn2023\.0\.3  | 
|  maven\-plugin\-build\-helper\-javadoc  |  noarch  |  maven\-plugin\-build\-helper  |  3\.2\.0\-7\.amzn2023\.0\.3  | 
|  maven\-plugin\-bundle  |  noarch  |  maven\-plugin\-bundle  |  5\.1\.1\-5\.amzn2023\.0\.3  | 
|  maven\-plugin\-bundle\-javadoc  |  noarch  |  maven\-plugin\-bundle  |  5\.1\.1\-5\.amzn2023\.0\.3  | 
|  maven\-plugin\-testing  |  noarch  |  maven\-plugin\-testing  |  3\.3\.0\-25\.amzn2023\.0\.3  | 
|  maven\-plugin\-testing\-harness  |  noarch  |  maven\-plugin\-testing  |  3\.3\.0\-25\.amzn2023\.0\.3  | 
|  maven\-plugin\-testing\-javadoc  |  noarch  |  maven\-plugin\-testing  |  3\.3\.0\-25\.amzn2023\.0\.3  | 
|  maven\-plugin\-annotations  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-plugin  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools\-annotations  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools\-api  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools\-generators  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools\-java  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-plugin\-tools\-javadocs  |  noarch  |  maven\-plugin\-tools  |  3\.6\.0\-12\.amzn2023\.0\.4  | 
|  maven\-remote\-resources\-plugin  |  noarch  |  maven\-remote\-resources\-plugin  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  maven\-remote\-resources\-plugin\-javadoc  |  noarch  |  maven\-remote\-resources\-plugin  |  1\.7\.0\-9\.amzn2023\.0\.3  | 
|  maven\-reporting\-api  |  noarch  |  maven\-reporting\-api  |  3\.1\.0\-1\.amzn2023\.0\.1  | 
|  maven\-reporting\-api\-javadoc  |  noarch  |  maven\-reporting\-api  |  3\.1\.0\-1\.amzn2023\.0\.1  | 
|  maven\-reporting\-impl  |  noarch  |  maven\-reporting\-impl  |  3\.1\.0\-1\.amzn2023\.0\.1  | 
|  maven\-reporting\-impl\-javadoc  |  noarch  |  maven\-reporting\-impl  |  3\.1\.0\-1\.amzn2023\.0\.1  | 
|  maven\-resolver  |  noarch  |  maven\-resolver  |  1\.7\.3\-3\.amzn2023\.0\.4  | 
|  maven\-resolver\-javadoc  |  noarch  |  maven\-resolver  |  1\.7\.3\-3\.amzn2023\.0\.4  | 
|  maven\-resources\-plugin  |  noarch  |  maven\-resources\-plugin  |  3\.2\.0\-6\.amzn2023\.0\.3  | 
|  maven\-resources\-plugin\-javadoc  |  noarch  |  maven\-resources\-plugin  |  3\.2\.0\-6\.amzn2023\.0\.3  | 
|  maven\-script\-interpreter  |  noarch  |  maven\-script\-interpreter  |  1\.2\-11\.amzn2023\.0\.1  | 
|  maven\-script\-interpreter\-javadoc  |  noarch  |  maven\-script\-interpreter  |  1\.2\-11\.amzn2023\.0\.1  | 
|  maven\-shade\-plugin  |  noarch  |  maven\-shade\-plugin  |  3\.2\.4\-7\.amzn2023\.0\.1  | 
|  maven\-shade\-plugin\-javadoc  |  noarch  |  maven\-shade\-plugin  |  3\.2\.4\-7\.amzn2023\.0\.1  | 
|  maven\-shared\-incremental  |  noarch  |  maven\-shared\-incremental  |  1\.1\-25\.amzn2023\.0\.3  | 
|  maven\-shared\-incremental\-javadoc  |  noarch  |  maven\-shared\-incremental  |  1\.1\-25\.amzn2023\.0\.3  | 
|  maven\-shared\-io  |  noarch  |  maven\-shared\-io  |  3\.0\.0\-17\.amzn2023\.0\.3  | 
|  maven\-shared\-io\-javadoc  |  noarch  |  maven\-shared\-io  |  3\.0\.0\-17\.amzn2023\.0\.3  | 
|  maven\-shared\-utils  |  noarch  |  maven\-shared\-utils  |  3\.3\.4\-4\.amzn2023\.0\.3  | 
|  maven\-shared\-utils\-javadoc  |  noarch  |  maven\-shared\-utils  |  3\.3\.4\-4\.amzn2023\.0\.3  | 
|  maven\-source\-plugin  |  noarch  |  maven\-source\-plugin  |  3\.2\.1\-8\.amzn2023\.0\.3  | 
|  maven\-source\-plugin\-javadoc  |  noarch  |  maven\-source\-plugin  |  3\.2\.1\-8\.amzn2023\.0\.3  | 
|  maven\-failsafe\-plugin  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire\-javadoc  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire\-plugin  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire\-provider\-junit  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire\-provider\-junit5  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-surefire\-provider\-testng  |  noarch  |  maven\-surefire  |  3\.0\.0\~M4\-6\.amzn2023\.0\.4  | 
|  maven\-verifier  |  noarch  |  maven\-verifier  |  1\.7\.2\-8\.amzn2023\.0\.3  | 
|  maven\-verifier\-javadoc  |  noarch  |  maven\-verifier  |  1\.7\.2\-8\.amzn2023\.0\.3  | 
|  maven\-verifier\-plugin  |  noarch  |  maven\-verifier\-plugin  |  1\.0\-30\.amzn2023\.0\.2  | 
|  maven\-verifier\-plugin\-javadoc  |  noarch  |  maven\-verifier\-plugin  |  1\.0\-30\.amzn2023\.0\.2  | 
|  maven\-wagon  |  noarch  |  maven\-wagon  |  3\.4\.2\-6\.amzn2023\.0\.4  | 
|  maven\-wagon\-javadoc  |  noarch  |  maven\-wagon  |  3\.4\.2\-6\.amzn2023\.0\.4  | 
|  mc  |  aarch64  |  mc  |  4\.8\.28\-2\.amzn2023\.0\.3  | 
|  mc  |  x86\_64  |  mc  |  4\.8\.28\-2\.amzn2023\.0\.3  | 
|  libmcpp  |  aarch64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  libmcpp  |  x86\_64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  libmcpp\-devel  |  aarch64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  libmcpp\-devel  |  x86\_64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  mcpp  |  aarch64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  mcpp  |  x86\_64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  mcpp\-doc  |  aarch64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  mcpp\-doc  |  x86\_64  |  mcpp  |  2\.7\.2\-27\.amzn2023\.0\.2  | 
|  mcstrans  |  aarch64  |  mcstrans  |  3\.4\-3\.amzn2023\.0\.2  | 
|  mcstrans  |  x86\_64  |  mcstrans  |  3\.4\-3\.amzn2023\.0\.2  | 
|  mdadm  |  aarch64  |  mdadm  |  4\.2\-3\.amzn2023\.0\.5  | 
|  mdadm  |  x86\_64  |  mdadm  |  4\.2\-3\.amzn2023\.0\.5  | 
|  mdevctl  |  aarch64  |  mdevctl  |  1\.1\.0\-4\.amzn2023\.0\.3  | 
|  mdevctl  |  x86\_64  |  mdevctl  |  1\.1\.0\-4\.amzn2023\.0\.3  | 
|  memcached  |  aarch64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memcached  |  x86\_64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memcached\-devel  |  aarch64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memcached\-devel  |  x86\_64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memcached\-selinux  |  aarch64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memcached\-selinux  |  x86\_64  |  memcached  |  1\.6\.14\-1\.amzn2023\.0\.3  | 
|  memkind  |  aarch64  |  memkind  |  1\.13\.0\-1\.amzn2023\.0\.3  | 
|  memkind  |  x86\_64  |  memkind  |  1\.13\.0\-1\.amzn2023\.0\.3  | 
|  memkind\-devel  |  aarch64  |  memkind  |  1\.13\.0\-1\.amzn2023\.0\.3  | 
|  memkind\-devel  |  x86\_64  |  memkind  |  1\.13\.0\-1\.amzn2023\.0\.3  | 
|  memstrack  |  aarch64  |  memstrack  |  0\.2\.4\-2\.amzn2023\.0\.3  | 
|  memstrack  |  x86\_64  |  memstrack  |  0\.2\.4\-2\.amzn2023\.0\.3  | 
|  mercurial  |  aarch64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mercurial  |  x86\_64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mercurial\-chg  |  aarch64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mercurial\-chg  |  x86\_64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mercurial\-hgk  |  aarch64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mercurial\-hgk  |  x86\_64  |  mercurial  |  5\.7\.1\-1\.amzn2023\.0\.3  | 
|  mesa\-dri\-drivers  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-dri\-drivers  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-filesystem  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-filesystem  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libd3d  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libd3d  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libd3d\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libd3d\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libEGL  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libEGL  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libEGL\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libEGL\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libgbm  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libgbm  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libgbm\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libgbm\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libGL  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libGL  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libglapi  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libglapi  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libGL\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libGL\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOpenCL  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOpenCL  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOpenCL\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOpenCL\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOSMesa  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOSMesa  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOSMesa\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libOSMesa\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libxatracker  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libxatracker  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libxatracker\-devel  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libxatracker\-devel  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-omx\-drivers  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-omx\-drivers  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-va\-drivers  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-va\-drivers  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-vdpau\-drivers  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-vdpau\-drivers  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-vulkan\-drivers  |  aarch64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-vulkan\-drivers  |  x86\_64  |  mesa  |  22\.3\.3\-1140\.amzn2023\.0\.3  | 
|  mesa\-libGLU  |  aarch64  |  mesa\-libGLU  |  9\.0\.1\-4\.amzn2023\.0\.3  | 
|  mesa\-libGLU  |  x86\_64  |  mesa\-libGLU  |  9\.0\.1\-4\.amzn2023\.0\.3  | 
|  mesa\-libGLU\-devel  |  aarch64  |  mesa\-libGLU  |  9\.0\.1\-4\.amzn2023\.0\.3  | 
|  mesa\-libGLU\-devel  |  x86\_64  |  mesa\-libGLU  |  9\.0\.1\-4\.amzn2023\.0\.3  | 
|  meson  |  noarch  |  meson  |  0\.62\.2\-205\.amzn2023\.0\.2  | 
|  metis  |  aarch64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis  |  x86\_64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis64  |  aarch64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis64  |  x86\_64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis64\-devel  |  aarch64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis64\-devel  |  x86\_64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis\-devel  |  aarch64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  metis\-devel  |  x86\_64  |  metis  |  5\.1\.0\-32\.amzn2023\.0\.2  | 
|  microcode\_ctl  |  x86\_64  |  microcode\_ctl  |  2\.1\-53\.amzn2023\.0\.1  | 
|  microdnf  |  aarch64  |  microdnf  |  3\.8\.1\-1\.amzn2023\.0\.1  | 
|  microdnf  |  x86\_64  |  microdnf  |  3\.8\.1\-1\.amzn2023\.0\.1  | 
|  microdnf\-dnf  |  aarch64  |  microdnf  |  3\.8\.1\-1\.amzn2023\.0\.1  | 
|  microdnf\-dnf  |  x86\_64  |  microdnf  |  3\.8\.1\-1\.amzn2023\.0\.1  | 
|  miniz  |  aarch64  |  miniz  |  2\.1\.0\-7\.amzn2023\.0\.3  | 
|  miniz  |  x86\_64  |  miniz  |  2\.1\.0\-7\.amzn2023\.0\.3  | 
|  miniz\-devel  |  aarch64  |  miniz  |  2\.1\.0\-7\.amzn2023\.0\.3  | 
|  miniz\-devel  |  x86\_64  |  miniz  |  2\.1\.0\-7\.amzn2023\.0\.3  | 
|  mkfontscale  |  aarch64  |  mkfontscale  |  1\.2\.1\-2\.amzn2023\.0\.3  | 
|  mkfontscale  |  x86\_64  |  mkfontscale  |  1\.2\.1\-2\.amzn2023\.0\.3  | 
|  mlocate  |  aarch64  |  mlocate  |  0\.26\-351\.amzn2023  | 
|  mlocate  |  x86\_64  |  mlocate  |  0\.26\-351\.amzn2023  | 
|  mm\-common  |  noarch  |  mm\-common  |  1\.0\.3\-1\.amzn2023\.0\.3  | 
|  mm\-common\-docs  |  noarch  |  mm\-common  |  1\.0\.3\-1\.amzn2023\.0\.3  | 
|  mockito  |  noarch  |  mockito  |  3\.12\.4\-3\.amzn2023\.0\.3  | 
|  mockito\-inline  |  noarch  |  mockito  |  3\.12\.4\-3\.amzn2023\.0\.3  | 
|  mockito\-javadoc  |  noarch  |  mockito  |  3\.12\.4\-3\.amzn2023\.0\.3  | 
|  mockito\-junit\-jupiter  |  noarch  |  mockito  |  3\.12\.4\-3\.amzn2023\.0\.3  | 
|  mod\_fcgid  |  aarch64  |  mod\_fcgid  |  2\.3\.9\-24\.amzn2023\.0\.3  | 
|  mod\_fcgid  |  x86\_64  |  mod\_fcgid  |  2\.3\.9\-24\.amzn2023\.0\.3  | 
|  mod\_http2  |  aarch64  |  mod\_http2  |  2\.0\.11\-2\.amzn2023  | 
|  mod\_http2  |  x86\_64  |  mod\_http2  |  2\.0\.11\-2\.amzn2023  | 
|  mod\_perl  |  aarch64  |  mod\_perl  |  2\.0\.11\-8\.amzn2023\.0\.3  | 
|  mod\_perl  |  x86\_64  |  mod\_perl  |  2\.0\.11\-8\.amzn2023\.0\.3  | 
|  mod\_perl\-devel  |  aarch64  |  mod\_perl  |  2\.0\.11\-8\.amzn2023\.0\.3  | 
|  mod\_perl\-devel  |  x86\_64  |  mod\_perl  |  2\.0\.11\-8\.amzn2023\.0\.3  | 
|  modello  |  noarch  |  modello  |  1\.11\-8\.amzn2023\.0\.3  | 
|  modello\-javadoc  |  noarch  |  modello  |  1\.11\-8\.amzn2023\.0\.3  | 
|  mojo\-parent  |  noarch  |  mojo\-parent  |  60\-5\.amzn2023\.0\.3  | 
|  mokutil  |  aarch64  |  mokutil  |  0\.6\.0\-6\.amzn2023  | 
|  mokutil  |  x86\_64  |  mokutil  |  0\.6\.0\-6\.amzn2023  | 
|  mozilla\-filesystem  |  aarch64  |  mozilla\-filesystem  |  1\.9\-25\.amzn2023\.0\.3  | 
|  mozilla\-filesystem  |  x86\_64  |  mozilla\-filesystem  |  1\.9\-25\.amzn2023\.0\.3  | 
|  mpdecimal  |  aarch64  |  mpdecimal  |  2\.5\.1\-3\.amzn2023\.0\.3  | 
|  mpdecimal  |  x86\_64  |  mpdecimal  |  2\.5\.1\-3\.amzn2023\.0\.3  | 
|  mpdecimal\-devel  |  aarch64  |  mpdecimal  |  2\.5\.1\-3\.amzn2023\.0\.3  | 
|  mpdecimal\-devel  |  x86\_64  |  mpdecimal  |  2\.5\.1\-3\.amzn2023\.0\.3  | 
|  mpdecimal\-doc  |  noarch  |  mpdecimal  |  2\.5\.1\-3\.amzn2023\.0\.3  | 
|  mpfr  |  aarch64  |  mpfr  |  4\.1\.0\-7\.amzn2023\.0\.2  | 
|  mpfr  |  x86\_64  |  mpfr  |  4\.1\.0\-7\.amzn2023\.0\.2  | 
|  mpfr\-devel  |  aarch64  |  mpfr  |  4\.1\.0\-7\.amzn2023\.0\.2  | 
|  mpfr\-devel  |  x86\_64  |  mpfr  |  4\.1\.0\-7\.amzn2023\.0\.2  | 
|  mpfr\-doc  |  noarch  |  mpfr  |  4\.1\.0\-7\.amzn2023\.0\.2  | 
|  mpich  |  aarch64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich  |  x86\_64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich\-autoload  |  aarch64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich\-autoload  |  x86\_64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich\-devel  |  aarch64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich\-devel  |  x86\_64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mpich\-doc  |  noarch  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  python3\-mpich  |  aarch64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  python3\-mpich  |  x86\_64  |  mpich  |  3\.4\.1\-1\.amzn2023\.0\.3  | 
|  mtdev  |  aarch64  |  mtdev  |  1\.1\.5\-20\.amzn2023\.0\.3  | 
|  mtdev  |  x86\_64  |  mtdev  |  1\.1\.5\-20\.amzn2023\.0\.3  | 
|  mtdev\-devel  |  aarch64  |  mtdev  |  1\.1\.5\-20\.amzn2023\.0\.3  | 
|  mtdev\-devel  |  x86\_64  |  mtdev  |  1\.1\.5\-20\.amzn2023\.0\.3  | 
|  mtools  |  aarch64  |  mtools  |  4\.0\.35\-1\.amzn2023\.0\.3  | 
|  mtools  |  x86\_64  |  mtools  |  4\.0\.35\-1\.amzn2023\.0\.3  | 
|  mtr  |  aarch64  |  mtr  |  0\.95\-3\.amzn2023\.0\.1  | 
|  mtr  |  x86\_64  |  mtr  |  0\.95\-3\.amzn2023\.0\.1  | 
|  mtr\-gtk  |  aarch64  |  mtr  |  0\.95\-3\.amzn2023\.0\.1  | 
|  mtr\-gtk  |  x86\_64  |  mtr  |  0\.95\-3\.amzn2023\.0\.1  | 
|  multilib\-rpm\-config  |  noarch  |  multilib\-rpm\-config  |  1\-17\.amzn2023\.0\.3  | 
|  munge  |  aarch64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge  |  x86\_64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge\-devel  |  aarch64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge\-devel  |  x86\_64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge\-libs  |  aarch64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge\-libs  |  x86\_64  |  munge  |  0\.5\.14\-7\.amzn2023\.0\.4  | 
|  munge\-maven\-plugin  |  noarch  |  munge\-maven\-plugin  |  1\.0\-24\.amzn2023\.0\.3  | 
|  munge\-maven\-plugin\-javadoc  |  noarch  |  munge\-maven\-plugin  |  1\.0\-24\.amzn2023\.0\.3  | 
|  mysql\-selinux  |  noarch  |  mysql\-selinux  |  1\.0\.4\-2\.amzn2023\.0\.3  | 
|  default\-editor  |  noarch  |  nano  |  5\.8\-3\.amzn2023\.0\.3  | 
|  nano  |  aarch64  |  nano  |  5\.8\-3\.amzn2023\.0\.3  | 
|  nano  |  x86\_64  |  nano  |  5\.8\-3\.amzn2023\.0\.3  | 
|  nano\-default\-editor  |  noarch  |  nano  |  5\.8\-3\.amzn2023\.0\.3  | 
|  nasm  |  aarch64  |  nasm  |  2\.15\.05\-1\.amzn2023\.0\.4  | 
|  nasm  |  x86\_64  |  nasm  |  2\.15\.05\-1\.amzn2023\.0\.4  | 
|  nasm\-doc  |  noarch  |  nasm  |  2\.15\.05\-1\.amzn2023\.0\.4  | 
|  nasm\-rdoff  |  aarch64  |  nasm  |  2\.15\.05\-1\.amzn2023\.0\.4  | 
|  nasm\-rdoff  |  x86\_64  |  nasm  |  2\.15\.05\-1\.amzn2023\.0\.4  | 
|  ncompress  |  aarch64  |  ncompress  |  4\.2\.4\.4\-19\.amzn2023\.0\.3  | 
|  ncompress  |  x86\_64  |  ncompress  |  4\.2\.4\.4\-19\.amzn2023\.0\.3  | 
|  ncurses  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-base  |  noarch  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-c\+\+\-libs  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-c\+\+\-libs  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-compat\-libs  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-compat\-libs  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-devel  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-devel  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-libs  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-libs  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-static  |  aarch64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-static  |  x86\_64  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  ncurses\-term  |  noarch  |  ncurses  |  6\.2\-4\.20200222\.amzn2023\.0\.4  | 
|  daxctl  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  daxctl  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  daxctl\-devel  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  daxctl\-devel  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  daxctl\-libs  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  daxctl\-libs  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl\-devel  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl\-devel  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl\-libs  |  aarch64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  ndctl\-libs  |  x86\_64  |  ndctl  |  71\.1\-2\.amzn2023\.0\.3  | 
|  nerdctl  |  aarch64  |  nerdctl  |  1\.1\.0\-1\.amzn2023\.0\.1  | 
|  nerdctl  |  x86\_64  |  nerdctl  |  1\.1\.0\-1\.amzn2023\.0\.1  | 
|  netlabel\_tools  |  aarch64  |  netlabel\_tools  |  0\.30\.0\-13\.amzn2023\.0\.1  | 
|  netlabel\_tools  |  x86\_64  |  netlabel\_tools  |  0\.30\.0\-13\.amzn2023\.0\.1  | 
|  netpbm  |  aarch64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm  |  x86\_64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-devel  |  aarch64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-devel  |  x86\_64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-doc  |  aarch64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-doc  |  x86\_64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-progs  |  aarch64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  netpbm\-progs  |  x86\_64  |  netpbm  |  10\.96\.00\-1\.amzn2023\.0\.3  | 
|  net\-snmp  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-agent\-libs  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-agent\-libs  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-devel  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-devel  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-gui  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-gui  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-libs  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-libs  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-perl  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-perl  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-utils  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  net\-snmp\-utils  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  python3\-net\-snmp  |  aarch64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  python3\-net\-snmp  |  x86\_64  |  net\-snmp  |  5\.9\.3\-2\.amzn2023\.0\.2  | 
|  nettle  |  aarch64  |  nettle  |  3\.8\-1\.amzn2023\.0\.2  | 
|  nettle  |  x86\_64  |  nettle  |  3\.8\-1\.amzn2023\.0\.2  | 
|  nettle\-devel  |  aarch64  |  nettle  |  3\.8\-1\.amzn2023\.0\.2  | 
|  nettle\-devel  |  x86\_64  |  nettle  |  3\.8\-1\.amzn2023\.0\.2  | 
|  net\-tools  |  aarch64  |  net\-tools  |  2\.0\-0\.59\.20160912git\.amzn2023\.0\.3  | 
|  net\-tools  |  x86\_64  |  net\-tools  |  2\.0\-0\.59\.20160912git\.amzn2023\.0\.3  | 
|  newt  |  aarch64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  newt  |  x86\_64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  newt\-devel  |  aarch64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  newt\-devel  |  x86\_64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  python3\-newt  |  aarch64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  python3\-newt  |  x86\_64  |  newt  |  0\.52\.21\-9\.amzn2023\.0\.3  | 
|  nfs4\-acl\-tools  |  aarch64  |  nfs4\-acl\-tools  |  0\.4\.2\-1\.amzn2023  | 
|  nfs4\-acl\-tools  |  x86\_64  |  nfs4\-acl\-tools  |  0\.4\.2\-1\.amzn2023  | 
|  libnfsidmap  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  libnfsidmap  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  libnfsidmap\-devel  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  libnfsidmap\-devel  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-stats\-utils  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-stats\-utils  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-utils  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-utils  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-utils\-coreos  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfs\-utils\-coreos  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfsv4\-client\-utils  |  aarch64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nfsv4\-client\-utils  |  x86\_64  |  nfs\-utils  |  2\.5\.4\-2\.rc3\.amzn2023\.0\.3  | 
|  nftables  |  aarch64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  nftables  |  x86\_64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  nftables\-devel  |  aarch64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  nftables\-devel  |  x86\_64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  python3\-nftables  |  aarch64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  python3\-nftables  |  x86\_64  |  nftables  |  1\.0\.4\-3\.amzn2023\.0\.2  | 
|  libnghttp2  |  aarch64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  libnghttp2  |  x86\_64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  libnghttp2\-devel  |  aarch64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  libnghttp2\-devel  |  x86\_64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  nghttp2  |  aarch64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  nghttp2  |  x86\_64  |  nghttp2  |  1\.51\.0\-1\.amzn2023  | 
|  nginx  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-all\-modules  |  noarch  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-core  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-core  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-filesystem  |  noarch  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-devel  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-devel  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-image\-filter  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-image\-filter  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-perl  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-perl  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-xslt\-filter  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-http\-xslt\-filter  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-mail  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-mail  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-stream  |  aarch64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nginx\-mod\-stream  |  x86\_64  |  nginx  |  1\.24\.0\-1\.amzn2023\.0\.1  | 
|  nim\-srpm\-macros  |  noarch  |  nim\-srpm\-macros  |  3\-4\.amzn2023\.0\.3  | 
|  ninja\-build  |  aarch64  |  ninja\-build  |  1\.10\.2\-2\.amzn2023\.0\.3  | 
|  ninja\-build  |  x86\_64  |  ninja\-build  |  1\.10\.2\-2\.amzn2023\.0\.3  | 
|  nkf  |  aarch64  |  nkf  |  2\.1\.4\-19\.amzn2023\.0\.3  | 
|  nkf  |  x86\_64  |  nkf  |  2\.1\.4\-19\.amzn2023\.0\.3  | 
|  perl\-NKF  |  aarch64  |  nkf  |  2\.1\.4\-19\.amzn2023\.0\.3  | 
|  perl\-NKF  |  x86\_64  |  nkf  |  2\.1\.4\-19\.amzn2023\.0\.3  | 
|  nmap  |  aarch64  |  nmap  |  7\.93\-1\.amzn2023  | 
|  nmap  |  x86\_64  |  nmap  |  7\.93\-1\.amzn2023  | 
|  nmap\-ncat  |  aarch64  |  nmap  |  7\.93\-1\.amzn2023  | 
|  nmap\-ncat  |  x86\_64  |  nmap  |  7\.93\-1\.amzn2023  | 
|  nodejs  |  aarch64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs  |  x86\_64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-devel  |  aarch64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-devel  |  x86\_64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-docs  |  noarch  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-full\-i18n  |  aarch64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-full\-i18n  |  x86\_64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-libs  |  aarch64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  nodejs\-libs  |  x86\_64  |  nodejs  |  18\.12\.1\-1\.amzn2023\.0\.7  | 
|  npm  |  aarch64  |  nodejs  |  8\.19\.2\-1\.18\.12\.1\.1\.amzn2023\.0\.7  | 
|  npm  |  x86\_64  |  nodejs  |  8\.19\.2\-1\.18\.12\.1\.1\.amzn2023\.0\.7  | 
|  v8\-devel  |  aarch64  |  nodejs  |  10\.2\.154\.15\-1\.18\.12\.1\.1\.amzn2023\.0\.7  | 
|  v8\-devel  |  x86\_64  |  nodejs  |  10\.2\.154\.15\-1\.18\.12\.1\.1\.amzn2023\.0\.7  | 
|  nodejs\-packaging  |  noarch  |  nodejs\-packaging  |  2021\.06\-2\.amzn2023\.0\.3  | 
|  nodejs\-packaging\-bundler  |  noarch  |  nodejs\-packaging  |  2021\.06\-2\.amzn2023\.0\.3  | 
|  nototools  |  noarch  |  nototools  |  0\.2\.13\-2\.amzn2023\.0\.3  | 
|  python3\-nototools  |  noarch  |  nototools  |  0\.2\.13\-2\.amzn2023\.0\.3  | 
|  npth  |  aarch64  |  npth  |  1\.6\-6\.amzn2023\.0\.2  | 
|  npth  |  x86\_64  |  npth  |  1\.6\-6\.amzn2023\.0\.2  | 
|  npth\-devel  |  aarch64  |  npth  |  1\.6\-6\.amzn2023\.0\.2  | 
|  npth\-devel  |  x86\_64  |  npth  |  1\.6\-6\.amzn2023\.0\.2  | 
|  nspr  |  aarch64  |  nss  |  4\.35\.0\-4\.amzn2023\.0\.2  | 
|  nspr  |  x86\_64  |  nss  |  4\.35\.0\-4\.amzn2023\.0\.2  | 
|  nspr\-devel  |  aarch64  |  nss  |  4\.35\.0\-4\.amzn2023\.0\.2  | 
|  nspr\-devel  |  x86\_64  |  nss  |  4\.35\.0\-4\.amzn2023\.0\.2  | 
|  nss  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-devel  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-devel  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-pkcs11\-devel  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-pkcs11\-devel  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-devel  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-devel  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-freebl  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-freebl  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-freebl\-devel  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-softokn\-freebl\-devel  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-sysinit  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-sysinit  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-tools  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-tools  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-util  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-util  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-util\-devel  |  aarch64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\-util\-devel  |  x86\_64  |  nss  |  3\.88\.1\-1\.amzn2023\.0\.2  | 
|  nss\_wrapper  |  aarch64  |  nss\_wrapper  |  1\.1\.11\-5\.amzn2023\.0\.2  | 
|  nss\_wrapper  |  x86\_64  |  nss\_wrapper  |  1\.1\.11\-5\.amzn2023\.0\.2  | 
|  nss\-pam\-ldapd  |  aarch64  |  nss\-pam\-ldapd  |  0\.9\.10\-9\.amzn2023\.0\.2  | 
|  nss\-pam\-ldapd  |  x86\_64  |  nss\-pam\-ldapd  |  0\.9\.10\-9\.amzn2023\.0\.2  | 
|  nss\-pem  |  aarch64  |  nss\-pem  |  1\.0\.8\-1\.amzn2023\.0\.2  | 
|  nss\-pem  |  x86\_64  |  nss\-pem  |  1\.0\.8\-1\.amzn2023\.0\.2  | 
|  numactl  |  aarch64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numactl  |  x86\_64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numactl\-devel  |  aarch64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numactl\-devel  |  x86\_64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numactl\-libs  |  aarch64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numactl\-libs  |  x86\_64  |  numactl  |  2\.0\.14\-3\.amzn2023\.0\.3  | 
|  numad  |  aarch64  |  numad  |  0\.5\-34\.20150602git\.amzn2023\.0\.3  | 
|  numad  |  x86\_64  |  numad  |  0\.5\-34\.20150602git\.amzn2023\.0\.3  | 
|  python3\-numpy  |  aarch64  |  numpy  |  1\.21\.1\-1\.amzn2023\.0\.3  | 
|  python3\-numpy  |  x86\_64  |  numpy  |  1\.21\.1\-1\.amzn2023\.0\.3  | 
|  python3\-numpy\-doc  |  noarch  |  numpy  |  1\.21\.1\-1\.amzn2023\.0\.3  | 
|  python3\-numpy\-f2py  |  aarch64  |  numpy  |  1\.21\.1\-1\.amzn2023\.0\.3  | 
|  python3\-numpy\-f2py  |  x86\_64  |  numpy  |  1\.21\.1\-1\.amzn2023\.0\.3  | 
|  nvme\-cli  |  aarch64  |  nvme\-cli  |  1\.11\.1\-3\.amzn2023\.0\.3  | 
|  nvme\-cli  |  x86\_64  |  nvme\-cli  |  1\.11\.1\-3\.amzn2023\.0\.3  | 
|  daxio  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem2  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem2\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem2\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemblk  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemblk\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemblk\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmem\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemlog  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemlog\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemlog\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemobj  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemobj\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmemobj\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmempool  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmempool\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  libpmempool\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  librpmem  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  librpmem\-debug  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  librpmem\-devel  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  pmempool  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  rpmemd  |  x86\_64  |  nvml  |  1\.10\.1\-1\.amzn2023\.0\.4  | 
|  objectweb\-asm  |  noarch  |  objectweb\-asm  |  9\.2\-3\.amzn2023\.0\.3  | 
|  objectweb\-asm\-javadoc  |  noarch  |  objectweb\-asm  |  9\.2\-3\.amzn2023\.0\.3  | 
|  objenesis  |  noarch  |  objenesis  |  3\.1\-9\.amzn2023\.0\.3  | 
|  objenesis\-javadoc  |  noarch  |  objenesis  |  3\.1\-9\.amzn2023\.0\.3  | 
|  ocaml  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-compiler\-libs  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-compiler\-libs  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-docs  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-docs  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-ocamldoc  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-ocamldoc  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-runtime  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-runtime  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-source  |  aarch64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-source  |  x86\_64  |  ocaml  |  4\.13\.1\-4\.amzn2023\.0\.2  | 
|  ocaml\-findlib  |  aarch64  |  ocaml\-findlib  |  1\.9\.3\-2\.amzn2023\.0\.3  | 
|  ocaml\-findlib  |  x86\_64  |  ocaml\-findlib  |  1\.9\.3\-2\.amzn2023\.0\.3  | 
|  ocaml\-findlib\-devel  |  aarch64  |  ocaml\-findlib  |  1\.9\.3\-2\.amzn2023\.0\.3  | 
|  ocaml\-findlib\-devel  |  x86\_64  |  ocaml\-findlib  |  1\.9\.3\-2\.amzn2023\.0\.3  | 
|  ocaml\-labltk  |  aarch64  |  ocaml\-labltk  |  8\.06\.11\-3\.amzn2023\.0\.3  | 
|  ocaml\-labltk  |  x86\_64  |  ocaml\-labltk  |  8\.06\.11\-3\.amzn2023\.0\.3  | 
|  ocaml\-labltk\-devel  |  aarch64  |  ocaml\-labltk  |  8\.06\.11\-3\.amzn2023\.0\.3  | 
|  ocaml\-labltk\-devel  |  x86\_64  |  ocaml\-labltk  |  8\.06\.11\-3\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild  |  aarch64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild  |  x86\_64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild\-devel  |  aarch64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild\-devel  |  x86\_64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild\-doc  |  aarch64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-ocamlbuild\-doc  |  x86\_64  |  ocaml\-ocamlbuild  |  0\.14\.0\-32\.amzn2023\.0\.3  | 
|  ocaml\-srpm\-macros  |  noarch  |  ocaml\-srpm\-macros  |  6\-6\.amzn2023\.0\.2  | 
|  ocaml\-zarith  |  aarch64  |  ocaml\-zarith  |  1\.12\-5\.amzn2023\.0\.3  | 
|  ocaml\-zarith  |  x86\_64  |  ocaml\-zarith  |  1\.12\-5\.amzn2023\.0\.3  | 
|  ocaml\-zarith\-devel  |  aarch64  |  ocaml\-zarith  |  1\.12\-5\.amzn2023\.0\.3  | 
|  ocaml\-zarith\-devel  |  x86\_64  |  ocaml\-zarith  |  1\.12\-5\.amzn2023\.0\.3  | 
|  oci\-add\-hooks  |  aarch64  |  oci\-add\-hooks  |  0\-0\.1\.20200504git268e3bb\.amzn2023  | 
|  oci\-add\-hooks  |  x86\_64  |  oci\-add\-hooks  |  0\-0\.1\.20200504git268e3bb\.amzn2023  | 
|  ocl\-icd  |  aarch64  |  ocl\-icd  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  ocl\-icd  |  x86\_64  |  ocl\-icd  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  ocl\-icd\-devel  |  aarch64  |  ocl\-icd  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  ocl\-icd\-devel  |  x86\_64  |  ocl\-icd  |  2\.3\.1\-2\.amzn2023\.0\.2  | 
|  oddjob  |  aarch64  |  oddjob  |  0\.34\.7\-2\.amzn2023\.0\.3  | 
|  oddjob  |  x86\_64  |  oddjob  |  0\.34\.7\-2\.amzn2023\.0\.3  | 
|  oddjob\-mkhomedir  |  aarch64  |  oddjob  |  0\.34\.7\-2\.amzn2023\.0\.3  | 
|  oddjob\-mkhomedir  |  x86\_64  |  oddjob  |  0\.34\.7\-2\.amzn2023\.0\.3  | 
|  oldstandard\-sfd\-fonts  |  noarch  |  oldstandard\-sfd\-fonts  |  2\.0\.2\-29\.amzn2023\.0\.3  | 
|  oniguruma  |  aarch64  |  oniguruma  |  6\.9\.7\.1\-1\.amzn2023\.0\.2  | 
|  oniguruma  |  x86\_64  |  oniguruma  |  6\.9\.7\.1\-1\.amzn2023\.0\.2  | 
|  oniguruma\-devel  |  aarch64  |  oniguruma  |  6\.9\.7\.1\-1\.amzn2023\.0\.2  | 
|  oniguruma\-devel  |  x86\_64  |  oniguruma  |  6\.9\.7\.1\-1\.amzn2023\.0\.2  | 
|  openblas  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-devel  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-devel  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp64  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp64  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp64\_  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-openmp64\_  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial64  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial64  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial64\_  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-serial64\_  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-static  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-static  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads64  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads64  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads64\_  |  aarch64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-threads64\_  |  x86\_64  |  openblas  |  0\.3\.18\-1\.amzn2023\.0\.3  | 
|  openblas\-srpm\-macros  |  noarch  |  openblas\-srpm\-macros  |  2\-9\.amzn2023\.0\.2  | 
|  opencl\-filesystem  |  noarch  |  opencl\-filesystem  |  1\.0\-15\.amzn2023\.0\.3  | 
|  opencl\-headers  |  noarch  |  opencl\-headers  |  3\.0\-11\.20220510gitdef8be9\.amzn2023\.0\.3  | 
|  openexr  |  aarch64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openexr  |  x86\_64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openexr\-devel  |  aarch64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openexr\-devel  |  x86\_64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openexr\-libs  |  aarch64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openexr\-libs  |  x86\_64  |  openexr  |  3\.1\.5\-1\.amzn2023\.0\.3  | 
|  openjade  |  aarch64  |  openjade  |  1\.3\.2\-66\.amzn2023\.0\.3  | 
|  openjade  |  x86\_64  |  openjade  |  1\.3\.2\-66\.amzn2023\.0\.3  | 
|  openjpeg2  |  aarch64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2  |  x86\_64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2\-devel  |  aarch64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2\-devel  |  x86\_64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2\-devel\-docs  |  noarch  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2\-tools  |  aarch64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openjpeg2\-tools  |  x86\_64  |  openjpeg2  |  2\.4\.0\-11\.amzn2023\.0\.3  | 
|  openldap  |  aarch64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap  |  x86\_64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-clients  |  aarch64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-clients  |  x86\_64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-compat  |  aarch64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-compat  |  x86\_64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-devel  |  aarch64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-devel  |  x86\_64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-servers  |  aarch64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openldap\-servers  |  x86\_64  |  openldap  |  2\.4\.57\-6\.amzn2023\.0\.5  | 
|  openmpi  |  aarch64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi  |  x86\_64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-devel  |  aarch64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-devel  |  x86\_64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-java  |  aarch64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-java  |  x86\_64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-java\-devel  |  aarch64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  openmpi\-java\-devel  |  x86\_64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  python3\-openmpi  |  aarch64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  python3\-openmpi  |  x86\_64  |  openmpi  |  4\.1\.2\-3\.amzn2023\.0\.4  | 
|  opensc  |  aarch64  |  opensc  |  0\.23\.0\-3\.amzn2023\.0\.1  | 
|  opensc  |  x86\_64  |  opensc  |  0\.23\.0\-3\.amzn2023\.0\.1  | 
|  openscap  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-containers  |  noarch  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-devel  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-devel  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-engine\-sce  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-engine\-sce  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-engine\-sce\-devel  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-engine\-sce\-devel  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-python3  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-python3  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-scanner  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-scanner  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-utils  |  aarch64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  openscap\-utils  |  x86\_64  |  openscap  |  1\.3\.7\-1\.amzn2023\.0\.1  | 
|  opensm  |  aarch64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm  |  x86\_64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-devel  |  aarch64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-devel  |  x86\_64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-libs  |  aarch64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-libs  |  x86\_64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-static  |  aarch64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensm\-static  |  x86\_64  |  opensm  |  3\.3\.23\-6\.amzn2023\.0\.3  | 
|  opensmtpd  |  aarch64  |  opensmtpd  |  6\.8\.0p2\-11\.amzn2023\.0\.1  | 
|  opensmtpd  |  x86\_64  |  opensmtpd  |  6\.8\.0p2\-11\.amzn2023\.0\.1  | 
|  opensp  |  aarch64  |  opensp  |  1\.5\.2\-36\.amzn2023\.0\.3  | 
|  opensp  |  x86\_64  |  opensp  |  1\.5\.2\-36\.amzn2023\.0\.3  | 
|  opensp\-devel  |  aarch64  |  opensp  |  1\.5\.2\-36\.amzn2023\.0\.3  | 
|  opensp\-devel  |  x86\_64  |  opensp  |  1\.5\.2\-36\.amzn2023\.0\.3  | 
|  openssh  |  aarch64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh  |  x86\_64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-clients  |  aarch64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-clients  |  x86\_64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-keycat  |  aarch64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-keycat  |  x86\_64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-server  |  aarch64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  openssh\-server  |  x86\_64  |  openssh  |  8\.7p1\-8\.amzn2023\.0\.6  | 
|  pam\_ssh\_agent\_auth  |  aarch64  |  openssh  |  0\.10\.4\-4\.8\.amzn2023\.0\.6  | 
|  pam\_ssh\_agent\_auth  |  x86\_64  |  openssh  |  0\.10\.4\-4\.8\.amzn2023\.0\.6  | 
|  openssl  |  aarch64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl  |  x86\_64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-devel  |  aarch64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-devel  |  x86\_64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-libs  |  aarch64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-libs  |  x86\_64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-perl  |  aarch64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  openssl\-perl  |  x86\_64  |  openssl  |  3\.0\.8\-1\.amzn2023\.0\.3  | 
|  libp11\-devel  |  aarch64  |  openssl\-pkcs11  |  0\.4\.12\-3\.amzn2023\.0\.1  | 
|  libp11\-devel  |  x86\_64  |  openssl\-pkcs11  |  0\.4\.12\-3\.amzn2023\.0\.1  | 
|  openssl\-pkcs11  |  aarch64  |  openssl\-pkcs11  |  0\.4\.12\-3\.amzn2023\.0\.1  | 
|  openssl\-pkcs11  |  x86\_64  |  openssl\-pkcs11  |  0\.4\.12\-3\.amzn2023\.0\.1  | 
|  opentest4j  |  noarch  |  opentest4j  |  1\.2\.0\-10\.amzn2023\.0\.3  | 
|  opentest4j\-javadoc  |  noarch  |  opentest4j  |  1\.2\.0\-10\.amzn2023\.0\.3  | 
|  open\-vm\-tools  |  aarch64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-desktop  |  aarch64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-desktop  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-devel  |  aarch64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-devel  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-salt\-minion  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-sdmp  |  aarch64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-sdmp  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-test  |  aarch64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  open\-vm\-tools\-test  |  x86\_64  |  open\-vm\-tools  |  12\.2\.5\-1\.amzn2023  | 
|  opus  |  aarch64  |  opus  |  1\.3\.1\-8\.amzn2023\.0\.3  | 
|  opus  |  x86\_64  |  opus  |  1\.3\.1\-8\.amzn2023\.0\.3  | 
|  opus\-devel  |  aarch64  |  opus  |  1\.3\.1\-8\.amzn2023\.0\.3  | 
|  opus\-devel  |  x86\_64  |  opus  |  1\.3\.1\-8\.amzn2023\.0\.3  | 
|  orangefs  |  aarch64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs  |  x86\_64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-devel  |  aarch64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-devel  |  x86\_64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-fuse  |  aarch64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-fuse  |  x86\_64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-server  |  aarch64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orangefs\-server  |  x86\_64  |  orangefs  |  2\.9\.8\-2\.amzn2023\.0\.3  | 
|  orc  |  aarch64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc  |  x86\_64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc\-compiler  |  aarch64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc\-compiler  |  x86\_64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc\-devel  |  aarch64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc\-devel  |  x86\_64  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  orc\-doc  |  noarch  |  orc  |  0\.4\.31\-4\.amzn2023\.0\.3  | 
|  osgi\-annotation  |  noarch  |  osgi\-annotation  |  8\.0\.1\-4\.amzn2023\.0\.3  | 
|  osgi\-annotation\-javadoc  |  noarch  |  osgi\-annotation  |  8\.0\.1\-4\.amzn2023\.0\.3  | 
|  osgi\-compendium  |  noarch  |  osgi\-compendium  |  7\.0\.0\-12\.amzn2023\.0\.3  | 
|  osgi\-compendium\-javadoc  |  noarch  |  osgi\-compendium  |  7\.0\.0\-12\.amzn2023\.0\.3  | 
|  osgi\-core  |  noarch  |  osgi\-core  |  8\.0\.0\-5\.amzn2023\.0\.3  | 
|  osgi\-core\-javadoc  |  noarch  |  osgi\-core  |  8\.0\.0\-5\.amzn2023\.0\.3  | 
|  os\-prober  |  aarch64  |  os\-prober  |  1\.77\-7\.amzn2023\.0\.3  | 
|  os\-prober  |  x86\_64  |  os\-prober  |  1\.77\-7\.amzn2023\.0\.3  | 
|  overpass\-fonts  |  noarch  |  overpass\-fonts  |  3\.0\.4\-5\.amzn2023\.0\.3  | 
|  overpass\-mono\-fonts  |  noarch  |  overpass\-fonts  |  3\.0\.4\-5\.amzn2023\.0\.3  | 
|  p11\-kit  |  aarch64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit  |  x86\_64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-devel  |  aarch64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-devel  |  x86\_64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-server  |  aarch64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-server  |  x86\_64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-trust  |  aarch64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p11\-kit\-trust  |  x86\_64  |  p11\-kit  |  0\.24\.1\-2\.amzn2023\.0\.2  | 
|  p7zip  |  aarch64  |  p7zip  |  16\.02\-20\.amzn2023\.0\.4  | 
|  p7zip  |  x86\_64  |  p7zip  |  16\.02\-20\.amzn2023\.0\.4  | 
|  p7zip\-doc  |  noarch  |  p7zip  |  16\.02\-20\.amzn2023\.0\.4  | 
|  p7zip\-plugins  |  aarch64  |  p7zip  |  16\.02\-20\.amzn2023\.0\.4  | 
|  p7zip\-plugins  |  x86\_64  |  p7zip  |  16\.02\-20\.amzn2023\.0\.4  | 
|  PackageKit  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-command\-not\-found  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-command\-not\-found  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-cron  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-cron  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-glib  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-glib  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-glib\-devel  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-glib\-devel  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-gtk3\-module  |  aarch64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  PackageKit\-gtk3\-module  |  x86\_64  |  PackageKit  |  1\.2\.4\-2\.amzn2023\.0\.5  | 
|  package\-notes  |  noarch  |  package\-notes  |  0\.4\-18\.amzn2023\.0\.5  | 
|  package\-notes\-srpm\-macros  |  noarch  |  package\-notes  |  0\.4\-18\.amzn2023\.0\.5  | 
|  paktype\-naskh\-basic\-fonts  |  noarch  |  paktype\-naskh\-basic\-fonts  |  6\.0\-1\.amzn2023\.0\.3  | 
|  pam  |  aarch64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  pam  |  x86\_64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  pam\-devel  |  aarch64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  pam\-devel  |  x86\_64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  pam\-docs  |  aarch64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  pam\-docs  |  x86\_64  |  pam  |  1\.5\.1\-8\.amzn2023\.0\.3  | 
|  libpamtest  |  aarch64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  libpamtest  |  x86\_64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  libpamtest\-devel  |  aarch64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  libpamtest\-devel  |  x86\_64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  libpamtest\-doc  |  aarch64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  libpamtest\-doc  |  x86\_64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  pam\_wrapper  |  aarch64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  pam\_wrapper  |  x86\_64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  python3\-libpamtest  |  aarch64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  python3\-libpamtest  |  x86\_64  |  pam\_wrapper  |  1\.1\.3\-7\.amzn2023\.0\.3  | 
|  pango  |  aarch64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pango  |  x86\_64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pango\-devel  |  aarch64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pango\-devel  |  x86\_64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pango\-tests  |  aarch64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pango\-tests  |  x86\_64  |  pango  |  1\.48\.10\-1\.amzn2023\.0\.3  | 
|  pangomm  |  aarch64  |  pangomm  |  2\.46\.1\-1\.amzn2023\.0\.3  | 
|  pangomm  |  x86\_64  |  pangomm  |  2\.46\.1\-1\.amzn2023\.0\.3  | 
|  pangomm\-devel  |  aarch64  |  pangomm  |  2\.46\.1\-1\.amzn2023\.0\.3  | 
|  pangomm\-devel  |  x86\_64  |  pangomm  |  2\.46\.1\-1\.amzn2023\.0\.3  | 
|  pangomm\-doc  |  noarch  |  pangomm  |  2\.46\.1\-1\.amzn2023\.0\.3  | 
|  paper  |  aarch64  |  paper  |  2\.3\-2\.amzn2023\.0\.3  | 
|  paper  |  x86\_64  |  paper  |  2\.3\-2\.amzn2023\.0\.3  | 
|  papi  |  aarch64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi  |  x86\_64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-devel  |  aarch64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-devel  |  x86\_64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-libs  |  aarch64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-libs  |  x86\_64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-testsuite  |  aarch64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  papi\-testsuite  |  x86\_64  |  papi  |  6\.0\.0\-8\.amzn2023\.0\.5  | 
|  parallel  |  noarch  |  parallel  |  20201222\-2\.amzn2023\.0\.3  | 
|  parted  |  aarch64  |  parted  |  3\.4\-2\.amzn2023\.0\.2  | 
|  parted  |  x86\_64  |  parted  |  3\.4\-2\.amzn2023\.0\.2  | 
|  parted\-devel  |  aarch64  |  parted  |  3\.4\-2\.amzn2023\.0\.2  | 
|  parted\-devel  |  x86\_64  |  parted  |  3\.4\-2\.amzn2023\.0\.2  | 
|  passwd  |  aarch64  |  passwd  |  0\.80\-10\.amzn2023\.0\.2  | 
|  passwd  |  x86\_64  |  passwd  |  0\.80\-10\.amzn2023\.0\.2  | 
|  patch  |  aarch64  |  patch  |  2\.7\.6\-14\.amzn2023\.0\.2  | 
|  patch  |  x86\_64  |  patch  |  2\.7\.6\-14\.amzn2023\.0\.2  | 
|  patchelf  |  aarch64  |  patchelf  |  0\.17\.0\-1\.amzn2023\.0\.2  | 
|  patchelf  |  x86\_64  |  patchelf  |  0\.17\.0\-1\.amzn2023\.0\.2  | 
|  patchutils  |  aarch64  |  patchutils  |  0\.4\.2\-5\.amzn2023\.0\.2  | 
|  patchutils  |  x86\_64  |  patchutils  |  0\.4\.2\-5\.amzn2023\.0\.2  | 
|  pciutils  |  aarch64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils  |  x86\_64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-devel  |  aarch64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-devel  |  x86\_64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-devel\-static  |  aarch64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-devel\-static  |  x86\_64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-libs  |  aarch64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pciutils\-libs  |  x86\_64  |  pciutils  |  3\.7\.0\-3\.amzn2023\.0\.2  | 
|  pcre  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-cpp  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-cpp  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-devel  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-devel  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-doc  |  noarch  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-static  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-static  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-tools  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-tools  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-utf16  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-utf16  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-utf32  |  aarch64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre\-utf32  |  x86\_64  |  pcre  |  8\.44\-3\.amzn2023\.1\.0\.3  | 
|  pcre2  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-devel  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-devel  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-static  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-static  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-syntax  |  noarch  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-tools  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-tools  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-utf16  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-utf16  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-utf32  |  aarch64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcre2\-utf32  |  x86\_64  |  pcre2  |  10\.40\-1\.amzn2023\.0\.2  | 
|  pcsc\-lite  |  aarch64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite  |  x86\_64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-devel  |  aarch64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-devel  |  x86\_64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-doc  |  noarch  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-libs  |  aarch64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-libs  |  x86\_64  |  pcsc\-lite  |  1\.9\.1\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-ccid  |  aarch64  |  pcsc\-lite\-ccid  |  1\.4\.34\-1\.amzn2023\.0\.3  | 
|  pcsc\-lite\-ccid  |  x86\_64  |  pcsc\-lite\-ccid  |  1\.4\.34\-1\.amzn2023\.0\.3  | 
|  perl  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Attribute\-Handlers  |  noarch  |  perl  |  1\.01\-477\.amzn2023\.0\.5  | 
|  perl\-AutoLoader  |  noarch  |  perl  |  5\.74\-477\.amzn2023\.0\.5  | 
|  perl\-AutoSplit  |  noarch  |  perl  |  5\.74\-477\.amzn2023\.0\.5  | 
|  perl\-autouse  |  noarch  |  perl  |  1\.11\-477\.amzn2023\.0\.5  | 
|  perl\-B  |  aarch64  |  perl  |  1\.80\-477\.amzn2023\.0\.5  | 
|  perl\-B  |  x86\_64  |  perl  |  1\.80\-477\.amzn2023\.0\.5  | 
|  perl\-base  |  noarch  |  perl  |  2\.27\-477\.amzn2023\.0\.5  | 
|  perl\-Benchmark  |  noarch  |  perl  |  1\.23\-477\.amzn2023\.0\.5  | 
|  perl\-blib  |  noarch  |  perl  |  1\.07\-477\.amzn2023\.0\.5  | 
|  perl\-Class\-Struct  |  noarch  |  perl  |  0\.66\-477\.amzn2023\.0\.5  | 
|  perl\-Config\-Extensions  |  noarch  |  perl  |  0\.03\-477\.amzn2023\.0\.5  | 
|  perl\-DBM\_Filter  |  noarch  |  perl  |  0\.06\-477\.amzn2023\.0\.5  | 
|  perl\-debugger  |  noarch  |  perl  |  1\.56\-477\.amzn2023\.0\.5  | 
|  perl\-deprecate  |  noarch  |  perl  |  0\.04\-477\.amzn2023\.0\.5  | 
|  perl\-devel  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-devel  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Devel\-Peek  |  aarch64  |  perl  |  1\.28\-477\.amzn2023\.0\.5  | 
|  perl\-Devel\-Peek  |  x86\_64  |  perl  |  1\.28\-477\.amzn2023\.0\.5  | 
|  perl\-Devel\-SelfStubber  |  noarch  |  perl  |  1\.06\-477\.amzn2023\.0\.5  | 
|  perl\-diagnostics  |  noarch  |  perl  |  1\.37\-477\.amzn2023\.0\.5  | 
|  perl\-DirHandle  |  noarch  |  perl  |  1\.05\-477\.amzn2023\.0\.5  | 
|  perl\-doc  |  noarch  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Dumpvalue  |  noarch  |  perl  |  2\.27\-477\.amzn2023\.0\.5  | 
|  perl\-DynaLoader  |  aarch64  |  perl  |  1\.47\-477\.amzn2023\.0\.5  | 
|  perl\-DynaLoader  |  x86\_64  |  perl  |  1\.47\-477\.amzn2023\.0\.5  | 
|  perl\-encoding\-warnings  |  noarch  |  perl  |  0\.13\-477\.amzn2023\.0\.5  | 
|  perl\-English  |  noarch  |  perl  |  1\.11\-477\.amzn2023\.0\.5  | 
|  perl\-Errno  |  aarch64  |  perl  |  1\.30\-477\.amzn2023\.0\.5  | 
|  perl\-Errno  |  x86\_64  |  perl  |  1\.30\-477\.amzn2023\.0\.5  | 
|  perl\-ExtUtils\-Constant  |  noarch  |  perl  |  0\.25\-477\.amzn2023\.0\.5  | 
|  perl\-ExtUtils\-Embed  |  noarch  |  perl  |  1\.35\-477\.amzn2023\.0\.5  | 
|  perl\-ExtUtils\-Miniperl  |  noarch  |  perl  |  1\.09\-477\.amzn2023\.0\.5  | 
|  perl\-Fcntl  |  aarch64  |  perl  |  1\.13\-477\.amzn2023\.0\.5  | 
|  perl\-Fcntl  |  x86\_64  |  perl  |  1\.13\-477\.amzn2023\.0\.5  | 
|  perl\-fields  |  noarch  |  perl  |  2\.27\-477\.amzn2023\.0\.5  | 
|  perl\-File\-Basename  |  noarch  |  perl  |  2\.85\-477\.amzn2023\.0\.5  | 
|  perl\-FileCache  |  noarch  |  perl  |  1\.10\-477\.amzn2023\.0\.5  | 
|  perl\-File\-Compare  |  noarch  |  perl  |  1\.100\.600\-477\.amzn2023\.0\.5  | 
|  perl\-File\-Copy  |  noarch  |  perl  |  2\.34\-477\.amzn2023\.0\.5  | 
|  perl\-File\-DosGlob  |  aarch64  |  perl  |  1\.12\-477\.amzn2023\.0\.5  | 
|  perl\-File\-DosGlob  |  x86\_64  |  perl  |  1\.12\-477\.amzn2023\.0\.5  | 
|  perl\-File\-Find  |  noarch  |  perl  |  1\.37\-477\.amzn2023\.0\.5  | 
|  perl\-FileHandle  |  noarch  |  perl  |  2\.03\-477\.amzn2023\.0\.5  | 
|  perl\-File\-stat  |  noarch  |  perl  |  1\.09\-477\.amzn2023\.0\.5  | 
|  perl\-filetest  |  noarch  |  perl  |  1\.03\-477\.amzn2023\.0\.5  | 
|  perl\-FindBin  |  noarch  |  perl  |  1\.51\-477\.amzn2023\.0\.5  | 
|  perl\-GDBM\_File  |  aarch64  |  perl  |  1\.18\-477\.amzn2023\.0\.5  | 
|  perl\-GDBM\_File  |  x86\_64  |  perl  |  1\.18\-477\.amzn2023\.0\.5  | 
|  perl\-Getopt\-Std  |  noarch  |  perl  |  1\.12\-477\.amzn2023\.0\.5  | 
|  perl\-Hash\-Util  |  aarch64  |  perl  |  0\.23\-477\.amzn2023\.0\.5  | 
|  perl\-Hash\-Util  |  x86\_64  |  perl  |  0\.23\-477\.amzn2023\.0\.5  | 
|  perl\-Hash\-Util\-FieldHash  |  aarch64  |  perl  |  1\.20\-477\.amzn2023\.0\.5  | 
|  perl\-Hash\-Util\-FieldHash  |  x86\_64  |  perl  |  1\.20\-477\.amzn2023\.0\.5  | 
|  perl\-I18N\-Collate  |  noarch  |  perl  |  1\.02\-477\.amzn2023\.0\.5  | 
|  perl\-I18N\-Langinfo  |  aarch64  |  perl  |  0\.19\-477\.amzn2023\.0\.5  | 
|  perl\-I18N\-Langinfo  |  x86\_64  |  perl  |  0\.19\-477\.amzn2023\.0\.5  | 
|  perl\-I18N\-LangTags  |  noarch  |  perl  |  0\.44\-477\.amzn2023\.0\.5  | 
|  perl\-if  |  noarch  |  perl  |  0\.60\.800\-477\.amzn2023\.0\.5  | 
|  perl\-interpreter  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-interpreter  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-IO  |  aarch64  |  perl  |  1\.43\-477\.amzn2023\.0\.5  | 
|  perl\-IO  |  x86\_64  |  perl  |  1\.43\-477\.amzn2023\.0\.5  | 
|  perl\-IPC\-Open3  |  noarch  |  perl  |  1\.21\-477\.amzn2023\.0\.5  | 
|  perl\-less  |  noarch  |  perl  |  0\.03\-477\.amzn2023\.0\.5  | 
|  perl\-lib  |  aarch64  |  perl  |  0\.65\-477\.amzn2023\.0\.5  | 
|  perl\-lib  |  x86\_64  |  perl  |  0\.65\-477\.amzn2023\.0\.5  | 
|  perl\-libnetcfg  |  noarch  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-libs  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-libs  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-locale  |  noarch  |  perl  |  1\.09\-477\.amzn2023\.0\.5  | 
|  perl\-Locale\-Maketext\-Simple  |  noarch  |  perl  |  0\.21\-477\.amzn2023\.0\.5  | 
|  perl\-macros  |  noarch  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Math\-Complex  |  noarch  |  perl  |  1\.59\-477\.amzn2023\.0\.5  | 
|  perl\-Memoize  |  noarch  |  perl  |  1\.03\-477\.amzn2023\.0\.5  | 
|  perl\-meta\-notation  |  noarch  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Module\-Loaded  |  noarch  |  perl  |  0\.08\-477\.amzn2023\.0\.5  | 
|  perl\-mro  |  aarch64  |  perl  |  1\.23\-477\.amzn2023\.0\.5  | 
|  perl\-mro  |  x86\_64  |  perl  |  1\.23\-477\.amzn2023\.0\.5  | 
|  perl\-NDBM\_File  |  aarch64  |  perl  |  1\.15\-477\.amzn2023\.0\.5  | 
|  perl\-NDBM\_File  |  x86\_64  |  perl  |  1\.15\-477\.amzn2023\.0\.5  | 
|  perl\-Net  |  noarch  |  perl  |  1\.02\-477\.amzn2023\.0\.5  | 
|  perl\-NEXT  |  noarch  |  perl  |  0\.67\-477\.amzn2023\.0\.5  | 
|  perl\-ODBM\_File  |  aarch64  |  perl  |  1\.16\-477\.amzn2023\.0\.5  | 
|  perl\-ODBM\_File  |  x86\_64  |  perl  |  1\.16\-477\.amzn2023\.0\.5  | 
|  perl\-Opcode  |  aarch64  |  perl  |  1\.48\-477\.amzn2023\.0\.5  | 
|  perl\-Opcode  |  x86\_64  |  perl  |  1\.48\-477\.amzn2023\.0\.5  | 
|  perl\-open  |  noarch  |  perl  |  1\.12\-477\.amzn2023\.0\.5  | 
|  perl\-overload  |  noarch  |  perl  |  1\.31\-477\.amzn2023\.0\.5  | 
|  perl\-overloading  |  noarch  |  perl  |  0\.02\-477\.amzn2023\.0\.5  | 
|  perl\-ph  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-ph  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Pod\-Functions  |  noarch  |  perl  |  1\.13\-477\.amzn2023\.0\.5  | 
|  perl\-Pod\-Html  |  noarch  |  perl  |  1\.25\-477\.amzn2023\.0\.5  | 
|  perl\-POSIX  |  aarch64  |  perl  |  1\.94\-477\.amzn2023\.0\.5  | 
|  perl\-POSIX  |  x86\_64  |  perl  |  1\.94\-477\.amzn2023\.0\.5  | 
|  perl\-Safe  |  noarch  |  perl  |  2\.41\-477\.amzn2023\.0\.5  | 
|  perl\-Search\-Dict  |  noarch  |  perl  |  1\.07\-477\.amzn2023\.0\.5  | 
|  perl\-SelectSaver  |  noarch  |  perl  |  1\.02\-477\.amzn2023\.0\.5  | 
|  perl\-SelfLoader  |  noarch  |  perl  |  1\.26\-477\.amzn2023\.0\.5  | 
|  perl\-sigtrap  |  noarch  |  perl  |  1\.09\-477\.amzn2023\.0\.5  | 
|  perl\-sort  |  noarch  |  perl  |  2\.04\-477\.amzn2023\.0\.5  | 
|  perl\-subs  |  noarch  |  perl  |  1\.03\-477\.amzn2023\.0\.5  | 
|  perl\-Symbol  |  noarch  |  perl  |  1\.08\-477\.amzn2023\.0\.5  | 
|  perl\-Sys\-Hostname  |  aarch64  |  perl  |  1\.23\-477\.amzn2023\.0\.5  | 
|  perl\-Sys\-Hostname  |  x86\_64  |  perl  |  1\.23\-477\.amzn2023\.0\.5  | 
|  perl\-Term\-Complete  |  noarch  |  perl  |  1\.403\-477\.amzn2023\.0\.5  | 
|  perl\-Term\-ReadLine  |  noarch  |  perl  |  1\.17\-477\.amzn2023\.0\.5  | 
|  perl\-Test  |  noarch  |  perl  |  1\.31\-477\.amzn2023\.0\.5  | 
|  perl\-tests  |  aarch64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-tests  |  x86\_64  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Text\-Abbrev  |  noarch  |  perl  |  1\.02\-477\.amzn2023\.0\.5  | 
|  perl\-Thread  |  noarch  |  perl  |  3\.05\-477\.amzn2023\.0\.5  | 
|  perl\-Thread\-Semaphore  |  noarch  |  perl  |  2\.13\-477\.amzn2023\.0\.5  | 
|  perl\-Tie  |  noarch  |  perl  |  4\.6\-477\.amzn2023\.0\.5  | 
|  perl\-Tie\-File  |  noarch  |  perl  |  1\.06\-477\.amzn2023\.0\.5  | 
|  perl\-Tie\-Memoize  |  noarch  |  perl  |  1\.1\-477\.amzn2023\.0\.5  | 
|  perl\-Time  |  noarch  |  perl  |  1\.03\-477\.amzn2023\.0\.5  | 
|  perl\-Time\-Piece  |  aarch64  |  perl  |  1\.3401\-477\.amzn2023\.0\.5  | 
|  perl\-Time\-Piece  |  x86\_64  |  perl  |  1\.3401\-477\.amzn2023\.0\.5  | 
|  perl\-Unicode\-UCD  |  noarch  |  perl  |  0\.75\-477\.amzn2023\.0\.5  | 
|  perl\-User\-pwent  |  noarch  |  perl  |  1\.03\-477\.amzn2023\.0\.5  | 
|  perl\-utils  |  noarch  |  perl  |  5\.32\.1\-477\.amzn2023\.0\.5  | 
|  perl\-vars  |  noarch  |  perl  |  1\.05\-477\.amzn2023\.0\.5  | 
|  perl\-vmsish  |  noarch  |  perl  |  1\.04\-477\.amzn2023\.0\.5  | 
|  perl\-accessors  |  noarch  |  perl\-accessors  |  1\.01\-33\.amzn2023\.0\.2  | 
|  perl\-Algorithm\-Diff  |  noarch  |  perl\-Algorithm\-Diff  |  1\.2010\-2\.amzn2023\.0\.2  | 
|  perl\-aliased  |  noarch  |  perl\-aliased  |  0\.34\-18\.amzn2023\.0\.2  | 
|  perl\-Any\-Moose  |  noarch  |  perl\-Any\-Moose  |  0\.27\-18\.amzn2023\.0\.2  | 
|  perl\-AppConfig  |  noarch  |  perl\-AppConfig  |  1\.71\-20\.amzn2023\.0\.2  | 
|  perl\-App\-FatPacker  |  noarch  |  perl\-App\-FatPacker  |  0\.010008\-8\.amzn2023\.0\.2  | 
|  perl\-Archive\-Any\-Lite  |  noarch  |  perl\-Archive\-Any\-Lite  |  0\.11\-16\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-bz2\-bunzip2  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-bz2\-IO\-Uncompress\-Bunzip2  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-gz\-Compress\-Zlib  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-gz\-gzip  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-lzma\-IO\-Uncompress\-UnLzma  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-lzma\-unlzma  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tar\-Archive\-Tar  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tar\-tar  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tbz\-Archive\-Tar\-IO\-Uncompress\-Bunzip2  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tbz\-tar\-bunzip2  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tgz\-Archive\-Tar\-Compress\-Zlib  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tgz\-Archive\-Tar\-IO\-Zlib  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-tgz\-tar\-gzip  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-txz\-Archive\-Tar\-IO\-Uncompress\-UnXz  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-txz\-tar\-unxz  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-xz\-IO\-Uncompress\-UnXz  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-xz\-unxz  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-Z\-Compress\-Zlib  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-zip\-Archive\-Zip  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-zip\-unzip  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Extract\-Z\-uncompress  |  noarch  |  perl\-Archive\-Extract  |  0\.88\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Tar  |  noarch  |  perl\-Archive\-Tar  |  2\.40\-1\.amzn2023\.0\.2  | 
|  perl\-Archive\-Zip  |  noarch  |  perl\-Archive\-Zip  |  1\.68\-4\.amzn2023\.0\.2  | 
|  perl\-Array\-Diff  |  noarch  |  perl\-Array\-Diff  |  0\.09\-7\.amzn2023\.0\.2  | 
|  perl\-Authen\-SASL  |  noarch  |  perl\-Authen\-SASL  |  2\.16\-23\.amzn2023\.0\.2  | 
|  perl\-autobox  |  aarch64  |  perl\-autobox  |  3\.0\.1\-12\.amzn2023\.0\.2  | 
|  perl\-autobox  |  x86\_64  |  perl\-autobox  |  3\.0\.1\-12\.amzn2023\.0\.2  | 
|  perl\-autodie  |  noarch  |  perl\-autodie  |  2\.34\-2\.amzn2023\.0\.2  | 
|  perl\-autovivification  |  aarch64  |  perl\-autovivification  |  0\.18\-12\.amzn2023\.0\.2  | 
|  perl\-autovivification  |  x86\_64  |  perl\-autovivification  |  0\.18\-12\.amzn2023\.0\.2  | 
|  perl\-bareword\-filehandles  |  aarch64  |  perl\-bareword\-filehandles  |  0\.007\-7\.amzn2023\.0\.2  | 
|  perl\-bareword\-filehandles  |  x86\_64  |  perl\-bareword\-filehandles  |  0\.007\-7\.amzn2023\.0\.2  | 
|  perl\-B\-Compiling  |  aarch64  |  perl\-B\-Compiling  |  0\.06\-21\.amzn2023\.0\.2  | 
|  perl\-B\-Compiling  |  x86\_64  |  perl\-B\-Compiling  |  0\.06\-21\.amzn2023\.0\.2  | 
|  perl\-B\-COW  |  aarch64  |  perl\-B\-COW  |  0\.004\-5\.amzn2023\.0\.2  | 
|  perl\-B\-COW  |  x86\_64  |  perl\-B\-COW  |  0\.004\-5\.amzn2023\.0\.2  | 
|  perl\-B\-Debug  |  noarch  |  perl\-B\-Debug  |  1\.26\-428\.amzn2023\.0\.2  | 
|  perl\-B\-Hooks\-EndOfScope  |  noarch  |  perl\-B\-Hooks\-EndOfScope  |  0\.24\-13\.amzn2023\.0\.2  | 
|  perl\-B\-Hooks\-OP\-Check  |  aarch64  |  perl\-B\-Hooks\-OP\-Check  |  0\.22\-13\.amzn2023\.0\.2  | 
|  perl\-B\-Hooks\-OP\-Check  |  x86\_64  |  perl\-B\-Hooks\-OP\-Check  |  0\.22\-13\.amzn2023\.0\.2  | 
|  perl\-BibTeX\-Parser  |  noarch  |  perl\-BibTeX\-Parser  |  1\.03\-1\.amzn2023\.0\.2  | 
|  perl\-bignum  |  noarch  |  perl\-bignum  |  0\.51\-458\.amzn2023\.0\.2  | 
|  perl\-Bit\-Vector  |  aarch64  |  perl\-Bit\-Vector  |  7\.4\-22\.amzn2023\.0\.2  | 
|  perl\-Bit\-Vector  |  x86\_64  |  perl\-Bit\-Vector  |  7\.4\-22\.amzn2023\.0\.2  | 
|  perl\-B\-Keywords  |  noarch  |  perl\-B\-Keywords  |  1\.22\-1\.amzn2023\.0\.2  | 
|  perl\-Browser\-Open  |  noarch  |  perl\-Browser\-Open  |  0\.04\-27\.amzn2023\.0\.2  | 
|  perl\-BSD\-Resource  |  aarch64  |  perl\-BSD\-Resource  |  1\.291\.100\-15\.amzn2023\.0\.2  | 
|  perl\-BSD\-Resource  |  x86\_64  |  perl\-BSD\-Resource  |  1\.291\.100\-15\.amzn2023\.0\.2  | 
|  perl\-Business\-ISBN  |  noarch  |  perl\-Business\-ISBN  |  3\.006\-2\.amzn2023\.0\.2  | 
|  perl\-Business\-ISBN\-Data  |  noarch  |  perl\-Business\-ISBN\-Data  |  20210112\.006\-1\.amzn2023\.0\.2  | 
|  perl\-Business\-ISMN  |  noarch  |  perl\-Business\-ISMN  |  1\.202\-1\.amzn2023\.0\.2  | 
|  perl\-Business\-ISSN  |  noarch  |  perl\-Business\-ISSN  |  1\.004\-4\.amzn2023\.0\.2  | 
|  perl\-B\-Utils  |  aarch64  |  perl\-B\-Utils  |  0\.27\-19\.amzn2023\.0\.2  | 
|  perl\-B\-Utils  |  x86\_64  |  perl\-B\-Utils  |  0\.27\-19\.amzn2023\.0\.2  | 
|  perl\-Canary\-Stability  |  noarch  |  perl\-Canary\-Stability  |  2013\-7\.amzn2023\.0\.2  | 
|  perl\-Capture\-Tiny  |  noarch  |  perl\-Capture\-Tiny  |  0\.48\-10\.amzn2023\.0\.2  | 
|  perl\-Carp  |  noarch  |  perl\-Carp  |  1\.50\-458\.amzn2023\.0\.2  | 
|  perl\-Carp\-Clan  |  noarch  |  perl\-Carp\-Clan  |  6\.08\-6\.amzn2023\.0\.2  | 
|  perl\-CGI  |  noarch  |  perl\-CGI  |  4\.52\-1\.amzn2023\.0\.2  | 
|  perl\-CGI\-tests  |  noarch  |  perl\-CGI  |  4\.52\-1\.amzn2023\.0\.2  | 
|  perl\-Class\-Accessor  |  noarch  |  perl\-Class\-Accessor  |  0\.51\-11\.amzn2023\.0\.2  | 
|  perl\-Class\-Data\-Inheritable  |  noarch  |  perl\-Class\-Data\-Inheritable  |  0\.08\-37\.amzn2023\.0\.2  | 
|  perl\-Class\-Inspector  |  noarch  |  perl\-Class\-Inspector  |  1\.36\-5\.amzn2023\.0\.2  | 
|  perl\-Class\-ISA  |  noarch  |  perl\-Class\-ISA  |  0\.36\-1032\.amzn2023\.0\.2  | 
|  perl\-Class\-Iterator  |  noarch  |  perl\-Class\-Iterator  |  0\.3\-26\.amzn2023\.0\.2  | 
|  perl\-Class\-Load  |  noarch  |  perl\-Class\-Load  |  0\.25\-14\.amzn2023\.0\.2  | 
|  perl\-Class\-Load\-XS  |  aarch64  |  perl\-Class\-Load\-XS  |  0\.10\-14\.amzn2023\.0\.2  | 
|  perl\-Class\-Load\-XS  |  x86\_64  |  perl\-Class\-Load\-XS  |  0\.10\-14\.amzn2023\.0\.2  | 
|  perl\-Class\-Method\-Modifiers  |  noarch  |  perl\-Class\-Method\-Modifiers  |  2\.13\-6\.amzn2023\.0\.2  | 
|  perl\-Class\-Singleton  |  noarch  |  perl\-Class\-Singleton  |  1\.6\-2\.amzn2023\.0\.2  | 
|  perl\-Class\-Tiny  |  noarch  |  perl\-Class\-Tiny  |  1\.008\-2\.amzn2023\.0\.2  | 
|  perl\-Class\-XSAccessor  |  aarch64  |  perl\-Class\-XSAccessor  |  1\.19\-23\.amzn2023\.0\.2  | 
|  perl\-Class\-XSAccessor  |  x86\_64  |  perl\-Class\-XSAccessor  |  1\.19\-23\.amzn2023\.0\.2  | 
|  perl\-Clone  |  aarch64  |  perl\-Clone  |  0\.45\-4\.amzn2023\.0\.2  | 
|  perl\-Clone  |  x86\_64  |  perl\-Clone  |  0\.45\-4\.amzn2023\.0\.2  | 
|  perl\-common\-sense  |  aarch64  |  perl\-common\-sense  |  3\.7\.5\-5\.amzn2023\.0\.2  | 
|  perl\-common\-sense  |  x86\_64  |  perl\-common\-sense  |  3\.7\.5\-5\.amzn2023\.0\.2  | 
|  perl\-Compress\-Bzip2  |  aarch64  |  perl\-Compress\-Bzip2  |  2\.28\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Bzip2  |  x86\_64  |  perl\-Compress\-Bzip2  |  2\.28\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Bzip2  |  aarch64  |  perl\-Compress\-Raw\-Bzip2  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Bzip2  |  x86\_64  |  perl\-Compress\-Raw\-Bzip2  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Bzip2\-tests  |  aarch64  |  perl\-Compress\-Raw\-Bzip2  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Bzip2\-tests  |  x86\_64  |  perl\-Compress\-Raw\-Bzip2  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Lzma  |  aarch64  |  perl\-Compress\-Raw\-Lzma  |  2\.101\-1\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Lzma  |  x86\_64  |  perl\-Compress\-Raw\-Lzma  |  2\.101\-1\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Zlib  |  aarch64  |  perl\-Compress\-Raw\-Zlib  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Zlib  |  x86\_64  |  perl\-Compress\-Raw\-Zlib  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Zlib\-tests  |  aarch64  |  perl\-Compress\-Raw\-Zlib  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Compress\-Raw\-Zlib\-tests  |  x86\_64  |  perl\-Compress\-Raw\-Zlib  |  2\.101\-3\.amzn2023\.0\.2  | 
|  perl\-Config\-Any  |  noarch  |  perl\-Config\-Any  |  0\.32\-14\.amzn2023\.0\.2  | 
|  perl\-Config\-AutoConf  |  noarch  |  perl\-Config\-AutoConf  |  0\.319\-3\.amzn2023\.0\.2  | 
|  perl\-Config\-General  |  noarch  |  perl\-Config\-General  |  2\.63\-14\.amzn2023\.0\.2  | 
|  perl\-Config\-Perl\-V  |  noarch  |  perl\-Config\-Perl\-V  |  0\.33\-2\.amzn2023\.0\.2  | 
|  perl\-Config\-Simple  |  noarch  |  perl\-Config\-Simple  |  4\.59\-36\.amzn2023\.0\.2  | 
|  perl\-Config\-Tiny  |  noarch  |  perl\-Config\-Tiny  |  2\.26\-1\.amzn2023\.0\.2  | 
|  perl\-constant  |  noarch  |  perl\-constant  |  1\.33\-459\.amzn2023\.0\.2  | 
|  perl\-constant\-boolean  |  noarch  |  perl\-constant\-boolean  |  0\.02\-30\.amzn2023\.0\.2  | 
|  perl\-constant\-defer  |  noarch  |  perl\-constant\-defer  |  6\-19\.amzn2023\.0\.2  | 
|  perl\-Const\-Fast  |  noarch  |  perl\-Const\-Fast  |  0\.014\-23\.amzn2023\.0\.2  | 
|  perl\-Contextual\-Return  |  noarch  |  perl\-Contextual\-Return  |  0\.004014\-14\.amzn2023\.0\.2  | 
|  perl\-Convert\-ASN1  |  noarch  |  perl\-Convert\-ASN1  |  0\.27\-22\.amzn2023\.0\.2  | 
|  perl\-Convert\-ASN1\-tests  |  noarch  |  perl\-Convert\-ASN1  |  0\.27\-22\.amzn2023\.0\.2  | 
|  perl\-CPAN  |  noarch  |  perl\-CPAN  |  2\.34\-1\.amzn2023\.0\.3  | 
|  perl\-CPAN\-tests  |  noarch  |  perl\-CPAN  |  2\.34\-1\.amzn2023\.0\.3  | 
|  perl\-CPAN\-Changes  |  noarch  |  perl\-CPAN\-Changes  |  0\.400002\-17\.amzn2023\.0\.2  | 
|  perl\-CPAN\-DistnameInfo  |  noarch  |  perl\-CPAN\-DistnameInfo  |  0\.12\-21\.amzn2023\.0\.2  | 
|  perl\-Cpanel\-JSON\-XS  |  aarch64  |  perl\-Cpanel\-JSON\-XS  |  4\.25\-2\.amzn2023\.0\.5  | 
|  perl\-Cpanel\-JSON\-XS  |  x86\_64  |  perl\-Cpanel\-JSON\-XS  |  4\.25\-2\.amzn2023\.0\.5  | 
|  perl\-CPAN\-Meta  |  noarch  |  perl\-CPAN\-Meta  |  2\.150010\-458\.amzn2023\.0\.2  | 
|  perl\-CPAN\-Meta\-Check  |  noarch  |  perl\-CPAN\-Meta\-Check  |  0\.014\-15\.amzn2023\.0\.2  | 
|  perl\-CPAN\-Meta\-Requirements  |  noarch  |  perl\-CPAN\-Meta\-Requirements  |  2\.140\-459\.amzn2023\.0\.2  | 
|  perl\-CPAN\-Meta\-YAML  |  noarch  |  perl\-CPAN\-Meta\-YAML  |  0\.018\-459\.amzn2023\.0\.2  | 
|  perl\-criticism  |  noarch  |  perl\-criticism  |  1\.02\-28\.amzn2023\.0\.2  | 
|  perl\-Crypt\-PasswdMD5  |  noarch  |  perl\-Crypt\-PasswdMD5  |  1\.4\.1\-1\.amzn2023\.0\.2  | 
|  perl\-Crypt\-RC4  |  noarch  |  perl\-Crypt\-RC4  |  2\.02\-27\.amzn2023\.0\.2  | 
|  perl\-CSS\-Tiny  |  noarch  |  perl\-CSS\-Tiny  |  1\.20\-15\.amzn2023\.0\.2  | 
|  perl\-Curses  |  aarch64  |  perl\-Curses  |  1\.37\-2\.amzn2023\.0\.2  | 
|  perl\-Curses  |  x86\_64  |  perl\-Curses  |  1\.37\-2\.amzn2023\.0\.2  | 
|  perl\-Cwd\-Guard  |  noarch  |  perl\-Cwd\-Guard  |  0\.05\-15\.amzn2023\.0\.2  | 
|  perl\-Data\-Binary  |  noarch  |  perl\-Data\-Binary  |  0\.01\-8\.amzn2023\.0\.2  | 
|  perl\-Data\-Compare  |  noarch  |  perl\-Data\-Compare  |  1\.27\-5\.amzn2023\.0\.2  | 
|  perl\-Data\-Dump  |  noarch  |  perl\-Data\-Dump  |  1\.23\-16\.amzn2023\.0\.2  | 
|  perl\-Data\-Dumper  |  aarch64  |  perl\-Data\-Dumper  |  2\.174\-460\.amzn2023\.0\.2  | 
|  perl\-Data\-Dumper  |  x86\_64  |  perl\-Data\-Dumper  |  2\.174\-460\.amzn2023\.0\.2  | 
|  perl\-Data\-Dump\-Streamer  |  aarch64  |  perl\-Data\-Dump\-Streamer  |  2\.40\-17\.amzn2023\.0\.2  | 
|  perl\-Data\-Dump\-Streamer  |  x86\_64  |  perl\-Data\-Dump\-Streamer  |  2\.40\-17\.amzn2023\.0\.2  | 
|  perl\-Data\-OptList  |  noarch  |  perl\-Data\-OptList  |  0\.110\-15\.amzn2023\.0\.2  | 
|  perl\-Data\-Perl  |  noarch  |  perl\-Data\-Perl  |  0\.002011\-4\.amzn2023\.0\.2  | 
|  perl\-Data\-Section  |  noarch  |  perl\-Data\-Section  |  0\.200007\-12\.amzn2023\.0\.2  | 
|  perl\-Data\-Section\-Simple  |  noarch  |  perl\-Data\-Section\-Simple  |  0\.07\-21\.amzn2023\.0\.2  | 
|  perl\-Data\-Uniqid  |  noarch  |  perl\-Data\-Uniqid  |  0\.12\-24\.amzn2023\.0\.2  | 
|  perl\-Data\-UUID  |  aarch64  |  perl\-Data\-UUID  |  1\.226\-4\.amzn2023\.0\.2  | 
|  perl\-Data\-UUID  |  x86\_64  |  perl\-Data\-UUID  |  1\.226\-4\.amzn2023\.0\.2  | 
|  perl\-Data\-Visitor  |  noarch  |  perl\-Data\-Visitor  |  0\.31\-2\.amzn2023\.0\.2  | 
|  perl\-Date\-Calc  |  noarch  |  perl\-Date\-Calc  |  6\.4\-18\.amzn2023\.0\.2  | 
|  perl\-Date\-ISO8601  |  noarch  |  perl\-Date\-ISO8601  |  0\.005\-11\.amzn2023\.0\.2  | 
|  perl\-Date\-Manip  |  noarch  |  perl\-Date\-Manip  |  6\.85\-1\.amzn2023\.0\.2  | 
|  perl\-Date\-Simple  |  aarch64  |  perl\-Date\-Simple  |  3\.03\-38\.amzn2023\.0\.2  | 
|  perl\-Date\-Simple  |  x86\_64  |  perl\-Date\-Simple  |  3\.03\-38\.amzn2023\.0\.2  | 
|  perl\-DateTime  |  aarch64  |  perl\-DateTime  |  1\.54\-2\.amzn2023\.0\.2  | 
|  perl\-DateTime  |  x86\_64  |  perl\-DateTime  |  1\.54\-2\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Calendar\-Julian  |  noarch  |  perl\-DateTime\-Calendar\-Julian  |  0\.103\-2\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Calendar\-Mayan  |  noarch  |  perl\-DateTime\-Calendar\-Mayan  |  0\.0601\-35\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-Builder  |  noarch  |  perl\-DateTime\-Format\-Builder  |  0\.8300\-3\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-DateParse  |  noarch  |  perl\-DateTime\-Format\-DateParse  |  0\.05\-25\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-HTTP  |  noarch  |  perl\-DateTime\-Format\-HTTP  |  0\.42\-19\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-IBeat  |  noarch  |  perl\-DateTime\-Format\-IBeat  |  0\.161\-39\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-Mail  |  noarch  |  perl\-DateTime\-Format\-Mail  |  0\.403\-14\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-MySQL  |  noarch  |  perl\-DateTime\-Format\-MySQL  |  0\.06\-16\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-Pg  |  noarch  |  perl\-DateTime\-Format\-Pg  |  0\.16014\-1\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-Pg\-tests  |  noarch  |  perl\-DateTime\-Format\-Pg  |  0\.16014\-1\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-SQLite  |  noarch  |  perl\-DateTime\-Format\-SQLite  |  0\.11\-32\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Format\-Strptime  |  noarch  |  perl\-DateTime\-Format\-Strptime  |  1\.78\-2\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Locale  |  noarch  |  perl\-DateTime\-Locale  |  1\.32\-1\.amzn2023\.0\.2  | 
|  perl\-DateTime\-Locale\-tests  |  noarch  |  perl\-DateTime\-Locale  |  1\.32\-1\.amzn2023\.0\.2  | 
|  perl\-DateTime\-TimeZone  |  noarch  |  perl\-DateTime\-TimeZone  |  2\.51\-1\.amzn2023\.0\.2  | 
|  perl\-DateTime\-TimeZone\-SystemV  |  noarch  |  perl\-DateTime\-TimeZone\-SystemV  |  0\.010\-12\.amzn2023\.0\.2  | 
|  perl\-DateTime\-TimeZone\-Tzfile  |  noarch  |  perl\-DateTime\-TimeZone\-Tzfile  |  0\.011\-12\.amzn2023\.0\.2  | 
|  perl\-DB\_File  |  aarch64  |  perl\-DB\_File  |  1\.855\-2\.amzn2023\.0\.2  | 
|  perl\-DB\_File  |  x86\_64  |  perl\-DB\_File  |  1\.855\-2\.amzn2023\.0\.2  | 
|  perl\-DBD\-CSV  |  noarch  |  perl\-DBD\-CSV  |  0\.58\-1\.amzn2023\.0\.2  | 
|  perl\-DBD\-MariaDB  |  aarch64  |  perl\-DBD\-MariaDB  |  1\.22\-1\.amzn2023\.0\.4  | 
|  perl\-DBD\-MariaDB  |  x86\_64  |  perl\-DBD\-MariaDB  |  1\.22\-1\.amzn2023\.0\.4  | 
|  perl\-DBD\-MariaDB\-tests  |  aarch64  |  perl\-DBD\-MariaDB  |  1\.22\-1\.amzn2023\.0\.4  | 
|  perl\-DBD\-MariaDB\-tests  |  x86\_64  |  perl\-DBD\-MariaDB  |  1\.22\-1\.amzn2023\.0\.4  | 
|  perl\-DBD\-MySQL  |  aarch64  |  perl\-DBD\-MySQL  |  4\.050\-10\.amzn2023\.0\.2  | 
|  perl\-DBD\-MySQL  |  x86\_64  |  perl\-DBD\-MySQL  |  4\.050\-10\.amzn2023\.0\.2  | 
|  perl\-DBD\-Pg  |  aarch64  |  perl\-DBD\-Pg  |  3\.14\.2\-3\.amzn2023\.0\.4  | 
|  perl\-DBD\-Pg  |  x86\_64  |  perl\-DBD\-Pg  |  3\.14\.2\-3\.amzn2023\.0\.4  | 
|  perl\-DBD\-SQLite  |  aarch64  |  perl\-DBD\-SQLite  |  1\.66\-3\.amzn2023\.0\.3  | 
|  perl\-DBD\-SQLite  |  x86\_64  |  perl\-DBD\-SQLite  |  1\.66\-3\.amzn2023\.0\.3  | 
|  perl\-DBI  |  aarch64  |  perl\-DBI  |  1\.643\-7\.amzn2023\.0\.3  | 
|  perl\-DBI  |  x86\_64  |  perl\-DBI  |  1\.643\-7\.amzn2023\.0\.3  | 
|  perl\-DBIx\-ContextualFetch  |  noarch  |  perl\-DBIx\-ContextualFetch  |  1\.03\-41\.amzn2023\.0\.2  | 
|  perl\-DBM\-Deep  |  noarch  |  perl\-DBM\-Deep  |  2\.0016\-10\.amzn2023\.0\.2  | 
|  perl\-Declare\-Constraints\-Simple  |  noarch  |  perl\-Declare\-Constraints\-Simple  |  0\.03\-43\.amzn2023\.0\.2  | 
|  perl\-Devel\-CallChecker  |  aarch64  |  perl\-Devel\-CallChecker  |  0\.008\-12\.amzn2023\.0\.2  | 
|  perl\-Devel\-CallChecker  |  x86\_64  |  perl\-Devel\-CallChecker  |  0\.008\-12\.amzn2023\.0\.2  | 
|  perl\-Devel\-Caller  |  aarch64  |  perl\-Devel\-Caller  |  2\.06\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-Caller  |  x86\_64  |  perl\-Devel\-Caller  |  2\.06\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-CallParser  |  aarch64  |  perl\-Devel\-CallParser  |  0\.002\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-CallParser  |  x86\_64  |  perl\-Devel\-CallParser  |  0\.002\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-CheckBin  |  noarch  |  perl\-Devel\-CheckBin  |  0\.04\-16\.amzn2023\.0\.2  | 
|  perl\-Devel\-CheckCompiler  |  noarch  |  perl\-Devel\-CheckCompiler  |  0\.07\-15\.amzn2023\.0\.2  | 
|  perl\-Devel\-CheckLib  |  noarch  |  perl\-Devel\-CheckLib  |  1\.14\-6\.amzn2023\.0\.2  | 
|  perl\-Devel\-Cover  |  aarch64  |  perl\-Devel\-Cover  |  1\.36\-4\.amzn2023\.0\.2  | 
|  perl\-Devel\-Cover  |  x86\_64  |  perl\-Devel\-Cover  |  1\.36\-4\.amzn2023\.0\.2  | 
|  perl\-Devel\-Cycle  |  noarch  |  perl\-Devel\-Cycle  |  1\.12\-20\.amzn2023\.0\.2  | 
|  perl\-Devel\-Declare  |  aarch64  |  perl\-Devel\-Declare  |  0\.006022\-5\.amzn2023\.0\.2  | 
|  perl\-Devel\-Declare  |  x86\_64  |  perl\-Devel\-Declare  |  0\.006022\-5\.amzn2023\.0\.2  | 
|  perl\-Devel\-EnforceEncapsulation  |  noarch  |  perl\-Devel\-EnforceEncapsulation  |  0\.51\-21\.amzn2023\.0\.2  | 
|  perl\-Devel\-FindPerl  |  noarch  |  perl\-Devel\-FindPerl  |  0\.015\-8\.amzn2023\.0\.2  | 
|  perl\-Devel\-GlobalDestruction  |  noarch  |  perl\-Devel\-GlobalDestruction  |  0\.14\-14\.amzn2023\.0\.2  | 
|  perl\-Devel\-Hide  |  noarch  |  perl\-Devel\-Hide  |  0\.0013\-4\.amzn2023\.0\.2  | 
|  perl\-Devel\-Leak  |  aarch64  |  perl\-Devel\-Leak  |  0\.03\-45\.amzn2023\.0\.2  | 
|  perl\-Devel\-Leak  |  x86\_64  |  perl\-Devel\-Leak  |  0\.03\-45\.amzn2023\.0\.2  | 
|  perl\-Devel\-LexAlias  |  aarch64  |  perl\-Devel\-LexAlias  |  0\.05\-25\.amzn2023\.0\.2  | 
|  perl\-Devel\-LexAlias  |  x86\_64  |  perl\-Devel\-LexAlias  |  0\.05\-25\.amzn2023\.0\.2  | 
|  perl\-Devel\-OverloadInfo  |  noarch  |  perl\-Devel\-OverloadInfo  |  0\.005\-11\.amzn2023\.0\.2  | 
|  perl\-Devel\-PartialDump  |  noarch  |  perl\-Devel\-PartialDump  |  0\.20\-12\.amzn2023\.0\.2  | 
|  perl\-Devel\-PPPort  |  aarch64  |  perl\-Devel\-PPPort  |  3\.62\-2\.amzn2023\.0\.2  | 
|  perl\-Devel\-PPPort  |  x86\_64  |  perl\-Devel\-PPPort  |  3\.62\-2\.amzn2023\.0\.2  | 
|  perl\-Devel\-Refcount  |  aarch64  |  perl\-Devel\-Refcount  |  0\.10\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-Refcount  |  x86\_64  |  perl\-Devel\-Refcount  |  0\.10\-24\.amzn2023\.0\.2  | 
|  perl\-Devel\-Size  |  aarch64  |  perl\-Devel\-Size  |  0\.83\-8\.amzn2023\.0\.2  | 
|  perl\-Devel\-Size  |  x86\_64  |  perl\-Devel\-Size  |  0\.83\-8\.amzn2023\.0\.2  | 
|  perl\-Devel\-StackTrace  |  noarch  |  perl\-Devel\-StackTrace  |  2\.04\-8\.amzn2023\.0\.2  | 
|  perl\-Devel\-Symdump  |  noarch  |  perl\-Devel\-Symdump  |  2\.18\-17\.amzn2023\.0\.2  | 
|  perl\-Digest  |  noarch  |  perl\-Digest  |  1\.20\-1\.amzn2023\.0\.2  | 
|  perl\-Digest\-CRC  |  aarch64  |  perl\-Digest\-CRC  |  0\.22\.2\-14\.amzn2023\.0\.2  | 
|  perl\-Digest\-CRC  |  x86\_64  |  perl\-Digest\-CRC  |  0\.22\.2\-14\.amzn2023\.0\.2  | 
|  perl\-Digest\-HMAC  |  noarch  |  perl\-Digest\-HMAC  |  1\.03\-27\.amzn2023\.0\.2  | 
|  perl\-Digest\-MD4  |  aarch64  |  perl\-Digest\-MD4  |  1\.9\-27\.amzn2023\.0\.2  | 
|  perl\-Digest\-MD4  |  x86\_64  |  perl\-Digest\-MD4  |  1\.9\-27\.amzn2023\.0\.2  | 
|  perl\-Digest\-MD5  |  aarch64  |  perl\-Digest\-MD5  |  2\.58\-2\.amzn2023\.0\.2  | 
|  perl\-Digest\-MD5  |  x86\_64  |  perl\-Digest\-MD5  |  2\.58\-2\.amzn2023\.0\.2  | 
|  perl\-Digest\-Perl\-MD5  |  noarch  |  perl\-Digest\-Perl\-MD5  |  1\.9\-22\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA  |  aarch64  |  perl\-Digest\-SHA  |  6\.02\-459\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA  |  x86\_64  |  perl\-Digest\-SHA  |  6\.02\-459\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA1  |  aarch64  |  perl\-Digest\-SHA1  |  2\.13\-32\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA1  |  x86\_64  |  perl\-Digest\-SHA1  |  2\.13\-32\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA3  |  aarch64  |  perl\-Digest\-SHA3  |  1\.04\-10\.amzn2023\.0\.2  | 
|  perl\-Digest\-SHA3  |  x86\_64  |  perl\-Digest\-SHA3  |  1\.04\-10\.amzn2023\.0\.2  | 
|  sha3sum  |  noarch  |  perl\-Digest\-SHA3  |  1\.04\-10\.amzn2023\.0\.2  | 
|  perl\-Dir\-Self  |  noarch  |  perl\-Dir\-Self  |  0\.11\-18\.amzn2023\.0\.2  | 
|  perl\-Dist\-CheckConflicts  |  noarch  |  perl\-Dist\-CheckConflicts  |  0\.11\-21\.amzn2023\.0\.2  | 
|  perl\-DynaLoader\-Functions  |  noarch  |  perl\-DynaLoader\-Functions  |  0\.003\-11\.amzn2023\.0\.2  | 
|  perl\-Email\-Date\-Format  |  noarch  |  perl\-Email\-Date\-Format  |  1\.005\-18\.amzn2023\.0\.2  | 
|  perl\-Encode  |  aarch64  |  perl\-Encode  |  3\.15\-462\.amzn2023\.0\.2  | 
|  perl\-Encode  |  x86\_64  |  perl\-Encode  |  3\.15\-462\.amzn2023\.0\.2  | 
|  perl\-Encode\-devel  |  aarch64  |  perl\-Encode  |  3\.15\-462\.amzn2023\.0\.2  | 
|  perl\-Encode\-devel  |  x86\_64  |  perl\-Encode  |  3\.15\-462\.amzn2023\.0\.2  | 
|  perl\-encoding  |  aarch64  |  perl\-Encode  |  3\.00\-462\.amzn2023\.0\.2  | 
|  perl\-encoding  |  x86\_64  |  perl\-Encode  |  3\.00\-462\.amzn2023\.0\.2  | 
|  perl\-Encode\-EUCJPASCII  |  aarch64  |  perl\-Encode\-EUCJPASCII  |  0\.03\-32\.amzn2023\.0\.2  | 
|  perl\-Encode\-EUCJPASCII  |  x86\_64  |  perl\-Encode\-EUCJPASCII  |  0\.03\-32\.amzn2023\.0\.2  | 
|  perl\-Encode\-HanExtra  |  aarch64  |  perl\-Encode\-HanExtra  |  0\.23\-32\.amzn2023\.0\.2  | 
|  perl\-Encode\-HanExtra  |  x86\_64  |  perl\-Encode\-HanExtra  |  0\.23\-32\.amzn2023\.0\.2  | 
|  perl\-Encode\-JIS2K  |  aarch64  |  perl\-Encode\-JIS2K  |  0\.03\-17\.amzn2023\.0\.2  | 
|  perl\-Encode\-JIS2K  |  x86\_64  |  perl\-Encode\-JIS2K  |  0\.03\-17\.amzn2023\.0\.2  | 
|  perl\-Encode\-Locale  |  noarch  |  perl\-Encode\-Locale  |  1\.05\-19\.amzn2023\.0\.2  | 
|  perl\-Env  |  noarch  |  perl\-Env  |  1\.04\-458\.amzn2023\.0\.2  | 
|  perl\-Env\-Sanctify  |  noarch  |  perl\-Env\-Sanctify  |  1\.12\-22\.amzn2023\.0\.2  | 
|  perl\-Error  |  noarch  |  perl\-Error  |  0\.17029\-5\.amzn2023\.0\.2  | 
|  perl\-Eval\-Closure  |  noarch  |  perl\-Eval\-Closure  |  0\.14\-14\.amzn2023\.0\.2  | 
|  perl\-Exception\-Base  |  noarch  |  perl\-Exception\-Base  |  0\.2501\-16\.amzn2023\.0\.2  | 
|  perl\-Exception\-Class  |  noarch  |  perl\-Exception\-Class  |  1\.44\-11\.amzn2023\.0\.2  | 
|  perl\-Expect  |  noarch  |  perl\-Expect  |  1\.35\-14\.amzn2023\.0\.2  | 
|  perl\-experimental  |  noarch  |  perl\-experimental  |  0\.025\-1\.amzn2023\.0\.2  | 
|  perl\-experimental\-tests  |  noarch  |  perl\-experimental  |  0\.025\-1\.amzn2023\.0\.2  | 
|  perl\-Exporter  |  noarch  |  perl\-Exporter  |  5\.74\-459\.amzn2023\.0\.2  | 
|  perl\-Exporter\-Tiny  |  noarch  |  perl\-Exporter\-Tiny  |  1\.002002\-4\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-CBuilder  |  noarch  |  perl\-ExtUtils\-CBuilder  |  0\.280236\-2\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-CBuilder\-tests  |  noarch  |  perl\-ExtUtils\-CBuilder  |  0\.280236\-2\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Config  |  noarch  |  perl\-ExtUtils\-Config  |  0\.008\-22\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Depends  |  noarch  |  perl\-ExtUtils\-Depends  |  0\.8000\-7\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-HasCompiler  |  noarch  |  perl\-ExtUtils\-HasCompiler  |  0\.023\-2\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Helpers  |  noarch  |  perl\-ExtUtils\-Helpers  |  0\.026\-16\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Install  |  noarch  |  perl\-ExtUtils\-Install  |  2\.20\-2\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-InstallPaths  |  noarch  |  perl\-ExtUtils\-InstallPaths  |  0\.012\-11\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-LibBuilder  |  noarch  |  perl\-ExtUtils\-LibBuilder  |  0\.08\-16\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Command  |  noarch  |  perl\-ExtUtils\-MakeMaker  |  7\.62\-1\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-MakeMaker  |  noarch  |  perl\-ExtUtils\-MakeMaker  |  7\.62\-1\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-MakeMaker\-tests  |  noarch  |  perl\-ExtUtils\-MakeMaker  |  7\.62\-1\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-MM\-Utils  |  noarch  |  perl\-ExtUtils\-MakeMaker  |  7\.62\-1\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-MakeMaker\-CPANfile  |  noarch  |  perl\-ExtUtils\-MakeMaker\-CPANfile  |  0\.09\-8\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-Manifest  |  noarch  |  perl\-ExtUtils\-Manifest  |  1\.73\-2\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-ParseXS  |  noarch  |  perl\-ExtUtils\-ParseXS  |  3\.40\-458\.amzn2023\.0\.2  | 
|  perl\-ExtUtils\-PkgConfig  |  noarch  |  perl\-ExtUtils\-PkgConfig  |  1\.16\-14\.amzn2023\.0\.2  | 
|  perl\-Fedora\-VSP  |  noarch  |  perl\-Fedora\-VSP  |  0\.001\-21\.amzn2023\.0\.2  | 
|  perl\-File\-BaseDir  |  noarch  |  perl\-File\-BaseDir  |  0\.08\-10\.amzn2023\.0\.2  | 
|  perl\-File\-UserDirs  |  noarch  |  perl\-File\-BaseDir  |  0\.08\-10\.amzn2023\.0\.2  | 
|  perl\-File\-Copy\-Recursive  |  noarch  |  perl\-File\-Copy\-Recursive  |  0\.45\-5\.amzn2023\.0\.2  | 
|  perl\-File\-Copy\-Recursive\-Reduced  |  noarch  |  perl\-File\-Copy\-Recursive\-Reduced  |  0\.006\-10\.amzn2023\.0\.2  | 
|  perl\-File\-DesktopEntry  |  noarch  |  perl\-File\-DesktopEntry  |  0\.22\-16\.amzn2023\.0\.2  | 
|  perl\-File\-Fetch  |  noarch  |  perl\-File\-Fetch  |  1\.00\-2\.amzn2023\.0\.2  | 
|  perl\-File\-Find\-Iterator  |  noarch  |  perl\-File\-Find\-Iterator  |  0\.4\-26\.amzn2023\.0\.2  | 
|  perl\-File\-Find\-Object  |  noarch  |  perl\-File\-Find\-Object  |  0\.3\.5\-5\.amzn2023\.0\.2  | 
|  perl\-File\-Find\-Object\-Rule  |  noarch  |  perl\-File\-Find\-Object\-Rule  |  0\.0312\-5\.amzn2023\.0\.2  | 
|  perl\-File\-Find\-Rule  |  noarch  |  perl\-File\-Find\-Rule  |  0\.34\-17\.amzn2023\.0\.2  | 
|  perl\-File\-Find\-Rule\-Perl  |  noarch  |  perl\-File\-Find\-Rule\-Perl  |  1\.15\-19\.amzn2023\.0\.2  | 
|  perl\-FileHandle\-Fmode  |  aarch64  |  perl\-FileHandle\-Fmode  |  0\.14\-17\.amzn2023\.0\.2  | 
|  perl\-FileHandle\-Fmode  |  x86\_64  |  perl\-FileHandle\-Fmode  |  0\.14\-17\.amzn2023\.0\.2  | 
|  perl\-File\-HomeDir  |  noarch  |  perl\-File\-HomeDir  |  1\.006\-2\.amzn2023\.0\.2  | 
|  perl\-File\-Inplace  |  noarch  |  perl\-File\-Inplace  |  0\.20\-28\.amzn2023\.0\.2  | 
|  perl\-File\-Listing  |  noarch  |  perl\-File\-Listing  |  6\.14\-2\.amzn2023\.0\.2  | 
|  perl\-File\-MimeInfo  |  noarch  |  perl\-File\-MimeInfo  |  0\.30\-2\.amzn2023\.0\.2  | 
|  perl\-File\-Path  |  noarch  |  perl\-File\-Path  |  2\.18\-2\.amzn2023\.0\.2  | 
|  perl\-File\-PathList  |  noarch  |  perl\-File\-PathList  |  1\.04\-29\.amzn2023\.0\.2  | 
|  perl\-File\-pushd  |  noarch  |  perl\-File\-pushd  |  1\.016\-10\.amzn2023\.0\.2  | 
|  perl\-File\-ReadBackwards  |  noarch  |  perl\-File\-ReadBackwards  |  1\.05\-21\.amzn2023\.0\.2  | 
|  perl\-File\-Remove  |  noarch  |  perl\-File\-Remove  |  1\.60\-2\.amzn2023\.0\.2  | 
|  perl\-File\-ShareDir  |  noarch  |  perl\-File\-ShareDir  |  1\.118\-2\.amzn2023\.0\.2  | 
|  perl\-File\-ShareDir\-Install  |  noarch  |  perl\-File\-ShareDir\-Install  |  0\.13\-11\.amzn2023\.0\.2  | 
|  perl\-File\-Slurp  |  noarch  |  perl\-File\-Slurp  |  9999\.32\-3\.amzn2023\.0\.2  | 
|  perl\-File\-Slurper  |  noarch  |  perl\-File\-Slurper  |  0\.012\-10\.amzn2023\.0\.2  | 
|  perl\-File\-Slurp\-Tiny  |  noarch  |  perl\-File\-Slurp\-Tiny  |  0\.004\-16\.amzn2023\.0\.2  | 
|  perl\-File\-Temp  |  noarch  |  perl\-File\-Temp  |  0\.231\.100\-2\.amzn2023\.0\.2  | 
|  perl\-File\-Type  |  noarch  |  perl\-File\-Type  |  0\.22\-39\.amzn2023\.0\.2  | 
|  perl\-File\-Which  |  noarch  |  perl\-File\-Which  |  1\.23\-8\.amzn2023\.0\.2  | 
|  perl\-Filter  |  aarch64  |  perl\-Filter  |  1\.60\-2\.amzn2023\.0\.2  | 
|  perl\-Filter  |  x86\_64  |  perl\-Filter  |  1\.60\-2\.amzn2023\.0\.2  | 
|  perl\-Filter\-Simple  |  noarch  |  perl\-Filter\-Simple  |  0\.96\-458\.amzn2023\.0\.2  | 
|  perl\-Font\-AFM  |  noarch  |  perl\-Font\-AFM  |  1\.20\-35\.amzn2023\.0\.2  | 
|  perl\-Font\-TTF  |  noarch  |  perl\-Font\-TTF  |  1\.06\-15\.amzn2023\.0\.2  | 
|  perl\-Font\-TTF\-XMLparse  |  noarch  |  perl\-Font\-TTF  |  1\.06\-15\.amzn2023\.0\.2  | 
|  perl\-FreezeThaw  |  noarch  |  perl\-FreezeThaw  |  0\.5001\-35\.amzn2023\.0\.2  | 
|  perl\-Function\-Parameters  |  aarch64  |  perl\-Function\-Parameters  |  2\.1\.3\-11\.amzn2023\.0\.2  | 
|  perl\-Function\-Parameters  |  x86\_64  |  perl\-Function\-Parameters  |  2\.1\.3\-11\.amzn2023\.0\.2  | 
|  perl\-GD  |  aarch64  |  perl\-GD  |  2\.73\-2\.amzn2023\.0\.2  | 
|  perl\-GD  |  x86\_64  |  perl\-GD  |  2\.73\-2\.amzn2023\.0\.2  | 
|  perl\-GD\-Barcode  |  noarch  |  perl\-GD\-Barcode  |  1\.15\-37\.amzn2023\.0\.2  | 
|  perl\-generators  |  noarch  |  perl\-generators  |  1\.13\-1\.amzn2023\.0\.2  | 
|  perl\-Getopt\-ArgvFile  |  noarch  |  perl\-Getopt\-ArgvFile  |  1\.11\-34\.amzn2023\.0\.2  | 
|  perl\-Getopt\-Long  |  noarch  |  perl\-Getopt\-Long  |  2\.52\-2\.amzn2023\.0\.2  | 
|  perl\-Getopt\-Long\-Descriptive  |  noarch  |  perl\-Getopt\-Long\-Descriptive  |  0\.109\-1\.amzn2023\.0\.2  | 
|  perl\-Locale\-gettext  |  aarch64  |  perl\-gettext  |  1\.07\-19\.amzn2023\.0\.2  | 
|  perl\-Locale\-gettext  |  x86\_64  |  perl\-gettext  |  1\.07\-19\.amzn2023\.0\.2  | 
|  perl\-Graph  |  noarch  |  perl\-Graph  |  0\.97\.16\-2\.amzn2023\.0\.2  | 
|  perl\-Graphics\-TIFF  |  aarch64  |  perl\-Graphics\-TIFF  |  18\-4\.amzn2023  | 
|  perl\-Graphics\-TIFF  |  x86\_64  |  perl\-Graphics\-TIFF  |  18\-4\.amzn2023  | 
|  perl\-Graphics\-TIFF\-tests  |  noarch  |  perl\-Graphics\-TIFF  |  18\-4\.amzn2023  | 
|  perl\-GraphViz  |  noarch  |  perl\-GraphViz  |  2\.24\-16\.amzn2023\.0\.2  | 
|  perl\-GraphViz\-XML  |  noarch  |  perl\-GraphViz  |  2\.24\-16\.amzn2023\.0\.2  | 
|  perl\-GSSAPI  |  aarch64  |  perl\-GSSAPI  |  0\.28\-35\.amzn2023\.0\.2  | 
|  perl\-GSSAPI  |  x86\_64  |  perl\-GSSAPI  |  0\.28\-35\.amzn2023\.0\.2  | 
|  perl\-Hash\-FieldHash  |  aarch64  |  perl\-Hash\-FieldHash  |  0\.15\-16\.amzn2023\.0\.2  | 
|  perl\-Hash\-FieldHash  |  x86\_64  |  perl\-Hash\-FieldHash  |  0\.15\-16\.amzn2023\.0\.2  | 
|  perl\-Hash\-Util\-FieldHash\-Compat  |  noarch  |  perl\-Hash\-Util\-FieldHash\-Compat  |  0\.11\-16\.amzn2023\.0\.2  | 
|  perl\-Heap  |  noarch  |  perl\-Heap  |  0\.80\-35\.amzn2023\.0\.2  | 
|  perl\-Hook\-LexWrap  |  noarch  |  perl\-Hook\-LexWrap  |  0\.26\-13\.amzn2023\.0\.2  | 
|  perl\-HTML\-Form  |  noarch  |  perl\-HTML\-Form  |  6\.07\-4\.amzn2023\.0\.2  | 
|  perl\-HTML\-Formatter  |  noarch  |  perl\-HTML\-Format  |  2\.16\-15\.amzn2023\.0\.2  | 
|  perl\-HTML\-FormatText\-WithLinks  |  noarch  |  perl\-HTML\-FormatText\-WithLinks  |  0\.15\-18\.amzn2023\.0\.2  | 
|  perl\-HTML\-FormatText\-WithLinks\-AndTables  |  noarch  |  perl\-HTML\-FormatText\-WithLinks\-AndTables  |  0\.07\-14\.amzn2023\.0\.2  | 
|  perl\-HTML\-Parser  |  aarch64  |  perl\-HTML\-Parser  |  3\.76\-1\.amzn2023\.0\.2  | 
|  perl\-HTML\-Parser  |  x86\_64  |  perl\-HTML\-Parser  |  3\.76\-1\.amzn2023\.0\.2  | 
|  perl\-HTML\-Parser\-tests  |  aarch64  |  perl\-HTML\-Parser  |  3\.76\-1\.amzn2023\.0\.2  | 
|  perl\-HTML\-Parser\-tests  |  x86\_64  |  perl\-HTML\-Parser  |  3\.76\-1\.amzn2023\.0\.2  | 
|  perl\-HTML\-Tagset  |  noarch  |  perl\-HTML\-Tagset  |  3\.20\-45\.amzn2023\.0\.2  | 
|  perl\-HTML\-Tree  |  noarch  |  perl\-HTML\-Tree  |  5\.07\-14\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Cookies  |  noarch  |  perl\-HTTP\-Cookies  |  6\.10\-2\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Daemon  |  noarch  |  perl\-HTTP\-Daemon  |  6\.16\-1\.amzn2023  | 
|  perl\-HTTP\-Daemon\-tests  |  noarch  |  perl\-HTTP\-Daemon  |  6\.16\-1\.amzn2023  | 
|  perl\-HTTP\-Date  |  noarch  |  perl\-HTTP\-Date  |  6\.05\-5\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Message  |  noarch  |  perl\-HTTP\-Message  |  6\.34\-1\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Message\-tests  |  noarch  |  perl\-HTTP\-Message  |  6\.34\-1\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Negotiate  |  noarch  |  perl\-HTTP\-Negotiate  |  6\.01\-28\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Server\-Simple  |  noarch  |  perl\-HTTP\-Server\-Simple  |  0\.52\-14\.amzn2023\.0\.2  | 
|  perl\-HTTP\-Tiny  |  noarch  |  perl\-HTTP\-Tiny  |  0\.078\-1\.amzn2023\.0\.3  | 
|  perl\-HTTP\-Tiny\-tests  |  noarch  |  perl\-HTTP\-Tiny  |  0\.078\-1\.amzn2023\.0\.3  | 
|  perl\-Image\-Base  |  noarch  |  perl\-Image\-Base  |  1\.17\-19\.amzn2023\.0\.2  | 
|  perl\-Image\-Info  |  noarch  |  perl\-Image\-Info  |  1\.42\-5\.amzn2023\.0\.2  | 
|  perl\-Image\-Size  |  noarch  |  perl\-Image\-Size  |  3\.300\-20\.amzn2023\.0\.2  | 
|  perl\-Image\-Xbm  |  noarch  |  perl\-Image\-Xbm  |  1\.10\-15\.amzn2023\.0\.2  | 
|  perl\-Image\-Xpm  |  noarch  |  perl\-Image\-Xpm  |  1\.13\-14\.amzn2023\.0\.2  | 
|  perl\-Importer  |  noarch  |  perl\-Importer  |  0\.026\-2\.amzn2023\.0\.2  | 
|  perl\-Import\-Into  |  noarch  |  perl\-Import\-Into  |  1\.002005\-17\.amzn2023\.0\.2  | 
|  perl\-inc\-latest  |  noarch  |  perl\-inc\-latest  |  0\.500\-18\.amzn2023\.0\.2  | 
|  perl\-indirect  |  aarch64  |  perl\-indirect  |  0\.39\-8\.amzn2023\.0\.2  | 
|  perl\-indirect  |  x86\_64  |  perl\-indirect  |  0\.39\-8\.amzn2023\.0\.2  | 
|  perl\-IO\-All  |  noarch  |  perl\-IO\-All  |  0\.87\-13\.amzn2023\.0\.2  | 
|  perl\-IO\-CaptureOutput  |  noarch  |  perl\-IO\-CaptureOutput  |  1\.1105\-5\.amzn2023\.0\.2  | 
|  perl\-IO\-Compress  |  noarch  |  perl\-IO\-Compress  |  2\.102\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-Compress\-tests  |  noarch  |  perl\-IO\-Compress  |  2\.102\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-Compress\-Lzma  |  noarch  |  perl\-IO\-Compress\-Lzma  |  2\.101\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-HTML  |  noarch  |  perl\-IO\-HTML  |  1\.004\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-Pipely  |  noarch  |  perl\-IO\-Pipely  |  0\.005\-21\.amzn2023\.0\.2  | 
|  perl\-IO\-Socket\-INET6  |  noarch  |  perl\-IO\-Socket\-INET6  |  2\.72\-22\.amzn2023\.0\.2  | 
|  perl\-IO\-Socket\-IP  |  noarch  |  perl\-IO\-Socket\-IP  |  0\.41\-3\.amzn2023\.0\.2  | 
|  perl\-IO\-Socket\-SSL  |  noarch  |  perl\-IO\-Socket\-SSL  |  2\.075\-1\.amzn2023\.0\.2  | 
|  perl\-IO\-String  |  noarch  |  perl\-IO\-String  |  1\.08\-41\.amzn2023\.0\.2  | 
|  perl\-IO\-stringy  |  noarch  |  perl\-IO\-stringy  |  2\.113\-5\.amzn2023\.0\.2  | 
|  perl\-IO\-Tty  |  aarch64  |  perl\-IO\-Tty  |  1\.16\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-Tty  |  x86\_64  |  perl\-IO\-Tty  |  1\.16\-2\.amzn2023\.0\.2  | 
|  perl\-IO\-Zlib  |  noarch  |  perl\-IO\-Zlib  |  1\.11\-2\.amzn2023\.0\.2  | 
|  perl\-IPC\-Cmd  |  noarch  |  perl\-IPC\-Cmd  |  1\.04\-459\.amzn2023\.0\.2  | 
|  perl\-IPC\-Run  |  noarch  |  perl\-IPC\-Run  |  20200505\.0\-4\.amzn2023\.0\.2  | 
|  perl\-IPC\-Run3  |  noarch  |  perl\-IPC\-Run3  |  0\.048\-21\.amzn2023\.0\.2  | 
|  perl\-IPC\-ShareLite  |  aarch64  |  perl\-IPC\-ShareLite  |  0\.17\-35\.amzn2023\.0\.2  | 
|  perl\-IPC\-ShareLite  |  x86\_64  |  perl\-IPC\-ShareLite  |  0\.17\-35\.amzn2023\.0\.2  | 
|  perl\-IPC\-System\-Simple  |  noarch  |  perl\-IPC\-System\-Simple  |  1\.30\-4\.amzn2023\.0\.2  | 
|  perl\-IPC\-SysV  |  aarch64  |  perl\-IPC\-SysV  |  2\.09\-2\.amzn2023\.0\.2  | 
|  perl\-IPC\-SysV  |  x86\_64  |  perl\-IPC\-SysV  |  2\.09\-2\.amzn2023\.0\.2  | 
|  perl\-Jcode  |  noarch  |  perl\-Jcode  |  2\.07\-34\.amzn2023\.0\.2  | 
|  perl\-JSON  |  noarch  |  perl\-JSON  |  4\.03\-3\.amzn2023\.0\.2  | 
|  perl\-JSON\-tests  |  noarch  |  perl\-JSON  |  4\.03\-3\.amzn2023\.0\.2  | 
|  perl\-JSON\-Any  |  noarch  |  perl\-JSON\-Any  |  1\.39\-18\.amzn2023\.0\.2  | 
|  perl\-JSON\-Any\-tests  |  noarch  |  perl\-JSON\-Any  |  1\.39\-18\.amzn2023\.0\.2  | 
|  perl\-JSON\-MaybeXS  |  noarch  |  perl\-JSON\-MaybeXS  |  1\.004003\-2\.amzn2023\.0\.2  | 
|  perl\-JSON\-PP  |  noarch  |  perl\-JSON\-PP  |  4\.06\-2\.amzn2023\.0\.2  | 
|  perl\-JSON\-XS  |  aarch64  |  perl\-JSON\-XS  |  4\.03\-3\.amzn2023\.0\.2  | 
|  perl\-JSON\-XS  |  x86\_64  |  perl\-JSON\-XS  |  4\.03\-3\.amzn2023\.0\.2  | 
|  perl\-JSON\-XS\-tests  |  noarch  |  perl\-JSON\-XS  |  4\.03\-3\.amzn2023\.0\.2  | 
|  perl\-LaTeX\-ToUnicode  |  noarch  |  perl\-LaTeX\-ToUnicode  |  0\.11\-2\.amzn2023\.0\.2  | 
|  perl\-LDAP  |  noarch  |  perl\-LDAP  |  0\.68\-3\.amzn2023\.0\.2  | 
|  perl\-LDAP\-tests  |  noarch  |  perl\-LDAP  |  0\.68\-3\.amzn2023\.0\.2  | 
|  perl\-Net\-LDAP\-DSML  |  noarch  |  perl\-LDAP  |  0\.68\-3\.amzn2023\.0\.2  | 
|  perl\-Lexical\-SealRequireHints  |  aarch64  |  perl\-Lexical\-SealRequireHints  |  0\.011\-15\.amzn2023\.0\.2  | 
|  perl\-Lexical\-SealRequireHints  |  x86\_64  |  perl\-Lexical\-SealRequireHints  |  0\.011\-15\.amzn2023\.0\.2  | 
|  perl\-Lexical\-Var  |  aarch64  |  perl\-Lexical\-Var  |  0\.009\-25\.amzn2023\.0\.2  | 
|  perl\-Lexical\-Var  |  x86\_64  |  perl\-Lexical\-Var  |  0\.009\-25\.amzn2023\.0\.2  | 
|  perl\-libintl\-perl  |  aarch64  |  perl\-libintl\-perl  |  1\.32\-2\.amzn2023\.0\.2  | 
|  perl\-libintl\-perl  |  x86\_64  |  perl\-libintl\-perl  |  1\.32\-2\.amzn2023\.0\.2  | 
|  perl\-libnet  |  noarch  |  perl\-libnet  |  3\.13\-2\.amzn2023\.0\.2  | 
|  perl\-libwww\-perl  |  noarch  |  perl\-libwww\-perl  |  6\.58\-1\.amzn2023\.0\.2  | 
|  perl\-libwww\-perl\-tests  |  noarch  |  perl\-libwww\-perl  |  6\.58\-1\.amzn2023\.0\.2  | 
|  perl\-libxml\-perl  |  noarch  |  perl\-libxml\-perl  |  0\.08\-42\.amzn2023\.0\.2  | 
|  perl\-Lingua\-EN\-Inflect  |  noarch  |  perl\-Lingua\-EN\-Inflect  |  1\.905\-2\.amzn2023\.0\.2  | 
|  perl\-Lingua\-Translit  |  noarch  |  perl\-Lingua\-Translit  |  0\.28\-11\.amzn2023\.0\.2  | 
|  perl\-Linux\-Pid  |  aarch64  |  perl\-Linux\-Pid  |  0\.04\-44\.amzn2023\.0\.2  | 
|  perl\-Linux\-Pid  |  x86\_64  |  perl\-Linux\-Pid  |  0\.04\-44\.amzn2023\.0\.2  | 
|  perl\-List\-AllUtils  |  noarch  |  perl\-List\-AllUtils  |  0\.18\-2\.amzn2023\.0\.2  | 
|  perl\-List\-MoreUtils  |  noarch  |  perl\-List\-MoreUtils  |  0\.430\-2\.amzn2023\.0\.2  | 
|  perl\-List\-MoreUtils\-XS  |  aarch64  |  perl\-List\-MoreUtils\-XS  |  0\.430\-2\.amzn2023\.0\.3  | 
|  perl\-List\-MoreUtils\-XS  |  x86\_64  |  perl\-List\-MoreUtils\-XS  |  0\.430\-2\.amzn2023\.0\.3  | 
|  perl\-List\-SomeUtils  |  noarch  |  perl\-List\-SomeUtils  |  0\.58\-5\.amzn2023\.0\.2  | 
|  perl\-List\-UtilsBy  |  noarch  |  perl\-List\-UtilsBy  |  0\.11\-11\.amzn2023\.0\.2  | 
|  perl\-Locale\-Codes  |  noarch  |  perl\-Locale\-Codes  |  3\.68\-1\.amzn2023\.0\.2  | 
|  perl\-Locale\-Codes\-tests  |  noarch  |  perl\-Locale\-Codes  |  3\.68\-1\.amzn2023\.0\.2  | 
|  perl\-Locale\-Maketext  |  noarch  |  perl\-Locale\-Maketext  |  1\.29\-459\.amzn2023\.0\.2  | 
|  perl\-Locale\-US  |  noarch  |  perl\-Locale\-US  |  3\.04\-17\.amzn2023\.0\.2  | 
|  perl\-homedir  |  noarch  |  perl\-local\-lib  |  2\.000024\-11\.amzn2023\.0\.2  | 
|  perl\-local\-lib  |  noarch  |  perl\-local\-lib  |  2\.000024\-11\.amzn2023\.0\.2  | 
|  perl\-Log\-Dispatch  |  noarch  |  perl\-Log\-Dispatch  |  2\.70\-3\.amzn2023\.0\.2  | 
|  perl\-Log\-Dispatch\-ApacheLog  |  noarch  |  perl\-Log\-Dispatch  |  2\.70\-3\.amzn2023\.0\.2  | 
|  perl\-Log\-Dispatch\-FileRotate  |  noarch  |  perl\-Log\-Dispatch\-FileRotate  |  1\.36\-8\.amzn2023\.0\.2  | 
|  perl\-Log\-Log4perl  |  noarch  |  perl\-Log\-Log4perl  |  1\.54\-1\.amzn2023\.0\.2  | 
|  perl\-Log\-Log4perl\-Appender\-DBI  |  noarch  |  perl\-Log\-Log4perl  |  1\.54\-1\.amzn2023\.0\.2  | 
|  perl\-Log\-Log4perl\-Appender\-RRDs  |  noarch  |  perl\-Log\-Log4perl  |  1\.54\-1\.amzn2023\.0\.2  | 
|  perl\-Log\-Log4perl\-Config\-DOMConfigurator  |  noarch  |  perl\-Log\-Log4perl  |  1\.54\-1\.amzn2023\.0\.2  | 
|  perl\-Log\-Message  |  noarch  |  perl\-Log\-Message  |  0\.08\-24\.amzn2023\.0\.2  | 
|  perl\-Log\-Message\-Simple  |  noarch  |  perl\-Log\-Message\-Simple  |  0\.10\-311\.amzn2023\.0\.2  | 
|  perl\-LWP\-MediaTypes  |  noarch  |  perl\-LWP\-MediaTypes  |  6\.04\-7\.amzn2023\.0\.2  | 
|  perl\-LWP\-Protocol\-https  |  noarch  |  perl\-LWP\-Protocol\-https  |  6\.10\-2\.amzn2023\.0\.2  | 
|  perl\-Mail\-Sender  |  noarch  |  perl\-Mail\-Sender  |  0\.903\-14\.amzn2023\.0\.3  | 
|  perl\-Mail\-Sendmail  |  noarch  |  perl\-Mail\-Sendmail  |  0\.80\-11\.amzn2023\.0\.2  | 
|  perl\-MailTools  |  noarch  |  perl\-MailTools  |  2\.21\-7\.amzn2023\.0\.2  | 
|  perl\-match\-simple  |  noarch  |  perl\-match\-simple  |  0\.010\-9\.amzn2023\.0\.2  | 
|  perl\-Math\-Base\-Convert  |  noarch  |  perl\-Math\-Base\-Convert  |  0\.11\-16\.amzn2023\.0\.2  | 
|  perl\-Math\-BigInt  |  noarch  |  perl\-Math\-BigInt  |  1\.9998\.18\-458\.amzn2023\.0\.2  | 
|  perl\-Math\-BigInt\-FastCalc  |  aarch64  |  perl\-Math\-BigInt\-FastCalc  |  0\.500\.900\-458\.amzn2023\.0\.2  | 
|  perl\-Math\-BigInt\-FastCalc  |  x86\_64  |  perl\-Math\-BigInt\-FastCalc  |  0\.500\.900\-458\.amzn2023\.0\.2  | 
|  perl\-Math\-BigRat  |  noarch  |  perl\-Math\-BigRat  |  0\.2614\-458\.amzn2023\.0\.2  | 
|  perl\-MCE  |  noarch  |  perl\-MCE  |  1\.874\-2\.amzn2023\.0\.2  | 
|  perl\-MCE\-tools  |  noarch  |  perl\-MCE  |  1\.874\-2\.amzn2023\.0\.2  | 
|  perl\-Metrics\-Any  |  noarch  |  perl\-Metrics\-Any  |  0\.06\-3\.amzn2023\.0\.2  | 
|  perl\-MIME\-Base64  |  aarch64  |  perl\-MIME\-Base64  |  3\.16\-2\.amzn2023\.0\.2  | 
|  perl\-MIME\-Base64  |  x86\_64  |  perl\-MIME\-Base64  |  3\.16\-2\.amzn2023\.0\.2  | 
|  perl\-MIME\-Charset  |  noarch  |  perl\-MIME\-Charset  |  1\.012\.2\-13\.amzn2023\.0\.2  | 
|  perl\-MIME\-Lite  |  noarch  |  perl\-MIME\-Lite  |  3\.031\-5\.amzn2023\.0\.2  | 
|  perl\-MIME\-Types  |  noarch  |  perl\-MIME\-Types  |  2\.18\-2\.amzn2023\.0\.2  | 
|  perl\-MojoX\-MIME\-Types  |  noarch  |  perl\-MIME\-Types  |  2\.18\-2\.amzn2023\.0\.2  | 
|  perl\-Mixin\-Linewise  |  noarch  |  perl\-Mixin\-Linewise  |  0\.108\-19\.amzn2023\.0\.2  | 
|  perl\-MLDBM  |  noarch  |  perl\-MLDBM  |  2\.05\-23\.amzn2023\.0\.2  | 
|  perl\-Mock\-Config  |  noarch  |  perl\-Mock\-Config  |  0\.03\-13\.amzn2023\.0\.2  | 
|  perl\-Module\-Build  |  noarch  |  perl\-Module\-Build  |  0\.42\.31\-7\.amzn2023\.0\.2  | 
|  perl\-Module\-Build\-Deprecated  |  noarch  |  perl\-Module\-Build\-Deprecated  |  0\.4210\-20\.amzn2023\.0\.2  | 
|  perl\-Module\-Build\-Tiny  |  noarch  |  perl\-Module\-Build\-Tiny  |  0\.039\-19\.amzn2023\.0\.2  | 
|  perl\-Module\-Build\-XSUtil  |  noarch  |  perl\-Module\-Build\-XSUtil  |  0\.19\-11\.amzn2023\.0\.2  | 
|  perl\-Module\-CoreList  |  noarch  |  perl\-Module\-CoreList  |  5\.20211020\-1\.amzn2023\.0\.2  | 
|  perl\-Module\-CoreList\-tests  |  noarch  |  perl\-Module\-CoreList  |  5\.20211020\-1\.amzn2023\.0\.2  | 
|  perl\-Module\-CoreList\-tools  |  noarch  |  perl\-Module\-CoreList  |  5\.20211020\-1\.amzn2023\.0\.2  | 
|  perl\-Module\-CPANfile  |  noarch  |  perl\-Module\-CPANfile  |  1\.1004\-10\.amzn2023\.0\.2  | 
|  perl\-Module\-CPANTS\-Analyse  |  noarch  |  perl\-Module\-CPANTS\-Analyse  |  1\.01\-5\.amzn2023\.0\.2  | 
|  perl\-Module\-Extract\-Use  |  noarch  |  perl\-Module\-Extract\-Use  |  1\.047\-4\.amzn2023\.0\.2  | 
|  perl\-Module\-Find  |  noarch  |  perl\-Module\-Find  |  0\.15\-5\.amzn2023\.0\.2  | 
|  perl\-Module\-Implementation  |  noarch  |  perl\-Module\-Implementation  |  0\.09\-28\.amzn2023\.0\.2  | 
|  perl\-Module\-Install  |  noarch  |  perl\-Module\-Install  |  1\.19\-16\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-AuthorRequires  |  noarch  |  perl\-Module\-Install\-AuthorRequires  |  0\.02\-24\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-AuthorTests  |  noarch  |  perl\-Module\-Install\-AuthorTests  |  0\.002\-25\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-AutoLicense  |  noarch  |  perl\-Module\-Install\-AutoLicense  |  0\.10\-13\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-ExtraTests  |  noarch  |  perl\-Module\-Install\-ExtraTests  |  0\.008\-24\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-GithubMeta  |  noarch  |  perl\-Module\-Install\-GithubMeta  |  0\.30\-18\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-ManifestSkip  |  noarch  |  perl\-Module\-Install\-ManifestSkip  |  0\.24\-19\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-ReadmeFromPod  |  noarch  |  perl\-Module\-Install\-ReadmeFromPod  |  0\.30\-15\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-ReadmeMarkdownFromPod  |  noarch  |  perl\-Module\-Install\-ReadmeMarkdownFromPod  |  0\.04\-13\.amzn2023\.0\.2  | 
|  perl\-Module\-Install\-Repository  |  noarch  |  perl\-Module\-Install\-Repository  |  0\.06\-26\.amzn2023\.0\.2  | 
|  perl\-Module\-Load  |  noarch  |  perl\-Module\-Load  |  0\.36\-2\.amzn2023\.0\.2  | 
|  perl\-Module\-Load\-Conditional  |  noarch  |  perl\-Module\-Load\-Conditional  |  0\.74\-2\.amzn2023\.0\.2  | 
|  perl\-Module\-Manifest  |  noarch  |  perl\-Module\-Manifest  |  1\.09\-12\.amzn2023\.0\.2  | 
|  perl\-Module\-Manifest\-Skip  |  noarch  |  perl\-Module\-Manifest\-Skip  |  0\.23\-20\.amzn2023\.0\.2  | 
|  perl\-Module\-Metadata  |  noarch  |  perl\-Module\-Metadata  |  1\.000037\-458\.amzn2023\.0\.2  | 
|  perl\-Module\-Package  |  noarch  |  perl\-Module\-Package  |  0\.30\-25\.amzn2023\.0\.2  | 
|  perl\-Module\-Package\-Au  |  noarch  |  perl\-Module\-Package\-Au  |  2\-19\.amzn2023\.0\.2  | 
|  perl\-Module\-Path  |  noarch  |  perl\-Module\-Path  |  0\.19\-18\.amzn2023\.0\.2  | 
|  perl\-Module\-Pluggable  |  noarch  |  perl\-Module\-Pluggable  |  5\.2\-16\.amzn2023\.0\.2  | 
|  perl\-Module\-Refresh  |  noarch  |  perl\-Module\-Refresh  |  0\.17\-28\.amzn2023\.0\.2  | 
|  perl\-Module\-Runtime  |  noarch  |  perl\-Module\-Runtime  |  0\.016\-11\.amzn2023\.0\.2  | 
|  perl\-Module\-Runtime\-Conflicts  |  noarch  |  perl\-Module\-Runtime\-Conflicts  |  0\.003\-14\.amzn2023\.0\.2  | 
|  perl\-Module\-ScanDeps  |  noarch  |  perl\-Module\-ScanDeps  |  1\.31\-1\.amzn2023\.0\.2  | 
|  perl\-Module\-ScanDeps\-tests  |  noarch  |  perl\-Module\-ScanDeps  |  1\.31\-1\.amzn2023\.0\.2  | 
|  perl\-Module\-Signature  |  noarch  |  perl\-Module\-Signature  |  0\.87\-3\.amzn2023\.0\.2  | 
|  perl\-Mojolicious  |  noarch  |  perl\-Mojolicious  |  8\.73\-3\.amzn2023\.0\.2  | 
|  perl\-Test\-Mojo  |  noarch  |  perl\-Mojolicious  |  8\.73\-3\.amzn2023\.0\.2  | 
|  perl\-Moo  |  noarch  |  perl\-Moo  |  2\.004004\-2\.amzn2023\.0\.2  | 
|  perl\-Moose  |  aarch64  |  perl\-Moose  |  2\.2014\-2\.amzn2023\.0\.4  | 
|  perl\-Moose  |  x86\_64  |  perl\-Moose  |  2\.2014\-2\.amzn2023\.0\.4  | 
|  perl\-Test\-Moose  |  aarch64  |  perl\-Moose  |  2\.2014\-2\.amzn2023\.0\.4  | 
|  perl\-Test\-Moose  |  x86\_64  |  perl\-Moose  |  2\.2014\-2\.amzn2023\.0\.4  | 
|  perl\-Moose\-Autobox  |  noarch  |  perl\-Moose\-Autobox  |  0\.16\-15\.amzn2023\.0\.2  | 
|  perl\-MooseX\-AttributeHelpers  |  noarch  |  perl\-MooseX\-AttributeHelpers  |  0\.25\-16\.amzn2023\.0\.2  | 
|  perl\-MooseX\-ConfigFromFile  |  noarch  |  perl\-MooseX\-ConfigFromFile  |  0\.14\-21\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Getopt  |  noarch  |  perl\-MooseX\-Getopt  |  0\.75\-1\.amzn2023\.0\.2  | 
|  perl\-MooseX\-GlobRef  |  noarch  |  perl\-MooseX\-GlobRef  |  0\.0701\-29\.amzn2023\.0\.2  | 
|  perl\-MooseX\-InsideOut  |  noarch  |  perl\-MooseX\-InsideOut  |  0\.106\-29\.amzn2023\.0\.2  | 
|  perl\-MooseX\-MarkAsMethods  |  noarch  |  perl\-MooseX\-MarkAsMethods  |  0\.15\-24\.amzn2023\.0\.2  | 
|  perl\-MooseX\-NonMoose  |  noarch  |  perl\-MooseX\-NonMoose  |  0\.26\-20\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Role\-Parameterized  |  noarch  |  perl\-MooseX\-Role\-Parameterized  |  1\.11\-6\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Role\-WithOverloading  |  aarch64  |  perl\-MooseX\-Role\-WithOverloading  |  0\.17\-19\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Role\-WithOverloading  |  x86\_64  |  perl\-MooseX\-Role\-WithOverloading  |  0\.17\-19\.amzn2023\.0\.2  | 
|  perl\-MooseX\-SimpleConfig  |  noarch  |  perl\-MooseX\-SimpleConfig  |  0\.11\-19\.amzn2023\.0\.2  | 
|  perl\-MooseX\-StrictConstructor  |  noarch  |  perl\-MooseX\-StrictConstructor  |  0\.21\-13\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Types  |  noarch  |  perl\-MooseX\-Types  |  0\.50\-13\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Types\-Common  |  noarch  |  perl\-MooseX\-Types\-Common  |  0\.001014\-14\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Types\-Path\-Tiny  |  noarch  |  perl\-MooseX\-Types\-Path\-Tiny  |  0\.012\-14\.amzn2023\.0\.2  | 
|  perl\-MooseX\-Types\-Stringlike  |  noarch  |  perl\-MooseX\-Types\-Stringlike  |  0\.003\-21\.amzn2023\.0\.2  | 
|  perl\-MooX\-HandlesVia  |  noarch  |  perl\-MooX\-HandlesVia  |  0\.001009\-2\.amzn2023\.0\.2  | 
|  perl\-MooX\-Types\-MooseLike  |  noarch  |  perl\-MooX\-Types\-MooseLike  |  0\.29\-16\.amzn2023\.0\.2  | 
|  perl\-Mouse  |  aarch64  |  perl\-Mouse  |  2\.5\.10\-5\.amzn2023\.0\.2  | 
|  perl\-Mouse  |  x86\_64  |  perl\-Mouse  |  2\.5\.10\-5\.amzn2023\.0\.2  | 
|  perl\-Test\-Mouse  |  aarch64  |  perl\-Mouse  |  2\.5\.10\-5\.amzn2023\.0\.2  | 
|  perl\-Test\-Mouse  |  x86\_64  |  perl\-Mouse  |  2\.5\.10\-5\.amzn2023\.0\.2  | 
|  perl\-MouseX\-Foreign  |  noarch  |  perl\-MouseX\-Foreign  |  1\.000\-16\.amzn2023\.0\.2  | 
|  perl\-MouseX\-Types  |  noarch  |  perl\-MouseX\-Types  |  0\.06\-28\.amzn2023\.0\.2  | 
|  perl\-Mozilla\-CA  |  noarch  |  perl\-Mozilla\-CA  |  20200520\-4\.amzn2023\.0\.2  | 
|  perl\-MRO\-Compat  |  noarch  |  perl\-MRO\-Compat  |  0\.13\-13\.amzn2023\.0\.2  | 
|  perl\-multidimensional  |  aarch64  |  perl\-multidimensional  |  0\.014\-10\.amzn2023\.0\.2  | 
|  perl\-multidimensional  |  x86\_64  |  perl\-multidimensional  |  0\.014\-10\.amzn2023\.0\.2  | 
|  perl\-namespace\-autoclean  |  noarch  |  perl\-namespace\-autoclean  |  0\.29\-6\.amzn2023\.0\.2  | 
|  perl\-namespace\-clean  |  noarch  |  perl\-namespace\-clean  |  0\.27\-16\.amzn2023\.0\.2  | 
|  perl\-Net\-HTTP  |  noarch  |  perl\-Net\-HTTP  |  6\.21\-1\.amzn2023\.0\.2  | 
|  perl\-Net\-HTTP\-tests  |  noarch  |  perl\-Net\-HTTP  |  6\.21\-1\.amzn2023\.0\.2  | 
|  perl\-Net\-IDN\-Encode  |  aarch64  |  perl\-Net\-IDN\-Encode  |  2\.500\-9\.amzn2023\.0\.2  | 
|  perl\-Net\-IDN\-Encode  |  x86\_64  |  perl\-Net\-IDN\-Encode  |  2\.500\-9\.amzn2023\.0\.2  | 
|  perl\-Net\-LibIDN  |  aarch64  |  perl\-Net\-LibIDN  |  0\.12\-39\.amzn2023\.0\.3  | 
|  perl\-Net\-LibIDN  |  x86\_64  |  perl\-Net\-LibIDN  |  0\.12\-39\.amzn2023\.0\.3  | 
|  perl\-Net\-Ping  |  noarch  |  perl\-Net\-Ping  |  2\.74\-3\.amzn2023\.0\.2  | 
|  perl\-Net\-SMTP\-SSL  |  noarch  |  perl\-Net\-SMTP\-SSL  |  1\.04\-14\.amzn2023\.0\.2  | 
|  perl\-Net\-SSLeay  |  aarch64  |  perl\-Net\-SSLeay  |  1\.92\-2\.amzn2023\.0\.2  | 
|  perl\-Net\-SSLeay  |  x86\_64  |  perl\-Net\-SSLeay  |  1\.92\-2\.amzn2023\.0\.2  | 
|  perl\-NTLM  |  noarch  |  perl\-NTLM  |  1\.09\-28\.amzn2023\.0\.2  | 
|  perl\-Number\-Compare  |  noarch  |  perl\-Number\-Compare  |  0\.03\-28\.amzn2023\.0\.2  | 
|  perl\-Number\-Format  |  noarch  |  perl\-Number\-Format  |  1\.75\-16\.amzn2023\.0\.2  | 
|  perl\-Object\-Accessor  |  noarch  |  perl\-Object\-Accessor  |  0\.48\-24\.amzn2023\.0\.2  | 
|  perl\-Object\-Deadly  |  noarch  |  perl\-Object\-Deadly  |  0\.09\-37\.amzn2023\.0\.2  | 
|  perl\-Object\-HashBase  |  noarch  |  perl\-Object\-HashBase  |  0\.009\-5\.amzn2023\.0\.2  | 
|  perl\-Object\-HashBase\-tools  |  noarch  |  perl\-Object\-HashBase  |  0\.009\-5\.amzn2023\.0\.2  | 
|  perl\-OLE\-Storage\_Lite  |  noarch  |  perl\-OLE\-Storage\_Lite  |  0\.20\-5\.amzn2023\.0\.2  | 
|  perl\-Package\-Anon  |  aarch64  |  perl\-Package\-Anon  |  0\.05\-28\.amzn2023\.0\.2  | 
|  perl\-Package\-Anon  |  x86\_64  |  perl\-Package\-Anon  |  0\.05\-28\.amzn2023\.0\.2  | 
|  perl\-Package\-DeprecationManager  |  noarch  |  perl\-Package\-DeprecationManager  |  0\.17\-14\.amzn2023\.0\.2  | 
|  perl\-Package\-Generator  |  noarch  |  perl\-Package\-Generator  |  1\.106\-21\.amzn2023\.0\.2  | 
|  perl\-Package\-Stash  |  noarch  |  perl\-Package\-Stash  |  0\.39\-2\.amzn2023\.0\.2  | 
|  perl\-Package\-Stash\-XS  |  aarch64  |  perl\-Package\-Stash\-XS  |  0\.29\-9\.amzn2023\.0\.2  | 
|  perl\-Package\-Stash\-XS  |  x86\_64  |  perl\-Package\-Stash\-XS  |  0\.29\-9\.amzn2023\.0\.2  | 
|  perl\-Package\-Variant  |  noarch  |  perl\-Package\-Variant  |  1\.003002\-16\.amzn2023\.0\.2  | 
|  perl\-PadWalker  |  aarch64  |  perl\-PadWalker  |  2\.5\-2\.amzn2023\.0\.2  | 
|  perl\-PadWalker  |  x86\_64  |  perl\-PadWalker  |  2\.5\-2\.amzn2023\.0\.2  | 
|  perl\-Paper\-Specs  |  noarch  |  perl\-Paper\-Specs  |  0\.10\-25\.amzn2023\.0\.2  | 
|  perl\-Parallel\-ForkManager  |  noarch  |  perl\-Parallel\-ForkManager  |  2\.02\-9\.amzn2023\.0\.2  | 
|  perl\-Parallel\-Iterator  |  noarch  |  perl\-Parallel\-Iterator  |  1\.00\-28\.amzn2023\.0\.2  | 
|  perl\-Params\-Check  |  noarch  |  perl\-Params\-Check  |  0\.38\-459\.amzn2023\.0\.2  | 
|  perl\-Params\-Classify  |  aarch64  |  perl\-Params\-Classify  |  0\.015\-12\.amzn2023\.0\.2  | 
|  perl\-Params\-Classify  |  x86\_64  |  perl\-Params\-Classify  |  0\.015\-12\.amzn2023\.0\.2  | 
|  perl\-Params\-Coerce  |  noarch  |  perl\-Params\-Coerce  |  0\.15\-2\.amzn2023\.0\.2  | 
|  perl\-Params\-Util  |  aarch64  |  perl\-Params\-Util  |  1\.102\-3\.amzn2023\.0\.2  | 
|  perl\-Params\-Util  |  x86\_64  |  perl\-Params\-Util  |  1\.102\-3\.amzn2023\.0\.2  | 
|  perl\-Params\-Validate  |  aarch64  |  perl\-Params\-Validate  |  1\.30\-2\.amzn2023\.0\.2  | 
|  perl\-Params\-Validate  |  x86\_64  |  perl\-Params\-Validate  |  1\.30\-2\.amzn2023\.0\.2  | 
|  perl\-Params\-ValidationCompiler  |  noarch  |  perl\-Params\-ValidationCompiler  |  0\.30\-10\.amzn2023\.0\.2  | 
|  perl\-PAR\-Dist  |  noarch  |  perl\-PAR\-Dist  |  0\.51\-2\.amzn2023\.0\.2  | 
|  perl\-parent  |  noarch  |  perl\-parent  |  0\.238\-458\.amzn2023\.0\.2  | 
|  perl\-Parse\-RecDescent  |  noarch  |  perl\-Parse\-RecDescent  |  1\.967015\-13\.amzn2023\.0\.2  | 
|  perl\-Parse\-Yapp  |  noarch  |  perl\-Parse\-Yapp  |  1\.21\-10\.amzn2023\.0\.2  | 
|  perl\-Path\-Class  |  noarch  |  perl\-Path\-Class  |  0\.37\-18\.amzn2023\.0\.2  | 
|  perl\-Path\-Tiny  |  noarch  |  perl\-Path\-Tiny  |  0\.118\-1\.amzn2023\.0\.2  | 
|  perl\-PathTools  |  aarch64  |  perl\-PathTools  |  3\.78\-459\.amzn2023\.0\.2  | 
|  perl\-PathTools  |  x86\_64  |  perl\-PathTools  |  3\.78\-459\.amzn2023\.0\.2  | 
|  perl\-PDF\-API2  |  noarch  |  perl\-PDF\-API2  |  2\.041\-1\.amzn2023\.0\.2  | 
|  perl\-PDF\-API2\-tests  |  noarch  |  perl\-PDF\-API2  |  2\.041\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic  |  noarch  |  perl\-Perl\-Critic  |  1\.140\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-Perl\-Critic\-Policy  |  noarch  |  perl\-Perl\-Critic  |  1\.140\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Bangs  |  noarch  |  perl\-Perl\-Critic\-Bangs  |  1\.12\-13\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Compatibility  |  noarch  |  perl\-Perl\-Critic\-Compatibility  |  1\.001\-28\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Deprecated  |  noarch  |  perl\-Perl\-Critic\-Deprecated  |  1\.119\-20\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Dynamic  |  noarch  |  perl\-Perl\-Critic\-Dynamic  |  0\.05\-26\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Itch  |  noarch  |  perl\-Perl\-Critic\-Itch  |  0\.07\-25\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Lax  |  noarch  |  perl\-Perl\-Critic\-Lax  |  0\.013\-13\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Moose  |  noarch  |  perl\-Perl\-Critic\-Moose  |  1\.05\-14\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-More  |  noarch  |  perl\-Perl\-Critic\-More  |  1\.003\-20\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Nits  |  noarch  |  perl\-Perl\-Critic\-Nits  |  1\.0\.0\-28\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-PetPeeves\-JTRAMMELL  |  noarch  |  perl\-Perl\-Critic\-PetPeeves\-JTRAMMELL  |  0\.04\-20\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Pulp  |  noarch  |  perl\-Perl\-Critic\-Pulp  |  99\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Pulp\-tests  |  noarch  |  perl\-Perl\-Critic\-Pulp  |  99\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Storable  |  noarch  |  perl\-Perl\-Critic\-Storable  |  0\.01\-29\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-StricterSubs  |  noarch  |  perl\-Perl\-Critic\-StricterSubs  |  0\.05\-18\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Swift  |  noarch  |  perl\-Perl\-Critic\-Swift  |  1\.0\.3\-31\.amzn2023\.0\.2  | 
|  perl\-Perl\-Critic\-Tics  |  noarch  |  perl\-Perl\-Critic\-Tics  |  0\.009\-19\.amzn2023\.0\.2  | 
|  perl\-Perl\-Destruct\-Level  |  aarch64  |  perl\-Perl\-Destruct\-Level  |  0\.02\-29\.amzn2023\.0\.2  | 
|  perl\-Perl\-Destruct\-Level  |  x86\_64  |  perl\-Perl\-Destruct\-Level  |  0\.02\-29\.amzn2023\.0\.2  | 
|  perl\-perlfaq  |  noarch  |  perl\-perlfaq  |  5\.20210520\-1\.amzn2023\.0\.2  | 
|  perl\-perlindex  |  noarch  |  perl\-perlindex  |  1\.606\-21\.amzn2023\.0\.2  | 
|  perl\-PerlIO\-utf8\_strict  |  aarch64  |  perl\-PerlIO\-utf8\_strict  |  0\.008\-2\.amzn2023\.0\.2  | 
|  perl\-PerlIO\-utf8\_strict  |  x86\_64  |  perl\-PerlIO\-utf8\_strict  |  0\.008\-2\.amzn2023\.0\.2  | 
|  perl\-PerlIO\-via\-QuotedPrint  |  noarch  |  perl\-PerlIO\-via\-QuotedPrint  |  0\.09\-2\.amzn2023\.0\.2  | 
|  perl\-Perl\-Metrics\-Simple  |  noarch  |  perl\-Perl\-Metrics\-Simple  |  1\.0\.1\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-Metrics\-Simple\-tests  |  noarch  |  perl\-Perl\-Metrics\-Simple  |  1\.0\.1\-1\.amzn2023\.0\.2  | 
|  perl\-Perl\-MinimumVersion  |  noarch  |  perl\-Perl\-MinimumVersion  |  1\.40\-0\.amzn2023\.0\.2  | 
|  perl\-Perl\-OSType  |  noarch  |  perl\-Perl\-OSType  |  1\.010\-459\.amzn2023\.0\.2  | 
|  perl\-Perl\-PrereqScanner  |  noarch  |  perl\-Perl\-PrereqScanner  |  1\.023\-17\.amzn2023\.0\.2  | 
|  perl\-Perl\-PrereqScanner\-NotQuiteLite  |  noarch  |  perl\-Perl\-PrereqScanner\-NotQuiteLite  |  0\.9913\-2\.amzn2023\.0\.2  | 
|  perl\-Perl\-Version  |  noarch  |  perl\-Perl\-Version  |  1\.013\-18\.amzn2023\.0\.2  | 
|  perl\-pod2pdf  |  noarch  |  perl\-pod2pdf  |  0\.42\-26\.amzn2023\.0\.2  | 
|  perl\-Pod\-Checker  |  noarch  |  perl\-Pod\-Checker  |  1\.74\-2\.amzn2023\.0\.2  | 
|  perl\-Pod\-Coverage  |  noarch  |  perl\-Pod\-Coverage  |  0\.23\-23\.amzn2023\.0\.2  | 
|  perl\-Pod\-Coverage\-Moose  |  noarch  |  perl\-Pod\-Coverage\-Moose  |  0\.07\-17\.amzn2023\.0\.2  | 
|  perl\-Pod\-Coverage\-TrustPod  |  noarch  |  perl\-Pod\-Coverage\-TrustPod  |  0\.100005\-11\.amzn2023\.0\.2  | 
|  perl\-Pod\-Escapes  |  noarch  |  perl\-Pod\-Escapes  |  1\.07\-458\.amzn2023\.0\.2  | 
|  perl\-Pod\-Eventual  |  noarch  |  perl\-Pod\-Eventual  |  0\.094001\-19\.amzn2023\.0\.2  | 
|  perl\-podlators  |  noarch  |  perl\-podlators  |  4\.14\-458\.amzn2023\.0\.2  | 
|  perl\-podlinkcheck  |  noarch  |  perl\-podlinkcheck  |  15\-14\.amzn2023\.0\.2  | 
|  perl\-Pod\-Markdown  |  noarch  |  perl\-Pod\-Markdown  |  3\.300\-2\.amzn2023\.0\.2  | 
|  perl\-Pod\-MinimumVersion  |  noarch  |  perl\-Pod\-MinimumVersion  |  50\-30\.amzn2023\.0\.2  | 
|  perl\-Pod\-Parser  |  noarch  |  perl\-Pod\-Parser  |  1\.63\-445\.amzn2023\.0\.2  | 
|  perl\-Pod\-Perldoc  |  noarch  |  perl\-Pod\-Perldoc  |  3\.28\.01\-459\.amzn2023\.0\.3  | 
|  perl\-Pod\-POM  |  noarch  |  perl\-Pod\-POM  |  2\.01\-18\.amzn2023\.0\.2  | 
|  perl\-Pod\-Readme  |  noarch  |  perl\-Pod\-Readme  |  1\.2\.3\-8\.amzn2023\.0\.2  | 
|  perl\-Pod\-Simple  |  noarch  |  perl\-Pod\-Simple  |  3\.42\-2\.amzn2023\.0\.2  | 
|  perl\-Pod\-Spell  |  noarch  |  perl\-Pod\-Spell  |  1\.20\-18\.amzn2023\.0\.2  | 
|  perl\-Pod\-Spell\-CommonMistakes  |  noarch  |  perl\-Pod\-Spell\-CommonMistakes  |  1\.002\-19\.amzn2023\.0\.2  | 
|  perl\-Pod\-Usage  |  noarch  |  perl\-Pod\-Usage  |  2\.01\-2\.amzn2023\.0\.2  | 
|  perl\-POE  |  noarch  |  perl\-POE  |  1\.368\-5\.amzn2023\.0\.2  | 
|  perl\-POE\-Test\-Loops  |  noarch  |  perl\-POE\-Test\-Loops  |  1\.360\-19\.amzn2023\.0\.2  | 
|  perl\-PPI  |  noarch  |  perl\-PPI  |  1\.270\-6\.amzn2023\.0\.2  | 
|  perl\-PPI\-HTML  |  noarch  |  perl\-PPI\-HTML  |  1\.08\-25\.amzn2023\.0\.2  | 
|  perl\-PPIx\-QuoteLike  |  noarch  |  perl\-PPIx\-QuoteLike  |  0\.016\-1\.amzn2023\.0\.2  | 
|  perl\-PPIx\-QuoteLike\-tests  |  noarch  |  perl\-PPIx\-QuoteLike  |  0\.016\-1\.amzn2023\.0\.2  | 
|  perl\-PPIx\-Regexp  |  noarch  |  perl\-PPIx\-Regexp  |  0\.079\-1\.amzn2023\.0\.2  | 
|  perl\-PPIx\-Regexp\-tests  |  noarch  |  perl\-PPIx\-Regexp  |  0\.079\-1\.amzn2023\.0\.2  | 
|  perl\-PPIx\-Utilities  |  noarch  |  perl\-PPIx\-Utilities  |  1\.001000\-40\.amzn2023\.0\.2  | 
|  perl\-PPIx\-Utils  |  noarch  |  perl\-PPIx\-Utils  |  0\.003\-2\.amzn2023\.0\.2  | 
|  perl\-prefork  |  noarch  |  perl\-prefork  |  1\.05\-8\.amzn2023\.0\.2  | 
|  perl\-Probe\-Perl  |  noarch  |  perl\-Probe\-Perl  |  0\.03\-20\.amzn2023\.0\.2  | 
|  perl\-Readonly  |  noarch  |  perl\-Readonly  |  2\.05\-14\.amzn2023\.0\.2  | 
|  perl\-Readonly\-XS  |  aarch64  |  perl\-Readonly\-XS  |  1\.05\-39\.amzn2023\.0\.2  | 
|  perl\-Readonly\-XS  |  x86\_64  |  perl\-Readonly\-XS  |  1\.05\-39\.amzn2023\.0\.2  | 
|  perl\-Ref\-Util  |  noarch  |  perl\-Ref\-Util  |  0\.204\-10\.amzn2023\.0\.2  | 
|  perl\-Ref\-Util\-XS  |  aarch64  |  perl\-Ref\-Util\-XS  |  0\.117\-11\.amzn2023\.0\.2  | 
|  perl\-Ref\-Util\-XS  |  x86\_64  |  perl\-Ref\-Util\-XS  |  0\.117\-11\.amzn2023\.0\.2  | 
|  perl\-Regexp\-Common  |  noarch  |  perl\-Regexp\-Common  |  2017060201\-14\.amzn2023\.0\.2  | 
|  perl\-Regexp\-Trie  |  noarch  |  perl\-Regexp\-Trie  |  0\.02\-8\.amzn2023\.0\.2  | 
|  perl\-Return\-Type  |  noarch  |  perl\-Return\-Type  |  0\.007\-2\.amzn2023\.0\.2  | 
|  perl\-Role\-Tiny  |  noarch  |  perl\-Role\-Tiny  |  2\.002004\-2\.amzn2023\.0\.2  | 
|  perl\-Scalar\-List\-Utils  |  aarch64  |  perl\-Scalar\-List\-Utils  |  1\.56\-459\.amzn2023\.0\.2  | 
|  perl\-Scalar\-List\-Utils  |  x86\_64  |  perl\-Scalar\-List\-Utils  |  1\.56\-459\.amzn2023\.0\.2  | 
|  perl\-Scalar\-Properties  |  noarch  |  perl\-Scalar\-Properties  |  1\.100860\-26\.amzn2023\.0\.2  | 
|  perl\-Scope\-Guard  |  noarch  |  perl\-Scope\-Guard  |  0\.21\-16\.amzn2023\.0\.2  | 
|  perl\-Scope\-Upper  |  aarch64  |  perl\-Scope\-Upper  |  0\.32\-6\.amzn2023\.0\.2  | 
|  perl\-Scope\-Upper  |  x86\_64  |  perl\-Scope\-Upper  |  0\.32\-6\.amzn2023\.0\.2  | 
|  perl\-Sereal  |  noarch  |  perl\-Sereal  |  4\.018\-2\.amzn2023\.0\.2  | 
|  perl\-Sereal\-Decoder  |  aarch64  |  perl\-Sereal\-Decoder  |  4\.018\-2\.amzn2023\.0\.2  | 
|  perl\-Sereal\-Decoder  |  x86\_64  |  perl\-Sereal\-Decoder  |  4\.018\-2\.amzn2023\.0\.2  | 
|  perl\-Sereal\-Encoder  |  aarch64  |  perl\-Sereal\-Encoder  |  4\.018\-2\.amzn2023\.0\.2  | 
|  perl\-Sereal\-Encoder  |  x86\_64  |  perl\-Sereal\-Encoder  |  4\.018\-2\.amzn2023\.0\.2  | 
|  perl\-Set\-Object  |  aarch64  |  perl\-Set\-Object  |  1\.40\-4\.amzn2023\.0\.2  | 
|  perl\-Set\-Object  |  x86\_64  |  perl\-Set\-Object  |  1\.40\-4\.amzn2023\.0\.2  | 
|  perl\-SGMLSpm  |  noarch  |  perl\-SGMLSpm  |  1\.03ii\-52\.amzn2023\.0\.2  | 
|  perl\-Socket  |  aarch64  |  perl\-Socket  |  2\.032\-1\.amzn2023\.0\.2  | 
|  perl\-Socket  |  x86\_64  |  perl\-Socket  |  2\.032\-1\.amzn2023\.0\.2  | 
|  perl\-Socket\-tests  |  aarch64  |  perl\-Socket  |  2\.032\-1\.amzn2023\.0\.2  | 
|  perl\-Socket\-tests  |  x86\_64  |  perl\-Socket  |  2\.032\-1\.amzn2023\.0\.2  | 
|  perl\-Socket6  |  aarch64  |  perl\-Socket6  |  0\.29\-9\.amzn2023\.0\.2  | 
|  perl\-Socket6  |  x86\_64  |  perl\-Socket6  |  0\.29\-9\.amzn2023\.0\.2  | 
|  perl\-Software\-License  |  noarch  |  perl\-Software\-License  |  0\.103014\-10\.amzn2023\.0\.2  | 
|  perl\-Software\-License\-CCpack  |  noarch  |  perl\-Software\-License\-CCpack  |  1\.11\-25\.amzn2023\.0\.2  | 
|  perl\-Sort\-Key  |  aarch64  |  perl\-Sort\-Key  |  1\.33\-20\.amzn2023\.0\.2  | 
|  perl\-Sort\-Key  |  x86\_64  |  perl\-Sort\-Key  |  1\.33\-20\.amzn2023\.0\.2  | 
|  perl\-Sort\-Versions  |  noarch  |  perl\-Sort\-Versions  |  1\.62\-17\.amzn2023\.0\.2  | 
|  perl\-Specio  |  noarch  |  perl\-Specio  |  0\.47\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-Specio  |  noarch  |  perl\-Specio  |  0\.47\-1\.amzn2023\.0\.2  | 
|  perl\-Spellunker  |  noarch  |  perl\-Spellunker  |  0\.4\.0\-20\.amzn2023\.0\.2  | 
|  perl\-Spiffy  |  noarch  |  perl\-Spiffy  |  0\.46\-20\.amzn2023\.0\.2  | 
|  perl\-Spreadsheet\-ParseExcel  |  aarch64  |  perl\-Spreadsheet\-ParseExcel  |  0\.6500\-28\.amzn2023\.0\.2  | 
|  perl\-Spreadsheet\-ParseExcel  |  x86\_64  |  perl\-Spreadsheet\-ParseExcel  |  0\.6500\-28\.amzn2023\.0\.2  | 
|  perl\-Spreadsheet\-WriteExcel  |  noarch  |  perl\-Spreadsheet\-WriteExcel  |  2\.40\-21\.amzn2023\.0\.2  | 
|  perl\-SQL\-Interp  |  noarch  |  perl\-SQL\-Interp  |  1\.27\-2\.amzn2023\.0\.2  | 
|  perl\-SQL\-Interp\-tests  |  noarch  |  perl\-SQL\-Interp  |  1\.27\-2\.amzn2023\.0\.2  | 
|  perl\-SQL\-Statement  |  noarch  |  perl\-SQL\-Statement  |  1\.414\-2\.amzn2023\.0\.2  | 
|  perl\-SQL\-Translator  |  noarch  |  perl\-SQL\-Translator  |  1\.62\-2\.amzn2023\.0\.2  | 
|  perl\-SQL\-Translator\-Producer\-Diagram  |  noarch  |  perl\-SQL\-Translator  |  1\.62\-2\.amzn2023\.0\.2  | 
|  perl\-srpm\-macros  |  noarch  |  perl\-srpm\-macros  |  1\-39\.amzn2023\.0\.2  | 
|  perl\-Statistics\-Basic  |  noarch  |  perl\-Statistics\-Basic  |  1\.6611\-19\.amzn2023\.0\.2  | 
|  perl\-Storable  |  aarch64  |  perl\-Storable  |  3\.21\-458\.amzn2023\.0\.2  | 
|  perl\-Storable  |  x86\_64  |  perl\-Storable  |  3\.21\-458\.amzn2023\.0\.2  | 
|  perl\-strictures  |  noarch  |  perl\-strictures  |  2\.000006\-10\.amzn2023\.0\.2  | 
|  perl\-String\-CRC32  |  aarch64  |  perl\-String\-CRC32  |  2\.100\-1\.amzn2023  | 
|  perl\-String\-CRC32  |  x86\_64  |  perl\-String\-CRC32  |  2\.100\-1\.amzn2023  | 
|  perl\-String\-Escape  |  noarch  |  perl\-String\-Escape  |  2010\.002\-33\.amzn2023\.0\.2  | 
|  perl\-String\-Format  |  noarch  |  perl\-String\-Format  |  1\.18\-10\.amzn2023\.0\.2  | 
|  perl\-String\-RewritePrefix  |  noarch  |  perl\-String\-RewritePrefix  |  0\.008\-5\.amzn2023\.0\.2  | 
|  perl\-String\-Similarity  |  aarch64  |  perl\-String\-Similarity  |  1\.04\-31\.amzn2023\.0\.2  | 
|  perl\-String\-Similarity  |  x86\_64  |  perl\-String\-Similarity  |  1\.04\-31\.amzn2023\.0\.2  | 
|  perl\-Struct\-Dumb  |  noarch  |  perl\-Struct\-Dumb  |  0\.12\-4\.amzn2023\.0\.2  | 
|  perl\-Sub\-Exporter  |  noarch  |  perl\-Sub\-Exporter  |  0\.987\-25\.amzn2023\.0\.2  | 
|  perl\-Sub\-Exporter\-ForMethods  |  noarch  |  perl\-Sub\-Exporter\-ForMethods  |  0\.100052\-17\.amzn2023\.0\.2  | 
|  perl\-Sub\-Exporter\-Lexical  |  noarch  |  perl\-Sub\-Exporter\-Lexical  |  0\.092292\-14\.amzn2023\.0\.2  | 
|  perl\-Sub\-Exporter\-Progressive  |  noarch  |  perl\-Sub\-Exporter\-Progressive  |  0\.001013\-14\.amzn2023\.0\.2  | 
|  perl\-Sub\-Identify  |  aarch64  |  perl\-Sub\-Identify  |  0\.14\-15\.amzn2023\.0\.2  | 
|  perl\-Sub\-Identify  |  x86\_64  |  perl\-Sub\-Identify  |  0\.14\-15\.amzn2023\.0\.2  | 
|  perl\-Sub\-Infix  |  noarch  |  perl\-Sub\-Infix  |  0\.004\-13\.amzn2023\.0\.2  | 
|  perl\-Sub\-Info  |  noarch  |  perl\-Sub\-Info  |  0\.002\-14\.amzn2023\.0\.2  | 
|  perl\-Sub\-Install  |  noarch  |  perl\-Sub\-Install  |  0\.928\-26\.amzn2023\.0\.2  | 
|  perl\-Sub\-Name  |  aarch64  |  perl\-Sub\-Name  |  0\.26\-5\.amzn2023\.0\.2  | 
|  perl\-Sub\-Name  |  x86\_64  |  perl\-Sub\-Name  |  0\.26\-5\.amzn2023\.0\.2  | 
|  perl\-Sub\-Quote  |  noarch  |  perl\-Sub\-Quote  |  2\.006006\-5\.amzn2023\.0\.2  | 
|  perl\-Sub\-Uplevel  |  noarch  |  perl\-Sub\-Uplevel  |  0\.2800\-13\.amzn2023\.0\.2  | 
|  perl\-SUPER  |  noarch  |  perl\-SUPER  |  1\.20190531\-7\.amzn2023\.0\.2  | 
|  perl\-Switch  |  noarch  |  perl\-Switch  |  2\.17\-21\.amzn2023\.0\.2  | 
|  perl\-Symbol\-Util  |  noarch  |  perl\-Symbol\-Util  |  0\.0203\-25\.amzn2023\.0\.2  | 
|  perl\-syntax  |  noarch  |  perl\-syntax  |  0\.004\-25\.amzn2023\.0\.2  | 
|  perl\-Syntax\-Keyword\-Junction  |  noarch  |  perl\-Syntax\-Keyword\-Junction  |  0\.003008\-19\.amzn2023\.0\.2  | 
|  perl\-Sys\-Syslog  |  aarch64  |  perl\-Sys\-Syslog  |  0\.36\-459\.amzn2023\.0\.2  | 
|  perl\-Sys\-Syslog  |  x86\_64  |  perl\-Sys\-Syslog  |  0\.36\-459\.amzn2023\.0\.2  | 
|  perl\-Taint\-Runtime  |  aarch64  |  perl\-Taint\-Runtime  |  0\.03\-41\.amzn2023\.0\.2  | 
|  perl\-Taint\-Runtime  |  x86\_64  |  perl\-Taint\-Runtime  |  0\.03\-41\.amzn2023\.0\.2  | 
|  perl\-TAP\-Formatter\-HTML  |  noarch  |  perl\-TAP\-Formatter\-HTML  |  0\.11\-23\.amzn2023\.0\.2  | 
|  perl\-TAP\-Harness\-Archive  |  noarch  |  perl\-TAP\-Harness\-Archive  |  0\.18\-16\.amzn2023\.0\.2  | 
|  perl\-Task\-Perl\-Critic  |  noarch  |  perl\-Task\-Perl\-Critic  |  1\.008\-26\.amzn2023\.0\.2  | 
|  perl\-Task\-Weaken  |  noarch  |  perl\-Task\-Weaken  |  1\.06\-10\.amzn2023\.0\.2  | 
|  perl\-Template\-Toolkit  |  aarch64  |  perl\-Template\-Toolkit  |  3\.009\-3\.amzn2023\.0\.2  | 
|  perl\-Template\-Toolkit  |  x86\_64  |  perl\-Template\-Toolkit  |  3\.009\-3\.amzn2023\.0\.2  | 
|  perl\-Term\-ANSIColor  |  noarch  |  perl\-Term\-ANSIColor  |  5\.01\-459\.amzn2023\.0\.2  | 
|  perl\-Term\-Cap  |  noarch  |  perl\-Term\-Cap  |  1\.17\-458\.amzn2023\.0\.2  | 
|  perl\-TermReadKey  |  aarch64  |  perl\-TermReadKey  |  2\.38\-9\.amzn2023\.0\.2  | 
|  perl\-TermReadKey  |  x86\_64  |  perl\-TermReadKey  |  2\.38\-9\.amzn2023\.0\.2  | 
|  perl\-Term\-Size\-Any  |  noarch  |  perl\-Term\-Size\-Any  |  0\.002\-33\.amzn2023\.0\.2  | 
|  perl\-Term\-Size\-Perl  |  aarch64  |  perl\-Term\-Size\-Perl  |  0\.031\-10\.amzn2023\.0\.2  | 
|  perl\-Term\-Size\-Perl  |  x86\_64  |  perl\-Term\-Size\-Perl  |  0\.031\-10\.amzn2023\.0\.2  | 
|  perl\-Term\-Table  |  noarch  |  perl\-Term\-Table  |  0\.015\-6\.amzn2023\.0\.2  | 
|  perl\-Term\-UI  |  noarch  |  perl\-Term\-UI  |  0\.46\-18\.amzn2023\.0\.2  | 
|  perl\-Test2\-Plugin\-NoWarnings  |  noarch  |  perl\-Test2\-Plugin\-NoWarnings  |  0\.09\-3\.amzn2023\.0\.2  | 
|  perl\-Test2\-Suite  |  noarch  |  perl\-Test2\-Suite  |  0\.000141\-1\.amzn2023\.0\.2  | 
|  perl\-Test2\-Suite\-tests  |  noarch  |  perl\-Test2\-Suite  |  0\.000141\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-Apocalypse  |  noarch  |  perl\-Test\-Apocalypse  |  1\.006\-20\.amzn2023\.0\.2  | 
|  perl\-Test\-Assert  |  noarch  |  perl\-Test\-Assert  |  0\.0504\-32\.amzn2023\.0\.2  | 
|  perl\-Test\-AutoLoader  |  noarch  |  perl\-Test\-AutoLoader  |  0\.03\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-Base  |  noarch  |  perl\-Test\-Base  |  0\.89\-10\.amzn2023\.0\.2  | 
|  perl\-Test\-CheckChanges  |  noarch  |  perl\-Test\-CheckChanges  |  0\.14\-31\.amzn2023\.0\.2  | 
|  perl\-Test\-CheckDeps  |  noarch  |  perl\-Test\-CheckDeps  |  0\.010\-29\.amzn2023\.0\.2  | 
|  perl\-Test\-CheckManifest  |  noarch  |  perl\-Test\-CheckManifest  |  1\.42\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-Class  |  noarch  |  perl\-Test\-Class  |  0\.52\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-CleanNamespaces  |  noarch  |  perl\-Test\-CleanNamespaces  |  0\.24\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-Compile  |  noarch  |  perl\-Test\-Compile  |  2\.4\.1\-3\.amzn2023\.0\.2  | 
|  perl\-Test\-ConsistentVersion  |  noarch  |  perl\-Test\-ConsistentVersion  |  0\.3\.0\-18\.amzn2023\.0\.2  | 
|  perl\-Test\-CPAN\-Meta  |  noarch  |  perl\-Test\-CPAN\-Meta  |  0\.25\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-CPAN\-Meta\-JSON  |  noarch  |  perl\-Test\-CPAN\-Meta\-JSON  |  0\.16\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-CPAN\-Meta\-YAML  |  noarch  |  perl\-Test\-CPAN\-Meta\-YAML  |  0\.25\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Deep  |  noarch  |  perl\-Test\-Deep  |  1\.130\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-Differences  |  noarch  |  perl\-Test\-Differences  |  0\.6700\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-Dir  |  noarch  |  perl\-Test\-Dir  |  1\.16\-14\.amzn2023\.0\.2  | 
|  perl\-Test\-DistManifest  |  noarch  |  perl\-Test\-DistManifest  |  1\.014\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Distribution  |  noarch  |  perl\-Test\-Distribution  |  2\.00\-36\.amzn2023\.0\.2  | 
|  perl\-Test\-EOL  |  noarch  |  perl\-Test\-EOL  |  2\.02\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-Exception  |  noarch  |  perl\-Test\-Exception  |  0\.43\-16\.amzn2023\.0\.2  | 
|  perl\-Test\-FailWarnings  |  noarch  |  perl\-Test\-FailWarnings  |  0\.008\-22\.amzn2023\.0\.2  | 
|  perl\-Test\-Fatal  |  noarch  |  perl\-Test\-Fatal  |  0\.016\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-File  |  noarch  |  perl\-Test\-File  |  1\.44\.8\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-File\-ShareDir  |  noarch  |  perl\-Test\-File\-ShareDir  |  1\.001002\-13\.amzn2023\.0\.2  | 
|  perl\-Test\-Fixme  |  noarch  |  perl\-Test\-Fixme  |  0\.16\-14\.amzn2023\.0\.2  | 
|  perl\-Test\-Harness  |  noarch  |  perl\-Test\-Harness  |  3\.42\-459\.amzn2023\.0\.2  | 
|  perl\-Test\-HasVersion  |  noarch  |  perl\-Test\-HasVersion  |  0\.014\-16\.amzn2023\.0\.2  | 
|  perl\-Test\-Identity  |  noarch  |  perl\-Test\-Identity  |  0\.01\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-InDistDir  |  noarch  |  perl\-Test\-InDistDir  |  1\.112071\-15\.amzn2023\.0\.2  | 
|  perl\-Test\-Inter  |  noarch  |  perl\-Test\-Inter  |  1\.09\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-Kwalitee  |  noarch  |  perl\-Test\-Kwalitee  |  1\.28\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-LeakTrace  |  aarch64  |  perl\-Test\-LeakTrace  |  0\.17\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-LeakTrace  |  x86\_64  |  perl\-Test\-LeakTrace  |  0\.17\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-LongString  |  noarch  |  perl\-Test\-LongString  |  0\.17\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Manifest  |  noarch  |  perl\-Test\-Manifest  |  2\.022\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-Memory\-Cycle  |  noarch  |  perl\-Test\-Memory\-Cycle  |  1\.06\-17\.amzn2023\.0\.2  | 
|  perl\-Test\-MemoryGrowth  |  noarch  |  perl\-Test\-MemoryGrowth  |  0\.04\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-MinimumVersion  |  noarch  |  perl\-Test\-MinimumVersion  |  0\.101082\-17\.amzn2023\.0\.2  | 
|  perl\-Test\-MockObject  |  noarch  |  perl\-Test\-MockObject  |  1\.20200122\-5\.amzn2023\.0\.2  | 
|  perl\-Test\-MockRandom  |  noarch  |  perl\-Test\-MockRandom  |  1\.01\-14\.amzn2023\.0\.2  | 
|  perl\-Test\-Mojibake  |  noarch  |  perl\-Test\-Mojibake  |  1\.3\-18\.amzn2023\.0\.2  | 
|  perl\-Test\-Needs  |  noarch  |  perl\-Test\-Needs  |  0\.002006\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-NoBreakpoints  |  noarch  |  perl\-Test\-NoBreakpoints  |  0\.17\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-NoBreakpoints\-tests  |  noarch  |  perl\-Test\-NoBreakpoints  |  0\.17\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-NoPlan  |  noarch  |  perl\-Test\-NoPlan  |  0\.0\.6\-26\.amzn2023\.0\.2  | 
|  perl\-Test\-NoTabs  |  noarch  |  perl\-Test\-NoTabs  |  2\.02\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-NoWarnings  |  noarch  |  perl\-Test\-NoWarnings  |  1\.04\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-Object  |  noarch  |  perl\-Test\-Object  |  0\.08\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-Output  |  noarch  |  perl\-Test\-Output  |  1\.03\.3\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-Perl\-Critic  |  noarch  |  perl\-Test\-Perl\-Critic  |  1\.04\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-Perl\-Critic\-Progressive  |  noarch  |  perl\-Test\-Perl\-Critic\-Progressive  |  0\.03\-31\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod  |  noarch  |  perl\-Test\-Pod  |  1\.52\-10\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod\-Content  |  noarch  |  perl\-Test\-Pod\-Content  |  0\.0\.6\-26\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod\-Coverage  |  noarch  |  perl\-Test\-Pod\-Coverage  |  1\.10\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod\-LinkCheck  |  noarch  |  perl\-Test\-Pod\-LinkCheck  |  0\.008\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod\-No404s  |  noarch  |  perl\-Test\-Pod\-No404s  |  0\.02\-25\.amzn2023\.0\.2  | 
|  perl\-Test\-Pod\-Spelling\-CommonMistakes  |  noarch  |  perl\-Test\-Pod\-Spelling\-CommonMistakes  |  1\.001\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Portability\-Files  |  noarch  |  perl\-Test\-Portability\-Files  |  0\.10\-9\.amzn2023\.0\.2  | 
|  perl\-Test\-Prereq  |  noarch  |  perl\-Test\-Prereq  |  2\.003\-5\.amzn2023\.0\.2  | 
|  perl\-Test\-Refcount  |  noarch  |  perl\-Test\-Refcount  |  0\.10\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-Regexp  |  noarch  |  perl\-Test\-Regexp  |  2017040101\-14\.amzn2023\.0\.2  | 
|  perl\-Test\-Requires  |  noarch  |  perl\-Test\-Requires  |  0\.11\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-RequiresInternet  |  noarch  |  perl\-Test\-RequiresInternet  |  0\.05\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-Script  |  noarch  |  perl\-Test\-Script  |  1\.29\-1\.amzn2023\.0\.2  | 
|  perl\-Test\-Signature  |  noarch  |  perl\-Test\-Signature  |  1\.11\-22\.amzn2023\.0\.2  | 
|  perl\-Test\-Simple  |  noarch  |  perl\-Test\-Simple  |  1\.302183\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-Spelling  |  noarch  |  perl\-Test\-Spelling  |  0\.25\-7\.amzn2023\.0\.2  | 
|  perl\-Test\-Strict  |  noarch  |  perl\-Test\-Strict  |  0\.52\-6\.amzn2023\.0\.2  | 
|  perl\-Test\-SubCalls  |  noarch  |  perl\-Test\-SubCalls  |  1\.10\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-Synopsis  |  noarch  |  perl\-Test\-Synopsis  |  0\.16\-10\.amzn2023\.0\.2  | 
|  perl\-Test\-Taint  |  aarch64  |  perl\-Test\-Taint  |  1\.08\-6\.amzn2023\.0\.2  | 
|  perl\-Test\-Taint  |  x86\_64  |  perl\-Test\-Taint  |  1\.08\-6\.amzn2023\.0\.2  | 
|  perl\-Test\-TrailingSpace  |  noarch  |  perl\-Test\-TrailingSpace  |  0\.0600\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-Trap  |  noarch  |  perl\-Test\-Trap  |  0\.3\.4\-8\.amzn2023\.0\.2  | 
|  perl\-Test\-Unit\-Lite  |  noarch  |  perl\-Test\-Unit\-Lite  |  0\.12\-40\.amzn2023\.0\.2  | 
|  perl\-Test\-UseAllModules  |  noarch  |  perl\-Test\-UseAllModules  |  0\.17\-19\.amzn2023\.0\.2  | 
|  perl\-Test\-utf8  |  noarch  |  perl\-Test\-utf8  |  1\.02\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-Valgrind  |  noarch  |  perl\-Test\-Valgrind  |  1\.19\-16\.amzn2023\.0\.2  | 
|  perl\-Test\-Vars  |  noarch  |  perl\-Test\-Vars  |  0\.014\-18\.amzn2023\.0\.2  | 
|  perl\-Test\-Version  |  noarch  |  perl\-Test\-Version  |  2\.09\-13\.amzn2023\.0\.2  | 
|  perl\-Test\-Warn  |  noarch  |  perl\-Test\-Warn  |  0\.36\-11\.amzn2023\.0\.2  | 
|  perl\-Test\-Warnings  |  noarch  |  perl\-Test\-Warnings  |  0\.030\-4\.amzn2023\.0\.2  | 
|  perl\-Test\-Without\-Module  |  noarch  |  perl\-Test\-Without\-Module  |  0\.20\-14\.amzn2023\.0\.2  | 
|  perl\-Test\-YAML  |  noarch  |  perl\-Test\-YAML  |  1\.07\-10\.amzn2023\.0\.2  | 
|  perl\-Test\-YAML\-Valid  |  noarch  |  perl\-Test\-YAML\-Valid  |  0\.04\-33\.amzn2023\.0\.2  | 
|  perl\-TeX\-Hyphen  |  noarch  |  perl\-TeX\-Hyphen  |  1\.18\-14\.amzn2023\.0\.2  | 
|  perl\-Text\-Autoformat  |  noarch  |  perl\-Text\-Autoformat  |  1\.750000\-5\.amzn2023\.0\.2  | 
|  perl\-Text\-Balanced  |  noarch  |  perl\-Text\-Balanced  |  2\.04\-2\.amzn2023\.0\.2  | 
|  perl\-Text\-BibTeX  |  aarch64  |  perl\-Text\-BibTeX  |  0\.88\-7\.amzn2023\.0\.2  | 
|  perl\-Text\-BibTeX  |  x86\_64  |  perl\-Text\-BibTeX  |  0\.88\-7\.amzn2023\.0\.2  | 
|  perl\-Text\-CharWidth  |  aarch64  |  perl\-Text\-CharWidth  |  0\.04\-42\.amzn2023\.0\.2  | 
|  perl\-Text\-CharWidth  |  x86\_64  |  perl\-Text\-CharWidth  |  0\.04\-42\.amzn2023\.0\.2  | 
|  perl\-Text\-CSV  |  noarch  |  perl\-Text\-CSV  |  2\.00\-6\.amzn2023\.0\.2  | 
|  perl\-Text\-CSV\_XS  |  aarch64  |  perl\-Text\-CSV\_XS  |  1\.46\-1\.amzn2023\.0\.2  | 
|  perl\-Text\-CSV\_XS  |  x86\_64  |  perl\-Text\-CSV\_XS  |  1\.46\-1\.amzn2023\.0\.2  | 
|  perl\-Text\-Diff  |  noarch  |  perl\-Text\-Diff  |  1\.45\-11\.amzn2023\.0\.2  | 
|  perl\-Text\-Glob  |  noarch  |  perl\-Text\-Glob  |  0\.11\-13\.amzn2023\.0\.2  | 
|  perl\-Text\-Iconv  |  aarch64  |  perl\-Text\-Iconv  |  1\.7\-41\.amzn2023\.0\.2  | 
|  perl\-Text\-Iconv  |  x86\_64  |  perl\-Text\-Iconv  |  1\.7\-41\.amzn2023\.0\.2  | 
|  perl\-Text\-ParseWords  |  noarch  |  perl\-Text\-ParseWords  |  3\.30\-458\.amzn2023\.0\.2  | 
|  perl\-Text\-RecordParser  |  noarch  |  perl\-Text\-RecordParser  |  1\.6\.5\-19\.amzn2023\.0\.2  | 
|  perl\-Text\-Reform  |  noarch  |  perl\-Text\-Reform  |  1\.20\-29\.amzn2023\.0\.2  | 
|  perl\-Text\-Roman  |  noarch  |  perl\-Text\-Roman  |  3\.5\-18\.amzn2023\.0\.2  | 
|  perl\-Text\-Soundex  |  aarch64  |  perl\-Text\-Soundex  |  3\.05\-18\.amzn2023\.0\.2  | 
|  perl\-Text\-Soundex  |  x86\_64  |  perl\-Text\-Soundex  |  3\.05\-18\.amzn2023\.0\.2  | 
|  perl\-Text\-Tabs\+Wrap  |  noarch  |  perl\-Text\-Tabs\+Wrap  |  2021\.0726\-1\.amzn2023\.0\.1  | 
|  perl\-Text\-Tabs\+Wrap\-tests  |  noarch  |  perl\-Text\-Tabs\+Wrap  |  2021\.0726\-1\.amzn2023\.0\.1  | 
|  perl\-Text\-TabularDisplay  |  noarch  |  perl\-Text\-TabularDisplay  |  1\.38\-19\.amzn2023\.0\.2  | 
|  perl\-Text\-Template  |  noarch  |  perl\-Text\-Template  |  1\.59\-3\.amzn2023\.0\.2  | 
|  perl\-Text\-Unidecode  |  noarch  |  perl\-Text\-Unidecode  |  1\.30\-14\.amzn2023\.0\.2  | 
|  perl\-Text\-WrapI18N  |  noarch  |  perl\-Text\-WrapI18N  |  0\.06\-39\.amzn2023\.0\.2  | 
|  perl\-Thread\-Queue  |  noarch  |  perl\-Thread\-Queue  |  3\.14\-458\.amzn2023\.0\.2  | 
|  perl\-threads  |  aarch64  |  perl\-threads  |  2\.25\-458\.amzn2023\.0\.3  | 
|  perl\-threads  |  x86\_64  |  perl\-threads  |  2\.25\-458\.amzn2023\.0\.3  | 
|  perl\-threads\-shared  |  aarch64  |  perl\-threads\-shared  |  1\.61\-458\.amzn2023\.0\.2  | 
|  perl\-threads\-shared  |  x86\_64  |  perl\-threads\-shared  |  1\.61\-458\.amzn2023\.0\.2  | 
|  perltidy  |  noarch  |  perltidy  |  20210402\-1\.amzn2023\.0\.3  | 
|  perl\-Tie\-Cycle  |  noarch  |  perl\-Tie\-Cycle  |  1\.226\-1\.amzn2023\.0\.2  | 
|  perl\-Tie\-IxHash  |  noarch  |  perl\-Tie\-IxHash  |  1\.23\-26\.amzn2023\.0\.2  | 
|  perl\-Tie\-RefHash  |  noarch  |  perl\-Tie\-RefHash  |  1\.40\-2\.amzn2023\.0\.2  | 
|  perl\-Tie\-RefHash\-Weak  |  noarch  |  perl\-Tie\-RefHash\-Weak  |  0\.09\-35\.amzn2023\.0\.2  | 
|  perl\-Tie\-ToObject  |  noarch  |  perl\-Tie\-ToObject  |  0\.03\-37\.amzn2023\.0\.2  | 
|  perl\-TimeDate  |  noarch  |  perl\-TimeDate  |  2\.33\-4\.amzn2023\.0\.2  | 
|  perl\-Time\-HiRes  |  aarch64  |  perl\-Time\-HiRes  |  1\.9764\-460\.amzn2023\.0\.2  | 
|  perl\-Time\-HiRes  |  x86\_64  |  perl\-Time\-HiRes  |  1\.9764\-460\.amzn2023\.0\.2  | 
|  perl\-Time\-Local  |  noarch  |  perl\-Time\-Local  |  1\.300\-5\.amzn2023\.0\.2  | 
|  perl\-Tk  |  aarch64  |  perl\-Tk  |  804\.036\-3\.amzn2023\.0\.2  | 
|  perl\-Tk  |  x86\_64  |  perl\-Tk  |  804\.036\-3\.amzn2023\.0\.2  | 
|  perl\-Tk\-devel  |  aarch64  |  perl\-Tk  |  804\.036\-3\.amzn2023\.0\.2  | 
|  perl\-Tk\-devel  |  x86\_64  |  perl\-Tk  |  804\.036\-3\.amzn2023\.0\.2  | 
|  perl\-Tk\-Pod  |  noarch  |  perl\-Tk\-Pod  |  0\.9943\-16\.amzn2023\.0\.2  | 
|  perl\-Try\-Tiny  |  noarch  |  perl\-Try\-Tiny  |  0\.30\-11\.amzn2023\.0\.2  | 
|  perl\-Types\-Path\-Tiny  |  noarch  |  perl\-Types\-Path\-Tiny  |  0\.006\-10\.amzn2023\.0\.2  | 
|  perl\-Types\-Serialiser  |  noarch  |  perl\-Types\-Serialiser  |  1\.01\-2\.amzn2023\.0\.2  | 
|  perl\-Type\-Tie  |  noarch  |  perl\-Type\-Tie  |  0\.015\-2\.amzn2023\.0\.2  | 
|  perl\-Test\-TypeTiny  |  noarch  |  perl\-Type\-Tiny  |  1\.012004\-1\.amzn2023\.0\.3  | 
|  perl\-Type\-Tiny  |  noarch  |  perl\-Type\-Tiny  |  1\.012004\-1\.amzn2023\.0\.3  | 
|  perl\-Unicode\-CheckUTF8  |  aarch64  |  perl\-Unicode\-CheckUTF8  |  1\.03\-31\.amzn2023\.0\.2  | 
|  perl\-Unicode\-CheckUTF8  |  x86\_64  |  perl\-Unicode\-CheckUTF8  |  1\.03\-31\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Collate  |  aarch64  |  perl\-Unicode\-Collate  |  1\.29\-2\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Collate  |  x86\_64  |  perl\-Unicode\-Collate  |  1\.29\-2\.amzn2023\.0\.2  | 
|  perl\-Unicode\-EastAsianWidth  |  noarch  |  perl\-Unicode\-EastAsianWidth  |  12\.0\-5\.amzn2023\.0\.2  | 
|  perl\-Unicode\-LineBreak  |  aarch64  |  perl\-Unicode\-LineBreak  |  2019\.001\-9\.amzn2023\.0\.2  | 
|  perl\-Unicode\-LineBreak  |  x86\_64  |  perl\-Unicode\-LineBreak  |  2019\.001\-9\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Map  |  aarch64  |  perl\-Unicode\-Map  |  0\.112\-53\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Map  |  x86\_64  |  perl\-Unicode\-Map  |  0\.112\-53\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Map8  |  aarch64  |  perl\-Unicode\-Map8  |  0\.13\-37\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Map8  |  x86\_64  |  perl\-Unicode\-Map8  |  0\.13\-37\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Normalize  |  aarch64  |  perl\-Unicode\-Normalize  |  1\.27\-459\.amzn2023\.0\.2  | 
|  perl\-Unicode\-Normalize  |  x86\_64  |  perl\-Unicode\-Normalize  |  1\.27\-459\.amzn2023\.0\.2  | 
|  perl\-Unicode\-String  |  aarch64  |  perl\-Unicode\-String  |  2\.10\-16\.amzn2023\.0\.2  | 
|  perl\-Unicode\-String  |  x86\_64  |  perl\-Unicode\-String  |  2\.10\-16\.amzn2023\.0\.2  | 
|  perl\-Unicode\-UTF8  |  aarch64  |  perl\-Unicode\-UTF8  |  0\.62\-14\.amzn2023\.0\.2  | 
|  perl\-Unicode\-UTF8  |  x86\_64  |  perl\-Unicode\-UTF8  |  0\.62\-14\.amzn2023\.0\.2  | 
|  perl\-UNIVERSAL\-can  |  noarch  |  perl\-UNIVERSAL\-can  |  1\.20140328\-19\.amzn2023\.0\.2  | 
|  perl\-UNIVERSAL\-isa  |  noarch  |  perl\-UNIVERSAL\-isa  |  1\.20171012\-11\.amzn2023\.0\.2  | 
|  perl\-UNIVERSAL\-require  |  noarch  |  perl\-UNIVERSAL\-require  |  0\.19\-1\.amzn2023\.0\.2  | 
|  perl\-URI  |  noarch  |  perl\-URI  |  5\.09\-1\.amzn2023\.0\.2  | 
|  perl\-URI\-tests  |  noarch  |  perl\-URI  |  5\.09\-1\.amzn2023\.0\.2  | 
|  perl\-URI\-cpan  |  noarch  |  perl\-URI\-cpan  |  1\.007\-5\.amzn2023\.0\.2  | 
|  perl\-URI\-Find  |  noarch  |  perl\-URI\-Find  |  20160806\-14\.amzn2023\.0\.2  | 
|  perl\-utf8\-all  |  noarch  |  perl\-utf8\-all  |  0\.024\-12\.amzn2023\.0\.2  | 
|  perl\-Variable\-Magic  |  aarch64  |  perl\-Variable\-Magic  |  0\.62\-12\.amzn2023\.0\.2  | 
|  perl\-Variable\-Magic  |  x86\_64  |  perl\-Variable\-Magic  |  0\.62\-12\.amzn2023\.0\.2  | 
|  perl\-version  |  aarch64  |  perl\-version  |  0\.99\.29\-1\.amzn2023\.0\.2  | 
|  perl\-version  |  x86\_64  |  perl\-version  |  0\.99\.29\-1\.amzn2023\.0\.2  | 
|  perl\-version\-tests  |  aarch64  |  perl\-version  |  0\.99\.29\-1\.amzn2023\.0\.2  | 
|  perl\-version\-tests  |  x86\_64  |  perl\-version  |  0\.99\.29\-1\.amzn2023\.0\.2  | 
|  perl\-Want  |  aarch64  |  perl\-Want  |  0\.29\-17\.amzn2023\.0\.2  | 
|  perl\-Want  |  x86\_64  |  perl\-Want  |  0\.29\-17\.amzn2023\.0\.2  | 
|  perl\-WWW\-Mechanize  |  noarch  |  perl\-WWW\-Mechanize  |  2\.07\-1\.amzn2023\.0\.3  | 
|  perl\-WWW\-RobotRules  |  noarch  |  perl\-WWW\-RobotRules  |  6\.02\-28\.amzn2023\.0\.2  | 
|  perl\-XML\-Catalog  |  noarch  |  perl\-XML\-Catalog  |  1\.03\-20\.amzn2023\.0\.2  | 
|  perl\-XML\-DOM  |  noarch  |  perl\-XML\-DOM  |  1\.46\-14\.amzn2023\.0\.2  | 
|  perl\-XML\-Dumper  |  noarch  |  perl\-XML\-Dumper  |  0\.81\-39\.amzn2023\.0\.2  | 
|  perl\-XML\-Filter\-BufferText  |  noarch  |  perl\-XML\-Filter\-BufferText  |  1\.01\-38\.amzn2023\.0\.2  | 
|  perl\-XML\-Handler\-YAWriter  |  noarch  |  perl\-XML\-Handler\-YAWriter  |  0\.23\-39\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXML  |  aarch64  |  perl\-XML\-LibXML  |  2\.0207\-1\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXML  |  x86\_64  |  perl\-XML\-LibXML  |  2\.0207\-1\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXML\-tests  |  aarch64  |  perl\-XML\-LibXML  |  2\.0207\-1\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXML\-tests  |  x86\_64  |  perl\-XML\-LibXML  |  2\.0207\-1\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXML\-Simple  |  noarch  |  perl\-XML\-LibXML\-Simple  |  1\.01\-5\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXSLT  |  aarch64  |  perl\-XML\-LibXSLT  |  1\.99\-5\.amzn2023\.0\.2  | 
|  perl\-XML\-LibXSLT  |  x86\_64  |  perl\-XML\-LibXSLT  |  1\.99\-5\.amzn2023\.0\.2  | 
|  perl\-XML\-NamespaceSupport  |  noarch  |  perl\-XML\-NamespaceSupport  |  1\.12\-13\.amzn2023\.0\.2  | 
|  perl\-XML\-Parser  |  aarch64  |  perl\-XML\-Parser  |  2\.46\-7\.amzn2023\.0\.2  | 
|  perl\-XML\-Parser  |  x86\_64  |  perl\-XML\-Parser  |  2\.46\-7\.amzn2023\.0\.2  | 
|  perl\-XML\-RegExp  |  noarch  |  perl\-XML\-RegExp  |  0\.04\-23\.amzn2023\.0\.2  | 
|  perl\-XML\-SAX  |  noarch  |  perl\-XML\-SAX  |  1\.02\-6\.amzn2023\.0\.2  | 
|  perl\-XML\-SAX\-Base  |  noarch  |  perl\-XML\-SAX\-Base  |  1\.09\-13\.amzn2023\.0\.2  | 
|  perl\-XML\-SAX\-Writer  |  noarch  |  perl\-XML\-SAX\-Writer  |  0\.57\-11\.amzn2023\.0\.2  | 
|  perl\-XML\-Simple  |  noarch  |  perl\-XML\-Simple  |  2\.25\-10\.amzn2023\.0\.2  | 
|  perl\-XML\-TokeParser  |  noarch  |  perl\-XML\-TokeParser  |  0\.05\-34\.amzn2023\.0\.2  | 
|  perl\-XML\-TreeBuilder  |  noarch  |  perl\-XML\-TreeBuilder  |  5\.4\-20\.amzn2023\.0\.2  | 
|  perl\-XML\-Twig  |  noarch  |  perl\-XML\-Twig  |  3\.52\-16\.amzn2023\.0\.2  | 
|  perl\-XML\-Writer  |  noarch  |  perl\-XML\-Writer  |  0\.900\-3\.amzn2023\.0\.2  | 
|  perl\-XML\-XPath  |  noarch  |  perl\-XML\-XPath  |  1\.44\-9\.amzn2023\.0\.2  | 
|  perl\-XML\-XPathEngine  |  noarch  |  perl\-XML\-XPathEngine  |  0\.14\-21\.amzn2023\.0\.2  | 
|  perl\-XString  |  aarch64  |  perl\-XString  |  0\.005\-2\.amzn2023\.0\.2  | 
|  perl\-XString  |  x86\_64  |  perl\-XString  |  0\.005\-2\.amzn2023\.0\.2  | 
|  perl\-YAML  |  noarch  |  perl\-YAML  |  1\.30\-6\.amzn2023\.0\.2  | 
|  perl\-YAML\-LibYAML  |  aarch64  |  perl\-YAML\-LibYAML  |  0\.82\-4\.amzn2023\.0\.2  | 
|  perl\-YAML\-LibYAML  |  x86\_64  |  perl\-YAML\-LibYAML  |  0\.82\-4\.amzn2023\.0\.2  | 
|  perl\-YAML\-Syck  |  aarch64  |  perl\-YAML\-Syck  |  1\.34\-2\.amzn2023\.0\.2  | 
|  perl\-YAML\-Syck  |  x86\_64  |  perl\-YAML\-Syck  |  1\.34\-2\.amzn2023\.0\.2  | 
|  perl\-YAML\-Tiny  |  noarch  |  perl\-YAML\-Tiny  |  1\.73\-11\.amzn2023\.0\.3  | 
|  pesign  |  aarch64  |  pesign  |  116\-2\.amzn2023\.0\.2  | 
|  pesign  |  x86\_64  |  pesign  |  116\-2\.amzn2023\.0\.2  | 
|  php8\.1  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-bcmath  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-bcmath  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-cli  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-cli  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-common  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-common  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-dba  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-dba  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-dbg  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-dbg  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-devel  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-devel  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-embedded  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-embedded  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-enchant  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-enchant  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-ffi  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-ffi  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-fpm  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-fpm  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-gd  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-gd  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-gmp  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-gmp  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-intl  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-intl  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-ldap  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-ldap  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-mbstring  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-mbstring  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-mysqlnd  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-mysqlnd  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-odbc  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-odbc  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-opcache  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-opcache  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pdo  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pdo  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pgsql  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pgsql  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-process  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-process  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pspell  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-pspell  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-snmp  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-snmp  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-soap  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-soap  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-tidy  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-tidy  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-xml  |  aarch64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.1\-xml  |  x86\_64  |  php8\.1  |  8\.1\.21\-1\.amzn2023\.0\.1  | 
|  php8\.2  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-bcmath  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-bcmath  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-cli  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-cli  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-common  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-common  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-dba  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-dba  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-dbg  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-dbg  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-devel  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-devel  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-embedded  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-embedded  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-enchant  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-enchant  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-ffi  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-ffi  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-fpm  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-fpm  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-gd  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-gd  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-gmp  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-gmp  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-intl  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-intl  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-ldap  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-ldap  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-mbstring  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-mbstring  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-mysqlnd  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-mysqlnd  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-odbc  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-odbc  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-opcache  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-opcache  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pdo  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pdo  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pgsql  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pgsql  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-process  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-process  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pspell  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-pspell  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-snmp  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-snmp  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-soap  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-soap  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-tidy  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-tidy  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-xml  |  aarch64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php8\.2\-xml  |  x86\_64  |  php8\.2  |  8\.2\.7\-1\.amzn2023\.0\.1  | 
|  php\-pear  |  noarch  |  php\-pear  |  1\.10\.13\-2\.amzn2023\.0\.4  | 
|  pigz  |  aarch64  |  pigz  |  2\.5\-1\.amzn2023\.0\.3  | 
|  pigz  |  x86\_64  |  pigz  |  2\.5\-1\.amzn2023\.0\.3  | 
|  pinentry  |  aarch64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pinentry  |  x86\_64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pinentry\-emacs  |  aarch64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pinentry\-emacs  |  x86\_64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pinentry\-tty  |  aarch64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pinentry\-tty  |  x86\_64  |  pinentry  |  1\.2\.0\-1\.amzn2023\.0\.5  | 
|  pixman  |  aarch64  |  pixman  |  0\.40\.0\-3\.amzn2023\.0\.3  | 
|  pixman  |  x86\_64  |  pixman  |  0\.40\.0\-3\.amzn2023\.0\.3  | 
|  pixman\-devel  |  aarch64  |  pixman  |  0\.40\.0\-3\.amzn2023\.0\.3  | 
|  pixman\-devel  |  x86\_64  |  pixman  |  0\.40\.0\-3\.amzn2023\.0\.3  | 
|  libpkgconf  |  aarch64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  libpkgconf  |  x86\_64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  libpkgconf\-devel  |  aarch64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  libpkgconf\-devel  |  x86\_64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  pkgconf  |  aarch64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  pkgconf  |  x86\_64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  pkgconf\-m4  |  noarch  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  pkgconf\-pkg\-config  |  aarch64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  pkgconf\-pkg\-config  |  x86\_64  |  pkgconf  |  1\.8\.0\-4\.amzn2023\.0\.2  | 
|  plexus\-archiver  |  noarch  |  plexus\-archiver  |  4\.2\.4\-5\.amzn2023\.0\.3  | 
|  plexus\-archiver\-javadoc  |  noarch  |  plexus\-archiver  |  4\.2\.4\-5\.amzn2023\.0\.3  | 
|  plexus\-build\-api  |  noarch  |  plexus\-build\-api  |  0\.0\.7\-36\.amzn2023\.0\.3  | 
|  plexus\-build\-api\-javadoc  |  noarch  |  plexus\-build\-api  |  0\.0\.7\-36\.amzn2023\.0\.3  | 
|  plexus\-cipher  |  noarch  |  plexus\-cipher  |  1\.8\-3\.amzn2023\.0\.3  | 
|  plexus\-cipher\-javadoc  |  noarch  |  plexus\-cipher  |  1\.8\-3\.amzn2023\.0\.3  | 
|  plexus\-classworlds  |  noarch  |  plexus\-classworlds  |  2\.6\.0\-10\.amzn2023\.0\.4  | 
|  plexus\-classworlds\-javadoc  |  noarch  |  plexus\-classworlds  |  2\.6\.0\-10\.amzn2023\.0\.4  | 
|  plexus\-compiler  |  noarch  |  plexus\-compiler  |  2\.8\.8\-5\.amzn2023\.0\.3  | 
|  plexus\-compiler\-extras  |  noarch  |  plexus\-compiler  |  2\.8\.8\-5\.amzn2023\.0\.3  | 
|  plexus\-compiler\-javadoc  |  noarch  |  plexus\-compiler  |  2\.8\.8\-5\.amzn2023\.0\.3  | 
|  plexus\-compiler\-pom  |  noarch  |  plexus\-compiler  |  2\.8\.8\-5\.amzn2023\.0\.3  | 
|  plexus\-component\-api  |  noarch  |  plexus\-component\-api  |  1\.0\-0\.34\.alpha15\.amzn2023\.0\.3  | 
|  plexus\-component\-api\-javadoc  |  noarch  |  plexus\-component\-api  |  1\.0\-0\.34\.alpha15\.amzn2023\.0\.3  | 
|  plexus\-components\-pom  |  noarch  |  plexus\-components\-pom  |  6\.5\-6\.amzn2023\.0\.3  | 
|  plexus\-containers  |  noarch  |  plexus\-containers  |  2\.1\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-containers\-component\-annotations  |  noarch  |  plexus\-containers  |  2\.1\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-containers\-component\-metadata  |  noarch  |  plexus\-containers  |  2\.1\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-containers\-container\-default  |  noarch  |  plexus\-containers  |  2\.1\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-containers\-javadoc  |  noarch  |  plexus\-containers  |  2\.1\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-i18n  |  noarch  |  plexus\-i18n  |  1\.0\-0\.19\.b10\.4\.amzn2023\.0\.3  | 
|  plexus\-i18n\-javadoc  |  noarch  |  plexus\-i18n  |  1\.0\-0\.19\.b10\.4\.amzn2023\.0\.3  | 
|  plexus\-interpolation  |  noarch  |  plexus\-interpolation  |  1\.26\-10\.amzn2023\.0\.4  | 
|  plexus\-interpolation\-javadoc  |  noarch  |  plexus\-interpolation  |  1\.26\-10\.amzn2023\.0\.4  | 
|  plexus\-io  |  noarch  |  plexus\-io  |  3\.2\.0\-9\.amzn2023\.0\.3  | 
|  plexus\-io\-javadoc  |  noarch  |  plexus\-io  |  3\.2\.0\-9\.amzn2023\.0\.3  | 
|  plexus\-languages  |  noarch  |  plexus\-languages  |  1\.0\.6\-6\.amzn2023\.0\.3  | 
|  plexus\-languages\-javadoc  |  noarch  |  plexus\-languages  |  1\.0\.6\-6\.amzn2023\.0\.3  | 
|  plexus\-pom  |  noarch  |  plexus\-pom  |  7\-5\.amzn2023\.0\.3  | 
|  plexus\-resources  |  noarch  |  plexus\-resources  |  1\.1\.0\-9\.amzn2023\.0\.3  | 
|  plexus\-resources\-javadoc  |  noarch  |  plexus\-resources  |  1\.1\.0\-9\.amzn2023\.0\.3  | 
|  plexus\-sec\-dispatcher  |  noarch  |  plexus\-sec\-dispatcher  |  2\.0\-3\.amzn2023\.0\.3  | 
|  plexus\-sec\-dispatcher\-javadoc  |  noarch  |  plexus\-sec\-dispatcher  |  2\.0\-3\.amzn2023\.0\.3  | 
|  plexus\-utils  |  noarch  |  plexus\-utils  |  3\.3\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-utils\-javadoc  |  noarch  |  plexus\-utils  |  3\.3\.0\-9\.amzn2023\.0\.4  | 
|  plexus\-velocity  |  noarch  |  plexus\-velocity  |  1\.2\-15\.amzn2023\.0\.2  | 
|  plexus\-velocity\-javadoc  |  noarch  |  plexus\-velocity  |  1\.2\-15\.amzn2023\.0\.2  | 
|  plotutils  |  aarch64  |  plotutils  |  2\.6\-26\.amzn2023\.0\.2  | 
|  plotutils  |  x86\_64  |  plotutils  |  2\.6\-26\.amzn2023\.0\.2  | 
|  plotutils\-devel  |  aarch64  |  plotutils  |  2\.6\-26\.amzn2023\.0\.2  | 
|  plotutils\-devel  |  x86\_64  |  plotutils  |  2\.6\-26\.amzn2023\.0\.2  | 
|  pmix  |  aarch64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix  |  x86\_64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-devel  |  aarch64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-devel  |  x86\_64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-pmi  |  aarch64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-pmi  |  x86\_64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-pmi\-devel  |  aarch64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-pmi\-devel  |  x86\_64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-tools  |  aarch64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pmix\-tools  |  x86\_64  |  pmix  |  3\.2\.3\-1\.amzn2023\.0\.2  | 
|  pngquant  |  aarch64  |  pngquant  |  2\.14\.1\-1\.amzn2023\.0\.1  | 
|  pngquant  |  x86\_64  |  pngquant  |  2\.14\.1\-1\.amzn2023\.0\.1  | 
|  po4a  |  noarch  |  po4a  |  0\.64\-1\.amzn2023\.0\.2  | 
|  policycoreutils  |  aarch64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils  |  x86\_64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-dbus  |  noarch  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-devel  |  aarch64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-devel  |  x86\_64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-gui  |  noarch  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-newrole  |  aarch64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-newrole  |  x86\_64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-python\-utils  |  noarch  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-restorecond  |  aarch64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  policycoreutils\-restorecond  |  x86\_64  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  python3\-policycoreutils  |  noarch  |  policycoreutils  |  3\.4\-6\.amzn2023\.0\.2  | 
|  polkit  |  aarch64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit  |  x86\_64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-devel  |  aarch64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-devel  |  x86\_64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-docs  |  noarch  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-libs  |  aarch64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-libs  |  x86\_64  |  polkit  |  0\.117\-11\.amzn2023  | 
|  polkit\-pkla\-compat  |  aarch64  |  polkit\-pkla\-compat  |  0\.1\-19\.amzn2023\.0\.2  | 
|  polkit\-pkla\-compat  |  x86\_64  |  polkit\-pkla\-compat  |  0\.1\-19\.amzn2023\.0\.2  | 
|  poppler  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-cpp  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-cpp  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-cpp\-devel  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-cpp\-devel  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-devel  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-devel  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-glib  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-glib  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-glib\-devel  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-glib\-devel  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-glib\-doc  |  noarch  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-utils  |  aarch64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-utils  |  x86\_64  |  poppler  |  22\.08\.0\-3\.amzn2023\.0\.1  | 
|  poppler\-data  |  noarch  |  poppler\-data  |  0\.4\.9\-7\.amzn2023\.0\.2  | 
|  poppler\-data\-devel  |  noarch  |  poppler\-data  |  0\.4\.9\-7\.amzn2023\.0\.2  | 
|  popt  |  aarch64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  popt  |  x86\_64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  popt\-devel  |  aarch64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  popt\-devel  |  x86\_64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  popt\-static  |  aarch64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  popt\-static  |  x86\_64  |  popt  |  1\.18\-6\.amzn2023\.0\.2  | 
|  postfix  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-cdb  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-cdb  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-ldap  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-ldap  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-lmdb  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-lmdb  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-mysql  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-mysql  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-pcre  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-pcre  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-perl\-scripts  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-perl\-scripts  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-pgsql  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-pgsql  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-sqlite  |  aarch64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postfix\-sqlite  |  x86\_64  |  postfix  |  3\.7\.2\-4\.amzn2023\.0\.4  | 
|  postgresql15  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-contrib  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-contrib  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-docs  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-docs  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-llvmjit  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-llvmjit  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-plperl  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-plperl  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-plpython3  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-plpython3  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-pltcl  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-pltcl  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-private\-devel  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-private\-devel  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-private\-libs  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-private\-libs  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-server  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-server  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-server\-devel  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-server\-devel  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-static  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-static  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-test  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-test  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-test\-rpm\-macros  |  noarch  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-upgrade  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-upgrade  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-upgrade\-devel  |  aarch64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  postgresql15\-upgrade\-devel  |  x86\_64  |  postgresql15  |  15\.0\-1\.amzn2023\.0\.3  | 
|  potrace  |  aarch64  |  potrace  |  1\.16\-5\.amzn2023  | 
|  potrace  |  x86\_64  |  potrace  |  1\.16\-5\.amzn2023  | 
|  potrace\-devel  |  aarch64  |  potrace  |  1\.16\-5\.amzn2023  | 
|  potrace\-devel  |  x86\_64  |  potrace  |  1\.16\-5\.amzn2023  | 
|  potrace\-doc  |  noarch  |  potrace  |  1\.16\-5\.amzn2023  | 
|  pps\-tools  |  aarch64  |  pps\-tools  |  1\.0\.2\-7\.amzn2023\.0\.2  | 
|  pps\-tools  |  x86\_64  |  pps\-tools  |  1\.0\.2\-7\.amzn2023\.0\.2  | 
|  pps\-tools\-devel  |  aarch64  |  pps\-tools  |  1\.0\.2\-7\.amzn2023\.0\.2  | 
|  pps\-tools\-devel  |  x86\_64  |  pps\-tools  |  1\.0\.2\-7\.amzn2023\.0\.2  | 
|  procmail  |  aarch64  |  procmail  |  3\.24\-1\.amzn2023\.0\.2  | 
|  procmail  |  x86\_64  |  procmail  |  3\.24\-1\.amzn2023\.0\.2  | 
|  procps\-ng  |  aarch64  |  procps\-ng  |  3\.3\.17\-1\.amzn2023\.0\.2  | 
|  procps\-ng  |  x86\_64  |  procps\-ng  |  3\.3\.17\-1\.amzn2023\.0\.2  | 
|  procps\-ng\-devel  |  aarch64  |  procps\-ng  |  3\.3\.17\-1\.amzn2023\.0\.2  | 
|  procps\-ng\-devel  |  x86\_64  |  procps\-ng  |  3\.3\.17\-1\.amzn2023\.0\.2  | 
|  procps\-ng\-i18n  |  noarch  |  procps\-ng  |  3\.3\.17\-1\.amzn2023\.0\.2  | 
|  protobuf  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-compiler  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-compiler  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-devel  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-devel  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-emacs  |  noarch  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite\-devel  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite\-devel  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite\-static  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-lite\-static  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-static  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-static  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-vim  |  noarch  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  python3\-protobuf  |  aarch64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  python3\-protobuf  |  noarch  |  protobuf  |  3\.14\.0\-7\.amzn2023\.0\.3  | 
|  python3\-protobuf  |  x86\_64  |  protobuf  |  3\.19\.6\-1\.amzn2023\.0\.1  | 
|  protobuf\-c  |  aarch64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  protobuf\-c  |  x86\_64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  protobuf\-c\-compiler  |  aarch64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  protobuf\-c\-compiler  |  x86\_64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  protobuf\-c\-devel  |  aarch64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  protobuf\-c\-devel  |  x86\_64  |  protobuf\-c  |  1\.4\.1\-2\.amzn2023\.0\.3  | 
|  psacct  |  aarch64  |  psacct  |  6\.6\.4\-9\.amzn2023\.0\.2  | 
|  psacct  |  x86\_64  |  psacct  |  6\.6\.4\-9\.amzn2023\.0\.2  | 
|  psmisc  |  aarch64  |  psmisc  |  23\.4\-1\.amzn2023\.0\.2  | 
|  psmisc  |  x86\_64  |  psmisc  |  23\.4\-1\.amzn2023\.0\.2  | 
|  pstoedit  |  aarch64  |  pstoedit  |  3\.78\-4\.amzn2023\.0\.3  | 
|  pstoedit  |  x86\_64  |  pstoedit  |  3\.78\-4\.amzn2023\.0\.3  | 
|  pstoedit\-devel  |  aarch64  |  pstoedit  |  3\.78\-4\.amzn2023\.0\.3  | 
|  pstoedit\-devel  |  x86\_64  |  pstoedit  |  3\.78\-4\.amzn2023\.0\.3  | 
|  psutils  |  noarch  |  psutils  |  2\.05\-1\.amzn2023\.0\.2  | 
|  psutils\-tests  |  noarch  |  psutils  |  2\.05\-1\.amzn2023\.0\.2  | 
|  publicsuffix\-list  |  noarch  |  publicsuffix\-list  |  20221208\-60\.amzn2023  | 
|  publicsuffix\-list\-dafsa  |  noarch  |  publicsuffix\-list  |  20221208\-60\.amzn2023  | 
|  pulseaudio  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs\-devel  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs\-devel  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs\-glib2  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-libs\-glib2  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-gsettings  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-gsettings  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-x11  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-x11  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-zeroconf  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-module\-zeroconf  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-utils  |  aarch64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pulseaudio\-utils  |  x86\_64  |  pulseaudio  |  15\.0\-5\.amzn2023\.0\.4  | 
|  pv  |  aarch64  |  pv  |  1\.6\.20\-63\.amzn2023\.0\.3  | 
|  pv  |  x86\_64  |  pv  |  1\.6\.20\-63\.amzn2023\.0\.3  | 
|  py3c\-devel  |  aarch64  |  py3c  |  1\.3\-3\.amzn2023\.0\.2  | 
|  py3c\-devel  |  x86\_64  |  py3c  |  1\.3\-3\.amzn2023\.0\.2  | 
|  py3c\-doc  |  noarch  |  py3c  |  1\.3\-3\.amzn2023\.0\.2  | 
|  pybind11\-devel  |  aarch64  |  pybind11  |  2\.9\.2\-1\.amzn2023\.0\.2  | 
|  pybind11\-devel  |  x86\_64  |  pybind11  |  2\.9\.2\-1\.amzn2023\.0\.2  | 
|  python3\-pybind11  |  aarch64  |  pybind11  |  2\.9\.2\-1\.amzn2023\.0\.2  | 
|  python3\-pybind11  |  x86\_64  |  pybind11  |  2\.9\.2\-1\.amzn2023\.0\.2  | 
|  python3\-cairo  |  aarch64  |  pycairo  |  1\.20\.1\-1\.amzn2023\.0\.2  | 
|  python3\-cairo  |  x86\_64  |  pycairo  |  1\.20\.1\-1\.amzn2023\.0\.2  | 
|  python3\-cairo\-devel  |  aarch64  |  pycairo  |  1\.20\.1\-1\.amzn2023\.0\.2  | 
|  python3\-cairo\-devel  |  x86\_64  |  pycairo  |  1\.20\.1\-1\.amzn2023\.0\.2  | 
|  python3\-gobject  |  aarch64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject  |  x86\_64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject\-base  |  aarch64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject\-base  |  x86\_64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject\-base\-noarch  |  noarch  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject\-devel  |  aarch64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  python3\-gobject\-devel  |  x86\_64  |  pygobject3  |  3\.42\.2\-2\.amzn2023\.0\.2  | 
|  pyOpenSSL\-doc  |  noarch  |  pyOpenSSL  |  21\.0\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pyOpenSSL  |  noarch  |  pyOpenSSL  |  21\.0\.0\-1\.amzn2023\.0\.2  | 
|  pyparsing\-doc  |  noarch  |  pyparsing  |  2\.4\.7\-6\.amzn2023\.0\.2  | 
|  python3\-pyparsing  |  noarch  |  pyparsing  |  2\.4\.7\-6\.amzn2023\.0\.2  | 
|  pyproject\-rpm\-macros  |  noarch  |  pyproject\-rpm\-macros  |  1\.3\.2\-1\.amzn2023\.0\.2  | 
|  python3\-pyserial  |  noarch  |  pyserial  |  3\.4\-10\.amzn2023\.0\.2  | 
|  python3\-pytest  |  noarch  |  pytest  |  6\.2\.2\-1\.amzn2023\.0\.3  | 
|  python3\.11  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-debug  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-debug  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-devel  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-devel  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-idle  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-idle  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-libs  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-libs  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-test  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-test  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-tkinter  |  aarch64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-tkinter  |  x86\_64  |  python3\.11  |  3\.11\.2\-2\.amzn2023\.0\.7  | 
|  python3\.11\-pip  |  noarch  |  python3\.11\-pip  |  22\.3\.1\-2\.amzn2023\.0\.2  | 
|  python3\.11\-pip\-wheel  |  noarch  |  python3\.11\-pip  |  22\.3\.1\-2\.amzn2023\.0\.2  | 
|  python3\.11\-setuptools  |  noarch  |  python3\.11\-setuptools  |  65\.5\.1\-2\.amzn2023\.0\.4  | 
|  python3\.11\-setuptools\-wheel  |  noarch  |  python3\.11\-setuptools  |  65\.5\.1\-2\.amzn2023\.0\.4  | 
|  python3\.11\-wheel  |  noarch  |  python3\.11\-wheel  |  0\.38\.4\-3\.amzn2023\.0\.3  | 
|  python3\.11\-wheel\-wheel  |  noarch  |  python3\.11\-wheel  |  0\.38\.4\-3\.amzn2023\.0\.3  | 
|  python3  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-debug  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-debug  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-devel  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-devel  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-idle  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-idle  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-libs  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-libs  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-test  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-test  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-tkinter  |  aarch64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-tkinter  |  x86\_64  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python\-unversioned\-command  |  noarch  |  python3\.9  |  3\.9\.16\-1\.amzn2023\.0\.3  | 
|  python3\-docs  |  noarch  |  python3\-docs  |  3\.9\.8\-1\.amzn2023\.0\.3  | 
|  python3\-mallard\-ducktype  |  noarch  |  python3\-mallard\-ducktype  |  1\.0\.2\-9\.amzn2023\.0\.2  | 
|  python3\-mypy  |  noarch  |  python3\-mypy  |  0\.910\-4\.amzn2023\.0\.2  | 
|  python3\-pytest\-asyncio  |  noarch  |  python3\-pytest\-asyncio  |  0\.14\.0\-2\.amzn2023\.0\.2  | 
|  python3\-typed\_ast  |  aarch64  |  python3\-typed\_ast  |  1\.4\.3\-4\.amzn2023\.0\.2  | 
|  python3\-typed\_ast  |  x86\_64  |  python3\-typed\_ast  |  1\.4\.3\-4\.amzn2023\.0\.2  | 
|  python3\-apipkg  |  noarch  |  python\-apipkg  |  1\.5\-12\.amzn2023\.0\.2  | 
|  python3\-appdirs  |  noarch  |  python\-appdirs  |  1\.4\.4\-2\.amzn2023\.0\.2  | 
|  python3\-argcomplete  |  noarch  |  python\-argcomplete  |  1\.12\.3\-1\.amzn2023\.0\.3  | 
|  python3\-async\-generator  |  noarch  |  python\-async\-generator  |  1\.10\-9\.amzn2023\.0\.2  | 
|  python3\-atomicwrites  |  noarch  |  python\-atomicwrites  |  1\.4\.0\-6\.amzn2023\.0\.2  | 
|  python3\-attrs  |  noarch  |  python\-attrs  |  20\.3\.0\-2\.amzn2023\.0\.2  | 
|  python3\-Automat  |  noarch  |  python\-Automat  |  20\.2\.0\-5\.amzn2023\.0\.3  | 
|  python\-Automat\-doc  |  noarch  |  python\-Automat  |  20\.2\.0\-5\.amzn2023\.0\.3  | 
|  python3\-awscrt  |  aarch64  |  python\-awscrt  |  0\.16\.7\-1\.amzn2023\.0\.1  | 
|  python3\-awscrt  |  x86\_64  |  python\-awscrt  |  0\.16\.7\-1\.amzn2023\.0\.1  | 
|  python3\-bcrypt  |  aarch64  |  python\-bcrypt  |  3\.1\.7\-7\.amzn2023\.0\.2  | 
|  python3\-bcrypt  |  x86\_64  |  python\-bcrypt  |  3\.1\.7\-7\.amzn2023\.0\.2  | 
|  python3\-blinker  |  noarch  |  python\-blinker  |  1\.4\-12\.amzn2023\.0\.2  | 
|  python3\-bottle  |  noarch  |  python\-bottle  |  0\.12\.21\-2\.amzn2023\.0\.1  | 
|  python3\-breathe  |  noarch  |  python\-breathe  |  4\.31\.0\-1\.amzn2023\.0\.3  | 
|  python\-breathe\-doc  |  noarch  |  python\-breathe  |  4\.31\.0\-1\.amzn2023\.0\.3  | 
|  python3\-certifi  |  noarch  |  python\-certifi  |  2022\.12\.07\-1\.amzn2023\.0\.1  | 
|  python3\-cffi  |  aarch64  |  python\-cffi  |  1\.14\.5\-1\.amzn2023\.0\.2  | 
|  python3\-cffi  |  x86\_64  |  python\-cffi  |  1\.14\.5\-1\.amzn2023\.0\.2  | 
|  python\-cffi\-doc  |  noarch  |  python\-cffi  |  1\.14\.5\-1\.amzn2023\.0\.2  | 
|  python3\-cffsubr  |  noarch  |  python\-cffsubr  |  0\.2\.9\-1\.amzn2023\.0\.2  | 
|  python3\-chardet  |  noarch  |  python\-chardet  |  4\.0\.0\-1\.amzn2023\.0\.2  | 
|  python\-chevron  |  aarch64  |  python\-chevron  |  0\.13\.1\-1\.amzn2023\.0\.3  | 
|  python\-chevron  |  x86\_64  |  python\-chevron  |  0\.13\.1\-1\.amzn2023\.0\.3  | 
|  python3\-click  |  noarch  |  python\-click  |  7\.1\.2\-5\.amzn2023\.0\.2  | 
|  python3\-colorama  |  noarch  |  python\-colorama  |  0\.4\.4\-2\.amzn2023\.0\.2  | 
|  python3\-CommonMark  |  noarch  |  python\-CommonMark  |  0\.9\.1\-3\.amzn2023\.0\.2  | 
|  python\-CommonMark\-doc  |  noarch  |  python\-CommonMark  |  0\.9\.1\-3\.amzn2023\.0\.2  | 
|  python3\-configobj  |  noarch  |  python\-configobj  |  5\.0\.6\-23\.amzn2023\.0\.3  | 
|  python3\-configshell  |  noarch  |  python\-configshell  |  1\.1\.29\-10\.amzn2023  | 
|  python3\-constantly  |  noarch  |  python\-constantly  |  15\.1\.0\-12\.amzn2023\.0\.2  | 
|  python3\-cov\-core  |  noarch  |  python\-cov\-core  |  1\.15\.0\-21\.amzn2023\.0\.2  | 
|  python3\-coverage  |  aarch64  |  python\-coverage  |  5\.5\-1\.amzn2023\.0\.3  | 
|  python3\-coverage  |  x86\_64  |  python\-coverage  |  5\.5\-1\.amzn2023\.0\.3  | 
|  python3\-coverage\+toml  |  aarch64  |  python\-coverage  |  5\.5\-1\.amzn2023\.0\.3  | 
|  python3\-coverage\+toml  |  x86\_64  |  python\-coverage  |  5\.5\-1\.amzn2023\.0\.3  | 
|  python3\-cpuinfo  |  noarch  |  python\-cpuinfo  |  7\.0\.0\-3\.amzn2023\.0\.2  | 
|  python3\-crypto  |  aarch64  |  python\-crypto  |  2\.6\.1\-34\.amzn2023\.0\.2  | 
|  python3\-crypto  |  x86\_64  |  python\-crypto  |  2\.6\.1\-34\.amzn2023\.0\.2  | 
|  python3\-cryptography  |  aarch64  |  python\-cryptography  |  36\.0\.1\-1\.amzn2023\.0\.3  | 
|  python3\-cryptography  |  x86\_64  |  python\-cryptography  |  36\.0\.1\-1\.amzn2023\.0\.3  | 
|  python3\-cups  |  aarch64  |  python\-cups  |  2\.0\.1\-10\.amzn2023\.0\.2  | 
|  python3\-cups  |  x86\_64  |  python\-cups  |  2\.0\.1\-10\.amzn2023\.0\.2  | 
|  python\-cups\-doc  |  aarch64  |  python\-cups  |  2\.0\.1\-10\.amzn2023\.0\.2  | 
|  python\-cups\-doc  |  x86\_64  |  python\-cups  |  2\.0\.1\-10\.amzn2023\.0\.2  | 
|  python3\-daemon  |  noarch  |  python\-daemon  |  2\.3\.0\-4\.amzn2023\.0\.2  | 
|  python3\-dateutil  |  noarch  |  python\-dateutil  |  2\.8\.1\-3\.amzn2023\.0\.2  | 
|  python\-dateutil\-doc  |  noarch  |  python\-dateutil  |  2\.8\.1\-3\.amzn2023\.0\.2  | 
|  python3\-decorator  |  noarch  |  python\-decorator  |  4\.4\.2\-4\.amzn2023\.0\.2  | 
|  python3\-distlib  |  noarch  |  python\-distlib  |  0\.3\.1\-4\.amzn2023\.0\.2  | 
|  python3\-distro  |  noarch  |  python\-distro  |  1\.5\.0\-5\.amzn2023\.0\.2  | 
|  python3\-dns  |  noarch  |  python\-dns  |  2\.1\.0\-3\.amzn2023\.0\.3  | 
|  python3\-dns\+dnssec  |  noarch  |  python\-dns  |  2\.1\.0\-3\.amzn2023\.0\.3  | 
|  python3\-dns\+idna  |  noarch  |  python\-dns  |  2\.1\.0\-3\.amzn2023\.0\.3  | 
|  python3\-docopt  |  noarch  |  python\-docopt  |  0\.6\.2\-19\.amzn2023\.0\.3  | 
|  python3\-docs\-theme  |  noarch  |  python\-docs\-theme  |  2020\.12\-1\.amzn2023\.0\.2  | 
|  python3\-docutils  |  noarch  |  python\-docutils  |  0\.16\-4\.amzn2023\.0\.2  | 
|  python3\-dulwich  |  aarch64  |  python\-dulwich  |  0\.20\.18\-1\.amzn2023\.0\.2  | 
|  python3\-dulwich  |  x86\_64  |  python\-dulwich  |  0\.20\.18\-1\.amzn2023\.0\.2  | 
|  python\-dulwich\-doc  |  aarch64  |  python\-dulwich  |  0\.20\.18\-1\.amzn2023\.0\.2  | 
|  python\-dulwich\-doc  |  x86\_64  |  python\-dulwich  |  0\.20\.18\-1\.amzn2023\.0\.2  | 
|  python3\-elementpath  |  noarch  |  python\-elementpath  |  2\.3\.2\-2\.amzn2023  | 
|  python3\-enchant  |  noarch  |  python\-enchant  |  3\.2\.1\-1\.amzn2023\.0\.2  | 
|  python3\-et\_xmlfile  |  noarch  |  python\-et\_xmlfile  |  1\.0\.1\-21\.amzn2023\.0\.2  | 
|  python3\-execnet  |  noarch  |  python\-execnet  |  1\.7\.1\-5\.amzn2023\.0\.2  | 
|  python3\-extras  |  noarch  |  python\-extras  |  1\.0\.0\-15\.amzn2023\.0\.2  | 
|  python3\-factory\-boy  |  noarch  |  python\-factory\-boy  |  3\.2\.0\-2\.amzn2023\.0\.2  | 
|  python\-factory\-boy\-doc  |  noarch  |  python\-factory\-boy  |  3\.2\.0\-2\.amzn2023\.0\.2  | 
|  python3\-faker  |  noarch  |  python\-faker  |  8\.4\.0\-1\.amzn2023\.0\.2  | 
|  python\-faker\-doc  |  noarch  |  python\-faker  |  8\.4\.0\-1\.amzn2023\.0\.2  | 
|  python3\-fields  |  noarch  |  python\-fields  |  5\.0\.0\-8\.amzn2023\.0\.2  | 
|  python\-fields\-doc  |  noarch  |  python\-fields  |  5\.0\.0\-8\.amzn2023\.0\.2  | 
|  python3\-filelock  |  noarch  |  python\-filelock  |  3\.0\.12\-9\.amzn2023\.0\.2  | 
|  python\-filelock\-doc  |  noarch  |  python\-filelock  |  3\.0\.12\-9\.amzn2023\.0\.2  | 
|  python3\-fixtures  |  noarch  |  python\-fixtures  |  3\.0\.0\-22\.amzn2023\.0\.2  | 
|  python3\-flask  |  noarch  |  python\-flask  |  1\.1\.2\-5\.amzn2023\.0\.3  | 
|  python\-flask\-doc  |  noarch  |  python\-flask  |  1\.1\.2\-5\.amzn2023\.0\.3  | 
|  python3\-flit  |  noarch  |  python\-flit  |  3\.7\.1\-4\.amzn2023\.0\.1  | 
|  python3\-flit\-core  |  noarch  |  python\-flit  |  3\.7\.1\-4\.amzn2023\.0\.1  | 
|  python3\-freezegun  |  noarch  |  python\-freezegun  |  1\.0\.0\-4\.amzn2023\.0\.3  | 
|  python3\-fs  |  noarch  |  python\-fs  |  2\.4\.11\-7\.amzn2023\.0\.2  | 
|  python3\-genshi  |  noarch  |  python\-genshi  |  0\.7\.5\-3\.amzn2023\.0\.2  | 
|  python3\-google\-crc32c  |  aarch64  |  python\-google\-crc32c  |  1\.1\.2\-4\.amzn2023  | 
|  python3\-google\-crc32c  |  x86\_64  |  python\-google\-crc32c  |  1\.1\.2\-4\.amzn2023  | 
|  python3\-google\-crc32c\+testing  |  aarch64  |  python\-google\-crc32c  |  1\.1\.2\-4\.amzn2023  | 
|  python3\-google\-crc32c\+testing  |  x86\_64  |  python\-google\-crc32c  |  1\.1\.2\-4\.amzn2023  | 
|  python3\-greenlet  |  aarch64  |  python\-greenlet  |  0\.4\.17\-2\.amzn2023\.0\.2  | 
|  python3\-greenlet  |  x86\_64  |  python\-greenlet  |  0\.4\.17\-2\.amzn2023\.0\.2  | 
|  python3\-greenlet\-devel  |  aarch64  |  python\-greenlet  |  0\.4\.17\-2\.amzn2023\.0\.2  | 
|  python3\-greenlet\-devel  |  x86\_64  |  python\-greenlet  |  0\.4\.17\-2\.amzn2023\.0\.2  | 
|  python3\-gssapi  |  aarch64  |  python\-gssapi  |  1\.6\.9\-3\.amzn2023\.0\.2  | 
|  python3\-gssapi  |  x86\_64  |  python\-gssapi  |  1\.6\.9\-3\.amzn2023\.0\.2  | 
|  python3\-h2  |  noarch  |  python\-h2  |  4\.0\.0\-2\.amzn2023\.0\.3  | 
|  python3\-hamcrest  |  noarch  |  python\-hamcrest  |  1\.9\.0\-16\.amzn2023\.0\.2  | 
|  python3\-hpack  |  noarch  |  python\-hpack  |  4\.0\.0\-2\.amzn2023\.0\.2  | 
|  python3\-html5lib  |  noarch  |  python\-html5lib  |  1\.1\-4\.amzn2023\.0\.2  | 
|  python3\-httpbin  |  noarch  |  python\-httpbin  |  0\.7\.0\-13\.amzn2023\.0\.2  | 
|  python3\-httpretty  |  noarch  |  python\-httpretty  |  1\.1\.4\-7\.amzn2023\.0\.3  | 
|  python3\-hyperframe  |  noarch  |  python\-hyperframe  |  6\.0\.1\-1\.amzn2023\.0\.2  | 
|  python3\-hyperlink  |  noarch  |  python\-hyperlink  |  21\.0\.0\-2\.amzn2023\.0\.2  | 
|  python\-hyperlink\-doc  |  noarch  |  python\-hyperlink  |  21\.0\.0\-2\.amzn2023\.0\.2  | 
|  python3\-hypothesis  |  noarch  |  python\-hypothesis  |  5\.43\.9\-1\.amzn2023\.0\.3  | 
|  python3\-idna  |  noarch  |  python\-idna  |  2\.10\-3\.amzn2023\.0\.2  | 
|  python3\-imagesize  |  noarch  |  python\-imagesize  |  1\.2\.0\-4\.amzn2023\.0\.2  | 
|  python3\-impacket  |  noarch  |  python\-impacket  |  0\.9\.22\-3\.amzn2023\.0\.2  | 
|  python3\-incremental  |  noarch  |  python\-incremental  |  21\.3\.0\-1\.amzn2023\.0\.2  | 
|  python3\-iniconfig  |  noarch  |  python\-iniconfig  |  1\.1\.1\-2\.amzn2023\.0\.2  | 
|  python3\-iniparse  |  noarch  |  python\-iniparse  |  0\.4\-43\.amzn2023\.0\.2  | 
|  python3\-iso8601  |  noarch  |  python\-iso8601  |  0\.1\.13\-2\.amzn2023\.0\.2  | 
|  python3\-isodate  |  noarch  |  python\-isodate  |  0\.6\.0\-8\.amzn2023\.0\.2  | 
|  python3\-itsdangerous  |  noarch  |  python\-itsdangerous  |  1\.1\.0\-4\.amzn2023\.0\.2  | 
|  python3\-jaraco\-envs  |  noarch  |  python\-jaraco\-envs  |  2\.0\.0\-4\.amzn2023\.0\.2  | 
|  python\-jaraco\-envs\-doc  |  noarch  |  python\-jaraco\-envs  |  2\.0\.0\-4\.amzn2023\.0\.2  | 
|  python3\-jaraco  |  noarch  |  python\-jaraco\-packaging  |  8\.2\.0\-2\.amzn2023\.0\.3  | 
|  python3\-jaraco\-packaging  |  noarch  |  python\-jaraco\-packaging  |  8\.2\.0\-2\.amzn2023\.0\.3  | 
|  python3\-jdcal  |  noarch  |  python\-jdcal  |  1\.4\-10\.amzn2023\.0\.2  | 
|  python3\-jedi  |  noarch  |  python\-jedi  |  0\.17\.2^20200805git209e271\-2\.amzn2023\.0\.2  | 
|  python3\-jinja2  |  noarch  |  python\-jinja2  |  2\.11\.3\-1\.amzn2023\.0\.2  | 
|  python3\-jmespath  |  noarch  |  python\-jmespath  |  0\.10\.0\-1\.amzn2023\.0\.3  | 
|  python3\-jsonpatch  |  noarch  |  python\-jsonpatch  |  1\.21\-14\.amzn2023\.0\.2  | 
|  python3\-jsonpointer  |  noarch  |  python\-jsonpointer  |  2\.0\-2\.amzn2023\.0\.2  | 
|  python3\-jsonschema  |  noarch  |  python\-jsonschema  |  3\.2\.0\-9\.amzn2023\.0\.3  | 
|  python3\-jwt  |  noarch  |  python\-jwt  |  2\.4\.0\-1\.amzn2023\.0\.1  | 
|  python3\-jwt\+crypto  |  noarch  |  python\-jwt  |  2\.4\.0\-1\.amzn2023\.0\.1  | 
|  python3\-kmod  |  aarch64  |  python\-kmod  |  0\.9\-30\.amzn2023\.0\.2  | 
|  python3\-kmod  |  x86\_64  |  python\-kmod  |  0\.9\-30\.amzn2023\.0\.2  | 
|  python3\-ldap3  |  noarch  |  python\-ldap3  |  2\.8\.1\-2\.amzn2023\.0\.2  | 
|  python3\-libevdev  |  noarch  |  python\-libevdev  |  0\.10\-1\.amzn2023\.0\.2  | 
|  python3\-linux\-procfs  |  noarch  |  python\-linux\-procfs  |  0\.7\.1\-1\.amzn2023\.0\.1  | 
|  python3\-lit  |  noarch  |  python\-lit  |  15\.0\.6\-1\.amzn2023\.0\.1  | 
|  python3\-lockfile  |  noarch  |  python\-lockfile  |  0\.12\.2\-5\.amzn2023\.0\.3  | 
|  python\-lockfile\-doc  |  noarch  |  python\-lockfile  |  0\.12\.2\-5\.amzn2023\.0\.3  | 
|  python3\-lxml  |  aarch64  |  python\-lxml  |  4\.7\.1\-3\.amzn2023\.0\.1  | 
|  python3\-lxml  |  x86\_64  |  python\-lxml  |  4\.7\.1\-3\.amzn2023\.0\.1  | 
|  python3\-m2r  |  noarch  |  python\-m2r  |  0\.2\.1\-3\.20190604git66f4a5a\.amzn2023\.0\.2  | 
|  python3\-mako  |  noarch  |  python\-mako  |  1\.1\.4\-3\.amzn2023\.0\.2  | 
|  python\-mako\-doc  |  noarch  |  python\-mako  |  1\.1\.4\-3\.amzn2023\.0\.2  | 
|  python3\-markdown  |  noarch  |  python\-markdown  |  3\.3\.4\-2\.amzn2023\.0\.2  | 
|  python3\-markupsafe  |  aarch64  |  python\-markupsafe  |  1\.1\.1\-10\.amzn2023\.0\.2  | 
|  python3\-markupsafe  |  x86\_64  |  python\-markupsafe  |  1\.1\.1\-10\.amzn2023\.0\.2  | 
|  python3\-mimeparse  |  noarch  |  python\-mimeparse  |  1\.6\.0\-16\.amzn2023\.0\.2  | 
|  python3\-mistune  |  aarch64  |  python\-mistune  |  0\.8\.3\-14\.amzn2023\.0\.3  | 
|  python3\-mistune  |  x86\_64  |  python\-mistune  |  0\.8\.3\-14\.amzn2023\.0\.3  | 
|  python3\-mock  |  noarch  |  python\-mock  |  3\.0\.5\-14\.amzn2023\.0\.2  | 
|  python3\-more\-itertools  |  noarch  |  python\-more\-itertools  |  8\.5\.0\-2\.amzn2023\.0\.2  | 
|  python3\-munkres  |  noarch  |  python\-munkres  |  1\.1\.2\-8\.amzn2023\.0\.2  | 
|  python3\-mypy\_extensions  |  noarch  |  python\-mypy\_extensions  |  0\.4\.3\-5\.amzn2023\.0\.2  | 
|  python3\-netaddr  |  noarch  |  python\-netaddr  |  0\.8\.0\-3\.amzn2023\.0\.2  | 
|  python3\-netifaces  |  aarch64  |  python\-netifaces  |  0\.10\.6\-13\.amzn2023\.0\.2  | 
|  python3\-netifaces  |  x86\_64  |  python\-netifaces  |  0\.10\.6\-13\.amzn2023\.0\.2  | 
|  python3\-nose2  |  noarch  |  python\-nose2  |  0\.9\.1\-5\.amzn2023\.0\.2  | 
|  python3\-oauthlib  |  noarch  |  python\-oauthlib  |  3\.0\.2\-9\.amzn2023\.0\.3  | 
|  python3\-oauthlib\+signedtoken  |  noarch  |  python\-oauthlib  |  3\.0\.2\-9\.amzn2023\.0\.3  | 
|  python3\-olefile  |  noarch  |  python\-olefile  |  0\.46\-13\.amzn2023\.0\.2  | 
|  python\-olefile\-doc  |  noarch  |  python\-olefile  |  0\.46\-13\.amzn2023\.0\.2  | 
|  python3\-openpyxl  |  noarch  |  python\-openpyxl  |  3\.0\.3\-3\.amzn2023\.0\.2  | 
|  python3\-openstackdocstheme  |  noarch  |  python\-openstackdocstheme  |  2\.2\.6\-3\.amzn2023\.0\.2  | 
|  python\-openstackdocstheme\-doc  |  noarch  |  python\-openstackdocstheme  |  2\.2\.6\-3\.amzn2023\.0\.2  | 
|  python3\-packaging  |  noarch  |  python\-packaging  |  21\.3\-2\.amzn2023\.0\.2  | 
|  python\-packaging\-doc  |  noarch  |  python\-packaging  |  21\.3\-2\.amzn2023\.0\.2  | 
|  python3\-Pallets\-Sphinx\-Themes  |  noarch  |  python\-Pallets\-Sphinx\-Themes  |  1\.2\.2\-7\.amzn2023\.0\.2  | 
|  python3\-parso  |  noarch  |  python\-parso  |  0\.8\.0\-3\.amzn2023\.0\.2  | 
|  python3\-path  |  noarch  |  python\-path  |  11\.5\.0\-6\.amzn2023\.0\.2  | 
|  python3\-pathspec  |  noarch  |  python\-pathspec  |  0\.6\.0\-5\.amzn2023\.0\.2  | 
|  python3\-pbr  |  noarch  |  python\-pbr  |  5\.5\.1\-2\.amzn2023\.0\.2  | 
|  python3\-pefile  |  noarch  |  python\-pefile  |  2023\.2\.7\-1\.amzn2023  | 
|  python3\-pexpect  |  noarch  |  python\-pexpect  |  4\.8\.0\-7\.amzn2023\.0\.2  | 
|  python3\-pillow  |  aarch64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pillow  |  x86\_64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pillow\-devel  |  aarch64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pillow\-devel  |  x86\_64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pillow\-tk  |  aarch64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pillow\-tk  |  x86\_64  |  python\-pillow  |  9\.4\.0\-2\.amzn2023\.0\.1  | 
|  python3\-pip  |  noarch  |  python\-pip  |  21\.3\.1\-2\.amzn2023\.0\.5  | 
|  python3\-pip\-wheel  |  noarch  |  python\-pip  |  21\.3\.1\-2\.amzn2023\.0\.5  | 
|  python3\-pluggy  |  noarch  |  python\-pluggy  |  0\.13\.1\-3\.amzn2023\.0\.2  | 
|  python3\-ply  |  noarch  |  python\-ply  |  3\.11\-11\.amzn2023\.0\.2  | 
|  python3\-pretend  |  noarch  |  python\-pretend  |  1\.0\.8\-23\.amzn2023\.0\.2  | 
|  python3\-prettytable  |  noarch  |  python\-prettytable  |  0\.7\.2\-25\.amzn2023\.0\.2  | 
|  python3\-priority  |  noarch  |  python\-priority  |  1\.3\.0\-12\.amzn2023\.0\.2  | 
|  python3\-process\-tests  |  noarch  |  python\-process\-tests  |  2\.0\.2\-9\.amzn2023\.0\.2  | 
|  python3\-progressbar2  |  noarch  |  python\-progressbar2  |  3\.52\.1\-23\.amzn2023\.0\.2  | 
|  python3\-prompt\-toolkit  |  noarch  |  python\-prompt\-toolkit  |  3\.0\.24\-1\.amzn2023\.0\.2  | 
|  python3\-psutil  |  aarch64  |  python\-psutil  |  5\.8\.0\-16\.amzn2023\.0\.2  | 
|  python3\-psutil  |  x86\_64  |  python\-psutil  |  5\.8\.0\-16\.amzn2023\.0\.2  | 
|  python3\-psutil\-tests  |  aarch64  |  python\-psutil  |  5\.8\.0\-16\.amzn2023\.0\.2  | 
|  python3\-psutil\-tests  |  x86\_64  |  python\-psutil  |  5\.8\.0\-16\.amzn2023\.0\.2  | 
|  python3\-psycopg2  |  aarch64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-psycopg2  |  x86\_64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-psycopg2\-debug  |  aarch64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-psycopg2\-debug  |  x86\_64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-psycopg2\-tests  |  aarch64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-psycopg2\-tests  |  x86\_64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python\-psycopg2\-doc  |  aarch64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python\-psycopg2\-doc  |  x86\_64  |  python\-psycopg2  |  2\.8\.6\-3\.amzn2023\.0\.3  | 
|  python3\-ptyprocess  |  noarch  |  python\-ptyprocess  |  0\.6\.0\-12\.amzn2023\.0\.2  | 
|  python3\-py  |  noarch  |  python\-py  |  1\.10\.0\-2\.amzn2023\.0\.2  | 
|  python3\-pyasn1  |  noarch  |  python\-pyasn1  |  0\.4\.8\-4\.amzn2023\.0\.2  | 
|  python3\-pyasn1\-modules  |  noarch  |  python\-pyasn1  |  0\.4\.8\-4\.amzn2023\.0\.2  | 
|  python\-pyasn1\-doc  |  noarch  |  python\-pyasn1  |  0\.4\.8\-4\.amzn2023\.0\.2  | 
|  python3\-pycotap  |  noarch  |  python\-pycotap  |  1\.1\.0\-8\.amzn2023\.0\.2  | 
|  python3\-pycparser  |  noarch  |  python\-pycparser  |  2\.20\-3\.amzn2023\.0\.2  | 
|  python3\-pycryptodomex  |  aarch64  |  python\-pycryptodomex  |  3\.11\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pycryptodomex  |  x86\_64  |  python\-pycryptodomex  |  3\.11\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pycryptodomex\-selftest  |  aarch64  |  python\-pycryptodomex  |  3\.11\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pycryptodomex\-selftest  |  x86\_64  |  python\-pycryptodomex  |  3\.11\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pycurl  |  aarch64  |  python\-pycurl  |  7\.45\.1\-1\.amzn2023\.0\.3  | 
|  python3\-pycurl  |  x86\_64  |  python\-pycurl  |  7\.45\.1\-1\.amzn2023\.0\.3  | 
|  python3\-pygments  |  noarch  |  python\-pygments  |  2\.7\.4\-1\.amzn2023\.0\.2  | 
|  python3\-pygments\-pytest  |  noarch  |  python\-pygments\-pytest  |  2\.1\.0\-2\.amzn2023\.0\.2  | 
|  python3\-bson  |  aarch64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-bson  |  x86\_64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-pymongo  |  aarch64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-pymongo  |  x86\_64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-pymongo\-gridfs  |  aarch64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-pymongo\-gridfs  |  x86\_64  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python\-pymongo\-doc  |  noarch  |  python\-pymongo  |  3\.10\.1\-5\.amzn2023\.0\.2  | 
|  python3\-pyrad  |  noarch  |  python\-pyrad  |  2\.1\-9\.amzn2023\.0\.2  | 
|  python3\-pyrsistent  |  aarch64  |  python\-pyrsistent  |  0\.17\.3\-6\.amzn2023\.0\.2  | 
|  python3\-pyrsistent  |  x86\_64  |  python\-pyrsistent  |  0\.17\.3\-6\.amzn2023\.0\.2  | 
|  python\-pyrsistent\-doc  |  noarch  |  python\-pyrsistent  |  0\.17\.3\-6\.amzn2023\.0\.2  | 
|  python3\-pysocks  |  noarch  |  python\-pysocks  |  1\.7\.1\-8\.amzn2023\.0\.2  | 
|  python3\-pytest4  |  noarch  |  python\-pytest4  |  4\.6\.11\-3\.amzn2023\.0\.3  | 
|  python3\-pytest\-benchmark  |  noarch  |  python\-pytest\-benchmark  |  3\.2\.3\-5\.amzn2023\.0\.2  | 
|  python3\-pytest\-cov  |  noarch  |  python\-pytest\-cov  |  3\.0\.0\-67\.amzn2023\.0\.2  | 
|  python3\-pytest\-expect  |  noarch  |  python\-pytest\-expect  |  1\.1\.0\-9\.amzn2023\.0\.2  | 
|  python3\-pytest\-fixture\-config  |  noarch  |  python\-pytest\-fixture\-config  |  1\.7\.0\-10\.amzn2023\.0\.2  | 
|  python3\-pytest\-forked  |  noarch  |  python\-pytest\-forked  |  1\.3\.0\-2\.amzn2023\.0\.2  | 
|  python3\-pytest\-httpbin  |  noarch  |  python\-pytest\-httpbin  |  1\.0\.0\-3\.amzn2023\.0\.2  | 
|  python3\-pytest\-mock  |  noarch  |  python\-pytest\-mock  |  3\.5\.1\-2\.amzn2023\.0\.2  | 
|  python3\-pytest\-randomly  |  noarch  |  python\-pytest\-randomly  |  3\.5\.0\-2\.amzn2023\.0\.2  | 
|  python3\-pytest\-runner  |  noarch  |  python\-pytest\-runner  |  4\.0\-12\.amzn2023\.0\.2  | 
|  python3\-pytest\-shutil  |  noarch  |  python\-pytest\-shutil  |  1\.7\.0\-11\.amzn2023\.0\.2  | 
|  python3\-pytest\-subtests  |  noarch  |  python\-pytest\-subtests  |  0\.4\.0\-1\.amzn2023\.0\.2  | 
|  python3\-pytest\-timeout  |  noarch  |  python\-pytest\-timeout  |  1\.4\.2\-3\.amzn2023\.0\.2  | 
|  python3\-pytest\-xdist  |  noarch  |  python\-pytest\-xdist  |  2\.2\.0\-2\.amzn2023\.0\.2  | 
|  python3\-pyudev  |  noarch  |  python\-pyudev  |  0\.22\.0\-4\.amzn2023\.0\.3  | 
|  python3\-raven  |  noarch  |  python\-raven  |  6\.10\.0\-10\.amzn2023\.0\.2  | 
|  python3\-raven\+flask  |  noarch  |  python\-raven  |  6\.10\.0\-10\.amzn2023\.0\.2  | 
|  python3\-readthedocs\-sphinx\-ext  |  noarch  |  python\-readthedocs\-sphinx\-ext  |  2\.1\.4\-1\.amzn2023\.0\.2  | 
|  python3\-recommonmark  |  noarch  |  python\-recommonmark  |  0\.6\.0\-3\.git\.amzn2023\.0\.2  | 
|  python3\-requests  |  noarch  |  python\-requests  |  2\.25\.1\-1\.amzn2023\.0\.3  | 
|  python3\-requests\+security  |  noarch  |  python\-requests  |  2\.25\.1\-1\.amzn2023\.0\.3  | 
|  python3\-requests\+socks  |  noarch  |  python\-requests  |  2\.25\.1\-1\.amzn2023\.0\.3  | 
|  python3\-requests\-download  |  noarch  |  python\-requests\-download  |  0\.1\.2\-5\.amzn2023\.0\.2  | 
|  python3\-requests\-unixsocket  |  noarch  |  python\-requests\-unixsocket  |  0\.1\.5\-9\.amzn2023\.0\.2  | 
|  python3\-responses  |  noarch  |  python\-responses  |  0\.10\.15\-3\.amzn2023\.0\.2  | 
|  python3\-rpm\-generators  |  noarch  |  python\-rpm\-generators  |  12\-15\.amzn2023\.0\.4  | 
|  python3\-rpm\-macros  |  noarch  |  python\-rpm\-macros  |  3\.9\-41\.amzn2023\.0\.5  | 
|  python\-rpm\-macros  |  noarch  |  python\-rpm\-macros  |  3\.9\-41\.amzn2023\.0\.5  | 
|  python\-srpm\-macros  |  noarch  |  python\-rpm\-macros  |  3\.9\-41\.amzn2023\.0\.5  | 
|  python3\-rsa  |  noarch  |  python\-rsa  |  4\.7\.2\-1\.amzn2023\.0\.2  | 
|  python3\-rst\-linker  |  noarch  |  python\-rst\-linker  |  2\.1\.1\-2\.amzn2023\.0\.2  | 
|  python3\-rtslib  |  noarch  |  python\-rtslib  |  2\.1\.74\-2\.amzn2023\.0\.2  | 
|  target\-restore  |  noarch  |  python\-rtslib  |  2\.1\.74\-2\.amzn2023\.0\.2  | 
|  python3\-ruamel\-yaml  |  aarch64  |  python\-ruamel\-yaml  |  0\.16\.6\-5\.amzn2023\.0\.2  | 
|  python3\-ruamel\-yaml  |  x86\_64  |  python\-ruamel\-yaml  |  0\.16\.6\-5\.amzn2023\.0\.2  | 
|  python3\-ruamel\-yaml\-clib  |  aarch64  |  python\-ruamel\-yaml\-clib  |  0\.1\.2\-6\.amzn2023\.0\.2  | 
|  python3\-ruamel\-yaml\-clib  |  x86\_64  |  python\-ruamel\-yaml\-clib  |  0\.1\.2\-6\.amzn2023\.0\.2  | 
|  python3\-semantic\_version  |  noarch  |  python\-semantic\_version  |  2\.8\.4\-6\.amzn2023\.0\.2  | 
|  python\-semantic\_version\-doc  |  noarch  |  python\-semantic\_version  |  2\.8\.4\-6\.amzn2023\.0\.2  | 
|  python3\-service\-identity  |  noarch  |  python\-service\-identity  |  21\.1\.0\-1\.amzn2023\.0\.2  | 
|  python\-service\-identity\-doc  |  noarch  |  python\-service\-identity  |  21\.1\.0\-1\.amzn2023\.0\.2  | 
|  python3\-setproctitle  |  aarch64  |  python\-setproctitle  |  1\.1\.10\-20\.amzn2023\.0\.3  | 
|  python3\-setproctitle  |  x86\_64  |  python\-setproctitle  |  1\.1\.10\-20\.amzn2023\.0\.3  | 
|  python3\-setuptools  |  noarch  |  python\-setuptools  |  59\.6\.0\-2\.amzn2023\.0\.4  | 
|  python3\-setuptools\-wheel  |  noarch  |  python\-setuptools  |  59\.6\.0\-2\.amzn2023\.0\.4  | 
|  python3\-setuptools\_scm  |  noarch  |  python\-setuptools\_scm  |  6\.0\.1\-4\.amzn2023\.0\.2  | 
|  python3\-setuptools\_scm\+toml  |  noarch  |  python\-setuptools\_scm  |  6\.0\.1\-4\.amzn2023\.0\.2  | 
|  python3\-setuptools\-rust  |  noarch  |  python\-setuptools\-rust  |  0\.12\.1\-1\.amzn2023\.0\.3  | 
|  python3\-simplejson  |  aarch64  |  python\-simplejson  |  3\.17\.6\-111\.amzn2023\.0\.2  | 
|  python3\-simplejson  |  x86\_64  |  python\-simplejson  |  3\.17\.6\-111\.amzn2023\.0\.2  | 
|  python3\-six  |  noarch  |  python\-six  |  1\.15\.0\-5\.amzn2023\.0\.2  | 
|  python3\-slip  |  noarch  |  python\-slip  |  0\.6\.4\-22\.amzn2023\.0\.2  | 
|  python3\-slip\-dbus  |  noarch  |  python\-slip  |  0\.6\.4\-22\.amzn2023\.0\.2  | 
|  python3\-snowballstemmer  |  noarch  |  python\-snowballstemmer  |  1\.9\.0\-8\.amzn2023\.0\.2  | 
|  python3\-sortedcontainers  |  noarch  |  python\-sortedcontainers  |  2\.4\.0\-1\.amzn2023\.0\.3  | 
|  python\-sortedcontainers\-doc  |  noarch  |  python\-sortedcontainers  |  2\.4\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sphinx  |  noarch  |  python\-sphinx  |  3\.4\.3\-2\.amzn2023\.0\.3  | 
|  python3\-sphinx\-latex  |  noarch  |  python\-sphinx  |  3\.4\.3\-2\.amzn2023\.0\.3  | 
|  python\-sphinx\-doc  |  noarch  |  python\-sphinx  |  3\.4\.3\-2\.amzn2023\.0\.3  | 
|  python3\-sphinx\_rtd\_theme  |  noarch  |  python\-sphinx\_rtd\_theme  |  0\.5\.1\-2\.amzn2023\.0\.2  | 
|  python\-sphinx\_rtd\_theme\-doc  |  noarch  |  python\-sphinx\_rtd\_theme  |  0\.5\.1\-2\.amzn2023\.0\.2  | 
|  python3\-sphinx\_selective\_exclude  |  noarch  |  python\-sphinx\_selective\_exclude  |  1\.0\.3\-2\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-apidoc  |  noarch  |  python\-sphinxcontrib\-apidoc  |  0\.3\.0\-2\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-applehelp  |  noarch  |  python\-sphinxcontrib\-applehelp  |  1\.0\.2\-3\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-devhelp  |  noarch  |  python\-sphinxcontrib\-devhelp  |  1\.0\.2\-3\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-htmlhelp  |  noarch  |  python\-sphinxcontrib\-htmlhelp  |  1\.0\.3\-3\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-httpdomain  |  noarch  |  python\-sphinxcontrib\-httpdomain  |  1\.7\.0\-11\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-jsmath  |  noarch  |  python\-sphinxcontrib\-jsmath  |  1\.0\.1\-10\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-log\-cabinet  |  noarch  |  python\-sphinxcontrib\-log\-cabinet  |  1\.0\.1\-6\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-qthelp  |  noarch  |  python\-sphinxcontrib\-qthelp  |  1\.0\.3\-3\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-serializinghtml  |  noarch  |  python\-sphinxcontrib\-serializinghtml  |  1\.1\.4\-3\.amzn2023\.0\.2  | 
|  python3\-sphinxcontrib\-trio  |  noarch  |  python\-sphinxcontrib\-trio  |  1\.1\.2\-4\.amzn2023\.0\.2  | 
|  python3\-sphinx\-epytext  |  noarch  |  python\-sphinx\-epytext  |  0\.0\.4\-5\.amzn2023\.0\.2  | 
|  python3\-sphinx\-hoverxref  |  noarch  |  python\-sphinx\-hoverxref  |  0\.5b1\-3\.amzn2023\.0\.2  | 
|  python3\-sphinx\-inline\-tabs  |  noarch  |  python\-sphinx\-inline\-tabs  |  2020\.10\.19\.b4\-2\.amzn2023\.0\.3  | 
|  python3\-sphinx\-issues  |  noarch  |  python\-sphinx\-issues  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  python3\-sphinx\-removed\-in  |  noarch  |  python\-sphinx\-removed\-in  |  0\.2\.1\-5\.amzn2023\.0\.2  | 
|  python3\-sphinx\-testing  |  noarch  |  python\-sphinx\-testing  |  1\.0\.1\-10\.amzn2023\.0\.2  | 
|  python3\-sphinx\-theme\-alabaster  |  noarch  |  python\-sphinx\-theme\-alabaster  |  0\.7\.12\-11\.amzn2023\.0\.2  | 
|  python3\-sphinx\-theme\-py3doc\-enhanced  |  noarch  |  python\-sphinx\-theme\-py3doc\-enhanced  |  2\.3\.2\-19\.amzn2023\.0\.2  | 
|  python3\-sqlalchemy  |  aarch64  |  python\-sqlalchemy  |  1\.3\.24\-1\.amzn2023\.0\.2  | 
|  python3\-sqlalchemy  |  x86\_64  |  python\-sqlalchemy  |  1\.3\.24\-1\.amzn2023\.0\.2  | 
|  python\-sqlalchemy\-doc  |  noarch  |  python\-sqlalchemy  |  1\.3\.24\-1\.amzn2023\.0\.2  | 
|  python3\-termcolor  |  noarch  |  python\-termcolor  |  1\.1\.0\-24\.amzn2023\.0\.2  | 
|  python3\-testpath  |  noarch  |  python\-testpath  |  0\.4\.4\-4\.amzn2023\.0\.2  | 
|  python\-testpath\-doc  |  noarch  |  python\-testpath  |  0\.4\.4\-4\.amzn2023\.0\.2  | 
|  python3\-testscenarios  |  noarch  |  python\-testscenarios  |  0\.5\.0\-21\.amzn2023\.0\.2  | 
|  python3\-testtools  |  noarch  |  python\-testtools  |  2\.4\.0\-8\.amzn2023\.0\.2  | 
|  python\-testtools\-doc  |  noarch  |  python\-testtools  |  2\.4\.0\-8\.amzn2023\.0\.2  | 
|  python3\-text\-unidecode  |  noarch  |  python\-text\-unidecode  |  1\.3\-5\.amzn2023\.0\.2  | 
|  python3\-toml  |  noarch  |  python\-toml  |  0\.10\.2\-2\.amzn2023\.0\.2  | 
|  python3\-tomli  |  noarch  |  python\-tomli  |  2\.0\.1\-4\.amzn2023  | 
|  python3\-tomli\-w  |  noarch  |  python\-tomli\-w  |  1\.0\.0\-4\.amzn2023  | 
|  python3\-tornado  |  aarch64  |  python\-tornado  |  6\.1\.0\-2\.amzn2023\.0\.3  | 
|  python3\-tornado  |  x86\_64  |  python\-tornado  |  6\.1\.0\-2\.amzn2023\.0\.3  | 
|  python\-tornado\-doc  |  aarch64  |  python\-tornado  |  6\.1\.0\-2\.amzn2023\.0\.3  | 
|  python\-tornado\-doc  |  x86\_64  |  python\-tornado  |  6\.1\.0\-2\.amzn2023\.0\.3  | 
|  tox  |  noarch  |  python\-tox  |  3\.24\.4\-1\.amzn2023\.0\.2  | 
|  python3\-tox\-current\-env  |  noarch  |  python\-tox\-current\-env  |  0\.0\.6\-1\.amzn2023\.0\.2  | 
|  python3\-tqdm  |  noarch  |  python\-tqdm  |  4\.61\.1\-1\.amzn2023\.0\.2  | 
|  python3\-trustme  |  noarch  |  python\-trustme  |  0\.6\.0\-6\.amzn2023\.0\.2  | 
|  python\-trustme\-doc  |  noarch  |  python\-trustme  |  0\.6\.0\-6\.amzn2023\.0\.2  | 
|  python3\-twisted  |  noarch  |  python\-twisted  |  22\.4\.0\-125\.amzn2023\.0\.2  | 
|  python3\-twisted\+tls  |  noarch  |  python\-twisted  |  22\.4\.0\-125\.amzn2023\.0\.2  | 
|  python3\-typing\-extensions  |  noarch  |  python\-typing\-extensions  |  3\.7\.4\.3\-2\.amzn2023\.0\.2  | 
|  python3\-uefivars  |  noarch  |  python\-uefivars  |  1\.0\.0\-1\.amzn2023\.0\.1  | 
|  python3\-u\-msgpack\-python  |  noarch  |  python\-u\-msgpack\-python  |  2\.7\.0\-2\.amzn2023\.0\.2  | 
|  python3\-urlgrabber  |  noarch  |  python\-urlgrabber  |  4\.1\.0\-6\.amzn2023\.0\.2  | 
|  python3\-urllib3  |  noarch  |  python\-urllib3  |  1\.25\.10\-5\.amzn2023\.0\.2  | 
|  python3\-urwid  |  aarch64  |  python\-urwid  |  2\.1\.2\-5\.amzn2023  | 
|  python3\-urwid  |  x86\_64  |  python\-urwid  |  2\.1\.2\-5\.amzn2023  | 
|  python3\-utils  |  noarch  |  python\-utils  |  2\.4\.0\-3\.amzn2023\.0\.2  | 
|  python3\-virt\-firmware  |  noarch  |  python\-virt\-firmware  |  0\.96\-1\.amzn2023\.0\.2  | 
|  python3\-virtualenv  |  noarch  |  python\-virtualenv  |  20\.4\.0\-3\.amzn2023\.0\.3  | 
|  python3\-waitress  |  noarch  |  python\-waitress  |  2\.1\.2\-1\.amzn2023\.0\.2  | 
|  python3\-wcwidth  |  noarch  |  python\-wcwidth  |  0\.2\.5\-3\.amzn2023\.0\.2  | 
|  python3\-webencodings  |  noarch  |  python\-webencodings  |  0\.5\.1\-14\.amzn2023\.0\.2  | 
|  python\-webencodings\-doc  |  noarch  |  python\-webencodings  |  0\.5\.1\-14\.amzn2023\.0\.2  | 
|  python3\-werkzeug  |  noarch  |  python\-werkzeug  |  1\.0\.1\-5\.amzn2023\.0\.4  | 
|  python3\-werkzeug\-doc  |  noarch  |  python\-werkzeug  |  1\.0\.1\-5\.amzn2023\.0\.4  | 
|  python3\-wheel  |  noarch  |  python\-wheel  |  0\.37\.1\-1\.amzn2023\.0\.3  | 
|  python3\-wheel\-wheel  |  noarch  |  python\-wheel  |  0\.37\.1\-1\.amzn2023\.0\.3  | 
|  python3\-xmlschema  |  noarch  |  python\-xmlschema  |  1\.4\.2\-1\.amzn2023\.0\.2  | 
|  python3\-zope\-event  |  noarch  |  python\-zope\-event  |  4\.2\.0\-20\.amzn2023\.0\.2  | 
|  python3\-zope\-interface  |  aarch64  |  python\-zope\-interface  |  5\.2\.0\-2\.amzn2023\.0\.2  | 
|  python3\-zope\-interface  |  x86\_64  |  python\-zope\-interface  |  5\.2\.0\-2\.amzn2023\.0\.2  | 
|  python3\-zope\-testing  |  noarch  |  python\-zope\-testing  |  4\.7\-4\.amzn2023\.0\.2  | 
|  python3\-pytz  |  noarch  |  pytz  |  2022\.7\.1\-1\.amzn2023  | 
|  python3\-pywbem  |  noarch  |  pywbem  |  0\.15\.0\-5\.amzn2023\.0\.2  | 
|  python3\-pyxattr  |  aarch64  |  pyxattr  |  0\.7\.2\-2\.amzn2023\.0\.2  | 
|  python3\-pyxattr  |  x86\_64  |  pyxattr  |  0\.7\.2\-2\.amzn2023\.0\.2  | 
|  python3\-pyxdg  |  noarch  |  pyxdg  |  0\.27\-1\.amzn2023\.0\.2  | 
|  python3\-pyyaml  |  aarch64  |  PyYAML  |  5\.4\.1\-2\.amzn2023\.0\.2  | 
|  python3\-pyyaml  |  x86\_64  |  PyYAML  |  5\.4\.1\-2\.amzn2023\.0\.2  | 
|  qdox  |  noarch  |  qdox  |  2\.0\.0\-9\.amzn2023\.0\.3  | 
|  qdox\-javadoc  |  noarch  |  qdox  |  2\.0\.0\-9\.amzn2023\.0\.3  | 
|  libqhull  |  aarch64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  libqhull  |  x86\_64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  libqhull\_p  |  aarch64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  libqhull\_p  |  x86\_64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  libqhull\_r  |  aarch64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  libqhull\_r  |  x86\_64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  qhull  |  aarch64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  qhull  |  x86\_64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  qhull\-devel  |  aarch64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  qhull\-devel  |  x86\_64  |  qhull  |  7\.2\.1\-7\.amzn2023\.0\.2  | 
|  qpdf  |  aarch64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf  |  x86\_64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf\-devel  |  aarch64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf\-devel  |  x86\_64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf\-doc  |  noarch  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf\-libs  |  aarch64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qpdf\-libs  |  x86\_64  |  qpdf  |  10\.6\.3\-4\.amzn2023\.0\.4  | 
|  qrencode  |  aarch64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  qrencode  |  x86\_64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  qrencode\-devel  |  aarch64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  qrencode\-devel  |  x86\_64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  qrencode\-libs  |  aarch64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  qrencode\-libs  |  x86\_64  |  qrencode  |  4\.1\.1\-2\.amzn2023\.0\.2  | 
|  quota  |  aarch64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota  |  x86\_64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-devel  |  aarch64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-devel  |  x86\_64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-doc  |  noarch  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-nld  |  aarch64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-nld  |  x86\_64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-nls  |  noarch  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-rpc  |  aarch64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-rpc  |  x86\_64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-warnquota  |  aarch64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  quota\-warnquota  |  x86\_64  |  quota  |  4\.06\-4\.amzn2023\.0\.2  | 
|  libRmath  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  libRmath  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  libRmath\-devel  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  libRmath\-devel  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  libRmath\-static  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  libRmath\-static  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-core  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-core  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-core\-devel  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-core\-devel  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-devel  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-devel  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-java  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-java  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-java\-devel  |  aarch64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  R\-java\-devel  |  x86\_64  |  R  |  4\.1\.3\-1\.amzn2023\.0\.2  | 
|  radvd  |  aarch64  |  radvd  |  2\.19\-2\.amzn2023\.0\.2  | 
|  radvd  |  x86\_64  |  radvd  |  2\.19\-2\.amzn2023\.0\.2  | 
|  rapidjson\-devel  |  aarch64  |  rapidjson  |  1\.1\.0\-16\.amzn2023\.0\.2  | 
|  rapidjson\-devel  |  x86\_64  |  rapidjson  |  1\.1\.0\-16\.amzn2023\.0\.2  | 
|  rapidjson\-doc  |  noarch  |  rapidjson  |  1\.1\.0\-16\.amzn2023\.0\.2  | 
|  ibacm  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  ibacm  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  infiniband\-diags  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  infiniband\-diags  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  infiniband\-diags\-compat  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  infiniband\-diags\-compat  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  iwpmd  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  iwpmd  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibumad  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibumad  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibverbs  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibverbs  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibverbs\-utils  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  libibverbs\-utils  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  librdmacm  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  librdmacm  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  librdmacm\-utils  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  librdmacm\-utils  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  python3\-pyverbs  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  python3\-pyverbs  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  rdma\-core  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  rdma\-core  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  rdma\-core\-devel  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  rdma\-core\-devel  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  srp\_daemon  |  aarch64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  srp\_daemon  |  x86\_64  |  rdma\-core  |  37\.0\-1\.amzn2023\.0\.3  | 
|  re2  |  aarch64  |  re2  |  20211101\-3\.amzn2023\.0\.2  | 
|  re2  |  x86\_64  |  re2  |  20211101\-3\.amzn2023\.0\.2  | 
|  re2\-devel  |  aarch64  |  re2  |  20211101\-3\.amzn2023\.0\.2  | 
|  re2\-devel  |  x86\_64  |  re2  |  20211101\-3\.amzn2023\.0\.2  | 
|  re2c  |  aarch64  |  re2c  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  re2c  |  x86\_64  |  re2c  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  readline  |  aarch64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  readline  |  x86\_64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  readline\-devel  |  aarch64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  readline\-devel  |  x86\_64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  readline\-static  |  aarch64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  readline\-static  |  x86\_64  |  readline  |  8\.1\-2\.amzn2023\.0\.2  | 
|  realmd  |  aarch64  |  realmd  |  0\.17\.0\-9\.amzn2023\.0\.3  | 
|  realmd  |  x86\_64  |  realmd  |  0\.17\.0\-9\.amzn2023\.0\.3  | 
|  realmd\-devel\-docs  |  aarch64  |  realmd  |  0\.17\.0\-9\.amzn2023\.0\.3  | 
|  realmd\-devel\-docs  |  x86\_64  |  realmd  |  0\.17\.0\-9\.amzn2023\.0\.3  | 
|  recode  |  aarch64  |  recode  |  3\.7\.8\-2\.amzn2023\.0\.2  | 
|  recode  |  x86\_64  |  recode  |  3\.7\.8\-2\.amzn2023\.0\.2  | 
|  recode\-devel  |  aarch64  |  recode  |  3\.7\.8\-2\.amzn2023\.0\.2  | 
|  recode\-devel  |  x86\_64  |  recode  |  3\.7\.8\-2\.amzn2023\.0\.2  | 
|  redis6  |  aarch64  |  redis6  |  6\.2\.12\-1\.amzn2023\.0\.1  | 
|  redis6  |  x86\_64  |  redis6  |  6\.2\.12\-1\.amzn2023\.0\.1  | 
|  redis6\-devel  |  aarch64  |  redis6  |  6\.2\.12\-1\.amzn2023\.0\.1  | 
|  redis6\-devel  |  x86\_64  |  redis6  |  6\.2\.12\-1\.amzn2023\.0\.1  | 
|  redis6\-doc  |  noarch  |  redis6  |  6\.2\.12\-1\.amzn2023\.0\.1  | 
|  reflections  |  noarch  |  reflections  |  0\.9\.12\-10\.amzn2023\.0\.1  | 
|  reflections\-javadoc  |  noarch  |  reflections  |  0\.9\.12\-10\.amzn2023\.0\.1  | 
|  regexp  |  noarch  |  regexp  |  1\.5\-38\.amzn2023\.0\.1  | 
|  regexp\-javadoc  |  noarch  |  regexp  |  1\.5\-38\.amzn2023\.0\.1  | 
|  replacer  |  noarch  |  replacer  |  1\.6\-22\.amzn2023\.0\.2  | 
|  replacer\-javadoc  |  noarch  |  replacer  |  1\.6\-22\.amzn2023\.0\.2  | 
|  rest  |  aarch64  |  rest  |  0\.8\.1\-9\.amzn2023\.0\.2  | 
|  rest  |  x86\_64  |  rest  |  0\.8\.1\-9\.amzn2023\.0\.2  | 
|  rest\-devel  |  aarch64  |  rest  |  0\.8\.1\-9\.amzn2023\.0\.2  | 
|  rest\-devel  |  x86\_64  |  rest  |  0\.8\.1\-9\.amzn2023\.0\.2  | 
|  rhash  |  aarch64  |  rhash  |  1\.4\.0\-3\.amzn2023\.0\.2  | 
|  rhash  |  x86\_64  |  rhash  |  1\.4\.0\-3\.amzn2023\.0\.2  | 
|  rhash\-devel  |  aarch64  |  rhash  |  1\.4\.0\-3\.amzn2023\.0\.2  | 
|  rhash\-devel  |  x86\_64  |  rhash  |  1\.4\.0\-3\.amzn2023\.0\.2  | 
|  rhino  |  noarch  |  rhino  |  1\.7\.14\-3\.amzn2023\.0\.2  | 
|  rhino\-engine  |  noarch  |  rhino  |  1\.7\.14\-3\.amzn2023\.0\.2  | 
|  rhino\-javadoc  |  noarch  |  rhino  |  1\.7\.14\-3\.amzn2023\.0\.2  | 
|  rhino\-runtime  |  noarch  |  rhino  |  1\.7\.14\-3\.amzn2023\.0\.2  | 
|  rit\-meera\-new\-fonts  |  noarch  |  rit\-meera\-new\-fonts  |  1\.3\-1\.amzn2023\.0\.2  | 
|  rng\-tools  |  aarch64  |  rng\-tools  |  6\.14\-1\.git\.56626083\.amzn2023\.0\.3  | 
|  rng\-tools  |  x86\_64  |  rng\-tools  |  6\.14\-1\.git\.56626083\.amzn2023\.0\.3  | 
|  rootfiles  |  noarch  |  rootfiles  |  8\.1\-29\.amzn2023\.0\.2  | 
|  rpcbind  |  aarch64  |  rpcbind  |  1\.2\.6\-0\.amzn2023\.0\.2  | 
|  rpcbind  |  x86\_64  |  rpcbind  |  1\.2\.6\-0\.amzn2023\.0\.2  | 
|  rpcgen  |  aarch64  |  rpcsvc\-proto  |  1\.4\-7\.amzn2023\.0\.2  | 
|  rpcgen  |  x86\_64  |  rpcsvc\-proto  |  1\.4\-7\.amzn2023\.0\.2  | 
|  rpcsvc\-proto\-devel  |  aarch64  |  rpcsvc\-proto  |  1\.4\-7\.amzn2023\.0\.2  | 
|  rpcsvc\-proto\-devel  |  x86\_64  |  rpcsvc\-proto  |  1\.4\-7\.amzn2023\.0\.2  | 
|  python3\-rpm  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  python3\-rpm  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-apidocs  |  noarch  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-build  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-build  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-build\-libs  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-build\-libs  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-cron  |  noarch  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-devel  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-devel  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-libs  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-libs  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-audit  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-audit  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-fapolicyd  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-fapolicyd  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-ima  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-ima  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-prioreset  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-prioreset  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-selinux  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-selinux  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-syslog  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-syslog  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-systemd\-inhibit  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-plugin\-systemd\-inhibit  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-sign  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-sign  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-sign\-libs  |  aarch64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpm\-sign\-libs  |  x86\_64  |  rpm  |  4\.16\.1\.3\-12\.amzn2023\.0\.6  | 
|  rpmdevtools  |  noarch  |  rpmdevtools  |  9\.6\-1\.amzn2023\.0\.3  | 
|  rpmlint  |  noarch  |  rpmlint  |  1\.11\-19\.amzn2023\.0\.2  | 
|  rpm\-mpi\-hooks  |  noarch  |  rpm\-mpi\-hooks  |  8\-1\.amzn2023\.0\.2  | 
|  python3\-rrdtool  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  python3\-rrdtool  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-devel  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-devel  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-doc  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-doc  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-lua  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-lua  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-perl  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-perl  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-tcl  |  aarch64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  rrdtool\-tcl  |  x86\_64  |  rrdtool  |  1\.7\.2\-16\.amzn2023\.0\.3  | 
|  R\-rpm\-macros  |  noarch  |  R\-rpm\-macros  |  1\.2\.1\-2\.amzn2023\.0\.2  | 
|  rsync  |  aarch64  |  rsync  |  3\.2\.6\-1\.amzn2023\.0\.3  | 
|  rsync  |  x86\_64  |  rsync  |  3\.2\.6\-1\.amzn2023\.0\.3  | 
|  rsync\-daemon  |  noarch  |  rsync  |  3\.2\.6\-1\.amzn2023\.0\.3  | 
|  rsyslog  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-crypto  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-crypto  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-doc  |  noarch  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-elasticsearch  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-elasticsearch  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-logrotate  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-logrotate  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmaudit  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmaudit  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmfields  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmfields  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmjsonparse  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmjsonparse  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmkubernetes  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmkubernetes  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmnormalize  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-mmnormalize  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-openssl  |  aarch64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rsyslog\-openssl  |  x86\_64  |  rsyslog  |  8\.2204\.0\-3\.amzn2023\.0\.2  | 
|  rtkit  |  aarch64  |  rtkit  |  0\.11\-26\.amzn2023\.0\.2  | 
|  rtkit  |  x86\_64  |  rtkit  |  0\.11\-26\.amzn2023\.0\.2  | 
|  ruby3\.2  |  aarch64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2  |  x86\_64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-bundled\-gems  |  aarch64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-bundled\-gems  |  x86\_64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-default\-gems  |  noarch  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-devel  |  aarch64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-devel  |  x86\_64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-doc  |  noarch  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-libs  |  aarch64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-libs  |  x86\_64  |  ruby3\.2  |  3\.2\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-bigdecimal  |  aarch64  |  ruby3\.2  |  3\.1\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-bigdecimal  |  x86\_64  |  ruby3\.2  |  3\.1\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-bundler  |  noarch  |  ruby3\.2  |  2\.4\.10\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-io\-console  |  aarch64  |  ruby3\.2  |  0\.6\.0\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-io\-console  |  x86\_64  |  ruby3\.2  |  0\.6\.0\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-irb  |  noarch  |  ruby3\.2  |  1\.6\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-json  |  aarch64  |  ruby3\.2  |  2\.6\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-json  |  x86\_64  |  ruby3\.2  |  2\.6\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-minitest  |  noarch  |  ruby3\.2  |  5\.16\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-power\_assert  |  noarch  |  ruby3\.2  |  2\.0\.3\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-psych  |  aarch64  |  ruby3\.2  |  5\.0\.1\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-psych  |  x86\_64  |  ruby3\.2  |  5\.0\.1\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rake  |  noarch  |  ruby3\.2  |  13\.0\.6\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rbs  |  aarch64  |  ruby3\.2  |  2\.8\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rbs  |  x86\_64  |  ruby3\.2  |  2\.8\.2\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rdoc  |  noarch  |  ruby3\.2  |  6\.5\.0\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rexml  |  noarch  |  ruby3\.2  |  3\.2\.5\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-rss  |  noarch  |  ruby3\.2  |  0\.2\.9\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygems  |  noarch  |  ruby3\.2  |  3\.4\.10\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygems\-devel  |  noarch  |  ruby3\.2  |  3\.4\.10\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-test\-unit  |  noarch  |  ruby3\.2  |  3\.5\.7\-180\.amzn2023\.0\.1  | 
|  ruby3\.2\-rubygem\-typeprof  |  noarch  |  ruby3\.2  |  0\.21\.3\-180\.amzn2023\.0\.1  | 
|  rubygem\-asciidoctor  |  noarch  |  rubygem\-asciidoctor  |  2\.0\.15\-3\.amzn2023\.0\.1  | 
|  rubygem\-asciidoctor\-doc  |  noarch  |  rubygem\-asciidoctor  |  2\.0\.15\-3\.amzn2023\.0\.1  | 
|  rubygem\-mustache  |  noarch  |  rubygem\-mustache  |  1\.1\.1\-3\.amzn2023\.0\.1  | 
|  rubygem\-mustache\-doc  |  noarch  |  rubygem\-mustache  |  1\.1\.1\-3\.amzn2023\.0\.1  | 
|  runc  |  aarch64  |  runc  |  1\.1\.7\-1\.amzn2023\.0\.1  | 
|  runc  |  x86\_64  |  runc  |  1\.1\.7\-1\.amzn2023\.0\.1  | 
|  cargo  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  cargo  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  clippy  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  clippy  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-analysis  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-analysis  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-analyzer  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-analyzer  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-debugger\-common  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-doc  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-doc  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rustfmt  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rustfmt  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-gdb  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-lldb  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-src  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-std\-static  |  aarch64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-std\-static  |  x86\_64  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-std\-static\-wasm32\-unknown\-unknown  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-std\-static\-wasm32\-wasi  |  noarch  |  rust  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  python3\-rust2rpm  |  aarch64  |  rust\-packaging  |  21\-88\.amzn2023\.0\.2  | 
|  python3\-rust2rpm  |  x86\_64  |  rust\-packaging  |  21\-88\.amzn2023\.0\.2  | 
|  rust\-packaging  |  aarch64  |  rust\-packaging  |  21\-88\.amzn2023\.0\.2  | 
|  rust\-packaging  |  x86\_64  |  rust\-packaging  |  21\-88\.amzn2023\.0\.2  | 
|  rust\-srpm\-macros  |  noarch  |  rust\-srpm\-macros  |  21\-42\.amzn2023\.0\.2  | 
|  rust\-toolset  |  aarch64  |  rust\-toolset  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  rust\-toolset  |  x86\_64  |  rust\-toolset  |  1\.68\.2\-1\.amzn2023\.0\.1  | 
|  libnetapi  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libnetapi  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libnetapi\-devel  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libnetapi\-devel  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libsmbclient  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libsmbclient  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libsmbclient\-devel  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libsmbclient\-devel  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libwbclient  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libwbclient  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libwbclient\-devel  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  libwbclient\-devel  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-dc  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-dc  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-devel  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-devel  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-test  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-samba\-test  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-client  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-client  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-client\-libs  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-client\-libs  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-common  |  noarch  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-common\-libs  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-common\-libs  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-common\-tools  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-common\-tools  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-dcerpc  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-dcerpc  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-dc\-libs  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-dc\-libs  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-devel  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-devel  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-krb5\-printing  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-krb5\-printing  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-ldb\-ldap\-modules  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-ldb\-ldap\-modules  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-libs  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-libs  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-pidl  |  noarch  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-test  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-test  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-test\-libs  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-test\-libs  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-tools  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-tools  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-usershares  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-usershares  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-vfs\-iouring  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-vfs\-iouring  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-clients  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-clients  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-krb5\-locator  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-krb5\-locator  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-modules  |  aarch64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  samba\-winbind\-modules  |  x86\_64  |  samba  |  4\.17\.8\-0\.amzn2023\.0\.2  | 
|  python3\-sanlock  |  aarch64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  python3\-sanlock  |  x86\_64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock  |  aarch64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock  |  x86\_64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock\-devel  |  aarch64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock\-devel  |  x86\_64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock\-lib  |  aarch64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  sanlock\-lib  |  x86\_64  |  sanlock  |  3\.8\.4\-1\.amzn2023\.0\.2  | 
|  python3\-satyr  |  aarch64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  python3\-satyr  |  x86\_64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  satyr  |  aarch64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  satyr  |  x86\_64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  satyr\-devel  |  aarch64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  satyr\-devel  |  x86\_64  |  satyr  |  0\.38\-2\.amzn2023\.0\.2  | 
|  libsbc  |  aarch64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  libsbc  |  x86\_64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  sbc  |  aarch64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  sbc  |  x86\_64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  sbc\-devel  |  aarch64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  sbc\-devel  |  x86\_64  |  sbc  |  1\.4\-7\.amzn2023\.0\.2  | 
|  sbsigntools  |  aarch64  |  sbsigntools  |  0\.9\.4\-8\.amzn2023\.0\.2  | 
|  sbsigntools  |  x86\_64  |  sbsigntools  |  0\.9\.4\-8\.amzn2023\.0\.2  | 
|  scap\-security\-guide  |  noarch  |  scap\-security\-guide  |  0\.1\.66\-1\.amzn2023\.0\.1  | 
|  scap\-security\-guide\-doc  |  noarch  |  scap\-security\-guide  |  0\.1\.66\-1\.amzn2023\.0\.1  | 
|  python3\-scipy  |  aarch64  |  scipy  |  1\.7\.0\-3\.amzn2023\.0\.3  | 
|  python3\-scipy  |  x86\_64  |  scipy  |  1\.7\.0\-3\.amzn2023\.0\.3  | 
|  ptscotch\-mpich  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-mpich  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-mpich\-devel  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-mpich\-devel  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-mpich\-devel\-parmetis  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-mpich\-devel\-parmetis  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi\-devel  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi\-devel  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi\-devel\-parmetis  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  ptscotch\-openmpi\-devel\-parmetis  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  scotch  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  scotch  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  scotch\-devel  |  aarch64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  scotch\-devel  |  x86\_64  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  scotch\-doc  |  noarch  |  scotch  |  6\.1\.0\-2\.amzn2023\.0\.2  | 
|  screen  |  aarch64  |  screen  |  4\.8\.0\-5\.amzn2023\.0\.3  | 
|  screen  |  x86\_64  |  screen  |  4\.8\.0\-5\.amzn2023\.0\.3  | 
|  scrub  |  aarch64  |  scrub  |  2\.6\.1\-2\.amzn2023\.0\.2  | 
|  scrub  |  x86\_64  |  scrub  |  2\.6\.1\-2\.amzn2023\.0\.2  | 
|  sed  |  aarch64  |  sed  |  4\.8\-7\.amzn2023\.0\.2  | 
|  sed  |  x86\_64  |  sed  |  4\.8\-7\.amzn2023\.0\.2  | 
|  selinux\-policy  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-devel  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-doc  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-minimum  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-mls  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-sandbox  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  selinux\-policy\-targeted  |  noarch  |  selinux\-policy  |  36\.16\-1\.amzn2023\.0\.2  | 
|  sendmail  |  aarch64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail  |  x86\_64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-cf  |  noarch  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-doc  |  noarch  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-milter  |  aarch64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-milter  |  x86\_64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-milter\-devel  |  aarch64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  sendmail\-milter\-devel  |  x86\_64  |  sendmail  |  8\.17\.1\-5\.amzn2023\.0\.4  | 
|  python3\-setools  |  aarch64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  python3\-setools  |  x86\_64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  setools  |  aarch64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  setools  |  x86\_64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  setools\-console  |  aarch64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  setools\-console  |  x86\_64  |  setools  |  4\.4\.1\-1\.amzn2023  | 
|  setup  |  noarch  |  setup  |  2\.13\.7\-3\.amzn2023\.0\.2  | 
|  setxkbmap  |  aarch64  |  setxkbmap  |  1\.3\.2\-3\.amzn2023\.0\.2  | 
|  setxkbmap  |  x86\_64  |  setxkbmap  |  1\.3\.2\-3\.amzn2023\.0\.2  | 
|  sgml\-common  |  noarch  |  sgml\-common  |  0\.6\.3\-56\.amzn2023\.0\.2  | 
|  xml\-common  |  noarch  |  sgml\-common  |  0\.6\.3\-56\.amzn2023\.0\.2  | 
|  sgpio  |  aarch64  |  sgpio  |  1\.2\.0\.10\-28\.amzn2023\.0\.2  | 
|  sgpio  |  x86\_64  |  sgpio  |  1\.2\.0\.10\-28\.amzn2023\.0\.2  | 
|  shadow\-utils  |  aarch64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shadow\-utils  |  x86\_64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shadow\-utils\-subid  |  aarch64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shadow\-utils\-subid  |  x86\_64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shadow\-utils\-subid\-devel  |  aarch64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shadow\-utils\-subid\-devel  |  x86\_64  |  shadow\-utils  |  4\.9\-12\.amzn2023\.0\.2  | 
|  shared\-mime\-info  |  aarch64  |  shared\-mime\-info  |  2\.2\-2\.amzn2023\.0\.1  | 
|  shared\-mime\-info  |  x86\_64  |  shared\-mime\-info  |  2\.2\-2\.amzn2023\.0\.1  | 
|  sharutils  |  aarch64  |  sharutils  |  4\.15\.2\-19\.amzn2023\.0\.2  | 
|  sharutils  |  x86\_64  |  sharutils  |  4\.15\.2\-19\.amzn2023\.0\.2  | 
|  sil\-padauk\-book\-fonts  |  noarch  |  sil\-padauk\-fonts  |  3\.003\-7\.amzn2023\.0\.2  | 
|  sil\-padauk\-fonts  |  noarch  |  sil\-padauk\-fonts  |  3\.003\-7\.amzn2023\.0\.2  | 
|  python3\-pyqt4\-sip  |  aarch64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  python3\-pyqt4\-sip  |  x86\_64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  python3\-pyqt5\-sip  |  aarch64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  python3\-pyqt5\-sip  |  x86\_64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  python3\-sip\-devel  |  aarch64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  python3\-sip\-devel  |  x86\_64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  sip  |  aarch64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  sip  |  x86\_64  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  sip\-doc  |  noarch  |  sip  |  4\.19\.24\-3\.amzn2023\.0\.2  | 
|  sip5  |  aarch64  |  sip5  |  5\.5\.0\-2\.amzn2023\.0\.2  | 
|  sip5  |  x86\_64  |  sip5  |  5\.5\.0\-2\.amzn2023\.0\.2  | 
|  sisu  |  noarch  |  sisu  |  0\.3\.4\-9\.amzn2023\.0\.4  | 
|  sisu\-javadoc  |  noarch  |  sisu  |  0\.3\.4\-9\.amzn2023\.0\.4  | 
|  sisu\-mojos  |  noarch  |  sisu\-mojos  |  0\.3\.4\-11\.amzn2023\.0\.3  | 
|  sisu\-mojos\-javadoc  |  noarch  |  sisu\-mojos  |  0\.3\.4\-11\.amzn2023\.0\.3  | 
|  slang  |  aarch64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  slang  |  x86\_64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  slang\-devel  |  aarch64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  slang\-devel  |  x86\_64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  slang\-slsh  |  aarch64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  slang\-slsh  |  x86\_64  |  slang  |  2\.3\.2\-9\.amzn2023\.0\.3  | 
|  jcl\-over\-slf4j  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  jul\-to\-slf4j  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  log4j\-over\-slf4j  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-javadoc  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-jcl  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-jdk14  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-manual  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-migrator  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  slf4j\-sources  |  noarch  |  slf4j  |  1\.7\.32\-3\.amzn2023\.0\.4  | 
|  smartmontools  |  aarch64  |  smartmontools  |  7\.2\-11\.amzn2023\.0\.1  | 
|  smartmontools  |  x86\_64  |  smartmontools  |  7\.2\-11\.amzn2023\.0\.1  | 
|  smartmontools\-selinux  |  noarch  |  smartmontools  |  7\.2\-11\.amzn2023\.0\.1  | 
|  snakeyaml  |  noarch  |  snakeyaml  |  1\.27\-6\.amzn2023\.0\.2  | 
|  snakeyaml\-javadoc  |  noarch  |  snakeyaml  |  1\.27\-6\.amzn2023\.0\.2  | 
|  snappy  |  aarch64  |  snappy  |  1\.1\.8\-5\.amzn2023\.0\.2  | 
|  snappy  |  x86\_64  |  snappy  |  1\.1\.8\-5\.amzn2023\.0\.2  | 
|  snappy\-devel  |  aarch64  |  snappy  |  1\.1\.8\-5\.amzn2023\.0\.2  | 
|  snappy\-devel  |  x86\_64  |  snappy  |  1\.1\.8\-5\.amzn2023\.0\.2  | 
|  socat  |  aarch64  |  socat  |  1\.7\.4\.2\-1\.amzn2023\.0\.2  | 
|  socat  |  x86\_64  |  socat  |  1\.7\.4\.2\-1\.amzn2023\.0\.2  | 
|  libsocket\_wrapper\_noop  |  aarch64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  libsocket\_wrapper\_noop  |  x86\_64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  libsocket\_wrapper\_noop\-devel  |  aarch64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  libsocket\_wrapper\_noop\-devel  |  x86\_64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  socket\_wrapper  |  aarch64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  socket\_wrapper  |  x86\_64  |  socket\_wrapper  |  1\.3\.3\-2\.amzn2023\.0\.2  | 
|  softhsm  |  aarch64  |  softhsm  |  2\.6\.1\-5\.amzn2023\.4\.0\.2  | 
|  softhsm  |  x86\_64  |  softhsm  |  2\.6\.1\-5\.amzn2023\.4\.0\.2  | 
|  softhsm\-devel  |  aarch64  |  softhsm  |  2\.6\.1\-5\.amzn2023\.4\.0\.2  | 
|  softhsm\-devel  |  x86\_64  |  softhsm  |  2\.6\.1\-5\.amzn2023\.4\.0\.2  | 
|  sombok  |  aarch64  |  sombok  |  2\.4\.0\-14\.amzn2023\.0\.2  | 
|  sombok  |  x86\_64  |  sombok  |  2\.4\.0\-14\.amzn2023\.0\.2  | 
|  sombok\-devel  |  aarch64  |  sombok  |  2\.4\.0\-14\.amzn2023\.0\.2  | 
|  sombok\-devel  |  x86\_64  |  sombok  |  2\.4\.0\-14\.amzn2023\.0\.2  | 
|  source\-highlight  |  aarch64  |  source\-highlight  |  3\.1\.9\-9\.amzn2023\.0\.2  | 
|  source\-highlight  |  x86\_64  |  source\-highlight  |  3\.1\.9\-9\.amzn2023\.0\.2  | 
|  source\-highlight\-devel  |  aarch64  |  source\-highlight  |  3\.1\.9\-9\.amzn2023\.0\.2  | 
|  source\-highlight\-devel  |  x86\_64  |  source\-highlight  |  3\.1\.9\-9\.amzn2023\.0\.2  | 
|  soxr  |  aarch64  |  soxr  |  0\.1\.3\-9\.amzn2023\.0\.2  | 
|  soxr  |  x86\_64  |  soxr  |  0\.1\.3\-9\.amzn2023\.0\.2  | 
|  soxr\-devel  |  aarch64  |  soxr  |  0\.1\.3\-9\.amzn2023\.0\.2  | 
|  soxr\-devel  |  x86\_64  |  soxr  |  0\.1\.3\-9\.amzn2023\.0\.2  | 
|  sparsehash\-devel  |  aarch64  |  sparsehash  |  2\.0\.3\-4\.amzn2023\.0\.2  | 
|  sparsehash\-devel  |  x86\_64  |  sparsehash  |  2\.0\.3\-4\.amzn2023\.0\.2  | 
|  spec\-version\-maven\-plugin  |  noarch  |  spec\-version\-maven\-plugin  |  1\.5\-6\.amzn2023\.0\.1  | 
|  spec\-version\-maven\-plugin\-javadoc  |  noarch  |  spec\-version\-maven\-plugin  |  1\.5\-6\.amzn2023\.0\.1  | 
|  speex  |  aarch64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speex  |  x86\_64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speex\-devel  |  aarch64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speex\-devel  |  x86\_64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speex\-tools  |  aarch64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speex\-tools  |  x86\_64  |  speex  |  1\.2\.0\-8\.amzn2023\.0\.2  | 
|  speexdsp  |  aarch64  |  speexdsp  |  1\.2\.0\-3\.amzn2023\.0\.2  | 
|  speexdsp  |  x86\_64  |  speexdsp  |  1\.2\.0\-3\.amzn2023\.0\.2  | 
|  speexdsp\-devel  |  aarch64  |  speexdsp  |  1\.2\.0\-3\.amzn2023\.0\.2  | 
|  speexdsp\-devel  |  x86\_64  |  speexdsp  |  1\.2\.0\-3\.amzn2023\.0\.2  | 
|  libsphinxclient  |  aarch64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  libsphinxclient  |  x86\_64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  libsphinxclient\-devel  |  aarch64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  libsphinxclient\-devel  |  x86\_64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx  |  aarch64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx  |  x86\_64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx\-java  |  aarch64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx\-java  |  x86\_64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx\-php  |  aarch64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  sphinx\-php  |  x86\_64  |  sphinx  |  2\.2\.11\-24\.amzn2023\.0\.4  | 
|  spirv\-headers\-devel  |  noarch  |  spirv\-headers  |  1\.5\.5\-42\.amzn2023\.0\.1  | 
|  spirv\-llvm\-translator  |  aarch64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-llvm\-translator  |  x86\_64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-llvm\-translator\-devel  |  aarch64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-llvm\-translator\-devel  |  x86\_64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-llvm\-translator\-tools  |  aarch64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-llvm\-translator\-tools  |  x86\_64  |  spirv\-llvm\-translator  |  15\.0\.0\-2\.amzn2023\.0\.2  | 
|  spirv\-tools  |  aarch64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  spirv\-tools  |  x86\_64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  spirv\-tools\-devel  |  aarch64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  spirv\-tools\-devel  |  x86\_64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  spirv\-tools\-libs  |  aarch64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  spirv\-tools\-libs  |  x86\_64  |  spirv\-tools  |  2022\.2\-2\.amzn2023\.0\.2  | 
|  lemon  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  lemon  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-analyzer  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-analyzer  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-devel  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-devel  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-doc  |  noarch  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-libs  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-libs  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-tcl  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-tcl  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-tools  |  aarch64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  sqlite\-tools  |  x86\_64  |  sqlite  |  3\.40\.0\-1\.amzn2023\.0\.2  | 
|  squashfs\-tools  |  aarch64  |  squashfs\-tools  |  4\.5\-3\.amzn2023\.0\.2  | 
|  squashfs\-tools  |  x86\_64  |  squashfs\-tools  |  4\.5\-3\.amzn2023\.0\.2  | 
|  squid  |  aarch64  |  squid  |  5\.8\-1\.amzn2023  | 
|  squid  |  x86\_64  |  squid  |  5\.8\-1\.amzn2023  | 
|  sscg  |  aarch64  |  sscg  |  3\.0\.3\-76\.amzn2023  | 
|  sscg  |  x86\_64  |  sscg  |  3\.0\.3\-76\.amzn2023  | 
|  ssmtp  |  aarch64  |  ssmtp  |  2\.64\-26\.amzn2023\.0\.2  | 
|  ssmtp  |  x86\_64  |  ssmtp  |  2\.64\-26\.amzn2023\.0\.2  | 
|  libipa\_hbac  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libipa\_hbac  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libipa\_hbac\-devel  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libipa\_hbac\-devel  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_autofs  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_autofs  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_certmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_certmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_certmap\-devel  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_certmap\-devel  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_idmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_idmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_idmap\-devel  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_idmap\-devel  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_nss\_idmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_nss\_idmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_nss\_idmap\-devel  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_nss\_idmap\-devel  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_simpleifp  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_simpleifp  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_simpleifp\-devel  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_simpleifp\-devel  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_sudo  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  libsss\_sudo  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-libipa\_hbac  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-libipa\_hbac  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-libsss\_nss\_idmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-libsss\_nss\_idmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sss  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sss  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sssdconfig  |  noarch  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sss\-murmur  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  python3\-sss\-murmur  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ad  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ad  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-client  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-client  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-common  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-common  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-common\-pac  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-common\-pac  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-dbus  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-dbus  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ipa  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ipa  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-kcm  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-kcm  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-krb5  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-krb5  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-krb5\-common  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-krb5\-common  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ldap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-ldap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-nfs\-idmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-nfs\-idmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-proxy  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-proxy  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-tools  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-tools  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-winbind\-idmap  |  aarch64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  sssd\-winbind\-idmap  |  x86\_64  |  sssd  |  2\.5\.0\-1\.amzn2023\.0\.3  | 
|  rmt  |  aarch64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  rmt  |  x86\_64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  scpio  |  aarch64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  scpio  |  x86\_64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  spax  |  aarch64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  spax  |  x86\_64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  star  |  aarch64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  star  |  x86\_64  |  star  |  1\.6\-4\.amzn2023\.0\.2  | 
|  startup\-notification  |  aarch64  |  startup\-notification  |  0\.12\-21\.amzn2023\.0\.2  | 
|  startup\-notification  |  x86\_64  |  startup\-notification  |  0\.12\-21\.amzn2023\.0\.2  | 
|  startup\-notification\-devel  |  aarch64  |  startup\-notification  |  0\.12\-21\.amzn2023\.0\.2  | 
|  startup\-notification\-devel  |  x86\_64  |  startup\-notification  |  0\.12\-21\.amzn2023\.0\.2  | 
|  strace  |  aarch64  |  strace  |  5\.16\-2\.amzn2023\.0\.3  | 
|  strace  |  x86\_64  |  strace  |  5\.16\-2\.amzn2023\.0\.3  | 
|  stress  |  aarch64  |  stress  |  1\.0\.4\-28\.amzn2023\.0\.2  | 
|  stress  |  x86\_64  |  stress  |  1\.0\.4\-28\.amzn2023\.0\.2  | 
|  stress\-ng  |  aarch64  |  stress\-ng  |  0\.15\.05\-1\.amzn2023  | 
|  stress\-ng  |  x86\_64  |  stress\-ng  |  0\.15\.05\-1\.amzn2023  | 
|  stunnel  |  aarch64  |  stunnel  |  5\.58\-1\.amzn2023\.0\.2  | 
|  stunnel  |  x86\_64  |  stunnel  |  5\.58\-1\.amzn2023\.0\.2  | 
|  python3\-subversion  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  python3\-subversion  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-devel  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-devel  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-javahl  |  noarch  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-libs  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-libs  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-perl  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-perl  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-tools  |  aarch64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  subversion\-tools  |  x86\_64  |  subversion  |  1\.14\.2\-5\.amzn2023\.0\.3  | 
|  sudo  |  aarch64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo  |  x86\_64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-devel  |  aarch64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-devel  |  x86\_64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-logsrvd  |  aarch64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-logsrvd  |  x86\_64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-python\-plugin  |  aarch64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  sudo\-python\-plugin  |  x86\_64  |  sudo  |  1\.9\.13\-1\.p2\.amzn2023\.0\.1  | 
|  suitesparse  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_\-devel  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_\-devel  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_\-static  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\_\-static  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\-devel  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\-devel  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\-static  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse64\-static  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse\-devel  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse\-devel  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse\-doc  |  noarch  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse\-static  |  aarch64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  suitesparse\-static  |  x86\_64  |  suitesparse  |  5\.4\.0\-6\.amzn2023\.0\.2  | 
|  SuperLU  |  aarch64  |  SuperLU  |  5\.2\.2\-1\.amzn2023\.0\.2  | 
|  SuperLU  |  x86\_64  |  SuperLU  |  5\.2\.2\-1\.amzn2023\.0\.2  | 
|  SuperLU\-devel  |  aarch64  |  SuperLU  |  5\.2\.2\-1\.amzn2023\.0\.2  | 
|  SuperLU\-devel  |  x86\_64  |  SuperLU  |  5\.2\.2\-1\.amzn2023\.0\.2  | 
|  SuperLU\-doc  |  noarch  |  SuperLU  |  5\.2\.2\-1\.amzn2023\.0\.2  | 
|  superlu\_dist\-doc  |  noarch  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-mpich  |  aarch64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-mpich  |  x86\_64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-mpich\-devel  |  aarch64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-mpich\-devel  |  x86\_64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-openmpi  |  aarch64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-openmpi  |  x86\_64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-openmpi\-devel  |  aarch64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  superlu\_dist\-openmpi\-devel  |  x86\_64  |  superlu\_dist  |  6\.1\.1\-7\.amzn2023\.0\.2  | 
|  swig  |  aarch64  |  swig  |  4\.1\.1\-4\.amzn2023\.0\.3  | 
|  swig  |  x86\_64  |  swig  |  4\.1\.1\-4\.amzn2023\.0\.3  | 
|  swig\-doc  |  noarch  |  swig  |  4\.1\.1\-4\.amzn2023\.0\.3  | 
|  swig\-gdb  |  aarch64  |  swig  |  4\.1\.1\-4\.amzn2023\.0\.3  | 
|  swig\-gdb  |  x86\_64  |  swig  |  4\.1\.1\-4\.amzn2023\.0\.3  | 
|  symlinks  |  aarch64  |  symlinks  |  1\.7\-4\.amzn2023\.0\.2  | 
|  symlinks  |  x86\_64  |  symlinks  |  1\.7\-4\.amzn2023\.0\.2  | 
|  sysctl\-defaults  |  noarch  |  sysctl\-defaults  |  1\.0\-3\.amzn2023  | 
|  libsysfs  |  aarch64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  libsysfs  |  x86\_64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  libsysfs\-devel  |  aarch64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  libsysfs\-devel  |  x86\_64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  sysfsutils  |  aarch64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  sysfsutils  |  x86\_64  |  sysfsutils  |  2\.1\.1\-1\.amzn2023\.0\.2  | 
|  syslinux  |  x86\_64  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-devel  |  x86\_64  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-efi64  |  x86\_64  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-extlinux  |  x86\_64  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-extlinux\-nonlinux  |  noarch  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-nonlinux  |  noarch  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-perl  |  x86\_64  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  syslinux\-tftpboot  |  noarch  |  syslinux  |  6\.04\-0\.22\.amzn2023\.0\.3  | 
|  libsysprof  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  libsysprof  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  libsysprof\-ui  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  libsysprof\-ui  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-capture\-devel  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-capture\-devel  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-cli  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-cli  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-devel  |  aarch64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysprof\-devel  |  x86\_64  |  sysprof  |  3\.40\.1\-2\.amzn2023\.0\.2  | 
|  sysstat  |  aarch64  |  sysstat  |  12\.5\.6\-1\.amzn2023\.0\.3  | 
|  sysstat  |  x86\_64  |  sysstat  |  12\.5\.6\-1\.amzn2023\.0\.3  | 
|  systemd  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-container  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-container  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-devel  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-devel  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-journal\-remote  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-journal\-remote  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-libs  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-libs  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-networkd  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-networkd  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-oomd\-defaults  |  noarch  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-pam  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-pam  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-resolved  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-resolved  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-rpm\-macros  |  noarch  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-standalone\-sysusers  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-standalone\-sysusers  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-standalone\-tmpfiles  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-standalone\-tmpfiles  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-tests  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-tests  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-udev  |  aarch64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  systemd\-udev  |  x86\_64  |  systemd  |  252\.4\-1161\.amzn2023\.0\.4  | 
|  amazon\-linux\-repo\-cdn  |  noarch  |  system\-release  |  2023\.1\.20230719\-0\.amzn2023  | 
|  amazon\-linux\-repo\-s3  |  noarch  |  system\-release  |  2023\.1\.20230719\-0\.amzn2023  | 
|  kernel\-livepatch\-repo\-cdn  |  noarch  |  system\-release  |  2023\.1\.20230719\-0\.amzn2023  | 
|  kernel\-livepatch\-repo\-s3  |  noarch  |  system\-release  |  2023\.1\.20230719\-0\.amzn2023  | 
|  system\-release  |  noarch  |  system\-release  |  2023\.1\.20230719\-0\.amzn2023  | 
|  systemtap  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-client  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-client  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-devel  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-devel  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-exporter  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-exporter  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-initscript  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-initscript  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-java  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-java  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-python3  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-python3  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-virtguest  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-runtime\-virtguest  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-sdt\-devel  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-sdt\-devel  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-server  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-server  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-testsuite  |  aarch64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  systemtap\-testsuite  |  x86\_64  |  systemtap  |  4\.8\-3\.amzn2023\.0\.5  | 
|  t1lib  |  aarch64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib  |  x86\_64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-apps  |  aarch64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-apps  |  x86\_64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-devel  |  aarch64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-devel  |  x86\_64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-static  |  aarch64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1lib\-static  |  x86\_64  |  t1lib  |  5\.1\.2\-29\.amzn2023\.0\.2  | 
|  t1utils  |  aarch64  |  t1utils  |  1\.42\-2\.amzn2023\.0\.2  | 
|  t1utils  |  x86\_64  |  t1utils  |  1\.42\-2\.amzn2023\.0\.2  | 
|  taglib  |  aarch64  |  taglib  |  1\.12\-4\.amzn2023\.0\.2  | 
|  taglib  |  x86\_64  |  taglib  |  1\.12\-4\.amzn2023\.0\.2  | 
|  taglib\-devel  |  aarch64  |  taglib  |  1\.12\-4\.amzn2023\.0\.2  | 
|  taglib\-devel  |  x86\_64  |  taglib  |  1\.12\-4\.amzn2023\.0\.2  | 
|  tar  |  aarch64  |  tar  |  1\.34\-1\.amzn2023\.0\.3  | 
|  tar  |  x86\_64  |  tar  |  1\.34\-1\.amzn2023\.0\.3  | 
|  targetcli  |  noarch  |  targetcli  |  2\.1\.54\-7\.amzn2023  | 
|  python3\-tbb  |  aarch64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  python3\-tbb  |  x86\_64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb  |  aarch64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb  |  x86\_64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb\-devel  |  aarch64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb\-devel  |  x86\_64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb\-doc  |  aarch64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tbb\-doc  |  x86\_64  |  tbb  |  2020\.3\-7\.amzn2023\.0\.2  | 
|  tcl  |  aarch64  |  tcl  |  8\.6\.10\-5\.amzn2023\.0\.2  | 
|  tcl  |  x86\_64  |  tcl  |  8\.6\.10\-5\.amzn2023\.0\.2  | 
|  tcl\-devel  |  aarch64  |  tcl  |  8\.6\.10\-5\.amzn2023\.0\.2  | 
|  tcl\-devel  |  x86\_64  |  tcl  |  8\.6\.10\-5\.amzn2023\.0\.2  | 
|  tcl\-doc  |  noarch  |  tcl  |  8\.6\.10\-5\.amzn2023\.0\.2  | 
|  tclx  |  aarch64  |  tclx  |  8\.4\.0\-37\.amzn2023\.0\.2  | 
|  tclx  |  x86\_64  |  tclx  |  8\.4\.0\-37\.amzn2023\.0\.2  | 
|  tclx\-devel  |  aarch64  |  tclx  |  8\.4\.0\-37\.amzn2023\.0\.2  | 
|  tclx\-devel  |  x86\_64  |  tclx  |  8\.4\.0\-37\.amzn2023\.0\.2  | 
|  tcpdump  |  aarch64  |  tcpdump  |  4\.99\.1\-1\.amzn2023\.0\.2  | 
|  tcpdump  |  x86\_64  |  tcpdump  |  4\.99\.1\-1\.amzn2023\.0\.2  | 
|  tcsh  |  aarch64  |  tcsh  |  6\.24\.07\-1\.amzn2023  | 
|  tcsh  |  x86\_64  |  tcsh  |  6\.24\.07\-1\.amzn2023  | 
|  teckit  |  aarch64  |  teckit  |  2\.5\.9\-6\.amzn2023\.0\.2  | 
|  teckit  |  x86\_64  |  teckit  |  2\.5\.9\-6\.amzn2023\.0\.2  | 
|  teckit\-devel  |  aarch64  |  teckit  |  2\.5\.9\-6\.amzn2023\.0\.2  | 
|  teckit\-devel  |  x86\_64  |  teckit  |  2\.5\.9\-6\.amzn2023\.0\.2  | 
|  telnet  |  aarch64  |  telnet  |  0\.17\-83\.amzn2023\.0\.2  | 
|  telnet  |  x86\_64  |  telnet  |  0\.17\-83\.amzn2023\.0\.2  | 
|  telnet\-server  |  aarch64  |  telnet  |  0\.17\-83\.amzn2023\.0\.2  | 
|  telnet\-server  |  x86\_64  |  telnet  |  0\.17\-83\.amzn2023\.0\.2  | 
|  testng  |  noarch  |  testng  |  7\.4\.0\-3\.amzn2023\.0\.4  | 
|  testng\-javadoc  |  noarch  |  testng  |  7\.4\.0\-3\.amzn2023\.0\.4  | 
|  texi2html  |  noarch  |  texi2html  |  5\.0\-15\.amzn2023\.0\.2  | 
|  info  |  aarch64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  info  |  x86\_64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  texinfo  |  aarch64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  texinfo  |  x86\_64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  texinfo\-tex  |  aarch64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  texinfo\-tex  |  x86\_64  |  texinfo  |  6\.7\-10\.amzn2023\.0\.2  | 
|  texlive  |  noarch  |  texlive  |  2021\-59\.amzn2023\.0\.2  | 
|  texlive\-12many  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-12many\-doc  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-2up  |  noarch  |  texlive  |  svn55076\-59\.amzn2023\.0\.2  | 
|  texlive\-2up\-doc  |  noarch  |  texlive  |  svn55076\-59\.amzn2023\.0\.2  | 
|  texlive\-a0poster  |  noarch  |  texlive  |  svn54071\-59\.amzn2023\.0\.2  | 
|  texlive\-a4wide  |  noarch  |  texlive  |  svn20943\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-a4wide\-doc  |  noarch  |  texlive  |  svn20943\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-a5comb  |  noarch  |  texlive  |  svn17020\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-a5comb\-doc  |  noarch  |  texlive  |  svn17020\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-aaai\-named  |  noarch  |  texlive  |  svn52470\-59\.amzn2023\.0\.2  | 
|  texlive\-aalok  |  noarch  |  texlive  |  svn59300\-59\.amzn2023\.0\.2  | 
|  texlive\-aastex  |  noarch  |  texlive  |  svn58057\-59\.amzn2023\.0\.2  | 
|  texlive\-aastex\-doc  |  noarch  |  texlive  |  svn58057\-59\.amzn2023\.0\.2  | 
|  texlive\-abbr  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-abbr\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-abc  |  noarch  |  texlive  |  svn41157\-59\.amzn2023\.0\.2  | 
|  texlive\-abc\-doc  |  noarch  |  texlive  |  svn41157\-59\.amzn2023\.0\.2  | 
|  texlive\-abnt  |  noarch  |  texlive  |  svn55471\-59\.amzn2023\.0\.2  | 
|  texlive\-abntex2  |  noarch  |  texlive  |  svn49248\-59\.amzn2023\.0\.2  | 
|  texlive\-abntex2\-doc  |  noarch  |  texlive  |  svn49248\-59\.amzn2023\.0\.2  | 
|  texlive\-abraces  |  noarch  |  texlive  |  svn58761\-59\.amzn2023\.0\.2  | 
|  texlive\-abraces\-doc  |  noarch  |  texlive  |  svn58761\-59\.amzn2023\.0\.2  | 
|  texlive\-abstract  |  noarch  |  texlive  |  svn15878\.1\.2a\-59\.amzn2023\.0\.2  | 
|  texlive\-abstract\-doc  |  noarch  |  texlive  |  svn15878\.1\.2a\-59\.amzn2023\.0\.2  | 
|  texlive\-abstyles  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-abstyles\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-academicons  |  noarch  |  texlive  |  svn56119\-59\.amzn2023\.0\.2  | 
|  texlive\-academicons\-doc  |  noarch  |  texlive  |  svn56119\-59\.amzn2023\.0\.2  | 
|  texlive\-accanthis  |  noarch  |  texlive  |  svn32089\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-accanthis\-doc  |  noarch  |  texlive  |  svn32089\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-accents  |  noarch  |  texlive  |  svn51497\-59\.amzn2023\.0\.2  | 
|  texlive\-accessibility  |  noarch  |  texlive  |  svn55777\-59\.amzn2023\.0\.2  | 
|  texlive\-accsupp  |  noarch  |  texlive  |  svn53052\-59\.amzn2023\.0\.2  | 
|  texlive\-achemso  |  noarch  |  texlive  |  svn57479\-59\.amzn2023\.0\.2  | 
|  texlive\-achemso\-doc  |  noarch  |  texlive  |  svn57479\-59\.amzn2023\.0\.2  | 
|  texlive\-acmart  |  noarch  |  texlive  |  svn58893\-59\.amzn2023\.0\.2  | 
|  texlive\-acmart\-doc  |  noarch  |  texlive  |  svn58893\-59\.amzn2023\.0\.2  | 
|  texlive\-acmconf  |  noarch  |  texlive  |  svn15878\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-acmconf\-doc  |  noarch  |  texlive  |  svn15878\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-acro  |  noarch  |  texlive  |  svn57447\-59\.amzn2023\.0\.2  | 
|  texlive\-acro\-doc  |  noarch  |  texlive  |  svn57447\-59\.amzn2023\.0\.2  | 
|  texlive\-acronym  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-acronym\-doc  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-acroterm  |  noarch  |  texlive  |  svn20498\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-acroterm\-doc  |  noarch  |  texlive  |  svn20498\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-active\-conf  |  noarch  |  texlive  |  svn15878\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-active\-conf\-doc  |  noarch  |  texlive  |  svn15878\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-actuarialangle  |  noarch  |  texlive  |  svn51376\-59\.amzn2023\.0\.2  | 
|  texlive\-actuarialangle\-doc  |  noarch  |  texlive  |  svn51376\-59\.amzn2023\.0\.2  | 
|  texlive\-actuarialsymbol  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-addfont  |  noarch  |  texlive  |  svn58559\-59\.amzn2023\.0\.2  | 
|  texlive\-addliga  |  noarch  |  texlive  |  svn50912\-59\.amzn2023\.0\.2  | 
|  texlive\-addlines  |  noarch  |  texlive  |  svn49326\-59\.amzn2023\.0\.2  | 
|  texlive\-addlines\-doc  |  noarch  |  texlive  |  svn49326\-59\.amzn2023\.0\.2  | 
|  texlive\-adfathesis  |  noarch  |  texlive  |  svn26048\.2\.42\-59\.amzn2023\.0\.2  | 
|  texlive\-adfathesis\-doc  |  noarch  |  texlive  |  svn26048\.2\.42\-59\.amzn2023\.0\.2  | 
|  texlive\-adforn  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-adforn\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-adfsymbols  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-adfsymbols\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-adigraph  |  noarch  |  texlive  |  svn49862\-59\.amzn2023\.0\.2  | 
|  texlive\-adjmulticol  |  noarch  |  texlive  |  svn54157\-59\.amzn2023\.0\.2  | 
|  texlive\-adjmulticol\-doc  |  noarch  |  texlive  |  svn54157\-59\.amzn2023\.0\.2  | 
|  texlive\-adjustbox  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-adjustbox\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-adobemapping  |  noarch  |  texlive  |  svn51787\-59\.amzn2023\.0\.2  | 
|  texlive\-adrconv  |  noarch  |  texlive  |  svn46817\-59\.amzn2023\.0\.2  | 
|  texlive\-adrconv\-doc  |  noarch  |  texlive  |  svn46817\-59\.amzn2023\.0\.2  | 
|  texlive\-adtrees  |  noarch  |  texlive  |  svn51618\-59\.amzn2023\.0\.2  | 
|  texlive\-adtrees\-doc  |  noarch  |  texlive  |  svn51618\-59\.amzn2023\.0\.2  | 
|  texlive\-advdate  |  noarch  |  texlive  |  svn20538\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-advdate\-doc  |  noarch  |  texlive  |  svn20538\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ae  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ae\-doc  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-aeguill  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aeguill\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aesupp  |  noarch  |  texlive  |  svn58253\-59\.amzn2023\.0\.2  | 
|  texlive\-afparticle  |  noarch  |  texlive  |  svn35900\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-afparticle\-doc  |  noarch  |  texlive  |  svn35900\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-afthesis  |  noarch  |  texlive  |  svn15878\.2\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-afthesis\-doc  |  noarch  |  texlive  |  svn15878\.2\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-aguplus  |  noarch  |  texlive  |  svn17156\.1\.6b\-59\.amzn2023\.0\.2  | 
|  texlive\-aguplus\-doc  |  noarch  |  texlive  |  svn17156\.1\.6b\-59\.amzn2023\.0\.2  | 
|  texlive\-aiaa  |  noarch  |  texlive  |  svn15878\.3\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-aiaa\-doc  |  noarch  |  texlive  |  svn15878\.3\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-aichej  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ajl  |  noarch  |  texlive  |  svn34016\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-akktex  |  noarch  |  texlive  |  svn26055\.0\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-akktex\-doc  |  noarch  |  texlive  |  svn26055\.0\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-akletter  |  noarch  |  texlive  |  svn15878\.1\.5i\-59\.amzn2023\.0\.2  | 
|  texlive\-akletter\-doc  |  noarch  |  texlive  |  svn15878\.1\.5i\-59\.amzn2023\.0\.2  | 
|  texlive\-akshar  |  noarch  |  texlive  |  svn56277\-59\.amzn2023\.0\.2  | 
|  texlive\-alegreya  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-alegreya\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-alertmessage  |  noarch  |  texlive  |  svn38055\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-alertmessage\-doc  |  noarch  |  texlive  |  svn38055\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-alg  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-alg\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-algobox  |  noarch  |  texlive  |  svn52204\-59\.amzn2023\.0\.2  | 
|  texlive\-algolrevived  |  noarch  |  texlive  |  svn56864\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithm2e  |  noarch  |  texlive  |  svn44846\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithm2e\-doc  |  noarch  |  texlive  |  svn44846\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithmicx  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithmicx\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithms  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-algorithms\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-algpseudocodex  |  noarch  |  texlive  |  svn56125\-59\.amzn2023\.0\.2  | 
|  texlive\-algxpar  |  noarch  |  texlive  |  svn56006\-59\.amzn2023\.0\.2  | 
|  texlive\-aligned\-overset  |  noarch  |  texlive  |  svn47290\-59\.amzn2023\.0\.2  | 
|  texlive\-alkalami  |  noarch  |  texlive  |  svn44497\-59\.amzn2023\.0\.2  | 
|  texlive\-allrunes  |  noarch  |  texlive  |  svn42221\-59\.amzn2023\.0\.2  | 
|  texlive\-allrunes\-doc  |  noarch  |  texlive  |  svn42221\-59\.amzn2023\.0\.2  | 
|  texlive\-almendra  |  noarch  |  texlive  |  svn56035\-59\.amzn2023\.0\.2  | 
|  texlive\-almfixed  |  noarch  |  texlive  |  svn35065\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-almfixed\-doc  |  noarch  |  texlive  |  svn35065\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-alnumsec  |  noarch  |  texlive  |  svn15878\.v0\.03\-59\.amzn2023\.0\.2  | 
|  texlive\-alnumsec\-doc  |  noarch  |  texlive  |  svn15878\.v0\.03\-59\.amzn2023\.0\.2  | 
|  texlive\-alphalph  |  noarch  |  texlive  |  svn53087\-59\.amzn2023\.0\.2  | 
|  texlive\-alpha\-persian  |  noarch  |  texlive  |  svn50316\-59\.amzn2023\.0\.2  | 
|  texlive\-altfont  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-altfont\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-ametsoc  |  noarch  |  texlive  |  svn36030\.4\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-ametsoc\-doc  |  noarch  |  texlive  |  svn36030\.4\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-amiri  |  noarch  |  texlive  |  svn55403\-59\.amzn2023\.0\.2  | 
|  texlive\-amiri\-doc  |  noarch  |  texlive  |  svn55403\-59\.amzn2023\.0\.2  | 
|  texlive\-amsaddr  |  noarch  |  texlive  |  svn29630\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-amsaddr\-doc  |  noarch  |  texlive  |  svn29630\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-amscdx  |  noarch  |  texlive  |  svn51532\-59\.amzn2023\.0\.2  | 
|  texlive\-amscls  |  noarch  |  texlive  |  svn55378\-59\.amzn2023\.0\.2  | 
|  texlive\-amscls\-doc  |  noarch  |  texlive  |  svn46110\-59\.amzn2023\.0\.2  | 
|  texlive\-amsfonts  |  noarch  |  texlive  |  svn29208\.3\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-amsfonts\-doc  |  noarch  |  texlive  |  svn29208\.3\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-amslatex\-primer\-doc  |  noarch  |  texlive  |  svn28980\.2\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-amsldoc\-it\-doc  |  noarch  |  texlive  |  svn45662\-59\.amzn2023\.0\.2  | 
|  texlive\-amsldoc\-vn\-doc  |  noarch  |  texlive  |  svn21855\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-amsmath  |  noarch  |  texlive  |  svn56514\-59\.amzn2023\.0\.2  | 
|  texlive\-amsmath\-doc  |  noarch  |  texlive  |  svn56514\-59\.amzn2023\.0\.2  | 
|  texlive\-amsmath\-it\-doc  |  noarch  |  texlive  |  svn22930\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-amsrefs  |  noarch  |  texlive  |  svn30646\.2\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-amsrefs\-doc  |  noarch  |  texlive  |  svn30646\.2\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-amsthdoc\-it\-doc  |  noarch  |  texlive  |  svn45662\-59\.amzn2023\.0\.2  | 
|  texlive\-animate  |  noarch  |  texlive  |  svn56583\-59\.amzn2023\.0\.2  | 
|  texlive\-animate\-doc  |  noarch  |  texlive  |  svn56583\-59\.amzn2023\.0\.2  | 
|  texlive\-annee\-scolaire  |  noarch  |  texlive  |  svn55988\-59\.amzn2023\.0\.2  | 
|  texlive\-annotate  |  noarch  |  texlive  |  svn52824\-59\.amzn2023\.0\.2  | 
|  texlive\-anonchap  |  noarch  |  texlive  |  svn17049\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-anonchap\-doc  |  noarch  |  texlive  |  svn17049\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-anonymous\-acm  |  noarch  |  texlive  |  svn55121\-59\.amzn2023\.0\.2  | 
|  texlive\-anonymouspro  |  noarch  |  texlive  |  svn51631\-59\.amzn2023\.0\.2  | 
|  texlive\-anonymouspro\-doc  |  noarch  |  texlive  |  svn51631\-59\.amzn2023\.0\.2  | 
|  texlive\-answers  |  noarch  |  texlive  |  svn35032\.2\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-answers\-doc  |  noarch  |  texlive  |  svn35032\.2\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-antanilipsum  |  noarch  |  texlive  |  svn55250\-59\.amzn2023\.0\.2  | 
|  texlive\-antiqua  |  noarch  |  texlive  |  svn24266\.001\.003\-59\.amzn2023\.0\.2  | 
|  texlive\-antiqua\-doc  |  noarch  |  texlive  |  svn24266\.001\.003\-59\.amzn2023\.0\.2  | 
|  texlive\-antomega  |  noarch  |  texlive  |  svn21933\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-antomega\-doc  |  noarch  |  texlive  |  svn21933\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-antt  |  noarch  |  texlive  |  svn18651\.2\.08\-59\.amzn2023\.0\.2  | 
|  texlive\-antt\-doc  |  noarch  |  texlive  |  svn18651\.2\.08\-59\.amzn2023\.0\.2  | 
|  texlive\-anufinalexam\-doc  |  noarch  |  texlive  |  svn26053\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-anyfontsize  |  noarch  |  texlive  |  svn17050\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-anyfontsize\-doc  |  noarch  |  texlive  |  svn17050\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-anysize  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-anysize\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aobs\-tikz  |  noarch  |  texlive  |  svn32662\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aobs\-tikz\-doc  |  noarch  |  texlive  |  svn32662\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aomart  |  noarch  |  texlive  |  svn58855\-59\.amzn2023\.0\.2  | 
|  texlive\-aomart\-doc  |  noarch  |  texlive  |  svn58855\-59\.amzn2023\.0\.2  | 
|  texlive\-apa  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-apa6  |  noarch  |  texlive  |  svn53406\-59\.amzn2023\.0\.2  | 
|  texlive\-apa6\-doc  |  noarch  |  texlive  |  svn53406\-59\.amzn2023\.0\.2  | 
|  texlive\-apa6e  |  noarch  |  texlive  |  svn23350\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-apa6e\-doc  |  noarch  |  texlive  |  svn23350\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-apa7  |  noarch  |  texlive  |  svn58835\-59\.amzn2023\.0\.2  | 
|  texlive\-apacite  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-apacite\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-apa\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-apalike2  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-apalike\-german  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-apnum  |  noarch  |  texlive  |  svn47510\-59\.amzn2023\.0\.2  | 
|  texlive\-apnum\-doc  |  noarch  |  texlive  |  svn47510\-59\.amzn2023\.0\.2  | 
|  texlive\-appendix  |  noarch  |  texlive  |  svn53718\-59\.amzn2023\.0\.2  | 
|  texlive\-appendix\-doc  |  noarch  |  texlive  |  svn53718\-59\.amzn2023\.0\.2  | 
|  texlive\-appendixnumberbeamer  |  noarch  |  texlive  |  svn46317\-59\.amzn2023\.0\.2  | 
|  texlive\-appendixnumberbeamer\-doc  |  noarch  |  texlive  |  svn46317\-59\.amzn2023\.0\.2  | 
|  texlive\-apprendre\-a\-programmer\-en\-tex  |  noarch  |  texlive  |  svn57179\-59\.amzn2023\.0\.2  | 
|  texlive\-apprends\-latex\-doc  |  noarch  |  texlive  |  svn19306\.4\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-apptools  |  noarch  |  texlive  |  svn28400\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-apptools\-doc  |  noarch  |  texlive  |  svn28400\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-apxproof  |  noarch  |  texlive  |  svn56673\-59\.amzn2023\.0\.2  | 
|  texlive\-arabi  |  noarch  |  texlive  |  svn44662\-59\.amzn2023\.0\.2  | 
|  texlive\-arabi\-add  |  noarch  |  texlive  |  svn37709\-59\.amzn2023\.0\.2  | 
|  texlive\-arabi\-add\-doc  |  noarch  |  texlive  |  svn37709\-59\.amzn2023\.0\.2  | 
|  texlive\-arabicfront  |  noarch  |  texlive  |  svn51474\-59\.amzn2023\.0\.2  | 
|  texlive\-arabi\-doc  |  noarch  |  texlive  |  svn44662\-59\.amzn2023\.0\.2  | 
|  texlive\-arabluatex  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-arabluatex\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-arabtex  |  noarch  |  texlive  |  svn59150\-59\.amzn2023\.0\.2  | 
|  texlive\-arabtex\-doc  |  noarch  |  texlive  |  svn59150\-59\.amzn2023\.0\.2  | 
|  texlive\-arabxetex  |  noarch  |  texlive  |  svn38299\.1\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-arabxetex\-doc  |  noarch  |  texlive  |  svn38299\.1\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-aramaic\-serto  |  noarch  |  texlive  |  svn30042\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aramaic\-serto\-doc  |  noarch  |  texlive  |  svn30042\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-archaeologie  |  noarch  |  texlive  |  svn57090\-59\.amzn2023\.0\.2  | 
|  texlive\-archaeologie\-doc  |  noarch  |  texlive  |  svn57090\-59\.amzn2023\.0\.2  | 
|  texlive\-archaic  |  noarch  |  texlive  |  svn38005\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-archaic\-doc  |  noarch  |  texlive  |  svn38005\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arcs  |  noarch  |  texlive  |  svn15878\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-arcs\-doc  |  noarch  |  texlive  |  svn15878\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-arev  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arev\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arimo  |  noarch  |  texlive  |  svn42880\-59\.amzn2023\.0\.2  | 
|  texlive\-armtex  |  noarch  |  texlive  |  svn33894\.3\.0\_beta3\-59\.amzn2023\.0\.2  | 
|  texlive\-armtex\-doc  |  noarch  |  texlive  |  svn33894\.3\.0\_beta3\-59\.amzn2023\.0\.2  | 
|  texlive\-around\-the\-bend\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arphic  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arphic\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arphic\-ttf  |  noarch  |  texlive  |  svn42675\-59\.amzn2023\.0\.2  | 
|  texlive\-arraycols  |  noarch  |  texlive  |  svn56997\-59\.amzn2023\.0\.2  | 
|  texlive\-arrayjobx  |  noarch  |  texlive  |  svn18125\.1\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-arrayjobx\-doc  |  noarch  |  texlive  |  svn18125\.1\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-arraysort  |  noarch  |  texlive  |  svn31576\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arraysort\-doc  |  noarch  |  texlive  |  svn31576\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-arsclassica  |  noarch  |  texlive  |  svn45656\-59\.amzn2023\.0\.2  | 
|  texlive\-arsclassica\-doc  |  noarch  |  texlive  |  svn45656\-59\.amzn2023\.0\.2  | 
|  texlive\-articleingud  |  noarch  |  texlive  |  svn38741\-59\.amzn2023\.0\.2  | 
|  texlive\-articleingud\-doc  |  noarch  |  texlive  |  svn38741\-59\.amzn2023\.0\.2  | 
|  texlive\-arydshln  |  noarch  |  texlive  |  svn50084\-59\.amzn2023\.0\.2  | 
|  texlive\-arydshln\-doc  |  noarch  |  texlive  |  svn50084\-59\.amzn2023\.0\.2  | 
|  texlive\-asaetr  |  noarch  |  texlive  |  svn15878\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-asaetr\-doc  |  noarch  |  texlive  |  svn15878\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-asana\-math  |  noarch  |  texlive  |  svn50999\-59\.amzn2023\.0\.2  | 
|  texlive\-asana\-math\-doc  |  noarch  |  texlive  |  svn50999\-59\.amzn2023\.0\.2  | 
|  texlive\-asapsym  |  noarch  |  texlive  |  svn40201\-59\.amzn2023\.0\.2  | 
|  texlive\-asapsym\-doc  |  noarch  |  texlive  |  svn40201\-59\.amzn2023\.0\.2  | 
|  texlive\-ascelike  |  noarch  |  texlive  |  svn29129\.2\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ascelike\-doc  |  noarch  |  texlive  |  svn29129\.2\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ascii\-chart\-doc  |  noarch  |  texlive  |  svn20536\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ascii\-font  |  noarch  |  texlive  |  svn29989\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ascii\-font\-doc  |  noarch  |  texlive  |  svn29989\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-asciilist  |  noarch  |  texlive  |  svn49060\-59\.amzn2023\.0\.2  | 
|  texlive\-asciilist\-doc  |  noarch  |  texlive  |  svn49060\-59\.amzn2023\.0\.2  | 
|  texlive\-ascmac  |  noarch  |  texlive  |  svn53411\-59\.amzn2023\.0\.2  | 
|  texlive\-askinclude  |  noarch  |  texlive  |  svn54725\-59\.amzn2023\.0\.2  | 
|  texlive\-askmaps  |  noarch  |  texlive  |  svn56730\-59\.amzn2023\.0\.2  | 
|  texlive\-askmaps\-doc  |  noarch  |  texlive  |  svn56730\-59\.amzn2023\.0\.2  | 
|  texlive\-asmeconf  |  noarch  |  texlive  |  svn57833\-59\.amzn2023\.0\.2  | 
|  texlive\-asmejour  |  noarch  |  texlive  |  svn57598\-59\.amzn2023\.0\.2  | 
|  texlive\-aspectratio  |  noarch  |  texlive  |  svn25243\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aspectratio\-doc  |  noarch  |  texlive  |  svn25243\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-assignment  |  noarch  |  texlive  |  svn20431\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-assignment\-doc  |  noarch  |  texlive  |  svn20431\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-assoccnt  |  noarch  |  texlive  |  svn38497\-59\.amzn2023\.0\.2  | 
|  texlive\-assoccnt\-doc  |  noarch  |  texlive  |  svn38497\-59\.amzn2023\.0\.2  | 
|  texlive\-association\-matrix  |  noarch  |  texlive  |  svn56759\-59\.amzn2023\.0\.2  | 
|  texlive\-astro  |  noarch  |  texlive  |  svn15878\.2\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-astro\-doc  |  noarch  |  texlive  |  svn15878\.2\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-asyfig  |  noarch  |  texlive  |  svn17512\.0\.1c\-59\.amzn2023\.0\.2  | 
|  texlive\-asyfig\-doc  |  noarch  |  texlive  |  svn17512\.0\.1c\-59\.amzn2023\.0\.2  | 
|  texlive\-asymptote\-by\-example\-zh\-cn\-doc  |  noarch  |  texlive  |  svn15878\-59\.amzn2023\.0\.2  | 
|  texlive\-asymptote\-faq\-zh\-cn\-doc  |  noarch  |  texlive  |  svn15878\-59\.amzn2023\.0\.2  | 
|  texlive\-asymptote\-manual\-zh\-cn\-doc  |  noarch  |  texlive  |  svn15878\-59\.amzn2023\.0\.2  | 
|  texlive\-asypictureb  |  noarch  |  texlive  |  svn33490\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-asypictureb\-doc  |  noarch  |  texlive  |  svn33490\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-atbegshi  |  noarch  |  texlive  |  svn53051\-59\.amzn2023\.0\.2  | 
|  texlive\-atenddvi  |  noarch  |  texlive  |  svn56922\-59\.amzn2023\.0\.2  | 
|  texlive\-atkinson  |  noarch  |  texlive  |  svn57624\-59\.amzn2023\.0\.2  | 
|  texlive\-attachfile  |  noarch  |  texlive  |  svn42099\-59\.amzn2023\.0\.2  | 
|  texlive\-attachfile\-doc  |  noarch  |  texlive  |  svn42099\-59\.amzn2023\.0\.2  | 
|  texlive\-atveryend  |  noarch  |  texlive  |  svn53108\-59\.amzn2023\.0\.2  | 
|  texlive\-aucklandthesis  |  noarch  |  texlive  |  svn51323\-59\.amzn2023\.0\.2  | 
|  texlive\-augie  |  noarch  |  texlive  |  svn18948\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-augie\-doc  |  noarch  |  texlive  |  svn18948\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-auncial\-new  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-auncial\-new\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-aurical  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-aurical\-doc  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-aurl  |  noarch  |  texlive  |  svn41853\-59\.amzn2023\.0\.2  | 
|  texlive\-authoraftertitle  |  noarch  |  texlive  |  svn55889\-59\.amzn2023\.0\.2  | 
|  texlive\-authoraftertitle\-doc  |  noarch  |  texlive  |  svn55889\-59\.amzn2023\.0\.2  | 
|  texlive\-authorarchive  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-authordate  |  noarch  |  texlive  |  svn52564\-59\.amzn2023\.0\.2  | 
|  texlive\-autoaligne  |  noarch  |  texlive  |  svn56966\-59\.amzn2023\.0\.2  | 
|  texlive\-autoarea  |  noarch  |  texlive  |  svn15878\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-autoarea\-doc  |  noarch  |  texlive  |  svn15878\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-autobreak  |  noarch  |  texlive  |  svn43337\-59\.amzn2023\.0\.2  | 
|  texlive\-autofancyhdr  |  noarch  |  texlive  |  svn54049\-59\.amzn2023\.0\.2  | 
|  texlive\-automata  |  noarch  |  texlive  |  svn19717\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-automata\-doc  |  noarch  |  texlive  |  svn19717\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-autonum  |  noarch  |  texlive  |  svn36084\.0\.3\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-autonum\-doc  |  noarch  |  texlive  |  svn36084\.0\.3\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-autopdf  |  noarch  |  texlive  |  svn32377\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-autopdf\-doc  |  noarch  |  texlive  |  svn32377\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-auto\-pst\-pdf  |  noarch  |  texlive  |  svn56596\-59\.amzn2023\.0\.2  | 
|  texlive\-auto\-pst\-pdf\-doc  |  noarch  |  texlive  |  svn56596\-59\.amzn2023\.0\.2  | 
|  texlive\-auto\-pst\-pdf\-lua  |  noarch  |  texlive  |  svn54779\-59\.amzn2023\.0\.2  | 
|  texlive\-auxhook  |  noarch  |  texlive  |  svn53173\-59\.amzn2023\.0\.2  | 
|  texlive\-avantgar  |  noarch  |  texlive  |  svn31835\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-avremu  |  noarch  |  texlive  |  svn35373\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-avremu\-doc  |  noarch  |  texlive  |  svn35373\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-awesomebox  |  noarch  |  texlive  |  svn57349\-59\.amzn2023\.0\.2  | 
|  texlive\-axessibility  |  noarch  |  texlive  |  svn57105\-59\.amzn2023\.0\.2  | 
|  texlive\-b1encoding  |  noarch  |  texlive  |  svn21271\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-b1encoding\-doc  |  noarch  |  texlive  |  svn21271\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel  |  noarch  |  texlive  |  svn58999\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-albanian  |  noarch  |  texlive  |  svn57005\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-albanian\-doc  |  noarch  |  texlive  |  svn57005\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-azerbaijani  |  noarch  |  texlive  |  svn44197\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bahasa  |  noarch  |  texlive  |  svn30255\.1\.0l\.metapackage\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bahasa\-doc  |  noarch  |  texlive  |  svn30255\.1\.0l\.metapackage\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-basque  |  noarch  |  texlive  |  svn30256\.1\.0f\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-basque\-doc  |  noarch  |  texlive  |  svn30256\.1\.0f\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-belarusian  |  noarch  |  texlive  |  svn49022\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-belarusian\-doc  |  noarch  |  texlive  |  svn49022\-59\.amzn2023\.0\.2  | 
|  texlive\-babelbib  |  noarch  |  texlive  |  svn57349\-59\.amzn2023\.0\.2  | 
|  texlive\-babelbib\-doc  |  noarch  |  texlive  |  svn57349\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bosnian  |  noarch  |  texlive  |  svn38174\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bosnian\-doc  |  noarch  |  texlive  |  svn38174\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-breton  |  noarch  |  texlive  |  svn30257\.1\.0h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-breton\-doc  |  noarch  |  texlive  |  svn30257\.1\.0h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bulgarian  |  noarch  |  texlive  |  svn31902\.1\.2g\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-bulgarian\-doc  |  noarch  |  texlive  |  svn31902\.1\.2g\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-catalan  |  noarch  |  texlive  |  svn30259\.2\.2p\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-catalan\-doc  |  noarch  |  texlive  |  svn30259\.2\.2p\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-croatian  |  noarch  |  texlive  |  svn35198\.1\.3l\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-croatian\-doc  |  noarch  |  texlive  |  svn35198\.1\.3l\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-czech  |  noarch  |  texlive  |  svn30261\.3\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-czech\-doc  |  noarch  |  texlive  |  svn30261\.3\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-danish  |  noarch  |  texlive  |  svn57642\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-danish\-doc  |  noarch  |  texlive  |  svn57642\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-doc  |  noarch  |  texlive  |  svn58999\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-dutch  |  noarch  |  texlive  |  svn56827\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-dutch\-doc  |  noarch  |  texlive  |  svn56827\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-english  |  noarch  |  texlive  |  svn44495\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-english\-doc  |  noarch  |  texlive  |  svn44495\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-esperanto  |  noarch  |  texlive  |  svn30265\.1\.4t\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-esperanto\-doc  |  noarch  |  texlive  |  svn30265\.1\.4t\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-estonian  |  noarch  |  texlive  |  svn38064\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-estonian\-doc  |  noarch  |  texlive  |  svn38064\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-finnish  |  noarch  |  texlive  |  svn57643\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-finnish\-doc  |  noarch  |  texlive  |  svn57643\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-french  |  noarch  |  texlive  |  svn56607\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-french\-doc  |  noarch  |  texlive  |  svn56607\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-friulan  |  noarch  |  texlive  |  svn39861\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-friulan\-doc  |  noarch  |  texlive  |  svn39861\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-galician  |  noarch  |  texlive  |  svn30270\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-galician\-doc  |  noarch  |  texlive  |  svn30270\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-georgian  |  noarch  |  texlive  |  svn45864\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-georgian\-doc  |  noarch  |  texlive  |  svn45864\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-german  |  noarch  |  texlive  |  svn57978\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-german\-doc  |  noarch  |  texlive  |  svn57978\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-greek  |  noarch  |  texlive  |  svn56904\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-greek\-doc  |  noarch  |  texlive  |  svn56904\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-hebrew  |  noarch  |  texlive  |  svn30273\.2\.3h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-hebrew\-doc  |  noarch  |  texlive  |  svn30273\.2\.3h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-hungarian  |  noarch  |  texlive  |  svn49701\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-hungarian\-doc  |  noarch  |  texlive  |  svn49701\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-icelandic  |  noarch  |  texlive  |  svn51551\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-icelandic\-doc  |  noarch  |  texlive  |  svn51551\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-indonesian  |  noarch  |  texlive  |  svn43235\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-indonesian\-doc  |  noarch  |  texlive  |  svn43235\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-interlingua  |  noarch  |  texlive  |  svn30276\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-interlingua\-doc  |  noarch  |  texlive  |  svn30276\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-irish  |  noarch  |  texlive  |  svn30277\.1\.0h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-irish\-doc  |  noarch  |  texlive  |  svn30277\.1\.0h\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-italian  |  noarch  |  texlive  |  svn55232\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-italian\-doc  |  noarch  |  texlive  |  svn55232\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-japanese  |  noarch  |  texlive  |  svn57733\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-kurmanji  |  noarch  |  texlive  |  svn30279\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-kurmanji\-doc  |  noarch  |  texlive  |  svn30279\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-latin  |  noarch  |  texlive  |  svn38173\.3\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-latin\-doc  |  noarch  |  texlive  |  svn38173\.3\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-latvian  |  noarch  |  texlive  |  svn46681\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-latvian\-doc  |  noarch  |  texlive  |  svn46681\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-macedonian  |  noarch  |  texlive  |  svn39587\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-macedonian\-doc  |  noarch  |  texlive  |  svn39587\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-malay  |  noarch  |  texlive  |  svn43234\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-malay\-doc  |  noarch  |  texlive  |  svn43234\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-norsk  |  noarch  |  texlive  |  svn30281\.2\.0i\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-norsk\-doc  |  noarch  |  texlive  |  svn30281\.2\.0i\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-occitan  |  noarch  |  texlive  |  svn39608\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-occitan\-doc  |  noarch  |  texlive  |  svn39608\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-piedmontese  |  noarch  |  texlive  |  svn30282\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-piedmontese\-doc  |  noarch  |  texlive  |  svn30282\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-polish  |  noarch  |  texlive  |  svn30283\.1\.2l\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-polish\-doc  |  noarch  |  texlive  |  svn30283\.1\.2l\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-portuges  |  noarch  |  texlive  |  svn57644\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-portuges\-doc  |  noarch  |  texlive  |  svn57644\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-romanian  |  noarch  |  texlive  |  svn58776\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-romanian\-doc  |  noarch  |  texlive  |  svn58776\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-romansh  |  noarch  |  texlive  |  svn30286\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-romansh\-doc  |  noarch  |  texlive  |  svn30286\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-russian  |  noarch  |  texlive  |  svn57376\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-russian\-doc  |  noarch  |  texlive  |  svn57376\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-samin  |  noarch  |  texlive  |  svn30288\.1\.0c\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-samin\-doc  |  noarch  |  texlive  |  svn30288\.1\.0c\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-scottish  |  noarch  |  texlive  |  svn30289\.1\.0g\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-scottish\-doc  |  noarch  |  texlive  |  svn30289\.1\.0g\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-serbian  |  noarch  |  texlive  |  svn58836\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-serbianc  |  noarch  |  texlive  |  svn58816\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-serbianc\-doc  |  noarch  |  texlive  |  svn58816\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-serbian\-doc  |  noarch  |  texlive  |  svn58836\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-slovak  |  noarch  |  texlive  |  svn30292\.3\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-slovak\-doc  |  noarch  |  texlive  |  svn30292\.3\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-slovenian  |  noarch  |  texlive  |  svn57666\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-slovenian\-doc  |  noarch  |  texlive  |  svn57666\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-sorbian  |  noarch  |  texlive  |  svn57646\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-sorbian\-doc  |  noarch  |  texlive  |  svn57646\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-spanish  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-spanish\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-swedish  |  noarch  |  texlive  |  svn57647\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-swedish\-doc  |  noarch  |  texlive  |  svn57647\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-thai  |  noarch  |  texlive  |  svn30564\.1\.0\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-thai\-doc  |  noarch  |  texlive  |  svn30564\.1\.0\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-turkish  |  noarch  |  texlive  |  svn51560\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-turkish\-doc  |  noarch  |  texlive  |  svn51560\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-ukrainian  |  noarch  |  texlive  |  svn56674\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-ukrainian\-doc  |  noarch  |  texlive  |  svn56674\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-vietnamese  |  noarch  |  texlive  |  svn39246\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-vietnamese\-doc  |  noarch  |  texlive  |  svn39246\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-welsh  |  noarch  |  texlive  |  svn38372\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-babel\-welsh\-doc  |  noarch  |  texlive  |  svn38372\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-background  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-background\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-backnaur  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-backnaur\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-baekmuk  |  noarch  |  texlive  |  svn56915\-59\.amzn2023\.0\.2  | 
|  texlive\-bagpipe  |  noarch  |  texlive  |  svn34393\.3\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-bagpipe\-doc  |  noarch  |  texlive  |  svn34393\.3\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-bangorcsthesis  |  noarch  |  texlive  |  svn48834\-59\.amzn2023\.0\.2  | 
|  texlive\-bangorcsthesis\-doc  |  noarch  |  texlive  |  svn48834\-59\.amzn2023\.0\.2  | 
|  texlive\-bangorexam  |  noarch  |  texlive  |  svn46626\-59\.amzn2023\.0\.2  | 
|  texlive\-bangtex  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-bangtex\-doc  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-bankstatement  |  noarch  |  texlive  |  svn38857\-59\.amzn2023\.0\.2  | 
|  texlive\-bankstatement\-doc  |  noarch  |  texlive  |  svn38857\-59\.amzn2023\.0\.2  | 
|  texlive\-barcodes  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-barcodes\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bardiag  |  noarch  |  texlive  |  svn22013\.0\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-bardiag\-doc  |  noarch  |  texlive  |  svn22013\.0\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-barr  |  noarch  |  texlive  |  svn38479\-59\.amzn2023\.0\.2  | 
|  texlive\-barracuda  |  noarch  |  texlive  |  svn53683\-59\.amzn2023\.0\.2  | 
|  texlive\-barr\-doc  |  noarch  |  texlive  |  svn38479\-59\.amzn2023\.0\.2  | 
|  texlive\-bartel\-chess\-fonts  |  noarch  |  texlive  |  svn20619\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bartel\-chess\-fonts\-doc  |  noarch  |  texlive  |  svn20619\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bashful  |  noarch  |  texlive  |  svn25597\.0\.93\-59\.amzn2023\.0\.2  | 
|  texlive\-bashful\-doc  |  noarch  |  texlive  |  svn25597\.0\.93\-59\.amzn2023\.0\.2  | 
|  texlive\-basicarith  |  noarch  |  texlive  |  svn35460\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-basicarith\-doc  |  noarch  |  texlive  |  svn35460\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-baskervald  |  noarch  |  texlive  |  svn19490\.1\.016\-59\.amzn2023\.0\.2  | 
|  texlive\-baskervald\-doc  |  noarch  |  texlive  |  svn19490\.1\.016\-59\.amzn2023\.0\.2  | 
|  texlive\-baskervaldx  |  noarch  |  texlive  |  svn57080\-59\.amzn2023\.0\.2  | 
|  texlive\-baskervaldx\-doc  |  noarch  |  texlive  |  svn57080\-59\.amzn2023\.0\.2  | 
|  texlive\-baskervillef  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-basque\-book  |  noarch  |  texlive  |  svn32924\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-basque\-book\-doc  |  noarch  |  texlive  |  svn32924\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-basque\-date  |  noarch  |  texlive  |  svn26477\.1\.05\-59\.amzn2023\.0\.2  | 
|  texlive\-basque\-date\-doc  |  noarch  |  texlive  |  svn26477\.1\.05\-59\.amzn2023\.0\.2  | 
|  texlive\-bath\-bst  |  noarch  |  texlive  |  svn57925\-59\.amzn2023\.0\.2  | 
|  texlive\-bbcard  |  noarch  |  texlive  |  svn19440\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbcard\-doc  |  noarch  |  texlive  |  svn19440\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbding  |  noarch  |  texlive  |  svn17186\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-bbding\-doc  |  noarch  |  texlive  |  svn17186\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-bbm  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbm\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbm\-macros  |  noarch  |  texlive  |  svn17224\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbm\-macros\-doc  |  noarch  |  texlive  |  svn17224\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbold  |  noarch  |  texlive  |  svn17187\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-bbold\-doc  |  noarch  |  texlive  |  svn17187\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-bbold\-type1  |  noarch  |  texlive  |  svn33143\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bbold\-type1\-doc  |  noarch  |  texlive  |  svn33143\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bchart  |  noarch  |  texlive  |  svn43928\-59\.amzn2023\.0\.2  | 
|  texlive\-bchart\-doc  |  noarch  |  texlive  |  svn43928\-59\.amzn2023\.0\.2  | 
|  texlive\-bclogo  |  noarch  |  texlive  |  svn39364\-59\.amzn2023\.0\.2  | 
|  texlive\-bclogo\-doc  |  noarch  |  texlive  |  svn39364\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer  |  noarch  |  texlive  |  svn58537\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer2thesis  |  noarch  |  texlive  |  svn27539\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer2thesis\-doc  |  noarch  |  texlive  |  svn27539\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerappendixnote  |  noarch  |  texlive  |  svn55732\-59\.amzn2023\.0\.2  | 
|  texlive\-beameraudience  |  noarch  |  texlive  |  svn23427\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-beameraudience\-doc  |  noarch  |  texlive  |  svn23427\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerauxtheme  |  noarch  |  texlive  |  svn56087\-59\.amzn2023\.0\.2  | 
|  texlive\-beamercolorthemeowl  |  noarch  |  texlive  |  svn40105\-59\.amzn2023\.0\.2  | 
|  texlive\-beamercolorthemeowl\-doc  |  noarch  |  texlive  |  svn40105\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerdarkthemes  |  noarch  |  texlive  |  svn55117\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerdarkthemes\-doc  |  noarch  |  texlive  |  svn55117\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-doc  |  noarch  |  texlive  |  svn58537\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-FUBerlin\-doc  |  noarch  |  texlive  |  svn38159\.0\.02b\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerposter  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerposter\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-rl  |  noarch  |  texlive  |  svn58513\-59\.amzn2023\.0\.2  | 
|  texlive\-beamersubframe  |  noarch  |  texlive  |  svn23510\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-beamersubframe\-doc  |  noarch  |  texlive  |  svn23510\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerswitch  |  noarch  |  texlive  |  svn58873\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-cuerna  |  noarch  |  texlive  |  svn42161\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-detlevcm  |  noarch  |  texlive  |  svn39048\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-detlevcm\-doc  |  noarch  |  texlive  |  svn39048\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-epyt  |  noarch  |  texlive  |  svn41404\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-epyt\-doc  |  noarch  |  texlive  |  svn41404\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-focus  |  noarch  |  texlive  |  svn56967\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerthemejltree  |  noarch  |  texlive  |  svn21977\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerthemelalic  |  noarch  |  texlive  |  svn58777\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-light  |  noarch  |  texlive  |  svn49867\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-metropolis  |  noarch  |  texlive  |  svn43031\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-metropolis\-doc  |  noarch  |  texlive  |  svn43031\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerthemenirma  |  noarch  |  texlive  |  svn20765\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerthemenirma\-doc  |  noarch  |  texlive  |  svn20765\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-beamerthemenord  |  noarch  |  texlive  |  svn56180\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-npbt  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-phnompenh  |  noarch  |  texlive  |  svn39100\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-phnompenh\-doc  |  noarch  |  texlive  |  svn39100\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-pure\-minimalistic  |  noarch  |  texlive  |  svn56934\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-saintpetersburg  |  noarch  |  texlive  |  svn45877\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-trigon  |  noarch  |  texlive  |  svn59004\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-upenn\-bc  |  noarch  |  texlive  |  svn29937\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-beamertheme\-upenn\-bc\-doc  |  noarch  |  texlive  |  svn29937\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-tut\-pt\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-verona  |  noarch  |  texlive  |  svn39180\-59\.amzn2023\.0\.2  | 
|  texlive\-beamer\-verona\-doc  |  noarch  |  texlive  |  svn39180\-59\.amzn2023\.0\.2  | 
|  texlive\-bearwear  |  noarch  |  texlive  |  svn54826\-59\.amzn2023\.0\.2  | 
|  texlive\-beaulivre  |  noarch  |  texlive  |  svn59320\-59\.amzn2023\.0\.2  | 
|  texlive\-beebe  |  noarch  |  texlive  |  svn58983\-59\.amzn2023\.0\.2  | 
|  texlive\-begingreek  |  noarch  |  texlive  |  svn36294\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-begingreek\-doc  |  noarch  |  texlive  |  svn36294\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-begriff  |  noarch  |  texlive  |  svn15878\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-begriff\-doc  |  noarch  |  texlive  |  svn15878\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-beilstein  |  noarch  |  texlive  |  svn56193\-59\.amzn2023\.0\.2  | 
|  texlive\-belleek  |  noarch  |  texlive  |  svn18651\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-belleek\-doc  |  noarch  |  texlive  |  svn18651\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bengali  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-bengali\-doc  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-bera  |  noarch  |  texlive  |  svn20031\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bera\-doc  |  noarch  |  texlive  |  svn20031\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-berenisadf  |  noarch  |  texlive  |  svn32215\.1\.004\-59\.amzn2023\.0\.2  | 
|  texlive\-berenisadf\-doc  |  noarch  |  texlive  |  svn32215\.1\.004\-59\.amzn2023\.0\.2  | 
|  texlive\-besjournals  |  noarch  |  texlive  |  svn45662\-59\.amzn2023\.0\.2  | 
|  texlive\-besjournals\-doc  |  noarch  |  texlive  |  svn45662\-59\.amzn2023\.0\.2  | 
|  texlive\-bestpapers  |  noarch  |  texlive  |  svn38708\-59\.amzn2023\.0\.2  | 
|  texlive\-bestpapers\-doc  |  noarch  |  texlive  |  svn38708\-59\.amzn2023\.0\.2  | 
|  texlive\-betababel  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-betababel\-doc  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-beton  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-beton\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-beuron  |  noarch  |  texlive  |  svn46374\-59\.amzn2023\.0\.2  | 
|  texlive\-bewerbung  |  noarch  |  texlive  |  svn56998\-59\.amzn2023\.0\.2  | 
|  texlive\-bewerbung\-doc  |  noarch  |  texlive  |  svn56998\-59\.amzn2023\.0\.2  | 
|  texlive\-bez123  |  noarch  |  texlive  |  svn15878\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-bez123\-doc  |  noarch  |  texlive  |  svn15878\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-bezierplot  |  noarch  |  texlive  |  svn51398\-59\.amzn2023\.0\.2  | 
|  texlive\-bgteubner  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bgteubner\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bguq  |  noarch  |  texlive  |  svn27401\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-bguq\-doc  |  noarch  |  texlive  |  svn27401\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-bhcexam  |  noarch  |  texlive  |  svn39041\-59\.amzn2023\.0\.2  | 
|  texlive\-bhcexam\-doc  |  noarch  |  texlive  |  svn39041\-59\.amzn2023\.0\.2  | 
|  texlive\-bibarts  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bibarts\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bib\-fr  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-bib\-fr\-doc  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-bibhtml  |  noarch  |  texlive  |  svn31607\.2\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bibhtml\-doc  |  noarch  |  texlive  |  svn31607\.2\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex  |  noarch  |  texlive  |  svn61868\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex2bibitem  |  noarch  |  texlive  |  svn54030\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-abnt  |  noarch  |  texlive  |  svn49179\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-abnt\-doc  |  noarch  |  texlive  |  svn49179\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ajc2020unofficial  |  noarch  |  texlive  |  svn54401\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-anonymous  |  noarch  |  texlive  |  svn48548\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-anonymous\-doc  |  noarch  |  texlive  |  svn48548\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-apa  |  noarch  |  texlive  |  svn56208\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-apa6  |  noarch  |  texlive  |  svn56209\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-apa\-doc  |  noarch  |  texlive  |  svn56208\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-archaeology  |  noarch  |  texlive  |  svn53281\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-arthistory\-bonn  |  noarch  |  texlive  |  svn46637\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bath  |  noarch  |  texlive  |  svn57924\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bookinarticle  |  noarch  |  texlive  |  svn40323\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bookinarticle\-doc  |  noarch  |  texlive  |  svn40323\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bookinother  |  noarch  |  texlive  |  svn54015\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bookinother\-doc  |  noarch  |  texlive  |  svn54015\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bwl  |  noarch  |  texlive  |  svn26556\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-bwl\-doc  |  noarch  |  texlive  |  svn26556\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-caspervector  |  noarch  |  texlive  |  svn56837\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-caspervector\-doc  |  noarch  |  texlive  |  svn56837\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-cheatsheet\-doc  |  noarch  |  texlive  |  svn44685\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-chem  |  noarch  |  texlive  |  svn57904\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-chem\-doc  |  noarch  |  texlive  |  svn57904\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-chicago  |  noarch  |  texlive  |  svn58715\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-chicago\-doc  |  noarch  |  texlive  |  svn58715\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-claves  |  noarch  |  texlive  |  svn43723\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-claves\-doc  |  noarch  |  texlive  |  svn43723\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-doc  |  noarch  |  texlive  |  svn61868\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-dw  |  noarch  |  texlive  |  svn42649\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-dw\-doc  |  noarch  |  texlive  |  svn42649\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-enc  |  noarch  |  texlive  |  svn44627\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ext  |  noarch  |  texlive  |  svn58975\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-fiwi  |  noarch  |  texlive  |  svn45876\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-fiwi\-doc  |  noarch  |  texlive  |  svn45876\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-gb7714\-2015  |  noarch  |  texlive  |  svn59101\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-german\-legal  |  noarch  |  texlive  |  svn56939\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-gost  |  noarch  |  texlive  |  svn59135\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-gost\-doc  |  noarch  |  texlive  |  svn59135\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-historian  |  noarch  |  texlive  |  svn19787\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-historian\-doc  |  noarch  |  texlive  |  svn19787\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ieee  |  noarch  |  texlive  |  svn58716\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ieee\-doc  |  noarch  |  texlive  |  svn58716\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ijsra  |  noarch  |  texlive  |  svn41634\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-ijsra\-doc  |  noarch  |  texlive  |  svn41634\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-iso690  |  noarch  |  texlive  |  svn54561\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-iso690\-doc  |  noarch  |  texlive  |  svn54561\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-jura2  |  noarch  |  texlive  |  svn56133\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-juradiss  |  noarch  |  texlive  |  svn56502\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-juradiss\-doc  |  noarch  |  texlive  |  svn56502\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-license  |  noarch  |  texlive  |  svn58437\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-lni  |  noarch  |  texlive  |  svn49935\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-lni\-doc  |  noarch  |  texlive  |  svn49935\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-luh\-ipw  |  noarch  |  texlive  |  svn32180\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-luh\-ipw\-doc  |  noarch  |  texlive  |  svn32180\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-manuscripts\-philology  |  noarch  |  texlive  |  svn53344\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-manuscripts\-philology\-doc  |  noarch  |  texlive  |  svn53344\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-mla  |  noarch  |  texlive  |  svn42445\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-mla\-doc  |  noarch  |  texlive  |  svn42445\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-morenames  |  noarch  |  texlive  |  svn43049\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-morenames\-doc  |  noarch  |  texlive  |  svn43049\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-multiple\-dm  |  noarch  |  texlive  |  svn37081\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-multiple\-dm\-doc  |  noarch  |  texlive  |  svn37081\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-musuos  |  noarch  |  texlive  |  svn24097\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-musuos\-doc  |  noarch  |  texlive  |  svn24097\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nature  |  noarch  |  texlive  |  svn57262\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nature\-doc  |  noarch  |  texlive  |  svn57262\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nejm  |  noarch  |  texlive  |  svn49839\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nejm\-doc  |  noarch  |  texlive  |  svn49839\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nottsclassic  |  noarch  |  texlive  |  svn41596\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-nottsclassic\-doc  |  noarch  |  texlive  |  svn41596\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-opcit\-booktitle  |  noarch  |  texlive  |  svn48983\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-opcit\-booktitle\-doc  |  noarch  |  texlive  |  svn48983\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-oxref  |  noarch  |  texlive  |  svn57513\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-philosophy  |  noarch  |  texlive  |  svn58925\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-philosophy\-doc  |  noarch  |  texlive  |  svn58925\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-phys  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-phys\-doc  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-publist  |  noarch  |  texlive  |  svn56392\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-publist\-doc  |  noarch  |  texlive  |  svn56392\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-realauthor  |  noarch  |  texlive  |  svn45865\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-realauthor\-doc  |  noarch  |  texlive  |  svn45865\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-sbl  |  noarch  |  texlive  |  svn56853\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-science  |  noarch  |  texlive  |  svn48945\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-science\-doc  |  noarch  |  texlive  |  svn48945\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-shortfields  |  noarch  |  texlive  |  svn45858\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-socialscienceshuberlin  |  noarch  |  texlive  |  svn47839\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-software  |  noarch  |  texlive  |  svn57366\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-source\-division  |  noarch  |  texlive  |  svn45379\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-source\-division\-doc  |  noarch  |  texlive  |  svn45379\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-subseries  |  noarch  |  texlive  |  svn43330\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-subseries\-doc  |  noarch  |  texlive  |  svn43330\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-swiss\-legal  |  noarch  |  texlive  |  svn58661\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-swiss\-legal\-doc  |  noarch  |  texlive  |  svn58661\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-trad  |  noarch  |  texlive  |  svn58169\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-trad\-doc  |  noarch  |  texlive  |  svn58169\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-true\-citepages\-omit  |  noarch  |  texlive  |  svn44653\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-true\-citepages\-omit\-doc  |  noarch  |  texlive  |  svn44653\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-unified  |  noarch  |  texlive  |  svn55290\-59\.amzn2023\.0\.2  | 
|  texlive\-biblatex\-vancouver  |  noarch  |  texlive  |  svn55339\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref  |  noarch  |  texlive  |  svn55626\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-doc  |  noarch  |  texlive  |  svn55626\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-french  |  noarch  |  texlive  |  svn53138\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-french\-doc  |  noarch  |  texlive  |  svn53138\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-german  |  noarch  |  texlive  |  svn21923\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-german\-doc  |  noarch  |  texlive  |  svn21923\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-lds  |  noarch  |  texlive  |  svn25526\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-lds\-doc  |  noarch  |  texlive  |  svn25526\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-mouth  |  noarch  |  texlive  |  svn25527\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-mouth\-doc  |  noarch  |  texlive  |  svn25527\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-parse  |  noarch  |  texlive  |  svn22054\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bibleref\-parse\-doc  |  noarch  |  texlive  |  svn22054\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bibletext  |  noarch  |  texlive  |  svn45196\-59\.amzn2023\.0\.2  | 
|  texlive\-bibletext\-doc  |  noarch  |  texlive  |  svn45196\-59\.amzn2023\.0\.2  | 
|  texlive\-biblist  |  noarch  |  texlive  |  svn17116\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biblist\-doc  |  noarch  |  texlive  |  svn17116\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bibtopic  |  noarch  |  texlive  |  svn15878\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-bibtopic\-doc  |  noarch  |  texlive  |  svn15878\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-bibtopicprefix  |  noarch  |  texlive  |  svn15878\.1\.10\-59\.amzn2023\.0\.2  | 
|  texlive\-bibtopicprefix\-doc  |  noarch  |  texlive  |  svn15878\.1\.10\-59\.amzn2023\.0\.2  | 
|  texlive\-bibunits  |  noarch  |  texlive  |  svn15878\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bibunits\-doc  |  noarch  |  texlive  |  svn15878\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bidi  |  noarch  |  texlive  |  svn55193\-59\.amzn2023\.0\.2  | 
|  texlive\-bidi\-atbegshi  |  noarch  |  texlive  |  svn35154\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bidi\-atbegshi\-doc  |  noarch  |  texlive  |  svn35154\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bidicontour  |  noarch  |  texlive  |  svn34631\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bidicontour\-doc  |  noarch  |  texlive  |  svn34631\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bidi\-doc  |  noarch  |  texlive  |  svn55193\-59\.amzn2023\.0\.2  | 
|  texlive\-bidihl  |  noarch  |  texlive  |  svn37795\.0\.1c\-59\.amzn2023\.0\.2  | 
|  texlive\-bidihl\-doc  |  noarch  |  texlive  |  svn37795\.0\.1c\-59\.amzn2023\.0\.2  | 
|  texlive\-bidipagegrid  |  noarch  |  texlive  |  svn34632\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bidipagegrid\-doc  |  noarch  |  texlive  |  svn34632\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bidipresentation  |  noarch  |  texlive  |  svn35267\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-bidipresentation\-doc  |  noarch  |  texlive  |  svn35267\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-bidishadowtext  |  noarch  |  texlive  |  svn34633\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bidishadowtext\-doc  |  noarch  |  texlive  |  svn34633\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bigfoot  |  noarch  |  texlive  |  svn38248\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bigfoot\-doc  |  noarch  |  texlive  |  svn38248\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bigintcalc  |  noarch  |  texlive  |  svn53172\-59\.amzn2023\.0\.2  | 
|  texlive\-bigints  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bigints\-doc  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-binarytree  |  noarch  |  texlive  |  svn41777\-59\.amzn2023\.0\.2  | 
|  texlive\-binomexp  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-binomexp\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biochemistry\-colors  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-biocon  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biocon\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-biolett\-bst  |  noarch  |  texlive  |  svn42217\-59\.amzn2023\.0\.2  | 
|  texlive\-bitelist  |  noarch  |  texlive  |  svn25779\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bitelist\-doc  |  noarch  |  texlive  |  svn25779\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bithesis  |  noarch  |  texlive  |  svn57388\-59\.amzn2023\.0\.2  | 
|  texlive\-bitpattern  |  noarch  |  texlive  |  svn39073\-59\.amzn2023\.0\.2  | 
|  texlive\-bitpattern\-doc  |  noarch  |  texlive  |  svn39073\-59\.amzn2023\.0\.2  | 
|  texlive\-bitset  |  noarch  |  texlive  |  svn53837\-59\.amzn2023\.0\.2  | 
|  texlive\-bitter  |  noarch  |  texlive  |  svn56026\-59\.amzn2023\.0\.2  | 
|  texlive\-bizcard  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bizcard\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-blacklettert1  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blacklettert1\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blindtext  |  noarch  |  texlive  |  svn25039\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blindtext\-doc  |  noarch  |  texlive  |  svn25039\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blkarray  |  noarch  |  texlive  |  svn36406\.0\.07\-59\.amzn2023\.0\.2  | 
|  texlive\-blkarray\-doc  |  noarch  |  texlive  |  svn36406\.0\.07\-59\.amzn2023\.0\.2  | 
|  texlive\-blochsphere  |  noarch  |  texlive  |  svn38388\-59\.amzn2023\.0\.2  | 
|  texlive\-blochsphere\-doc  |  noarch  |  texlive  |  svn38388\-59\.amzn2023\.0\.2  | 
|  texlive\-block  |  noarch  |  texlive  |  svn17209\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-block\-doc  |  noarch  |  texlive  |  svn17209\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blockdraw\_mp  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blockdraw\_mp\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bloques  |  noarch  |  texlive  |  svn22490\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bloques\-doc  |  noarch  |  texlive  |  svn22490\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-blowup  |  noarch  |  texlive  |  svn46213\-59\.amzn2023\.0\.2  | 
|  texlive\-blox  |  noarch  |  texlive  |  svn57949\-59\.amzn2023\.0\.2  | 
|  texlive\-blox\-doc  |  noarch  |  texlive  |  svn57949\-59\.amzn2023\.0\.2  | 
|  texlive\-bnumexpr  |  noarch  |  texlive  |  svn49643\-59\.amzn2023\.0\.2  | 
|  texlive\-bnumexpr\-doc  |  noarch  |  texlive  |  svn49643\-59\.amzn2023\.0\.2  | 
|  texlive\-bodegraph  |  noarch  |  texlive  |  svn20047\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-bodegraph\-doc  |  noarch  |  texlive  |  svn20047\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-bohr  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-bohr\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-boisik  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-boisik\-doc  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-boites  |  noarch  |  texlive  |  svn32235\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-boites\-doc  |  noarch  |  texlive  |  svn32235\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bold\-extra  |  noarch  |  texlive  |  svn17076\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bold\-extra\-doc  |  noarch  |  texlive  |  svn17076\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-boldtensors  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-boldtensors\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bondgraph  |  noarch  |  texlive  |  svn21670\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bondgraph\-doc  |  noarch  |  texlive  |  svn21670\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bondgraphs  |  noarch  |  texlive  |  svn36605\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bondgraphs\-doc  |  noarch  |  texlive  |  svn36605\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bookcover  |  noarch  |  texlive  |  svn57326\-59\.amzn2023\.0\.2  | 
|  texlive\-bookcover\-doc  |  noarch  |  texlive  |  svn57326\-59\.amzn2023\.0\.2  | 
|  texlive\-bookdb  |  noarch  |  texlive  |  svn37536\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bookdb\-doc  |  noarch  |  texlive  |  svn37536\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bookest  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bookest\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-bookhands  |  noarch  |  texlive  |  svn46480\-59\.amzn2023\.0\.2  | 
|  texlive\-bookhands\-doc  |  noarch  |  texlive  |  svn46480\-59\.amzn2023\.0\.2  | 
|  texlive\-booklet  |  noarch  |  texlive  |  svn15878\.0\.7b\-59\.amzn2023\.0\.2  | 
|  texlive\-booklet\-doc  |  noarch  |  texlive  |  svn15878\.0\.7b\-59\.amzn2023\.0\.2  | 
|  texlive\-bookman  |  noarch  |  texlive  |  svn31835\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bookmark  |  noarch  |  texlive  |  svn56885\-59\.amzn2023\.0\.2  | 
|  texlive\-bookshelf  |  noarch  |  texlive  |  svn55475\-59\.amzn2023\.0\.2  | 
|  texlive\-booktabs  |  noarch  |  texlive  |  svn53402\-59\.amzn2023\.0\.2  | 
|  texlive\-booktabs\-de\-doc  |  noarch  |  texlive  |  svn21907\.1\.61803\-59\.amzn2023\.0\.2  | 
|  texlive\-booktabs\-doc  |  noarch  |  texlive  |  svn53402\-59\.amzn2023\.0\.2  | 
|  texlive\-booktabs\-fr\-doc  |  noarch  |  texlive  |  svn21948\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-boolexpr  |  noarch  |  texlive  |  svn17830\.3\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-boolexpr\-doc  |  noarch  |  texlive  |  svn17830\.3\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-boondox  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-boondox\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-bophook  |  noarch  |  texlive  |  svn17062\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-bophook\-doc  |  noarch  |  texlive  |  svn17062\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-borceux  |  noarch  |  texlive  |  svn21047\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-borceux\-doc  |  noarch  |  texlive  |  svn21047\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bosisio  |  noarch  |  texlive  |  svn16989\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bosisio\-doc  |  noarch  |  texlive  |  svn16989\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-boxedminipage  |  noarch  |  texlive  |  svn54827\-59\.amzn2023\.0\.2  | 
|  texlive\-boxhandler  |  noarch  |  texlive  |  svn28031\.1\.30\-59\.amzn2023\.0\.2  | 
|  texlive\-boxhandler\-doc  |  noarch  |  texlive  |  svn28031\.1\.30\-59\.amzn2023\.0\.2  | 
|  texlive\-bpchem  |  noarch  |  texlive  |  svn45120\-59\.amzn2023\.0\.2  | 
|  texlive\-bpchem\-doc  |  noarch  |  texlive  |  svn45120\-59\.amzn2023\.0\.2  | 
|  texlive\-bpolynomial  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-bpolynomial\-doc  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-bracketkey  |  noarch  |  texlive  |  svn17129\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bracketkey\-doc  |  noarch  |  texlive  |  svn17129\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-braids  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-braids\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-braille  |  noarch  |  texlive  |  svn20655\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-braille\-doc  |  noarch  |  texlive  |  svn20655\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-braket  |  noarch  |  texlive  |  svn17127\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-braket\-doc  |  noarch  |  texlive  |  svn17127\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-brandeis\-dissertation  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-brandeis\-dissertation\-doc  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-brandeis\-problemset  |  noarch  |  texlive  |  svn50991\-59\.amzn2023\.0\.2  | 
|  texlive\-brandeis\-thesis  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-breakcites  |  noarch  |  texlive  |  svn21014\-59\.amzn2023\.0\.2  | 
|  texlive\-breakcites\-doc  |  noarch  |  texlive  |  svn21014\-59\.amzn2023\.0\.2  | 
|  texlive\-breakurl  |  noarch  |  texlive  |  svn29901\.1\.40\-59\.amzn2023\.0\.2  | 
|  texlive\-breakurl\-doc  |  noarch  |  texlive  |  svn29901\.1\.40\-59\.amzn2023\.0\.2  | 
|  texlive\-bredzenie  |  noarch  |  texlive  |  svn44371\-59\.amzn2023\.0\.2  | 
|  texlive\-breqn  |  noarch  |  texlive  |  svn56422\-59\.amzn2023\.0\.2  | 
|  texlive\-breqn\-doc  |  noarch  |  texlive  |  svn56422\-59\.amzn2023\.0\.2  | 
|  texlive\-br\-lex  |  noarch  |  texlive  |  svn44939\-59\.amzn2023\.0\.2  | 
|  texlive\-br\-lex\-doc  |  noarch  |  texlive  |  svn44939\-59\.amzn2023\.0\.2  | 
|  texlive\-bropd  |  noarch  |  texlive  |  svn35383\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bropd\-doc  |  noarch  |  texlive  |  svn35383\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-brushscr  |  noarch  |  texlive  |  svn28363\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-brushscr\-doc  |  noarch  |  texlive  |  svn28363\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-bubblesort  |  noarch  |  texlive  |  svn56070\-59\.amzn2023\.0\.2  | 
|  texlive\-buctthesis  |  noarch  |  texlive  |  svn59002\-59\.amzn2023\.0\.2  | 
|  texlive\-bullcntr  |  noarch  |  texlive  |  svn15878\.0\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-bullcntr\-doc  |  noarch  |  texlive  |  svn15878\.0\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-burmese  |  noarch  |  texlive  |  svn25185\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-burmese\-doc  |  noarch  |  texlive  |  svn25185\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-businesscard\-qrcode  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bussproofs  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bussproofs\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bussproofs\-extra  |  noarch  |  texlive  |  svn51299\-59\.amzn2023\.0\.2  | 
|  texlive\-bxbase  |  noarch  |  texlive  |  svn56528\-59\.amzn2023\.0\.2  | 
|  texlive\-bxbase\-doc  |  noarch  |  texlive  |  svn56528\-59\.amzn2023\.0\.2  | 
|  texlive\-bxcalc  |  noarch  |  texlive  |  svn56431\-59\.amzn2023\.0\.2  | 
|  texlive\-bxcjkjatype  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bxcjkjatype\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-bxdpx\-beamer  |  noarch  |  texlive  |  svn41813\-59\.amzn2023\.0\.2  | 
|  texlive\-bxdpx\-beamer\-doc  |  noarch  |  texlive  |  svn41813\-59\.amzn2023\.0\.2  | 
|  texlive\-bxdvidriver  |  noarch  |  texlive  |  svn43219\-59\.amzn2023\.0\.2  | 
|  texlive\-bxdvidriver\-doc  |  noarch  |  texlive  |  svn43219\-59\.amzn2023\.0\.2  | 
|  texlive\-bxeepic  |  noarch  |  texlive  |  svn30559\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bxeepic\-doc  |  noarch  |  texlive  |  svn30559\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-bxenclose  |  noarch  |  texlive  |  svn40213\-59\.amzn2023\.0\.2  | 
|  texlive\-bxenclose\-doc  |  noarch  |  texlive  |  svn40213\-59\.amzn2023\.0\.2  | 
|  texlive\-bxghost  |  noarch  |  texlive  |  svn53606\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjaholiday  |  noarch  |  texlive  |  svn57025\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjalipsum  |  noarch  |  texlive  |  svn43369\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjaprnind  |  noarch  |  texlive  |  svn45291\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjatoucs  |  noarch  |  texlive  |  svn52509\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjscls  |  noarch  |  texlive  |  svn57625\-59\.amzn2023\.0\.2  | 
|  texlive\-bxjscls\-doc  |  noarch  |  texlive  |  svn57625\-59\.amzn2023\.0\.2  | 
|  texlive\-bxnewfont  |  noarch  |  texlive  |  svn44173\-59\.amzn2023\.0\.2  | 
|  texlive\-bxnewfont\-doc  |  noarch  |  texlive  |  svn44173\-59\.amzn2023\.0\.2  | 
|  texlive\-bxorigcapt  |  noarch  |  texlive  |  svn48606\-59\.amzn2023\.0\.2  | 
|  texlive\-bxpapersize  |  noarch  |  texlive  |  svn56491\-59\.amzn2023\.0\.2  | 
|  texlive\-bxpapersize\-doc  |  noarch  |  texlive  |  svn56491\-59\.amzn2023\.0\.2  | 
|  texlive\-bxpdfver  |  noarch  |  texlive  |  svn57755\-59\.amzn2023\.0\.2  | 
|  texlive\-bxpdfver\-doc  |  noarch  |  texlive  |  svn57755\-59\.amzn2023\.0\.2  | 
|  texlive\-bxtexlogo  |  noarch  |  texlive  |  svn47230\-59\.amzn2023\.0\.2  | 
|  texlive\-bxwareki  |  noarch  |  texlive  |  svn51286\-59\.amzn2023\.0\.2  | 
|  texlive\-byo\-twemojis  |  noarch  |  texlive  |  svn58917\-59\.amzn2023\.0\.2  | 
|  texlive\-bytefield  |  noarch  |  texlive  |  svn56821\-59\.amzn2023\.0\.2  | 
|  texlive\-bytefield\-doc  |  noarch  |  texlive  |  svn56821\-59\.amzn2023\.0\.2  | 
|  texlive\-c90  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-c90\-doc  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-cabin  |  noarch  |  texlive  |  svn55907\-59\.amzn2023\.0\.2  | 
|  texlive\-cabin\-doc  |  noarch  |  texlive  |  svn55907\-59\.amzn2023\.0\.2  | 
|  texlive\-caladea  |  noarch  |  texlive  |  svn34991\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-caladea\-doc  |  noarch  |  texlive  |  svn34991\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calcage  |  noarch  |  texlive  |  svn27725\.0\.90\-59\.amzn2023\.0\.2  | 
|  texlive\-calcage\-doc  |  noarch  |  texlive  |  svn27725\.0\.90\-59\.amzn2023\.0\.2  | 
|  texlive\-calctab  |  noarch  |  texlive  |  svn15878\.v0\.6\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-calctab\-doc  |  noarch  |  texlive  |  svn15878\.v0\.6\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-calculation  |  noarch  |  texlive  |  svn35973\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calculation\-doc  |  noarch  |  texlive  |  svn35973\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calculator  |  noarch  |  texlive  |  svn33041\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calculator\-doc  |  noarch  |  texlive  |  svn33041\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calligra  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calligra\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calligra\-type1  |  noarch  |  texlive  |  svn24302\.001\.000\-59\.amzn2023\.0\.2  | 
|  texlive\-calligra\-type1\-doc  |  noarch  |  texlive  |  svn24302\.001\.000\-59\.amzn2023\.0\.2  | 
|  texlive\-callouts  |  noarch  |  texlive  |  svn44899\-59\.amzn2023\.0\.2  | 
|  texlive\-calrsfs  |  noarch  |  texlive  |  svn17125\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-calrsfs\-doc  |  noarch  |  texlive  |  svn17125\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cals  |  noarch  |  texlive  |  svn43003\-59\.amzn2023\.0\.2  | 
|  texlive\-cals\-doc  |  noarch  |  texlive  |  svn43003\-59\.amzn2023\.0\.2  | 
|  texlive\-calxxxx\-yyyy  |  noarch  |  texlive  |  svn57282\-59\.amzn2023\.0\.2  | 
|  texlive\-calxxxx\-yyyy\-doc  |  noarch  |  texlive  |  svn57282\-59\.amzn2023\.0\.2  | 
|  texlive\-cancel  |  noarch  |  texlive  |  svn32508\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cancel\-doc  |  noarch  |  texlive  |  svn32508\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-canoniclayout  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-canoniclayout\-doc  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-cantarell  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cantarell\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-captcont  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-captcont\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-captdef  |  noarch  |  texlive  |  svn17353\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-captdef\-doc  |  noarch  |  texlive  |  svn17353\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-caption  |  noarch  |  texlive  |  svn56771\-59\.amzn2023\.0\.2  | 
|  texlive\-caption\-doc  |  noarch  |  texlive  |  svn56771\-59\.amzn2023\.0\.2  | 
|  texlive\-capt\-of  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-capt\-of\-doc  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-carbohydrates  |  noarch  |  texlive  |  svn39000\-59\.amzn2023\.0\.2  | 
|  texlive\-carbohydrates\-doc  |  noarch  |  texlive  |  svn39000\-59\.amzn2023\.0\.2  | 
|  texlive\-carlisle  |  noarch  |  texlive  |  svn56753\-59\.amzn2023\.0\.2  | 
|  texlive\-carlisle\-doc  |  noarch  |  texlive  |  svn56753\-59\.amzn2023\.0\.2  | 
|  texlive\-carlito  |  noarch  |  texlive  |  svn35002\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-carlito\-doc  |  noarch  |  texlive  |  svn35002\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-carolmin\-ps  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-carolmin\-ps\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cascade  |  noarch  |  texlive  |  svn55759\-59\.amzn2023\.0\.2  | 
|  texlive\-cascadia\-code  |  noarch  |  texlive  |  svn57478\-59\.amzn2023\.0\.2  | 
|  texlive\-cascadilla  |  noarch  |  texlive  |  svn25144\.1\.8\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cascadilla\-doc  |  noarch  |  texlive  |  svn25144\.1\.8\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cases  |  noarch  |  texlive  |  svn54682\-59\.amzn2023\.0\.2  | 
|  texlive\-cases\-doc  |  noarch  |  texlive  |  svn54682\-59\.amzn2023\.0\.2  | 
|  texlive\-casyl  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-casyl\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-catchfile  |  noarch  |  texlive  |  svn53084\-59\.amzn2023\.0\.2  | 
|  texlive\-catchfilebetweentags  |  noarch  |  texlive  |  svn21476\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-catchfilebetweentags\-doc  |  noarch  |  texlive  |  svn21476\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-catcodes  |  noarch  |  texlive  |  svn38859\-59\.amzn2023\.0\.2  | 
|  texlive\-catcodes\-doc  |  noarch  |  texlive  |  svn38859\-59\.amzn2023\.0\.2  | 
|  texlive\-catechis  |  noarch  |  texlive  |  svn49061\-59\.amzn2023\.0\.2  | 
|  texlive\-catechis\-doc  |  noarch  |  texlive  |  svn49061\-59\.amzn2023\.0\.2  | 
|  texlive\-catoptions  |  noarch  |  texlive  |  svn35069\.0\.2\.7h\-59\.amzn2023\.0\.2  | 
|  texlive\-catoptions\-doc  |  noarch  |  texlive  |  svn35069\.0\.2\.7h\-59\.amzn2023\.0\.2  | 
|  texlive\-causets  |  noarch  |  texlive  |  svn57139\-59\.amzn2023\.0\.2  | 
|  texlive\-cbcoptic  |  noarch  |  texlive  |  svn16666\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cbcoptic\-doc  |  noarch  |  texlive  |  svn16666\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cbfonts  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-cbfonts\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-cbfonts\-fd  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-cbfonts\-fd\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-ccaption  |  noarch  |  texlive  |  svn23443\.3\.2c\-59\.amzn2023\.0\.2  | 
|  texlive\-ccaption\-doc  |  noarch  |  texlive  |  svn23443\.3\.2c\-59\.amzn2023\.0\.2  | 
|  texlive\-ccfonts  |  noarch  |  texlive  |  svn54686\-59\.amzn2023\.0\.2  | 
|  texlive\-ccfonts\-doc  |  noarch  |  texlive  |  svn54686\-59\.amzn2023\.0\.2  | 
|  texlive\-ccicons  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-ccicons\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cclicenses  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cclicenses\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ccool  |  noarch  |  texlive  |  svn56636\-59\.amzn2023\.0\.2  | 
|  texlive\-cc\-pl  |  noarch  |  texlive  |  svn58602\-59\.amzn2023\.0\.2  | 
|  texlive\-cc\-pl\-doc  |  noarch  |  texlive  |  svn58602\-59\.amzn2023\.0\.2  | 
|  texlive\-cd  |  noarch  |  texlive  |  svn34452\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-cd\-cover  |  noarch  |  texlive  |  svn17121\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cd\-cover\-doc  |  noarch  |  texlive  |  svn17121\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cd\-doc  |  noarch  |  texlive  |  svn34452\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-cdpbundl  |  noarch  |  texlive  |  svn46613\-59\.amzn2023\.0\.2  | 
|  texlive\-cdpbundl\-doc  |  noarch  |  texlive  |  svn46613\-59\.amzn2023\.0\.2  | 
|  texlive\-cell  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-cell\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-cellprops  |  noarch  |  texlive  |  svn57599\-59\.amzn2023\.0\.2  | 
|  texlive\-cellspace  |  noarch  |  texlive  |  svn50374\-59\.amzn2023\.0\.2  | 
|  texlive\-cellspace\-doc  |  noarch  |  texlive  |  svn50374\-59\.amzn2023\.0\.2  | 
|  texlive\-celtic  |  noarch  |  texlive  |  svn39797\-59\.amzn2023\.0\.2  | 
|  texlive\-celtic\-doc  |  noarch  |  texlive  |  svn39797\-59\.amzn2023\.0\.2  | 
|  texlive\-censor  |  noarch  |  texlive  |  svn49168\-59\.amzn2023\.0\.2  | 
|  texlive\-censor\-doc  |  noarch  |  texlive  |  svn49168\-59\.amzn2023\.0\.2  | 
|  texlive\-centeredline  |  noarch  |  texlive  |  svn50971\-59\.amzn2023\.0\.2  | 
|  texlive\-cesenaexam  |  noarch  |  texlive  |  svn44960\-59\.amzn2023\.0\.2  | 
|  texlive\-cfr\-initials  |  noarch  |  texlive  |  svn36728\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-cfr\-initials\-doc  |  noarch  |  texlive  |  svn36728\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-cfr\-lm  |  noarch  |  texlive  |  svn36195\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-cfr\-lm\-doc  |  noarch  |  texlive  |  svn36195\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-changebar  |  noarch  |  texlive  |  svn46919\-59\.amzn2023\.0\.2  | 
|  texlive\-changebar\-doc  |  noarch  |  texlive  |  svn46919\-59\.amzn2023\.0\.2  | 
|  texlive\-changelayout  |  noarch  |  texlive  |  svn16094\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-changelayout\-doc  |  noarch  |  texlive  |  svn16094\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-changelog  |  noarch  |  texlive  |  svn56338\-59\.amzn2023\.0\.2  | 
|  texlive\-changepage  |  noarch  |  texlive  |  svn15878\.1\.0c\-59\.amzn2023\.0\.2  | 
|  texlive\-changepage\-doc  |  noarch  |  texlive  |  svn15878\.1\.0c\-59\.amzn2023\.0\.2  | 
|  texlive\-changes  |  noarch  |  texlive  |  svn58773\-59\.amzn2023\.0\.2  | 
|  texlive\-changes\-doc  |  noarch  |  texlive  |  svn58773\-59\.amzn2023\.0\.2  | 
|  texlive\-chappg  |  noarch  |  texlive  |  svn15878\.2\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-chappg\-doc  |  noarch  |  texlive  |  svn15878\.2\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-chapterfolder  |  noarch  |  texlive  |  svn15878\.2\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-chapterfolder\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-charissil  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-charter  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-charter\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chbibref  |  noarch  |  texlive  |  svn17120\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chbibref\-doc  |  noarch  |  texlive  |  svn17120\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cheatsheet  |  noarch  |  texlive  |  svn45069\-59\.amzn2023\.0\.2  | 
|  texlive\-checkend  |  noarch  |  texlive  |  svn51475\-59\.amzn2023\.0\.2  | 
|  texlive\-chemarrow  |  noarch  |  texlive  |  svn17146\.0\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-chemarrow\-doc  |  noarch  |  texlive  |  svn17146\.0\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-chembst  |  noarch  |  texlive  |  svn15878\.0\.2\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-chembst\-doc  |  noarch  |  texlive  |  svn15878\.0\.2\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-chemcompounds  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chemcompounds\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chemcono  |  noarch  |  texlive  |  svn17119\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-chemcono\-doc  |  noarch  |  texlive  |  svn17119\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-chemexec  |  noarch  |  texlive  |  svn21632\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chemexec\-doc  |  noarch  |  texlive  |  svn21632\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chemfig  |  noarch  |  texlive  |  svn58014\-59\.amzn2023\.0\.2  | 
|  texlive\-chemfig\-doc  |  noarch  |  texlive  |  svn58014\-59\.amzn2023\.0\.2  | 
|  texlive\-chemformula  |  noarch  |  texlive  |  svn57206\-59\.amzn2023\.0\.2  | 
|  texlive\-chemformula\-doc  |  noarch  |  texlive  |  svn57206\-59\.amzn2023\.0\.2  | 
|  texlive\-chemgreek  |  noarch  |  texlive  |  svn53437\-59\.amzn2023\.0\.2  | 
|  texlive\-chemgreek\-doc  |  noarch  |  texlive  |  svn53437\-59\.amzn2023\.0\.2  | 
|  texlive\-chem\-journal  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chemmacros  |  noarch  |  texlive  |  svn56983\-59\.amzn2023\.0\.2  | 
|  texlive\-chemmacros\-doc  |  noarch  |  texlive  |  svn56983\-59\.amzn2023\.0\.2  | 
|  texlive\-chemnum  |  noarch  |  texlive  |  svn57490\-59\.amzn2023\.0\.2  | 
|  texlive\-chemnum\-doc  |  noarch  |  texlive  |  svn57490\-59\.amzn2023\.0\.2  | 
|  texlive\-chemplants  |  noarch  |  texlive  |  svn52863\-59\.amzn2023\.0\.2  | 
|  texlive\-chemschemex  |  noarch  |  texlive  |  svn46723\-59\.amzn2023\.0\.2  | 
|  texlive\-chemschemex\-doc  |  noarch  |  texlive  |  svn46723\-59\.amzn2023\.0\.2  | 
|  texlive\-chemsec  |  noarch  |  texlive  |  svn46972\-59\.amzn2023\.0\.2  | 
|  texlive\-chemstyle  |  noarch  |  texlive  |  svn31096\.2\.0m\-59\.amzn2023\.0\.2  | 
|  texlive\-chemstyle\-doc  |  noarch  |  texlive  |  svn31096\.2\.0m\-59\.amzn2023\.0\.2  | 
|  texlive\-cherokee  |  noarch  |  texlive  |  svn21046\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cherokee\-doc  |  noarch  |  texlive  |  svn21046\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chess  |  noarch  |  texlive  |  svn20582\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-chessboard  |  noarch  |  texlive  |  svn56833\-59\.amzn2023\.0\.2  | 
|  texlive\-chessboard\-doc  |  noarch  |  texlive  |  svn56833\-59\.amzn2023\.0\.2  | 
|  texlive\-chess\-doc  |  noarch  |  texlive  |  svn20582\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-chessfss  |  noarch  |  texlive  |  svn19440\.1\.2a\-59\.amzn2023\.0\.2  | 
|  texlive\-chessfss\-doc  |  noarch  |  texlive  |  svn19440\.1\.2a\-59\.amzn2023\.0\.2  | 
|  texlive\-chess\-problem\-diagrams  |  noarch  |  texlive  |  svn53302\-59\.amzn2023\.0\.2  | 
|  texlive\-chess\-problem\-diagrams\-doc  |  noarch  |  texlive  |  svn53302\-59\.amzn2023\.0\.2  | 
|  texlive\-chet  |  noarch  |  texlive  |  svn45081\-59\.amzn2023\.0\.2  | 
|  texlive\-chet\-doc  |  noarch  |  texlive  |  svn45081\-59\.amzn2023\.0\.2  | 
|  texlive\-chextras  |  noarch  |  texlive  |  svn27118\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-chextras\-doc  |  noarch  |  texlive  |  svn27118\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-chhaya  |  noarch  |  texlive  |  svn57508\-59\.amzn2023\.0\.2  | 
|  texlive\-chicago  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chicagoa  |  noarch  |  texlive  |  svn52567\-59\.amzn2023\.0\.2  | 
|  texlive\-chicago\-annote  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chicago\-annote\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chickenize  |  noarch  |  texlive  |  svn57325\-59\.amzn2023\.0\.2  | 
|  texlive\-chickenize\-doc  |  noarch  |  texlive  |  svn57325\-59\.amzn2023\.0\.2  | 
|  texlive\-chifoot  |  noarch  |  texlive  |  svn57312\-59\.amzn2023\.0\.2  | 
|  texlive\-childdoc  |  noarch  |  texlive  |  svn49543\-59\.amzn2023\.0\.2  | 
|  texlive\-chinese\-jfm  |  noarch  |  texlive  |  svn57758\-59\.amzn2023\.0\.2  | 
|  texlive\-chivo  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-chivo\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-chkfloat  |  noarch  |  texlive  |  svn27473\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-chkfloat\-doc  |  noarch  |  texlive  |  svn27473\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-chletter  |  noarch  |  texlive  |  svn20060\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chletter\-doc  |  noarch  |  texlive  |  svn20060\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-chngcntr  |  noarch  |  texlive  |  svn47577\-59\.amzn2023\.0\.2  | 
|  texlive\-chngcntr\-doc  |  noarch  |  texlive  |  svn47577\-59\.amzn2023\.0\.2  | 
|  texlive\-chordbars  |  noarch  |  texlive  |  svn49569\-59\.amzn2023\.0\.2  | 
|  texlive\-chordbox  |  noarch  |  texlive  |  svn51000\-59\.amzn2023\.0\.2  | 
|  texlive\-chronology  |  noarch  |  texlive  |  svn37934\.1\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-chronology\-doc  |  noarch  |  texlive  |  svn37934\.1\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-chronosys  |  noarch  |  texlive  |  svn26700\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-chronosys\-doc  |  noarch  |  texlive  |  svn26700\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-chscite  |  noarch  |  texlive  |  svn28552\.2\.9999\-59\.amzn2023\.0\.2  | 
|  texlive\-chscite\-doc  |  noarch  |  texlive  |  svn28552\.2\.9999\-59\.amzn2023\.0\.2  | 
|  texlive\-chs\-physics\-report  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-churchslavonic  |  noarch  |  texlive  |  svn42751\-59\.amzn2023\.0\.2  | 
|  texlive\-churchslavonic\-doc  |  noarch  |  texlive  |  svn42751\-59\.amzn2023\.0\.2  | 
|  texlive\-cinzel  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cinzel\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-circ  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-circ\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-circledsteps  |  noarch  |  texlive  |  svn53382\-59\.amzn2023\.0\.2  | 
|  texlive\-circuitikz  |  noarch  |  texlive  |  svn59147\-59\.amzn2023\.0\.2  | 
|  texlive\-circuitikz\-doc  |  noarch  |  texlive  |  svn59147\-59\.amzn2023\.0\.2  | 
|  texlive\-circuit\-macros  |  noarch  |  texlive  |  svn57308\-59\.amzn2023\.0\.2  | 
|  texlive\-cite  |  noarch  |  texlive  |  svn36428\.5\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-citeall  |  noarch  |  texlive  |  svn45975\-59\.amzn2023\.0\.2  | 
|  texlive\-citeall\-doc  |  noarch  |  texlive  |  svn45975\-59\.amzn2023\.0\.2  | 
|  texlive\-cite\-doc  |  noarch  |  texlive  |  svn36428\.5\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-citeref  |  noarch  |  texlive  |  svn47407\-59\.amzn2023\.0\.2  | 
|  texlive\-cje  |  noarch  |  texlive  |  svn46721\-59\.amzn2023\.0\.2  | 
|  texlive\-cjhebrew  |  noarch  |  texlive  |  svn43444\-59\.amzn2023\.0\.2  | 
|  texlive\-cjhebrew\-doc  |  noarch  |  texlive  |  svn43444\-59\.amzn2023\.0\.2  | 
|  texlive\-cjk  |  noarch  |  texlive  |  svn36951\.4\.8\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-cjk\-doc  |  noarch  |  texlive  |  svn36951\.4\.8\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-cjk\-ko  |  noarch  |  texlive  |  svn58081\-59\.amzn2023\.0\.2  | 
|  texlive\-cjk\-ko\-doc  |  noarch  |  texlive  |  svn58081\-59\.amzn2023\.0\.2  | 
|  texlive\-cjkpunct  |  noarch  |  texlive  |  svn41119\-59\.amzn2023\.0\.2  | 
|  texlive\-cjkpunct\-doc  |  noarch  |  texlive  |  svn41119\-59\.amzn2023\.0\.2  | 
|  texlive\-clara  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-classics  |  noarch  |  texlive  |  svn53671\-59\.amzn2023\.0\.2  | 
|  texlive\-classics\-doc  |  noarch  |  texlive  |  svn53671\-59\.amzn2023\.0\.2  | 
|  texlive\-classicthesis  |  noarch  |  texlive  |  svn48041\-59\.amzn2023\.0\.2  | 
|  texlive\-classicthesis\-doc  |  noarch  |  texlive  |  svn48041\-59\.amzn2023\.0\.2  | 
|  texlive\-classpack  |  noarch  |  texlive  |  svn55218\-59\.amzn2023\.0\.2  | 
|  texlive\-classpack\-doc  |  noarch  |  texlive  |  svn55218\-59\.amzn2023\.0\.2  | 
|  texlive\-cleanthesis  |  noarch  |  texlive  |  svn51472\-59\.amzn2023\.0\.2  | 
|  texlive\-cleanthesis\-doc  |  noarch  |  texlive  |  svn51472\-59\.amzn2023\.0\.2  | 
|  texlive\-clearsans  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-clearsans\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-clefval  |  noarch  |  texlive  |  svn55985\-59\.amzn2023\.0\.2  | 
|  texlive\-clefval\-doc  |  noarch  |  texlive  |  svn55985\-59\.amzn2023\.0\.2  | 
|  texlive\-cleveref  |  noarch  |  texlive  |  svn47525\-59\.amzn2023\.0\.2  | 
|  texlive\-cleveref\-doc  |  noarch  |  texlive  |  svn47525\-59\.amzn2023\.0\.2  | 
|  texlive\-clipboard  |  noarch  |  texlive  |  svn47747\-59\.amzn2023\.0\.2  | 
|  texlive\-clipboard\-doc  |  noarch  |  texlive  |  svn47747\-59\.amzn2023\.0\.2  | 
|  texlive\-clock  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-clock\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cloze  |  noarch  |  texlive  |  svn55763\-59\.amzn2023\.0\.2  | 
|  texlive\-cloze\-doc  |  noarch  |  texlive  |  svn55763\-59\.amzn2023\.0\.2  | 
|  texlive\-clrdblpg  |  noarch  |  texlive  |  svn47511\-59\.amzn2023\.0\.2  | 
|  texlive\-clrscode  |  noarch  |  texlive  |  svn51136\-59\.amzn2023\.0\.2  | 
|  texlive\-clrscode3e  |  noarch  |  texlive  |  svn51137\-59\.amzn2023\.0\.2  | 
|  texlive\-clrscode3e\-doc  |  noarch  |  texlive  |  svn51137\-59\.amzn2023\.0\.2  | 
|  texlive\-clrscode\-doc  |  noarch  |  texlive  |  svn51136\-59\.amzn2023\.0\.2  | 
|  texlive\-clrstrip  |  noarch  |  texlive  |  svn53537\-59\.amzn2023\.0\.2  | 
|  texlive\-cm  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-cmap  |  noarch  |  texlive  |  svn57640\-59\.amzn2023\.0\.2  | 
|  texlive\-cmap\-doc  |  noarch  |  texlive  |  svn57640\-59\.amzn2023\.0\.2  | 
|  texlive\-cmarrows  |  noarch  |  texlive  |  svn24378\.v0\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-cmarrows\-doc  |  noarch  |  texlive  |  svn24378\.v0\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-cmathbb  |  noarch  |  texlive  |  svn56414\-59\.amzn2023\.0\.2  | 
|  texlive\-cmbright  |  noarch  |  texlive  |  svn21107\.8\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cmbright\-doc  |  noarch  |  texlive  |  svn21107\.8\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cmcyr  |  noarch  |  texlive  |  svn39273\-59\.amzn2023\.0\.2  | 
|  texlive\-cmcyr\-doc  |  noarch  |  texlive  |  svn39273\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-doc  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-cmdstring  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cmdstring\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cmdtrack  |  noarch  |  texlive  |  svn28910\-59\.amzn2023\.0\.2  | 
|  texlive\-cmdtrack\-doc  |  noarch  |  texlive  |  svn28910\-59\.amzn2023\.0\.2  | 
|  texlive\-cmexb  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-cmexb\-doc  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-cmextra  |  noarch  |  texlive  |  svn57866\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-lgc  |  noarch  |  texlive  |  svn28250\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-lgc\-doc  |  noarch  |  texlive  |  svn28250\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-cmll  |  noarch  |  texlive  |  svn17964\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmll\-doc  |  noarch  |  texlive  |  svn17964\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-mf\-extra\-bold  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cmpica  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmpica\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmpj  |  noarch  |  texlive  |  svn58506\-59\.amzn2023\.0\.2  | 
|  texlive\-cmpj\-doc  |  noarch  |  texlive  |  svn58506\-59\.amzn2023\.0\.2  | 
|  texlive\-cmsd  |  noarch  |  texlive  |  svn18787\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmsd\-doc  |  noarch  |  texlive  |  svn18787\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmsrb  |  noarch  |  texlive  |  svn54706\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-super  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-super\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cmtiup  |  noarch  |  texlive  |  svn39728\-59\.amzn2023\.0\.2  | 
|  texlive\-cmtiup\-doc  |  noarch  |  texlive  |  svn39728\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-unicode  |  noarch  |  texlive  |  svn58661\-59\.amzn2023\.0\.2  | 
|  texlive\-cm\-unicode\-doc  |  noarch  |  texlive  |  svn58661\-59\.amzn2023\.0\.2  | 
|  texlive\-cmupint  |  noarch  |  texlive  |  svn54735\-59\.amzn2023\.0\.2  | 
|  texlive\-cnbwp  |  noarch  |  texlive  |  svn32550\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cnbwp\-doc  |  noarch  |  texlive  |  svn32550\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cnltx  |  noarch  |  texlive  |  svn55265\-59\.amzn2023\.0\.2  | 
|  texlive\-cnltx\-doc  |  noarch  |  texlive  |  svn55265\-59\.amzn2023\.0\.2  | 
|  texlive\-cns  |  noarch  |  texlive  |  svn45677\-59\.amzn2023\.0\.2  | 
|  texlive\-cns\-doc  |  noarch  |  texlive  |  svn45677\-59\.amzn2023\.0\.2  | 
|  texlive\-cntformats  |  noarch  |  texlive  |  svn34668\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-cntformats\-doc  |  noarch  |  texlive  |  svn34668\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-cntperchap  |  noarch  |  texlive  |  svn37572\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-cntperchap\-doc  |  noarch  |  texlive  |  svn37572\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-cochineal  |  noarch  |  texlive  |  svn58717\-59\.amzn2023\.0\.2  | 
|  texlive\-cochineal\-doc  |  noarch  |  texlive  |  svn58717\-59\.amzn2023\.0\.2  | 
|  texlive\-codeanatomy  |  noarch  |  texlive  |  svn51627\-59\.amzn2023\.0\.2  | 
|  texlive\-codedoc  |  noarch  |  texlive  |  svn17630\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-codedoc\-doc  |  noarch  |  texlive  |  svn17630\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-codepage  |  noarch  |  texlive  |  svn51502\-59\.amzn2023\.0\.2  | 
|  texlive\-codepage\-doc  |  noarch  |  texlive  |  svn51502\-59\.amzn2023\.0\.2  | 
|  texlive\-codesection  |  noarch  |  texlive  |  svn34481\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-codesection\-doc  |  noarch  |  texlive  |  svn34481\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-codicefiscaleitaliano  |  noarch  |  texlive  |  svn29803\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-codicefiscaleitaliano\-doc  |  noarch  |  texlive  |  svn29803\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-coelacanth  |  noarch  |  texlive  |  svn54736\-59\.amzn2023\.0\.2  | 
|  texlive\-coffeestains  |  noarch  |  texlive  |  svn59115\-59\.amzn2023\.0\.2  | 
|  texlive\-collcell  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-collcell\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-collectbox  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-collectbox\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-basic  |  noarch  |  texlive  |  svn59159\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-bibtexextra  |  noarch  |  texlive  |  svn58437\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-binextra  |  noarch  |  texlive  |  svn56352\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-context  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-fontsextra  |  noarch  |  texlive  |  svn58253\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-fontsrecommended  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-fontutils  |  noarch  |  texlive  |  svn57089\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-formatsextra  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-games  |  noarch  |  texlive  |  svn58896\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-humanities  |  noarch  |  texlive  |  svn56575\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langarabic  |  noarch  |  texlive  |  svn59003\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langchinese  |  noarch  |  texlive  |  svn58965\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langcjk  |  noarch  |  texlive  |  svn54191\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langcyrillic  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langczechslovak  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langenglish  |  noarch  |  texlive  |  svn58290\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langeuropean  |  noarch  |  texlive  |  svn58626\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langfrench  |  noarch  |  texlive  |  svn57491\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langgerman  |  noarch  |  texlive  |  svn55706\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langgreek  |  noarch  |  texlive  |  svn54139\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langitalian  |  noarch  |  texlive  |  svn55129\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langjapanese  |  noarch  |  texlive  |  svn58754\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langkorean  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langother  |  noarch  |  texlive  |  svn57757\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langpolish  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langportuguese  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-langspanish  |  noarch  |  texlive  |  svn54141\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-latex  |  noarch  |  texlive  |  svn57048\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-latexextra  |  noarch  |  texlive  |  svn59009\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-latexrecommended  |  noarch  |  texlive  |  svn57862\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-luatex  |  noarch  |  texlive  |  svn58124\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-mathscience  |  noarch  |  texlive  |  svn57759\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-metapost  |  noarch  |  texlive  |  svn50293\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-music  |  noarch  |  texlive  |  svn57878\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-pictures  |  noarch  |  texlive  |  svn59115\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-plaingeneric  |  noarch  |  texlive  |  svn58874\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-pstricks  |  noarch  |  texlive  |  svn54455\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-publishers  |  noarch  |  texlive  |  svn59002\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-texworks  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collection\-xetex  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-collref  |  noarch  |  texlive  |  svn46358\-59\.amzn2023\.0\.2  | 
|  texlive\-collref\-doc  |  noarch  |  texlive  |  svn46358\-59\.amzn2023\.0\.2  | 
|  texlive\-colophon  |  noarch  |  texlive  |  svn47913\-59\.amzn2023\.0\.2  | 
|  texlive\-colordoc  |  noarch  |  texlive  |  svn18270\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colordoc\-doc  |  noarch  |  texlive  |  svn18270\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-color\-edits  |  noarch  |  texlive  |  svn56707\-59\.amzn2023\.0\.2  | 
|  texlive\-colorinfo  |  noarch  |  texlive  |  svn15878\.0\.3c\-59\.amzn2023\.0\.2  | 
|  texlive\-colorinfo\-doc  |  noarch  |  texlive  |  svn15878\.0\.3c\-59\.amzn2023\.0\.2  | 
|  texlive\-coloring  |  noarch  |  texlive  |  svn41042\-59\.amzn2023\.0\.2  | 
|  texlive\-coloring\-doc  |  noarch  |  texlive  |  svn41042\-59\.amzn2023\.0\.2  | 
|  texlive\-colorist  |  noarch  |  texlive  |  svn59316\-59\.amzn2023\.0\.2  | 
|  texlive\-colorprofiles  |  noarch  |  texlive  |  svn49086\-59\.amzn2023\.0\.2  | 
|  texlive\-colorsep  |  noarch  |  texlive  |  svn13293\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colorspace  |  noarch  |  texlive  |  svn50585\-59\.amzn2023\.0\.2  | 
|  texlive\-colorspace\-doc  |  noarch  |  texlive  |  svn50585\-59\.amzn2023\.0\.2  | 
|  texlive\-colortab  |  noarch  |  texlive  |  svn22155\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colortab\-doc  |  noarch  |  texlive  |  svn22155\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colortbl  |  noarch  |  texlive  |  svn53545\-59\.amzn2023\.0\.2  | 
|  texlive\-colortbl\-doc  |  noarch  |  texlive  |  svn49404\-59\.amzn2023\.0\.2  | 
|  texlive\-colorwav  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colorwav\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-colorweb  |  noarch  |  texlive  |  svn31490\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-colorweb\-doc  |  noarch  |  texlive  |  svn31490\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-colourchange  |  noarch  |  texlive  |  svn21741\.1\.22\-59\.amzn2023\.0\.2  | 
|  texlive\-colourchange\-doc  |  noarch  |  texlive  |  svn21741\.1\.22\-59\.amzn2023\.0\.2  | 
|  texlive\-combelow  |  noarch  |  texlive  |  svn18462\.0\.99f\-59\.amzn2023\.0\.2  | 
|  texlive\-combelow\-doc  |  noarch  |  texlive  |  svn18462\.0\.99f\-59\.amzn2023\.0\.2  | 
|  texlive\-combine  |  noarch  |  texlive  |  svn19361\.0\.7a\-59\.amzn2023\.0\.2  | 
|  texlive\-combinedgraphics  |  noarch  |  texlive  |  svn27198\.0\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-combinedgraphics\-doc  |  noarch  |  texlive  |  svn27198\.0\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-combine\-doc  |  noarch  |  texlive  |  svn19361\.0\.7a\-59\.amzn2023\.0\.2  | 
|  texlive\-combofont  |  noarch  |  texlive  |  svn51348\-59\.amzn2023\.0\.2  | 
|  texlive\-comfortaa  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-comfortaa\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-comicneue  |  noarch  |  texlive  |  svn54891\-59\.amzn2023\.0\.2  | 
|  texlive\-comicneue\-doc  |  noarch  |  texlive  |  svn54891\-59\.amzn2023\.0\.2  | 
|  texlive\-comma  |  noarch  |  texlive  |  svn18259\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-commado  |  noarch  |  texlive  |  svn38875\-59\.amzn2023\.0\.2  | 
|  texlive\-comma\-doc  |  noarch  |  texlive  |  svn18259\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-commado\-doc  |  noarch  |  texlive  |  svn38875\-59\.amzn2023\.0\.2  | 
|  texlive\-commath  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-commath\-doc  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-commedit  |  noarch  |  texlive  |  svn50116\-59\.amzn2023\.0\.2  | 
|  texlive\-comment  |  noarch  |  texlive  |  svn41927\-59\.amzn2023\.0\.2  | 
|  texlive\-comment\-doc  |  noarch  |  texlive  |  svn41927\-59\.amzn2023\.0\.2  | 
|  texlive\-compactbib  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-compare  |  noarch  |  texlive  |  svn54265\-59\.amzn2023\.0\.2  | 
|  texlive\-competences  |  noarch  |  texlive  |  svn47573\-59\.amzn2023\.0\.2  | 
|  texlive\-complexity  |  noarch  |  texlive  |  svn45322\-59\.amzn2023\.0\.2  | 
|  texlive\-complexity\-doc  |  noarch  |  texlive  |  svn45322\-59\.amzn2023\.0\.2  | 
|  texlive\-components\-of\-TeX\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-comprehensive\-doc  |  noarch  |  texlive  |  svn46270\-59\.amzn2023\.0\.2  | 
|  texlive\-computational\-complexity  |  noarch  |  texlive  |  svn44847\-59\.amzn2023\.0\.2  | 
|  texlive\-computational\-complexity\-doc  |  noarch  |  texlive  |  svn44847\-59\.amzn2023\.0\.2  | 
|  texlive\-concepts  |  noarch  |  texlive  |  svn29020\.0\.0\.5\_r1\-59\.amzn2023\.0\.2  | 
|  texlive\-concepts\-doc  |  noarch  |  texlive  |  svn29020\.0\.0\.5\_r1\-59\.amzn2023\.0\.2  | 
|  texlive\-concmath  |  noarch  |  texlive  |  svn17219\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concmath\-doc  |  noarch  |  texlive  |  svn17219\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concmath\-fonts  |  noarch  |  texlive  |  svn17218\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concmath\-fonts\-doc  |  noarch  |  texlive  |  svn17218\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concprog  |  noarch  |  texlive  |  svn18791\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concprog\-doc  |  noarch  |  texlive  |  svn18791\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-concrete  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-concrete\-doc  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-conditext  |  noarch  |  texlive  |  svn55387\-59\.amzn2023\.0\.2  | 
|  texlive\-confproc  |  noarch  |  texlive  |  svn29349\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-confproc\-doc  |  noarch  |  texlive  |  svn29349\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-constants  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-constants\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-conteq  |  noarch  |  texlive  |  svn37868\.0\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-conteq\-doc  |  noarch  |  texlive  |  svn37868\.0\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-account  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-account\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-algorithmic  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-animation  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-animation\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-annotation  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-annotation\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-bnf  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-bnf\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-chromato  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-chromato\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-cmscbf  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-cmttbf  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-construction\-plan  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-construction\-plan\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-cyrillicnumbers  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-cyrillicnumbers\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-degrade  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-degrade\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-fancybreak  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-fancybreak\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-filter  |  noarch  |  texlive  |  svn55718\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-filter\-doc  |  noarch  |  texlive  |  svn55718\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-french  |  noarch  |  texlive  |  svn54215\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-french\-doc  |  noarch  |  texlive  |  svn54215\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-fullpage  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-fullpage\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-gantt  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-gantt\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-gnuplot  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-gnuplot\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-handlecsv  |  noarch  |  texlive  |  svn51306\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-inifile  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-layout  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-letter  |  noarch  |  texlive  |  svn56073\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-letter\-doc  |  noarch  |  texlive  |  svn56073\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-lettrine  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-lettrine\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-mathsets  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-mathsets\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-notes\-zh\-cn  |  noarch  |  texlive  |  svn23171\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-notes\-zh\-cn\-doc  |  noarch  |  texlive  |  svn23171\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-rst  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-rst\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-ruby  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-ruby\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-simplefonts  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-simplefonts\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-simpleslides  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-simpleslides\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-title  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-title\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-transliterator  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-transliterator\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-typearea  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-typearea\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-typescripts  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-typescripts\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-vim  |  noarch  |  texlive  |  svn58082\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-vim\-doc  |  noarch  |  texlive  |  svn58082\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-visualcounter  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-context\-visualcounter\-doc  |  noarch  |  texlive  |  svn47085\-59\.amzn2023\.0\.2  | 
|  texlive\-continue  |  noarch  |  texlive  |  svn49449\-59\.amzn2023\.0\.2  | 
|  texlive\-continue\-doc  |  noarch  |  texlive  |  svn49449\-59\.amzn2023\.0\.2  | 
|  texlive\-contour  |  noarch  |  texlive  |  svn18950\.2\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-contour\-doc  |  noarch  |  texlive  |  svn18950\.2\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-contracard  |  noarch  |  texlive  |  svn50217\-59\.amzn2023\.0\.2  | 
|  texlive\-contracard\-doc  |  noarch  |  texlive  |  svn50217\-59\.amzn2023\.0\.2  | 
|  texlive\-conv\-xkv  |  noarch  |  texlive  |  svn43558\-59\.amzn2023\.0\.2  | 
|  texlive\-cooking  |  noarch  |  texlive  |  svn15878\.0\.9b\-59\.amzn2023\.0\.2  | 
|  texlive\-cooking\-doc  |  noarch  |  texlive  |  svn15878\.0\.9b\-59\.amzn2023\.0\.2  | 
|  texlive\-cookingsymbols  |  noarch  |  texlive  |  svn35929\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cookingsymbols\-doc  |  noarch  |  texlive  |  svn35929\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cooking\-units  |  noarch  |  texlive  |  svn53403\-59\.amzn2023\.0\.2  | 
|  texlive\-cool  |  noarch  |  texlive  |  svn15878\.1\.35\-59\.amzn2023\.0\.2  | 
|  texlive\-cool\-doc  |  noarch  |  texlive  |  svn15878\.1\.35\-59\.amzn2023\.0\.2  | 
|  texlive\-coollist  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-coollist\-doc  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-coolstr  |  noarch  |  texlive  |  svn15878\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-coolstr\-doc  |  noarch  |  texlive  |  svn15878\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-coolthms  |  noarch  |  texlive  |  svn29062\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-coolthms\-doc  |  noarch  |  texlive  |  svn29062\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cooltooltips  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cooltooltips\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-coordsys  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-coordsys\-doc  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-copyedit  |  noarch  |  texlive  |  svn37928\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-copyedit\-doc  |  noarch  |  texlive  |  svn37928\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-copyrightbox  |  noarch  |  texlive  |  svn24829\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-copyrightbox\-doc  |  noarch  |  texlive  |  svn24829\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cormorantgaramond  |  noarch  |  texlive  |  svn54696\-59\.amzn2023\.0\.2  | 
|  texlive\-correctmathalign  |  noarch  |  texlive  |  svn44131\-59\.amzn2023\.0\.2  | 
|  texlive\-coseoul  |  noarch  |  texlive  |  svn23862\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-coseoul\-doc  |  noarch  |  texlive  |  svn23862\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-countriesofeurope  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-countriesofeurope\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-counttexruns  |  noarch  |  texlive  |  svn27576\.1\.00a\-59\.amzn2023\.0\.2  | 
|  texlive\-counttexruns\-doc  |  noarch  |  texlive  |  svn27576\.1\.00a\-59\.amzn2023\.0\.2  | 
|  texlive\-courier  |  noarch  |  texlive  |  svn35058\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-courier\-scaled  |  noarch  |  texlive  |  svn24940\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-courier\-scaled\-doc  |  noarch  |  texlive  |  svn24940\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-courierten  |  noarch  |  texlive  |  svn55436\-59\.amzn2023\.0\.2  | 
|  texlive\-courseoutline  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-courseoutline\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-coursepaper  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-coursepaper\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-coverpage  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-coverpage\-doc  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-covington  |  noarch  |  texlive  |  svn58589\-59\.amzn2023\.0\.2  | 
|  texlive\-covington\-doc  |  noarch  |  texlive  |  svn58589\-59\.amzn2023\.0\.2  | 
|  texlive\-c\-pascal  |  noarch  |  texlive  |  svn18337\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-c\-pascal\-doc  |  noarch  |  texlive  |  svn18337\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cprotect  |  noarch  |  texlive  |  svn21209\.1\.0e\-59\.amzn2023\.0\.2  | 
|  texlive\-cprotect\-doc  |  noarch  |  texlive  |  svn21209\.1\.0e\-59\.amzn2023\.0\.2  | 
|  texlive\-cqubeamer  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cquthesis  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-cquthesis\-doc  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-crbox  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-crbox\-doc  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-crimson  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-crimson\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-crimsonpro  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-crop  |  noarch  |  texlive  |  svn55424\-59\.amzn2023\.0\.2  | 
|  texlive\-crop\-doc  |  noarch  |  texlive  |  svn55424\-59\.amzn2023\.0\.2  | 
|  texlive\-crossreference  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-crossreference\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-crossreftools  |  noarch  |  texlive  |  svn55879\-59\.amzn2023\.0\.2  | 
|  texlive\-crossword  |  noarch  |  texlive  |  svn55271\-59\.amzn2023\.0\.2  | 
|  texlive\-crossword\-doc  |  noarch  |  texlive  |  svn55271\-59\.amzn2023\.0\.2  | 
|  texlive\-crosswrd  |  noarch  |  texlive  |  svn16896\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-crosswrd\-doc  |  noarch  |  texlive  |  svn16896\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cryptocode  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-cryptocode\-doc  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-cryst  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cryst\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cs  |  noarch  |  texlive  |  svn41553\-59\.amzn2023\.0\.2  | 
|  texlive\-csbulletin  |  noarch  |  texlive  |  svn54433\-59\.amzn2023\.0\.2  | 
|  texlive\-csbulletin\-doc  |  noarch  |  texlive  |  svn54433\-59\.amzn2023\.0\.2  | 
|  texlive\-csquotes  |  noarch  |  texlive  |  svn57844\-59\.amzn2023\.0\.2  | 
|  texlive\-csquotes\-de\-doc  |  noarch  |  texlive  |  svn23371\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-csquotes\-doc  |  noarch  |  texlive  |  svn57844\-59\.amzn2023\.0\.2  | 
|  texlive\-css\-colors  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-cstex\-doc  |  noarch  |  texlive  |  svn53767\-59\.amzn2023\.0\.2  | 
|  texlive\-cstypo  |  noarch  |  texlive  |  svn41986\-59\.amzn2023\.0\.2  | 
|  texlive\-csvmerge  |  noarch  |  texlive  |  svn51857\-59\.amzn2023\.0\.2  | 
|  texlive\-csvsimple  |  noarch  |  texlive  |  svn51010\-59\.amzn2023\.0\.2  | 
|  texlive\-csvsimple\-doc  |  noarch  |  texlive  |  svn51010\-59\.amzn2023\.0\.2  | 
|  texlive\-ctable  |  noarch  |  texlive  |  svn38672\-59\.amzn2023\.0\.2  | 
|  texlive\-ctable\-doc  |  noarch  |  texlive  |  svn38672\-59\.amzn2023\.0\.2  | 
|  texlive\-ctablestack  |  noarch  |  texlive  |  svn38514\-59\.amzn2023\.0\.2  | 
|  texlive\-ctablestack\-doc  |  noarch  |  texlive  |  svn38514\-59\.amzn2023\.0\.2  | 
|  texlive\-ctan\_chk\-doc  |  noarch  |  texlive  |  svn36304\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ctex  |  noarch  |  texlive  |  svn58583\-59\.amzn2023\.0\.2  | 
|  texlive\-ctex\-doc  |  noarch  |  texlive  |  svn58583\-59\.amzn2023\.0\.2  | 
|  texlive\-ctex\-faq\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ctib  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ctib\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cuisine  |  noarch  |  texlive  |  svn34453\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-cuisine\-doc  |  noarch  |  texlive  |  svn34453\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-cuprum  |  noarch  |  texlive  |  svn49909\-59\.amzn2023\.0\.2  | 
|  texlive\-currency  |  noarch  |  texlive  |  svn48990\-59\.amzn2023\.0\.2  | 
|  texlive\-currfile  |  noarch  |  texlive  |  svn56478\-59\.amzn2023\.0\.2  | 
|  texlive\-currfile\-doc  |  noarch  |  texlive  |  svn56478\-59\.amzn2023\.0\.2  | 
|  texlive\-currvita  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-currvita\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cursolatex\-doc  |  noarch  |  texlive  |  svn24139\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-curve  |  noarch  |  texlive  |  svn20745\.1\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-curve2e  |  noarch  |  texlive  |  svn57402\-59\.amzn2023\.0\.2  | 
|  texlive\-curve2e\-doc  |  noarch  |  texlive  |  svn57402\-59\.amzn2023\.0\.2  | 
|  texlive\-curve\-doc  |  noarch  |  texlive  |  svn20745\.1\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-curves  |  noarch  |  texlive  |  svn45255\-59\.amzn2023\.0\.2  | 
|  texlive\-curves\-doc  |  noarch  |  texlive  |  svn45255\-59\.amzn2023\.0\.2  | 
|  texlive\-custom\-bib  |  noarch  |  texlive  |  svn24729\.4\.33\-59\.amzn2023\.0\.2  | 
|  texlive\-custom\-bib\-doc  |  noarch  |  texlive  |  svn24729\.4\.33\-59\.amzn2023\.0\.2  | 
|  texlive\-cutwin  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cutwin\-doc  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cv  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cv4tw  |  noarch  |  texlive  |  svn34577\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cv4tw\-doc  |  noarch  |  texlive  |  svn34577\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-cv\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cweb\-latex  |  noarch  |  texlive  |  svn28878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cweb\-latex\-doc  |  noarch  |  texlive  |  svn28878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-cweb\-old  |  noarch  |  texlive  |  svn49271\-59\.amzn2023\.0\.2  | 
|  texlive\-cyber  |  noarch  |  texlive  |  svn46776\-59\.amzn2023\.0\.2  | 
|  texlive\-cybercic  |  noarch  |  texlive  |  svn37659\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cybercic\-doc  |  noarch  |  texlive  |  svn37659\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-cyber\-doc  |  noarch  |  texlive  |  svn46776\-59\.amzn2023\.0\.2  | 
|  texlive\-cyklop  |  noarch  |  texlive  |  svn18651\.0\.915\-59\.amzn2023\.0\.2  | 
|  texlive\-cyklop\-doc  |  noarch  |  texlive  |  svn18651\.0\.915\-59\.amzn2023\.0\.2  | 
|  texlive\-cyrplain  |  noarch  |  texlive  |  svn45692\-59\.amzn2023\.0\.2  | 
|  texlive\-dad  |  noarch  |  texlive  |  svn54191\-59\.amzn2023\.0\.2  | 
|  texlive\-dad\-doc  |  noarch  |  texlive  |  svn54191\-59\.amzn2023\.0\.2  | 
|  texlive\-dancers  |  noarch  |  texlive  |  svn13293\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dantelogo  |  noarch  |  texlive  |  svn38599\-59\.amzn2023\.0\.2  | 
|  texlive\-dantelogo\-doc  |  noarch  |  texlive  |  svn38599\-59\.amzn2023\.0\.2  | 
|  texlive\-dashbox  |  noarch  |  texlive  |  svn23425\.1\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-dashbox\-doc  |  noarch  |  texlive  |  svn23425\.1\.14\-59\.amzn2023\.0\.2  | 
|  texlive\-dashrule  |  noarch  |  texlive  |  svn29579\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-dashrule\-doc  |  noarch  |  texlive  |  svn29579\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-dashundergaps  |  noarch  |  texlive  |  svn58150\-59\.amzn2023\.0\.2  | 
|  texlive\-dashundergaps\-doc  |  noarch  |  texlive  |  svn58150\-59\.amzn2023\.0\.2  | 
|  texlive\-dataref  |  noarch  |  texlive  |  svn42883\-59\.amzn2023\.0\.2  | 
|  texlive\-dataref\-doc  |  noarch  |  texlive  |  svn42883\-59\.amzn2023\.0\.2  | 
|  texlive\-datatool  |  noarch  |  texlive  |  svn52663\-59\.amzn2023\.0\.2  | 
|  texlive\-datatool\-doc  |  noarch  |  texlive  |  svn52663\-59\.amzn2023\.0\.2  | 
|  texlive\-datax  |  noarch  |  texlive  |  svn57033\-59\.amzn2023\.0\.2  | 
|  texlive\-dateiliste  |  noarch  |  texlive  |  svn27974\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-dateiliste\-doc  |  noarch  |  texlive  |  svn27974\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-datenumber  |  noarch  |  texlive  |  svn18951\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-datenumber\-doc  |  noarch  |  texlive  |  svn18951\.0\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime  |  noarch  |  texlive  |  svn36650\.2\.60\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2  |  noarch  |  texlive  |  svn58590\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-bahasai  |  noarch  |  texlive  |  svn46287\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-bahasai\-doc  |  noarch  |  texlive  |  svn46287\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-basque  |  noarch  |  texlive  |  svn47064\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-basque\-doc  |  noarch  |  texlive  |  svn47064\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-breton  |  noarch  |  texlive  |  svn52647\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-breton\-doc  |  noarch  |  texlive  |  svn52647\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-bulgarian  |  noarch  |  texlive  |  svn47031\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-bulgarian\-doc  |  noarch  |  texlive  |  svn47031\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-catalan  |  noarch  |  texlive  |  svn47032\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-catalan\-doc  |  noarch  |  texlive  |  svn47032\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-croatian  |  noarch  |  texlive  |  svn36682\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-croatian\-doc  |  noarch  |  texlive  |  svn36682\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-czech  |  noarch  |  texlive  |  svn47033\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-czech\-doc  |  noarch  |  texlive  |  svn47033\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-danish  |  noarch  |  texlive  |  svn47034\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-danish\-doc  |  noarch  |  texlive  |  svn47034\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-doc  |  noarch  |  texlive  |  svn58590\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-dutch  |  noarch  |  texlive  |  svn47355\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-dutch\-doc  |  noarch  |  texlive  |  svn47355\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-en\-fulltext  |  noarch  |  texlive  |  svn36705\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-en\-fulltext\-doc  |  noarch  |  texlive  |  svn36705\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-english  |  noarch  |  texlive  |  svn52479\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-english\-doc  |  noarch  |  texlive  |  svn52479\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-esperanto  |  noarch  |  texlive  |  svn47356\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-esperanto\-doc  |  noarch  |  texlive  |  svn47356\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-estonian  |  noarch  |  texlive  |  svn47565\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-estonian\-doc  |  noarch  |  texlive  |  svn47565\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-finnish  |  noarch  |  texlive  |  svn47047\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-finnish\-doc  |  noarch  |  texlive  |  svn47047\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-french  |  noarch  |  texlive  |  svn56393\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-french\-doc  |  noarch  |  texlive  |  svn56393\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-galician  |  noarch  |  texlive  |  svn47631\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-galician\-doc  |  noarch  |  texlive  |  svn47631\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-german  |  noarch  |  texlive  |  svn53125\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-german\-doc  |  noarch  |  texlive  |  svn53125\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-greek  |  noarch  |  texlive  |  svn47533\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-greek\-doc  |  noarch  |  texlive  |  svn47533\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-hebrew  |  noarch  |  texlive  |  svn47534\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-hebrew\-doc  |  noarch  |  texlive  |  svn47534\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-icelandic  |  noarch  |  texlive  |  svn47501\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-icelandic\-doc  |  noarch  |  texlive  |  svn47501\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-irish  |  noarch  |  texlive  |  svn47632\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-irish\-doc  |  noarch  |  texlive  |  svn47632\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-italian  |  noarch  |  texlive  |  svn37146\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-italian\-doc  |  noarch  |  texlive  |  svn37146\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-it\-fulltext  |  noarch  |  texlive  |  svn54779\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-it\-fulltext\-doc  |  noarch  |  texlive  |  svn54779\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-latin  |  noarch  |  texlive  |  svn47748\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-latin\-doc  |  noarch  |  texlive  |  svn47748\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-lsorbian  |  noarch  |  texlive  |  svn47749\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-lsorbian\-doc  |  noarch  |  texlive  |  svn47749\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-magyar  |  noarch  |  texlive  |  svn48266\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-magyar\-doc  |  noarch  |  texlive  |  svn48266\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-norsk  |  noarch  |  texlive  |  svn48267\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-norsk\-doc  |  noarch  |  texlive  |  svn48267\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-polish  |  noarch  |  texlive  |  svn48456\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-polish\-doc  |  noarch  |  texlive  |  svn48456\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-portuges  |  noarch  |  texlive  |  svn48457\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-portuges\-doc  |  noarch  |  texlive  |  svn48457\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-romanian  |  noarch  |  texlive  |  svn56394\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-romanian\-doc  |  noarch  |  texlive  |  svn56394\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-russian  |  noarch  |  texlive  |  svn49345\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-russian\-doc  |  noarch  |  texlive  |  svn49345\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-samin  |  noarch  |  texlive  |  svn49346\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-samin\-doc  |  noarch  |  texlive  |  svn49346\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-scottish  |  noarch  |  texlive  |  svn52101\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-scottish\-doc  |  noarch  |  texlive  |  svn52101\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-serbian  |  noarch  |  texlive  |  svn52893\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-serbian\-doc  |  noarch  |  texlive  |  svn52893\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-slovak  |  noarch  |  texlive  |  svn52281\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-slovak\-doc  |  noarch  |  texlive  |  svn52281\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-slovene  |  noarch  |  texlive  |  svn52282\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-slovene\-doc  |  noarch  |  texlive  |  svn52282\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-spanish  |  noarch  |  texlive  |  svn45785\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-spanish\-doc  |  noarch  |  texlive  |  svn45785\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-swedish  |  noarch  |  texlive  |  svn36700\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-swedish\-doc  |  noarch  |  texlive  |  svn36700\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-turkish  |  noarch  |  texlive  |  svn52331\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-turkish\-doc  |  noarch  |  texlive  |  svn52331\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-ukrainian  |  noarch  |  texlive  |  svn47552\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-ukrainian\-doc  |  noarch  |  texlive  |  svn47552\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-usorbian  |  noarch  |  texlive  |  svn52375\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-usorbian\-doc  |  noarch  |  texlive  |  svn52375\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-welsh  |  noarch  |  texlive  |  svn52553\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime2\-welsh\-doc  |  noarch  |  texlive  |  svn52553\-59\.amzn2023\.0\.2  | 
|  texlive\-datetime\-doc  |  noarch  |  texlive  |  svn36650\.2\.60\-59\.amzn2023\.0\.2  | 
|  texlive\-dblfloatfix  |  noarch  |  texlive  |  svn28983\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-dblfloatfix\-doc  |  noarch  |  texlive  |  svn28983\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-dccpaper  |  noarch  |  texlive  |  svn57522\-59\.amzn2023\.0\.2  | 
|  texlive\-dccpaper\-doc  |  noarch  |  texlive  |  svn57522\-59\.amzn2023\.0\.2  | 
|  texlive\-dcpic  |  noarch  |  texlive  |  svn30206\.5\.0\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dcpic\-doc  |  noarch  |  texlive  |  svn30206\.5\.0\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ddphonism  |  noarch  |  texlive  |  svn52009\-59\.amzn2023\.0\.2  | 
|  texlive\-decimal  |  noarch  |  texlive  |  svn23374\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-decimal\-doc  |  noarch  |  texlive  |  svn23374\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-decision\-table  |  noarch  |  texlive  |  svn57094\-59\.amzn2023\.0\.2  | 
|  texlive\-decorule  |  noarch  |  texlive  |  svn55230\-59\.amzn2023\.0\.2  | 
|  texlive\-decorule\-doc  |  noarch  |  texlive  |  svn55230\-59\.amzn2023\.0\.2  | 
|  texlive\-dehyph  |  noarch  |  texlive  |  svn48599\-59\.amzn2023\.0\.2  | 
|  texlive\-dehyph\-exptl  |  noarch  |  texlive  |  svn58212\-59\.amzn2023\.0\.2  | 
|  texlive\-dehyph\-exptl\-doc  |  noarch  |  texlive  |  svn58212\-59\.amzn2023\.0\.2  | 
|  texlive\-dejavu  |  noarch  |  texlive  |  svn31771\.2\.34\-59\.amzn2023\.0\.2  | 
|  texlive\-dejavu\-doc  |  noarch  |  texlive  |  svn31771\.2\.34\-59\.amzn2023\.0\.2  | 
|  texlive\-dejavu\-otf  |  noarch  |  texlive  |  svn45991\-59\.amzn2023\.0\.2  | 
|  texlive\-delim  |  noarch  |  texlive  |  svn23974\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-delim\-doc  |  noarch  |  texlive  |  svn23974\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-delimseasy  |  noarch  |  texlive  |  svn39589\-59\.amzn2023\.0\.2  | 
|  texlive\-delimseasy\-doc  |  noarch  |  texlive  |  svn39589\-59\.amzn2023\.0\.2  | 
|  texlive\-delimset  |  noarch  |  texlive  |  svn49544\-59\.amzn2023\.0\.2  | 
|  texlive\-delimtxt  |  noarch  |  texlive  |  svn16549\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-delimtxt\-doc  |  noarch  |  texlive  |  svn16549\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-denisbdoc  |  noarch  |  texlive  |  svn56664\-59\.amzn2023\.0\.2  | 
|  texlive\-denisbdoc\-doc  |  noarch  |  texlive  |  svn56664\-59\.amzn2023\.0\.2  | 
|  texlive\-derivative  |  noarch  |  texlive  |  svn55890\-59\.amzn2023\.0\.2  | 
|  texlive\-dhua  |  noarch  |  texlive  |  svn24035\.0\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-dhua\-doc  |  noarch  |  texlive  |  svn24035\.0\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-diabetes\-logbook  |  noarch  |  texlive  |  svn54810\-59\.amzn2023\.0\.2  | 
|  texlive\-diagbox  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-diagbox\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-diagmac2  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-diagmac2\-doc  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-diagnose  |  noarch  |  texlive  |  svn19387\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-diagnose\-doc  |  noarch  |  texlive  |  svn19387\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-dialogl  |  noarch  |  texlive  |  svn28946\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dialogl\-doc  |  noarch  |  texlive  |  svn28946\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dice  |  noarch  |  texlive  |  svn28501\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dice\-doc  |  noarch  |  texlive  |  svn28501\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dichokey  |  noarch  |  texlive  |  svn17192\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dichokey\-doc  |  noarch  |  texlive  |  svn17192\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dickimaw\-doc  |  noarch  |  texlive  |  svn32925\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dictsym  |  noarch  |  texlive  |  svn20031\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dictsym\-doc  |  noarch  |  texlive  |  svn20031\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-diffcoeff  |  noarch  |  texlive  |  svn53244\-59\.amzn2023\.0\.2  | 
|  texlive\-digiconfigs  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-digiconfigs\-doc  |  noarch  |  texlive  |  svn15878\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-dijkstra  |  noarch  |  texlive  |  svn55661\-59\.amzn2023\.0\.2  | 
|  texlive\-dimnum  |  noarch  |  texlive  |  svn58774\-59\.amzn2023\.0\.2  | 
|  texlive\-din1505  |  noarch  |  texlive  |  svn19441\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-din1505\-doc  |  noarch  |  texlive  |  svn19441\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dinat  |  noarch  |  texlive  |  svn15878\.2\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-dinat\-doc  |  noarch  |  texlive  |  svn15878\.2\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-dinbrief  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dinbrief\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dingbat  |  noarch  |  texlive  |  svn27918\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dingbat\-doc  |  noarch  |  texlive  |  svn27918\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-directory  |  noarch  |  texlive  |  svn15878\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-directory\-doc  |  noarch  |  texlive  |  svn15878\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-dirtree  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-dirtree\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-dirtytalk  |  noarch  |  texlive  |  svn20520\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dirtytalk\-doc  |  noarch  |  texlive  |  svn20520\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-disser  |  noarch  |  texlive  |  svn43417\-59\.amzn2023\.0\.2  | 
|  texlive\-disser\-doc  |  noarch  |  texlive  |  svn43417\-59\.amzn2023\.0\.2  | 
|  texlive\-ditaa  |  noarch  |  texlive  |  svn48932\-59\.amzn2023\.0\.2  | 
|  texlive\-dithesis  |  noarch  |  texlive  |  svn34295\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-dithesis\-doc  |  noarch  |  texlive  |  svn34295\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-dk\-bib  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-dk\-bib\-doc  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-dlfltxb  |  noarch  |  texlive  |  svn17337\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dlfltxb\-doc  |  noarch  |  texlive  |  svn17337\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dnaseq  |  noarch  |  texlive  |  svn17194\.0\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-dnaseq\-doc  |  noarch  |  texlive  |  svn17194\.0\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-dnp  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-docbytex  |  noarch  |  texlive  |  svn34294\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-docbytex\-doc  |  noarch  |  texlive  |  svn34294\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-doclicense  |  noarch  |  texlive  |  svn58350\-59\.amzn2023\.0\.2  | 
|  texlive\-doclicense\-doc  |  noarch  |  texlive  |  svn58350\-59\.amzn2023\.0\.2  | 
|  texlive\-docmfp  |  noarch  |  texlive  |  svn15878\.1\.2d\-59\.amzn2023\.0\.2  | 
|  texlive\-docmfp\-doc  |  noarch  |  texlive  |  svn15878\.1\.2d\-59\.amzn2023\.0\.2  | 
|  texlive\-docmute  |  noarch  |  texlive  |  svn25741\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-docmute\-doc  |  noarch  |  texlive  |  svn25741\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-doc\-pictex\-doc  |  noarch  |  texlive  |  svn24927\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-docsurvey\-doc  |  noarch  |  texlive  |  svn48931\-59\.amzn2023\.0\.2  | 
|  texlive\-doctools  |  noarch  |  texlive  |  svn34474\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-doctools\-doc  |  noarch  |  texlive  |  svn34474\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-documentation  |  noarch  |  texlive  |  svn34521\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-documentation\-doc  |  noarch  |  texlive  |  svn34521\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-docutils  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-doi  |  noarch  |  texlive  |  svn48634\-59\.amzn2023\.0\.2  | 
|  texlive\-doi\-doc  |  noarch  |  texlive  |  svn48634\-59\.amzn2023\.0\.2  | 
|  texlive\-doipubmed  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-doipubmed\-doc  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-domitian  |  noarch  |  texlive  |  svn55286\-59\.amzn2023\.0\.2  | 
|  texlive\-dot2texi  |  noarch  |  texlive  |  svn26237\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dot2texi\-doc  |  noarch  |  texlive  |  svn26237\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dotarrow  |  noarch  |  texlive  |  svn15878\.0\.01a\-59\.amzn2023\.0\.2  | 
|  texlive\-dotarrow\-doc  |  noarch  |  texlive  |  svn15878\.0\.01a\-59\.amzn2023\.0\.2  | 
|  texlive\-dotlessi  |  noarch  |  texlive  |  svn51476\-59\.amzn2023\.0\.2  | 
|  texlive\-dotseqn  |  noarch  |  texlive  |  svn17195\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-dotseqn\-doc  |  noarch  |  texlive  |  svn17195\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-dottex  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-dottex\-doc  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-doublestroke  |  noarch  |  texlive  |  svn15878\.1\.111\-59\.amzn2023\.0\.2  | 
|  texlive\-doublestroke\-doc  |  noarch  |  texlive  |  svn15878\.1\.111\-59\.amzn2023\.0\.2  | 
|  texlive\-doulossil  |  noarch  |  texlive  |  svn56407\-59\.amzn2023\.0\.2  | 
|  texlive\-dowith  |  noarch  |  texlive  |  svn38860\-59\.amzn2023\.0\.2  | 
|  texlive\-dowith\-doc  |  noarch  |  texlive  |  svn38860\-59\.amzn2023\.0\.2  | 
|  texlive\-download  |  noarch  |  texlive  |  svn52257\-59\.amzn2023\.0\.2  | 
|  texlive\-download\-doc  |  noarch  |  texlive  |  svn52257\-59\.amzn2023\.0\.2  | 
|  texlive\-dox  |  noarch  |  texlive  |  svn46011\-59\.amzn2023\.0\.2  | 
|  texlive\-dox\-doc  |  noarch  |  texlive  |  svn46011\-59\.amzn2023\.0\.2  | 
|  texlive\-dozenal  |  noarch  |  texlive  |  svn47680\-59\.amzn2023\.0\.2  | 
|  texlive\-dozenal\-doc  |  noarch  |  texlive  |  svn47680\-59\.amzn2023\.0\.2  | 
|  texlive\-dpcircling  |  noarch  |  texlive  |  svn54994\-59\.amzn2023\.0\.2  | 
|  texlive\-dpfloat  |  noarch  |  texlive  |  svn17196\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dpfloat\-doc  |  noarch  |  texlive  |  svn17196\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dprogress  |  noarch  |  texlive  |  svn15878\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-dprogress\-doc  |  noarch  |  texlive  |  svn15878\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-drac  |  noarch  |  texlive  |  svn15878\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-drac\-doc  |  noarch  |  texlive  |  svn15878\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-draftcopy  |  noarch  |  texlive  |  svn15878\.2\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-draftcopy\-doc  |  noarch  |  texlive  |  svn15878\.2\.16\-59\.amzn2023\.0\.2  | 
|  texlive\-draftfigure  |  noarch  |  texlive  |  svn44854\-59\.amzn2023\.0\.2  | 
|  texlive\-draftwatermark  |  noarch  |  texlive  |  svn57099\-59\.amzn2023\.0\.2  | 
|  texlive\-draftwatermark\-doc  |  noarch  |  texlive  |  svn57099\-59\.amzn2023\.0\.2  | 
|  texlive\-dramatist  |  noarch  |  texlive  |  svn35866\.1\.2e\-59\.amzn2023\.0\.2  | 
|  texlive\-dramatist\-doc  |  noarch  |  texlive  |  svn35866\.1\.2e\-59\.amzn2023\.0\.2  | 
|  texlive\-dratex  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dratex\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-drawmatrix  |  noarch  |  texlive  |  svn44471\-59\.amzn2023\.0\.2  | 
|  texlive\-drawmatrix\-doc  |  noarch  |  texlive  |  svn44471\-59\.amzn2023\.0\.2  | 
|  texlive\-drawstack  |  noarch  |  texlive  |  svn28582\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-drawstack\-doc  |  noarch  |  texlive  |  svn28582\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-drm  |  noarch  |  texlive  |  svn38157\.4\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-drm\-doc  |  noarch  |  texlive  |  svn38157\.4\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-droid  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-droid\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-droit\-fr  |  noarch  |  texlive  |  svn39802\-59\.amzn2023\.0\.2  | 
|  texlive\-droit\-fr\-doc  |  noarch  |  texlive  |  svn39802\-59\.amzn2023\.0\.2  | 
|  texlive\-drs  |  noarch  |  texlive  |  svn19232\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-drs\-doc  |  noarch  |  texlive  |  svn19232\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-drv  |  noarch  |  texlive  |  svn29349\.0\.97\-59\.amzn2023\.0\.2  | 
|  texlive\-drv\-doc  |  noarch  |  texlive  |  svn29349\.0\.97\-59\.amzn2023\.0\.2  | 
|  texlive\-dsptricks  |  noarch  |  texlive  |  svn34724\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dsptricks\-doc  |  noarch  |  texlive  |  svn34724\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dsserif  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-dtk  |  noarch  |  texlive  |  svn56696\-59\.amzn2023\.0\.2  | 
|  texlive\-dtk\-doc  |  noarch  |  texlive  |  svn56696\-59\.amzn2023\.0\.2  | 
|  texlive\-dtxdescribe  |  noarch  |  texlive  |  svn51652\-59\.amzn2023\.0\.2  | 
|  texlive\-dtxgallery\-doc  |  noarch  |  texlive  |  svn49504\-59\.amzn2023\.0\.2  | 
|  texlive\-dtxtut\-doc  |  noarch  |  texlive  |  svn38375\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-ducksay  |  noarch  |  texlive  |  svn56800\-59\.amzn2023\.0\.2  | 
|  texlive\-duckuments  |  noarch  |  texlive  |  svn52271\-59\.amzn2023\.0\.2  | 
|  texlive\-duerer  |  noarch  |  texlive  |  svn20741\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-duerer\-doc  |  noarch  |  texlive  |  svn20741\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-duerer\-latex  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-duerer\-latex\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-duotenzor  |  noarch  |  texlive  |  svn18728\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-duotenzor\-doc  |  noarch  |  texlive  |  svn18728\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-dutchcal  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-dutchcal\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-dvdcoll  |  noarch  |  texlive  |  svn15878\.v1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-dvdcoll\-doc  |  noarch  |  texlive  |  svn15878\.v1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-dvgloss  |  noarch  |  texlive  |  svn29103\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-dvgloss\-doc  |  noarch  |  texlive  |  svn29103\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-dviincl  |  noarch  |  texlive  |  svn29349\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-dviincl\-doc  |  noarch  |  texlive  |  svn29349\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-dvipsconfig  |  noarch  |  texlive  |  svn13293\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-dynamicnumber  |  noarch  |  texlive  |  svn38726\-59\.amzn2023\.0\.2  | 
|  texlive\-dynamicnumber\-doc  |  noarch  |  texlive  |  svn38726\-59\.amzn2023\.0\.2  | 
|  texlive\-dynblocks  |  noarch  |  texlive  |  svn35193\.0\.2b\-59\.amzn2023\.0\.2  | 
|  texlive\-dynblocks\-doc  |  noarch  |  texlive  |  svn35193\.0\.2b\-59\.amzn2023\.0\.2  | 
|  texlive\-dynkin\-diagrams  |  noarch  |  texlive  |  svn58758\-59\.amzn2023\.0\.2  | 
|  texlive\-dyntree  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-dyntree\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ean  |  noarch  |  texlive  |  svn20851\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ean13isbn  |  noarch  |  texlive  |  svn57514\-59\.amzn2023\.0\.2  | 
|  texlive\-ean13isbn\-doc  |  noarch  |  texlive  |  svn57514\-59\.amzn2023\.0\.2  | 
|  texlive\-ean\-doc  |  noarch  |  texlive  |  svn20851\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-easy  |  noarch  |  texlive  |  svn19440\.0\.99\-59\.amzn2023\.0\.2  | 
|  texlive\-easybook  |  noarch  |  texlive  |  svn59306\-59\.amzn2023\.0\.2  | 
|  texlive\-easy\-doc  |  noarch  |  texlive  |  svn19440\.0\.99\-59\.amzn2023\.0\.2  | 
|  texlive\-easyfig  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-easyfig\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-easyfloats  |  noarch  |  texlive  |  svn57204\-59\.amzn2023\.0\.2  | 
|  texlive\-easyformat  |  noarch  |  texlive  |  svn44543\-59\.amzn2023\.0\.2  | 
|  texlive\-easylist  |  noarch  |  texlive  |  svn32661\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-easylist\-doc  |  noarch  |  texlive  |  svn32661\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-easyreview  |  noarch  |  texlive  |  svn38352\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-easyreview\-doc  |  noarch  |  texlive  |  svn38352\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-easy\-todo  |  noarch  |  texlive  |  svn32677\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-easy\-todo\-doc  |  noarch  |  texlive  |  svn32677\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ebezier  |  noarch  |  texlive  |  svn15878\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ebezier\-doc  |  noarch  |  texlive  |  svn15878\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ebgaramond  |  noarch  |  texlive  |  svn54721\-59\.amzn2023\.0\.2  | 
|  texlive\-ebgaramond\-doc  |  noarch  |  texlive  |  svn54721\-59\.amzn2023\.0\.2  | 
|  texlive\-ebgaramond\-maths  |  noarch  |  texlive  |  svn52168\-59\.amzn2023\.0\.2  | 
|  texlive\-ebgaramond\-maths\-doc  |  noarch  |  texlive  |  svn52168\-59\.amzn2023\.0\.2  | 
|  texlive\-ebook  |  noarch  |  texlive  |  svn29466\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ebook\-doc  |  noarch  |  texlive  |  svn29466\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ebproof  |  noarch  |  texlive  |  svn57544\-59\.amzn2023\.0\.2  | 
|  texlive\-ebproof\-doc  |  noarch  |  texlive  |  svn57544\-59\.amzn2023\.0\.2  | 
|  texlive\-ebsthesis  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ebsthesis\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ec  |  noarch  |  texlive  |  svn25033\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ecc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ecc\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ecclesiastic  |  noarch  |  texlive  |  svn38172\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ecclesiastic\-doc  |  noarch  |  texlive  |  svn38172\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ec\-doc  |  noarch  |  texlive  |  svn25033\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ecgdraw  |  noarch  |  texlive  |  svn41617\-59\.amzn2023\.0\.2  | 
|  texlive\-ecltree  |  noarch  |  texlive  |  svn15878\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-ecltree\-doc  |  noarch  |  texlive  |  svn15878\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-eco  |  noarch  |  texlive  |  svn29349\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ecobiblatex  |  noarch  |  texlive  |  svn39233\-59\.amzn2023\.0\.2  | 
|  texlive\-ecobiblatex\-doc  |  noarch  |  texlive  |  svn39233\-59\.amzn2023\.0\.2  | 
|  texlive\-eco\-doc  |  noarch  |  texlive  |  svn29349\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-econ\-bst  |  noarch  |  texlive  |  svn54191\-59\.amzn2023\.0\.2  | 
|  texlive\-econlipsum  |  noarch  |  texlive  |  svn58390\-59\.amzn2023\.0\.2  | 
|  texlive\-econometrics  |  noarch  |  texlive  |  svn39396\-59\.amzn2023\.0\.2  | 
|  texlive\-econometrics\-doc  |  noarch  |  texlive  |  svn39396\-59\.amzn2023\.0\.2  | 
|  texlive\-economic  |  noarch  |  texlive  |  svn32639\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-economic\-doc  |  noarch  |  texlive  |  svn32639\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ecothesis  |  noarch  |  texlive  |  svn48007\-59\.amzn2023\.0\.2  | 
|  texlive\-ecv  |  noarch  |  texlive  |  svn24928\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ecv\-doc  |  noarch  |  texlive  |  svn24928\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-eczar  |  noarch  |  texlive  |  svn57716\-59\.amzn2023\.0\.2  | 
|  texlive\-ed  |  noarch  |  texlive  |  svn25231\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-ed\-doc  |  noarch  |  texlive  |  svn25231\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-edfnotes  |  noarch  |  texlive  |  svn21540\.0\.6b\-59\.amzn2023\.0\.2  | 
|  texlive\-edfnotes\-doc  |  noarch  |  texlive  |  svn21540\.0\.6b\-59\.amzn2023\.0\.2  | 
|  texlive\-edichokey  |  noarch  |  texlive  |  svn56223\-59\.amzn2023\.0\.2  | 
|  texlive\-edmac  |  noarch  |  texlive  |  svn15878\.3\.17\-59\.amzn2023\.0\.2  | 
|  texlive\-edmac\-doc  |  noarch  |  texlive  |  svn15878\.3\.17\-59\.amzn2023\.0\.2  | 
|  texlive\-edmargin  |  noarch  |  texlive  |  svn27599\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-edmargin\-doc  |  noarch  |  texlive  |  svn27599\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-ednotes  |  noarch  |  texlive  |  svn35829\.1\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-ednotes\-doc  |  noarch  |  texlive  |  svn35829\.1\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-eemeir  |  noarch  |  texlive  |  svn15878\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-eemeir\-doc  |  noarch  |  texlive  |  svn15878\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-eepic  |  noarch  |  texlive  |  svn15878\.1\.1e\-59\.amzn2023\.0\.2  | 
|  texlive\-eepic\-doc  |  noarch  |  texlive  |  svn15878\.1\.1e\-59\.amzn2023\.0\.2  | 
|  texlive\-efbox  |  noarch  |  texlive  |  svn33236\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-efbox\-doc  |  noarch  |  texlive  |  svn33236\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-e\-french  |  noarch  |  texlive  |  svn52027\-59\.amzn2023\.0\.2  | 
|  texlive\-e\-french\-doc  |  noarch  |  texlive  |  svn52027\-59\.amzn2023\.0\.2  | 
|  texlive\-egameps  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-egameps\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-egplot  |  noarch  |  texlive  |  svn20617\.1\.02a\-59\.amzn2023\.0\.2  | 
|  texlive\-egplot\-doc  |  noarch  |  texlive  |  svn20617\.1\.02a\-59\.amzn2023\.0\.2  | 
|  texlive\-ehhline  |  noarch  |  texlive  |  svn54676\-59\.amzn2023\.0\.2  | 
|  texlive\-eiad  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eiad\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eiad\-ltx  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eiad\-ltx\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eijkhout  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-einfart  |  noarch  |  texlive  |  svn59321\-59\.amzn2023\.0\.2  | 
|  texlive\-ejpecp  |  noarch  |  texlive  |  svn56728\-59\.amzn2023\.0\.2  | 
|  texlive\-ejpecp\-doc  |  noarch  |  texlive  |  svn56728\-59\.amzn2023\.0\.2  | 
|  texlive\-ekaia  |  noarch  |  texlive  |  svn49594\-59\.amzn2023\.0\.2  | 
|  texlive\-ekaia\-doc  |  noarch  |  texlive  |  svn49594\-59\.amzn2023\.0\.2  | 
|  texlive\-ekdosis  |  noarch  |  texlive  |  svn58721\-59\.amzn2023\.0\.2  | 
|  texlive\-ektype\-tanka  |  noarch  |  texlive  |  svn56070\-59\.amzn2023\.0\.2  | 
|  texlive\-elbioimp  |  noarch  |  texlive  |  svn21758\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-elbioimp\-doc  |  noarch  |  texlive  |  svn21758\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-electrum  |  noarch  |  texlive  |  svn19705\.1\.005\_b\-59\.amzn2023\.0\.2  | 
|  texlive\-electrum\-doc  |  noarch  |  texlive  |  svn19705\.1\.005\_b\-59\.amzn2023\.0\.2  | 
|  texlive\-eledform  |  noarch  |  texlive  |  svn38114\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-eledform\-doc  |  noarch  |  texlive  |  svn38114\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-eledmac  |  noarch  |  texlive  |  svn45418\-59\.amzn2023\.0\.2  | 
|  texlive\-eledmac\-doc  |  noarch  |  texlive  |  svn45418\-59\.amzn2023\.0\.2  | 
|  texlive\-elegantbook  |  noarch  |  texlive  |  svn59053\-59\.amzn2023\.0\.2  | 
|  texlive\-elegantnote  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-elegantpaper  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-elements  |  noarch  |  texlive  |  svn52398\-59\.amzn2023\.0\.2  | 
|  texlive\-elements\-doc  |  noarch  |  texlive  |  svn52398\-59\.amzn2023\.0\.2  | 
|  texlive\-ellipse  |  noarch  |  texlive  |  svn39025\-59\.amzn2023\.0\.2  | 
|  texlive\-ellipse\-doc  |  noarch  |  texlive  |  svn39025\-59\.amzn2023\.0\.2  | 
|  texlive\-ellipsis  |  noarch  |  texlive  |  svn55418\-59\.amzn2023\.0\.2  | 
|  texlive\-ellipsis\-doc  |  noarch  |  texlive  |  svn55418\-59\.amzn2023\.0\.2  | 
|  texlive\-elmath  |  noarch  |  texlive  |  svn15878\.v1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-elmath\-doc  |  noarch  |  texlive  |  svn15878\.v1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-elocalloc  |  noarch  |  texlive  |  svn42712\-59\.amzn2023\.0\.2  | 
|  texlive\-elocalloc\-doc  |  noarch  |  texlive  |  svn42712\-59\.amzn2023\.0\.2  | 
|  texlive\-elpres  |  noarch  |  texlive  |  svn58015\-59\.amzn2023\.0\.2  | 
|  texlive\-elpres\-doc  |  noarch  |  texlive  |  svn58015\-59\.amzn2023\.0\.2  | 
|  texlive\-elsarticle  |  noarch  |  texlive  |  svn56999\-59\.amzn2023\.0\.2  | 
|  texlive\-elsarticle\-doc  |  noarch  |  texlive  |  svn56999\-59\.amzn2023\.0\.2  | 
|  texlive\-els\-cas\-templates  |  noarch  |  texlive  |  svn54317\-59\.amzn2023\.0\.2  | 
|  texlive\-elteikthesis  |  noarch  |  texlive  |  svn55928\-59\.amzn2023\.0\.2  | 
|  texlive\-elteikthesis\-doc  |  noarch  |  texlive  |  svn55928\-59\.amzn2023\.0\.2  | 
|  texlive\-eltex  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eltex\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-elvish  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-elvish\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-elzcards  |  noarch  |  texlive  |  svn51894\-59\.amzn2023\.0\.2  | 
|  texlive\-elzcards\-doc  |  noarch  |  texlive  |  svn51894\-59\.amzn2023\.0\.2  | 
|  texlive\-emarks  |  noarch  |  texlive  |  svn24504\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-emarks\-doc  |  noarch  |  texlive  |  svn24504\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-embedall  |  noarch  |  texlive  |  svn51177\-59\.amzn2023\.0\.2  | 
|  texlive\-embedall\-doc  |  noarch  |  texlive  |  svn51177\-59\.amzn2023\.0\.2  | 
|  texlive\-embedfile  |  noarch  |  texlive  |  svn54865\-59\.amzn2023\.0\.2  | 
|  texlive\-embrac  |  noarch  |  texlive  |  svn57814\-59\.amzn2023\.0\.2  | 
|  texlive\-embrac\-doc  |  noarch  |  texlive  |  svn57814\-59\.amzn2023\.0\.2  | 
|  texlive\-emf  |  noarch  |  texlive  |  svn42023\-59\.amzn2023\.0\.2  | 
|  texlive\-emisa  |  noarch  |  texlive  |  svn57013\-59\.amzn2023\.0\.2  | 
|  texlive\-emisa\-doc  |  noarch  |  texlive  |  svn57013\-59\.amzn2023\.0\.2  | 
|  texlive\-emoji  |  noarch  |  texlive  |  svn55678\-59\.amzn2023\.0\.2  | 
|  texlive\-emojicite  |  noarch  |  texlive  |  svn55131\-59\.amzn2023\.0\.2  | 
|  texlive\-emp  |  noarch  |  texlive  |  svn23483\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-emp\-doc  |  noarch  |  texlive  |  svn23483\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-emptypage  |  noarch  |  texlive  |  svn18064\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-emptypage\-doc  |  noarch  |  texlive  |  svn18064\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-emulateapj  |  noarch  |  texlive  |  svn28469\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-emulateapj\-doc  |  noarch  |  texlive  |  svn28469\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-enctex  |  noarch  |  texlive  |  svn34957\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-enctex\-doc  |  noarch  |  texlive  |  svn34957\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-encxvlna  |  noarch  |  texlive  |  svn34087\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-encxvlna\-doc  |  noarch  |  texlive  |  svn34087\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-endfloat  |  noarch  |  texlive  |  svn57090\-59\.amzn2023\.0\.2  | 
|  texlive\-endfloat\-doc  |  noarch  |  texlive  |  svn57090\-59\.amzn2023\.0\.2  | 
|  texlive\-endheads  |  noarch  |  texlive  |  svn43750\-59\.amzn2023\.0\.2  | 
|  texlive\-endheads\-doc  |  noarch  |  texlive  |  svn43750\-59\.amzn2023\.0\.2  | 
|  texlive\-endiagram  |  noarch  |  texlive  |  svn34486\.0\.1d\-59\.amzn2023\.0\.2  | 
|  texlive\-endiagram\-doc  |  noarch  |  texlive  |  svn34486\.0\.1d\-59\.amzn2023\.0\.2  | 
|  texlive\-endnotes  |  noarch  |  texlive  |  svn53319\-59\.amzn2023\.0\.2  | 
|  texlive\-endnotes\-doc  |  noarch  |  texlive  |  svn53319\-59\.amzn2023\.0\.2  | 
|  texlive\-endnotes\-hy  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-endnotesj  |  noarch  |  texlive  |  svn47703\-59\.amzn2023\.0\.2  | 
|  texlive\-endofproofwd  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-engpron  |  noarch  |  texlive  |  svn16558\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-engpron\-doc  |  noarch  |  texlive  |  svn16558\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-engrec  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-engrec\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-engtlc  |  noarch  |  texlive  |  svn28571\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-engtlc\-doc  |  noarch  |  texlive  |  svn28571\.3\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-enigma  |  noarch  |  texlive  |  svn29802\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-enigma\-doc  |  noarch  |  texlive  |  svn29802\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-enotez  |  noarch  |  texlive  |  svn57130\-59\.amzn2023\.0\.2  | 
|  texlive\-enotez\-doc  |  noarch  |  texlive  |  svn57130\-59\.amzn2023\.0\.2  | 
|  texlive\-enumitem  |  noarch  |  texlive  |  svn51423\-59\.amzn2023\.0\.2  | 
|  texlive\-enumitem\-doc  |  noarch  |  texlive  |  svn51423\-59\.amzn2023\.0\.2  | 
|  texlive\-enumitem\-zref  |  noarch  |  texlive  |  svn21472\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-enumitem\-zref\-doc  |  noarch  |  texlive  |  svn21472\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-envbig  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-envbig\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-environ  |  noarch  |  texlive  |  svn56615\-59\.amzn2023\.0\.2  | 
|  texlive\-environ\-doc  |  noarch  |  texlive  |  svn56615\-59\.amzn2023\.0\.2  | 
|  texlive\-envlab  |  noarch  |  texlive  |  svn15878\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-envlab\-doc  |  noarch  |  texlive  |  svn15878\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-epigrafica  |  noarch  |  texlive  |  svn17210\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-epigrafica\-doc  |  noarch  |  texlive  |  svn17210\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-epigram  |  noarch  |  texlive  |  svn20513\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-epigraph  |  noarch  |  texlive  |  svn54857\-59\.amzn2023\.0\.2  | 
|  texlive\-epigraph\-doc  |  noarch  |  texlive  |  svn54857\-59\.amzn2023\.0\.2  | 
|  texlive\-epigraph\-keys  |  noarch  |  texlive  |  svn54851\-59\.amzn2023\.0\.2  | 
|  texlive\-epiolmec  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-epiolmec\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-epsdice  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-epsdice\-doc  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-epsf  |  noarch  |  texlive  |  svn21461\.2\.7\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-epsf\-doc  |  noarch  |  texlive  |  svn21461\.2\.7\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-epsf\-dvipdfmx  |  noarch  |  texlive  |  svn35575\.2014\-59\.amzn2023\.0\.2  | 
|  texlive\-epsf\-dvipdfmx\-doc  |  noarch  |  texlive  |  svn35575\.2014\-59\.amzn2023\.0\.2  | 
|  texlive\-epsincl  |  noarch  |  texlive  |  svn29349\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-epsincl\-doc  |  noarch  |  texlive  |  svn29349\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-epslatex\-fr\-doc  |  noarch  |  texlive  |  svn19440\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-epspdfconversion  |  noarch  |  texlive  |  svn18703\.0\.61\-59\.amzn2023\.0\.2  | 
|  texlive\-epspdfconversion\-doc  |  noarch  |  texlive  |  svn18703\.0\.61\-59\.amzn2023\.0\.2  | 
|  texlive\-epstopdf\-pkg  |  noarch  |  texlive  |  svn53546\-59\.amzn2023\.0\.2  | 
|  texlive\-eqell  |  noarch  |  texlive  |  svn22931\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eqell\-doc  |  noarch  |  texlive  |  svn22931\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eqexpl  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-eqlist  |  noarch  |  texlive  |  svn32257\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-eqlist\-doc  |  noarch  |  texlive  |  svn32257\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-eqnalign  |  noarch  |  texlive  |  svn43278\-59\.amzn2023\.0\.2  | 
|  texlive\-eqname  |  noarch  |  texlive  |  svn20678\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eqnarray  |  noarch  |  texlive  |  svn20641\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-eqnarray\-doc  |  noarch  |  texlive  |  svn20641\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-eqnnumwarn  |  noarch  |  texlive  |  svn45511\-59\.amzn2023\.0\.2  | 
|  texlive\-eqparbox  |  noarch  |  texlive  |  svn45215\-59\.amzn2023\.0\.2  | 
|  texlive\-eqparbox\-doc  |  noarch  |  texlive  |  svn45215\-59\.amzn2023\.0\.2  | 
|  texlive\-eq\-pin2corr  |  noarch  |  texlive  |  svn57815\-59\.amzn2023\.0\.2  | 
|  texlive\-erdc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-erdc\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-erewhon  |  noarch  |  texlive  |  svn58722\-59\.amzn2023\.0\.2  | 
|  texlive\-erewhon\-doc  |  noarch  |  texlive  |  svn58722\-59\.amzn2023\.0\.2  | 
|  texlive\-erewhon\-math  |  noarch  |  texlive  |  svn58903\-59\.amzn2023\.0\.2  | 
|  texlive\-errata  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-errata\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-erw\-l3  |  noarch  |  texlive  |  svn55414\-59\.amzn2023\.0\.2  | 
|  texlive\-esami  |  noarch  |  texlive  |  svn47639\-59\.amzn2023\.0\.2  | 
|  texlive\-esami\-doc  |  noarch  |  texlive  |  svn47639\-59\.amzn2023\.0\.2  | 
|  texlive\-esdiff  |  noarch  |  texlive  |  svn21385\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-esdiff\-doc  |  noarch  |  texlive  |  svn21385\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-ESIEEcv  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ESIEEcv\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esindex  |  noarch  |  texlive  |  svn52342\-59\.amzn2023\.0\.2  | 
|  texlive\-esint  |  noarch  |  texlive  |  svn52240\-59\.amzn2023\.0\.2  | 
|  texlive\-esint\-doc  |  noarch  |  texlive  |  svn52240\-59\.amzn2023\.0\.2  | 
|  texlive\-esint\-type1  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esint\-type1\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esk  |  noarch  |  texlive  |  svn18115\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eskd  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eskd\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esk\-doc  |  noarch  |  texlive  |  svn18115\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eskdx  |  noarch  |  texlive  |  svn29235\.0\.98\-59\.amzn2023\.0\.2  | 
|  texlive\-eskdx\-doc  |  noarch  |  texlive  |  svn29235\.0\.98\-59\.amzn2023\.0\.2  | 
|  texlive\-eso\-pic  |  noarch  |  texlive  |  svn56658\-59\.amzn2023\.0\.2  | 
|  texlive\-eso\-pic\-doc  |  noarch  |  texlive  |  svn47694\-59\.amzn2023\.0\.2  | 
|  texlive\-esrelation  |  noarch  |  texlive  |  svn37236\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esrelation\-doc  |  noarch  |  texlive  |  svn37236\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esstix  |  noarch  |  texlive  |  svn22426\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-esstix\-doc  |  noarch  |  texlive  |  svn22426\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-estcpmm  |  noarch  |  texlive  |  svn17335\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-estcpmm\-doc  |  noarch  |  texlive  |  svn17335\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-es\-tex\-faq\-doc  |  noarch  |  texlive  |  svn15878\.1\.97\-59\.amzn2023\.0\.2  | 
|  texlive\-esvect  |  noarch  |  texlive  |  svn32098\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-esvect\-doc  |  noarch  |  texlive  |  svn32098\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-etaremune  |  noarch  |  texlive  |  svn15878\.v1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-etaremune\-doc  |  noarch  |  texlive  |  svn15878\.v1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-etbb  |  noarch  |  texlive  |  svn56390\-59\.amzn2023\.0\.2  | 
|  texlive\-etdipa\-doc  |  noarch  |  texlive  |  svn36354\.2\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-etex  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-etexcmds  |  noarch  |  texlive  |  svn53171\-59\.amzn2023\.0\.2  | 
|  texlive\-etex\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-etex\-pkg  |  noarch  |  texlive  |  svn41784\-59\.amzn2023\.0\.2  | 
|  texlive\-etex\-pkg\-doc  |  noarch  |  texlive  |  svn41784\-59\.amzn2023\.0\.2  | 
|  texlive\-etextools  |  noarch  |  texlive  |  svn20694\.3\.1415926\-59\.amzn2023\.0\.2  | 
|  texlive\-etextools\-doc  |  noarch  |  texlive  |  svn20694\.3\.1415926\-59\.amzn2023\.0\.2  | 
|  texlive\-ethiop  |  noarch  |  texlive  |  svn15878\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-ethiop\-doc  |  noarch  |  texlive  |  svn15878\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-ethiop\-t1  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ethiop\-t1\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-etoc  |  noarch  |  texlive  |  svn55156\-59\.amzn2023\.0\.2  | 
|  texlive\-etoc\-doc  |  noarch  |  texlive  |  svn55156\-59\.amzn2023\.0\.2  | 
|  texlive\-etoolbox  |  noarch  |  texlive  |  svn56554\-59\.amzn2023\.0\.2  | 
|  texlive\-etoolbox\-de\-doc  |  noarch  |  texlive  |  svn21906\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-etoolbox\-doc  |  noarch  |  texlive  |  svn56554\-59\.amzn2023\.0\.2  | 
|  texlive\-etsvthor  |  noarch  |  texlive  |  svn48186\-59\.amzn2023\.0\.2  | 
|  texlive\-euclideangeometry  |  noarch  |  texlive  |  svn54897\-59\.amzn2023\.0\.2  | 
|  texlive\-euenc  |  noarch  |  texlive  |  svn19795\.0\.1h\-59\.amzn2023\.0\.2  | 
|  texlive\-euenc\-doc  |  noarch  |  texlive  |  svn19795\.0\.1h\-59\.amzn2023\.0\.2  | 
|  texlive\-euflag  |  noarch  |  texlive  |  svn55265\-59\.amzn2023\.0\.2  | 
|  texlive\-eukdate  |  noarch  |  texlive  |  svn15878\.1\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-eukdate\-doc  |  noarch  |  texlive  |  svn15878\.1\.04\-59\.amzn2023\.0\.2  | 
|  texlive\-euler  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-euler\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-eulerpx  |  noarch  |  texlive  |  svn43735\-59\.amzn2023\.0\.2  | 
|  texlive\-eulervm  |  noarch  |  texlive  |  svn15878\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-eulervm\-doc  |  noarch  |  texlive  |  svn15878\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-euro  |  noarch  |  texlive  |  svn22191\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-euro\-ce  |  noarch  |  texlive  |  svn25714\-59\.amzn2023\.0\.2  | 
|  texlive\-euro\-doc  |  noarch  |  texlive  |  svn22191\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-europasscv  |  noarch  |  texlive  |  svn56829\-59\.amzn2023\.0\.2  | 
|  texlive\-europasscv\-doc  |  noarch  |  texlive  |  svn56829\-59\.amzn2023\.0\.2  | 
|  texlive\-europecv  |  noarch  |  texlive  |  svn59162\-59\.amzn2023\.0\.2  | 
|  texlive\-europecv\-doc  |  noarch  |  texlive  |  svn59162\-59\.amzn2023\.0\.2  | 
|  texlive\-eurosym  |  noarch  |  texlive  |  svn17265\.1\.4\_subrfix\-59\.amzn2023\.0\.2  | 
|  texlive\-eurosym\-doc  |  noarch  |  texlive  |  svn17265\.1\.4\_subrfix\-59\.amzn2023\.0\.2  | 
|  texlive\-euxm  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-everyhook  |  noarch  |  texlive  |  svn35675\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-everyhook\-doc  |  noarch  |  texlive  |  svn35675\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-everypage  |  noarch  |  texlive  |  svn56694\-59\.amzn2023\.0\.2  | 
|  texlive\-everypage\-doc  |  noarch  |  texlive  |  svn56694\-59\.amzn2023\.0\.2  | 
|  texlive\-everysel  |  noarch  |  texlive  |  svn57489\-59\.amzn2023\.0\.2  | 
|  texlive\-everyshi  |  noarch  |  texlive  |  svn57001\-59\.amzn2023\.0\.2  | 
|  texlive\-exam  |  noarch  |  texlive  |  svn58023\-59\.amzn2023\.0\.2  | 
|  texlive\-examdesign  |  noarch  |  texlive  |  svn15878\.1\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-examdesign\-doc  |  noarch  |  texlive  |  svn15878\.1\.02\-59\.amzn2023\.0\.2  | 
|  texlive\-exam\-doc  |  noarch  |  texlive  |  svn58023\-59\.amzn2023\.0\.2  | 
|  texlive\-exam\-n  |  noarch  |  texlive  |  svn42755\-59\.amzn2023\.0\.2  | 
|  texlive\-exam\-n\-doc  |  noarch  |  texlive  |  svn42755\-59\.amzn2023\.0\.2  | 
|  texlive\-example  |  noarch  |  texlive  |  svn33398\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-examplep  |  noarch  |  texlive  |  svn55265\-59\.amzn2023\.0\.2  | 
|  texlive\-examplep\-doc  |  noarch  |  texlive  |  svn55265\-59\.amzn2023\.0\.2  | 
|  texlive\-exam\-randomizechoices  |  noarch  |  texlive  |  svn49662\-59\.amzn2023\.0\.2  | 
|  texlive\-excludeonly  |  noarch  |  texlive  |  svn17262\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-excludeonly\-doc  |  noarch  |  texlive  |  svn17262\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-exercise  |  noarch  |  texlive  |  svn35417\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-exercisebank  |  noarch  |  texlive  |  svn50448\-59\.amzn2023\.0\.2  | 
|  texlive\-exercise\-doc  |  noarch  |  texlive  |  svn35417\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-exercisepoints  |  noarch  |  texlive  |  svn49590\-59\.amzn2023\.0\.2  | 
|  texlive\-exercises  |  noarch  |  texlive  |  svn55188\-59\.amzn2023\.0\.2  | 
|  texlive\-exercises\-doc  |  noarch  |  texlive  |  svn55188\-59\.amzn2023\.0\.2  | 
|  texlive\-exesheet  |  noarch  |  texlive  |  svn55916\-59\.amzn2023\.0\.2  | 
|  texlive\-exframe  |  noarch  |  texlive  |  svn53911\-59\.amzn2023\.0\.2  | 
|  texlive\-expdlist  |  noarch  |  texlive  |  svn15878\.2\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-expdlist\-doc  |  noarch  |  texlive  |  svn15878\.2\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-expex  |  noarch  |  texlive  |  svn44499\-59\.amzn2023\.0\.2  | 
|  texlive\-expex\-doc  |  noarch  |  texlive  |  svn44499\-59\.amzn2023\.0\.2  | 
|  texlive\-expkv  |  noarch  |  texlive  |  svn58853\-59\.amzn2023\.0\.2  | 
|  texlive\-expkv\-cs  |  noarch  |  texlive  |  svn58852\-59\.amzn2023\.0\.2  | 
|  texlive\-expkv\-def  |  noarch  |  texlive  |  svn58814\-59\.amzn2023\.0\.2  | 
|  texlive\-expkv\-opt  |  noarch  |  texlive  |  svn58772\-59\.amzn2023\.0\.2  | 
|  texlive\-export  |  noarch  |  texlive  |  svn27206\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-export\-doc  |  noarch  |  texlive  |  svn27206\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-expose\-expl3\-dunkerque\-2019  |  noarch  |  texlive  |  svn54451\-59\.amzn2023\.0\.2  | 
|  texlive\-expressg  |  noarch  |  texlive  |  svn29349\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-expressg\-doc  |  noarch  |  texlive  |  svn29349\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-exp\-testopt  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-exp\-testopt\-doc  |  noarch  |  texlive  |  svn15878\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-exsheets  |  noarch  |  texlive  |  svn52227\-59\.amzn2023\.0\.2  | 
|  texlive\-exsheets\-doc  |  noarch  |  texlive  |  svn52227\-59\.amzn2023\.0\.2  | 
|  texlive\-exsol  |  noarch  |  texlive  |  svn48977\-59\.amzn2023\.0\.2  | 
|  texlive\-exsol\-doc  |  noarch  |  texlive  |  svn48977\-59\.amzn2023\.0\.2  | 
|  texlive\-extarrows  |  noarch  |  texlive  |  svn54400\-59\.amzn2023\.0\.2  | 
|  texlive\-extarrows\-doc  |  noarch  |  texlive  |  svn54400\-59\.amzn2023\.0\.2  | 
|  texlive\-exteps  |  noarch  |  texlive  |  svn19859\.0\.41\-59\.amzn2023\.0\.2  | 
|  texlive\-exteps\-doc  |  noarch  |  texlive  |  svn19859\.0\.41\-59\.amzn2023\.0\.2  | 
|  texlive\-extpfeil  |  noarch  |  texlive  |  svn16243\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-extpfeil\-doc  |  noarch  |  texlive  |  svn16243\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-extract  |  noarch  |  texlive  |  svn52117\-59\.amzn2023\.0\.2  | 
|  texlive\-extract\-doc  |  noarch  |  texlive  |  svn52117\-59\.amzn2023\.0\.2  | 
|  texlive\-extsizes  |  noarch  |  texlive  |  svn17263\.1\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-extsizes\-doc  |  noarch  |  texlive  |  svn17263\.1\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-facsimile  |  noarch  |  texlive  |  svn21328\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-facsimile\-doc  |  noarch  |  texlive  |  svn21328\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-factura  |  noarch  |  texlive  |  svn56948\-59\.amzn2023\.0\.2  | 
|  texlive\-factura\-doc  |  noarch  |  texlive  |  svn54803\-59\.amzn2023\.0\.2  | 
|  texlive\-facture  |  noarch  |  texlive  |  svn43865\-59\.amzn2023\.0\.2  | 
|  texlive\-facture\-belge\-simple\-sans\-tva  |  noarch  |  texlive  |  svn49004\-59\.amzn2023\.0\.2  | 
|  texlive\-facture\-doc  |  noarch  |  texlive  |  svn43865\-59\.amzn2023\.0\.2  | 
|  texlive\-faktor  |  noarch  |  texlive  |  svn15878\.0\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-faktor\-doc  |  noarch  |  texlive  |  svn15878\.0\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-fancybox  |  noarch  |  texlive  |  svn18304\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fancybox\-doc  |  noarch  |  texlive  |  svn18304\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyhandout  |  noarch  |  texlive  |  svn46411\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyhdr  |  noarch  |  texlive  |  svn57672\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyhdr\-doc  |  noarch  |  texlive  |  svn57672\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyhdr\-it\-doc  |  noarch  |  texlive  |  svn21912\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fancylabel  |  noarch  |  texlive  |  svn46736\-59\.amzn2023\.0\.2  | 
|  texlive\-fancylabel\-doc  |  noarch  |  texlive  |  svn46736\-59\.amzn2023\.0\.2  | 
|  texlive\-fancynum  |  noarch  |  texlive  |  svn15878\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-fancynum\-doc  |  noarch  |  texlive  |  svn15878\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-fancypar  |  noarch  |  texlive  |  svn58895\-59\.amzn2023\.0\.2  | 
|  texlive\-fancypar\-doc  |  noarch  |  texlive  |  svn58895\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyref  |  noarch  |  texlive  |  svn15878\.0\.9c\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyref\-doc  |  noarch  |  texlive  |  svn15878\.0\.9c\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyslides  |  noarch  |  texlive  |  svn36263\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyslides\-doc  |  noarch  |  texlive  |  svn36263\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fancytabs  |  noarch  |  texlive  |  svn41549\-59\.amzn2023\.0\.2  | 
|  texlive\-fancytabs\-doc  |  noarch  |  texlive  |  svn41549\-59\.amzn2023\.0\.2  | 
|  texlive\-fancytooltips  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-fancytooltips\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyvrb  |  noarch  |  texlive  |  svn57488\-59\.amzn2023\.0\.2  | 
|  texlive\-fancyvrb\-doc  |  noarch  |  texlive  |  svn57488\-59\.amzn2023\.0\.2  | 
|  texlive\-fandol  |  noarch  |  texlive  |  svn37889\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-fandol\-doc  |  noarch  |  texlive  |  svn37889\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-fascicules  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-fast\-diagram  |  noarch  |  texlive  |  svn29264\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fast\-diagram\-doc  |  noarch  |  texlive  |  svn29264\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fbb  |  noarch  |  texlive  |  svn55728\-59\.amzn2023\.0\.2  | 
|  texlive\-fbb\-doc  |  noarch  |  texlive  |  svn55728\-59\.amzn2023\.0\.2  | 
|  texlive\-fbithesis  |  noarch  |  texlive  |  svn21340\.1\.2m\-59\.amzn2023\.0\.2  | 
|  texlive\-fbithesis\-doc  |  noarch  |  texlive  |  svn21340\.1\.2m\-59\.amzn2023\.0\.2  | 
|  texlive\-fbox  |  noarch  |  texlive  |  svn55627\-59\.amzn2023\.0\.2  | 
|  texlive\-fbs  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fc  |  noarch  |  texlive  |  svn32796\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fcavtex  |  noarch  |  texlive  |  svn38074\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fcavtex\-doc  |  noarch  |  texlive  |  svn38074\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fc\-doc  |  noarch  |  texlive  |  svn32796\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fcltxdoc  |  noarch  |  texlive  |  svn24500\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fcltxdoc\-doc  |  noarch  |  texlive  |  svn24500\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fcolumn  |  noarch  |  texlive  |  svn57428\-59\.amzn2023\.0\.2  | 
|  texlive\-fcolumn\-doc  |  noarch  |  texlive  |  svn57428\-59\.amzn2023\.0\.2  | 
|  texlive\-fdsymbol  |  noarch  |  texlive  |  svn26722\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-fdsymbol\-doc  |  noarch  |  texlive  |  svn26722\.0\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-fduthesis  |  noarch  |  texlive  |  svn56216\-59\.amzn2023\.0\.2  | 
|  texlive\-featpost  |  noarch  |  texlive  |  svn35346\.0\.8\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-featpost\-doc  |  noarch  |  texlive  |  svn35346\.0\.8\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-fei  |  noarch  |  texlive  |  svn55960\-59\.amzn2023\.0\.2  | 
|  texlive\-fei\-doc  |  noarch  |  texlive  |  svn55960\-59\.amzn2023\.0\.2  | 
|  texlive\-fenixpar  |  noarch  |  texlive  |  svn24730\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-fenixpar\-doc  |  noarch  |  texlive  |  svn24730\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-fetamont  |  noarch  |  texlive  |  svn43812\-59\.amzn2023\.0\.2  | 
|  texlive\-fetamont\-doc  |  noarch  |  texlive  |  svn43812\-59\.amzn2023\.0\.2  | 
|  texlive\-fetchcls  |  noarch  |  texlive  |  svn45245\-59\.amzn2023\.0\.2  | 
|  texlive\-feupphdteses  |  noarch  |  texlive  |  svn30962\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-feupphdteses\-doc  |  noarch  |  texlive  |  svn30962\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fewerfloatpages  |  noarch  |  texlive  |  svn58058\-59\.amzn2023\.0\.2  | 
|  texlive\-feyn  |  noarch  |  texlive  |  svn55777\-59\.amzn2023\.0\.2  | 
|  texlive\-feyn\-doc  |  noarch  |  texlive  |  svn55777\-59\.amzn2023\.0\.2  | 
|  texlive\-feynmf  |  noarch  |  texlive  |  svn17259\.1\.08\-59\.amzn2023\.0\.2  | 
|  texlive\-feynmf\-doc  |  noarch  |  texlive  |  svn17259\.1\.08\-59\.amzn2023\.0\.2  | 
|  texlive\-feynmp\-auto  |  noarch  |  texlive  |  svn30223\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-feynmp\-auto\-doc  |  noarch  |  texlive  |  svn30223\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-ffslides  |  noarch  |  texlive  |  svn38895\-59\.amzn2023\.0\.2  | 
|  texlive\-ffslides\-doc  |  noarch  |  texlive  |  svn38895\-59\.amzn2023\.0\.2  | 
|  texlive\-fge  |  noarch  |  texlive  |  svn37628\.1\.25\-59\.amzn2023\.0\.2  | 
|  texlive\-fge\-doc  |  noarch  |  texlive  |  svn37628\.1\.25\-59\.amzn2023\.0\.2  | 
|  texlive\-fgruler  |  noarch  |  texlive  |  svn56854\-59\.amzn2023\.0\.2  | 
|  texlive\-fibeamer  |  noarch  |  texlive  |  svn53146\-59\.amzn2023\.0\.2  | 
|  texlive\-fibeamer\-doc  |  noarch  |  texlive  |  svn53146\-59\.amzn2023\.0\.2  | 
|  texlive\-fifinddo\-info\-doc  |  noarch  |  texlive  |  svn29349\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-fifo\-stack  |  noarch  |  texlive  |  svn33288\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fifo\-stack\-doc  |  noarch  |  texlive  |  svn33288\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-figbas  |  noarch  |  texlive  |  svn28943\.1\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-figbas\-doc  |  noarch  |  texlive  |  svn28943\.1\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-figbib  |  noarch  |  texlive  |  svn19388\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-figbib\-doc  |  noarch  |  texlive  |  svn19388\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-figchild  |  noarch  |  texlive  |  svn58964\-59\.amzn2023\.0\.2  | 
|  texlive\-figflow  |  noarch  |  texlive  |  svn21462\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-figflow\-doc  |  noarch  |  texlive  |  svn21462\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-figsize  |  noarch  |  texlive  |  svn18784\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-figsize\-doc  |  noarch  |  texlive  |  svn18784\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-filecontents  |  noarch  |  texlive  |  svn52142\-59\.amzn2023\.0\.2  | 
|  texlive\-filecontentsdef  |  noarch  |  texlive  |  svn52208\-59\.amzn2023\.0\.2  | 
|  texlive\-filecontents\-doc  |  noarch  |  texlive  |  svn52142\-59\.amzn2023\.0\.2  | 
|  texlive\-filedate  |  noarch  |  texlive  |  svn29529\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-filedate\-doc  |  noarch  |  texlive  |  svn29529\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-filehook  |  noarch  |  texlive  |  svn56479\-59\.amzn2023\.0\.2  | 
|  texlive\-filehook\-doc  |  noarch  |  texlive  |  svn56479\-59\.amzn2023\.0\.2  | 
|  texlive\-fileinfo  |  noarch  |  texlive  |  svn28421\.0\.81a\-59\.amzn2023\.0\.2  | 
|  texlive\-fileinfo\-doc  |  noarch  |  texlive  |  svn28421\.0\.81a\-59\.amzn2023\.0\.2  | 
|  texlive\-filemod  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-filemod\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-finbib  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fink  |  noarch  |  texlive  |  svn24329\.2\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fink\-doc  |  noarch  |  texlive  |  svn24329\.2\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-finstrut  |  noarch  |  texlive  |  svn21719\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-finstrut\-doc  |  noarch  |  texlive  |  svn21719\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-fira  |  noarch  |  texlive  |  svn55437\-59\.amzn2023\.0\.2  | 
|  texlive\-fira\-doc  |  noarch  |  texlive  |  svn55437\-59\.amzn2023\.0\.2  | 
|  texlive\-firamath  |  noarch  |  texlive  |  svn56672\-59\.amzn2023\.0\.2  | 
|  texlive\-firamath\-otf  |  noarch  |  texlive  |  svn50732\-59\.amzn2023\.0\.2  | 
|  texlive\-firstaid  |  noarch  |  texlive  |  svn58440\-59\.amzn2023\.0\.2  | 
|  texlive\-first\-latex\-doc\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fitbox  |  noarch  |  texlive  |  svn50088\-59\.amzn2023\.0\.2  | 
|  texlive\-fitbox\-doc  |  noarch  |  texlive  |  svn50088\-59\.amzn2023\.0\.2  | 
|  texlive\-fithesis  |  noarch  |  texlive  |  svn54483\-59\.amzn2023\.0\.2  | 
|  texlive\-fithesis\-doc  |  noarch  |  texlive  |  svn54483\-59\.amzn2023\.0\.2  | 
|  texlive\-fix2col  |  noarch  |  texlive  |  svn38770\-59\.amzn2023\.0\.2  | 
|  texlive\-fix2col\-doc  |  noarch  |  texlive  |  svn38770\-59\.amzn2023\.0\.2  | 
|  texlive\-fixcmex  |  noarch  |  texlive  |  svn51825\-59\.amzn2023\.0\.2  | 
|  texlive\-fixcmex\-doc  |  noarch  |  texlive  |  svn51825\-59\.amzn2023\.0\.2  | 
|  texlive\-fixfoot  |  noarch  |  texlive  |  svn17131\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-fixfoot\-doc  |  noarch  |  texlive  |  svn17131\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-fixjfm  |  noarch  |  texlive  |  svn47113\-59\.amzn2023\.0\.2  | 
|  texlive\-fixlatvian  |  noarch  |  texlive  |  svn21631\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-fixlatvian\-doc  |  noarch  |  texlive  |  svn21631\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-fixltxhyph  |  noarch  |  texlive  |  svn25832\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fixltxhyph\-doc  |  noarch  |  texlive  |  svn25832\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-fixme  |  noarch  |  texlive  |  svn49591\-59\.amzn2023\.0\.2  | 
|  texlive\-fixme\-doc  |  noarch  |  texlive  |  svn49591\-59\.amzn2023\.0\.2  | 
|  texlive\-fixmetodonotes  |  noarch  |  texlive  |  svn30168\.0\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fixmetodonotes\-doc  |  noarch  |  texlive  |  svn30168\.0\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fixpdfmag  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fiziko  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-fjodor  |  noarch  |  texlive  |  svn53207\-59\.amzn2023\.0\.2  | 
|  texlive\-fjodor\-doc  |  noarch  |  texlive  |  svn53207\-59\.amzn2023\.0\.2  | 
|  texlive\-flabels  |  noarch  |  texlive  |  svn17272\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-flabels\-doc  |  noarch  |  texlive  |  svn17272\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-flacards  |  noarch  |  texlive  |  svn19440\.0\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-flacards\-doc  |  noarch  |  texlive  |  svn19440\.0\.1\.1b\-59\.amzn2023\.0\.2  | 
|  texlive\-flagderiv  |  noarch  |  texlive  |  svn15878\.0\.10\-59\.amzn2023\.0\.2  | 
|  texlive\-flagderiv\-doc  |  noarch  |  texlive  |  svn15878\.0\.10\-59\.amzn2023\.0\.2  | 
|  texlive\-flashcards  |  noarch  |  texlive  |  svn19667\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-flashcards\-doc  |  noarch  |  texlive  |  svn19667\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-flashmovie  |  noarch  |  texlive  |  svn25768\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-flashmovie\-doc  |  noarch  |  texlive  |  svn25768\.0\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-flipbook  |  noarch  |  texlive  |  svn25584\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-flipbook\-doc  |  noarch  |  texlive  |  svn25584\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-flippdf  |  noarch  |  texlive  |  svn56782\-59\.amzn2023\.0\.2  | 
|  texlive\-flippdf\-doc  |  noarch  |  texlive  |  svn56782\-59\.amzn2023\.0\.2  | 
|  texlive\-float  |  noarch  |  texlive  |  svn15878\.1\.3d\-59\.amzn2023\.0\.2  | 
|  texlive\-float\-doc  |  noarch  |  texlive  |  svn15878\.1\.3d\-59\.amzn2023\.0\.2  | 
|  texlive\-floatflt  |  noarch  |  texlive  |  svn25540\.1\.31\-59\.amzn2023\.0\.2  | 
|  texlive\-floatflt\-doc  |  noarch  |  texlive  |  svn25540\.1\.31\-59\.amzn2023\.0\.2  | 
|  texlive\-floatrow  |  noarch  |  texlive  |  svn15878\.0\.3b\-59\.amzn2023\.0\.2  | 
|  texlive\-floatrow\-doc  |  noarch  |  texlive  |  svn15878\.0\.3b\-59\.amzn2023\.0\.2  | 
|  texlive\-flowchart  |  noarch  |  texlive  |  svn36572\.3\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-flowchart\-doc  |  noarch  |  texlive  |  svn36572\.3\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-flowfram  |  noarch  |  texlive  |  svn35291\.1\.17\-59\.amzn2023\.0\.2  | 
|  texlive\-flowfram\-doc  |  noarch  |  texlive  |  svn35291\.1\.17\-59\.amzn2023\.0\.2  | 
|  texlive\-fltpoint  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-fltpoint\-doc  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-fmp  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fmp\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fmtcount  |  noarch  |  texlive  |  svn53912\-59\.amzn2023\.0\.2  | 
|  texlive\-fmtcount\-doc  |  noarch  |  texlive  |  svn53912\-59\.amzn2023\.0\.2  | 
|  texlive\-fn2end  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fn2end\-doc  |  noarch  |  texlive  |  svn15878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fnbreak  |  noarch  |  texlive  |  svn25003\.1\.30\-59\.amzn2023\.0\.2  | 
|  texlive\-fnbreak\-doc  |  noarch  |  texlive  |  svn25003\.1\.30\-59\.amzn2023\.0\.2  | 
|  texlive\-fncychap  |  noarch  |  texlive  |  svn20710\.v1\.34\-59\.amzn2023\.0\.2  | 
|  texlive\-fncychap\-doc  |  noarch  |  texlive  |  svn20710\.v1\.34\-59\.amzn2023\.0\.2  | 
|  texlive\-fncylab  |  noarch  |  texlive  |  svn52090\-59\.amzn2023\.0\.2  | 
|  texlive\-fncylab\-doc  |  noarch  |  texlive  |  svn52090\-59\.amzn2023\.0\.2  | 
|  texlive\-fnpara  |  noarch  |  texlive  |  svn25607\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fnpara\-doc  |  noarch  |  texlive  |  svn25607\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fnpct  |  noarch  |  texlive  |  svn57508\-59\.amzn2023\.0\.2  | 
|  texlive\-fnpct\-doc  |  noarch  |  texlive  |  svn57508\-59\.amzn2023\.0\.2  | 
|  texlive\-fnspe  |  noarch  |  texlive  |  svn45360\-59\.amzn2023\.0\.2  | 
|  texlive\-fntproof  |  noarch  |  texlive  |  svn20638\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fntproof\-doc  |  noarch  |  texlive  |  svn20638\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fnumprint  |  noarch  |  texlive  |  svn29173\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-fnumprint\-doc  |  noarch  |  texlive  |  svn29173\.1\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-foekfont  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-foekfont\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-foilhtml  |  noarch  |  texlive  |  svn21855\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-foilhtml\-doc  |  noarch  |  texlive  |  svn21855\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-foliono  |  noarch  |  texlive  |  svn58877\-59\.amzn2023\.0\.2  | 
|  texlive\-fonetika  |  noarch  |  texlive  |  svn21326\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fonetika\-doc  |  noarch  |  texlive  |  svn21326\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fontawesome  |  noarch  |  texlive  |  svn48145\-59\.amzn2023\.0\.2  | 
|  texlive\-fontawesome5  |  noarch  |  texlive  |  svn54517\-59\.amzn2023\.0\.2  | 
|  texlive\-fontawesome\-doc  |  noarch  |  texlive  |  svn48145\-59\.amzn2023\.0\.2  | 
|  texlive\-fontaxes  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-fontaxes\-doc  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-fontbook  |  noarch  |  texlive  |  svn23608\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fontbook\-doc  |  noarch  |  texlive  |  svn23608\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fontch  |  noarch  |  texlive  |  svn17859\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-font\-change  |  noarch  |  texlive  |  svn40403\-59\.amzn2023\.0\.2  | 
|  texlive\-font\-change\-doc  |  noarch  |  texlive  |  svn40403\-59\.amzn2023\.0\.2  | 
|  texlive\-font\-change\-xetex  |  noarch  |  texlive  |  svn40404\-59\.amzn2023\.0\.2  | 
|  texlive\-font\-change\-xetex\-doc  |  noarch  |  texlive  |  svn40404\-59\.amzn2023\.0\.2  | 
|  texlive\-fontch\-doc  |  noarch  |  texlive  |  svn17859\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fontmfizz  |  noarch  |  texlive  |  svn43546\-59\.amzn2023\.0\.2  | 
|  texlive\-fontmfizz\-doc  |  noarch  |  texlive  |  svn43546\-59\.amzn2023\.0\.2  | 
|  texlive\-fontname  |  noarch  |  texlive  |  svn53228\-59\.amzn2023\.0\.2  | 
|  texlive\-fontname\-doc  |  noarch  |  texlive  |  svn53228\-59\.amzn2023\.0\.2  | 
|  texlive\-fonts\-churchslavonic  |  noarch  |  texlive  |  svn56350\-59\.amzn2023\.0\.2  | 
|  texlive\-fonts\-churchslavonic\-doc  |  noarch  |  texlive  |  svn43121\-59\.amzn2023\.0\.2  | 
|  texlive\-fontsetup  |  noarch  |  texlive  |  svn59079\-59\.amzn2023\.0\.2  | 
|  texlive\-fontsize  |  noarch  |  texlive  |  svn58906\-59\.amzn2023\.0\.2  | 
|  texlive\-fontspec  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-fontspec\-doc  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-fonts\-tlwg  |  noarch  |  texlive  |  svn54994\-59\.amzn2023\.0\.2  | 
|  texlive\-fonts\-tlwg\-doc  |  noarch  |  texlive  |  svn54994\-59\.amzn2023\.0\.2  | 
|  texlive\-fonttable  |  noarch  |  texlive  |  svn44799\-59\.amzn2023\.0\.2  | 
|  texlive\-fonttable\-doc  |  noarch  |  texlive  |  svn44799\-59\.amzn2023\.0\.2  | 
|  texlive\-fontwrap  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fontwrap\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-footbib  |  noarch  |  texlive  |  svn17115\.2\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-footbib\-doc  |  noarch  |  texlive  |  svn17115\.2\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-footmisc  |  noarch  |  texlive  |  svn23330\.5\.5b\-59\.amzn2023\.0\.2  | 
|  texlive\-footmisc\-doc  |  noarch  |  texlive  |  svn23330\.5\.5b\-59\.amzn2023\.0\.2  | 
|  texlive\-footmisx  |  noarch  |  texlive  |  svn42621\-59\.amzn2023\.0\.2  | 
|  texlive\-footnotebackref  |  noarch  |  texlive  |  svn27034\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-footnotebackref\-doc  |  noarch  |  texlive  |  svn27034\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-footnotehyper  |  noarch  |  texlive  |  svn57618\-59\.amzn2023\.0\.2  | 
|  texlive\-footnotehyper\-doc  |  noarch  |  texlive  |  svn57618\-59\.amzn2023\.0\.2  | 
|  texlive\-footnoterange  |  noarch  |  texlive  |  svn52910\-59\.amzn2023\.0\.2  | 
|  texlive\-footnoterange\-doc  |  noarch  |  texlive  |  svn52910\-59\.amzn2023\.0\.2  | 
|  texlive\-footnpag  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-footnpag\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-forarray  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-forarray\-doc  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-foreign  |  noarch  |  texlive  |  svn27819\.2\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-foreign\-doc  |  noarch  |  texlive  |  svn27819\.2\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-forest  |  noarch  |  texlive  |  svn57398\-59\.amzn2023\.0\.2  | 
|  texlive\-forest\-doc  |  noarch  |  texlive  |  svn57398\-59\.amzn2023\.0\.2  | 
|  texlive\-forest\-quickstart\-doc  |  noarch  |  texlive  |  svn42503\-59\.amzn2023\.0\.2  | 
|  texlive\-forloop  |  noarch  |  texlive  |  svn15878\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-forloop\-doc  |  noarch  |  texlive  |  svn15878\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-formation\-latex\-ul  |  noarch  |  texlive  |  svn56714\-59\.amzn2023\.0\.2  | 
|  texlive\-formlett  |  noarch  |  texlive  |  svn21480\.2\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-formlett\-doc  |  noarch  |  texlive  |  svn21480\.2\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-forms16be  |  noarch  |  texlive  |  svn51305\-59\.amzn2023\.0\.2  | 
|  texlive\-formular  |  noarch  |  texlive  |  svn15878\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-formular\-doc  |  noarch  |  texlive  |  svn15878\.1\.0a\-59\.amzn2023\.0\.2  | 
|  texlive\-forum  |  noarch  |  texlive  |  svn56025\-59\.amzn2023\.0\.2  | 
|  texlive\-fouridx  |  noarch  |  texlive  |  svn32214\.2\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-fouridx\-doc  |  noarch  |  texlive  |  svn32214\.2\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-fourier  |  noarch  |  texlive  |  svn54090\-59\.amzn2023\.0\.2  | 
|  texlive\-fourier\-doc  |  noarch  |  texlive  |  svn54090\-59\.amzn2023\.0\.2  | 
|  texlive\-fouriernc  |  noarch  |  texlive  |  svn29646\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fouriernc\-doc  |  noarch  |  texlive  |  svn29646\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fp  |  noarch  |  texlive  |  svn49719\-59\.amzn2023\.0\.2  | 
|  texlive\-fp\-doc  |  noarch  |  texlive  |  svn49719\-59\.amzn2023\.0\.2  | 
|  texlive\-fpl  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-fpl\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-fragments  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fragments\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frame  |  noarch  |  texlive  |  svn18312\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-framed  |  noarch  |  texlive  |  svn26789\.0\.96\-59\.amzn2023\.0\.2  | 
|  texlive\-framed\-doc  |  noarch  |  texlive  |  svn26789\.0\.96\-59\.amzn2023\.0\.2  | 
|  texlive\-frame\-doc  |  noarch  |  texlive  |  svn18312\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-francais\-bst  |  noarch  |  texlive  |  svn38922\-59\.amzn2023\.0\.2  | 
|  texlive\-francais\-bst\-doc  |  noarch  |  texlive  |  svn38922\-59\.amzn2023\.0\.2  | 
|  texlive\-frankenstein  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frankenstein\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frcursive  |  noarch  |  texlive  |  svn24559\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frcursive\-doc  |  noarch  |  texlive  |  svn24559\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frederika2016  |  noarch  |  texlive  |  svn42157\-59\.amzn2023\.0\.2  | 
|  texlive\-frege  |  noarch  |  texlive  |  svn27417\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-frege\-doc  |  noarch  |  texlive  |  svn27417\.1\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-frenchmath  |  noarch  |  texlive  |  svn56847\-59\.amzn2023\.0\.2  | 
|  texlive\-frimurer  |  noarch  |  texlive  |  svn56704\-59\.amzn2023\.0\.2  | 
|  texlive\-frletter  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frletter\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-frontespizio  |  noarch  |  texlive  |  svn24054\.1\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-frontespizio\-doc  |  noarch  |  texlive  |  svn24054\.1\.4a\-59\.amzn2023\.0\.2  | 
|  texlive\-froufrou  |  noarch  |  texlive  |  svn59103\-59\.amzn2023\.0\.2  | 
|  texlive\-frpseudocode  |  noarch  |  texlive  |  svn56088\-59\.amzn2023\.0\.2  | 
|  texlive\-ftcap  |  noarch  |  texlive  |  svn17275\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ftcap\-doc  |  noarch  |  texlive  |  svn17275\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ftc\-notebook  |  noarch  |  texlive  |  svn50043\-59\.amzn2023\.0\.2  | 
|  texlive\-ftnxtra  |  noarch  |  texlive  |  svn29652\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-ftnxtra\-doc  |  noarch  |  texlive  |  svn29652\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fullblck  |  noarch  |  texlive  |  svn25434\.1\.03\-59\.amzn2023\.0\.2  | 
|  texlive\-fullblck\-doc  |  noarch  |  texlive  |  svn25434\.1\.03\-59\.amzn2023\.0\.2  | 
|  texlive\-fullminipage  |  noarch  |  texlive  |  svn34545\.0\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fullminipage\-doc  |  noarch  |  texlive  |  svn34545\.0\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fullwidth  |  noarch  |  texlive  |  svn24684\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-fullwidth\-doc  |  noarch  |  texlive  |  svn24684\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-functan  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-functan\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fundus\-calligra  |  noarch  |  texlive  |  svn26018\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fundus\-calligra\-doc  |  noarch  |  texlive  |  svn26018\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fundus\-cyr  |  noarch  |  texlive  |  svn26019\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fundus\-sueterlin  |  noarch  |  texlive  |  svn26030\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fundus\-sueterlin\-doc  |  noarch  |  texlive  |  svn26030\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-fvextra  |  noarch  |  texlive  |  svn49947\-59\.amzn2023\.0\.2  | 
|  texlive\-fwlw  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-fwlw\-doc  |  noarch  |  texlive  |  svn29803\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gaceta  |  noarch  |  texlive  |  svn15878\.1\.06\-59\.amzn2023\.0\.2  | 
|  texlive\-gaceta\-doc  |  noarch  |  texlive  |  svn15878\.1\.06\-59\.amzn2023\.0\.2  | 
|  texlive\-galois  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-galois\-doc  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-gamebook  |  noarch  |  texlive  |  svn24714\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gamebook\-doc  |  noarch  |  texlive  |  svn24714\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gammas  |  noarch  |  texlive  |  svn56403\-59\.amzn2023\.0\.2  | 
|  texlive\-garamond\-libre  |  noarch  |  texlive  |  svn55166\-59\.amzn2023\.0\.2  | 
|  texlive\-garamond\-math  |  noarch  |  texlive  |  svn52820\-59\.amzn2023\.0\.2  | 
|  texlive\-garrigues  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-garrigues\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-garuda\-c90  |  noarch  |  texlive  |  svn37677\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gastex  |  noarch  |  texlive  |  svn58505\-59\.amzn2023\.0\.2  | 
|  texlive\-gastex\-doc  |  noarch  |  texlive  |  svn58505\-59\.amzn2023\.0\.2  | 
|  texlive\-gatech\-thesis  |  noarch  |  texlive  |  svn19886\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-gatech\-thesis\-doc  |  noarch  |  texlive  |  svn19886\.1\.8\-59\.amzn2023\.0\.2  | 
|  texlive\-gates  |  noarch  |  texlive  |  svn29803\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gates\-doc  |  noarch  |  texlive  |  svn29803\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gatherenum  |  noarch  |  texlive  |  svn52209\-59\.amzn2023\.0\.2  | 
|  texlive\-gauss  |  noarch  |  texlive  |  svn32934\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gauss\-doc  |  noarch  |  texlive  |  svn32934\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gb4e  |  noarch  |  texlive  |  svn19216\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gb4e\-doc  |  noarch  |  texlive  |  svn19216\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-g\-brief  |  noarch  |  texlive  |  svn50415\-59\.amzn2023\.0\.2  | 
|  texlive\-g\-brief\-doc  |  noarch  |  texlive  |  svn50415\-59\.amzn2023\.0\.2  | 
|  texlive\-gbt7714  |  noarch  |  texlive  |  svn57157\-59\.amzn2023\.0\.2  | 
|  texlive\-gcard  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gcard\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gchords  |  noarch  |  texlive  |  svn29803\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-gchords\-doc  |  noarch  |  texlive  |  svn29803\.1\.20\-59\.amzn2023\.0\.2  | 
|  texlive\-gcite  |  noarch  |  texlive  |  svn15878\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gcite\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gckanbun  |  noarch  |  texlive  |  svn58754\-59\.amzn2023\.0\.2  | 
|  texlive\-gender  |  noarch  |  texlive  |  svn36464\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gender\-doc  |  noarch  |  texlive  |  svn36464\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-genealogy  |  noarch  |  texlive  |  svn25112\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-genealogy\-doc  |  noarch  |  texlive  |  svn25112\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-genealogytree  |  noarch  |  texlive  |  svn55978\-59\.amzn2023\.0\.2  | 
|  texlive\-genealogytree\-doc  |  noarch  |  texlive  |  svn55978\-59\.amzn2023\.0\.2  | 
|  texlive\-gene\-logic  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-gene\-logic\-doc  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-genmpage  |  noarch  |  texlive  |  svn15878\.0\.3\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-genmpage\-doc  |  noarch  |  texlive  |  svn15878\.0\.3\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gentium\-tug  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-gentium\-tug\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-gentle\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gentombow  |  noarch  |  texlive  |  svn56665\-59\.amzn2023\.0\.2  | 
|  texlive\-geometry  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-geometry\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-german  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-german\-doc  |  noarch  |  texlive  |  svn42428\-59\.amzn2023\.0\.2  | 
|  texlive\-germbib  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-germbib\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-germkorr  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-germkorr\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-geschichtsfrkl  |  noarch  |  texlive  |  svn42121\-59\.amzn2023\.0\.2  | 
|  texlive\-geschichtsfrkl\-doc  |  noarch  |  texlive  |  svn42121\-59\.amzn2023\.0\.2  | 
|  texlive\-getfiledate  |  noarch  |  texlive  |  svn16189\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-getfiledate\-doc  |  noarch  |  texlive  |  svn16189\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-getitems  |  noarch  |  texlive  |  svn39365\-59\.amzn2023\.0\.2  | 
|  texlive\-getitems\-doc  |  noarch  |  texlive  |  svn39365\-59\.amzn2023\.0\.2  | 
|  texlive\-getoptk  |  noarch  |  texlive  |  svn23567\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-getoptk\-doc  |  noarch  |  texlive  |  svn23567\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gettitlestring  |  noarch  |  texlive  |  svn53170\-59\.amzn2023\.0\.2  | 
|  texlive\-gfnotation  |  noarch  |  texlive  |  svn37156\.2\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-gfnotation\-doc  |  noarch  |  texlive  |  svn37156\.2\.9\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsartemisia  |  noarch  |  texlive  |  svn19469\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsartemisia\-doc  |  noarch  |  texlive  |  svn19469\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsbaskerville  |  noarch  |  texlive  |  svn19440\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsbaskerville\-doc  |  noarch  |  texlive  |  svn19440\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsbodoni  |  noarch  |  texlive  |  svn28484\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsbodoni\-doc  |  noarch  |  texlive  |  svn28484\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-gfscomplutum  |  noarch  |  texlive  |  svn19469\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfscomplutum\-doc  |  noarch  |  texlive  |  svn19469\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsdidot  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsdidotclassic  |  noarch  |  texlive  |  svn52778\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsdidot\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsneohellenic  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsneohellenic\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsneohellenicmath  |  noarch  |  texlive  |  svn52570\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsporson  |  noarch  |  texlive  |  svn18651\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-gfsporson\-doc  |  noarch  |  texlive  |  svn18651\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-gfssolomos  |  noarch  |  texlive  |  svn18651\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gfssolomos\-doc  |  noarch  |  texlive  |  svn18651\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ghab  |  noarch  |  texlive  |  svn29803\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-ghab\-doc  |  noarch  |  texlive  |  svn29803\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-ghsystem  |  noarch  |  texlive  |  svn53822\-59\.amzn2023\.0\.2  | 
|  texlive\-ghsystem\-doc  |  noarch  |  texlive  |  svn53822\-59\.amzn2023\.0\.2  | 
|  texlive\-gillcm  |  noarch  |  texlive  |  svn19878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gillcm\-doc  |  noarch  |  texlive  |  svn19878\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gillius  |  noarch  |  texlive  |  svn32068\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gillius\-doc  |  noarch  |  texlive  |  svn32068\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gincltex  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-gincltex\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-gindex  |  noarch  |  texlive  |  svn52311\-59\.amzn2023\.0\.2  | 
|  texlive\-ginpenc  |  noarch  |  texlive  |  svn24980\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ginpenc\-doc  |  noarch  |  texlive  |  svn24980\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gitfile\-info  |  noarch  |  texlive  |  svn51928\-59\.amzn2023\.0\.2  | 
|  texlive\-gitinfo  |  noarch  |  texlive  |  svn34049\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gitinfo2  |  noarch  |  texlive  |  svn38913\-59\.amzn2023\.0\.2  | 
|  texlive\-gitinfo2\-doc  |  noarch  |  texlive  |  svn38913\-59\.amzn2023\.0\.2  | 
|  texlive\-gitinfo\-doc  |  noarch  |  texlive  |  svn34049\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gitlog  |  noarch  |  texlive  |  svn38932\-59\.amzn2023\.0\.2  | 
|  texlive\-gitlog\-doc  |  noarch  |  texlive  |  svn38932\-59\.amzn2023\.0\.2  | 
|  texlive\-gitver  |  noarch  |  texlive  |  svn56810\-59\.amzn2023\.0\.2  | 
|  texlive\-globalvals  |  noarch  |  texlive  |  svn49962\-59\.amzn2023\.0\.2  | 
|  texlive\-glosmathtools  |  noarch  |  texlive  |  svn55920\-59\.amzn2023\.0\.2  | 
|  texlive\-gloss  |  noarch  |  texlive  |  svn15878\.1\.5\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-danish  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-danish\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-dutch  |  noarch  |  texlive  |  svn35685\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-dutch\-doc  |  noarch  |  texlive  |  svn35685\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-english  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-english\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-estonian  |  noarch  |  texlive  |  svn49928\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-extra  |  noarch  |  texlive  |  svn54688\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-extra\-doc  |  noarch  |  texlive  |  svn54688\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-finnish  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-french  |  noarch  |  texlive  |  svn42873\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-french\-doc  |  noarch  |  texlive  |  svn42873\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-german  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-german\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-irish  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-irish\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-italian  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-italian\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-magyar  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-magyar\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-nynorsk  |  noarch  |  texlive  |  svn55189\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-polish  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-polish\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-portuges  |  noarch  |  texlive  |  svn36064\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-portuges\-doc  |  noarch  |  texlive  |  svn36064\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-serbian  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-serbian\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-slovene  |  noarch  |  texlive  |  svn51211\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-spanish  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-glossaries\-spanish\-doc  |  noarch  |  texlive  |  svn35665\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gloss\-doc  |  noarch  |  texlive  |  svn15878\.1\.5\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gloss\-occitan  |  noarch  |  texlive  |  svn52593\-59\.amzn2023\.0\.2  | 
|  texlive\-gloss\-occitan\-doc  |  noarch  |  texlive  |  svn52593\-59\.amzn2023\.0\.2  | 
|  texlive\-gmdoc  |  noarch  |  texlive  |  svn21292\.0\.993\-59\.amzn2023\.0\.2  | 
|  texlive\-gmdoc\-doc  |  noarch  |  texlive  |  svn21292\.0\.993\-59\.amzn2023\.0\.2  | 
|  texlive\-gmdoc\-enhance  |  noarch  |  texlive  |  svn15878\.v0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gmdoc\-enhance\-doc  |  noarch  |  texlive  |  svn15878\.v0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gmiflink  |  noarch  |  texlive  |  svn15878\.v0\.97\-59\.amzn2023\.0\.2  | 
|  texlive\-gmiflink\-doc  |  noarch  |  texlive  |  svn15878\.v0\.97\-59\.amzn2023\.0\.2  | 
|  texlive\-gmp  |  noarch  |  texlive  |  svn21691\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gmp\-doc  |  noarch  |  texlive  |  svn21691\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gmutils  |  noarch  |  texlive  |  svn24287\.v0\.996\-59\.amzn2023\.0\.2  | 
|  texlive\-gmutils\-doc  |  noarch  |  texlive  |  svn24287\.v0\.996\-59\.amzn2023\.0\.2  | 
|  texlive\-gmverb  |  noarch  |  texlive  |  svn24288\.v0\.98\-59\.amzn2023\.0\.2  | 
|  texlive\-gmverb\-doc  |  noarch  |  texlive  |  svn24288\.v0\.98\-59\.amzn2023\.0\.2  | 
|  texlive\-gmverse  |  noarch  |  texlive  |  svn29803\.v0\.73\-59\.amzn2023\.0\.2  | 
|  texlive\-gmverse\-doc  |  noarch  |  texlive  |  svn29803\.v0\.73\-59\.amzn2023\.0\.2  | 
|  texlive\-gnu\-freefont  |  noarch  |  texlive  |  svn29349\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gnu\-freefont\-doc  |  noarch  |  texlive  |  svn29349\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gnuplottex  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-gnuplottex\-doc  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-go  |  noarch  |  texlive  |  svn28628\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gobble  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-gobble\-doc  |  noarch  |  texlive  |  svn49608\-59\.amzn2023\.0\.2  | 
|  texlive\-go\-doc  |  noarch  |  texlive  |  svn28628\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gofonts  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-gost  |  noarch  |  texlive  |  svn57616\-59\.amzn2023\.0\.2  | 
|  texlive\-gost\-doc  |  noarch  |  texlive  |  svn57616\-59\.amzn2023\.0\.2  | 
|  texlive\-gothic  |  noarch  |  texlive  |  svn49869\-59\.amzn2023\.0\.2  | 
|  texlive\-gothic\-doc  |  noarch  |  texlive  |  svn49869\-59\.amzn2023\.0\.2  | 
|  texlive\-gotoh  |  noarch  |  texlive  |  svn44764\-59\.amzn2023\.0\.2  | 
|  texlive\-grabbox  |  noarch  |  texlive  |  svn51052\-59\.amzn2023\.0\.2  | 
|  texlive\-gradientframe  |  noarch  |  texlive  |  svn21387\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gradientframe\-doc  |  noarch  |  texlive  |  svn21387\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-gradstudentresume  |  noarch  |  texlive  |  svn38832\-59\.amzn2023\.0\.2  | 
|  texlive\-gradstudentresume\-doc  |  noarch  |  texlive  |  svn38832\-59\.amzn2023\.0\.2  | 
|  texlive\-grafcet  |  noarch  |  texlive  |  svn22509\.1\.3\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-grafcet\-doc  |  noarch  |  texlive  |  svn22509\.1\.3\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-grant  |  noarch  |  texlive  |  svn56852\-59\.amzn2023\.0\.2  | 
|  texlive\-graph35  |  noarch  |  texlive  |  svn47522\-59\.amzn2023\.0\.2  | 
|  texlive\-graphbox  |  noarch  |  texlive  |  svn46360\-59\.amzn2023\.0\.2  | 
|  texlive\-graphbox\-doc  |  noarch  |  texlive  |  svn46360\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics  |  noarch  |  texlive  |  svn56514\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-cfg  |  noarch  |  texlive  |  svn41448\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-cfg\-doc  |  noarch  |  texlive  |  svn41448\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-def  |  noarch  |  texlive  |  svn58539\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-doc  |  noarch  |  texlive  |  svn56514\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-pln  |  noarch  |  texlive  |  svn56823\-59\.amzn2023\.0\.2  | 
|  texlive\-graphics\-pln\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-graphicxbox  |  noarch  |  texlive  |  svn32630\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-graphicxbox\-doc  |  noarch  |  texlive  |  svn32630\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-graphicxpsd  |  noarch  |  texlive  |  svn57341\-59\.amzn2023\.0\.2  | 
|  texlive\-graphicx\-psmin  |  noarch  |  texlive  |  svn56931\-59\.amzn2023\.0\.2  | 
|  texlive\-graphicx\-psmin\-doc  |  noarch  |  texlive  |  svn56931\-59\.amzn2023\.0\.2  | 
|  texlive\-graphpaper  |  noarch  |  texlive  |  svn58661\-59\.amzn2023\.0\.2  | 
|  texlive\-graphviz  |  noarch  |  texlive  |  svn31517\.0\.94\-59\.amzn2023\.0\.2  | 
|  texlive\-graphviz\-doc  |  noarch  |  texlive  |  svn31517\.0\.94\-59\.amzn2023\.0\.2  | 
|  texlive\-grayhints  |  noarch  |  texlive  |  svn49052\-59\.amzn2023\.0\.2  | 
|  texlive\-greekdates  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-greekdates\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-greek\-fontenc  |  noarch  |  texlive  |  svn56851\-59\.amzn2023\.0\.2  | 
|  texlive\-greek\-fontenc\-doc  |  noarch  |  texlive  |  svn56851\-59\.amzn2023\.0\.2  | 
|  texlive\-greek\-inputenc  |  noarch  |  texlive  |  svn51612\-59\.amzn2023\.0\.2  | 
|  texlive\-greek\-inputenc\-doc  |  noarch  |  texlive  |  svn51612\-59\.amzn2023\.0\.2  | 
|  texlive\-greektex  |  noarch  |  texlive  |  svn28327\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-greektex\-doc  |  noarch  |  texlive  |  svn28327\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-greektonoi  |  noarch  |  texlive  |  svn39419\-59\.amzn2023\.0\.2  | 
|  texlive\-greektonoi\-doc  |  noarch  |  texlive  |  svn39419\-59\.amzn2023\.0\.2  | 
|  texlive\-greenpoint  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-greenpoint\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grfext  |  noarch  |  texlive  |  svn53024\-59\.amzn2023\.0\.2  | 
|  texlive\-grffile  |  noarch  |  texlive  |  svn52756\-59\.amzn2023\.0\.2  | 
|  texlive\-grfpaste  |  noarch  |  texlive  |  svn17354\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-grfpaste\-doc  |  noarch  |  texlive  |  svn17354\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-grid  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grid\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gridpapers  |  noarch  |  texlive  |  svn58723\-59\.amzn2023\.0\.2  | 
|  texlive\-gridset  |  noarch  |  texlive  |  svn53762\-59\.amzn2023\.0\.2  | 
|  texlive\-gridset\-doc  |  noarch  |  texlive  |  svn53762\-59\.amzn2023\.0\.2  | 
|  texlive\-gridslides  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-grid\-system  |  noarch  |  texlive  |  svn32981\.0\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grid\-system\-doc  |  noarch  |  texlive  |  svn32981\.0\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grotesq  |  noarch  |  texlive  |  svn35859\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grotesq\-doc  |  noarch  |  texlive  |  svn35859\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-grundgesetze  |  noarch  |  texlive  |  svn58997\-59\.amzn2023\.0\.2  | 
|  texlive\-grundgesetze\-doc  |  noarch  |  texlive  |  svn58997\-59\.amzn2023\.0\.2  | 
|  texlive\-GS1  |  noarch  |  texlive  |  svn44822\-59\.amzn2023\.0\.2  | 
|  texlive\-GS1\-doc  |  noarch  |  texlive  |  svn44822\-59\.amzn2023\.0\.2  | 
|  texlive\-gsemthesis  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-gsemthesis\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-gtl  |  noarch  |  texlive  |  svn49527\-59\.amzn2023\.0\.2  | 
|  texlive\-gtl\-doc  |  noarch  |  texlive  |  svn49527\-59\.amzn2023\.0\.2  | 
|  texlive\-gtrcrd  |  noarch  |  texlive  |  svn32484\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gtrcrd\-doc  |  noarch  |  texlive  |  svn32484\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-gtrlib\-largetrees  |  noarch  |  texlive  |  svn49062\-59\.amzn2023\.0\.2  | 
|  texlive\-gu  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-gudea  |  noarch  |  texlive  |  svn57359\-59\.amzn2023\.0\.2  | 
|  texlive\-gu\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-guide\-to\-latex\-doc  |  noarch  |  texlive  |  svn45712\-59\.amzn2023\.0\.2  | 
|  texlive\-guitar  |  noarch  |  texlive  |  svn32258\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-guitarchordschemes  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-guitarchordschemes\-doc  |  noarch  |  texlive  |  svn41880\-59\.amzn2023\.0\.2  | 
|  texlive\-guitar\-doc  |  noarch  |  texlive  |  svn32258\.1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-guitartabs  |  noarch  |  texlive  |  svn48102\-59\.amzn2023\.0\.2  | 
|  texlive\-guitlogo  |  noarch  |  texlive  |  svn55741\-59\.amzn2023\.0\.2  | 
|  texlive\-guitlogo\-doc  |  noarch  |  texlive  |  svn55741\-59\.amzn2023\.0\.2  | 
|  texlive\-gustlib  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-gustlib\-doc  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-gustprog\-doc  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-gzt  |  noarch  |  texlive  |  svn57765\-59\.amzn2023\.0\.2  | 
|  texlive\-gzt\-doc  |  noarch  |  texlive  |  svn57765\-59\.amzn2023\.0\.2  | 
|  texlive\-h2020proposal  |  noarch  |  texlive  |  svn38428\-59\.amzn2023\.0\.2  | 
|  texlive\-h2020proposal\-doc  |  noarch  |  texlive  |  svn38428\-59\.amzn2023\.0\.2  | 
|  texlive\-hackthefootline  |  noarch  |  texlive  |  svn46494\-59\.amzn2023\.0\.2  | 
|  texlive\-hacm  |  noarch  |  texlive  |  svn27671\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-hacm\-doc  |  noarch  |  texlive  |  svn27671\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-hagenberg\-thesis  |  noarch  |  texlive  |  svn56798\-59\.amzn2023\.0\.2  | 
|  texlive\-halloweenmath  |  noarch  |  texlive  |  svn52602\-59\.amzn2023\.0\.2  | 
|  texlive\-handin  |  noarch  |  texlive  |  svn48255\-59\.amzn2023\.0\.2  | 
|  texlive\-handout  |  noarch  |  texlive  |  svn43962\-59\.amzn2023\.0\.2  | 
|  texlive\-handout\-doc  |  noarch  |  texlive  |  svn43962\-59\.amzn2023\.0\.2  | 
|  texlive\-hands  |  noarch  |  texlive  |  svn13293\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hang  |  noarch  |  texlive  |  svn43280\-59\.amzn2023\.0\.2  | 
|  texlive\-hang\-doc  |  noarch  |  texlive  |  svn43280\-59\.amzn2023\.0\.2  | 
|  texlive\-hanging  |  noarch  |  texlive  |  svn15878\.1\.2b\-59\.amzn2023\.0\.2  | 
|  texlive\-hanging\-doc  |  noarch  |  texlive  |  svn15878\.1\.2b\-59\.amzn2023\.0\.2  | 
|  texlive\-hanoi  |  noarch  |  texlive  |  svn25019\.20120101\-59\.amzn2023\.0\.2  | 
|  texlive\-happy4th\-doc  |  noarch  |  texlive  |  svn25020\.20120102\-59\.amzn2023\.0\.2  | 
|  texlive\-HA\-prosper  |  noarch  |  texlive  |  svn15878\.4\.21\-59\.amzn2023\.0\.2  | 
|  texlive\-HA\-prosper\-doc  |  noarch  |  texlive  |  svn15878\.4\.21\-59\.amzn2023\.0\.2  | 
|  texlive\-har2nat  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-har2nat\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-haranoaji  |  noarch  |  texlive  |  svn58830\-59\.amzn2023\.0\.2  | 
|  texlive\-haranoaji\-extra  |  noarch  |  texlive  |  svn58831\-59\.amzn2023\.0\.2  | 
|  texlive\-hardwrap  |  noarch  |  texlive  |  svn21396\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-hardwrap\-doc  |  noarch  |  texlive  |  svn21396\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-harmony  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harmony\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harnon\-cv  |  noarch  |  texlive  |  svn26543\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harnon\-cv\-doc  |  noarch  |  texlive  |  svn26543\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harpoon  |  noarch  |  texlive  |  svn21327\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harpoon\-doc  |  noarch  |  texlive  |  svn21327\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harvard  |  noarch  |  texlive  |  svn15878\.2\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-harvard\-doc  |  noarch  |  texlive  |  svn15878\.2\.0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-harveyballs  |  noarch  |  texlive  |  svn32003\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-harveyballs\-doc  |  noarch  |  texlive  |  svn32003\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-harvmac  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-harvmac\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hatching  |  noarch  |  texlive  |  svn23818\.0\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-hatching\-doc  |  noarch  |  texlive  |  svn23818\.0\.11\-59\.amzn2023\.0\.2  | 
|  texlive\-hausarbeit\-jura  |  noarch  |  texlive  |  svn56070\-59\.amzn2023\.0\.2  | 
|  texlive\-hausarbeit\-jura\-doc  |  noarch  |  texlive  |  svn56070\-59\.amzn2023\.0\.2  | 
|  texlive\-havannah  |  noarch  |  texlive  |  svn36348\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-havannah\-doc  |  noarch  |  texlive  |  svn36348\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hc\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hecthese  |  noarch  |  texlive  |  svn56181\-59\.amzn2023\.0\.2  | 
|  texlive\-helmholtz\-ellis\-ji\-notation  |  noarch  |  texlive  |  svn55213\-59\.amzn2023\.0\.2  | 
|  texlive\-helvetic  |  noarch  |  texlive  |  svn31835\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hep  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hep\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hepnames  |  noarch  |  texlive  |  svn35722\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hepnames\-doc  |  noarch  |  texlive  |  svn35722\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hep\-paper  |  noarch  |  texlive  |  svn57045\-59\.amzn2023\.0\.2  | 
|  texlive\-hepparticles  |  noarch  |  texlive  |  svn35723\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hepparticles\-doc  |  noarch  |  texlive  |  svn35723\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hepthesis  |  noarch  |  texlive  |  svn46054\-59\.amzn2023\.0\.2  | 
|  texlive\-hepthesis\-doc  |  noarch  |  texlive  |  svn46054\-59\.amzn2023\.0\.2  | 
|  texlive\-hepunits  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-hepunits\-doc  |  noarch  |  texlive  |  svn54758\-59\.amzn2023\.0\.2  | 
|  texlive\-here  |  noarch  |  texlive  |  svn16135\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-here\-doc  |  noarch  |  texlive  |  svn16135\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-he\-she  |  noarch  |  texlive  |  svn41359\-59\.amzn2023\.0\.2  | 
|  texlive\-he\-she\-doc  |  noarch  |  texlive  |  svn41359\-59\.amzn2023\.0\.2  | 
|  texlive\-heuristica  |  noarch  |  texlive  |  svn51362\-59\.amzn2023\.0\.2  | 
|  texlive\-heuristica\-doc  |  noarch  |  texlive  |  svn51362\-59\.amzn2023\.0\.2  | 
|  texlive\-hexgame  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hexgame\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hfbright  |  noarch  |  texlive  |  svn29349\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hfbright\-doc  |  noarch  |  texlive  |  svn29349\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hfoldsty  |  noarch  |  texlive  |  svn29349\.1\.15\-59\.amzn2023\.0\.2  | 
|  texlive\-hfoldsty\-doc  |  noarch  |  texlive  |  svn29349\.1\.15\-59\.amzn2023\.0\.2  | 
|  texlive\-hf\-tikz  |  noarch  |  texlive  |  svn34733\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-hf\-tikz\-doc  |  noarch  |  texlive  |  svn34733\.0\.3a\-59\.amzn2023\.0\.2  | 
|  texlive\-hhtensor  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-hhtensor\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-highlightlatex  |  noarch  |  texlive  |  svn58392\-59\.amzn2023\.0\.2  | 
|  texlive\-hindawi\-latex\-template  |  noarch  |  texlive  |  svn57757\-59\.amzn2023\.0\.2  | 
|  texlive\-hindmadurai  |  noarch  |  texlive  |  svn57360\-59\.amzn2023\.0\.2  | 
|  texlive\-histogr  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-histogr\-doc  |  noarch  |  texlive  |  svn15878\.1\.01\-59\.amzn2023\.0\.2  | 
|  texlive\-historische\-zeitschrift  |  noarch  |  texlive  |  svn42635\-59\.amzn2023\.0\.2  | 
|  texlive\-historische\-zeitschrift\-doc  |  noarch  |  texlive  |  svn42635\-59\.amzn2023\.0\.2  | 
|  texlive\-hitec  |  noarch  |  texlive  |  svn15878\.0\.0\_beta\_\-59\.amzn2023\.0\.2  | 
|  texlive\-hitec\-doc  |  noarch  |  texlive  |  svn15878\.0\.0\_beta\_\-59\.amzn2023\.0\.2  | 
|  texlive\-hithesis  |  noarch  |  texlive  |  svn53362\-59\.amzn2023\.0\.2  | 
|  texlive\-hitreport  |  noarch  |  texlive  |  svn58357\-59\.amzn2023\.0\.2  | 
|  texlive\-hitszbeamer  |  noarch  |  texlive  |  svn54381\-59\.amzn2023\.0\.2  | 
|  texlive\-hitszthesis  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-hletter  |  noarch  |  texlive  |  svn30002\.4\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-hletter\-doc  |  noarch  |  texlive  |  svn30002\.4\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-hlist  |  noarch  |  texlive  |  svn44983\-59\.amzn2023\.0\.2  | 
|  texlive\-hmtrump  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-hobby  |  noarch  |  texlive  |  svn44474\-59\.amzn2023\.0\.2  | 
|  texlive\-hobby\-doc  |  noarch  |  texlive  |  svn44474\-59\.amzn2023\.0\.2  | 
|  texlive\-hobete  |  noarch  |  texlive  |  svn27036\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hobete\-doc  |  noarch  |  texlive  |  svn27036\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hobsub  |  noarch  |  texlive  |  svn52810\-59\.amzn2023\.0\.2  | 
|  texlive\-hologo  |  noarch  |  texlive  |  svn53048\-59\.amzn2023\.0\.2  | 
|  texlive\-hook\-pre\-commit\-pkg\-doc  |  noarch  |  texlive  |  svn41378\-59\.amzn2023\.0\.2  | 
|  texlive\-hopatch  |  noarch  |  texlive  |  svn56106\-59\.amzn2023\.0\.2  | 
|  texlive\-horoscop  |  noarch  |  texlive  |  svn56021\-59\.amzn2023\.0\.2  | 
|  texlive\-horoscop\-doc  |  noarch  |  texlive  |  svn30530\.0\.92\-59\.amzn2023\.0\.2  | 
|  texlive\-hpsdiss  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hpsdiss\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hrefhide  |  noarch  |  texlive  |  svn22255\.1\.0f\-59\.amzn2023\.0\.2  | 
|  texlive\-hrefhide\-doc  |  noarch  |  texlive  |  svn22255\.1\.0f\-59\.amzn2023\.0\.2  | 
|  texlive\-hrlatex  |  noarch  |  texlive  |  svn18020\.0\.23\-59\.amzn2023\.0\.2  | 
|  texlive\-hrlatex\-doc  |  noarch  |  texlive  |  svn18020\.0\.23\-59\.amzn2023\.0\.2  | 
|  texlive\-huawei  |  noarch  |  texlive  |  svn59328\-59\.amzn2023\.0\.2  | 
|  texlive\-hu\-berlin\-bundle  |  noarch  |  texlive  |  svn57580\-59\.amzn2023\.0\.2  | 
|  texlive\-hulipsum  |  noarch  |  texlive  |  svn56848\-59\.amzn2023\.0\.2  | 
|  texlive\-hustthesis  |  noarch  |  texlive  |  svn42547\-59\.amzn2023\.0\.2  | 
|  texlive\-hvarabic  |  noarch  |  texlive  |  svn55643\-59\.amzn2023\.0\.2  | 
|  texlive\-hvfloat  |  noarch  |  texlive  |  svn59104\-59\.amzn2023\.0\.2  | 
|  texlive\-hvfloat\-doc  |  noarch  |  texlive  |  svn59104\-59\.amzn2023\.0\.2  | 
|  texlive\-hvindex  |  noarch  |  texlive  |  svn46051\-59\.amzn2023\.0\.2  | 
|  texlive\-hvindex\-doc  |  noarch  |  texlive  |  svn46051\-59\.amzn2023\.0\.2  | 
|  texlive\-hvqrurl  |  noarch  |  texlive  |  svn52993\-59\.amzn2023\.0\.2  | 
|  texlive\-hycolor  |  noarch  |  texlive  |  svn53584\-59\.amzn2023\.0\.2  | 
|  texlive\-hypdestopt  |  noarch  |  texlive  |  svn56253\-59\.amzn2023\.0\.2  | 
|  texlive\-hypdvips  |  noarch  |  texlive  |  svn53197\-59\.amzn2023\.0\.2  | 
|  texlive\-hypdvips\-doc  |  noarch  |  texlive  |  svn53197\-59\.amzn2023\.0\.2  | 
|  texlive\-hyper  |  noarch  |  texlive  |  svn17357\.4\.2d\-59\.amzn2023\.0\.2  | 
|  texlive\-hyperbar  |  noarch  |  texlive  |  svn48147\-59\.amzn2023\.0\.2  | 
|  texlive\-hyper\-doc  |  noarch  |  texlive  |  svn17357\.4\.2d\-59\.amzn2023\.0\.2  | 
|  texlive\-hypernat  |  noarch  |  texlive  |  svn17358\.1\.0b\-59\.amzn2023\.0\.2  | 
|  texlive\-hypernat\-doc  |  noarch  |  texlive  |  svn17358\.1\.0b\-59\.amzn2023\.0\.2  | 
|  texlive\-hyperref  |  noarch  |  texlive  |  svn58024\-59\.amzn2023\.0\.2  | 
|  texlive\-hyperref\-doc  |  noarch  |  texlive  |  svn58024\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-afrikaans  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-ancientgreek  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-arabic  |  noarch  |  texlive  |  svn54568\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-armenian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphenat  |  noarch  |  texlive  |  svn15878\.2\.3c\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphenat\-doc  |  noarch  |  texlive  |  svn15878\.2\.3c\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-base  |  noarch  |  texlive  |  svn58630\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-basque  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-belarusian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-bulgarian  |  noarch  |  texlive  |  svn58685\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-catalan  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-chinese  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-churchslavonic  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-coptic  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-croatian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-czech  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-danish  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-dutch  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-english  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-esperanto  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-estonian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-ethiopic  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphenex  |  noarch  |  texlive  |  svn57387\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-farsi  |  noarch  |  texlive  |  svn54568\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-finnish  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-french  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-friulan  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-galician  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-georgian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-german  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-greek  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-greek\-doc  |  noarch  |  texlive  |  svn51186\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-hungarian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-hungarian\-doc  |  noarch  |  texlive  |  svn54568\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-icelandic  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-indic  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-indonesian  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-interlingua  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-irish  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-italian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-kurmanji  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-latin  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-latvian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-lithuanian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-macedonian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-mongolian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-norwegian  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-occitan  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-piedmontese  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-polish  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-portuguese  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-romanian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-romansh  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-russian  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-sanskrit  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-sanskrit\-doc  |  noarch  |  texlive  |  svn54568\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-serbian  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-slovak  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-slovenian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-spanish  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-spanish\-doc  |  noarch  |  texlive  |  svn54568\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-swedish  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-thai  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-turkish  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-turkmen  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-ukrainian  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-uppersorbian  |  noarch  |  texlive  |  svn58609\-59\.amzn2023\.0\.2  | 
|  texlive\-hyphen\-welsh  |  noarch  |  texlive  |  svn58652\-59\.amzn2023\.0\.2  | 
|  texlive\-hyph\-utf8  |  noarch  |  texlive  |  svn58619\-59\.amzn2023\.0\.2  | 
|  texlive\-hyph\-utf8\-doc  |  noarch  |  texlive  |  svn58619\-59\.amzn2023\.0\.2  | 
|  texlive\-hyplain  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-hyplain\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ibarra  |  noarch  |  texlive  |  svn55820\-59\.amzn2023\.0\.2  | 
|  texlive\-ibycus\-babel  |  noarch  |  texlive  |  svn15878\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ibycus\-babel\-doc  |  noarch  |  texlive  |  svn15878\.3\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ibygrk  |  noarch  |  texlive  |  svn15878\.4\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-ibygrk\-doc  |  noarch  |  texlive  |  svn15878\.4\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-icite  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-icsv  |  noarch  |  texlive  |  svn15878\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-icsv\-doc  |  noarch  |  texlive  |  svn15878\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-identkey  |  noarch  |  texlive  |  svn49018\-59\.amzn2023\.0\.2  | 
|  texlive\-idxcmds  |  noarch  |  texlive  |  svn54554\-59\.amzn2023\.0\.2  | 
|  texlive\-idxcmds\-doc  |  noarch  |  texlive  |  svn54554\-59\.amzn2023\.0\.2  | 
|  texlive\-idxlayout  |  noarch  |  texlive  |  svn25821\.0\.4d\-59\.amzn2023\.0\.2  | 
|  texlive\-idxlayout\-doc  |  noarch  |  texlive  |  svn25821\.0\.4d\-59\.amzn2023\.0\.2  | 
|  texlive\-IEEEconf  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-IEEEconf\-doc  |  noarch  |  texlive  |  svn15878\.1\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-ieeepes  |  noarch  |  texlive  |  svn17359\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ieeepes\-doc  |  noarch  |  texlive  |  svn17359\.4\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-IEEEtran  |  noarch  |  texlive  |  svn51065\-59\.amzn2023\.0\.2  | 
|  texlive\-IEEEtran\-doc  |  noarch  |  texlive  |  svn51065\-59\.amzn2023\.0\.2  | 
|  texlive\-ietfbibs\-doc  |  noarch  |  texlive  |  svn41332\-59\.amzn2023\.0\.2  | 
|  texlive\-iffont  |  noarch  |  texlive  |  svn38823\-59\.amzn2023\.0\.2  | 
|  texlive\-iffont\-doc  |  noarch  |  texlive  |  svn38823\-59\.amzn2023\.0\.2  | 
|  texlive\-ifmslide  |  noarch  |  texlive  |  svn20727\.0\.47\-59\.amzn2023\.0\.2  | 
|  texlive\-ifmslide\-doc  |  noarch  |  texlive  |  svn20727\.0\.47\-59\.amzn2023\.0\.2  | 
|  texlive\-ifmtarg  |  noarch  |  texlive  |  svn47544\-59\.amzn2023\.0\.2  | 
|  texlive\-ifmtarg\-doc  |  noarch  |  texlive  |  svn47544\-59\.amzn2023\.0\.2  | 
|  texlive\-ifnextok  |  noarch  |  texlive  |  svn23379\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ifnextok\-doc  |  noarch  |  texlive  |  svn23379\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ifoddpage  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-ifoddpage\-doc  |  noarch  |  texlive  |  svn56291\-59\.amzn2023\.0\.2  | 
|  texlive\-ifplatform  |  noarch  |  texlive  |  svn45533\-59\.amzn2023\.0\.2  | 
|  texlive\-ifplatform\-doc  |  noarch  |  texlive  |  svn45533\-59\.amzn2023\.0\.2  | 
|  texlive\-ifptex  |  noarch  |  texlive  |  svn52626\-59\.amzn2023\.0\.2  | 
|  texlive\-ifsym  |  noarch  |  texlive  |  svn24868\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ifsym\-doc  |  noarch  |  texlive  |  svn24868\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-iftex  |  noarch  |  texlive  |  svn56594\-59\.amzn2023\.0\.2  | 
|  texlive\-iftex\-doc  |  noarch  |  texlive  |  svn54159\-59\.amzn2023\.0\.2  | 
|  texlive\-ifthenx  |  noarch  |  texlive  |  svn25819\.0\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-ifthenx\-doc  |  noarch  |  texlive  |  svn25819\.0\.1a\-59\.amzn2023\.0\.2  | 
|  texlive\-ifxptex  |  noarch  |  texlive  |  svn46153\-59\.amzn2023\.0\.2  | 
|  texlive\-iitem  |  noarch  |  texlive  |  svn29613\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-iitem\-doc  |  noarch  |  texlive  |  svn29613\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-ijmart  |  noarch  |  texlive  |  svn30958\.1\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-ijmart\-doc  |  noarch  |  texlive  |  svn30958\.1\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-ijqc  |  noarch  |  texlive  |  svn15878\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-ijqc\-doc  |  noarch  |  texlive  |  svn15878\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-ijsra  |  noarch  |  texlive  |  svn44886\-59\.amzn2023\.0\.2  | 
|  texlive\-imac  |  noarch  |  texlive  |  svn17347\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-imac\-doc  |  noarch  |  texlive  |  svn17347\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-image\-gallery  |  noarch  |  texlive  |  svn15878\.v1\.0j\-59\.amzn2023\.0\.2  | 
|  texlive\-image\-gallery\-doc  |  noarch  |  texlive  |  svn15878\.v1\.0j\-59\.amzn2023\.0\.2  | 
|  texlive\-imakeidx  |  noarch  |  texlive  |  svn42287\-59\.amzn2023\.0\.2  | 
|  texlive\-imakeidx\-doc  |  noarch  |  texlive  |  svn42287\-59\.amzn2023\.0\.2  | 
|  texlive\-imfellenglish  |  noarch  |  texlive  |  svn38547\-59\.amzn2023\.0\.2  | 
|  texlive\-imfellenglish\-doc  |  noarch  |  texlive  |  svn38547\-59\.amzn2023\.0\.2  | 
|  texlive\-impatient\-cn\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-impatient\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-impatient\-fr\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-impnattypo  |  noarch  |  texlive  |  svn50227\-59\.amzn2023\.0\.2  | 
|  texlive\-impnattypo\-doc  |  noarch  |  texlive  |  svn50227\-59\.amzn2023\.0\.2  | 
|  texlive\-import  |  noarch  |  texlive  |  svn54683\-59\.amzn2023\.0\.2  | 
|  texlive\-import\-doc  |  noarch  |  texlive  |  svn54683\-59\.amzn2023\.0\.2  | 
|  texlive\-imsproc  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-imsproc\-doc  |  noarch  |  texlive  |  svn29803\.0\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-imtekda  |  noarch  |  texlive  |  svn17667\.1\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-imtekda\-doc  |  noarch  |  texlive  |  svn17667\.1\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-incgraph  |  noarch  |  texlive  |  svn36500\.1\.12\-59\.amzn2023\.0\.2  | 
|  texlive\-incgraph\-doc  |  noarch  |  texlive  |  svn36500\.1\.12\-59\.amzn2023\.0\.2  | 
|  texlive\-inconsolata  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-inconsolata\-doc  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-index  |  noarch  |  texlive  |  svn24099\.4\.1beta\-59\.amzn2023\.0\.2  | 
|  texlive\-index\-doc  |  noarch  |  texlive  |  svn24099\.4\.1beta\-59\.amzn2023\.0\.2  | 
|  texlive\-indextools  |  noarch  |  texlive  |  svn38931\-59\.amzn2023\.0\.2  | 
|  texlive\-indextools\-doc  |  noarch  |  texlive  |  svn38931\-59\.amzn2023\.0\.2  | 
|  texlive\-infwarerr  |  noarch  |  texlive  |  svn53023\-59\.amzn2023\.0\.2  | 
|  texlive\-initials  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-initials\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-inkpaper  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-inlinebib  |  noarch  |  texlive  |  svn22018\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-inlinebib\-doc  |  noarch  |  texlive  |  svn22018\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-inlinedef  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-inlinedef\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-inline\-images  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-innerscript  |  noarch  |  texlive  |  svn57672\-59\.amzn2023\.0\.2  | 
|  texlive\-inputenx  |  noarch  |  texlive  |  svn52986\-59\.amzn2023\.0\.2  | 
|  texlive\-inputtrc  |  noarch  |  texlive  |  svn28019\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-inputtrc\-doc  |  noarch  |  texlive  |  svn28019\.0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-inriafonts  |  noarch  |  texlive  |  svn54512\-59\.amzn2023\.0\.2  | 
|  texlive\-insbox  |  noarch  |  texlive  |  svn34299\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-insbox\-doc  |  noarch  |  texlive  |  svn34299\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-install\-latex\-guide\-zh\-cn  |  noarch  |  texlive  |  svn59037\-59\.amzn2023\.0\.2  | 
|  texlive\-intcalc  |  noarch  |  texlive  |  svn53168\-59\.amzn2023\.0\.2  | 
|  texlive\-inter  |  noarch  |  texlive  |  svn58892\-59\.amzn2023\.0\.2  | 
|  texlive\-interactiveworkbook  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-interactiveworkbook\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-interchar  |  noarch  |  texlive  |  svn36312\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-interchar\-doc  |  noarch  |  texlive  |  svn36312\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-interfaces  |  noarch  |  texlive  |  svn21474\.3\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-interfaces\-doc  |  noarch  |  texlive  |  svn21474\.3\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-interpreter  |  noarch  |  texlive  |  svn27232\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-interpreter\-doc  |  noarch  |  texlive  |  svn27232\.1\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-interval  |  noarch  |  texlive  |  svn50265\-59\.amzn2023\.0\.2  | 
|  texlive\-interval\-doc  |  noarch  |  texlive  |  svn50265\-59\.amzn2023\.0\.2  | 
|  texlive\-intopdf  |  noarch  |  texlive  |  svn58743\-59\.amzn2023\.0\.2  | 
|  texlive\-intro\-scientific\-doc  |  noarch  |  texlive  |  svn15878\.5th\_edition\-59\.amzn2023\.0\.2  | 
|  texlive\-inversepath  |  noarch  |  texlive  |  svn15878\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-inversepath\-doc  |  noarch  |  texlive  |  svn15878\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-invoice  |  noarch  |  texlive  |  svn48359\-59\.amzn2023\.0\.2  | 
|  texlive\-invoice2  |  noarch  |  texlive  |  svn46364\-59\.amzn2023\.0\.2  | 
|  texlive\-invoice\-class  |  noarch  |  texlive  |  svn49749\-59\.amzn2023\.0\.2  | 
|  texlive\-invoice\-doc  |  noarch  |  texlive  |  svn48359\-59\.amzn2023\.0\.2  | 
|  texlive\-iodhbwm  |  noarch  |  texlive  |  svn57773\-59\.amzn2023\.0\.2  | 
|  texlive\-ionumbers  |  noarch  |  texlive  |  svn33457\.0\.3\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-ionumbers\-doc  |  noarch  |  texlive  |  svn33457\.0\.3\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-iopart\-num  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-iopart\-num\-doc  |  noarch  |  texlive  |  svn15878\.2\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-ipaex  |  noarch  |  texlive  |  svn52032\-59\.amzn2023\.0\.2  | 
|  texlive\-ipaex\-doc  |  noarch  |  texlive  |  svn52032\-59\.amzn2023\.0\.2  | 
|  texlive\-ipaex\-type1  |  noarch  |  texlive  |  svn47700\-59\.amzn2023\.0\.2  | 
|  texlive\-ipaex\-type1\-doc  |  noarch  |  texlive  |  svn47700\-59\.amzn2023\.0\.2  | 
|  texlive\-is\-bst  |  noarch  |  texlive  |  svn52623\-59\.amzn2023\.0\.2  | 
|  texlive\-iscram  |  noarch  |  texlive  |  svn45801\-59\.amzn2023\.0\.2  | 
|  texlive\-iso  |  noarch  |  texlive  |  svn15878\.2\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-iso10303  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-iso10303\-doc  |  noarch  |  texlive  |  svn15878\.1\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-isodate  |  noarch  |  texlive  |  svn16613\.2\.28\-59\.amzn2023\.0\.2  | 
|  texlive\-isodate\-doc  |  noarch  |  texlive  |  svn16613\.2\.28\-59\.amzn2023\.0\.2  | 
|  texlive\-isodoc  |  noarch  |  texlive  |  svn57811\-59\.amzn2023\.0\.2  | 
|  texlive\-iso\-doc  |  noarch  |  texlive  |  svn15878\.2\.4\-59\.amzn2023\.0\.2  | 
|  texlive\-isodoc\-doc  |  noarch  |  texlive  |  svn57811\-59\.amzn2023\.0\.2  | 
|  texlive\-isomath  |  noarch  |  texlive  |  svn27654\.0\.6\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-isomath\-doc  |  noarch  |  texlive  |  svn27654\.0\.6\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-isonums  |  noarch  |  texlive  |  svn17362\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-isonums\-doc  |  noarch  |  texlive  |  svn17362\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-isopt  |  noarch  |  texlive  |  svn45509\-59\.amzn2023\.0\.2  | 
|  texlive\-isorot  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-isorot\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-isotope  |  noarch  |  texlive  |  svn23711\.v0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-isotope\-doc  |  noarch  |  texlive  |  svn23711\.v0\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-issuulinks  |  noarch  |  texlive  |  svn25742\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-issuulinks\-doc  |  noarch  |  texlive  |  svn25742\.1\.1\-59\.amzn2023\.0\.2  | 
|  texlive\-istgame  |  noarch  |  texlive  |  svn49848\-59\.amzn2023\.0\.2  | 
|  texlive\-itnumpar  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-itnumpar\-doc  |  noarch  |  texlive  |  svn15878\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-iwhdp  |  noarch  |  texlive  |  svn37552\.0\.50\-59\.amzn2023\.0\.2  | 
|  texlive\-iwhdp\-doc  |  noarch  |  texlive  |  svn37552\.0\.50\-59\.amzn2023\.0\.2  | 
|  texlive\-iwona  |  noarch  |  texlive  |  svn19611\.0\.995b\-59\.amzn2023\.0\.2  | 
|  texlive\-iwona\-doc  |  noarch  |  texlive  |  svn19611\.0\.995b\-59\.amzn2023\.0\.2  | 
|  texlive\-jablantile  |  noarch  |  texlive  |  svn16364\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jablantile\-doc  |  noarch  |  texlive  |  svn16364\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jacow  |  noarch  |  texlive  |  svn50870\-59\.amzn2023\.0\.2  | 
|  texlive\-jacow\-doc  |  noarch  |  texlive  |  svn50870\-59\.amzn2023\.0\.2  | 
|  texlive\-jamtimes  |  noarch  |  texlive  |  svn20408\.1\.12\-59\.amzn2023\.0\.2  | 
|  texlive\-jamtimes\-doc  |  noarch  |  texlive  |  svn20408\.1\.12\-59\.amzn2023\.0\.2  | 
|  texlive\-japanese\-otf  |  noarch  |  texlive  |  svn57826\-59\.amzn2023\.0\.2  | 
|  texlive\-japanese\-otf\-doc  |  noarch  |  texlive  |  svn57826\-59\.amzn2023\.0\.2  | 
|  texlive\-japanese\-otf\-uptex  |  noarch  |  texlive  |  svn56932\-59\.amzn2023\.0\.2  | 
|  texlive\-japanese\-otf\-uptex\-doc  |  noarch  |  texlive  |  svn54080\-59\.amzn2023\.0\.2  | 
|  texlive\-jbact  |  noarch  |  texlive  |  svn52717\-59\.amzn2023\.0\.2  | 
|  texlive\-jigsaw  |  noarch  |  texlive  |  svn49111\-59\.amzn2023\.0\.2  | 
|  texlive\-jkmath  |  noarch  |  texlive  |  svn47109\-59\.amzn2023\.0\.2  | 
|  texlive\-jknapltx  |  noarch  |  texlive  |  svn19440\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jknapltx\-doc  |  noarch  |  texlive  |  svn19440\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jlabels  |  noarch  |  texlive  |  svn24858\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jlabels\-doc  |  noarch  |  texlive  |  svn24858\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jlreq  |  noarch  |  texlive  |  svn58472\-59\.amzn2023\.0\.2  | 
|  texlive\-jlreq\-deluxe  |  noarch  |  texlive  |  svn58329\-59\.amzn2023\.0\.2  | 
|  texlive\-jmb  |  noarch  |  texlive  |  svn52718\-59\.amzn2023\.0\.2  | 
|  texlive\-jmlr  |  noarch  |  texlive  |  svn56395\-59\.amzn2023\.0\.2  | 
|  texlive\-jmlr\-doc  |  noarch  |  texlive  |  svn56395\-59\.amzn2023\.0\.2  | 
|  texlive\-jmn  |  noarch  |  texlive  |  svn45751\-59\.amzn2023\.0\.2  | 
|  texlive\-jneurosci  |  noarch  |  texlive  |  svn17346\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-jneurosci\-doc  |  noarch  |  texlive  |  svn17346\.1\.00\-59\.amzn2023\.0\.2  | 
|  texlive\-jnuexam  |  noarch  |  texlive  |  svn56867\-59\.amzn2023\.0\.2  | 
|  texlive\-josefin  |  noarch  |  texlive  |  svn57152\-59\.amzn2023\.0\.2  | 
|  texlive\-jpsj  |  noarch  |  texlive  |  svn15878\.1\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-jpsj\-doc  |  noarch  |  texlive  |  svn15878\.1\.2\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-jsclasses  |  noarch  |  texlive  |  svn56608\-59\.amzn2023\.0\.2  | 
|  texlive\-jsclasses\-doc  |  noarch  |  texlive  |  svn56608\-59\.amzn2023\.0\.2  | 
|  texlive\-jslectureplanner  |  noarch  |  texlive  |  svn57095\-59\.amzn2023\.0\.2  | 
|  texlive\-jslectureplanner\-doc  |  noarch  |  texlive  |  svn53672\-59\.amzn2023\.0\.2  | 
|  texlive\-js\-misc  |  noarch  |  texlive  |  svn16211\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-js\-misc\-doc  |  noarch  |  texlive  |  svn16211\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jumplines  |  noarch  |  texlive  |  svn37553\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-jumplines\-doc  |  noarch  |  texlive  |  svn37553\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-junicode  |  noarch  |  texlive  |  svn53954\-59\.amzn2023\.0\.2  | 
|  texlive\-junicode\-doc  |  noarch  |  texlive  |  svn53954\-59\.amzn2023\.0\.2  | 
|  texlive\-jupynotex  |  noarch  |  texlive  |  svn56715\-59\.amzn2023\.0\.2  | 
|  texlive\-jura  |  noarch  |  texlive  |  svn15878\.4\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-juraabbrev  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-juraabbrev\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-jurabib  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-jurabib\-doc  |  noarch  |  texlive  |  svn15878\.0\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-jura\-doc  |  noarch  |  texlive  |  svn15878\.4\.3\-59\.amzn2023\.0\.2  | 
|  texlive\-juramisc  |  noarch  |  texlive  |  svn15878\.0\.91\-59\.amzn2023\.0\.2  | 
|  texlive\-juramisc\-doc  |  noarch  |  texlive  |  svn15878\.0\.91\-59\.amzn2023\.0\.2  | 
|  texlive\-jurarsp  |  noarch  |  texlive  |  svn15878\.0\.52\-59\.amzn2023\.0\.2  | 
|  texlive\-jurarsp\-doc  |  noarch  |  texlive  |  svn15878\.0\.52\-59\.amzn2023\.0\.2  | 
|  texlive\-jvlisting  |  noarch  |  texlive  |  svn24638\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-jvlisting\-doc  |  noarch  |  texlive  |  svn24638\.0\.7\-59\.amzn2023\.0\.2  | 
|  texlive\-kalendarium  |  noarch  |  texlive  |  svn48744\-59\.amzn2023\.0\.2  | 
|  texlive\-kanaparser  |  noarch  |  texlive  |  svn48052\-59\.amzn2023\.0\.2  | 
|  texlive\-kantlipsum  |  noarch  |  texlive  |  svn51727\-59\.amzn2023\.0\.2  | 
|  texlive\-kantlipsum\-doc  |  noarch  |  texlive  |  svn51727\-59\.amzn2023\.0\.2  | 
|  texlive\-karnaugh  |  noarch  |  texlive  |  svn21338\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-karnaugh\-doc  |  noarch  |  texlive  |  svn21338\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-karnaughmap  |  noarch  |  texlive  |  svn36989\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-karnaugh\-map  |  noarch  |  texlive  |  svn44131\-59\.amzn2023\.0\.2  | 
|  texlive\-karnaughmap\-doc  |  noarch  |  texlive  |  svn36989\.2\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kastrup  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kastrup\-doc  |  noarch  |  texlive  |  svn15878\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kblocks  |  noarch  |  texlive  |  svn57617\-59\.amzn2023\.0\.2  | 
|  texlive\-kdgdocs  |  noarch  |  texlive  |  svn24498\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kdgdocs\-doc  |  noarch  |  texlive  |  svn24498\.1\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kerkis  |  noarch  |  texlive  |  svn56271\-59\.amzn2023\.0\.2  | 
|  texlive\-kerkis\-doc  |  noarch  |  texlive  |  svn56271\-59\.amzn2023\.0\.2  | 
|  texlive\-kerntest  |  noarch  |  texlive  |  svn15878\.1\.32\-59\.amzn2023\.0\.2  | 
|  texlive\-kerntest\-doc  |  noarch  |  texlive  |  svn15878\.1\.32\-59\.amzn2023\.0\.2  | 
|  texlive\-keycommand  |  noarch  |  texlive  |  svn18042\.3\.1415\-59\.amzn2023\.0\.2  | 
|  texlive\-keycommand\-doc  |  noarch  |  texlive  |  svn18042\.3\.1415\-59\.amzn2023\.0\.2  | 
|  texlive\-keyfloat  |  noarch  |  texlive  |  svn52160\-59\.amzn2023\.0\.2  | 
|  texlive\-keyindex  |  noarch  |  texlive  |  svn50828\-59\.amzn2023\.0\.2  | 
|  texlive\-keyreader  |  noarch  |  texlive  |  svn28195\.0\.5b\-59\.amzn2023\.0\.2  | 
|  texlive\-keyreader\-doc  |  noarch  |  texlive  |  svn28195\.0\.5b\-59\.amzn2023\.0\.2  | 
|  texlive\-keystroke  |  noarch  |  texlive  |  svn17992\.v1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-keystroke\-doc  |  noarch  |  texlive  |  svn17992\.v1\.6\-59\.amzn2023\.0\.2  | 
|  texlive\-keyval2e  |  noarch  |  texlive  |  svn23698\.0\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-keyval2e\-doc  |  noarch  |  texlive  |  svn23698\.0\.0\.2\-59\.amzn2023\.0\.2  | 
|  texlive\-keyvaltable  |  noarch  |  texlive  |  svn54677\-59\.amzn2023\.0\.2  | 
|  texlive\-keyvaltable\-doc  |  noarch  |  texlive  |  svn54677\-59\.amzn2023\.0\.2  | 
|  texlive\-kix  |  noarch  |  texlive  |  svn21606\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kix\-doc  |  noarch  |  texlive  |  svn21606\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kixfont  |  noarch  |  texlive  |  svn18488\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kixfont\-doc  |  noarch  |  texlive  |  svn18488\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-kluwer  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-kluwer\-doc  |  noarch  |  texlive  |  svn54074\-59\.amzn2023\.0\.2  | 
|  texlive\-knitting  |  noarch  |  texlive  |  svn50782\-59\.amzn2023\.0\.2  | 
|  texlive\-knitting\-doc  |  noarch  |  texlive  |  svn50782\-59\.amzn2023\.0\.2  | 
|  texlive\-knittingpattern  |  noarch  |  texlive  |  svn17205\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-knittingpattern\-doc  |  noarch  |  texlive  |  svn17205\.0\-59\.amzn2023\.0\.2  | 
|  texlive\-knowledge  |  noarch  |  texlive  |  svn58724\-59\.amzn2023\.0\.2  | 
|  texlive\-knuth\-errata  |  noarch  |  texlive  |  svn58682\-59\.amzn2023\.0\.2  | 
|  texlive\-knuth\-lib  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-knuth\-local  |  noarch  |  texlive  |  svn57963\-59\.amzn2023\.0\.2  | 
|  texlive\-knuth\-pdf  |  noarch  |  texlive  |  svn58470\-59\.amzn2023\.0\.2  | 
|  texlive\-komacv  |  noarch  |  texlive  |  svn57721\-59\.amzn2023\.0\.2  | 
|  texlive\-komacv\-doc  |  noarch  |  texlive  |  svn57721\-59\.amzn2023\.0\.2  | 
|  texlive\-komacv\-rg  |  noarch  |  texlive  |  svn49064\-59\.amzn2023\.0\.2  | 
|  texlive\-koma\-moderncvclassic  |  noarch  |  texlive  |  svn25025\.v0\.5\-59\.amzn2023\.0\.2  | 
|  texlive\-koma\-mod