---
layout: home
# home: true
sidebar: false
hero:
  # name: VitePress
  text: Debugging your GraphQL server was never this easy!
  tagline: Altair GraphQL Client helps you debug GraphQL queries and implementations - taking care of the hard part so you can focus on actually getting things done.
  image:
    src: /assets/img/app-shot.png
    alt: Altair GraphQL
  actions:
    - theme: brand
      text: Download
      link: /#download
    - theme: alt
      text: Get Started →
      link: /docs/
heroSublimeAction:
  text: Discover Altair GraphQL Cloud ✨
  link: /cloud

# heroImage: ./assets/img/app-shot.png
# heroText: Debugging your GraphQL server was never this easy!
# tagline: Altair GraphQL Client helps you debug GraphQL queries and implementations - taking care of the hard part so you can focus on actually getting things done.
# actions:
# - text: Download
#   link: ./#download
#   primary: true
# - text: Get Started →
#   link: /docs/
features:
  - title: Creating environments
    details: easily switch between various working environments (e.g. switching between local, staging and production environments)
  - title: Advanced schema doc search
    details: provides a rich interface to conveniently search through your schema
  - title: File upload mechanism
    details: use binary files as variables to upload them via GraphQL following the GraphQL multipart request specification
  - title: Automatic schema refreshing
    details: automatically refresh your schema whenever it changes using the GraphQL Event Stream specification
  - title: Executing pre-request scripts
    details: execute scripts to set dynamic variables before your request is sent
  - title: Import/export query collection
    details: create and export collections of queries to share with other members of your team
  - title: Generating queries from schema
    details: easily add a query or fragment from the docs into the editor without having to manually type the fields in the query
  - title: Multiple language translations
    details: use Altair comfortably in your native language with several languages supported
  - title: Extensive plugin system
    details: extend the core functionality provided with plugins that can do much more
featuresFooterText: View all features
featuresFooterLink: /docs/features/
contributions:
  opencollective:
    url: https://opencollective.com/altair
  buymeacoffee:
    url: https://www.buymeacoffee.com/imolorhe
downloads:
  title: Get Altair
  list:
    - name: macOS
      image: /assets/img/osx_logo.svg
      pattern: _x64_mac.dmg$
      link: https://github.com/altair-graphql/altair/releases/latest
      extra: brew install --cask altair-graphql-client
    - name: macOS M1
      image: /assets/img/osx_logo.svg
      pattern: _arm64_mac.dmg$
    - name: linux
      image: /assets/img/linux_logo.svg
      pattern: AppImage
      link:
      extra: snap install altair
    - name: windows
      image: /assets/img/windows_logo.svg
      pattern: exe
      link:
      extra: choco install altair-graphql
    - name: chrome
      image: /assets/img/chrome_icon.svg
      link: https://chrome.google.com/webstore/detail/altair-graphql-client/flnheeellpciglgpaodhkhmapeljopja
    - name: firefox
      image: /assets/img/firefox_logo.svg
      link: https://addons.mozilla.org/en-US/firefox/addon/altair-graphql-client/
    - name: edge
      image: /assets/img/edge_icon.svg
      link: https://microsoftedge.microsoft.com/addons/detail/altair-graphql-client/kpggioiimijgcalmnfnalgglgooonopa
    - name: web
      image: /assets/img/webapp_icon.svg
      link: https://web.altairgraphql.dev
footer: Made by Samuel with ❤️
---
