---
title: Contributing
order: 9
---

# Let's build Altair together

Altair is only as useful as it is because of the contributions from people like you. Your contributions are important in making Altair better for the community

---

There are several ways to contribute to Altair.

## Write code 👨🏾‍💻

There are always issues that are open and need some attention. You could fork the [project](https://github.com/altair-graphql/altair), create the solution and create a PR! Pull Requests from members of the community are always welcome.

Sometimes it can be intimidating to pick up issues. An easy way to get started would be looking for issues with the `good-first-issue` or `first-timers-only` labels. Those are usually simple tasks that wouldn't require much effort.

You don't have to wait for an issue to be created either. You can create a PR to fix minor bugs, make UI improvements, fix typos, remove `console.log()` statements if in the code, little things like that count as contributions too.

## Translations 🌍

As at the time of this writing (16 March 2019), Altair supports 12 languages (3 fully supported languages and 9 other partially supported ones). These translations are all done by members of the community, and have provided a better experience for non-English users.

This is a very good way to contribute to the project. Contributing translations is done using [Crowdin](https://crwd.in/altair-gql), a translation service. It is even easier to contribute using the [in-app context](https://altair-gql-translate.surge.sh/) that allows you translate the texts within the Altair app itself.

## Documentation 📖

As more features get added regularly, the documentation of the project gets stale quickly, and is often in need of updating. It is useful to update the documentations whenever you discover some outdated content in them to help others in the community get access to the right information.

The documentation might not be descriptive enough. You can add more content to make it more descriptive. You could add images and video links as well to further improve the documentation.

The content of this site is stored on the [repo](https://github.com/altair-graphql/altair/tree/master/packages/altair-docs/) as well, so you can easily update the content and create a PR with your changes to be merged.

## Donate 💰

As an open source project, it takes the effort of the maintainers to keep Altair active, and the development momentum up. This usually requires spending a lot of time creating features and enhancements, fixing issues, etc. Donations help to support the maintainers as well as paying up the bills for keeping the site up and other related expenses.

[![Donate to Altair](https://opencollective.com/altair/donate/button.png?color=blue)](https://opencollective.com/altair/donate)
