import { Component, Input, OnInit, Output } from '@angular/core';
import { NonNullableFormBuilder } from '@angular/forms';

@Component({
  selector: 'app-authorization-basic',
  templateUrl: './authorization-basic.component.html',
  styles: ``,
})
export class AuthorizationBasicComponent implements OnInit {
  basicForm = this.formBuilder.group({
    username: '',
    password: '',
  });
  @Input() authData?: unknown;
  @Output() authDataChange = this.basicForm.valueChanges;

  constructor(private readonly formBuilder: NonNullableFormBuilder) {}

  ngOnInit(): void {
    if (this.authData) {
      this.basicForm.patchValue(this.authData);
    }
  }
}
