$ErrorActionPreference = 'Stop'; # stop on all errors

$toolsDir   = "$(Split-Path -parent $MyInvocation.MyCommand.Definition)"
$fileLocation = Join-Path $toolsDir '..\bins\altair_8.1.3_x64_win.exe'
$fileHash = Get-FileHash $fileLocation

$packageArgs = @{
  packageName   = $env:ChocolateyPackageName
  unzipLocation = $toolsDir
  fileType      = 'EXE'
  file64        = $fileLocation
  softwareName  = 'altair-graphql*'
  checksum64    = $fileHash.Hash
  checksumType64= 'sha256'
  silentArgs    = "/qn /norestart /l*v `"$($env:TEMP)\$($packageName).$($env:chocolateyPackageVersion).MsiInstall.log`""
  validExitCodes= @(0, 3010, 1641)
}

Install-ChocolateyPackage @packageArgs

# Remove the installer
Remove-Item $fileLocation -Force -ErrorAction 'SilentlyContinue'
