# langchain-news
A sample Streamlit application for Google news search and summaries using LangChain and Serper API.

[LangChain](https://langchain.readthedocs.io/en/latest) is an open-source framework created to aid the development of applications leveraging the power of large language models (LLMs). It can be used for chatbots, text summarisation, data generation, code understanding, question answering, evaluation, and more. [Serper](https://serper.dev/), on the other hand, allows you to submit queries and receive Google Search (SERP) results quickly and cost effectively.

You'll need API keys from OpenAI (get it [here](https://platform.openai.com/account/api-keys)) and Serper (get it [here](https://serper.dev/api-key)).
<img src="./../images/langchain-news.png" alt="langchain-news"/>

Here's a sample search result using Serper API only.
<img src="./../images/langchain-news-search.png" alt="langchain-news-search"/>

Here's a sample search result with AI-generated summaries using Serper and OpenAI APIs.
<img src="./../images/langchain-news-summary.png" alt="langchain-news-summary"/>

For a detailed guide, see [this](https://alphasec.io/summarize-google-news-results-with-langchain-and-serper-api) post. To deploy on [Railway](https://railway.app/?referralCode=alphasec) using a one-click template, click the button below.

[![Deploy on Railway](https://railway.app/button.svg)](https://railway.app/new/template/oE8sWo?referralCode=alphasec)
