# langchain-examples
<h4 align="center">
  <a href="https://github.com/alphasecio/langchain-examples/blob/main/LICENSE">
    <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="Released under the MIT license." />
  </a>
  <a href="https://github.com/alphasecio/langchain-examples">
    <img src="https://img.shields.io/github/stars/alphasecio/langchain-examples" alt="GitHub Stars" />
  </a>
  <a href="https://github.com/alphasecio/langchain-examples">
    <img src="https://img.shields.io/github/forks/alphasecio/langchain-examples" alt="GitHub Forks" />
  </a>
  <a href="https://github.com/alphasecio/langchain-examples">
    <img src="https://img.shields.io/github/watchers/alphasecio/langchain-examples" alt="GitHub Watchers" />
  </a>
  <a href="https://twitter.com/alphasecio">
    <img src="https://img.shields.io/twitter/follow/alphasecio?label=Follow" alt="Follow on Twitter" />
  </a>
</h4>

This repository contains a collection of apps powered by LangChain. 

[LangChain](https://langchain.readthedocs.io/en/latest) is an open-source framework created to aid the development of applications leveraging the power of large language models (LLMs). It can be used for chatbots, text summarisation, data generation, code understanding, question answering, evaluation, and more.

### [all-in-one](https://github.com/alphasecio/langchain-examples/blob/main/all-in-one)
A multi-page Streamlit application showcasing generative AI uses cases using LangChain, OpenAI, and others.

### [chroma-summary](https://github.com/alphasecio/langchain-examples/blob/main/chroma-summary)
A sample Streamlit web application for summarizing documents using LangChain and Chroma.

### [gemini-chat-pdf](https://github.com/alphasecio/langchain-examples/blob/main/gemini-chat-pdf)
A sample Streamlit web application for generative question-answering using LangChain, Gemini and Chroma.

### [helicone](https://github.com/alphasecio/langchain-examples/blob/main/helicone)
A sample Streamlit web application to demo LLM observability using LangChain and Helicone.

### [news-summary](https://github.com/alphasecio/langchain-examples/blob/main/news-summary)
A sample Streamlit application for Google news search and summaries using LangChain and Serper API.

### [pinecone-qa](https://github.com/alphasecio/langchain-examples/blob/main/pinecone-qa)
A sample Streamlit web application for generative question-answering using LangChain and Pinecone.

### [pinecone-summary](https://github.com/alphasecio/langchain-examples/blob/main/pinecone-summary)
A sample Streamlit web application for document summarization using LangChain and Pinecone.

### [search-tavily](https://github.com/alphasecio/langchain-examples/blob/main/search-tavily)
A sample Streamlit web application for search queries using LangChain and Tavily Search API.

### [search](https://github.com/alphasecio/langchain-examples/blob/main/search)
A sample Streamlit web application for search queries using LangChain and SerpApi.

### [text-summary](https://github.com/alphasecio/langchain-examples/blob/main/text-summary)
A sample Streamlit web application for summarizing text using LangChain and OpenAI.

### [url-summary](https://github.com/alphasecio/langchain-examples/blob/main/url-summary)
A sample Streamlit application to summarize URL content using LangChain and OpenAI.
