# Digital Signage Samples #

A repository containing commonly used code samples for my digital signage 
projects. This includes code for

* [`gcalflow/`](gcalflow/) - a customizable scrolling Agenda that uses data 
  from Google Calendar,
    * [`gcalflow/reveal/`](gcalflow/reveal/) - a customizable Agenda presentation
      slideshow that uses data from Google Calendar
* [`coin-slider/`](coin-slider/) - a customizable, nice, Slide show gallery 
  that uses images from Flickr,
* [`gapps-script/pollenvarsling/`](gapps-script/pollenvarsling/) - a project 
  that automatically extracts Pollen alert data from Pollen Alert emails from 
  NAAF (The Norwegian Asthma and Allergy Association) and adds the alert to 
  Google Calendar,
* [`php/flickr/`](php/flickr/) - a project that returns a filtered photos 
  result from Flickr as a Feed,
* [`responsive-tabbed-navigation/`](responsive-tabbed-navigation/) - Provides a
  responsive tabbed multi-view navigation container for other pages.
    * Original work from article by CodyHouse (<http://codyhouse.co/?p=346>).
      Please see their terms at <http://codyhouse.co/terms/>.
* [`xibo/`](xibo/) - custom templates for the modules of the Xibo Digital 
  Signage project


Licensed under the [MIT](LICENSE.md) License.

-----------

## Folder structure ##

* [`coin-slider/`](coin-slider/) - contains code, layout and styles for the 
  Coin Slider JavaScript library
* [`domoticz/`](domoticz/) - contains code for Domoticz Event script projects
* [`gapps-script/`](gapps-script/) - contains code for integrating different 
  Google services (and/or other services) with each-other through Google Apps 
  Script
* [`gcalflow/`](gcalflow/) - contains code, layout and styles for the 
  gCalFlow JavaScript library
* [`php/`](php/) - contains server side code samples written in PHP
* [`xibo/`](xibo/) - contains templates and styles for Xibo modules
* [`shared/`](shared/) - contains shared code, styles and other resources

## Building ##

To build this project you will need the following applications:

* `nodejs` + `npm`
* `grunt` - install with `npm install -g grunt`

Install the required NodeJS packages with (from the project root folder):

    npm install


## Links ##

* [Xibo](http://xibo.org.uk/) Open Source Digital Signage
  ([GitHub Repository](https://github.com/xibosignage/xibo-cms))
* [Rise Vision](https://www.risevision.com/) Digital Signage Content Management
  ([GitHub Repository](https://github.com/Rise-Vision/rise-vision-apps))
* [Domoticz](http://www.domoticz.com/) Open Source Home Automation System
  ([GitHub Repository](https://github.com/domoticz/domoticz))
* [Coin Slider](http://workshop.rs/projects/coin-slider/): jQuery Image Slider 
  with Unique Effects
  ([GitHub Repository](https://github.com/kopipejst/coin-slider))
* [gCalFlow](http://sugi.github.io/jquery-gcal-flow/): jQuery Google Calendar 
  Event List Plug-in
  ([GitHub Repository](https://github.com/sugi/jquery-gcal-flow))
* [reveal.js](http://lab.hakim.se/reveal-js) - The HTML Presentation Framework
  ([GitHub Repository](https://github.com/hakimel/reveal.js))
* [Moment.js](http://momentjs.com/) JavaScript library
  ([GitHub Repository](https://github.com/moment/moment))
* [jQuery Transit](http://ricostacruz.com/jquery.transit/) JavaScript library
  ([GitHub Repository](https://github.com/rstacruz/jquery.transit/))
* [Color Safe](http://colorsafe.co/) - beautiful, accessible colors
  ([GitHub Repository](https://github.com/donnieberg/accessible-color-palette))
* [Google Apps Script](https://www.google.com/script/start/) JavaScript cloud 
  scripting language
