Design Title: 
Authors: 
Date: 

## Overview
This section explains the motivation of the work, providing the status quo and 
the problems associated with it. 
This section also proposes the high level solution to the problem.

## Goals
This section explains the detailed goals and minimum requirements for the design. 
It should also include any non-goals of the design which would be expected from 
a reader. 
This also includes some high level functionality or performance gains.

## Use Cases
This section explains the use cases which will be enabled by the implementation 
of this design. 
This section should be from the perspective of a user and how they would be 
able to interact with the feature described.

## Design
This section explains the high level changes proposed to achieve the design. 
Changes should be grouped by project components or in another logical way which 
makes the design easy to follow.
If applicable, the design should be broken down into separate phases which each 
delivers incremental value. 
The first phase should achieve the minimum requirements outlined in the goals.
If applicable, alternative approaches should be noted and evaluated for different 
sections of the design.

## API Changes
This is a section detailing any user facing or internal APIs added to components, 
including configuration changes. 
Any changes to user facing components are mentioned here (ie. WebUI, command line). 
If no changes are made, it should be stated in this section.
Changes should be formatted in a reader friendly manner. 

## Compatibility
This section explains any compatibility assumptions or limitations.
This section also analyzes any dependency changes (ie. pom file changes). 
In particular, the addition of new external libraries should be justified.

## Security
This section explains any security considerations which must be taken into 
account. 
If there are no security implications, it should be stated explicitly here.

## Implementation Detail (Optional)
This is an OPTIONAL and possibly REPEATED section which dives into a specific 
implementation detail in the design. 
Diagrams, code snippets, and other figures are encouraged.

## Failure Analysis
This section explains the various failure cases which the design must 
tolerate as well as failure cases the design neglects to address. 
Each failure should be noted with the expected behavior as well as ideal 
behavior, and if different, what effort is required to bridge the gap.
This section should also outline any potential risks due to the implementation 
of this design such as performance loss, undesired behavior, and system instability.

## Test Plan
This section details the tests which will be added to ensure the quality and 
maintainability of the implementation. 
Unit tests should be added under the corresponding Alluxio module. 
Integration tests should be added to alluxio/tests module. 
System tests performed manually can be mentioned in the PR. 
In addition, any new functionality to support testing should be noted.

## Engineering Estimate
This section covers the schedule of the design, implementation and testing phases. 
This will help us estimate the complete time of the feature and align with releases.
