---
layout: global
title: Overview
---

Welcome to Alluxio Documentation! You will find resources regarding deploying Alluxio, integrations with various tech stacks, API references, and more! If you have any questions, join our Alluxio Community Slack &rarr; [alluxio.io/slack](https://www.alluxio.io/slack)

## Get Started with Alluxio

### Quick Start Guide
Check out our [Quick Start Guide]({{ '/en/deploy/Get-Started.html' | relativize_url }}) for step-by-step guidance on how to download and configure Alluxio, run Alluxio on a local machine, and perform basic tasks via Alluxio Shell.

▶️ [Get Alluxio Up & Running in Less Than 3 Min!](https://youtu.be/5YQvvznT5cI){:target="_blank"} (2:36)

### Install Alluxio on Kubernetes
See [Install Alluxio on Kubernetes]({{ '/en/kubernetes/Install-Alluxio-On-Kubernetes.html' | relativize_url }}) on how to install Alluxio on Kubernetes via 
[Helm](https://helm.sh/), a kubernetes package manager, and [Operator](https://kubernetes.io/docs/concepts/extend-kubernetes/operator/), a kubernetes extension for managing applications.

Check out these 2 short videos on deployment and best practices with configurations & recommendations:  
* ▶️ [Deploy Alluxio on Kubernetes](https://www.youtube.com/watch?v=FlvbekK_xG0){:target="_blank"} (5:12)  
* ▶️ [Alluxio on Kubernetes Best Practices](https://www.youtube.com/watch?v=zwhMwiYmO8M){:target="_blank"} (5:26)

### Install Alluxio on Bare Metal

Make sure you have the proper [Software Requirements]({{ '/en/deploy/Software-Requirements.html' | relativize_url}}), then
follow [Install Alluxio Cluster with HA]({{ '/en/deploy/Install-Alluxio-Cluster-with-HA.html' | relativize_url }}) to deploy an Alluxio cluster with High Availability (HA), which is achieved by running multiple Alluxio master processes on different nodes in the system.

### Install Alluxio on Docker

You can run an Alluxio cluster with a couple of `docker run` commands by following our tutorial for running Dockerized Alluxio on a single node with local disk as the under storage at [Install Alluxio on Docker]({{ '/en/deploy/Install-Alluxio-Cluster-with-Docker.html' | relativize_url }}). 

## Run a Compute Framework with Alluxio
* [Running Presto with Alluxio]({{ '/en/compute/Presto.html' | relativize_url }})
* [Running Trino with Alluxio]({{ '/en/compute/Trino.html' | relativize_url }})
* [Running Apache Spark with Alluxio]({{ '/en/compute/Spark.html' | relativize_url }})

## Connect a Storage Service to Alluxio
Take a look at [Storage Integrations Overview]({{ '/en/ufs/Storage-Overview.html' | relativize_url }}) for a list of all storage systems available to integrate with Alluxio and its necessary prerequisites.

* [Amazon AWS S3]({{ '/en/ufs/S3.html' | relativize_url }})
* [HDFS]({{ '/en/ufs/HDFS.html' | relativize_url }})
* [Google Cloud Storage]({{ '/en/ufs/GCS.html' | relativize_url }})

## Ask a Question to Alluxio Community

Join our vibrant and fast-growing [Alluxio Community Slack Channel](https://www.alluxio.io/slack) to connect with users & developers of Alluxio. If you need help running Alluxio or encounter any blockers, send your technical questions to our `#troubleshooting` channel. If you are a developer looking to contribute to Alluxio, check out the `#dev` channel.

## Contribute to the Open Source Project

Become a contributor! Follow our [Contribution Guide]({{ '/en/contributor/Contribution-Guide.html' | relativize_url }}) to learn how to fork the Alluxio repository and take on a new contributor task.
