# Alluxio CLI

The Alluxio command line interface is the single entrypoint for users to:
- Initialize and configure the Alluxio cluster
- Start and stop processes
- Expose information about the running cluster
- Interact with the filesystem, running commands such as `ls` and `cp`
- Perform administrator level actions such as format or backup

The CLI is invoked through the shell script at `bin/alluxio`.
Commands follow the format of:
```console
bin/alluxio <service> <operation> [--<flag>[=<value>]] [<args>]
```

Add the `-h` flag to view more details regarding a service or operation.

## Layout and naming conventions

The choice of names for services, operations, and flags should be succinct: short and unambiguous.
Use of a single word is strongly preferred, but otherwise the name parts should be delimited by a dash such as `foo-bar`.

For example, let's assume there is a `mark` operation as part of a `item` service that can be `set` or `unset` on an item `name`.
The recommended format for a command is
```console
bin/alluxio item mark --set name
bin/alluxio item mark --unset name
```
where it is expected that either `--set` or `--unset` are specified.
This is preferred over the alternative of two separate commands with `setMark` and `unsetMark` as the operations.

## User input

### Flags and arguments
After selecting the desired command, additional user input can be parsed, as a mix of arguments and/or flags:
- Arguments: `bin/alluxio command arg1 arg2 ...`
- Flags: `bin/alluxio command --flag1 --flag2 val2 ...`

Flags are strictly preferred over arguments.
- The flag name conveys context; an argument does not
- Arguments must be ordered; flags can be declared arbitrarily
- Flags can be designated as required to ensure user input.
- Repeated flags can be defined to capture an ordered list of inputs, ex. `--target target1 --target target2`

### Input validation

User inputs should be validated by the CLI command as much as possible as opposed to the resulting invocation.

## Output conventions and java invocation

A majority of commands result in invoking a java class with arguments to execute the expected operation and possibly return some output.
The output returned from the java invocation should tend towards being plain or machine parseable, such as a JSON formatted string,
rather than terminal friendly or human readable format.
When appropriate, the CLI command will default to formatting this output to be terminal friendly, with an option to output in a machine parseable format.

## Documentation

The markdown file at `docs/en/operation/User-CLI.md` describes all the commands available through the `bin/alluxio` CLI.
This is a file generated by running `bin/alluxio generate user-cli`.

The command definition determines the generated content:
- The string outlining the general usage of the command
- The list of flags with their name, default value, and description
- A lengthy description, defined by the `Long` field of the command
- A list of examples, defined by the `Examples` field of the command
  - The list is generated in the doc by splitting `Example` string by two newline characters

## References

Github CLI guidelines: https://primer.style/design/native/cli/foundations
