# Quick start

## Installation

`npm install @aposin/ngx-docs-ui`

## Import the module in your application

The `NxvDocumentationModule` is used in a regular angular application.

In the app.module.ts add these imports

```ts
import { NXV_MANIFEST_TOKEN, NxvDocumentationModule } from '@aposin/ngx-docs-ui';
import * as NX_MANIFEST from '@aposin/ng-aquila/documentation/manifest.json';
import { RouterModule } from '@angular/router';

const ROUTES = [
    {
        path: '',
        pathMatch: 'full',
        redirectTo: '/welcome',
    },
];

@NgModule({
    imports: [RouterModule.forRoot(ROUTES, { enableTracing: false }), NxvDocumentationModule.forRoot()],
    providers: [{ provide: NXV_MANIFEST_TOKEN, useValue: NX_MANIFEST }],
})
export class AppModule {}
```

First this will import the `NxvDocumentationModule` which takes care of all the routing and includes all angular components which are used in the generated files from the [ngx-doc-cli] package. That the `NxvDocumentationModule` works it needs to know what to actually show, this is done through a `manifest.json` which is generated by the CLI. Import your manifest file and inject it through the `NXV_MANIFEST_TOKEN`. To directly start on the welcome page of the documentation add a route which redirects to `/welcome`.
