import { Component } from '@angular/core';
import {
    NxAutocompleteComponent,
    NxAutocompleteOptionComponent,
    NxAutocompleteTriggerDirective,
} from '@aposin/ng-aquila/autocomplete';

/**
 * @title Autocomplete filtering example
 */
@Component({
    selector: 'autocomplete-filtering-example',
    templateUrl: './autocomplete-filtering-example.html',
    styleUrls: ['./autocomplete-filtering-example.css'],
    standalone: true,
    imports: [
        NxAutocompleteTriggerDirective,
        NxAutocompleteComponent,
        NxAutocompleteOptionComponent,
    ],
})
export class AutocompleteFilteringExampleComponent {
    filteredOptions: string[];
    options = [
        'Chimpanzee',
        'Chinchilla',
        'Chipmunk',
        'Coati',
        'Cicada',
        'Clam',
        'Clownfish',
        'Cobra',
        'Cockroach',
        'Cod',
        'Condor',
        'Constrictor',
        'Coral',
        'Cougar',
        'Cow',
        'Coyote',
        'Coypu',
        'Crab',
        'Crane',
        'Crane fly',
        'Crawdad',
        'Crayfish',
        'Cricket',
        'Crocodile',
        'Crow',
    ];

    constructor() {
        this.filteredOptions = this.options.slice();
    }

    filter(value: any) {
        this.filteredOptions = this.options.filter(s =>
            new RegExp(value, 'gi').test(s),
        );
    }
}
