# medicat-code

## Code setup
Run `pip install -r requirements.txt` to install the necessary requirements. Note that you may have to run different commands to install PyTorch and Torchvision with the CUDA version matching your hardware. See the PyTorch website for detailed information.

## Training and Getting predictions for models
There are 3 separate parts of this repository: (1) Figure classification, (2) Subfigure-subcaption detection alignment, and (3) Image-text matching.

(1) First, download the DocFigure dataset from https://researchweb.iiit.ac.in/~jobin.kv/projects/. Use the following commands to train and obtain predictions for a figure classification model:
```
allennlp train train_configs/train_docfigure.jsonnet -s serialized_directory --include-package figure_classifier
allennlp predict serialized_directory/model.tar.gz /path/to/test/set --use-dataset-reader --dataset-reader validation --include-package figure_classifier --output-file /path/to/output/file --predictor figure [--cuda-device OPTIONAL-CUDA-DEVICE]
```

(2) Use the following commands to train and obtain predictions for the object detector.
```
allennlp train train_configs/detector.jsonnet -s serialized_directory --include-package subcaption
allennlp predict serialized_directory/model.tar.gz /path/to/test/set --use-dataset-reader --dataset-reader validation --include-package subcaption --output-file /path/to/output/file --predictor generic -o "{"validation_dataset_reader": {"image_root": "\"/path/to/test/images\""}}" [--cuda-device OPTIONAL-CUDA-DEVICE]
```
Use the following commands to train and obtain predictions for the subcaption model.
```
allennlp train train_configs/subcaption.jsonnet -s serialized_directory --include-package subcaption
# To use gold subfigures for predicting subcaptions:
allennlp predict serialized_directory/model.tar.gz /path/to/test/set --use-dataset-reader --dataset-reader validation --include-package subcaption --output-file /path/to/output/file --predictor generic [--cuda-device OPTIONAL-CUDA-DEVICE]
# To use the predicted subfigures in the file generated by the object detector for predicting subcaptions:
allennlp predict serialized_directory/model.tar.gz /path/to/test/set --use-dataset-reader --dataset-reader validation --include-package subcaption --output-file /path/to/output/file --predictor generic -o "{"validation_dataset_reader": {"box_predictions_file": "\"/path/to/predicted/subfigures/file\""}}" [--cuda-device OPTIONAL-CUDA-DEVICE]
```

(3) Use the following commands to train and obtain predictions for the image-text matching model.
```
allennlp train train_configs/image_text_matching.jsonnet -s serialized_directory --include-package matching
allennlp predict serialized_directory/model.tar.gz /path/to/test/set --include-package matching --use-dataset-reader --dataset-reader validation --output-file /path/to/output/file --predictor generic -o "{"model": {"full_matching": "true"}}" [--cuda-device OPTIONAL-CUDA-DEVICE]
```

## Acknowledgements
`subcaption/coco_eval.py` is a slightly modified version of [this torchvision file][https://github.com/pytorch/vision/blob/master/references/detection/coco_eval.py]. `subcaption/utils.py` was taken from [this repository][https://github.com/sgrvinod/a-PyTorch-Tutorial-to-Object-Detection/blob/master/utils.py].
