import styler from '@alinea/styler'
import {createTypo} from 'alinea/ui/util/CreateTypo'
import NextLink from 'next/link'
import {HTMLAttributes} from 'react'
import css from './WebTypo.module.scss'

const styles = styler(css)

interface LinkProps {
  href?: string
  [key: string]: any
}

function Link({href, ...props}: LinkProps) {
  return href ? <NextLink href={href!} {...props} /> : <a {...props} />
}

function withPermaLink(Tag: string) {
  return function Perma(props: HTMLAttributes<HTMLHeadingElement>) {
    return (
      <Tag {...props}>
        {props.id && <a href={`#${props.id}`} className={styles.permaLink()} />}
        {props.children}
      </Tag>
    )
  }
}

export const WebTypo = createTypo(styles, {
  a: Link,
  h2: withPermaLink('h2'),
  h3: withPermaLink('h3')
})
