function(lookup_ftdi)
    if(FTDI_DRIVER_URL AND FTDI_LIB_DIR)
        message(STATUS "[ftdi] Using predefined driver source")
        return()
    endif()

    if(WIN32)
        set(FTDI_DRIVER_URL "https://www.ftdichip.com/Drivers/CDM/CDM%20v2.12.28%20WHQL%20Certified.zip" PARENT_SCOPE)
        if(CMAKE_SIZEOF_VOID_P EQUAL 4)
            set(FTDI_LIB_DIR i386 PARENT_SCOPE)
        else()
            set(FTDI_LIB_DIR amd64 PARENT_SCOPE)
        endif()
    else()
        message(SEND_ERROR "Unable to determine FTDI library source")
    endif()
endfunction()