/* Copyright 2020 Alibaba Group Holding Limited. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/

#include "actor/operator/base_op.act.h"

#include "actor/dag/dag_actor_manager.h"
#include "actor/graph/sharded_graph_store.h"
#include "core/operator/op_registry.h"

namespace graphlearn {
namespace act {

BaseOperatorActor::BaseOperatorActor(hiactor::actor_base* exec_ctx,
                                     const hiactor::byte_t* addr)
    : hiactor::actor(exec_ctx, addr), impl_(nullptr) {
  auto& mgr = DagActorManager::GetInstance();
  const auto* actor_params = reinterpret_cast<const OpActorParams*>(
      mgr.GetActorParams(actor_id()));
  params_ = &actor_params->node->Params();
}

BaseOperatorActor::~BaseOperatorActor() = default;

void BaseOperatorActor::SetOp(const std::string& op_name) {
  impl_ = (*op::OpRegistry::OpRegistry::GetInstance()->Lookup(op_name))();
  impl_->Set(ShardedGraphStore::Get().OnShard(
      static_cast<int32_t>(hiactor::local_shard_id())));
}

const Tensor::Map& BaseOperatorActor::GetParams() {
  auto& mgr = DagActorManager::GetInstance();
  const auto* actor_params = reinterpret_cast<const OpActorParams*>(
      mgr.GetActorParams(actor_id()));
  return actor_params->node->Params();
}

}  // namespace act
}  // namespace graphlearn
