# Search by Algolia – Instant & Relevant results #
**Contributors:** [algolia](https://profiles.wordpress.org/algolia), [rayrutjes](https://profiles.wordpress.org/rayrutjes)  
**Tags:** Search, Algolia, Autocomplete, instant-search, relevant search, search highlight, faceted search, find-as-you-type search, suggest, search by category, ajax search, better search, custom search  
**Requires at least:** 4.4  
**Tested up to:** 5.0  
**Requires PHP:** 5.3  
**Stable tag:** 2.11.3  
**License:** MIT License, GNU General Public License v2.0  

Search by Algolia is the smartest way to improve search on your site. Autocomplete is included, along with full control over look, feel and relevance.

## Plugin sunset ##

TL;DR: This plugin is no longer supported. Please use our API client guide instead [https://www.algolia.com/doc/integration/wordpress/getting-started/quick-start/](https://www.algolia.com/doc/integration/wordpress/getting-started/quick-start/).

After discussing with a lot of you, we've realized that our WordPress plugin, while being easy to implement and use, did not provide the room for customization necessary to build satisfying, advanced search and discovery experiences on Wordpress websites. 

That's why **we have decided to double down on our new PHP API client instead**. We created [comprehensive documentation](https://www.algolia.com/doc/integration/wordpress/getting-started/quick-start/) to guide you to index your Wordpress content, optimize your relevance, and build state-of-the art front end experiences relying on the API client.

We believe this approach is the most robust, satisfying and future-proof way to build great experiences for Wordpress websites. **We will therefore stop supporting our WordPress plugin** following this timeline:

* From 02/05/19: we won't add any new feature or fix any new functional bug in our Wordpress plugin. 

* From 31/12/19: we won't provide any security fix to our Wordpress plugin

Please note that **if you already have the plugin set up and are satisfied with your current integration, you can keep using the plugin forever**, knowing that it won't be supported according to the timeline above. It will still work as is, in its current state, on your website.

## Description ##

The plugin provides relevant search results in milliseconds, ensuring that your users can find your best posts at the speed of thought. It also comes with native typo-tolerance and is language-agnostic, so that every WordPress user, no matter where they are, can benefit from it.

### About pricing ###

This plugin relies on the [Algolia service](https://www.algolia.com/) which requires you to [create an account here](https://www.algolia.com/users/sign_up).
Algolia offers its Search as a Service provider on a incremental payment program, including a free Community Plan which includes 10,000 records & 50,000 operations per month.
Beyond that, plans start at $29/month.

Note that there isn’t a direct correlation between the number of posts in WordPress and the number of records in Algolia.
Also note that we only offer support starting from the PRO plan.
On average, you can expect to have about 10 times more records than you have posts, though this is not a golden rule and you could end up with more records.

### Getting started guide ###
Once you have installed the plugin, you can follow the step by step guide provided here: https://community.algolia.com/wordpress/configuration.html

### Relevance ###
Algolia enhances your search functionality with a completely customizable search experience which can be seamlessly integrated into your Wordpress theme. It lets you create a find-as-you-type experience or an auto-complete dropdown menu, which provides relevant results from the first keystroke. Our extension also automatically synchronizes data (posts, taxonomies etc.) in real-time, making sure that any updates to your site are available as soon as they are made.

### Speed ###
Algolia returns results in under 35ms on an average – irrespective of whether you have 100s or 1000s of posts.
Our state-of-the-art infrastructure and distributed search network ensures that your readers benefit from this, no matter where they are.

### Accessibility ###
Search by Algolia gives you the ability to make all forms of data – blog posts, categories, users etc. – searchable from a single search bar. Algolia also gives you the ability to completely customize your search results based on criteria that makes sense for your business, such as popularity, date, relevance etc.

### Built by developers for developers ###
Search by Algolia is also completely configurable and fully extensible by means of WordPress filters and hooks, letting you build a custom search experience or theme based on Algolia.

Want to see out how we did it?

Check it out here: [Search by Algolia GitHub Repository](https://github.com/algolia/algoliasearch-wordpress)

Join the Algolia community and meet thousands of search enthusiasts. We’re also always on the lookout for feedback: https://community.algolia.com/wordpress

## Frequently Asked Questions ##

### Where can I find Search by Algolia documentation and user guides? ###

- For help setting up and configuring Search by Algolia please refer to our [user guide](https://community.algolia.com/wordpress/installation.html)
- For extending or theming the Autocomplete dropdown, see our [Autocomplete Customization guide](https://community.algolia.com/wordpress/customize-autocomplete.html).
- For extending or theming the Instant Search results page, see our [Search Page Customization guide](https://community.algolia.com/wordpress/customize-search-page.html).

### Will Search by Algolia work with my theme? ###

Yes; Search by Algolia will work with any theme, but the Instant Search results page may require some styling to make it match nicely.

### Where can I report bugs or contribute to the project? ###

Bugs can be reported either in our support forum or preferably on the [Search by Algolia GitHub repository](https://github.com/algolia/algoliasearch-wordpress).

### My issue is not listed here, what should I do? ###

Please check out the [Frequently Asked Questions](https://community.algolia.com/wordpress/frequently-asked-questions.html) on our website which might have more information than this thread.
It will also give you guidance about where to ask support if your question is not covered.


## Installation ##

### Minimum Requirements ###

* PHP version 5.3 or greater (PHP 5.6 or greater is recommended)
* MySQL version 5.0 or greater (MySQL 5.6 or greater is recommended)
* Some payment gateways require fsockopen support (for IPN access)
* Requires WordPress 4.4+

Visit the [Search by Algolia server requirements documentation](https://community.algolia.com/wordpress/installation.html) for a detailed list of server requirements.

### Automatic installation ###

Automatic installation is the easiest option as WordPress handles the file transfers itself and you don’t need to leave your web browser. To do an automatic install of Search by Algolia, log in to your WordPress dashboard, navigate to the Plugins menu and click Add New.

In the search field type “Algolia” and click Search Plugins. Once you’ve found our search plugin you can view details about it such as the point release, rating and description. Most importantly of course, you can install it by simply clicking “Install Now”.

### Manual installation ###

The manual installation method involves downloading our search plugin and uploading it to your webserver via your favourite FTP application. The WordPress codex contains [instructions on how to do this here](https://codex.wordpress.org/Managing_Plugins#Manual_Plugin_Installation).

### Updating ###

Automatic updates should work like a charm; as always though, ensure you backup your site just in case.

## Screenshots ##

### 1. Algolia Settings. ###
![Algolia Settings.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-1.png)

### 2. Indexing configuration. ###
![Indexing configuration.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-2.png)

### 3. Instant-search results configuration. ###
![Instant-search results configuration.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-3.png)

### 4. Autocomplete dropdown configuration. ###
![Autocomplete dropdown configuration.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-4.png)

### 5. Autocomplete dropdown example. ###
![Autocomplete dropdown example.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-5.png)

### 6. Instant-search results page example. ###
![Instant-search results page example.](https://ps.w.org/search-by-algolia-instant-relevant-results/assets/screenshot-6.png)


## Changelog ##

[Checkout the complete changelog here](https://github.com/algolia/algoliasearch-wordpress/blob/master/CHANGELOG.md).
