# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.condition import Condition
from algoliasearch.search.models.consequence import Consequence
from algoliasearch.search.models.time_range import TimeRange

_ALIASES = {
    "object_id": "objectID",
    "conditions": "conditions",
    "consequence": "consequence",
    "description": "description",
    "enabled": "enabled",
    "validity": "validity",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Rule(BaseModel):
    """
    Rule object.
    """

    object_id: str
    """ Unique identifier of a rule object. """
    conditions: Optional[List[Condition]] = None
    """ Conditions that trigger a rule.  Some consequences require specific conditions or don't require any condition. For more information, see [Conditions](https://www.algolia.com/doc/guides/managing-results/rules/rules-overview/#conditions).  """
    consequence: Consequence
    description: Optional[str] = None
    """ Description of the rule's purpose to help you distinguish between different rules. """
    enabled: Optional[bool] = None
    """ Whether the rule is active. """
    validity: Optional[List[TimeRange]] = None
    """ Time periods when the rule is active. """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Rule from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Rule from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["conditions"] = (
            [Condition.from_dict(_item) for _item in obj["conditions"]]
            if obj.get("conditions") is not None
            else None
        )
        obj["consequence"] = (
            Consequence.from_dict(obj["consequence"])
            if obj.get("consequence") is not None
            else None
        )
        obj["validity"] = (
            [TimeRange.from_dict(_item) for _item in obj["validity"]]
            if obj.get("validity") is not None
            else None
        )

        return cls.model_validate(obj)
