# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.search.models.log_query import LogQuery

_ALIASES = {
    "timestamp": "timestamp",
    "method": "method",
    "answer_code": "answer_code",
    "query_body": "query_body",
    "answer": "answer",
    "url": "url",
    "ip": "ip",
    "query_headers": "query_headers",
    "sha1": "sha1",
    "nb_api_calls": "nb_api_calls",
    "processing_time_ms": "processing_time_ms",
    "index": "index",
    "var_query_params": "query_params",
    "query_nb_hits": "query_nb_hits",
    "inner_queries": "inner_queries",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Log(BaseModel):
    """
    Log
    """

    timestamp: str
    """ Date and time of the API request, in RFC 3339 format. """
    method: str
    """ HTTP method of the request. """
    answer_code: str
    """ HTTP status code of the response. """
    query_body: str
    """ Request body. """
    answer: str
    """ Response body. """
    url: str
    """ URL of the API endpoint. """
    ip: str
    """ IP address of the client that performed the request. """
    query_headers: str
    """ Request headers (API keys are obfuscated). """
    sha1: str
    """ SHA1 signature of the log entry. """
    nb_api_calls: Optional[str] = None
    """ Number of API requests. """
    processing_time_ms: str
    """ Processing time for the query in milliseconds. This doesn't include latency due to the network.  """
    index: Optional[str] = None
    """ Index targeted by the query. """
    var_query_params: Optional[str] = None
    """ Query parameters sent with the request. """
    query_nb_hits: Optional[str] = None
    """ Number of search results (hits) returned for the query. """
    inner_queries: Optional[List[LogQuery]] = None
    """ Queries performed for the given request. """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Log from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Log from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["inner_queries"] = (
            [LogQuery.from_dict(_item) for _item in obj["inner_queries"]]
            if obj.get("inner_queries") is not None
            else None
        )

        return cls.model_validate(obj)
