# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import dumps
from sys import version_info
from typing import Any, Dict, List, Optional, Union
from urllib.parse import quote

from pydantic import Field, StrictInt, StrictStr
from typing_extensions import Annotated

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self

from algoliasearch.http.api_response import ApiResponse
from algoliasearch.http.base_config import BaseConfig
from algoliasearch.http.request_options import RequestOptions
from algoliasearch.http.serializer import body_serializer
from algoliasearch.http.transporter import Transporter
from algoliasearch.http.transporter_sync import TransporterSync
from algoliasearch.http.verb import Verb
from algoliasearch.recommend.config import RecommendConfig
from algoliasearch.recommend.models.deleted_at_response import DeletedAtResponse
from algoliasearch.recommend.models.get_recommend_task_response import (
    GetRecommendTaskResponse,
)
from algoliasearch.recommend.models.get_recommendations_params import (
    GetRecommendationsParams,
)
from algoliasearch.recommend.models.get_recommendations_response import (
    GetRecommendationsResponse,
)
from algoliasearch.recommend.models.recommend_models import RecommendModels
from algoliasearch.recommend.models.recommend_rule import RecommendRule
from algoliasearch.recommend.models.recommend_updated_at_response import (
    RecommendUpdatedAtResponse,
)
from algoliasearch.recommend.models.search_recommend_rules_params import (
    SearchRecommendRulesParams,
)
from algoliasearch.recommend.models.search_recommend_rules_response import (
    SearchRecommendRulesResponse,
)


class RecommendClient:
    """The Algolia 'RecommendClient' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.


    Returns:
    The initialized API client.

    Example:
    _client = RecommendClient("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY")
    _client_with_named_args = RecommendClient(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY")

    See `RecommendClient.create_with_config` for advanced configuration.
    """

    _transporter: Transporter
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        transporter: Optional[Transporter] = None,
        config: Optional[RecommendConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = RecommendConfig(
                transporter.config.app_id, transporter.config.api_key
            )

        if config is None:
            config = RecommendConfig(app_id, api_key)
        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = Transporter(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls, config: RecommendConfig, transporter: Optional[Transporter] = None
    ) -> RecommendClient:
        """Allows creating a client with a customized `RecommendConfig` and `Transporter`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (RecommendConfig): The config of the API client.
        transporter (Transporter): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = RecommendClient.create_with_config(config=RecommendConfig(...))
        _client_with_custom_config_and_transporter = RecommendClient.create_with_config(config=RecommendConfig(...), transporter=Transporter(...))
        """
        if transporter is None:
            transporter = Transporter(config)

        return RecommendClient(
            app_id=config.app_id,
            api_key=config.api_key,
            transporter=transporter,
            config=config,
        )

    async def __aenter__(self) -> Self:
        return self

    async def __aexit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        await self.close()

    async def close(self) -> None:
        """Closes the underlying `transporter` of the API client."""
        return await self._transporter.close()

    async def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    async def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    async def batch_recommend_rules_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        recommend_rule: Union[
            Optional[List[RecommendRule]], list[dict[str, Any]]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create or update a batch of Recommend Rules  Each Recommend Rule is created or updated, depending on whether a Recommend Rule with the same `objectID` already exists. You may also specify `true` for `clearExistingRules`, in which case the batch will atomically replace all the existing Recommend Rules.  Recommend Rules are similar to Search Rules, except that the conditions and consequences apply to a [source item](/doc/guides/algolia-recommend/overview/#recommend-models) instead of a query. The main differences are the following: - Conditions `pattern` and `anchoring` are unavailable. - Condition `filters` triggers if the source item matches the specified filters. - Condition `filters` accepts numeric filters. - Consequence `params` only covers filtering parameters. - Consequence `automaticFacetFilters` doesn't require a facet value placeholder (it tries to match the data source item's attributes instead).

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param recommend_rule:
        :type recommend_rule: List[RecommendRule]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `batch_recommend_rules`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `batch_recommend_rules`."
            )

        _data = {}
        if recommend_rule is not None:
            _data = recommend_rule

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/{indexName}/{model}/recommend/rules/batch".replace(
                "{indexName}", quote(str(index_name), safe="")
            ).replace("{model}", quote(str(model), safe="")),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def batch_recommend_rules(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        recommend_rule: Union[
            Optional[List[RecommendRule]], list[dict[str, Any]]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RecommendUpdatedAtResponse:
        """
        Create or update a batch of Recommend Rules  Each Recommend Rule is created or updated, depending on whether a Recommend Rule with the same `objectID` already exists. You may also specify `true` for `clearExistingRules`, in which case the batch will atomically replace all the existing Recommend Rules.  Recommend Rules are similar to Search Rules, except that the conditions and consequences apply to a [source item](/doc/guides/algolia-recommend/overview/#recommend-models) instead of a query. The main differences are the following: - Conditions `pattern` and `anchoring` are unavailable. - Condition `filters` triggers if the source item matches the specified filters. - Condition `filters` accepts numeric filters. - Consequence `params` only covers filtering parameters. - Consequence `automaticFacetFilters` doesn't require a facet value placeholder (it tries to match the data source item's attributes instead).

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param recommend_rule:
        :type recommend_rule: List[RecommendRule]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RecommendUpdatedAtResponse' result object.
        """
        resp = await self.batch_recommend_rules_with_http_info(
            index_name, model, recommend_rule, request_options
        )
        return resp.deserialize(RecommendUpdatedAtResponse, resp.raw_data)

    async def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_delete_with_http_info(
            path, parameters, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return await self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    async def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_post_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return await self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = await self.custom_put_with_http_info(
            path, parameters, body, request_options
        )
        return resp.deserialize(object, resp.raw_data)

    async def delete_recommend_rule_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes a Recommend rule from a recommendation scenario.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `delete_recommend_rule`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `delete_recommend_rule`."
            )

        if object_id is None:
            raise ValueError(
                "Parameter `object_id` is required when calling `delete_recommend_rule`."
            )

        return await self._transporter.request(
            verb=Verb.DELETE,
            path="/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{objectID}", quote(str(object_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def delete_recommend_rule(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeletedAtResponse:
        """
        Deletes a Recommend rule from a recommendation scenario.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeletedAtResponse' result object.
        """
        resp = await self.delete_recommend_rule_with_http_info(
            index_name, model, object_id, request_options
        )
        return resp.deserialize(DeletedAtResponse, resp.raw_data)

    async def get_recommend_rule_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves a Recommend rule that you previously created in the Algolia dashboard.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_recommend_rule`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `get_recommend_rule`."
            )

        if object_id is None:
            raise ValueError(
                "Parameter `object_id` is required when calling `get_recommend_rule`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{objectID}", quote(str(object_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_recommend_rule(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RecommendRule:
        """
        Retrieves a Recommend rule that you previously created in the Algolia dashboard.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RecommendRule' result object.
        """
        resp = await self.get_recommend_rule_with_http_info(
            index_name, model, object_id, request_options
        )
        return resp.deserialize(RecommendRule, resp.raw_data)

    async def get_recommend_status_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        task_id: Annotated[StrictInt, Field(description="Unique task identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Checks the status of a given task.  Deleting a Recommend rule is asynchronous. When you delete a rule, a task is created on a queue and completed depending on the load on the server. The API response includes a task ID that you can use to check the status.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param task_id: Unique task identifier. (required)
        :type task_id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_recommend_status`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `get_recommend_status`."
            )

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `get_recommend_status`."
            )

        return await self._transporter.request(
            verb=Verb.GET,
            path="/1/indexes/{indexName}/{model}/task/{taskID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{taskID}", quote(str(task_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    async def get_recommend_status(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        task_id: Annotated[StrictInt, Field(description="Unique task identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetRecommendTaskResponse:
        """
        Checks the status of a given task.  Deleting a Recommend rule is asynchronous. When you delete a rule, a task is created on a queue and completed depending on the load on the server. The API response includes a task ID that you can use to check the status.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param task_id: Unique task identifier. (required)
        :type task_id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetRecommendTaskResponse' result object.
        """
        resp = await self.get_recommend_status_with_http_info(
            index_name, model, task_id, request_options
        )
        return resp.deserialize(GetRecommendTaskResponse, resp.raw_data)

    async def get_recommendations_with_http_info(
        self,
        get_recommendations_params: Union[GetRecommendationsParams, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves recommendations from selected AI models.

        Required API Key ACLs:
          - search

        :param get_recommendations_params: (required)
        :type get_recommendations_params: GetRecommendationsParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if get_recommendations_params is None:
            raise ValueError(
                "Parameter `get_recommendations_params` is required when calling `get_recommendations`."
            )

        _data = {}
        if get_recommendations_params is not None:
            _data = get_recommendations_params

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/*/recommendations",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=True,
        )

    async def get_recommendations(
        self,
        get_recommendations_params: Union[GetRecommendationsParams, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetRecommendationsResponse:
        """
        Retrieves recommendations from selected AI models.

        Required API Key ACLs:
          - search

        :param get_recommendations_params: (required)
        :type get_recommendations_params: GetRecommendationsParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetRecommendationsResponse' result object.
        """
        resp = await self.get_recommendations_with_http_info(
            get_recommendations_params, request_options
        )
        return resp.deserialize(GetRecommendationsResponse, resp.raw_data)

    async def search_recommend_rules_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        search_recommend_rules_params: Union[
            Optional[SearchRecommendRulesParams], dict[str, Any]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Searches for Recommend rules.  Use an empty query to list all rules for this recommendation scenario.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param search_recommend_rules_params:
        :type search_recommend_rules_params: SearchRecommendRulesParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `search_recommend_rules`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `search_recommend_rules`."
            )

        _data = {}
        if search_recommend_rules_params is not None:
            _data = search_recommend_rules_params

        return await self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/{indexName}/{model}/recommend/rules/search".replace(
                "{indexName}", quote(str(index_name), safe="")
            ).replace("{model}", quote(str(model), safe="")),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=True,
        )

    async def search_recommend_rules(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        search_recommend_rules_params: Union[
            Optional[SearchRecommendRulesParams], dict[str, Any]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> SearchRecommendRulesResponse:
        """
        Searches for Recommend rules.  Use an empty query to list all rules for this recommendation scenario.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param search_recommend_rules_params:
        :type search_recommend_rules_params: SearchRecommendRulesParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'SearchRecommendRulesResponse' result object.
        """
        resp = await self.search_recommend_rules_with_http_info(
            index_name, model, search_recommend_rules_params, request_options
        )
        return resp.deserialize(SearchRecommendRulesResponse, resp.raw_data)


class RecommendClientSync:
    """The Algolia 'RecommendClientSync' class.

    Args:
    app_id (str): The Algolia application ID to retrieve information from.
    api_key (str): The Algolia api key bound to the given `app_id`.


    Returns:
    The initialized API client.

    Example:
    _client = RecommendClientSync("YOUR_ALGOLIA_APP_ID", "YOUR_ALGOLIA_API_KEY")
    _client_with_named_args = RecommendClientSync(app_id="YOUR_ALGOLIA_APP_ID", api_key="YOUR_ALGOLIA_API_KEY")

    See `RecommendClientSync.create_with_config` for advanced configuration.
    """

    _transporter: TransporterSync
    _config: BaseConfig
    _request_options: RequestOptions

    def __init__(
        self,
        app_id: Optional[str] = None,
        api_key: Optional[str] = None,
        transporter: Optional[TransporterSync] = None,
        config: Optional[RecommendConfig] = None,
    ) -> None:
        if transporter is not None and config is None:
            config = RecommendConfig(
                transporter.config.app_id, transporter.config.api_key
            )

        if config is None:
            config = RecommendConfig(app_id, api_key)
        self._config = config
        self._request_options = RequestOptions(config)

        if transporter is None:
            transporter = TransporterSync(config)
        self._transporter = transporter

    @classmethod
    def create_with_config(
        cls, config: RecommendConfig, transporter: Optional[TransporterSync] = None
    ) -> RecommendClientSync:
        """Allows creating a client with a customized `RecommendConfig` and `TransporterSync`. If `transporter` is not provided, the default one will be initialized from the given `config`.

        Args:
        config (RecommendConfig): The config of the API client.
        transporter (TransporterSync): The HTTP transporter, see `http/transporter.py` for implementation details.

        Returns:
        The initialized API client.

        Example:
        _client_with_custom_config = RecommendClientSync.create_with_config(config=RecommendConfig(...))
        _client_with_custom_config_and_transporter = RecommendClientSync.create_with_config(config=RecommendConfig(...), transporter=TransporterSync(...))
        """
        if transporter is None:
            transporter = TransporterSync(config)

        return RecommendClientSync(
            app_id=config.app_id,
            api_key=config.api_key,
            transporter=transporter,
            config=config,
        )

    def __enter__(self) -> Self:
        return self

    def __exit__(self, exc_type, exc_value, traceback) -> None:
        """Closes the underlying `transporter` of the API client."""
        self.close()

    def close(self) -> None:
        return self._transporter.close()

    def set_client_api_key(self, api_key: str) -> None:
        """Sets a new API key to authenticate requests."""
        self._transporter.config.set_client_api_key(api_key)

    def add_user_agent(self, segment: str, version: Optional[str] = None) -> None:
        """adds a segment to the default user agent, and update the headers sent with each requests as well"""
        self._transporter.config.add_user_agent(segment, version)

    def batch_recommend_rules_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        recommend_rule: Union[
            Optional[List[RecommendRule]], list[dict[str, Any]]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Create or update a batch of Recommend Rules  Each Recommend Rule is created or updated, depending on whether a Recommend Rule with the same `objectID` already exists. You may also specify `true` for `clearExistingRules`, in which case the batch will atomically replace all the existing Recommend Rules.  Recommend Rules are similar to Search Rules, except that the conditions and consequences apply to a [source item](/doc/guides/algolia-recommend/overview/#recommend-models) instead of a query. The main differences are the following: - Conditions `pattern` and `anchoring` are unavailable. - Condition `filters` triggers if the source item matches the specified filters. - Condition `filters` accepts numeric filters. - Consequence `params` only covers filtering parameters. - Consequence `automaticFacetFilters` doesn't require a facet value placeholder (it tries to match the data source item's attributes instead).

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param recommend_rule:
        :type recommend_rule: List[RecommendRule]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `batch_recommend_rules`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `batch_recommend_rules`."
            )

        _data = {}
        if recommend_rule is not None:
            _data = recommend_rule

        return self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/{indexName}/{model}/recommend/rules/batch".replace(
                "{indexName}", quote(str(index_name), safe="")
            ).replace("{model}", quote(str(model), safe="")),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def batch_recommend_rules(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        recommend_rule: Union[
            Optional[List[RecommendRule]], list[dict[str, Any]]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RecommendUpdatedAtResponse:
        """
        Create or update a batch of Recommend Rules  Each Recommend Rule is created or updated, depending on whether a Recommend Rule with the same `objectID` already exists. You may also specify `true` for `clearExistingRules`, in which case the batch will atomically replace all the existing Recommend Rules.  Recommend Rules are similar to Search Rules, except that the conditions and consequences apply to a [source item](/doc/guides/algolia-recommend/overview/#recommend-models) instead of a query. The main differences are the following: - Conditions `pattern` and `anchoring` are unavailable. - Condition `filters` triggers if the source item matches the specified filters. - Condition `filters` accepts numeric filters. - Consequence `params` only covers filtering parameters. - Consequence `automaticFacetFilters` doesn't require a facet value placeholder (it tries to match the data source item's attributes instead).

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param recommend_rule:
        :type recommend_rule: List[RecommendRule]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RecommendUpdatedAtResponse' result object.
        """
        resp = self.batch_recommend_rules_with_http_info(
            index_name, model, recommend_rule, request_options
        )
        return resp.deserialize(RecommendUpdatedAtResponse, resp.raw_data)

    def custom_delete_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError(
                "Parameter `path` is required when calling `custom_delete`."
            )

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_delete(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_delete_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_get_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_get`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        return self._transporter.request(
            verb=Verb.GET,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_get(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_get_with_http_info(path, parameters, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_post_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_post`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.POST,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_post(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_post_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def custom_put_with_http_info(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if path is None:
            raise ValueError("Parameter `path` is required when calling `custom_put`.")

        _query_parameters: Dict[str, Any] = {}

        if parameters is not None:
            for _qpkey, _qpvalue in parameters.items():
                _query_parameters[_qpkey] = _qpvalue

        _data = {}
        if body is not None:
            _data = body

        return self._transporter.request(
            verb=Verb.PUT,
            path="/{path}".replace("{path}", path),
            request_options=self._request_options.merge(
                query_parameters=_query_parameters,
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def custom_put(
        self,
        path: Annotated[
            StrictStr,
            Field(
                description='Path of the endpoint, anything after "/1" must be specified.'
            ),
        ],
        parameters: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Query parameters to apply to the current query."),
        ] = None,
        body: Annotated[
            Optional[Dict[str, Any]],
            Field(description="Parameters to send with the custom request."),
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> object:
        """
        This method allow you to send requests to the Algolia REST API.


        :param path: Path of the endpoint, anything after \"/1\" must be specified. (required)
        :type path: str
        :param parameters: Query parameters to apply to the current query.
        :type parameters: Dict[str, object]
        :param body: Parameters to send with the custom request.
        :type body: object
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'object' result object.
        """
        resp = self.custom_put_with_http_info(path, parameters, body, request_options)
        return resp.deserialize(object, resp.raw_data)

    def delete_recommend_rule_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Deletes a Recommend rule from a recommendation scenario.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `delete_recommend_rule`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `delete_recommend_rule`."
            )

        if object_id is None:
            raise ValueError(
                "Parameter `object_id` is required when calling `delete_recommend_rule`."
            )

        return self._transporter.request(
            verb=Verb.DELETE,
            path="/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{objectID}", quote(str(object_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def delete_recommend_rule(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> DeletedAtResponse:
        """
        Deletes a Recommend rule from a recommendation scenario.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'DeletedAtResponse' result object.
        """
        resp = self.delete_recommend_rule_with_http_info(
            index_name, model, object_id, request_options
        )
        return resp.deserialize(DeletedAtResponse, resp.raw_data)

    def get_recommend_rule_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves a Recommend rule that you previously created in the Algolia dashboard.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_recommend_rule`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `get_recommend_rule`."
            )

        if object_id is None:
            raise ValueError(
                "Parameter `object_id` is required when calling `get_recommend_rule`."
            )

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/indexes/{indexName}/{model}/recommend/rules/{objectID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{objectID}", quote(str(object_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_recommend_rule(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        object_id: Annotated[StrictStr, Field(description="Unique record identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> RecommendRule:
        """
        Retrieves a Recommend rule that you previously created in the Algolia dashboard.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param object_id: Unique record identifier. (required)
        :type object_id: str
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'RecommendRule' result object.
        """
        resp = self.get_recommend_rule_with_http_info(
            index_name, model, object_id, request_options
        )
        return resp.deserialize(RecommendRule, resp.raw_data)

    def get_recommend_status_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        task_id: Annotated[StrictInt, Field(description="Unique task identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Checks the status of a given task.  Deleting a Recommend rule is asynchronous. When you delete a rule, a task is created on a queue and completed depending on the load on the server. The API response includes a task ID that you can use to check the status.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param task_id: Unique task identifier. (required)
        :type task_id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `get_recommend_status`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `get_recommend_status`."
            )

        if task_id is None:
            raise ValueError(
                "Parameter `task_id` is required when calling `get_recommend_status`."
            )

        return self._transporter.request(
            verb=Verb.GET,
            path="/1/indexes/{indexName}/{model}/task/{taskID}".replace(
                "{indexName}", quote(str(index_name), safe="")
            )
            .replace("{model}", quote(str(model), safe=""))
            .replace("{taskID}", quote(str(task_id), safe="")),
            request_options=self._request_options.merge(
                user_request_options=request_options,
            ),
            use_read_transporter=False,
        )

    def get_recommend_status(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        task_id: Annotated[StrictInt, Field(description="Unique task identifier.")],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetRecommendTaskResponse:
        """
        Checks the status of a given task.  Deleting a Recommend rule is asynchronous. When you delete a rule, a task is created on a queue and completed depending on the load on the server. The API response includes a task ID that you can use to check the status.

        Required API Key ACLs:
          - editSettings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param task_id: Unique task identifier. (required)
        :type task_id: int
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetRecommendTaskResponse' result object.
        """
        resp = self.get_recommend_status_with_http_info(
            index_name, model, task_id, request_options
        )
        return resp.deserialize(GetRecommendTaskResponse, resp.raw_data)

    def get_recommendations_with_http_info(
        self,
        get_recommendations_params: Union[GetRecommendationsParams, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Retrieves recommendations from selected AI models.

        Required API Key ACLs:
          - search

        :param get_recommendations_params: (required)
        :type get_recommendations_params: GetRecommendationsParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if get_recommendations_params is None:
            raise ValueError(
                "Parameter `get_recommendations_params` is required when calling `get_recommendations`."
            )

        _data = {}
        if get_recommendations_params is not None:
            _data = get_recommendations_params

        return self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/*/recommendations",
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=True,
        )

    def get_recommendations(
        self,
        get_recommendations_params: Union[GetRecommendationsParams, dict[str, Any]],
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> GetRecommendationsResponse:
        """
        Retrieves recommendations from selected AI models.

        Required API Key ACLs:
          - search

        :param get_recommendations_params: (required)
        :type get_recommendations_params: GetRecommendationsParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'GetRecommendationsResponse' result object.
        """
        resp = self.get_recommendations_with_http_info(
            get_recommendations_params, request_options
        )
        return resp.deserialize(GetRecommendationsResponse, resp.raw_data)

    def search_recommend_rules_with_http_info(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        search_recommend_rules_params: Union[
            Optional[SearchRecommendRulesParams], dict[str, Any]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> ApiResponse[str]:
        """
        Searches for Recommend rules.  Use an empty query to list all rules for this recommendation scenario.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param search_recommend_rules_params:
        :type search_recommend_rules_params: SearchRecommendRulesParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the raw algoliasearch 'APIResponse' object.
        """

        if index_name is None:
            raise ValueError(
                "Parameter `index_name` is required when calling `search_recommend_rules`."
            )

        if model is None:
            raise ValueError(
                "Parameter `model` is required when calling `search_recommend_rules`."
            )

        _data = {}
        if search_recommend_rules_params is not None:
            _data = search_recommend_rules_params

        return self._transporter.request(
            verb=Verb.POST,
            path="/1/indexes/{indexName}/{model}/recommend/rules/search".replace(
                "{indexName}", quote(str(index_name), safe="")
            ).replace("{model}", quote(str(model), safe="")),
            request_options=self._request_options.merge(
                data=dumps(body_serializer(_data)),
                user_request_options=request_options,
            ),
            use_read_transporter=True,
        )

    def search_recommend_rules(
        self,
        index_name: Annotated[
            StrictStr,
            Field(description="Name of the index on which to perform the operation."),
        ],
        model: Union[
            Annotated[
                RecommendModels,
                Field(
                    description="[Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models). "
                ),
            ],
            str,
        ],
        search_recommend_rules_params: Union[
            Optional[SearchRecommendRulesParams], dict[str, Any]
        ] = None,
        request_options: Optional[Union[dict, RequestOptions]] = None,
    ) -> SearchRecommendRulesResponse:
        """
        Searches for Recommend rules.  Use an empty query to list all rules for this recommendation scenario.

        Required API Key ACLs:
          - settings

        :param index_name: Name of the index on which to perform the operation. (required)
        :type index_name: str
        :param model: [Recommend model](https://www.algolia.com/doc/guides/algolia-recommend/overview/#recommend-models).  (required)
        :type model: RecommendModels
        :param search_recommend_rules_params:
        :type search_recommend_rules_params: SearchRecommendRulesParams
        :param request_options: The request options to send along with the query, they will be merged with the transporter base parameters (headers, query params, timeouts, etc.). (optional)
        :return: Returns the deserialized response in a 'SearchRecommendRulesResponse' result object.
        """
        resp = self.search_recommend_rules_with_http_info(
            index_name, model, search_recommend_rules_params, request_options
        )
        return resp.deserialize(SearchRecommendRulesResponse, resp.raw_data)
