# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.personalization.models.event_scoring import EventScoring
from algoliasearch.personalization.models.facet_scoring import FacetScoring

_ALIASES = {
    "event_scoring": "eventScoring",
    "facet_scoring": "facetScoring",
    "personalization_impact": "personalizationImpact",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class PersonalizationStrategyParams(BaseModel):
    """
    PersonalizationStrategyParams
    """

    event_scoring: List[EventScoring]
    """ Scores associated with each event.  The higher the scores, the higher the impact of those events on the personalization of search results.  """
    facet_scoring: List[FacetScoring]
    """ Scores associated with each facet.  The higher the scores, the higher the impact of those events on the personalization of search results.  """
    personalization_impact: int
    """ Impact of personalization on the search results.  If set to 0, personalization has no impact on the search results.  """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PersonalizationStrategyParams from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PersonalizationStrategyParams from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["eventScoring"] = (
            [EventScoring.from_dict(_item) for _item in obj["eventScoring"]]
            if obj.get("eventScoring") is not None
            else None
        )
        obj["facetScoring"] = (
            [FacetScoring.from_dict(_item) for _item in obj["facetScoring"]]
            if obj.get("facetScoring") is not None
            else None
        )

        return cls.model_validate(obj)
