# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.monitoring.models.probes_metric import ProbesMetric

_ALIASES = {
    "cpu_usage": "cpu_usage",
    "ram_indexing_usage": "ram_indexing_usage",
    "ram_search_usage": "ram_search_usage",
    "ssd_usage": "ssd_usage",
    "avg_build_time": "avg_build_time",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Metrics(BaseModel):
    """
    Metrics
    """

    cpu_usage: Optional[Dict[str, List[ProbesMetric]]] = None
    """ CPU idleness in %. """
    ram_indexing_usage: Optional[Dict[str, List[ProbesMetric]]] = None
    """ RAM used for indexing in MB. """
    ram_search_usage: Optional[Dict[str, List[ProbesMetric]]] = None
    """ RAM used for search in MB. """
    ssd_usage: Optional[Dict[str, List[ProbesMetric]]] = None
    """ Solid-state disk (SSD) usage expressed as % of RAM.  0% means no SSD usage. A value of 50% indicates 32&nbsp;GB SSD usage for a machine with 64&nbsp;RAM.  """
    avg_build_time: Optional[Dict[str, List[ProbesMetric]]] = None
    """ Average build time of the indices in seconds. """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Metrics from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Metrics from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["cpu_usage"] = dict(
            (
                _k,
                [ProbesMetric.from_dict(_item) for _item in _v]
                if _v is not None
                else None,
            )
            for _k, _v in obj.get("cpu_usage", {}).items()
        )
        obj["ram_indexing_usage"] = dict(
            (
                _k,
                [ProbesMetric.from_dict(_item) for _item in _v]
                if _v is not None
                else None,
            )
            for _k, _v in obj.get("ram_indexing_usage", {}).items()
        )
        obj["ram_search_usage"] = dict(
            (
                _k,
                [ProbesMetric.from_dict(_item) for _item in _v]
                if _v is not None
                else None,
            )
            for _k, _v in obj.get("ram_search_usage", {}).items()
        )
        obj["ssd_usage"] = dict(
            (
                _k,
                [ProbesMetric.from_dict(_item) for _item in _v]
                if _v is not None
                else None,
            )
            for _k, _v in obj.get("ssd_usage", {}).items()
        )
        obj["avg_build_time"] = dict(
            (
                _k,
                [ProbesMetric.from_dict(_item) for _item in _v]
                if _v is not None
                else None,
            )
            for _k, _v in obj.get("avg_build_time", {}).items()
        )

        return cls.model_validate(obj)
