# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, List, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


_ALIASES = {
    "transformation_id": "transformationID",
    "authentication_ids": "authenticationIDs",
    "code": "code",
    "name": "name",
    "description": "description",
    "created_at": "createdAt",
    "updated_at": "updatedAt",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Transformation(BaseModel):
    """
    Transformation
    """

    transformation_id: str
    """ Universally unique identifier (UUID) of a transformation. """
    authentication_ids: Optional[List[str]] = None
    """ The authentications associated with the current transformation. """
    code: str
    """ The source code of the transformation. """
    name: str
    """ The uniquely identified name of your transformation. """
    description: Optional[str] = None
    """ A descriptive name for your transformation of what it does. """
    created_at: str
    """ Date of creation in RFC 3339 format. """
    updated_at: Optional[str] = None
    """ Date of last update in RFC 3339 format. """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Transformation from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Transformation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        return cls.model_validate(obj)
