# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.ingestion.models.mapping_type_csv import MappingTypeCSV
from algoliasearch.ingestion.models.method_type import MethodType

_ALIASES = {
    "url": "url",
    "unique_id_column": "uniqueIDColumn",
    "mapping": "mapping",
    "method": "method",
    "delimiter": "delimiter",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class SourceCSV(BaseModel):
    """
    SourceCSV
    """

    url: str
    """ URL of the file. """
    unique_id_column: Optional[str] = None
    """ Name of a column that contains a unique ID which will be used as `objectID` in Algolia. """
    mapping: Optional[Dict[str, MappingTypeCSV]] = None
    """ Key-value pairs of column names and their expected types.  """
    method: Optional[MethodType] = None
    delimiter: Optional[str] = None
    """ The character used to split the value on each line, default to a comma (\\r, \\n, 0xFFFD, and space are forbidden). """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SourceCSV from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SourceCSV from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        mapping = obj.get("mapping")
        if mapping is not None:
            obj["mapping"] = dict((_k, _v) for _k, _v in mapping.items())
        obj["method"] = obj.get("method")

        return cls.model_validate(obj)
