# coding: utf-8

"""
Code generated by OpenAPI Generator (https://openapi-generator.tech), manual changes will be lost - read more on https://github.com/algolia/api-clients-automation. DO NOT EDIT.
"""

from __future__ import annotations

from json import loads
from sys import version_info
from typing import Any, Dict, Optional

from pydantic import BaseModel, ConfigDict

if version_info >= (3, 11):
    from typing import Self
else:
    from typing_extensions import Self


from algoliasearch.abtesting.models.currency import Currency
from algoliasearch.abtesting.models.filter_effects import FilterEffects

_ALIASES = {
    "add_to_cart_count": "addToCartCount",
    "add_to_cart_rate": "addToCartRate",
    "average_click_position": "averageClickPosition",
    "click_count": "clickCount",
    "click_through_rate": "clickThroughRate",
    "conversion_count": "conversionCount",
    "conversion_rate": "conversionRate",
    "currencies": "currencies",
    "description": "description",
    "estimated_sample_size": "estimatedSampleSize",
    "filter_effects": "filterEffects",
    "index": "index",
    "no_result_count": "noResultCount",
    "purchase_count": "purchaseCount",
    "purchase_rate": "purchaseRate",
    "search_count": "searchCount",
    "tracked_search_count": "trackedSearchCount",
    "traffic_percentage": "trafficPercentage",
    "user_count": "userCount",
    "tracked_user_count": "trackedUserCount",
}


def _alias_generator(name: str) -> str:
    return _ALIASES.get(name, name)


class Variant(BaseModel):
    """
    Variant
    """

    add_to_cart_count: int
    """ Number of add-to-cart events for this variant. """
    add_to_cart_rate: Optional[float] = None
    """ [Add-to-cart rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#add-to-cart-rate) for this variant.  """
    average_click_position: Optional[int] = None
    """ [Average click position](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-position) for this variant.  """
    click_count: int
    """ Number of click events for this variant. """
    click_through_rate: Optional[float] = None
    """ [Click-through rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#click-through-rate) for this variant.  """
    conversion_count: int
    """ Number of click events for this variant. """
    conversion_rate: Optional[float] = None
    """ [Conversion rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#conversion-rate) for this variant.  """
    currencies: Optional[Dict[str, Currency]] = None
    """ A/B test currencies. """
    description: Optional[str] = None
    """ Description for this variant. """
    estimated_sample_size: Optional[int] = None
    """ Estimated number of searches required to achieve the desired statistical significance.  The A/B test configuration must include a `mininmumDetectableEffect` setting for this number to be included in the response.  """
    filter_effects: Optional[FilterEffects] = None
    index: str
    """ Index name of the A/B test variant (case-sensitive). """
    no_result_count: int
    """ Number of [searches without results](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#searches-without-results) for this variant. """
    purchase_count: int
    """ Number of purchase events for this variant. """
    purchase_rate: Optional[float] = None
    """ [Purchase rate](https://www.algolia.com/doc/guides/search-analytics/concepts/metrics/#purchase-rate) for this variant.  """
    search_count: int
    """ Number of searches for this variant. """
    tracked_search_count: Optional[int] = None
    """ Number of tracked searches. Tracked searches are search requests where the `clickAnalytics` parameter is true. """
    traffic_percentage: int
    """ Percentage of search requests each variant receives. """
    user_count: int
    """ Number of users that made searches to this variant. """
    tracked_user_count: int
    """ Number of users that made tracked searches to this variant. """

    model_config = ConfigDict(
        use_enum_values=True,
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        alias_generator=_alias_generator,
    )

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_unset=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Variant from a JSON string"""
        return cls.from_dict(loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias."""
        return self.model_dump(
            by_alias=True,
            exclude_none=True,
            exclude_unset=True,
        )

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Variant from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        obj["currencies"] = (
            dict((_k, Currency.from_dict(_v)) for _k, _v in obj["currencies"].items())
            if obj.get("currencies") is not None
            else None
        )
        obj["filterEffects"] = (
            FilterEffects.from_dict(obj["filterEffects"])
            if obj.get("filterEffects") is not None
            else None
        )

        return cls.model_validate(obj)
