// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime

#if os(Linux)
    @preconcurrency import struct Foundation.URL
    @preconcurrency import struct Foundation.Data
    @preconcurrency import struct Foundation.Date
#else
    import struct Foundation.URL
    import struct Foundation.Data
    import struct Foundation.Date
#endif
/// A type that performs HTTP operations defined by the OpenAPI document.
public protocol APIProtocol: Sendable {
    /// Creates a model response for the given chat conversation.
    ///
    /// - Remark: HTTP `POST /chat/completions`.
    /// - Remark: Generated from `#/paths//chat/completions/post(createChatCompletion)`.
    func createChatCompletion(_ input: Operations.createChatCompletion.Input) async throws
        -> Operations.createChatCompletion.Output
    /// Creates a completion for the provided prompt and parameters.
    ///
    /// - Remark: HTTP `POST /completions`.
    /// - Remark: Generated from `#/paths//completions/post(createCompletion)`.
    func createCompletion(_ input: Operations.createCompletion.Input) async throws
        -> Operations.createCompletion.Output
    /// Creates a new edit for the provided input, instruction, and parameters.
    ///
    /// - Remark: HTTP `POST /edits`.
    /// - Remark: Generated from `#/paths//edits/post(createEdit)`.
    @available(*, deprecated)
    func createEdit(_ input: Operations.createEdit.Input) async throws
        -> Operations.createEdit.Output
    /// Creates an image given a prompt.
    ///
    /// - Remark: HTTP `POST /images/generations`.
    /// - Remark: Generated from `#/paths//images/generations/post(createImage)`.
    func createImage(_ input: Operations.createImage.Input) async throws
        -> Operations.createImage.Output
    /// Creates an edited or extended image given an original image and a prompt.
    ///
    /// - Remark: HTTP `POST /images/edits`.
    /// - Remark: Generated from `#/paths//images/edits/post(createImageEdit)`.
    func createImageEdit(_ input: Operations.createImageEdit.Input) async throws
        -> Operations.createImageEdit.Output
    /// Creates a variation of a given image.
    ///
    /// - Remark: HTTP `POST /images/variations`.
    /// - Remark: Generated from `#/paths//images/variations/post(createImageVariation)`.
    func createImageVariation(_ input: Operations.createImageVariation.Input) async throws
        -> Operations.createImageVariation.Output
    /// Creates an embedding vector representing the input text.
    ///
    /// - Remark: HTTP `POST /embeddings`.
    /// - Remark: Generated from `#/paths//embeddings/post(createEmbedding)`.
    func createEmbedding(_ input: Operations.createEmbedding.Input) async throws
        -> Operations.createEmbedding.Output
    /// Generates audio from the input text.
    ///
    /// - Remark: HTTP `POST /audio/speech`.
    /// - Remark: Generated from `#/paths//audio/speech/post(createSpeech)`.
    func createSpeech(_ input: Operations.createSpeech.Input) async throws
        -> Operations.createSpeech.Output
    /// Transcribes audio into the input language.
    ///
    /// - Remark: HTTP `POST /audio/transcriptions`.
    /// - Remark: Generated from `#/paths//audio/transcriptions/post(createTranscription)`.
    func createTranscription(_ input: Operations.createTranscription.Input) async throws
        -> Operations.createTranscription.Output
    /// Translates audio into English.
    ///
    /// - Remark: HTTP `POST /audio/translations`.
    /// - Remark: Generated from `#/paths//audio/translations/post(createTranslation)`.
    func createTranslation(_ input: Operations.createTranslation.Input) async throws
        -> Operations.createTranslation.Output
    /// Returns a list of files that belong to the user's organization.
    ///
    /// - Remark: HTTP `GET /files`.
    /// - Remark: Generated from `#/paths//files/get(listFiles)`.
    func listFiles(_ input: Operations.listFiles.Input) async throws -> Operations.listFiles.Output
    /// Upload a file that can be used across various endpoints/features. The size of all the files uploaded by one organization can be up to 100 GB.
    ///
    /// The size of individual files for can be a maximum of 512MB. See the [Assistants Tools guide](/docs/assistants/tools) to learn more about the types of files supported. The Fine-tuning API only supports `.jsonl` files.
    ///
    /// Please [contact us](https://help.openai.com/) if you need to increase these storage limits.
    ///
    ///
    /// - Remark: HTTP `POST /files`.
    /// - Remark: Generated from `#/paths//files/post(createFile)`.
    func createFile(_ input: Operations.createFile.Input) async throws
        -> Operations.createFile.Output
    /// Returns information about a specific file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/get(retrieveFile)`.
    func retrieveFile(_ input: Operations.retrieveFile.Input) async throws
        -> Operations.retrieveFile.Output
    /// Delete a file.
    ///
    /// - Remark: HTTP `DELETE /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/delete(deleteFile)`.
    func deleteFile(_ input: Operations.deleteFile.Input) async throws
        -> Operations.deleteFile.Output
    /// Returns the contents of the specified file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}/content`.
    /// - Remark: Generated from `#/paths//files/{file_id}/content/get(downloadFile)`.
    func downloadFile(_ input: Operations.downloadFile.Input) async throws
        -> Operations.downloadFile.Output
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/get(listPaginatedFineTuningJobs)`.
    func listPaginatedFineTuningJobs(_ input: Operations.listPaginatedFineTuningJobs.Input)
        async throws -> Operations.listPaginatedFineTuningJobs.Output
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/post(createFineTuningJob)`.
    func createFineTuningJob(_ input: Operations.createFineTuningJob.Input) async throws
        -> Operations.createFineTuningJob.Output
    /// Get info about a fine-tuning job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/get(retrieveFineTuningJob)`.
    func retrieveFineTuningJob(_ input: Operations.retrieveFineTuningJob.Input) async throws
        -> Operations.retrieveFineTuningJob.Output
    /// Get status updates for a fine-tuning job.
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}/events`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/events/get(listFineTuningEvents)`.
    func listFineTuningEvents(_ input: Operations.listFineTuningEvents.Input) async throws
        -> Operations.listFineTuningEvents.Output
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs/{fine_tuning_job_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/cancel/post(cancelFineTuningJob)`.
    func cancelFineTuningJob(_ input: Operations.cancelFineTuningJob.Input) async throws
        -> Operations.cancelFineTuningJob.Output
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/get(listFineTunes)`.
    @available(*, deprecated)
    func listFineTunes(_ input: Operations.listFineTunes.Input) async throws
        -> Operations.listFineTunes.Output
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/post(createFineTune)`.
    @available(*, deprecated)
    func createFineTune(_ input: Operations.createFineTune.Input) async throws
        -> Operations.createFineTune.Output
    /// Gets info about the fine-tune job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/get(retrieveFineTune)`.
    @available(*, deprecated)
    func retrieveFineTune(_ input: Operations.retrieveFineTune.Input) async throws
        -> Operations.retrieveFineTune.Output
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes/{fine_tune_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/cancel/post(cancelFineTune)`.
    @available(*, deprecated)
    func cancelFineTune(_ input: Operations.cancelFineTune.Input) async throws
        -> Operations.cancelFineTune.Output
    /// Get fine-grained status updates for a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}/events`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/events/get(listFineTuneEvents)`.
    @available(*, deprecated)
    func listFineTuneEvents(_ input: Operations.listFineTuneEvents.Input) async throws
        -> Operations.listFineTuneEvents.Output
    /// Lists the currently available models, and provides basic information about each one such as the owner and availability.
    ///
    /// - Remark: HTTP `GET /models`.
    /// - Remark: Generated from `#/paths//models/get(listModels)`.
    func listModels(_ input: Operations.listModels.Input) async throws
        -> Operations.listModels.Output
    /// Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
    ///
    /// - Remark: HTTP `GET /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/get(retrieveModel)`.
    func retrieveModel(_ input: Operations.retrieveModel.Input) async throws
        -> Operations.retrieveModel.Output
    /// Delete a fine-tuned model. You must have the Owner role in your organization to delete a model.
    ///
    /// - Remark: HTTP `DELETE /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/delete(deleteModel)`.
    func deleteModel(_ input: Operations.deleteModel.Input) async throws
        -> Operations.deleteModel.Output
    /// Classifies if text violates OpenAI's Content Policy
    ///
    /// - Remark: HTTP `POST /moderations`.
    /// - Remark: Generated from `#/paths//moderations/post(createModeration)`.
    func createModeration(_ input: Operations.createModeration.Input) async throws
        -> Operations.createModeration.Output
    /// Returns a list of assistants.
    ///
    /// - Remark: HTTP `GET /assistants`.
    /// - Remark: Generated from `#/paths//assistants/get(listAssistants)`.
    func listAssistants(_ input: Operations.listAssistants.Input) async throws
        -> Operations.listAssistants.Output
    /// Create an assistant with a model and instructions.
    ///
    /// - Remark: HTTP `POST /assistants`.
    /// - Remark: Generated from `#/paths//assistants/post(createAssistant)`.
    func createAssistant(_ input: Operations.createAssistant.Input) async throws
        -> Operations.createAssistant.Output
    /// Retrieves an assistant.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/get(getAssistant)`.
    func getAssistant(_ input: Operations.getAssistant.Input) async throws
        -> Operations.getAssistant.Output
    /// Modifies an assistant.
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/post(modifyAssistant)`.
    func modifyAssistant(_ input: Operations.modifyAssistant.Input) async throws
        -> Operations.modifyAssistant.Output
    /// Delete an assistant.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/delete(deleteAssistant)`.
    func deleteAssistant(_ input: Operations.deleteAssistant.Input) async throws
        -> Operations.deleteAssistant.Output
    /// Create a thread.
    ///
    /// - Remark: HTTP `POST /threads`.
    /// - Remark: Generated from `#/paths//threads/post(createThread)`.
    func createThread(_ input: Operations.createThread.Input) async throws
        -> Operations.createThread.Output
    /// Retrieves a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/get(getThread)`.
    func getThread(_ input: Operations.getThread.Input) async throws -> Operations.getThread.Output
    /// Modifies a thread.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/post(modifyThread)`.
    func modifyThread(_ input: Operations.modifyThread.Input) async throws
        -> Operations.modifyThread.Output
    /// Delete a thread.
    ///
    /// - Remark: HTTP `DELETE /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/delete(deleteThread)`.
    func deleteThread(_ input: Operations.deleteThread.Input) async throws
        -> Operations.deleteThread.Output
    /// Returns a list of messages for a given thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/get(listMessages)`.
    func listMessages(_ input: Operations.listMessages.Input) async throws
        -> Operations.listMessages.Output
    /// Create a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/post(createMessage)`.
    func createMessage(_ input: Operations.createMessage.Input) async throws
        -> Operations.createMessage.Output
    /// Retrieve a message.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/get(getMessage)`.
    func getMessage(_ input: Operations.getMessage.Input) async throws
        -> Operations.getMessage.Output
    /// Modifies a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/post(modifyMessage)`.
    func modifyMessage(_ input: Operations.modifyMessage.Input) async throws
        -> Operations.modifyMessage.Output
    /// Create a thread and run it in one request.
    ///
    /// - Remark: HTTP `POST /threads/runs`.
    /// - Remark: Generated from `#/paths//threads/runs/post(createThreadAndRun)`.
    func createThreadAndRun(_ input: Operations.createThreadAndRun.Input) async throws
        -> Operations.createThreadAndRun.Output
    /// Returns a list of runs belonging to a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/get(listRuns)`.
    func listRuns(_ input: Operations.listRuns.Input) async throws -> Operations.listRuns.Output
    /// Create a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/post(createRun)`.
    func createRun(_ input: Operations.createRun.Input) async throws -> Operations.createRun.Output
    /// Retrieves a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/get(getRun)`.
    func getRun(_ input: Operations.getRun.Input) async throws -> Operations.getRun.Output
    /// Modifies a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/post(modifyRun)`.
    func modifyRun(_ input: Operations.modifyRun.Input) async throws -> Operations.modifyRun.Output
    /// When a run has the `status: "requires_action"` and `required_action.type` is `submit_tool_outputs`, this endpoint can be used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single request.
    ///
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/submit_tool_outputs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/submit_tool_outputs/post(submitToolOuputsToRun)`.
    func submitToolOuputsToRun(_ input: Operations.submitToolOuputsToRun.Input) async throws
        -> Operations.submitToolOuputsToRun.Output
    /// Cancels a run that is `in_progress`.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/cancel/post(cancelRun)`.
    func cancelRun(_ input: Operations.cancelRun.Input) async throws -> Operations.cancelRun.Output
    /// Returns a list of run steps belonging to a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/get(listRunSteps)`.
    func listRunSteps(_ input: Operations.listRunSteps.Input) async throws
        -> Operations.listRunSteps.Output
    /// Retrieves a run step.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps/{step_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/{step_id}/get(getRunStep)`.
    func getRunStep(_ input: Operations.getRunStep.Input) async throws
        -> Operations.getRunStep.Output
    /// Returns a list of assistant files.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/get(listAssistantFiles)`.
    func listAssistantFiles(_ input: Operations.listAssistantFiles.Input) async throws
        -> Operations.listAssistantFiles.Output
    /// Create an assistant file by attaching a [File](/docs/api-reference/files) to an [assistant](/docs/api-reference/assistants).
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/post(createAssistantFile)`.
    func createAssistantFile(_ input: Operations.createAssistantFile.Input) async throws
        -> Operations.createAssistantFile.Output
    /// Retrieves an AssistantFile.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/get(getAssistantFile)`.
    func getAssistantFile(_ input: Operations.getAssistantFile.Input) async throws
        -> Operations.getAssistantFile.Output
    /// Delete an assistant file.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/delete(deleteAssistantFile)`.
    func deleteAssistantFile(_ input: Operations.deleteAssistantFile.Input) async throws
        -> Operations.deleteAssistantFile.Output
    /// Returns a list of message files.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/get(listMessageFiles)`.
    func listMessageFiles(_ input: Operations.listMessageFiles.Input) async throws
        -> Operations.listMessageFiles.Output
    /// Retrieves a message file.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/{file_id}/get(getMessageFile)`.
    func getMessageFile(_ input: Operations.getMessageFile.Input) async throws
        -> Operations.getMessageFile.Output
}

/// Convenience overloads for operation inputs.
extension APIProtocol {
    /// Creates a model response for the given chat conversation.
    ///
    /// - Remark: HTTP `POST /chat/completions`.
    /// - Remark: Generated from `#/paths//chat/completions/post(createChatCompletion)`.
    public func createChatCompletion(
        headers: Operations.createChatCompletion.Input.Headers = .init(),
        body: Operations.createChatCompletion.Input.Body
    ) async throws -> Operations.createChatCompletion.Output {
        try await createChatCompletion(
            Operations.createChatCompletion.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates a completion for the provided prompt and parameters.
    ///
    /// - Remark: HTTP `POST /completions`.
    /// - Remark: Generated from `#/paths//completions/post(createCompletion)`.
    public func createCompletion(
        headers: Operations.createCompletion.Input.Headers = .init(),
        body: Operations.createCompletion.Input.Body
    ) async throws -> Operations.createCompletion.Output {
        try await createCompletion(
            Operations.createCompletion.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates a new edit for the provided input, instruction, and parameters.
    ///
    /// - Remark: HTTP `POST /edits`.
    /// - Remark: Generated from `#/paths//edits/post(createEdit)`.
    @available(*, deprecated)
    public func createEdit(
        headers: Operations.createEdit.Input.Headers = .init(),
        body: Operations.createEdit.Input.Body
    ) async throws -> Operations.createEdit.Output {
        try await createEdit(
            Operations.createEdit.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates an image given a prompt.
    ///
    /// - Remark: HTTP `POST /images/generations`.
    /// - Remark: Generated from `#/paths//images/generations/post(createImage)`.
    public func createImage(
        headers: Operations.createImage.Input.Headers = .init(),
        body: Operations.createImage.Input.Body
    ) async throws -> Operations.createImage.Output {
        try await createImage(
            Operations.createImage.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates an edited or extended image given an original image and a prompt.
    ///
    /// - Remark: HTTP `POST /images/edits`.
    /// - Remark: Generated from `#/paths//images/edits/post(createImageEdit)`.
    public func createImageEdit(
        headers: Operations.createImageEdit.Input.Headers = .init(),
        body: Operations.createImageEdit.Input.Body
    ) async throws -> Operations.createImageEdit.Output {
        try await createImageEdit(
            Operations.createImageEdit.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates a variation of a given image.
    ///
    /// - Remark: HTTP `POST /images/variations`.
    /// - Remark: Generated from `#/paths//images/variations/post(createImageVariation)`.
    public func createImageVariation(
        headers: Operations.createImageVariation.Input.Headers = .init(),
        body: Operations.createImageVariation.Input.Body
    ) async throws -> Operations.createImageVariation.Output {
        try await createImageVariation(
            Operations.createImageVariation.Input(
                headers: headers,
                body: body
            ))
    }
    /// Creates an embedding vector representing the input text.
    ///
    /// - Remark: HTTP `POST /embeddings`.
    /// - Remark: Generated from `#/paths//embeddings/post(createEmbedding)`.
    public func createEmbedding(
        headers: Operations.createEmbedding.Input.Headers = .init(),
        body: Operations.createEmbedding.Input.Body
    ) async throws -> Operations.createEmbedding.Output {
        try await createEmbedding(
            Operations.createEmbedding.Input(
                headers: headers,
                body: body
            ))
    }
    /// Generates audio from the input text.
    ///
    /// - Remark: HTTP `POST /audio/speech`.
    /// - Remark: Generated from `#/paths//audio/speech/post(createSpeech)`.
    public func createSpeech(
        headers: Operations.createSpeech.Input.Headers = .init(),
        body: Operations.createSpeech.Input.Body
    ) async throws -> Operations.createSpeech.Output {
        try await createSpeech(
            Operations.createSpeech.Input(
                headers: headers,
                body: body
            ))
    }
    /// Transcribes audio into the input language.
    ///
    /// - Remark: HTTP `POST /audio/transcriptions`.
    /// - Remark: Generated from `#/paths//audio/transcriptions/post(createTranscription)`.
    public func createTranscription(
        headers: Operations.createTranscription.Input.Headers = .init(),
        body: Operations.createTranscription.Input.Body
    ) async throws -> Operations.createTranscription.Output {
        try await createTranscription(
            Operations.createTranscription.Input(
                headers: headers,
                body: body
            ))
    }
    /// Translates audio into English.
    ///
    /// - Remark: HTTP `POST /audio/translations`.
    /// - Remark: Generated from `#/paths//audio/translations/post(createTranslation)`.
    public func createTranslation(
        headers: Operations.createTranslation.Input.Headers = .init(),
        body: Operations.createTranslation.Input.Body
    ) async throws -> Operations.createTranslation.Output {
        try await createTranslation(
            Operations.createTranslation.Input(
                headers: headers,
                body: body
            ))
    }
    /// Returns a list of files that belong to the user's organization.
    ///
    /// - Remark: HTTP `GET /files`.
    /// - Remark: Generated from `#/paths//files/get(listFiles)`.
    public func listFiles(
        query: Operations.listFiles.Input.Query = .init(),
        headers: Operations.listFiles.Input.Headers = .init()
    ) async throws -> Operations.listFiles.Output {
        try await listFiles(
            Operations.listFiles.Input(
                query: query,
                headers: headers
            ))
    }
    /// Upload a file that can be used across various endpoints/features. The size of all the files uploaded by one organization can be up to 100 GB.
    ///
    /// The size of individual files for can be a maximum of 512MB. See the [Assistants Tools guide](/docs/assistants/tools) to learn more about the types of files supported. The Fine-tuning API only supports `.jsonl` files.
    ///
    /// Please [contact us](https://help.openai.com/) if you need to increase these storage limits.
    ///
    ///
    /// - Remark: HTTP `POST /files`.
    /// - Remark: Generated from `#/paths//files/post(createFile)`.
    public func createFile(
        headers: Operations.createFile.Input.Headers = .init(),
        body: Operations.createFile.Input.Body
    ) async throws -> Operations.createFile.Output {
        try await createFile(
            Operations.createFile.Input(
                headers: headers,
                body: body
            ))
    }
    /// Returns information about a specific file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/get(retrieveFile)`.
    public func retrieveFile(
        path: Operations.retrieveFile.Input.Path,
        headers: Operations.retrieveFile.Input.Headers = .init()
    ) async throws -> Operations.retrieveFile.Output {
        try await retrieveFile(
            Operations.retrieveFile.Input(
                path: path,
                headers: headers
            ))
    }
    /// Delete a file.
    ///
    /// - Remark: HTTP `DELETE /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/delete(deleteFile)`.
    public func deleteFile(
        path: Operations.deleteFile.Input.Path,
        headers: Operations.deleteFile.Input.Headers = .init()
    ) async throws -> Operations.deleteFile.Output {
        try await deleteFile(
            Operations.deleteFile.Input(
                path: path,
                headers: headers
            ))
    }
    /// Returns the contents of the specified file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}/content`.
    /// - Remark: Generated from `#/paths//files/{file_id}/content/get(downloadFile)`.
    public func downloadFile(
        path: Operations.downloadFile.Input.Path,
        headers: Operations.downloadFile.Input.Headers = .init()
    ) async throws -> Operations.downloadFile.Output {
        try await downloadFile(
            Operations.downloadFile.Input(
                path: path,
                headers: headers
            ))
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/get(listPaginatedFineTuningJobs)`.
    public func listPaginatedFineTuningJobs(
        query: Operations.listPaginatedFineTuningJobs.Input.Query = .init(),
        headers: Operations.listPaginatedFineTuningJobs.Input.Headers = .init()
    ) async throws -> Operations.listPaginatedFineTuningJobs.Output {
        try await listPaginatedFineTuningJobs(
            Operations.listPaginatedFineTuningJobs.Input(
                query: query,
                headers: headers
            ))
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/post(createFineTuningJob)`.
    public func createFineTuningJob(
        headers: Operations.createFineTuningJob.Input.Headers = .init(),
        body: Operations.createFineTuningJob.Input.Body
    ) async throws -> Operations.createFineTuningJob.Output {
        try await createFineTuningJob(
            Operations.createFineTuningJob.Input(
                headers: headers,
                body: body
            ))
    }
    /// Get info about a fine-tuning job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/get(retrieveFineTuningJob)`.
    public func retrieveFineTuningJob(
        path: Operations.retrieveFineTuningJob.Input.Path,
        headers: Operations.retrieveFineTuningJob.Input.Headers = .init()
    ) async throws -> Operations.retrieveFineTuningJob.Output {
        try await retrieveFineTuningJob(
            Operations.retrieveFineTuningJob.Input(
                path: path,
                headers: headers
            ))
    }
    /// Get status updates for a fine-tuning job.
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}/events`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/events/get(listFineTuningEvents)`.
    public func listFineTuningEvents(
        path: Operations.listFineTuningEvents.Input.Path,
        query: Operations.listFineTuningEvents.Input.Query = .init(),
        headers: Operations.listFineTuningEvents.Input.Headers = .init()
    ) async throws -> Operations.listFineTuningEvents.Output {
        try await listFineTuningEvents(
            Operations.listFineTuningEvents.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs/{fine_tuning_job_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/cancel/post(cancelFineTuningJob)`.
    public func cancelFineTuningJob(
        path: Operations.cancelFineTuningJob.Input.Path,
        headers: Operations.cancelFineTuningJob.Input.Headers = .init()
    ) async throws -> Operations.cancelFineTuningJob.Output {
        try await cancelFineTuningJob(
            Operations.cancelFineTuningJob.Input(
                path: path,
                headers: headers
            ))
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/get(listFineTunes)`.
    @available(*, deprecated)
    public func listFineTunes(headers: Operations.listFineTunes.Input.Headers = .init())
        async throws -> Operations.listFineTunes.Output
    {
        try await listFineTunes(Operations.listFineTunes.Input(headers: headers))
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/post(createFineTune)`.
    @available(*, deprecated)
    public func createFineTune(
        headers: Operations.createFineTune.Input.Headers = .init(),
        body: Operations.createFineTune.Input.Body
    ) async throws -> Operations.createFineTune.Output {
        try await createFineTune(
            Operations.createFineTune.Input(
                headers: headers,
                body: body
            ))
    }
    /// Gets info about the fine-tune job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/get(retrieveFineTune)`.
    @available(*, deprecated)
    public func retrieveFineTune(
        path: Operations.retrieveFineTune.Input.Path,
        headers: Operations.retrieveFineTune.Input.Headers = .init()
    ) async throws -> Operations.retrieveFineTune.Output {
        try await retrieveFineTune(
            Operations.retrieveFineTune.Input(
                path: path,
                headers: headers
            ))
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes/{fine_tune_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/cancel/post(cancelFineTune)`.
    @available(*, deprecated)
    public func cancelFineTune(
        path: Operations.cancelFineTune.Input.Path,
        headers: Operations.cancelFineTune.Input.Headers = .init()
    ) async throws -> Operations.cancelFineTune.Output {
        try await cancelFineTune(
            Operations.cancelFineTune.Input(
                path: path,
                headers: headers
            ))
    }
    /// Get fine-grained status updates for a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}/events`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/events/get(listFineTuneEvents)`.
    @available(*, deprecated)
    public func listFineTuneEvents(
        path: Operations.listFineTuneEvents.Input.Path,
        query: Operations.listFineTuneEvents.Input.Query = .init(),
        headers: Operations.listFineTuneEvents.Input.Headers = .init()
    ) async throws -> Operations.listFineTuneEvents.Output {
        try await listFineTuneEvents(
            Operations.listFineTuneEvents.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Lists the currently available models, and provides basic information about each one such as the owner and availability.
    ///
    /// - Remark: HTTP `GET /models`.
    /// - Remark: Generated from `#/paths//models/get(listModels)`.
    public func listModels(headers: Operations.listModels.Input.Headers = .init()) async throws
        -> Operations.listModels.Output
    {
        try await listModels(Operations.listModels.Input(headers: headers))
    }
    /// Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
    ///
    /// - Remark: HTTP `GET /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/get(retrieveModel)`.
    public func retrieveModel(
        path: Operations.retrieveModel.Input.Path,
        headers: Operations.retrieveModel.Input.Headers = .init()
    ) async throws -> Operations.retrieveModel.Output {
        try await retrieveModel(
            Operations.retrieveModel.Input(
                path: path,
                headers: headers
            ))
    }
    /// Delete a fine-tuned model. You must have the Owner role in your organization to delete a model.
    ///
    /// - Remark: HTTP `DELETE /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/delete(deleteModel)`.
    public func deleteModel(
        path: Operations.deleteModel.Input.Path,
        headers: Operations.deleteModel.Input.Headers = .init()
    ) async throws -> Operations.deleteModel.Output {
        try await deleteModel(
            Operations.deleteModel.Input(
                path: path,
                headers: headers
            ))
    }
    /// Classifies if text violates OpenAI's Content Policy
    ///
    /// - Remark: HTTP `POST /moderations`.
    /// - Remark: Generated from `#/paths//moderations/post(createModeration)`.
    public func createModeration(
        headers: Operations.createModeration.Input.Headers = .init(),
        body: Operations.createModeration.Input.Body
    ) async throws -> Operations.createModeration.Output {
        try await createModeration(
            Operations.createModeration.Input(
                headers: headers,
                body: body
            ))
    }
    /// Returns a list of assistants.
    ///
    /// - Remark: HTTP `GET /assistants`.
    /// - Remark: Generated from `#/paths//assistants/get(listAssistants)`.
    public func listAssistants(
        query: Operations.listAssistants.Input.Query = .init(),
        headers: Operations.listAssistants.Input.Headers = .init()
    ) async throws -> Operations.listAssistants.Output {
        try await listAssistants(
            Operations.listAssistants.Input(
                query: query,
                headers: headers
            ))
    }
    /// Create an assistant with a model and instructions.
    ///
    /// - Remark: HTTP `POST /assistants`.
    /// - Remark: Generated from `#/paths//assistants/post(createAssistant)`.
    public func createAssistant(
        headers: Operations.createAssistant.Input.Headers = .init(),
        body: Operations.createAssistant.Input.Body
    ) async throws -> Operations.createAssistant.Output {
        try await createAssistant(
            Operations.createAssistant.Input(
                headers: headers,
                body: body
            ))
    }
    /// Retrieves an assistant.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/get(getAssistant)`.
    public func getAssistant(
        path: Operations.getAssistant.Input.Path,
        headers: Operations.getAssistant.Input.Headers = .init()
    ) async throws -> Operations.getAssistant.Output {
        try await getAssistant(
            Operations.getAssistant.Input(
                path: path,
                headers: headers
            ))
    }
    /// Modifies an assistant.
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/post(modifyAssistant)`.
    public func modifyAssistant(
        path: Operations.modifyAssistant.Input.Path,
        headers: Operations.modifyAssistant.Input.Headers = .init(),
        body: Operations.modifyAssistant.Input.Body
    ) async throws -> Operations.modifyAssistant.Output {
        try await modifyAssistant(
            Operations.modifyAssistant.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Delete an assistant.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/delete(deleteAssistant)`.
    public func deleteAssistant(
        path: Operations.deleteAssistant.Input.Path,
        headers: Operations.deleteAssistant.Input.Headers = .init()
    ) async throws -> Operations.deleteAssistant.Output {
        try await deleteAssistant(
            Operations.deleteAssistant.Input(
                path: path,
                headers: headers
            ))
    }
    /// Create a thread.
    ///
    /// - Remark: HTTP `POST /threads`.
    /// - Remark: Generated from `#/paths//threads/post(createThread)`.
    public func createThread(
        headers: Operations.createThread.Input.Headers = .init(),
        body: Operations.createThread.Input.Body? = nil
    ) async throws -> Operations.createThread.Output {
        try await createThread(
            Operations.createThread.Input(
                headers: headers,
                body: body
            ))
    }
    /// Retrieves a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/get(getThread)`.
    public func getThread(
        path: Operations.getThread.Input.Path,
        headers: Operations.getThread.Input.Headers = .init()
    ) async throws -> Operations.getThread.Output {
        try await getThread(
            Operations.getThread.Input(
                path: path,
                headers: headers
            ))
    }
    /// Modifies a thread.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/post(modifyThread)`.
    public func modifyThread(
        path: Operations.modifyThread.Input.Path,
        headers: Operations.modifyThread.Input.Headers = .init(),
        body: Operations.modifyThread.Input.Body
    ) async throws -> Operations.modifyThread.Output {
        try await modifyThread(
            Operations.modifyThread.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Delete a thread.
    ///
    /// - Remark: HTTP `DELETE /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/delete(deleteThread)`.
    public func deleteThread(
        path: Operations.deleteThread.Input.Path,
        headers: Operations.deleteThread.Input.Headers = .init()
    ) async throws -> Operations.deleteThread.Output {
        try await deleteThread(
            Operations.deleteThread.Input(
                path: path,
                headers: headers
            ))
    }
    /// Returns a list of messages for a given thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/get(listMessages)`.
    public func listMessages(
        path: Operations.listMessages.Input.Path,
        query: Operations.listMessages.Input.Query = .init(),
        headers: Operations.listMessages.Input.Headers = .init()
    ) async throws -> Operations.listMessages.Output {
        try await listMessages(
            Operations.listMessages.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Create a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/post(createMessage)`.
    public func createMessage(
        path: Operations.createMessage.Input.Path,
        headers: Operations.createMessage.Input.Headers = .init(),
        body: Operations.createMessage.Input.Body
    ) async throws -> Operations.createMessage.Output {
        try await createMessage(
            Operations.createMessage.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Retrieve a message.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/get(getMessage)`.
    public func getMessage(
        path: Operations.getMessage.Input.Path,
        headers: Operations.getMessage.Input.Headers = .init()
    ) async throws -> Operations.getMessage.Output {
        try await getMessage(
            Operations.getMessage.Input(
                path: path,
                headers: headers
            ))
    }
    /// Modifies a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/post(modifyMessage)`.
    public func modifyMessage(
        path: Operations.modifyMessage.Input.Path,
        headers: Operations.modifyMessage.Input.Headers = .init(),
        body: Operations.modifyMessage.Input.Body
    ) async throws -> Operations.modifyMessage.Output {
        try await modifyMessage(
            Operations.modifyMessage.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Create a thread and run it in one request.
    ///
    /// - Remark: HTTP `POST /threads/runs`.
    /// - Remark: Generated from `#/paths//threads/runs/post(createThreadAndRun)`.
    public func createThreadAndRun(
        headers: Operations.createThreadAndRun.Input.Headers = .init(),
        body: Operations.createThreadAndRun.Input.Body
    ) async throws -> Operations.createThreadAndRun.Output {
        try await createThreadAndRun(
            Operations.createThreadAndRun.Input(
                headers: headers,
                body: body
            ))
    }
    /// Returns a list of runs belonging to a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/get(listRuns)`.
    public func listRuns(
        path: Operations.listRuns.Input.Path,
        query: Operations.listRuns.Input.Query = .init(),
        headers: Operations.listRuns.Input.Headers = .init()
    ) async throws -> Operations.listRuns.Output {
        try await listRuns(
            Operations.listRuns.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Create a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/post(createRun)`.
    public func createRun(
        path: Operations.createRun.Input.Path,
        headers: Operations.createRun.Input.Headers = .init(),
        body: Operations.createRun.Input.Body
    ) async throws -> Operations.createRun.Output {
        try await createRun(
            Operations.createRun.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Retrieves a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/get(getRun)`.
    public func getRun(
        path: Operations.getRun.Input.Path,
        headers: Operations.getRun.Input.Headers = .init()
    ) async throws -> Operations.getRun.Output {
        try await getRun(
            Operations.getRun.Input(
                path: path,
                headers: headers
            ))
    }
    /// Modifies a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/post(modifyRun)`.
    public func modifyRun(
        path: Operations.modifyRun.Input.Path,
        headers: Operations.modifyRun.Input.Headers = .init(),
        body: Operations.modifyRun.Input.Body
    ) async throws -> Operations.modifyRun.Output {
        try await modifyRun(
            Operations.modifyRun.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// When a run has the `status: "requires_action"` and `required_action.type` is `submit_tool_outputs`, this endpoint can be used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single request.
    ///
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/submit_tool_outputs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/submit_tool_outputs/post(submitToolOuputsToRun)`.
    public func submitToolOuputsToRun(
        path: Operations.submitToolOuputsToRun.Input.Path,
        headers: Operations.submitToolOuputsToRun.Input.Headers = .init(),
        body: Operations.submitToolOuputsToRun.Input.Body
    ) async throws -> Operations.submitToolOuputsToRun.Output {
        try await submitToolOuputsToRun(
            Operations.submitToolOuputsToRun.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Cancels a run that is `in_progress`.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/cancel/post(cancelRun)`.
    public func cancelRun(
        path: Operations.cancelRun.Input.Path,
        headers: Operations.cancelRun.Input.Headers = .init()
    ) async throws -> Operations.cancelRun.Output {
        try await cancelRun(
            Operations.cancelRun.Input(
                path: path,
                headers: headers
            ))
    }
    /// Returns a list of run steps belonging to a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/get(listRunSteps)`.
    public func listRunSteps(
        path: Operations.listRunSteps.Input.Path,
        query: Operations.listRunSteps.Input.Query = .init(),
        headers: Operations.listRunSteps.Input.Headers = .init()
    ) async throws -> Operations.listRunSteps.Output {
        try await listRunSteps(
            Operations.listRunSteps.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Retrieves a run step.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps/{step_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/{step_id}/get(getRunStep)`.
    public func getRunStep(
        path: Operations.getRunStep.Input.Path,
        headers: Operations.getRunStep.Input.Headers = .init()
    ) async throws -> Operations.getRunStep.Output {
        try await getRunStep(
            Operations.getRunStep.Input(
                path: path,
                headers: headers
            ))
    }
    /// Returns a list of assistant files.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/get(listAssistantFiles)`.
    public func listAssistantFiles(
        path: Operations.listAssistantFiles.Input.Path,
        query: Operations.listAssistantFiles.Input.Query = .init(),
        headers: Operations.listAssistantFiles.Input.Headers = .init()
    ) async throws -> Operations.listAssistantFiles.Output {
        try await listAssistantFiles(
            Operations.listAssistantFiles.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Create an assistant file by attaching a [File](/docs/api-reference/files) to an [assistant](/docs/api-reference/assistants).
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/post(createAssistantFile)`.
    public func createAssistantFile(
        path: Operations.createAssistantFile.Input.Path,
        headers: Operations.createAssistantFile.Input.Headers = .init(),
        body: Operations.createAssistantFile.Input.Body
    ) async throws -> Operations.createAssistantFile.Output {
        try await createAssistantFile(
            Operations.createAssistantFile.Input(
                path: path,
                headers: headers,
                body: body
            ))
    }
    /// Retrieves an AssistantFile.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/get(getAssistantFile)`.
    public func getAssistantFile(
        path: Operations.getAssistantFile.Input.Path,
        headers: Operations.getAssistantFile.Input.Headers = .init()
    ) async throws -> Operations.getAssistantFile.Output {
        try await getAssistantFile(
            Operations.getAssistantFile.Input(
                path: path,
                headers: headers
            ))
    }
    /// Delete an assistant file.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/delete(deleteAssistantFile)`.
    public func deleteAssistantFile(
        path: Operations.deleteAssistantFile.Input.Path,
        headers: Operations.deleteAssistantFile.Input.Headers = .init()
    ) async throws -> Operations.deleteAssistantFile.Output {
        try await deleteAssistantFile(
            Operations.deleteAssistantFile.Input(
                path: path,
                headers: headers
            ))
    }
    /// Returns a list of message files.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/get(listMessageFiles)`.
    public func listMessageFiles(
        path: Operations.listMessageFiles.Input.Path,
        query: Operations.listMessageFiles.Input.Query = .init(),
        headers: Operations.listMessageFiles.Input.Headers = .init()
    ) async throws -> Operations.listMessageFiles.Output {
        try await listMessageFiles(
            Operations.listMessageFiles.Input(
                path: path,
                query: query,
                headers: headers
            ))
    }
    /// Retrieves a message file.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/{file_id}/get(getMessageFile)`.
    public func getMessageFile(
        path: Operations.getMessageFile.Input.Path,
        headers: Operations.getMessageFile.Input.Headers = .init()
    ) async throws -> Operations.getMessageFile.Output {
        try await getMessageFile(
            Operations.getMessageFile.Input(
                path: path,
                headers: headers
            ))
    }
}

/// Server URLs defined in the OpenAPI document.
public enum Servers {
    public static func server1() throws -> Foundation.URL {
        try Foundation.URL(
            validatingOpenAPIServerURL: "https://api.openai.com/v1",
            variables: []
        )
    }
}

/// Types generated from the components section of the OpenAPI document.
public enum Components {
    /// Types generated from the `#/components/schemas` section of the OpenAPI document.
    public enum Schemas {
        /// - Remark: Generated from `#/components/schemas/Error`.
        public struct _Error: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/Error/code`.
            public var code: Swift.String?
            /// - Remark: Generated from `#/components/schemas/Error/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/Error/param`.
            public var param: Swift.String?
            /// - Remark: Generated from `#/components/schemas/Error/type`.
            public var _type: Swift.String
            /// Creates a new `_Error`.
            ///
            /// - Parameters:
            ///   - code:
            ///   - message:
            ///   - param:
            ///   - _type:
            public init(
                code: Swift.String? = nil,
                message: Swift.String,
                param: Swift.String? = nil,
                _type: Swift.String
            ) {
                self.code = code
                self.message = message
                self.param = param
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case code
                case message
                case param
                case _type = "type"
            }
        }
        /// - Remark: Generated from `#/components/schemas/ErrorResponse`.
        public struct ErrorResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ErrorResponse/error`.
            public var error: Components.Schemas._Error
            /// Creates a new `ErrorResponse`.
            ///
            /// - Parameters:
            ///   - error:
            public init(error: Components.Schemas._Error) {
                self.error = error
            }
            public enum CodingKeys: String, CodingKey {
                case error
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListModelsResponse`.
        public struct ListModelsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListModelsResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListModelsResponse/object`.
            public var object: Components.Schemas.ListModelsResponse.objectPayload
            /// - Remark: Generated from `#/components/schemas/ListModelsResponse/data`.
            public var data: [Components.Schemas.Model]
            /// Creates a new `ListModelsResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            public init(
                object: Components.Schemas.ListModelsResponse.objectPayload,
                data: [Components.Schemas.Model]
            ) {
                self.object = object
                self.data = data
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
            }
        }
        /// - Remark: Generated from `#/components/schemas/DeleteModelResponse`.
        public struct DeleteModelResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteModelResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteModelResponse/deleted`.
            public var deleted: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/DeleteModelResponse/object`.
            public var object: Swift.String
            /// Creates a new `DeleteModelResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - deleted:
            ///   - object:
            public init(
                id: Swift.String,
                deleted: Swift.Bool,
                object: Swift.String
            ) {
                self.id = id
                self.deleted = deleted
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case deleted
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest`.
        public struct CreateCompletionRequest: Codable, Hashable, Sendable {
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case babbage_hyphen_002 = "babbage-002"
                    case davinci_hyphen_002 = "davinci-002"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_instruct =
                        "gpt-3.5-turbo-instruct"
                    case text_hyphen_davinci_hyphen_003 = "text-davinci-003"
                    case text_hyphen_davinci_hyphen_002 = "text-davinci-002"
                    case text_hyphen_davinci_hyphen_001 = "text-davinci-001"
                    case code_hyphen_davinci_hyphen_002 = "code-davinci-002"
                    case text_hyphen_curie_hyphen_001 = "text-curie-001"
                    case text_hyphen_babbage_hyphen_001 = "text-babbage-001"
                    case text_hyphen_ada_hyphen_001 = "text-ada-001"
                }
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateCompletionRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateCompletionRequest.modelPayload.Value2Payload? =
                        nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/model`.
            public var model: Components.Schemas.CreateCompletionRequest.modelPayload
            /// The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.
            ///
            /// Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt`.
            @frozen public enum promptPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt/case2`.
                case case2([Swift.String])
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt/case3`.
                case case3([Swift.Int])
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt/case4`.
                case case4([[Swift.Int]])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case3(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case4(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case3(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case4(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.
            ///
            /// Note that <|endoftext|> is the document separator that the model sees during training, so if a prompt is not specified the model will generate as if from the beginning of a new document.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/prompt`.
            public var prompt: Components.Schemas.CreateCompletionRequest.promptPayload?
            /// Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.
            ///
            /// When used with `n`, `best_of` controls the number of candidate completions and `n` specifies how many to return – `best_of` must be greater than `n`.
            ///
            /// **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/best_of`.
            public var best_of: Swift.Int?
            /// Echo back the prompt in addition to the completion
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/echo`.
            public var echo: Swift.Bool?
            /// Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
            ///
            /// [See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/frequency_penalty`.
            public var frequency_penalty: Swift.Double?
            /// Modify the likelihood of specified tokens appearing in the completion.
            ///
            /// Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
            ///
            /// As an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/logit_bias`.
            public struct logit_biasPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.Int]
                /// Creates a new `logit_biasPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Swift.Int] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// Modify the likelihood of specified tokens appearing in the completion.
            ///
            /// Accepts a JSON object that maps tokens (specified by their token ID in the GPT tokenizer) to an associated bias value from -100 to 100. You can use this [tokenizer tool](/tokenizer?view=bpe) (which works for both GPT-2 and GPT-3) to convert text to token IDs. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
            ///
            /// As an example, you can pass `{"50256": -100}` to prevent the <|endoftext|> token from being generated.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/logit_bias`.
            public var logit_bias: Components.Schemas.CreateCompletionRequest.logit_biasPayload?
            /// Include the log probabilities on the `logprobs` most likely tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.
            ///
            /// The maximum value for `logprobs` is 5.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/logprobs`.
            public var logprobs: Swift.Int?
            /// The maximum number of [tokens](/tokenizer) to generate in the completion.
            ///
            /// The token count of your prompt plus `max_tokens` cannot exceed the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/max_tokens`.
            public var max_tokens: Swift.Int?
            /// How many completions to generate for each prompt.
            ///
            /// **Note:** Because this parameter generates many completions, it can quickly consume your token quota. Use carefully and ensure that you have reasonable settings for `max_tokens` and `stop`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/n`.
            public var n: Swift.Int?
            /// Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
            ///
            /// [See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/presence_penalty`.
            public var presence_penalty: Swift.Double?
            /// If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
            ///
            /// Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/seed`.
            public var seed: Swift.Int?
            /// Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/stop`.
            @frozen public enum stopPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/stop/case1`.
                case case1(Swift.String?)
                /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/stop/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/stop`.
            public var stop: Components.Schemas.CreateCompletionRequest.stopPayload?
            /// Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/stream`.
            public var stream: Swift.Bool?
            /// The suffix that comes after a completion of inserted text.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/suffix`.
            public var suffix: Swift.String?
            /// What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///
            /// We generally recommend altering this or `top_p` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/temperature`.
            public var temperature: Swift.Double?
            /// An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            ///
            /// We generally recommend altering this or `temperature` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/top_p`.
            public var top_p: Swift.Double?
            /// A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionRequest/user`.
            public var user: Swift.String?
            /// Creates a new `CreateCompletionRequest`.
            ///
            /// - Parameters:
            ///   - model: ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///   - prompt: The prompt(s) to generate completions for, encoded as a string, array of strings, array of tokens, or array of token arrays.
            ///   - best_of: Generates `best_of` completions server-side and returns the "best" (the one with the highest log probability per token). Results cannot be streamed.
            ///   - echo: Echo back the prompt in addition to the completion
            ///   - frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
            ///   - logit_bias: Modify the likelihood of specified tokens appearing in the completion.
            ///   - logprobs: Include the log probabilities on the `logprobs` most likely tokens, as well the chosen tokens. For example, if `logprobs` is 5, the API will return a list of the 5 most likely tokens. The API will always return the `logprob` of the sampled token, so there may be up to `logprobs+1` elements in the response.
            ///   - max_tokens: The maximum number of [tokens](/tokenizer) to generate in the completion.
            ///   - n: How many completions to generate for each prompt.
            ///   - presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
            ///   - seed: If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
            ///   - stop: Up to 4 sequences where the API will stop generating further tokens. The returned text will not contain the stop sequence.
            ///   - stream: Whether to stream back partial progress. If set, tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
            ///   - suffix: The suffix that comes after a completion of inserted text.
            ///   - temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///   - top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            ///   - user: A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            public init(
                model: Components.Schemas.CreateCompletionRequest.modelPayload,
                prompt: Components.Schemas.CreateCompletionRequest.promptPayload? = nil,
                best_of: Swift.Int? = nil,
                echo: Swift.Bool? = nil,
                frequency_penalty: Swift.Double? = nil,
                logit_bias: Components.Schemas.CreateCompletionRequest.logit_biasPayload? = nil,
                logprobs: Swift.Int? = nil,
                max_tokens: Swift.Int? = nil,
                n: Swift.Int? = nil,
                presence_penalty: Swift.Double? = nil,
                seed: Swift.Int? = nil,
                stop: Components.Schemas.CreateCompletionRequest.stopPayload? = nil,
                stream: Swift.Bool? = nil,
                suffix: Swift.String? = nil,
                temperature: Swift.Double? = nil,
                top_p: Swift.Double? = nil,
                user: Swift.String? = nil
            ) {
                self.model = model
                self.prompt = prompt
                self.best_of = best_of
                self.echo = echo
                self.frequency_penalty = frequency_penalty
                self.logit_bias = logit_bias
                self.logprobs = logprobs
                self.max_tokens = max_tokens
                self.n = n
                self.presence_penalty = presence_penalty
                self.seed = seed
                self.stop = stop
                self.stream = stream
                self.suffix = suffix
                self.temperature = temperature
                self.top_p = top_p
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case model
                case prompt
                case best_of
                case echo
                case frequency_penalty
                case logit_bias
                case logprobs
                case max_tokens
                case n
                case presence_penalty
                case seed
                case stop
                case stream
                case suffix
                case temperature
                case top_p
                case user
            }
        }
        /// Represents a completion response from the API. Note: both the streamed and non-streamed response objects share the same shape (unlike the chat endpoint).
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse`.
        public struct CreateCompletionResponse: Codable, Hashable, Sendable {
            /// A unique identifier for the completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload`.
            public struct choicesPayloadPayload: Codable, Hashable, Sendable {
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// or `content_filter` if content was omitted due to a flag from our content filters.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/finish_reason`.
                @frozen public enum finish_reasonPayload: String, Codable, Hashable, Sendable {
                    case stop = "stop"
                    case length = "length"
                    case content_filter = "content_filter"
                }
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// or `content_filter` if content was omitted due to a flag from our content filters.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/finish_reason`.
                public var finish_reason:
                    Components.Schemas.CreateCompletionResponse.choicesPayloadPayload
                        .finish_reasonPayload?
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/index`.
                public var index: Swift.Int
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs`.
                public struct logprobsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/text_offset`.
                    public var text_offset: [Swift.Int]?
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/token_logprobs`.
                    public var token_logprobs: [Swift.Double]?
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/tokens`.
                    public var tokens: [Swift.String]?
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/top_logprobsPayload`.
                    public struct top_logprobsPayloadPayload: Codable, Hashable, Sendable {
                        /// A container of undocumented properties.
                        public var additionalProperties: [String: Swift.Double]
                        /// Creates a new `top_logprobsPayloadPayload`.
                        ///
                        /// - Parameters:
                        ///   - additionalProperties: A container of undocumented properties.
                        public init(additionalProperties: [String: Swift.Double] = .init()) {
                            self.additionalProperties = additionalProperties
                        }
                        public init(from decoder: any Decoder) throws {
                            additionalProperties = try decoder.decodeAdditionalProperties(
                                knownKeys: [])
                        }
                        public func encode(to encoder: any Encoder) throws {
                            try encoder.encodeAdditionalProperties(additionalProperties)
                        }
                    }
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/top_logprobs`.
                    public typealias top_logprobsPayload = [Components.Schemas
                        .CreateCompletionResponse.choicesPayloadPayload.logprobsPayload
                        .top_logprobsPayloadPayload]
                    /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs/top_logprobs`.
                    public var top_logprobs:
                        Components.Schemas.CreateCompletionResponse.choicesPayloadPayload
                            .logprobsPayload.top_logprobsPayload?
                    /// Creates a new `logprobsPayload`.
                    ///
                    /// - Parameters:
                    ///   - text_offset:
                    ///   - token_logprobs:
                    ///   - tokens:
                    ///   - top_logprobs:
                    public init(
                        text_offset: [Swift.Int]? = nil,
                        token_logprobs: [Swift.Double]? = nil,
                        tokens: [Swift.String]? = nil,
                        top_logprobs: Components.Schemas.CreateCompletionResponse
                            .choicesPayloadPayload.logprobsPayload.top_logprobsPayload? = nil
                    ) {
                        self.text_offset = text_offset
                        self.token_logprobs = token_logprobs
                        self.tokens = tokens
                        self.top_logprobs = top_logprobs
                    }
                    public enum CodingKeys: String, CodingKey {
                        case text_offset
                        case token_logprobs
                        case tokens
                        case top_logprobs
                    }
                }
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/logprobs`.
                public var logprobs:
                    Components.Schemas.CreateCompletionResponse.choicesPayloadPayload
                        .logprobsPayload?
                /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choicesPayload/text`.
                public var text: Swift.String
                /// Creates a new `choicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - finish_reason: The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                ///   - index:
                ///   - logprobs:
                ///   - text:
                public init(
                    finish_reason: Components.Schemas.CreateCompletionResponse.choicesPayloadPayload
                        .finish_reasonPayload? = nil,
                    index: Swift.Int,
                    logprobs: Components.Schemas.CreateCompletionResponse.choicesPayloadPayload
                        .logprobsPayload? = nil,
                    text: Swift.String
                ) {
                    self.finish_reason = finish_reason
                    self.index = index
                    self.logprobs = logprobs
                    self.text = text
                }
                public enum CodingKeys: String, CodingKey {
                    case finish_reason
                    case index
                    case logprobs
                    case text
                }
            }
            /// The list of completion choices the model generated for the input prompt.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choices`.
            public typealias choicesPayload = [Components.Schemas.CreateCompletionResponse
                .choicesPayloadPayload]
            /// The list of completion choices the model generated for the input prompt.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/choices`.
            public var choices: Components.Schemas.CreateCompletionResponse.choicesPayload
            /// The Unix timestamp (in seconds) of when the completion was created.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/created`.
            public var created: Swift.Int
            /// The model used for completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/model`.
            public var model: Swift.String
            /// This fingerprint represents the backend configuration that the model runs with.
            ///
            /// Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/system_fingerprint`.
            public var system_fingerprint: Swift.String?
            /// The object type, which is always "text_completion"
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case text_completion = "text_completion"
            }
            /// The object type, which is always "text_completion"
            ///
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/object`.
            public var object: Components.Schemas.CreateCompletionResponse.objectPayload
            /// - Remark: Generated from `#/components/schemas/CreateCompletionResponse/usage`.
            public var usage: Components.Schemas.CompletionUsage?
            /// Creates a new `CreateCompletionResponse`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the completion.
            ///   - choices: The list of completion choices the model generated for the input prompt.
            ///   - created: The Unix timestamp (in seconds) of when the completion was created.
            ///   - model: The model used for completion.
            ///   - system_fingerprint: This fingerprint represents the backend configuration that the model runs with.
            ///   - object: The object type, which is always "text_completion"
            ///   - usage:
            public init(
                id: Swift.String,
                choices: Components.Schemas.CreateCompletionResponse.choicesPayload,
                created: Swift.Int,
                model: Swift.String,
                system_fingerprint: Swift.String? = nil,
                object: Components.Schemas.CreateCompletionResponse.objectPayload,
                usage: Components.Schemas.CompletionUsage? = nil
            ) {
                self.id = id
                self.choices = choices
                self.created = created
                self.model = model
                self.system_fingerprint = system_fingerprint
                self.object = object
                self.usage = usage
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case choices
                case created
                case model
                case system_fingerprint
                case object
                case usage
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPart`.
        @frozen public enum ChatCompletionRequestMessageContentPart: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPart/case1`.
            case ChatCompletionRequestMessageContentPartText(
                Components.Schemas.ChatCompletionRequestMessageContentPartText)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPart/case2`.
            case ChatCompletionRequestMessageContentPartImage(
                Components.Schemas.ChatCompletionRequestMessageContentPartImage)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .ChatCompletionRequestMessageContentPartText(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionRequestMessageContentPartImage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .ChatCompletionRequestMessageContentPartText(value):
                    try value.encode(to: encoder)
                case let .ChatCompletionRequestMessageContentPartImage(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage`.
        public struct ChatCompletionRequestMessageContentPartImage: Codable, Hashable, Sendable {
            /// The type of the content part.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case image_url = "image_url"
            }
            /// The type of the content part.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/type`.
            public var _type:
                Components.Schemas.ChatCompletionRequestMessageContentPartImage._typePayload
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/image_url`.
            public struct image_urlPayload: Codable, Hashable, Sendable {
                /// Either a URL of the image or the base64 encoded image data.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/image_url/url`.
                public var url: Swift.String
                /// Specifies the detail level of the image.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/image_url/detail`.
                @frozen public enum detailPayload: String, Codable, Hashable, Sendable {
                    case auto = "auto"
                    case low = "low"
                    case high = "high"
                }
                /// Specifies the detail level of the image.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/image_url/detail`.
                public var detail:
                    Components.Schemas.ChatCompletionRequestMessageContentPartImage.image_urlPayload
                        .detailPayload?
                /// Creates a new `image_urlPayload`.
                ///
                /// - Parameters:
                ///   - url: Either a URL of the image or the base64 encoded image data.
                ///   - detail: Specifies the detail level of the image.
                public init(
                    url: Swift.String,
                    detail: Components.Schemas.ChatCompletionRequestMessageContentPartImage
                        .image_urlPayload.detailPayload? = nil
                ) {
                    self.url = url
                    self.detail = detail
                }
                public enum CodingKeys: String, CodingKey {
                    case url
                    case detail
                }
            }
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartImage/image_url`.
            public var image_url:
                Components.Schemas.ChatCompletionRequestMessageContentPartImage.image_urlPayload
            /// Creates a new `ChatCompletionRequestMessageContentPartImage`.
            ///
            /// - Parameters:
            ///   - _type: The type of the content part.
            ///   - image_url:
            public init(
                _type: Components.Schemas.ChatCompletionRequestMessageContentPartImage._typePayload,
                image_url: Components.Schemas.ChatCompletionRequestMessageContentPartImage
                    .image_urlPayload
            ) {
                self._type = _type
                self.image_url = image_url
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case image_url
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartText`.
        public struct ChatCompletionRequestMessageContentPartText: Codable, Hashable, Sendable {
            /// The type of the content part.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartText/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case text = "text"
            }
            /// The type of the content part.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartText/type`.
            public var _type:
                Components.Schemas.ChatCompletionRequestMessageContentPartText._typePayload
            /// The text content.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessageContentPartText/text`.
            public var text: Swift.String
            /// Creates a new `ChatCompletionRequestMessageContentPartText`.
            ///
            /// - Parameters:
            ///   - _type: The type of the content part.
            ///   - text: The text content.
            public init(
                _type: Components.Schemas.ChatCompletionRequestMessageContentPartText._typePayload,
                text: Swift.String
            ) {
                self._type = _type
                self.text = text
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case text
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage`.
        @frozen public enum ChatCompletionRequestMessage: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage/case1`.
            case ChatCompletionRequestSystemMessage(
                Components.Schemas.ChatCompletionRequestSystemMessage)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage/case2`.
            case ChatCompletionRequestUserMessage(
                Components.Schemas.ChatCompletionRequestUserMessage)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage/case3`.
            case ChatCompletionRequestAssistantMessage(
                Components.Schemas.ChatCompletionRequestAssistantMessage)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage/case4`.
            case ChatCompletionRequestToolMessage(
                Components.Schemas.ChatCompletionRequestToolMessage)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestMessage/case5`.
            case ChatCompletionRequestFunctionMessage(
                Components.Schemas.ChatCompletionRequestFunctionMessage)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .ChatCompletionRequestSystemMessage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionRequestUserMessage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionRequestAssistantMessage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionRequestToolMessage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionRequestFunctionMessage(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .ChatCompletionRequestSystemMessage(value):
                    try value.encode(to: encoder)
                case let .ChatCompletionRequestUserMessage(value):
                    try value.encode(to: encoder)
                case let .ChatCompletionRequestAssistantMessage(value):
                    try value.encode(to: encoder)
                case let .ChatCompletionRequestToolMessage(value):
                    try value.encode(to: encoder)
                case let .ChatCompletionRequestFunctionMessage(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestSystemMessage`.
        public struct ChatCompletionRequestSystemMessage: Codable, Hashable, Sendable {
            /// The contents of the system message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestSystemMessage/content`.
            public var content: Swift.String?
            /// The role of the messages author, in this case `system`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestSystemMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case system = "system"
            }
            /// The role of the messages author, in this case `system`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestSystemMessage/role`.
            public var role: Components.Schemas.ChatCompletionRequestSystemMessage.rolePayload
            /// Creates a new `ChatCompletionRequestSystemMessage`.
            ///
            /// - Parameters:
            ///   - content: The contents of the system message.
            ///   - role: The role of the messages author, in this case `system`.
            public init(
                content: Swift.String? = nil,
                role: Components.Schemas.ChatCompletionRequestSystemMessage.rolePayload
            ) {
                self.content = content
                self.role = role
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case role
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage`.
        public struct ChatCompletionRequestUserMessage: Codable, Hashable, Sendable {
            /// The contents of the user message.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/content`.
            @frozen public enum contentPayload: Codable, Hashable, Sendable {
                /// The text contents of the message.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/content/case1`.
                case case1(Swift.String)
                /// An array of content parts with a defined type, each can be of type `text` or `image_url` when passing in images. You can pass multiple images by adding multiple `image_url` content parts. Image input is only supported when using the `gpt-4-visual-preview` model.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/content/case2`.
                case case2([Components.Schemas.ChatCompletionRequestMessageContentPart])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// The contents of the user message.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/content`.
            public var content: Components.Schemas.ChatCompletionRequestUserMessage.contentPayload?
            /// The role of the messages author, in this case `user`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case user = "user"
            }
            /// The role of the messages author, in this case `user`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestUserMessage/role`.
            public var role: Components.Schemas.ChatCompletionRequestUserMessage.rolePayload
            /// Creates a new `ChatCompletionRequestUserMessage`.
            ///
            /// - Parameters:
            ///   - content: The contents of the user message.
            ///   - role: The role of the messages author, in this case `user`.
            public init(
                content: Components.Schemas.ChatCompletionRequestUserMessage.contentPayload? = nil,
                role: Components.Schemas.ChatCompletionRequestUserMessage.rolePayload
            ) {
                self.content = content
                self.role = role
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case role
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage`.
        public struct ChatCompletionRequestAssistantMessage: Codable, Hashable, Sendable {
            /// The contents of the assistant message.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/content`.
            public var content: Swift.String?
            /// The role of the messages author, in this case `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case assistant = "assistant"
            }
            /// The role of the messages author, in this case `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/role`.
            public var role: Components.Schemas.ChatCompletionRequestAssistantMessage.rolePayload
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/tool_calls`.
            public var tool_calls: Components.Schemas.ChatCompletionMessageToolCalls?
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/function_call`.
            @available(*, deprecated)
            public struct function_callPayload: Codable, Hashable, Sendable {
                /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/function_call/arguments`.
                public var arguments: Swift.String
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/function_call/name`.
                public var name: Swift.String
                /// Creates a new `function_callPayload`.
                ///
                /// - Parameters:
                ///   - arguments: The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///   - name: The name of the function to call.
                public init(
                    arguments: Swift.String,
                    name: Swift.String
                ) {
                    self.arguments = arguments
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case arguments
                    case name
                }
            }
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestAssistantMessage/function_call`.
            @available(*, deprecated)
            public var function_call:
                Components.Schemas.ChatCompletionRequestAssistantMessage.function_callPayload?
            /// Creates a new `ChatCompletionRequestAssistantMessage`.
            ///
            /// - Parameters:
            ///   - content: The contents of the assistant message.
            ///   - role: The role of the messages author, in this case `assistant`.
            ///   - tool_calls:
            ///   - function_call: Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            public init(
                content: Swift.String? = nil,
                role: Components.Schemas.ChatCompletionRequestAssistantMessage.rolePayload,
                tool_calls: Components.Schemas.ChatCompletionMessageToolCalls? = nil,
                function_call: Components.Schemas.ChatCompletionRequestAssistantMessage
                    .function_callPayload? = nil
            ) {
                self.content = content
                self.role = role
                self.tool_calls = tool_calls
                self.function_call = function_call
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case role
                case tool_calls
                case function_call
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestToolMessage`.
        public struct ChatCompletionRequestToolMessage: Codable, Hashable, Sendable {
            /// The role of the messages author, in this case `tool`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestToolMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case tool = "tool"
            }
            /// The role of the messages author, in this case `tool`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestToolMessage/role`.
            public var role: Components.Schemas.ChatCompletionRequestToolMessage.rolePayload
            /// The contents of the tool message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestToolMessage/content`.
            public var content: Swift.String?
            /// Tool call that this message is responding to.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestToolMessage/tool_call_id`.
            public var tool_call_id: Swift.String
            /// Creates a new `ChatCompletionRequestToolMessage`.
            ///
            /// - Parameters:
            ///   - role: The role of the messages author, in this case `tool`.
            ///   - content: The contents of the tool message.
            ///   - tool_call_id: Tool call that this message is responding to.
            public init(
                role: Components.Schemas.ChatCompletionRequestToolMessage.rolePayload,
                content: Swift.String? = nil,
                tool_call_id: Swift.String
            ) {
                self.role = role
                self.content = content
                self.tool_call_id = tool_call_id
            }
            public enum CodingKeys: String, CodingKey {
                case role
                case content
                case tool_call_id
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestFunctionMessage`.
        @available(*, deprecated)
        public struct ChatCompletionRequestFunctionMessage: Codable, Hashable, Sendable {
            /// The role of the messages author, in this case `function`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestFunctionMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The role of the messages author, in this case `function`.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestFunctionMessage/role`.
            public var role: Components.Schemas.ChatCompletionRequestFunctionMessage.rolePayload
            /// The return value from the function call, to return to the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestFunctionMessage/content`.
            public var content: Swift.String?
            /// The name of the function to call.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionRequestFunctionMessage/name`.
            public var name: Swift.String
            /// Creates a new `ChatCompletionRequestFunctionMessage`.
            ///
            /// - Parameters:
            ///   - role: The role of the messages author, in this case `function`.
            ///   - content: The return value from the function call, to return to the model.
            ///   - name: The name of the function to call.
            public init(
                role: Components.Schemas.ChatCompletionRequestFunctionMessage.rolePayload,
                content: Swift.String? = nil,
                name: Swift.String
            ) {
                self.role = role
                self.content = content
                self.name = name
            }
            public enum CodingKeys: String, CodingKey {
                case role
                case content
                case name
            }
        }
        /// The parameters the functions accepts, described as a JSON Schema object. See the [guide](/docs/guides/gpt/function-calling) for examples, and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.
        ///
        /// To describe a function that accepts no parameters, provide the value `{"type": "object", "properties": {}}`.
        ///
        /// - Remark: Generated from `#/components/schemas/FunctionParameters`.
        public struct FunctionParameters: Codable, Hashable, Sendable {
            /// A container of undocumented properties.
            public var additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `FunctionParameters`.
            ///
            /// - Parameters:
            ///   - additionalProperties: A container of undocumented properties.
            public init(additionalProperties: OpenAPIRuntime.OpenAPIObjectContainer = .init()) {
                self.additionalProperties = additionalProperties
            }
            public init(from decoder: any Decoder) throws {
                additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
            }
            public func encode(to encoder: any Encoder) throws {
                try encoder.encodeAdditionalProperties(additionalProperties)
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctions`.
        @available(*, deprecated)
        public struct ChatCompletionFunctions: Codable, Hashable, Sendable {
            /// A description of what the function does, used by the model to choose when and how to call the function.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctions/description`.
            public var description: Swift.String?
            /// The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctions/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctions/parameters`.
            public var parameters: Components.Schemas.FunctionParameters
            /// Creates a new `ChatCompletionFunctions`.
            ///
            /// - Parameters:
            ///   - description: A description of what the function does, used by the model to choose when and how to call the function.
            ///   - name: The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
            ///   - parameters:
            public init(
                description: Swift.String? = nil,
                name: Swift.String,
                parameters: Components.Schemas.FunctionParameters
            ) {
                self.description = description
                self.name = name
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case name
                case parameters
            }
        }
        /// Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctionCallOption`.
        public struct ChatCompletionFunctionCallOption: Codable, Hashable, Sendable {
            /// The name of the function to call.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionFunctionCallOption/name`.
            public var name: Swift.String
            /// Creates a new `ChatCompletionFunctionCallOption`.
            ///
            /// - Parameters:
            ///   - name: The name of the function to call.
            public init(name: Swift.String) {
                self.name = name
            }
            public enum CodingKeys: String, CodingKey {
                case name
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionTool`.
        public struct ChatCompletionTool: Codable, Hashable, Sendable {
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionTool/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionTool/type`.
            public var _type: Components.Schemas.ChatCompletionTool._typePayload
            /// - Remark: Generated from `#/components/schemas/ChatCompletionTool/function`.
            public var function: Components.Schemas.FunctionObject
            /// Creates a new `ChatCompletionTool`.
            ///
            /// - Parameters:
            ///   - _type: The type of the tool. Currently, only `function` is supported.
            ///   - function:
            public init(
                _type: Components.Schemas.ChatCompletionTool._typePayload,
                function: Components.Schemas.FunctionObject
            ) {
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case function
            }
        }
        /// - Remark: Generated from `#/components/schemas/FunctionObject`.
        public struct FunctionObject: Codable, Hashable, Sendable {
            /// A description of what the function does, used by the model to choose when and how to call the function.
            ///
            /// - Remark: Generated from `#/components/schemas/FunctionObject/description`.
            public var description: Swift.String?
            /// The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
            ///
            /// - Remark: Generated from `#/components/schemas/FunctionObject/name`.
            public var name: Swift.String
            /// - Remark: Generated from `#/components/schemas/FunctionObject/parameters`.
            public var parameters: Components.Schemas.FunctionParameters
            /// Creates a new `FunctionObject`.
            ///
            /// - Parameters:
            ///   - description: A description of what the function does, used by the model to choose when and how to call the function.
            ///   - name: The name of the function to be called. Must be a-z, A-Z, 0-9, or contain underscores and dashes, with a maximum length of 64.
            ///   - parameters:
            public init(
                description: Swift.String? = nil,
                name: Swift.String,
                parameters: Components.Schemas.FunctionParameters
            ) {
                self.description = description
                self.name = name
                self.parameters = parameters
            }
            public enum CodingKeys: String, CodingKey {
                case description
                case name
                case parameters
            }
        }
        /// Controls which (if any) function is called by the model.
        /// `none` means the model will not call a function and instead generates a message.
        /// `auto` means the model can pick between generating a message or calling a function.
        /// Specifying a particular function via `{"type: "function", "function": {"name": "my_function"}}` forces the model to call that function.
        ///
        /// `none` is the default when no functions are present. `auto` is the default if functions are present.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionToolChoiceOption`.
        @frozen public enum ChatCompletionToolChoiceOption: Codable, Hashable, Sendable {
            /// `none` means the model will not call a function and instead generates a message. `auto` means the model can pick between generating a message or calling a function.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionToolChoiceOption/case1`.
            @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                case none = "none"
                case auto = "auto"
            }
            /// `none` means the model will not call a function and instead generates a message. `auto` means the model can pick between generating a message or calling a function.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionToolChoiceOption/case1`.
            case case1(Components.Schemas.ChatCompletionToolChoiceOption.Case1Payload)
            /// - Remark: Generated from `#/components/schemas/ChatCompletionToolChoiceOption/case2`.
            case ChatCompletionNamedToolChoice(Components.Schemas.ChatCompletionNamedToolChoice)
            public init(from decoder: any Decoder) throws {
                var errors: [any Error] = []
                do {
                    self = .case1(try decoder.decodeFromSingleValueContainer())
                    return
                } catch {
                    errors.append(error)
                }
                do {
                    self = .ChatCompletionNamedToolChoice(try .init(from: decoder))
                    return
                } catch {
                    errors.append(error)
                }
                throw Swift.DecodingError.failedToDecodeOneOfSchema(
                    type: Self.self,
                    codingPath: decoder.codingPath,
                    errors: errors
                )
            }
            public func encode(to encoder: any Encoder) throws {
                switch self {
                case let .case1(value):
                    try encoder.encodeToSingleValueContainer(value)
                case let .ChatCompletionNamedToolChoice(value):
                    try value.encode(to: encoder)
                }
            }
        }
        /// Specifies a tool the model should use. Use to force the model to call a specific function.
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice`.
        public struct ChatCompletionNamedToolChoice: Codable, Hashable, Sendable {
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice/type`.
            public var _type: Components.Schemas.ChatCompletionNamedToolChoice._typePayload?
            /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice/function`.
            public struct functionPayload: Codable, Hashable, Sendable {
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice/function/name`.
                public var name: Swift.String
                /// Creates a new `functionPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the function to call.
                public init(name: Swift.String) {
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                }
            }
            /// - Remark: Generated from `#/components/schemas/ChatCompletionNamedToolChoice/function`.
            public var function: Components.Schemas.ChatCompletionNamedToolChoice.functionPayload?
            /// Creates a new `ChatCompletionNamedToolChoice`.
            ///
            /// - Parameters:
            ///   - _type: The type of the tool. Currently, only `function` is supported.
            ///   - function:
            public init(
                _type: Components.Schemas.ChatCompletionNamedToolChoice._typePayload? = nil,
                function: Components.Schemas.ChatCompletionNamedToolChoice.functionPayload? = nil
            ) {
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case function
            }
        }
        /// The tool calls generated by the model, such as function calls.
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCalls`.
        public typealias ChatCompletionMessageToolCalls = [Components.Schemas
            .ChatCompletionMessageToolCall]
        /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall`.
        public struct ChatCompletionMessageToolCall: Codable, Hashable, Sendable {
            /// The ID of the tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/id`.
            public var id: Swift.String
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/type`.
            public var _type: Components.Schemas.ChatCompletionMessageToolCall._typePayload
            /// The function that the model called.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/function`.
            public struct functionPayload: Codable, Hashable, Sendable {
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/function/name`.
                public var name: Swift.String
                /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/function/arguments`.
                public var arguments: Swift.String
                /// Creates a new `functionPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the function to call.
                ///   - arguments: The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                public init(
                    name: Swift.String,
                    arguments: Swift.String
                ) {
                    self.name = name
                    self.arguments = arguments
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case arguments
                }
            }
            /// The function that the model called.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCall/function`.
            public var function: Components.Schemas.ChatCompletionMessageToolCall.functionPayload
            /// Creates a new `ChatCompletionMessageToolCall`.
            ///
            /// - Parameters:
            ///   - id: The ID of the tool call.
            ///   - _type: The type of the tool. Currently, only `function` is supported.
            ///   - function: The function that the model called.
            public init(
                id: Swift.String,
                _type: Components.Schemas.ChatCompletionMessageToolCall._typePayload,
                function: Components.Schemas.ChatCompletionMessageToolCall.functionPayload
            ) {
                self.id = id
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case function
            }
        }
        /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk`.
        public struct ChatCompletionMessageToolCallChunk: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/index`.
            public var index: Swift.Int
            /// The ID of the tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/id`.
            public var id: Swift.String?
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of the tool. Currently, only `function` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/type`.
            public var _type: Components.Schemas.ChatCompletionMessageToolCallChunk._typePayload?
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/function`.
            public struct functionPayload: Codable, Hashable, Sendable {
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/function/name`.
                public var name: Swift.String?
                /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/function/arguments`.
                public var arguments: Swift.String?
                /// Creates a new `functionPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the function to call.
                ///   - arguments: The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                public init(
                    name: Swift.String? = nil,
                    arguments: Swift.String? = nil
                ) {
                    self.name = name
                    self.arguments = arguments
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case arguments
                }
            }
            /// - Remark: Generated from `#/components/schemas/ChatCompletionMessageToolCallChunk/function`.
            public var function:
                Components.Schemas.ChatCompletionMessageToolCallChunk.functionPayload?
            /// Creates a new `ChatCompletionMessageToolCallChunk`.
            ///
            /// - Parameters:
            ///   - index:
            ///   - id: The ID of the tool call.
            ///   - _type: The type of the tool. Currently, only `function` is supported.
            ///   - function:
            public init(
                index: Swift.Int,
                id: Swift.String? = nil,
                _type: Components.Schemas.ChatCompletionMessageToolCallChunk._typePayload? = nil,
                function: Components.Schemas.ChatCompletionMessageToolCallChunk.functionPayload? =
                    nil
            ) {
                self.index = index
                self.id = id
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case index
                case id
                case _type = "type"
                case function
            }
        }
        /// The role of the author of a message
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionRole`.
        @frozen public enum ChatCompletionRole: String, Codable, Hashable, Sendable {
            case system = "system"
            case user = "user"
            case assistant = "assistant"
            case tool = "tool"
            case function = "function"
        }
        /// A chat completion message generated by the model.
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage`.
        public struct ChatCompletionResponseMessage: Codable, Hashable, Sendable {
            /// The contents of the message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/content`.
            public var content: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/tool_calls`.
            public var tool_calls: Components.Schemas.ChatCompletionMessageToolCalls?
            /// The role of the author of this message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case assistant = "assistant"
            }
            /// The role of the author of this message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/role`.
            public var role: Components.Schemas.ChatCompletionResponseMessage.rolePayload
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/function_call`.
            @available(*, deprecated)
            public struct function_callPayload: Codable, Hashable, Sendable {
                /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/function_call/arguments`.
                public var arguments: Swift.String
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/function_call/name`.
                public var name: Swift.String
                /// Creates a new `function_callPayload`.
                ///
                /// - Parameters:
                ///   - arguments: The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///   - name: The name of the function to call.
                public init(
                    arguments: Swift.String,
                    name: Swift.String
                ) {
                    self.arguments = arguments
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case arguments
                    case name
                }
            }
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionResponseMessage/function_call`.
            @available(*, deprecated)
            public var function_call:
                Components.Schemas.ChatCompletionResponseMessage.function_callPayload?
            /// Creates a new `ChatCompletionResponseMessage`.
            ///
            /// - Parameters:
            ///   - content: The contents of the message.
            ///   - tool_calls:
            ///   - role: The role of the author of this message.
            ///   - function_call: Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            public init(
                content: Swift.String? = nil,
                tool_calls: Components.Schemas.ChatCompletionMessageToolCalls? = nil,
                role: Components.Schemas.ChatCompletionResponseMessage.rolePayload,
                function_call: Components.Schemas.ChatCompletionResponseMessage
                    .function_callPayload? = nil
            ) {
                self.content = content
                self.tool_calls = tool_calls
                self.role = role
                self.function_call = function_call
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case tool_calls
                case role
                case function_call
            }
        }
        /// A chat completion delta generated by streamed model responses.
        ///
        /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta`.
        public struct ChatCompletionStreamResponseDelta: Codable, Hashable, Sendable {
            /// The contents of the chunk message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/content`.
            public var content: Swift.String?
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/function_call`.
            @available(*, deprecated)
            public struct function_callPayload: Codable, Hashable, Sendable {
                /// The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/function_call/arguments`.
                public var arguments: Swift.String?
                /// The name of the function to call.
                ///
                /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/function_call/name`.
                public var name: Swift.String?
                /// Creates a new `function_callPayload`.
                ///
                /// - Parameters:
                ///   - arguments: The arguments to call the function with, as generated by the model in JSON format. Note that the model does not always generate valid JSON, and may hallucinate parameters not defined by your function schema. Validate the arguments in your code before calling your function.
                ///   - name: The name of the function to call.
                public init(
                    arguments: Swift.String? = nil,
                    name: Swift.String? = nil
                ) {
                    self.arguments = arguments
                    self.name = name
                }
                public enum CodingKeys: String, CodingKey {
                    case arguments
                    case name
                }
            }
            /// Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/function_call`.
            @available(*, deprecated)
            public var function_call:
                Components.Schemas.ChatCompletionStreamResponseDelta.function_callPayload?
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/tool_calls`.
            public var tool_calls: [Components.Schemas.ChatCompletionMessageToolCallChunk]?
            /// The role of the author of this message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case system = "system"
                case user = "user"
                case assistant = "assistant"
                case tool = "tool"
            }
            /// The role of the author of this message.
            ///
            /// - Remark: Generated from `#/components/schemas/ChatCompletionStreamResponseDelta/role`.
            public var role: Components.Schemas.ChatCompletionStreamResponseDelta.rolePayload?
            /// Creates a new `ChatCompletionStreamResponseDelta`.
            ///
            /// - Parameters:
            ///   - content: The contents of the chunk message.
            ///   - function_call: Deprecated and replaced by `tool_calls`. The name and arguments of a function that should be called, as generated by the model.
            ///   - tool_calls:
            ///   - role: The role of the author of this message.
            public init(
                content: Swift.String? = nil,
                function_call: Components.Schemas.ChatCompletionStreamResponseDelta
                    .function_callPayload? = nil,
                tool_calls: [Components.Schemas.ChatCompletionMessageToolCallChunk]? = nil,
                role: Components.Schemas.ChatCompletionStreamResponseDelta.rolePayload? = nil
            ) {
                self.content = content
                self.function_call = function_call
                self.tool_calls = tool_calls
                self.role = role
            }
            public enum CodingKeys: String, CodingKey {
                case content
                case function_call
                case tool_calls
                case role
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest`.
        public struct CreateChatCompletionRequest: Codable, Hashable, Sendable {
            /// A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/messages`.
            public var messages: [Components.Schemas.ChatCompletionRequestMessage]
            /// ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable, CaseIterable
                {
                    case o1 = "o1"
                    case o1_hyphen_2024_hyphen_12_hyphen_17 = "o1-2024-12-17"
                    case o1_hyphen_preview = "o1-preview"
                    case o1_hyphen_preview_hyphen_2024_hyphen_09_hyphen_12 = "o1-preview-2024-09-12"
                    case o1_hyphen_mini = "o1-mini"
                    case o1_hyphen_mini_hyphen_2024_hyphen_09_hyphen_12 = "o1-mini-2024-09-12"
                    case gpt_hyphen_4o = "gpt-4o"
                    case gpt_hyphen_4o_hyphen_2024_hyphen_11_hyphen_20 = "gpt-4o-2024-11-20"
                    case gpt_hyphen_4o_hyphen_2024_hyphen_08_hyphen_06 = "gpt-4o-2024-08-06"
                    case gpt_hyphen_4o_hyphen_2024_hyphen_05_hyphen_13 = "gpt-4o-2024-05-13"
                    case gpt_hyphen_4o_hyphen_audio_hyphen_preview = "gpt-4o-audio-preview"
                    case gpt_hyphen_4o_hyphen_audio_hyphen_preview_hyphen_2024_hyphen_10_hyphen_01 =
                        "gpt-4o-audio-preview-2024-10-01"
                    case gpt_hyphen_4o_hyphen_audio_hyphen_preview_hyphen_2024_hyphen_12_hyphen_17 =
                        "gpt-4o-audio-preview-2024-12-17"
                    case gpt_hyphen_4o_hyphen_mini_hyphen_audio_hyphen_preview =
                        "gpt-4o-mini-audio-preview"
                    case
                        gpt_hyphen_4o_hyphen_mini_hyphen_audio_hyphen_preview_hyphen_2024_hyphen_12_hyphen_17 =
                        "gpt-4o-mini-audio-preview-2024-12-17"
                    case chatgpt_hyphen_4o_hyphen_latest = "chatgpt-4o-latest"
                    case gpt_hyphen_4o_hyphen_mini = "gpt-4o-mini"
                    case gpt_hyphen_4o_hyphen_mini_hyphen_2024_hyphen_07_hyphen_18 =
                        "gpt-4o-mini-2024-07-18"
                    case gpt_hyphen_4_hyphen_turbo = "gpt-4-turbo"
                    case gpt_hyphen_4_hyphen_turbo_hyphen_2024_hyphen_04_hyphen_09 =
                        "gpt-4-turbo-2024-04-09"
                    case gpt_hyphen_4_hyphen_0125_hyphen_preview = "gpt-4-0125-preview"
                    case gpt_hyphen_4_hyphen_turbo_hyphen_preview = "gpt-4-turbo-preview"
                    case gpt_hyphen_4_hyphen_1106_hyphen_preview = "gpt-4-1106-preview"
                    case gpt_hyphen_4_hyphen_vision_hyphen_preview = "gpt-4-vision-preview"
                    case gpt_hyphen_4 = "gpt-4"
                    case gpt_hyphen_4_hyphen_0314 = "gpt-4-0314"
                    case gpt_hyphen_4_hyphen_0613 = "gpt-4-0613"
                    case gpt_hyphen_4_hyphen_32k = "gpt-4-32k"
                    case gpt_hyphen_4_hyphen_32k_hyphen_0314 = "gpt-4-32k-0314"
                    case gpt_hyphen_4_hyphen_32k_hyphen_0613 = "gpt-4-32k-0613"
                    case gpt_hyphen_3_period_5_hyphen_turbo = "gpt-3.5-turbo"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_16k = "gpt-3.5-turbo-16k"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_0301 = "gpt-3.5-turbo-0301"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_0613 = "gpt-3.5-turbo-0613"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_1106 = "gpt-3.5-turbo-1106"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_0125 = "gpt-3.5-turbo-0125"
                    case gpt_hyphen_3_period_5_hyphen_turbo_hyphen_16k_hyphen_0613 =
                        "gpt-3.5-turbo-16k-0613"
                }
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateChatCompletionRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateChatCompletionRequest.modelPayload
                        .Value2Payload? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/model`.
            public var model: Components.Schemas.CreateChatCompletionRequest.modelPayload
            /// Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
            ///
            /// [See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/frequency_penalty`.
            public var frequency_penalty: Swift.Double?
            /// Modify the likelihood of specified tokens appearing in the completion.
            ///
            /// Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/logit_bias`.
            public struct logit_biasPayload: Codable, Hashable, Sendable {
                /// A container of undocumented properties.
                public var additionalProperties: [String: Swift.Int]
                /// Creates a new `logit_biasPayload`.
                ///
                /// - Parameters:
                ///   - additionalProperties: A container of undocumented properties.
                public init(additionalProperties: [String: Swift.Int] = .init()) {
                    self.additionalProperties = additionalProperties
                }
                public init(from decoder: any Decoder) throws {
                    additionalProperties = try decoder.decodeAdditionalProperties(knownKeys: [])
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeAdditionalProperties(additionalProperties)
                }
            }
            /// Modify the likelihood of specified tokens appearing in the completion.
            ///
            /// Accepts a JSON object that maps tokens (specified by their token ID in the tokenizer) to an associated bias value from -100 to 100. Mathematically, the bias is added to the logits generated by the model prior to sampling. The exact effect will vary per model, but values between -1 and 1 should decrease or increase likelihood of selection; values like -100 or 100 should result in a ban or exclusive selection of the relevant token.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/logit_bias`.
            public var logit_bias: Components.Schemas.CreateChatCompletionRequest.logit_biasPayload?
            /// The maximum number of [tokens](/tokenizer) to generate in the chat completion.
            ///
            /// The total length of input tokens and generated tokens is limited by the model's context length. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/max_tokens`.
            public var max_tokens: Swift.Int?
            /// How many chat completion choices to generate for each input message.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/n`.
            public var n: Swift.Int?
            /// Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
            ///
            /// [See more information about frequency and presence penalties.](/docs/guides/gpt/parameter-details)
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/presence_penalty`.
            public var presence_penalty: Swift.Double?
            /// An object specifying the format that the model must output.
            ///
            /// Setting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.
            ///
            /// **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in increased latency and appearance of a "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/response_format`.
            public struct response_formatPayload: Codable, Hashable, Sendable {
                /// Must be one of `text` or `json_object`.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/response_format/type`.
                @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                    case text = "text"
                    case json_object = "json_object"
                }
                /// Must be one of `text` or `json_object`.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/response_format/type`.
                public var _type:
                    Components.Schemas.CreateChatCompletionRequest.response_formatPayload
                        ._typePayload?
                /// Creates a new `response_formatPayload`.
                ///
                /// - Parameters:
                ///   - _type: Must be one of `text` or `json_object`.
                public init(
                    _type: Components.Schemas.CreateChatCompletionRequest.response_formatPayload
                        ._typePayload? = nil
                ) {
                    self._type = _type
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                }
            }
            /// An object specifying the format that the model must output.
            ///
            /// Setting to `{ "type": "json_object" }` enables JSON mode, which guarantees the message the model generates is valid JSON.
            ///
            /// **Important:** when using JSON mode, you **must** also instruct the model to produce JSON yourself via a system or user message. Without this, the model may generate an unending stream of whitespace until the generation reaches the token limit, resulting in increased latency and appearance of a "stuck" request. Also note that the message content may be partially cut off if `finish_reason="length"`, which indicates the generation exceeded `max_tokens` or the conversation exceeded the max context length.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/response_format`.
            public var response_format:
                Components.Schemas.CreateChatCompletionRequest.response_formatPayload?
            /// This feature is in Beta.
            /// If specified, our system will make a best effort to sample deterministically, such that repeated requests with the same `seed` and parameters should return the same result.
            /// Determinism is not guaranteed, and you should refer to the `system_fingerprint` response parameter to monitor changes in the backend.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/seed`.
            public var seed: Swift.Int?
            /// Up to 4 sequences where the API will stop generating further tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/stop`.
            @frozen public enum stopPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/stop/case1`.
                case case1(Swift.String?)
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/stop/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// Up to 4 sequences where the API will stop generating further tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/stop`.
            public var stop: Components.Schemas.CreateChatCompletionRequest.stopPayload?
            /// If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/stream`.
            public var stream: Swift.Bool?
            /// What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///
            /// We generally recommend altering this or `top_p` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/temperature`.
            public var temperature: Swift.Double?
            /// An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            ///
            /// We generally recommend altering this or `temperature` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/top_p`.
            public var top_p: Swift.Double?
            /// A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/tools`.
            public var tools: [Components.Schemas.ChatCompletionTool]?
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/tool_choice`.
            public var tool_choice: Components.Schemas.ChatCompletionToolChoiceOption?
            /// A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/user`.
            public var user: Swift.String?
            /// Deprecated in favor of `tool_choice`.
            ///
            /// Controls which (if any) function is called by the model.
            /// `none` means the model will not call a function and instead generates a message.
            /// `auto` means the model can pick between generating a message or calling a function.
            /// Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
            ///
            /// `none` is the default when no functions are present. `auto`` is the default if functions are present.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/function_call`.
            @frozen public enum function_callPayload: Codable, Hashable, Sendable {
                /// `none` means the model will not call a function and instead generates a message. `auto` means the model can pick between generating a message or calling a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/function_call/case1`.
                @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                    case none = "none"
                    case auto = "auto"
                }
                /// `none` means the model will not call a function and instead generates a message. `auto` means the model can pick between generating a message or calling a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/function_call/case1`.
                case case1(
                    Components.Schemas.CreateChatCompletionRequest.function_callPayload.Case1Payload
                )
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/function_call/case2`.
                case ChatCompletionFunctionCallOption(
                    Components.Schemas.ChatCompletionFunctionCallOption)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .ChatCompletionFunctionCallOption(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .ChatCompletionFunctionCallOption(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Deprecated in favor of `tool_choice`.
            ///
            /// Controls which (if any) function is called by the model.
            /// `none` means the model will not call a function and instead generates a message.
            /// `auto` means the model can pick between generating a message or calling a function.
            /// Specifying a particular function via `{"name": "my_function"}` forces the model to call that function.
            ///
            /// `none` is the default when no functions are present. `auto`` is the default if functions are present.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/function_call`.
            @available(*, deprecated)
            public var function_call:
                Components.Schemas.CreateChatCompletionRequest.function_callPayload?
            /// Deprecated in favor of `tools`.
            ///
            /// A list of functions the model may generate JSON inputs for.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionRequest/functions`.
            @available(*, deprecated)
            public var functions: [Components.Schemas.ChatCompletionFunctions]?
            /// Creates a new `CreateChatCompletionRequest`.
            ///
            /// - Parameters:
            ///   - messages: A list of messages comprising the conversation so far. [Example Python code](https://cookbook.openai.com/examples/how_to_format_inputs_to_chatgpt_models).
            ///   - model: ID of the model to use. See the [model endpoint compatibility](/docs/models/model-endpoint-compatibility) table for details on which models work with the Chat API.
            ///   - frequency_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on their existing frequency in the text so far, decreasing the model's likelihood to repeat the same line verbatim.
            ///   - logit_bias: Modify the likelihood of specified tokens appearing in the completion.
            ///   - max_tokens: The maximum number of [tokens](/tokenizer) to generate in the chat completion.
            ///   - n: How many chat completion choices to generate for each input message.
            ///   - presence_penalty: Number between -2.0 and 2.0. Positive values penalize new tokens based on whether they appear in the text so far, increasing the model's likelihood to talk about new topics.
            ///   - response_format: An object specifying the format that the model must output.
            ///   - seed: This feature is in Beta.
            ///   - stop: Up to 4 sequences where the API will stop generating further tokens.
            ///   - stream: If set, partial message deltas will be sent, like in ChatGPT. Tokens will be sent as data-only [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format) as they become available, with the stream terminated by a `data: [DONE]` message. [Example Python code](https://cookbook.openai.com/examples/how_to_stream_completions).
            ///   - temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///   - top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            ///   - tools: A list of tools the model may call. Currently, only functions are supported as a tool. Use this to provide a list of functions the model may generate JSON inputs for.
            ///   - tool_choice:
            ///   - user: A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            ///   - function_call: Deprecated in favor of `tool_choice`.
            ///   - functions: Deprecated in favor of `tools`.
            public init(
                messages: [Components.Schemas.ChatCompletionRequestMessage],
                model: Components.Schemas.CreateChatCompletionRequest.modelPayload,
                frequency_penalty: Swift.Double? = nil,
                logit_bias: Components.Schemas.CreateChatCompletionRequest.logit_biasPayload? = nil,
                max_tokens: Swift.Int? = nil,
                n: Swift.Int? = nil,
                presence_penalty: Swift.Double? = nil,
                response_format: Components.Schemas.CreateChatCompletionRequest
                    .response_formatPayload? = nil,
                seed: Swift.Int? = nil,
                stop: Components.Schemas.CreateChatCompletionRequest.stopPayload? = nil,
                stream: Swift.Bool? = nil,
                temperature: Swift.Double? = nil,
                top_p: Swift.Double? = nil,
                tools: [Components.Schemas.ChatCompletionTool]? = nil,
                tool_choice: Components.Schemas.ChatCompletionToolChoiceOption? = nil,
                user: Swift.String? = nil,
                function_call: Components.Schemas.CreateChatCompletionRequest
                    .function_callPayload? = nil,
                functions: [Components.Schemas.ChatCompletionFunctions]? = nil
            ) {
                self.messages = messages
                self.model = model
                self.frequency_penalty = frequency_penalty
                self.logit_bias = logit_bias
                self.max_tokens = max_tokens
                self.n = n
                self.presence_penalty = presence_penalty
                self.response_format = response_format
                self.seed = seed
                self.stop = stop
                self.stream = stream
                self.temperature = temperature
                self.top_p = top_p
                self.tools = tools
                self.tool_choice = tool_choice
                self.user = user
                self.function_call = function_call
                self.functions = functions
            }
            public enum CodingKeys: String, CodingKey {
                case messages
                case model
                case frequency_penalty
                case logit_bias
                case max_tokens
                case n
                case presence_penalty
                case response_format
                case seed
                case stop
                case stream
                case temperature
                case top_p
                case tools
                case tool_choice
                case user
                case function_call
                case functions
            }
        }
        /// Represents a chat completion response returned by model, based on the provided input.
        ///
        /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse`.
        public struct CreateChatCompletionResponse: Codable, Hashable, Sendable {
            /// A unique identifier for the chat completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choicesPayload`.
            public struct choicesPayloadPayload: Codable, Hashable, Sendable {
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// `content_filter` if content was omitted due to a flag from our content filters,
                /// `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choicesPayload/finish_reason`.
                @frozen public enum finish_reasonPayload: String, Codable, Hashable, Sendable {
                    case stop = "stop"
                    case length = "length"
                    case tool_calls = "tool_calls"
                    case content_filter = "content_filter"
                    case function_call = "function_call"
                }
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// `content_filter` if content was omitted due to a flag from our content filters,
                /// `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choicesPayload/finish_reason`.
                public var finish_reason:
                    Components.Schemas.CreateChatCompletionResponse.choicesPayloadPayload
                        .finish_reasonPayload?
                /// The index of the choice in the list of choices.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choicesPayload/index`.
                public var index: Swift.Int
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choicesPayload/message`.
                public var message: Components.Schemas.ChatCompletionResponseMessage
                /// Creates a new `choicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - finish_reason: The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                ///   - index: The index of the choice in the list of choices.
                ///   - message:
                public init(
                    finish_reason: Components.Schemas.CreateChatCompletionResponse
                        .choicesPayloadPayload.finish_reasonPayload? = nil,
                    index: Swift.Int,
                    message: Components.Schemas.ChatCompletionResponseMessage
                ) {
                    self.finish_reason = finish_reason
                    self.index = index
                    self.message = message
                }
                public enum CodingKeys: String, CodingKey {
                    case finish_reason
                    case index
                    case message
                }
            }
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choices`.
            public typealias choicesPayload = [Components.Schemas.CreateChatCompletionResponse
                .choicesPayloadPayload]
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/choices`.
            public var choices: Components.Schemas.CreateChatCompletionResponse.choicesPayload
            /// The Unix timestamp (in seconds) of when the chat completion was created.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/created`.
            public var created: Swift.Int
            /// The model used for the chat completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/model`.
            public var model: Swift.String
            /// This fingerprint represents the backend configuration that the model runs with.
            ///
            /// Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/system_fingerprint`.
            public var system_fingerprint: Swift.String?
            /// The object type, which is always `chat.completion`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case chat_period_completion = "chat.completion"
            }
            /// The object type, which is always `chat.completion`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/object`.
            public var object: Components.Schemas.CreateChatCompletionResponse.objectPayload
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionResponse/usage`.
            public var usage: Components.Schemas.CompletionUsage?
            /// Creates a new `CreateChatCompletionResponse`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the chat completion.
            ///   - choices: A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///   - created: The Unix timestamp (in seconds) of when the chat completion was created.
            ///   - model: The model used for the chat completion.
            ///   - system_fingerprint: This fingerprint represents the backend configuration that the model runs with.
            ///   - object: The object type, which is always `chat.completion`.
            ///   - usage:
            public init(
                id: Swift.String,
                choices: Components.Schemas.CreateChatCompletionResponse.choicesPayload,
                created: Swift.Int,
                model: Swift.String,
                system_fingerprint: Swift.String? = nil,
                object: Components.Schemas.CreateChatCompletionResponse.objectPayload,
                usage: Components.Schemas.CompletionUsage? = nil
            ) {
                self.id = id
                self.choices = choices
                self.created = created
                self.model = model
                self.system_fingerprint = system_fingerprint
                self.object = object
                self.usage = usage
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case choices
                case created
                case model
                case system_fingerprint
                case object
                case usage
            }
        }
        /// Represents a chat completion response returned by model, based on the provided input.
        ///
        /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse`.
        public struct CreateChatCompletionFunctionResponse: Codable, Hashable, Sendable {
            /// A unique identifier for the chat completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choicesPayload`.
            public struct choicesPayloadPayload: Codable, Hashable, Sendable {
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choicesPayload/finish_reason`.
                @frozen public enum finish_reasonPayload: String, Codable, Hashable, Sendable {
                    case stop = "stop"
                    case length = "length"
                    case function_call = "function_call"
                    case content_filter = "content_filter"
                }
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choicesPayload/finish_reason`.
                public var finish_reason:
                    Components.Schemas.CreateChatCompletionFunctionResponse.choicesPayloadPayload
                        .finish_reasonPayload?
                /// The index of the choice in the list of choices.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choicesPayload/index`.
                public var index: Swift.Int
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choicesPayload/message`.
                public var message: Components.Schemas.ChatCompletionResponseMessage
                /// Creates a new `choicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - finish_reason: The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence, `length` if the maximum number of tokens specified in the request was reached, `content_filter` if content was omitted due to a flag from our content filters, or `function_call` if the model called a function.
                ///   - index: The index of the choice in the list of choices.
                ///   - message:
                public init(
                    finish_reason: Components.Schemas.CreateChatCompletionFunctionResponse
                        .choicesPayloadPayload.finish_reasonPayload? = nil,
                    index: Swift.Int,
                    message: Components.Schemas.ChatCompletionResponseMessage
                ) {
                    self.finish_reason = finish_reason
                    self.index = index
                    self.message = message
                }
                public enum CodingKeys: String, CodingKey {
                    case finish_reason
                    case index
                    case message
                }
            }
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choices`.
            public typealias choicesPayload = [Components.Schemas
                .CreateChatCompletionFunctionResponse.choicesPayloadPayload]
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/choices`.
            public var choices:
                Components.Schemas.CreateChatCompletionFunctionResponse.choicesPayload
            /// The Unix timestamp (in seconds) of when the chat completion was created.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/created`.
            public var created: Swift.Int
            /// The model used for the chat completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/model`.
            public var model: Swift.String
            /// This fingerprint represents the backend configuration that the model runs with.
            ///
            /// Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/system_fingerprint`.
            public var system_fingerprint: Swift.String?
            /// The object type, which is always `chat.completion`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case chat_period_completion = "chat.completion"
            }
            /// The object type, which is always `chat.completion`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/object`.
            public var object: Components.Schemas.CreateChatCompletionFunctionResponse.objectPayload
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionFunctionResponse/usage`.
            public var usage: Components.Schemas.CompletionUsage?
            /// Creates a new `CreateChatCompletionFunctionResponse`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the chat completion.
            ///   - choices: A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///   - created: The Unix timestamp (in seconds) of when the chat completion was created.
            ///   - model: The model used for the chat completion.
            ///   - system_fingerprint: This fingerprint represents the backend configuration that the model runs with.
            ///   - object: The object type, which is always `chat.completion`.
            ///   - usage:
            public init(
                id: Swift.String,
                choices: Components.Schemas.CreateChatCompletionFunctionResponse.choicesPayload,
                created: Swift.Int,
                model: Swift.String,
                system_fingerprint: Swift.String? = nil,
                object: Components.Schemas.CreateChatCompletionFunctionResponse.objectPayload,
                usage: Components.Schemas.CompletionUsage? = nil
            ) {
                self.id = id
                self.choices = choices
                self.created = created
                self.model = model
                self.system_fingerprint = system_fingerprint
                self.object = object
                self.usage = usage
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case choices
                case created
                case model
                case system_fingerprint
                case object
                case usage
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListPaginatedFineTuningJobsResponse`.
        public struct ListPaginatedFineTuningJobsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListPaginatedFineTuningJobsResponse/data`.
            public var data: [Components.Schemas.FineTuningJob]
            /// - Remark: Generated from `#/components/schemas/ListPaginatedFineTuningJobsResponse/has_more`.
            public var has_more: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/ListPaginatedFineTuningJobsResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListPaginatedFineTuningJobsResponse/object`.
            public var object: Components.Schemas.ListPaginatedFineTuningJobsResponse.objectPayload
            /// Creates a new `ListPaginatedFineTuningJobsResponse`.
            ///
            /// - Parameters:
            ///   - data:
            ///   - has_more:
            ///   - object:
            public init(
                data: [Components.Schemas.FineTuningJob],
                has_more: Swift.Bool,
                object: Components.Schemas.ListPaginatedFineTuningJobsResponse.objectPayload
            ) {
                self.data = data
                self.has_more = has_more
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case has_more
                case object
            }
        }
        /// Represents a streamed chunk of a chat completion response returned by model, based on the provided input.
        ///
        /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse`.
        public struct CreateChatCompletionStreamResponse: Codable, Hashable, Sendable {
            /// A unique identifier for the chat completion. Each chunk has the same ID.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choicesPayload`.
            public struct choicesPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choicesPayload/delta`.
                public var delta: Components.Schemas.ChatCompletionStreamResponseDelta
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// `content_filter` if content was omitted due to a flag from our content filters,
                /// `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choicesPayload/finish_reason`.
                @frozen public enum finish_reasonPayload: String, Codable, Hashable, Sendable {
                    case stop = "stop"
                    case length = "length"
                    case tool_calls = "tool_calls"
                    case content_filter = "content_filter"
                    case function_call = "function_call"
                }
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// `content_filter` if content was omitted due to a flag from our content filters,
                /// `tool_calls` if the model called a tool, or `function_call` (deprecated) if the model called a function.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choicesPayload/finish_reason`.
                public var finish_reason:
                    Components.Schemas.CreateChatCompletionStreamResponse.choicesPayloadPayload
                        .finish_reasonPayload?
                /// The index of the choice in the list of choices.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choicesPayload/index`.
                public var index: Swift.Int
                /// Creates a new `choicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - delta:
                ///   - finish_reason: The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                ///   - index: The index of the choice in the list of choices.
                public init(
                    delta: Components.Schemas.ChatCompletionStreamResponseDelta,
                    finish_reason: Components.Schemas.CreateChatCompletionStreamResponse
                        .choicesPayloadPayload.finish_reasonPayload? = nil,
                    index: Swift.Int
                ) {
                    self.delta = delta
                    self.finish_reason = finish_reason
                    self.index = index
                }
                public enum CodingKeys: String, CodingKey {
                    case delta
                    case finish_reason
                    case index
                }
            }
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choices`.
            public typealias choicesPayload = [Components.Schemas.CreateChatCompletionStreamResponse
                .choicesPayloadPayload]
            /// A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/choices`.
            public var choices: Components.Schemas.CreateChatCompletionStreamResponse.choicesPayload
            /// The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/created`.
            public var created: Swift.Int
            /// The model to generate the completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/model`.
            public var model: Swift.String
            /// This fingerprint represents the backend configuration that the model runs with.
            /// Can be used in conjunction with the `seed` request parameter to understand when backend changes have been made that might impact determinism.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/system_fingerprint`.
            public var system_fingerprint: Swift.String?
            /// The object type, which is always `chat.completion.chunk`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case chat_period_completion_period_chunk = "chat.completion.chunk"
            }
            /// The object type, which is always `chat.completion.chunk`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateChatCompletionStreamResponse/object`.
            public var object: Components.Schemas.CreateChatCompletionStreamResponse.objectPayload
            /// Creates a new `CreateChatCompletionStreamResponse`.
            ///
            /// - Parameters:
            ///   - id: A unique identifier for the chat completion. Each chunk has the same ID.
            ///   - choices: A list of chat completion choices. Can be more than one if `n` is greater than 1.
            ///   - created: The Unix timestamp (in seconds) of when the chat completion was created. Each chunk has the same timestamp.
            ///   - model: The model to generate the completion.
            ///   - system_fingerprint: This fingerprint represents the backend configuration that the model runs with.
            ///   - object: The object type, which is always `chat.completion.chunk`.
            public init(
                id: Swift.String,
                choices: Components.Schemas.CreateChatCompletionStreamResponse.choicesPayload,
                created: Swift.Int,
                model: Swift.String,
                system_fingerprint: Swift.String? = nil,
                object: Components.Schemas.CreateChatCompletionStreamResponse.objectPayload
            ) {
                self.id = id
                self.choices = choices
                self.created = created
                self.model = model
                self.system_fingerprint = system_fingerprint
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case choices
                case created
                case model
                case system_fingerprint
                case object
            }
        }
        /// Represents a streamed chunk of a chat completion response returned by model, based on the provided input.
        ///
        /// - Remark: Generated from `#/components/schemas/CreateChatCompletionImageResponse`.
        public typealias CreateChatCompletionImageResponse = OpenAPIRuntime.OpenAPIObjectContainer
        /// - Remark: Generated from `#/components/schemas/CreateEditRequest`.
        public struct CreateEditRequest: Codable, Hashable, Sendable {
            /// The instruction that tells the model how to edit the prompt.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/instruction`.
            public var instruction: Swift.String
            /// ID of the model to use. You can use the `text-davinci-edit-001` or `code-davinci-edit-001` model with this endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateEditRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateEditRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case text_hyphen_davinci_hyphen_edit_hyphen_001 = "text-davinci-edit-001"
                    case code_hyphen_davinci_hyphen_edit_hyphen_001 = "code-davinci-edit-001"
                }
                /// - Remark: Generated from `#/components/schemas/CreateEditRequest/model/value2`.
                public var value2: Components.Schemas.CreateEditRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateEditRequest.modelPayload.Value2Payload? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// ID of the model to use. You can use the `text-davinci-edit-001` or `code-davinci-edit-001` model with this endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/model`.
            public var model: Components.Schemas.CreateEditRequest.modelPayload
            /// The input text to use as a starting point for the edit.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/input`.
            public var input: Swift.String?
            /// How many edits to generate for the input and instruction.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/n`.
            public var n: Swift.Int?
            /// What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///
            /// We generally recommend altering this or `top_p` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/temperature`.
            public var temperature: Swift.Double?
            /// An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            ///
            /// We generally recommend altering this or `temperature` but not both.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditRequest/top_p`.
            public var top_p: Swift.Double?
            /// Creates a new `CreateEditRequest`.
            ///
            /// - Parameters:
            ///   - instruction: The instruction that tells the model how to edit the prompt.
            ///   - model: ID of the model to use. You can use the `text-davinci-edit-001` or `code-davinci-edit-001` model with this endpoint.
            ///   - input: The input text to use as a starting point for the edit.
            ///   - n: How many edits to generate for the input and instruction.
            ///   - temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output more random, while lower values like 0.2 will make it more focused and deterministic.
            ///   - top_p: An alternative to sampling with temperature, called nucleus sampling, where the model considers the results of the tokens with top_p probability mass. So 0.1 means only the tokens comprising the top 10% probability mass are considered.
            public init(
                instruction: Swift.String,
                model: Components.Schemas.CreateEditRequest.modelPayload,
                input: Swift.String? = nil,
                n: Swift.Int? = nil,
                temperature: Swift.Double? = nil,
                top_p: Swift.Double? = nil
            ) {
                self.instruction = instruction
                self.model = model
                self.input = input
                self.n = n
                self.temperature = temperature
                self.top_p = top_p
            }
            public enum CodingKeys: String, CodingKey {
                case instruction
                case model
                case input
                case n
                case temperature
                case top_p
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateEditResponse`.
        @available(*, deprecated)
        public struct CreateEditResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choicesPayload`.
            public struct choicesPayloadPayload: Codable, Hashable, Sendable {
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// or `content_filter` if content was omitted due to a flag from our content filters.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choicesPayload/finish_reason`.
                @frozen public enum finish_reasonPayload: String, Codable, Hashable, Sendable {
                    case stop = "stop"
                    case length = "length"
                }
                /// The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                /// `length` if the maximum number of tokens specified in the request was reached,
                /// or `content_filter` if content was omitted due to a flag from our content filters.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choicesPayload/finish_reason`.
                public var finish_reason:
                    Components.Schemas.CreateEditResponse.choicesPayloadPayload
                        .finish_reasonPayload?
                /// The index of the choice in the list of choices.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choicesPayload/index`.
                public var index: Swift.Int
                /// The edited result.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choicesPayload/text`.
                public var text: Swift.String
                /// Creates a new `choicesPayloadPayload`.
                ///
                /// - Parameters:
                ///   - finish_reason: The reason the model stopped generating tokens. This will be `stop` if the model hit a natural stop point or a provided stop sequence,
                ///   - index: The index of the choice in the list of choices.
                ///   - text: The edited result.
                public init(
                    finish_reason: Components.Schemas.CreateEditResponse.choicesPayloadPayload
                        .finish_reasonPayload? = nil,
                    index: Swift.Int,
                    text: Swift.String
                ) {
                    self.finish_reason = finish_reason
                    self.index = index
                    self.text = text
                }
                public enum CodingKeys: String, CodingKey {
                    case finish_reason
                    case index
                    case text
                }
            }
            /// A list of edit choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choices`.
            public typealias choicesPayload = [Components.Schemas.CreateEditResponse
                .choicesPayloadPayload]
            /// A list of edit choices. Can be more than one if `n` is greater than 1.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/choices`.
            public var choices: Components.Schemas.CreateEditResponse.choicesPayload
            /// The object type, which is always `edit`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case edit = "edit"
            }
            /// The object type, which is always `edit`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/object`.
            public var object: Components.Schemas.CreateEditResponse.objectPayload
            /// The Unix timestamp (in seconds) of when the edit was created.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/created`.
            public var created: Swift.Int
            /// - Remark: Generated from `#/components/schemas/CreateEditResponse/usage`.
            public var usage: Components.Schemas.CompletionUsage
            /// Creates a new `CreateEditResponse`.
            ///
            /// - Parameters:
            ///   - choices: A list of edit choices. Can be more than one if `n` is greater than 1.
            ///   - object: The object type, which is always `edit`.
            ///   - created: The Unix timestamp (in seconds) of when the edit was created.
            ///   - usage:
            public init(
                choices: Components.Schemas.CreateEditResponse.choicesPayload,
                object: Components.Schemas.CreateEditResponse.objectPayload,
                created: Swift.Int,
                usage: Components.Schemas.CompletionUsage
            ) {
                self.choices = choices
                self.object = object
                self.created = created
                self.usage = usage
            }
            public enum CodingKeys: String, CodingKey {
                case choices
                case object
                case created
                case usage
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateImageRequest`.
        public struct CreateImageRequest: Codable, Hashable, Sendable {
            /// A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/prompt`.
            public var prompt: Swift.String
            /// The model to use for image generation.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateImageRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateImageRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case dall_hyphen_e_hyphen_2 = "dall-e-2"
                    case dall_hyphen_e_hyphen_3 = "dall-e-3"
                }
                /// - Remark: Generated from `#/components/schemas/CreateImageRequest/model/value2`.
                public var value2: Components.Schemas.CreateImageRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateImageRequest.modelPayload.Value2Payload? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// The model to use for image generation.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/model`.
            public var model: Components.Schemas.CreateImageRequest.modelPayload?
            /// The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/n`.
            public var n: Swift.Int?
            /// The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/quality`.
            @frozen public enum qualityPayload: String, Codable, Hashable, Sendable {
                case standard = "standard"
                case hd = "hd"
            }
            /// The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/quality`.
            public var quality: Components.Schemas.CreateImageRequest.qualityPayload?
            /// The format in which the generated images are returned. Must be one of `url` or `b64_json`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/response_format`.
            @frozen public enum response_formatPayload: String, Codable, Hashable, Sendable {
                case url = "url"
                case b64_json = "b64_json"
            }
            /// The format in which the generated images are returned. Must be one of `url` or `b64_json`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/response_format`.
            public var response_format:
                Components.Schemas.CreateImageRequest.response_formatPayload?
            /// The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/size`.
            @frozen public enum sizePayload: String, Codable, Hashable, Sendable {
                case _256x256 = "256x256"
                case _512x512 = "512x512"
                case _1024x1024 = "1024x1024"
                case _1792x1024 = "1792x1024"
                case _1024x1792 = "1024x1792"
            }
            /// The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/size`.
            public var size: Components.Schemas.CreateImageRequest.sizePayload?
            /// The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/style`.
            @frozen public enum stylePayload: String, Codable, Hashable, Sendable {
                case vivid = "vivid"
                case natural = "natural"
            }
            /// The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/style`.
            public var style: Components.Schemas.CreateImageRequest.stylePayload?
            /// A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateImageRequest/user`.
            public var user: Swift.String?
            /// Creates a new `CreateImageRequest`.
            ///
            /// - Parameters:
            ///   - prompt: A text description of the desired image(s). The maximum length is 1000 characters for `dall-e-2` and 4000 characters for `dall-e-3`.
            ///   - model: The model to use for image generation.
            ///   - n: The number of images to generate. Must be between 1 and 10. For `dall-e-3`, only `n=1` is supported.
            ///   - quality: The quality of the image that will be generated. `hd` creates images with finer details and greater consistency across the image. This param is only supported for `dall-e-3`.
            ///   - response_format: The format in which the generated images are returned. Must be one of `url` or `b64_json`.
            ///   - size: The size of the generated images. Must be one of `256x256`, `512x512`, or `1024x1024` for `dall-e-2`. Must be one of `1024x1024`, `1792x1024`, or `1024x1792` for `dall-e-3` models.
            ///   - style: The style of the generated images. Must be one of `vivid` or `natural`. Vivid causes the model to lean towards generating hyper-real and dramatic images. Natural causes the model to produce more natural, less hyper-real looking images. This param is only supported for `dall-e-3`.
            ///   - user: A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            public init(
                prompt: Swift.String,
                model: Components.Schemas.CreateImageRequest.modelPayload? = nil,
                n: Swift.Int? = nil,
                quality: Components.Schemas.CreateImageRequest.qualityPayload? = nil,
                response_format: Components.Schemas.CreateImageRequest.response_formatPayload? =
                    nil,
                size: Components.Schemas.CreateImageRequest.sizePayload? = nil,
                style: Components.Schemas.CreateImageRequest.stylePayload? = nil,
                user: Swift.String? = nil
            ) {
                self.prompt = prompt
                self.model = model
                self.n = n
                self.quality = quality
                self.response_format = response_format
                self.size = size
                self.style = style
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case prompt
                case model
                case n
                case quality
                case response_format
                case size
                case style
                case user
            }
        }
        /// - Remark: Generated from `#/components/schemas/ImagesResponse`.
        public struct ImagesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ImagesResponse/created`.
            public var created: Swift.Int
            /// - Remark: Generated from `#/components/schemas/ImagesResponse/data`.
            public var data: [Components.Schemas.Image]
            /// Creates a new `ImagesResponse`.
            ///
            /// - Parameters:
            ///   - created:
            ///   - data:
            public init(
                created: Swift.Int,
                data: [Components.Schemas.Image]
            ) {
                self.created = created
                self.data = data
            }
            public enum CodingKeys: String, CodingKey {
                case created
                case data
            }
        }
        /// Represents the url or the content of an image generated by the OpenAI API.
        ///
        /// - Remark: Generated from `#/components/schemas/Image`.
        public struct Image: Codable, Hashable, Sendable {
            /// The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.
            ///
            /// - Remark: Generated from `#/components/schemas/Image/b64_json`.
            public var b64_json: Swift.String?
            /// The URL of the generated image, if `response_format` is `url` (default).
            ///
            /// - Remark: Generated from `#/components/schemas/Image/url`.
            public var url: Swift.String?
            /// The prompt that was used to generate the image, if there was any revision to the prompt.
            ///
            /// - Remark: Generated from `#/components/schemas/Image/revised_prompt`.
            public var revised_prompt: Swift.String?
            /// Creates a new `Image`.
            ///
            /// - Parameters:
            ///   - b64_json: The base64-encoded JSON of the generated image, if `response_format` is `b64_json`.
            ///   - url: The URL of the generated image, if `response_format` is `url` (default).
            ///   - revised_prompt: The prompt that was used to generate the image, if there was any revision to the prompt.
            public init(
                b64_json: Swift.String? = nil,
                url: Swift.String? = nil,
                revised_prompt: Swift.String? = nil
            ) {
                self.b64_json = b64_json
                self.url = url
                self.revised_prompt = revised_prompt
            }
            public enum CodingKeys: String, CodingKey {
                case b64_json
                case url
                case revised_prompt
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest`.
        @frozen public enum CreateImageEditRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/image`.
            public struct imagePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `imagePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case image(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.imagePayload>
            )
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/prompt`.
            public struct promptPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `promptPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case prompt(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageEditRequest.promptPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/mask`.
            public struct maskPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `maskPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case mask(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.maskPayload>)
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/model`.
            public struct modelPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case model(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.modelPayload>
            )
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/n`.
            public struct nPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `nPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case n(OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.nPayload>)
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/size`.
            public struct sizePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `sizePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case size(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.sizePayload>)
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/response_format`.
            public struct response_formatPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `response_formatPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case response_format(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageEditRequest.response_formatPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageEditRequest/user`.
            public struct userPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `userPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case user(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateImageEditRequest.userPayload>)
            case undocumented(OpenAPIRuntime.MultipartRawPart)
        }
        /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest`.
        @frozen public enum CreateImageVariationRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/image`.
            public struct imagePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `imagePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case image(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.imagePayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/model`.
            public struct modelPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case model(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.modelPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/n`.
            public struct nPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `nPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case n(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.nPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/response_format`.
            public struct response_formatPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `response_formatPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case response_format(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.response_formatPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/size`.
            public struct sizePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `sizePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case size(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.sizePayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateImageVariationRequest/user`.
            public struct userPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `userPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case user(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateImageVariationRequest.userPayload
                >)
            case undocumented(OpenAPIRuntime.MultipartRawPart)
        }
        /// - Remark: Generated from `#/components/schemas/CreateModerationRequest`.
        public struct CreateModerationRequest: Codable, Hashable, Sendable {
            /// The input text to classify
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/input`.
            @frozen public enum inputPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/input/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/input/case2`.
                case case2([Swift.String])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// The input text to classify
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/input`.
            public var input: Components.Schemas.CreateModerationRequest.inputPayload
            /// Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.
            ///
            /// The default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case text_hyphen_moderation_hyphen_latest = "text-moderation-latest"
                    case text_hyphen_moderation_hyphen_stable = "text-moderation-stable"
                }
                /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateModerationRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateModerationRequest.modelPayload.Value2Payload? =
                        nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.
            ///
            /// The default is `text-moderation-latest` which will be automatically upgraded over time. This ensures you are always using our most accurate model. If you use `text-moderation-stable`, we will provide advanced notice before updating the model. Accuracy of `text-moderation-stable` may be slightly lower than for `text-moderation-latest`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationRequest/model`.
            public var model: Components.Schemas.CreateModerationRequest.modelPayload?
            /// Creates a new `CreateModerationRequest`.
            ///
            /// - Parameters:
            ///   - input: The input text to classify
            ///   - model: Two content moderations models are available: `text-moderation-stable` and `text-moderation-latest`.
            public init(
                input: Components.Schemas.CreateModerationRequest.inputPayload,
                model: Components.Schemas.CreateModerationRequest.modelPayload? = nil
            ) {
                self.input = input
                self.model = model
            }
            public enum CodingKeys: String, CodingKey {
                case input
                case model
            }
        }
        /// Represents policy compliance report by OpenAI's content moderation model against a given input.
        ///
        /// - Remark: Generated from `#/components/schemas/CreateModerationResponse`.
        public struct CreateModerationResponse: Codable, Hashable, Sendable {
            /// The unique identifier for the moderation request.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/id`.
            public var id: Swift.String
            /// The model used to generate the moderation results.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/model`.
            public var model: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload`.
            public struct resultsPayloadPayload: Codable, Hashable, Sendable {
                /// Whether the content violates [OpenAI's usage policies](/policies/usage-policies).
                ///
                /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/flagged`.
                public var flagged: Swift.Bool
                /// A list of the categories, and whether they are flagged or not.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories`.
                public struct categoriesPayload: Codable, Hashable, Sendable {
                    /// Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harrassment.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/hate`.
                    public var hate: Swift.Bool
                    /// Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/hate/threatening`.
                    public var hate_sol_threatening: Swift.Bool
                    /// Content that expresses, incites, or promotes harassing language towards any target.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/harassment`.
                    public var harassment: Swift.Bool
                    /// Harassment content that also includes violence or serious harm towards any target.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/harassment/threatening`.
                    public var harassment_sol_threatening: Swift.Bool
                    /// Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/self-harm`.
                    public var self_hyphen_harm: Swift.Bool
                    /// Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/self-harm/intent`.
                    public var self_hyphen_harm_sol_intent: Swift.Bool
                    /// Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/self-harm/instructions`.
                    public var self_hyphen_harm_sol_instructions: Swift.Bool
                    /// Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/sexual`.
                    public var sexual: Swift.Bool
                    /// Sexual content that includes an individual who is under 18 years old.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/sexual/minors`.
                    public var sexual_sol_minors: Swift.Bool
                    /// Content that depicts death, violence, or physical injury.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/violence`.
                    public var violence: Swift.Bool
                    /// Content that depicts death, violence, or physical injury in graphic detail.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories/violence/graphic`.
                    public var violence_sol_graphic: Swift.Bool
                    /// Creates a new `categoriesPayload`.
                    ///
                    /// - Parameters:
                    ///   - hate: Content that expresses, incites, or promotes hate based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste. Hateful content aimed at non-protected groups (e.g., chess players) is harrassment.
                    ///   - hate_sol_threatening: Hateful content that also includes violence or serious harm towards the targeted group based on race, gender, ethnicity, religion, nationality, sexual orientation, disability status, or caste.
                    ///   - harassment: Content that expresses, incites, or promotes harassing language towards any target.
                    ///   - harassment_sol_threatening: Harassment content that also includes violence or serious harm towards any target.
                    ///   - self_hyphen_harm: Content that promotes, encourages, or depicts acts of self-harm, such as suicide, cutting, and eating disorders.
                    ///   - self_hyphen_harm_sol_intent: Content where the speaker expresses that they are engaging or intend to engage in acts of self-harm, such as suicide, cutting, and eating disorders.
                    ///   - self_hyphen_harm_sol_instructions: Content that encourages performing acts of self-harm, such as suicide, cutting, and eating disorders, or that gives instructions or advice on how to commit such acts.
                    ///   - sexual: Content meant to arouse sexual excitement, such as the description of sexual activity, or that promotes sexual services (excluding sex education and wellness).
                    ///   - sexual_sol_minors: Sexual content that includes an individual who is under 18 years old.
                    ///   - violence: Content that depicts death, violence, or physical injury.
                    ///   - violence_sol_graphic: Content that depicts death, violence, or physical injury in graphic detail.
                    public init(
                        hate: Swift.Bool,
                        hate_sol_threatening: Swift.Bool,
                        harassment: Swift.Bool,
                        harassment_sol_threatening: Swift.Bool,
                        self_hyphen_harm: Swift.Bool,
                        self_hyphen_harm_sol_intent: Swift.Bool,
                        self_hyphen_harm_sol_instructions: Swift.Bool,
                        sexual: Swift.Bool,
                        sexual_sol_minors: Swift.Bool,
                        violence: Swift.Bool,
                        violence_sol_graphic: Swift.Bool
                    ) {
                        self.hate = hate
                        self.hate_sol_threatening = hate_sol_threatening
                        self.harassment = harassment
                        self.harassment_sol_threatening = harassment_sol_threatening
                        self.self_hyphen_harm = self_hyphen_harm
                        self.self_hyphen_harm_sol_intent = self_hyphen_harm_sol_intent
                        self.self_hyphen_harm_sol_instructions = self_hyphen_harm_sol_instructions
                        self.sexual = sexual
                        self.sexual_sol_minors = sexual_sol_minors
                        self.violence = violence
                        self.violence_sol_graphic = violence_sol_graphic
                    }
                    public enum CodingKeys: String, CodingKey {
                        case hate
                        case hate_sol_threatening = "hate/threatening"
                        case harassment
                        case harassment_sol_threatening = "harassment/threatening"
                        case self_hyphen_harm = "self-harm"
                        case self_hyphen_harm_sol_intent = "self-harm/intent"
                        case self_hyphen_harm_sol_instructions = "self-harm/instructions"
                        case sexual
                        case sexual_sol_minors = "sexual/minors"
                        case violence
                        case violence_sol_graphic = "violence/graphic"
                    }
                }
                /// A list of the categories, and whether they are flagged or not.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/categories`.
                public var categories:
                    Components.Schemas.CreateModerationResponse.resultsPayloadPayload
                        .categoriesPayload
                /// A list of the categories along with their scores as predicted by model.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores`.
                public struct category_scoresPayload: Codable, Hashable, Sendable {
                    /// The score for the category 'hate'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/hate`.
                    public var hate: Swift.Double
                    /// The score for the category 'hate/threatening'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/hate/threatening`.
                    public var hate_sol_threatening: Swift.Double
                    /// The score for the category 'harassment'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/harassment`.
                    public var harassment: Swift.Double
                    /// The score for the category 'harassment/threatening'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/harassment/threatening`.
                    public var harassment_sol_threatening: Swift.Double
                    /// The score for the category 'self-harm'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/self-harm`.
                    public var self_hyphen_harm: Swift.Double
                    /// The score for the category 'self-harm/intent'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/self-harm/intent`.
                    public var self_hyphen_harm_sol_intent: Swift.Double
                    /// The score for the category 'self-harm/instructions'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/self-harm/instructions`.
                    public var self_hyphen_harm_sol_instructions: Swift.Double
                    /// The score for the category 'sexual'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/sexual`.
                    public var sexual: Swift.Double
                    /// The score for the category 'sexual/minors'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/sexual/minors`.
                    public var sexual_sol_minors: Swift.Double
                    /// The score for the category 'violence'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/violence`.
                    public var violence: Swift.Double
                    /// The score for the category 'violence/graphic'.
                    ///
                    /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores/violence/graphic`.
                    public var violence_sol_graphic: Swift.Double
                    /// Creates a new `category_scoresPayload`.
                    ///
                    /// - Parameters:
                    ///   - hate: The score for the category 'hate'.
                    ///   - hate_sol_threatening: The score for the category 'hate/threatening'.
                    ///   - harassment: The score for the category 'harassment'.
                    ///   - harassment_sol_threatening: The score for the category 'harassment/threatening'.
                    ///   - self_hyphen_harm: The score for the category 'self-harm'.
                    ///   - self_hyphen_harm_sol_intent: The score for the category 'self-harm/intent'.
                    ///   - self_hyphen_harm_sol_instructions: The score for the category 'self-harm/instructions'.
                    ///   - sexual: The score for the category 'sexual'.
                    ///   - sexual_sol_minors: The score for the category 'sexual/minors'.
                    ///   - violence: The score for the category 'violence'.
                    ///   - violence_sol_graphic: The score for the category 'violence/graphic'.
                    public init(
                        hate: Swift.Double,
                        hate_sol_threatening: Swift.Double,
                        harassment: Swift.Double,
                        harassment_sol_threatening: Swift.Double,
                        self_hyphen_harm: Swift.Double,
                        self_hyphen_harm_sol_intent: Swift.Double,
                        self_hyphen_harm_sol_instructions: Swift.Double,
                        sexual: Swift.Double,
                        sexual_sol_minors: Swift.Double,
                        violence: Swift.Double,
                        violence_sol_graphic: Swift.Double
                    ) {
                        self.hate = hate
                        self.hate_sol_threatening = hate_sol_threatening
                        self.harassment = harassment
                        self.harassment_sol_threatening = harassment_sol_threatening
                        self.self_hyphen_harm = self_hyphen_harm
                        self.self_hyphen_harm_sol_intent = self_hyphen_harm_sol_intent
                        self.self_hyphen_harm_sol_instructions = self_hyphen_harm_sol_instructions
                        self.sexual = sexual
                        self.sexual_sol_minors = sexual_sol_minors
                        self.violence = violence
                        self.violence_sol_graphic = violence_sol_graphic
                    }
                    public enum CodingKeys: String, CodingKey {
                        case hate
                        case hate_sol_threatening = "hate/threatening"
                        case harassment
                        case harassment_sol_threatening = "harassment/threatening"
                        case self_hyphen_harm = "self-harm"
                        case self_hyphen_harm_sol_intent = "self-harm/intent"
                        case self_hyphen_harm_sol_instructions = "self-harm/instructions"
                        case sexual
                        case sexual_sol_minors = "sexual/minors"
                        case violence
                        case violence_sol_graphic = "violence/graphic"
                    }
                }
                /// A list of the categories along with their scores as predicted by model.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/resultsPayload/category_scores`.
                public var category_scores:
                    Components.Schemas.CreateModerationResponse.resultsPayloadPayload
                        .category_scoresPayload
                /// Creates a new `resultsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - flagged: Whether the content violates [OpenAI's usage policies](/policies/usage-policies).
                ///   - categories: A list of the categories, and whether they are flagged or not.
                ///   - category_scores: A list of the categories along with their scores as predicted by model.
                public init(
                    flagged: Swift.Bool,
                    categories: Components.Schemas.CreateModerationResponse.resultsPayloadPayload
                        .categoriesPayload,
                    category_scores: Components.Schemas.CreateModerationResponse
                        .resultsPayloadPayload.category_scoresPayload
                ) {
                    self.flagged = flagged
                    self.categories = categories
                    self.category_scores = category_scores
                }
                public enum CodingKeys: String, CodingKey {
                    case flagged
                    case categories
                    case category_scores
                }
            }
            /// A list of moderation objects.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/results`.
            public typealias resultsPayload = [Components.Schemas.CreateModerationResponse
                .resultsPayloadPayload]
            /// A list of moderation objects.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateModerationResponse/results`.
            public var results: Components.Schemas.CreateModerationResponse.resultsPayload
            /// Creates a new `CreateModerationResponse`.
            ///
            /// - Parameters:
            ///   - id: The unique identifier for the moderation request.
            ///   - model: The model used to generate the moderation results.
            ///   - results: A list of moderation objects.
            public init(
                id: Swift.String,
                model: Swift.String,
                results: Components.Schemas.CreateModerationResponse.resultsPayload
            ) {
                self.id = id
                self.model = model
                self.results = results
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case model
                case results
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListFilesResponse`.
        public struct ListFilesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListFilesResponse/data`.
            public var data: [Components.Schemas.OpenAIFile]
            /// - Remark: Generated from `#/components/schemas/ListFilesResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListFilesResponse/object`.
            public var object: Components.Schemas.ListFilesResponse.objectPayload
            /// Creates a new `ListFilesResponse`.
            ///
            /// - Parameters:
            ///   - data:
            ///   - object:
            public init(
                data: [Components.Schemas.OpenAIFile],
                object: Components.Schemas.ListFilesResponse.objectPayload
            ) {
                self.data = data
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateFileRequest`.
        @frozen public enum CreateFileRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/schemas/CreateFileRequest/file`.
            public struct filePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `filePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case file(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateFileRequest.filePayload>)
            /// - Remark: Generated from `#/components/schemas/CreateFileRequest/purpose`.
            public struct purposePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `purposePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case purpose(
                OpenAPIRuntime.MultipartPart<Components.Schemas.CreateFileRequest.purposePayload>)
        }
        /// - Remark: Generated from `#/components/schemas/DeleteFileResponse`.
        public struct DeleteFileResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteFileResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteFileResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case file = "file"
            }
            /// - Remark: Generated from `#/components/schemas/DeleteFileResponse/object`.
            public var object: Components.Schemas.DeleteFileResponse.objectPayload
            /// - Remark: Generated from `#/components/schemas/DeleteFileResponse/deleted`.
            public var deleted: Swift.Bool
            /// Creates a new `DeleteFileResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - object:
            ///   - deleted:
            public init(
                id: Swift.String,
                object: Components.Schemas.DeleteFileResponse.objectPayload,
                deleted: Swift.Bool
            ) {
                self.id = id
                self.object = object
                self.deleted = deleted
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case deleted
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest`.
        public struct CreateFineTuningJobRequest: Codable, Hashable, Sendable {
            /// The name of the model to fine-tune. You can select one of the
            /// [supported models](/docs/guides/fine-tuning/what-models-can-be-fine-tuned).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case babbage_hyphen_002 = "babbage-002"
                    case davinci_hyphen_002 = "davinci-002"
                    case gpt_hyphen_3_period_5_hyphen_turbo = "gpt-3.5-turbo"
                }
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateFineTuningJobRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateFineTuningJobRequest.modelPayload
                        .Value2Payload? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// The name of the model to fine-tune. You can select one of the
            /// [supported models](/docs/guides/fine-tuning/what-models-can-be-fine-tuned).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/model`.
            public var model: Components.Schemas.CreateFineTuningJobRequest.modelPayload
            /// The ID of an uploaded file that contains training data.
            ///
            /// See [upload file](/docs/api-reference/files/upload) for how to upload a file.
            ///
            /// Your dataset must be formatted as a JSONL file. Additionally, you must upload your file with the purpose `fine-tune`.
            ///
            /// See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/training_file`.
            public var training_file: Swift.String
            /// The hyperparameters used for the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters`.
            public struct hyperparametersPayload: Codable, Hashable, Sendable {
                /// Number of examples in each batch. A larger batch size means that model parameters
                /// are updated less frequently, but with lower variance.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/batch_size`.
                @frozen public enum batch_sizePayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/batch_size/case1`.
                    @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                        case auto = "auto"
                    }
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/batch_size/case1`.
                    case case1(
                        Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                            .batch_sizePayload.Case1Payload)
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/batch_size/case2`.
                    case case2(Swift.Int)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// Number of examples in each batch. A larger batch size means that model parameters
                /// are updated less frequently, but with lower variance.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/batch_size`.
                public var batch_size:
                    Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                        .batch_sizePayload?
                /// Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
                /// overfitting.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/learning_rate_multiplier`.
                @frozen public enum learning_rate_multiplierPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/learning_rate_multiplier/case1`.
                    @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                        case auto = "auto"
                    }
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/learning_rate_multiplier/case1`.
                    case case1(
                        Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                            .learning_rate_multiplierPayload.Case1Payload)
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/learning_rate_multiplier/case2`.
                    case case2(Swift.Double)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
                /// overfitting.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/learning_rate_multiplier`.
                public var learning_rate_multiplier:
                    Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                        .learning_rate_multiplierPayload?
                /// The number of epochs to train the model for. An epoch refers to one full cycle
                /// through the training dataset.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/n_epochs`.
                @frozen public enum n_epochsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/n_epochs/case1`.
                    @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                        case auto = "auto"
                    }
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/n_epochs/case1`.
                    case case1(
                        Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                            .n_epochsPayload.Case1Payload)
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/n_epochs/case2`.
                    case case2(Swift.Int)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// The number of epochs to train the model for. An epoch refers to one full cycle
                /// through the training dataset.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters/n_epochs`.
                public var n_epochs:
                    Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                        .n_epochsPayload?
                /// Creates a new `hyperparametersPayload`.
                ///
                /// - Parameters:
                ///   - batch_size: Number of examples in each batch. A larger batch size means that model parameters
                ///   - learning_rate_multiplier: Scaling factor for the learning rate. A smaller learning rate may be useful to avoid
                ///   - n_epochs: The number of epochs to train the model for. An epoch refers to one full cycle
                public init(
                    batch_size: Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                        .batch_sizePayload? = nil,
                    learning_rate_multiplier: Components.Schemas.CreateFineTuningJobRequest
                        .hyperparametersPayload.learning_rate_multiplierPayload? = nil,
                    n_epochs: Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload
                        .n_epochsPayload? = nil
                ) {
                    self.batch_size = batch_size
                    self.learning_rate_multiplier = learning_rate_multiplier
                    self.n_epochs = n_epochs
                }
                public enum CodingKeys: String, CodingKey {
                    case batch_size
                    case learning_rate_multiplier
                    case n_epochs
                }
            }
            /// The hyperparameters used for the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/hyperparameters`.
            public var hyperparameters:
                Components.Schemas.CreateFineTuningJobRequest.hyperparametersPayload?
            /// A string of up to 18 characters that will be added to your fine-tuned model name.
            ///
            /// For example, a `suffix` of "custom-model-name" would produce a model name like `ft:gpt-3.5-turbo:openai:custom-model-name:7p4lURel`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/suffix`.
            public var suffix: Swift.String?
            /// The ID of an uploaded file that contains validation data.
            ///
            /// If you provide this file, the data is used to generate validation
            /// metrics periodically during fine-tuning. These metrics can be viewed in
            /// the fine-tuning results file.
            /// The same data should not be present in both train and validation files.
            ///
            /// Your dataset must be formatted as a JSONL file. You must upload your file with the purpose `fine-tune`.
            ///
            /// See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuningJobRequest/validation_file`.
            public var validation_file: Swift.String?
            /// Creates a new `CreateFineTuningJobRequest`.
            ///
            /// - Parameters:
            ///   - model: The name of the model to fine-tune. You can select one of the
            ///   - training_file: The ID of an uploaded file that contains training data.
            ///   - hyperparameters: The hyperparameters used for the fine-tuning job.
            ///   - suffix: A string of up to 18 characters that will be added to your fine-tuned model name.
            ///   - validation_file: The ID of an uploaded file that contains validation data.
            public init(
                model: Components.Schemas.CreateFineTuningJobRequest.modelPayload,
                training_file: Swift.String,
                hyperparameters: Components.Schemas.CreateFineTuningJobRequest
                    .hyperparametersPayload? = nil,
                suffix: Swift.String? = nil,
                validation_file: Swift.String? = nil
            ) {
                self.model = model
                self.training_file = training_file
                self.hyperparameters = hyperparameters
                self.suffix = suffix
                self.validation_file = validation_file
            }
            public enum CodingKeys: String, CodingKey {
                case model
                case training_file
                case hyperparameters
                case suffix
                case validation_file
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListFineTuningJobEventsResponse`.
        public struct ListFineTuningJobEventsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListFineTuningJobEventsResponse/data`.
            public var data: [Components.Schemas.FineTuningJobEvent]
            /// - Remark: Generated from `#/components/schemas/ListFineTuningJobEventsResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListFineTuningJobEventsResponse/object`.
            public var object: Components.Schemas.ListFineTuningJobEventsResponse.objectPayload
            /// Creates a new `ListFineTuningJobEventsResponse`.
            ///
            /// - Parameters:
            ///   - data:
            ///   - object:
            public init(
                data: [Components.Schemas.FineTuningJobEvent],
                object: Components.Schemas.ListFineTuningJobEventsResponse.objectPayload
            ) {
                self.data = data
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest`.
        public struct CreateFineTuneRequest: Codable, Hashable, Sendable {
            /// The ID of an uploaded file that contains training data.
            ///
            /// See [upload file](/docs/api-reference/files/upload) for how to upload a file.
            ///
            /// Your dataset must be formatted as a JSONL file, where each training
            /// example is a JSON object with the keys "prompt" and "completion".
            /// Additionally, you must upload your file with the purpose `fine-tune`.
            ///
            /// See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/creating-training-data) for more details.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/training_file`.
            public var training_file: Swift.String
            /// The batch size to use for training. The batch size is the number of
            /// training examples used to train a single forward and backward pass.
            ///
            /// By default, the batch size will be dynamically configured to be
            /// ~0.2% of the number of examples in the training set, capped at 256 -
            /// in general, we've found that larger batch sizes tend to work better
            /// for larger datasets.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/batch_size`.
            public var batch_size: Swift.Int?
            /// If this is provided, we calculate F-beta scores at the specified
            /// beta values. The F-beta score is a generalization of F-1 score.
            /// This is only used for binary classification.
            ///
            /// With a beta of 1 (i.e. the F-1 score), precision and recall are
            /// given the same weight. A larger beta score puts more weight on
            /// recall and less on precision. A smaller beta score puts more weight
            /// on precision and less on recall.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/classification_betas`.
            public var classification_betas: [Swift.Double]?
            /// The number of classes in a classification task.
            ///
            /// This parameter is required for multiclass classification.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/classification_n_classes`.
            public var classification_n_classes: Swift.Int?
            /// The positive class in binary classification.
            ///
            /// This parameter is needed to generate precision, recall, and F1
            /// metrics when doing binary classification.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/classification_positive_class`.
            public var classification_positive_class: Swift.String?
            /// If set, we calculate classification-specific metrics such as accuracy
            /// and F-1 score using the validation set at the end of every epoch.
            /// These metrics can be viewed in the [results file](/docs/guides/legacy-fine-tuning/analyzing-your-fine-tuned-model).
            ///
            /// In order to compute classification metrics, you must provide a
            /// `validation_file`. Additionally, you must
            /// specify `classification_n_classes` for multiclass classification or
            /// `classification_positive_class` for binary classification.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/compute_classification_metrics`.
            public var compute_classification_metrics: Swift.Bool?
            /// The hyperparameters used for the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters`.
            public struct hyperparametersPayload: Codable, Hashable, Sendable {
                /// The number of epochs to train the model for. An epoch refers to one
                /// full cycle through the training dataset.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters/n_epochs`.
                @frozen public enum n_epochsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters/n_epochs/case1`.
                    @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                        case auto = "auto"
                    }
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters/n_epochs/case1`.
                    case case1(
                        Components.Schemas.CreateFineTuneRequest.hyperparametersPayload
                            .n_epochsPayload.Case1Payload)
                    /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters/n_epochs/case2`.
                    case case2(Swift.Int)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// The number of epochs to train the model for. An epoch refers to one
                /// full cycle through the training dataset.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters/n_epochs`.
                public var n_epochs:
                    Components.Schemas.CreateFineTuneRequest.hyperparametersPayload.n_epochsPayload?
                /// Creates a new `hyperparametersPayload`.
                ///
                /// - Parameters:
                ///   - n_epochs: The number of epochs to train the model for. An epoch refers to one
                public init(
                    n_epochs: Components.Schemas.CreateFineTuneRequest.hyperparametersPayload
                        .n_epochsPayload? = nil
                ) {
                    self.n_epochs = n_epochs
                }
                public enum CodingKeys: String, CodingKey {
                    case n_epochs
                }
            }
            /// The hyperparameters used for the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/hyperparameters`.
            public var hyperparameters:
                Components.Schemas.CreateFineTuneRequest.hyperparametersPayload?
            /// The learning rate multiplier to use for training.
            /// The fine-tuning learning rate is the original learning rate used for
            /// pretraining multiplied by this value.
            ///
            /// By default, the learning rate multiplier is the 0.05, 0.1, or 0.2
            /// depending on final `batch_size` (larger learning rates tend to
            /// perform better with larger batch sizes). We recommend experimenting
            /// with values in the range 0.02 to 0.2 to see what produces the best
            /// results.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/learning_rate_multiplier`.
            public var learning_rate_multiplier: Swift.Double?
            /// The name of the base model to fine-tune. You can select one of "ada",
            /// "babbage", "curie", "davinci", or a fine-tuned model created after 2022-04-21 and before 2023-08-22.
            /// To learn more about these models, see the
            /// [Models](/docs/models) documentation.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case ada = "ada"
                    case babbage = "babbage"
                    case curie = "curie"
                    case davinci = "davinci"
                }
                /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateFineTuneRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateFineTuneRequest.modelPayload.Value2Payload? =
                        nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// The name of the base model to fine-tune. You can select one of "ada",
            /// "babbage", "curie", "davinci", or a fine-tuned model created after 2022-04-21 and before 2023-08-22.
            /// To learn more about these models, see the
            /// [Models](/docs/models) documentation.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/model`.
            public var model: Components.Schemas.CreateFineTuneRequest.modelPayload?
            /// The weight to use for loss on the prompt tokens. This controls how
            /// much the model tries to learn to generate the prompt (as compared
            /// to the completion which always has a weight of 1.0), and can add
            /// a stabilizing effect to training when completions are short.
            ///
            /// If prompts are extremely long (relative to completions), it may make
            /// sense to reduce this weight so as to avoid over-prioritizing
            /// learning the prompt.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/prompt_loss_weight`.
            public var prompt_loss_weight: Swift.Double?
            /// A string of up to 40 characters that will be added to your fine-tuned model name.
            ///
            /// For example, a `suffix` of "custom-model-name" would produce a model name like `ada:ft-your-org:custom-model-name-2022-02-15-04-21-04`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/suffix`.
            public var suffix: Swift.String?
            /// The ID of an uploaded file that contains validation data.
            ///
            /// If you provide this file, the data is used to generate validation
            /// metrics periodically during fine-tuning. These metrics can be viewed in
            /// the [fine-tuning results file](/docs/guides/legacy-fine-tuning/analyzing-your-fine-tuned-model).
            /// Your train and validation data should be mutually exclusive.
            ///
            /// Your dataset must be formatted as a JSONL file, where each validation
            /// example is a JSON object with the keys "prompt" and "completion".
            /// Additionally, you must upload your file with the purpose `fine-tune`.
            ///
            /// See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/creating-training-data) for more details.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateFineTuneRequest/validation_file`.
            public var validation_file: Swift.String?
            /// Creates a new `CreateFineTuneRequest`.
            ///
            /// - Parameters:
            ///   - training_file: The ID of an uploaded file that contains training data.
            ///   - batch_size: The batch size to use for training. The batch size is the number of
            ///   - classification_betas: If this is provided, we calculate F-beta scores at the specified
            ///   - classification_n_classes: The number of classes in a classification task.
            ///   - classification_positive_class: The positive class in binary classification.
            ///   - compute_classification_metrics: If set, we calculate classification-specific metrics such as accuracy
            ///   - hyperparameters: The hyperparameters used for the fine-tuning job.
            ///   - learning_rate_multiplier: The learning rate multiplier to use for training.
            ///   - model: The name of the base model to fine-tune. You can select one of "ada",
            ///   - prompt_loss_weight: The weight to use for loss on the prompt tokens. This controls how
            ///   - suffix: A string of up to 40 characters that will be added to your fine-tuned model name.
            ///   - validation_file: The ID of an uploaded file that contains validation data.
            public init(
                training_file: Swift.String,
                batch_size: Swift.Int? = nil,
                classification_betas: [Swift.Double]? = nil,
                classification_n_classes: Swift.Int? = nil,
                classification_positive_class: Swift.String? = nil,
                compute_classification_metrics: Swift.Bool? = nil,
                hyperparameters: Components.Schemas.CreateFineTuneRequest.hyperparametersPayload? =
                    nil,
                learning_rate_multiplier: Swift.Double? = nil,
                model: Components.Schemas.CreateFineTuneRequest.modelPayload? = nil,
                prompt_loss_weight: Swift.Double? = nil,
                suffix: Swift.String? = nil,
                validation_file: Swift.String? = nil
            ) {
                self.training_file = training_file
                self.batch_size = batch_size
                self.classification_betas = classification_betas
                self.classification_n_classes = classification_n_classes
                self.classification_positive_class = classification_positive_class
                self.compute_classification_metrics = compute_classification_metrics
                self.hyperparameters = hyperparameters
                self.learning_rate_multiplier = learning_rate_multiplier
                self.model = model
                self.prompt_loss_weight = prompt_loss_weight
                self.suffix = suffix
                self.validation_file = validation_file
            }
            public enum CodingKeys: String, CodingKey {
                case training_file
                case batch_size
                case classification_betas
                case classification_n_classes
                case classification_positive_class
                case compute_classification_metrics
                case hyperparameters
                case learning_rate_multiplier
                case model
                case prompt_loss_weight
                case suffix
                case validation_file
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListFineTunesResponse`.
        public struct ListFineTunesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListFineTunesResponse/data`.
            public var data: [Components.Schemas.FineTune]
            /// - Remark: Generated from `#/components/schemas/ListFineTunesResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListFineTunesResponse/object`.
            public var object: Components.Schemas.ListFineTunesResponse.objectPayload
            /// Creates a new `ListFineTunesResponse`.
            ///
            /// - Parameters:
            ///   - data:
            ///   - object:
            public init(
                data: [Components.Schemas.FineTune],
                object: Components.Schemas.ListFineTunesResponse.objectPayload
            ) {
                self.data = data
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListFineTuneEventsResponse`.
        public struct ListFineTuneEventsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListFineTuneEventsResponse/data`.
            public var data: [Components.Schemas.FineTuneEvent]
            /// - Remark: Generated from `#/components/schemas/ListFineTuneEventsResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// - Remark: Generated from `#/components/schemas/ListFineTuneEventsResponse/object`.
            public var object: Components.Schemas.ListFineTuneEventsResponse.objectPayload
            /// Creates a new `ListFineTuneEventsResponse`.
            ///
            /// - Parameters:
            ///   - data:
            ///   - object:
            public init(
                data: [Components.Schemas.FineTuneEvent],
                object: Components.Schemas.ListFineTuneEventsResponse.objectPayload
            ) {
                self.data = data
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest`.
        public struct CreateEmbeddingRequest: Codable, Hashable, Sendable {
            /// Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`) and cannot be an empty string. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input`.
            @frozen public enum inputPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input/case1`.
                case case1(Swift.String)
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input/case2`.
                case case2([Swift.String])
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input/case3`.
                case case3([Swift.Int])
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input/case4`.
                case case4([[Swift.Int]])
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .case1(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case2(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case3(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .case4(try decoder.decodeFromSingleValueContainer())
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .case1(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case2(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case3(value):
                        try encoder.encodeToSingleValueContainer(value)
                    case let .case4(value):
                        try encoder.encodeToSingleValueContainer(value)
                    }
                }
            }
            /// Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`) and cannot be an empty string. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/input`.
            public var input: Components.Schemas.CreateEmbeddingRequest.inputPayload
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case text_hyphen_embedding_hyphen_ada_hyphen_002 = "text-embedding-ada-002"
                }
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateEmbeddingRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateEmbeddingRequest.modelPayload.Value2Payload? =
                        nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/model`.
            public var model: Components.Schemas.CreateEmbeddingRequest.modelPayload
            /// The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/encoding_format`.
            @frozen public enum encoding_formatPayload: String, Codable, Hashable, Sendable {
                case float = "float"
                case base64 = "base64"
            }
            /// The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/encoding_format`.
            public var encoding_format:
                Components.Schemas.CreateEmbeddingRequest.encoding_formatPayload?
            /// A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingRequest/user`.
            public var user: Swift.String?
            /// Creates a new `CreateEmbeddingRequest`.
            ///
            /// - Parameters:
            ///   - input: Input text to embed, encoded as a string or array of tokens. To embed multiple inputs in a single request, pass an array of strings or array of token arrays. The input must not exceed the max input tokens for the model (8192 tokens for `text-embedding-ada-002`) and cannot be an empty string. [Example Python code](https://cookbook.openai.com/examples/how_to_count_tokens_with_tiktoken) for counting tokens.
            ///   - model: ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///   - encoding_format: The format to return the embeddings in. Can be either `float` or [`base64`](https://pypi.org/project/pybase64/).
            ///   - user: A unique identifier representing your end-user, which can help OpenAI to monitor and detect abuse. [Learn more](/docs/guides/safety-best-practices/end-user-ids).
            public init(
                input: Components.Schemas.CreateEmbeddingRequest.inputPayload,
                model: Components.Schemas.CreateEmbeddingRequest.modelPayload,
                encoding_format: Components.Schemas.CreateEmbeddingRequest.encoding_formatPayload? =
                    nil,
                user: Swift.String? = nil
            ) {
                self.input = input
                self.model = model
                self.encoding_format = encoding_format
                self.user = user
            }
            public enum CodingKeys: String, CodingKey {
                case input
                case model
                case encoding_format
                case user
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                input = try container.decode(
                    Components.Schemas.CreateEmbeddingRequest.inputPayload.self,
                    forKey: .input
                )
                model = try container.decode(
                    Components.Schemas.CreateEmbeddingRequest.modelPayload.self,
                    forKey: .model
                )
                encoding_format = try container.decodeIfPresent(
                    Components.Schemas.CreateEmbeddingRequest.encoding_formatPayload.self,
                    forKey: .encoding_format
                )
                user = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .user
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "input",
                    "model",
                    "encoding_format",
                    "user",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse`.
        public struct CreateEmbeddingResponse: Codable, Hashable, Sendable {
            /// The list of embeddings generated by the model.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/data`.
            public var data: [Components.Schemas.Embedding]
            /// The name of the model used to generate the embedding.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/model`.
            public var model: Swift.String
            /// The object type, which is always "list".
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case list = "list"
            }
            /// The object type, which is always "list".
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/object`.
            public var object: Components.Schemas.CreateEmbeddingResponse.objectPayload
            /// The usage information for the request.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/usage`.
            public struct usagePayload: Codable, Hashable, Sendable {
                /// The number of tokens used by the prompt.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/usage/prompt_tokens`.
                public var prompt_tokens: Swift.Int
                /// The total number of tokens used by the request.
                ///
                /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/usage/total_tokens`.
                public var total_tokens: Swift.Int
                /// Creates a new `usagePayload`.
                ///
                /// - Parameters:
                ///   - prompt_tokens: The number of tokens used by the prompt.
                ///   - total_tokens: The total number of tokens used by the request.
                public init(
                    prompt_tokens: Swift.Int,
                    total_tokens: Swift.Int
                ) {
                    self.prompt_tokens = prompt_tokens
                    self.total_tokens = total_tokens
                }
                public enum CodingKeys: String, CodingKey {
                    case prompt_tokens
                    case total_tokens
                }
            }
            /// The usage information for the request.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateEmbeddingResponse/usage`.
            public var usage: Components.Schemas.CreateEmbeddingResponse.usagePayload
            /// Creates a new `CreateEmbeddingResponse`.
            ///
            /// - Parameters:
            ///   - data: The list of embeddings generated by the model.
            ///   - model: The name of the model used to generate the embedding.
            ///   - object: The object type, which is always "list".
            ///   - usage: The usage information for the request.
            public init(
                data: [Components.Schemas.Embedding],
                model: Swift.String,
                object: Components.Schemas.CreateEmbeddingResponse.objectPayload,
                usage: Components.Schemas.CreateEmbeddingResponse.usagePayload
            ) {
                self.data = data
                self.model = model
                self.object = object
                self.usage = usage
            }
            public enum CodingKeys: String, CodingKey {
                case data
                case model
                case object
                case usage
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest`.
        @frozen public enum CreateTranscriptionRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/file`.
            public struct filePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `filePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case file(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.filePayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/model`.
            public struct modelPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case model(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.modelPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/language`.
            public struct languagePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `languagePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case language(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.languagePayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/prompt`.
            public struct promptPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `promptPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case prompt(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.promptPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/response_format`.
            public struct response_formatPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `response_formatPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case response_format(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.response_formatPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionRequest/temperature`.
            public struct temperaturePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `temperaturePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case temperature(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranscriptionRequest.temperaturePayload
                >)
        }
        /// - Remark: Generated from `#/components/schemas/CreateTranscriptionResponse`.
        public struct CreateTranscriptionResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/CreateTranscriptionResponse/text`.
            public var text: Swift.String
            /// Creates a new `CreateTranscriptionResponse`.
            ///
            /// - Parameters:
            ///   - text:
            public init(text: Swift.String) {
                self.text = text
            }
            public enum CodingKeys: String, CodingKey {
                case text
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest`.
        @frozen public enum CreateTranslationRequest: Sendable, Hashable {
            /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest/file`.
            public struct filePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `filePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case file(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranslationRequest.filePayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest/model`.
            public struct modelPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case model(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranslationRequest.modelPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest/prompt`.
            public struct promptPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `promptPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case prompt(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranslationRequest.promptPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest/response_format`.
            public struct response_formatPayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `response_formatPayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case response_format(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranslationRequest.response_formatPayload
                >)
            /// - Remark: Generated from `#/components/schemas/CreateTranslationRequest/temperature`.
            public struct temperaturePayload: Sendable, Hashable {
                public var body: OpenAPIRuntime.HTTPBody
                /// Creates a new `temperaturePayload`.
                ///
                /// - Parameters:
                ///   - body:
                public init(body: OpenAPIRuntime.HTTPBody) {
                    self.body = body
                }
            }
            case temperature(
                OpenAPIRuntime.MultipartPart<
                    Components.Schemas.CreateTranslationRequest.temperaturePayload
                >)
        }
        /// - Remark: Generated from `#/components/schemas/CreateTranslationResponse`.
        public struct CreateTranslationResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/CreateTranslationResponse/text`.
            public var text: Swift.String
            /// Creates a new `CreateTranslationResponse`.
            ///
            /// - Parameters:
            ///   - text:
            public init(text: Swift.String) {
                self.text = text
            }
            public enum CodingKeys: String, CodingKey {
                case text
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest`.
        public struct CreateSpeechRequest: Codable, Hashable, Sendable {
            /// One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/model/value1`.
                public var value1: Swift.String?
                /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/model/value2`.
                @frozen public enum Value2Payload: String, Codable, Hashable, Sendable {
                    case tts_hyphen_1 = "tts-1"
                    case tts_hyphen_1_hyphen_hd = "tts-1-hd"
                }
                /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/model/value2`.
                public var value2:
                    Components.Schemas.CreateSpeechRequest.modelPayload.Value2Payload?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                ///   - value2:
                public init(
                    value1: Swift.String? = nil,
                    value2: Components.Schemas.CreateSpeechRequest.modelPayload.Value2Payload? = nil
                ) {
                    self.value1 = value1
                    self.value2 = value2
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    do {
                        value2 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1,
                            value2,
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1,
                        value2,
                    ])
                }
            }
            /// One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/model`.
            public var model: Components.Schemas.CreateSpeechRequest.modelPayload
            /// The text to generate audio for. The maximum length is 4096 characters.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/input`.
            public var input: Swift.String
            /// The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/voice`.
            @frozen public enum voicePayload: String, Codable, Hashable, Sendable {
                case alloy = "alloy"
                case echo = "echo"
                case fable = "fable"
                case onyx = "onyx"
                case nova = "nova"
                case shimmer = "shimmer"
            }
            /// The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/voice`.
            public var voice: Components.Schemas.CreateSpeechRequest.voicePayload
            /// The format to audio in. Supported formats are `mp3`, `opus`, `aac`, and `flac`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/response_format`.
            @frozen public enum response_formatPayload: String, Codable, Hashable, Sendable {
                case mp3 = "mp3"
                case opus = "opus"
                case aac = "aac"
                case flac = "flac"
            }
            /// The format to audio in. Supported formats are `mp3`, `opus`, `aac`, and `flac`.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/response_format`.
            public var response_format:
                Components.Schemas.CreateSpeechRequest.response_formatPayload?
            /// The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateSpeechRequest/speed`.
            public var speed: Swift.Double?
            /// Creates a new `CreateSpeechRequest`.
            ///
            /// - Parameters:
            ///   - model: One of the available [TTS models](/docs/models/tts): `tts-1` or `tts-1-hd`
            ///   - input: The text to generate audio for. The maximum length is 4096 characters.
            ///   - voice: The voice to use when generating the audio. Supported voices are `alloy`, `echo`, `fable`, `onyx`, `nova`, and `shimmer`.
            ///   - response_format: The format to audio in. Supported formats are `mp3`, `opus`, `aac`, and `flac`.
            ///   - speed: The speed of the generated audio. Select a value from `0.25` to `4.0`. `1.0` is the default.
            public init(
                model: Components.Schemas.CreateSpeechRequest.modelPayload,
                input: Swift.String,
                voice: Components.Schemas.CreateSpeechRequest.voicePayload,
                response_format: Components.Schemas.CreateSpeechRequest.response_formatPayload? =
                    nil,
                speed: Swift.Double? = nil
            ) {
                self.model = model
                self.input = input
                self.voice = voice
                self.response_format = response_format
                self.speed = speed
            }
            public enum CodingKeys: String, CodingKey {
                case model
                case input
                case voice
                case response_format
                case speed
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                model = try container.decode(
                    Components.Schemas.CreateSpeechRequest.modelPayload.self,
                    forKey: .model
                )
                input = try container.decode(
                    Swift.String.self,
                    forKey: .input
                )
                voice = try container.decode(
                    Components.Schemas.CreateSpeechRequest.voicePayload.self,
                    forKey: .voice
                )
                response_format = try container.decodeIfPresent(
                    Components.Schemas.CreateSpeechRequest.response_formatPayload.self,
                    forKey: .response_format
                )
                speed = try container.decodeIfPresent(
                    Swift.Double.self,
                    forKey: .speed
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "model",
                    "input",
                    "voice",
                    "response_format",
                    "speed",
                ])
            }
        }
        /// Describes an OpenAI model offering that can be used with the API.
        ///
        /// - Remark: Generated from `#/components/schemas/Model`.
        public struct Model: Codable, Hashable, Sendable {
            /// The model identifier, which can be referenced in the API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/Model/id`.
            public var id: Swift.String
            /// The Unix timestamp (in seconds) when the model was created.
            ///
            /// - Remark: Generated from `#/components/schemas/Model/created`.
            public var created: Swift.Int
            /// The object type, which is always "model".
            ///
            /// - Remark: Generated from `#/components/schemas/Model/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case model = "model"
            }
            /// The object type, which is always "model".
            ///
            /// - Remark: Generated from `#/components/schemas/Model/object`.
            public var object: Components.Schemas.Model.objectPayload
            /// The organization that owns the model.
            ///
            /// - Remark: Generated from `#/components/schemas/Model/owned_by`.
            public var owned_by: Swift.String
            /// Creates a new `Model`.
            ///
            /// - Parameters:
            ///   - id: The model identifier, which can be referenced in the API endpoints.
            ///   - created: The Unix timestamp (in seconds) when the model was created.
            ///   - object: The object type, which is always "model".
            ///   - owned_by: The organization that owns the model.
            public init(
                id: Swift.String,
                created: Swift.Int,
                object: Components.Schemas.Model.objectPayload,
                owned_by: Swift.String
            ) {
                self.id = id
                self.created = created
                self.object = object
                self.owned_by = owned_by
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case created
                case object
                case owned_by
            }
        }
        /// The `File` object represents a document that has been uploaded to OpenAI.
        ///
        /// - Remark: Generated from `#/components/schemas/OpenAIFile`.
        public struct OpenAIFile: Codable, Hashable, Sendable {
            /// The file identifier, which can be referenced in the API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/id`.
            public var id: Swift.String
            /// The size of the file, in bytes.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/bytes`.
            public var bytes: Swift.Int
            /// The Unix timestamp (in seconds) for when the file was created.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/created_at`.
            public var created_at: Swift.Int
            /// The name of the file.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/filename`.
            public var filename: Swift.String
            /// The object type, which is always `file`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case file = "file"
            }
            /// The object type, which is always `file`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/object`.
            public var object: Components.Schemas.OpenAIFile.objectPayload
            /// The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`, `assistants`, and `assistants_output`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/purpose`.
            @frozen public enum purposePayload: String, Codable, Hashable, Sendable {
                case fine_hyphen_tune = "fine-tune"
                case fine_hyphen_tune_hyphen_results = "fine-tune-results"
                case assistants = "assistants"
                case assistants_output = "assistants_output"
            }
            /// The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`, `assistants`, and `assistants_output`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/purpose`.
            public var purpose: Components.Schemas.OpenAIFile.purposePayload
            /// Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/status`.
            @frozen public enum statusPayload: String, Codable, Hashable, Sendable {
                case uploaded = "uploaded"
                case processed = "processed"
                case error = "error"
            }
            /// Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/status`.
            @available(*, deprecated)
            public var status: Components.Schemas.OpenAIFile.statusPayload
            /// Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.
            ///
            /// - Remark: Generated from `#/components/schemas/OpenAIFile/status_details`.
            @available(*, deprecated)
            public var status_details: Swift.String?
            /// Creates a new `OpenAIFile`.
            ///
            /// - Parameters:
            ///   - id: The file identifier, which can be referenced in the API endpoints.
            ///   - bytes: The size of the file, in bytes.
            ///   - created_at: The Unix timestamp (in seconds) for when the file was created.
            ///   - filename: The name of the file.
            ///   - object: The object type, which is always `file`.
            ///   - purpose: The intended purpose of the file. Supported values are `fine-tune`, `fine-tune-results`, `assistants`, and `assistants_output`.
            ///   - status: Deprecated. The current status of the file, which can be either `uploaded`, `processed`, or `error`.
            ///   - status_details: Deprecated. For details on why a fine-tuning training file failed validation, see the `error` field on `fine_tuning.job`.
            public init(
                id: Swift.String,
                bytes: Swift.Int,
                created_at: Swift.Int,
                filename: Swift.String,
                object: Components.Schemas.OpenAIFile.objectPayload,
                purpose: Components.Schemas.OpenAIFile.purposePayload,
                status: Components.Schemas.OpenAIFile.statusPayload,
                status_details: Swift.String? = nil
            ) {
                self.id = id
                self.bytes = bytes
                self.created_at = created_at
                self.filename = filename
                self.object = object
                self.purpose = purpose
                self.status = status
                self.status_details = status_details
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case bytes
                case created_at
                case filename
                case object
                case purpose
                case status
                case status_details
            }
        }
        /// Represents an embedding vector returned by embedding endpoint.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/Embedding`.
        public struct Embedding: Codable, Hashable, Sendable {
            /// The index of the embedding in the list of embeddings.
            ///
            /// - Remark: Generated from `#/components/schemas/Embedding/index`.
            public var index: Swift.Int
            /// The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/Embedding/embedding`.
            public var embedding: [Swift.Double]
            /// The object type, which is always "embedding".
            ///
            /// - Remark: Generated from `#/components/schemas/Embedding/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case embedding = "embedding"
            }
            /// The object type, which is always "embedding".
            ///
            /// - Remark: Generated from `#/components/schemas/Embedding/object`.
            public var object: Components.Schemas.Embedding.objectPayload
            /// Creates a new `Embedding`.
            ///
            /// - Parameters:
            ///   - index: The index of the embedding in the list of embeddings.
            ///   - embedding: The embedding vector, which is a list of floats. The length of vector depends on the model as listed in the [embedding guide](/docs/guides/embeddings).
            ///   - object: The object type, which is always "embedding".
            public init(
                index: Swift.Int,
                embedding: [Swift.Double],
                object: Components.Schemas.Embedding.objectPayload
            ) {
                self.index = index
                self.embedding = embedding
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case index
                case embedding
                case object
            }
        }
        /// The `fine_tuning.job` object represents a fine-tuning job that has been created through the API.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/FineTuningJob`.
        public struct FineTuningJob: Codable, Hashable, Sendable {
            /// The object identifier, which can be referenced in the API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/id`.
            public var id: Swift.String
            /// The Unix timestamp (in seconds) for when the fine-tuning job was created.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/created_at`.
            public var created_at: Swift.Int
            /// For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/error`.
            public struct errorPayload: Codable, Hashable, Sendable {
                /// A machine-readable error code.
                ///
                /// - Remark: Generated from `#/components/schemas/FineTuningJob/error/code`.
                public var code: Swift.String
                /// A human-readable error message.
                ///
                /// - Remark: Generated from `#/components/schemas/FineTuningJob/error/message`.
                public var message: Swift.String
                /// The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.
                ///
                /// - Remark: Generated from `#/components/schemas/FineTuningJob/error/param`.
                public var param: Swift.String?
                /// Creates a new `errorPayload`.
                ///
                /// - Parameters:
                ///   - code: A machine-readable error code.
                ///   - message: A human-readable error message.
                ///   - param: The parameter that was invalid, usually `training_file` or `validation_file`. This field will be null if the failure was not parameter-specific.
                public init(
                    code: Swift.String,
                    message: Swift.String,
                    param: Swift.String? = nil
                ) {
                    self.code = code
                    self.message = message
                    self.param = param
                }
                public enum CodingKeys: String, CodingKey {
                    case code
                    case message
                    case param
                }
            }
            /// For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/error`.
            public var error: Components.Schemas.FineTuningJob.errorPayload?
            /// The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/fine_tuned_model`.
            public var fine_tuned_model: Swift.String?
            /// The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/finished_at`.
            public var finished_at: Swift.Int?
            /// The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters`.
            public struct hyperparametersPayload: Codable, Hashable, Sendable {
                /// The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
                /// "auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.
                ///
                /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters/n_epochs`.
                @frozen public enum n_epochsPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters/n_epochs/case1`.
                    @frozen public enum Case1Payload: String, Codable, Hashable, Sendable {
                        case auto = "auto"
                    }
                    /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters/n_epochs/case1`.
                    case case1(
                        Components.Schemas.FineTuningJob.hyperparametersPayload.n_epochsPayload
                            .Case1Payload)
                    /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters/n_epochs/case2`.
                    case case2(Swift.Int)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .case1(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .case2(try decoder.decodeFromSingleValueContainer())
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .case1(value):
                            try encoder.encodeToSingleValueContainer(value)
                        case let .case2(value):
                            try encoder.encodeToSingleValueContainer(value)
                        }
                    }
                }
                /// The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
                /// "auto" decides the optimal number of epochs based on the size of the dataset. If setting the number manually, we support any number between 1 and 50 epochs.
                ///
                /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters/n_epochs`.
                public var n_epochs:
                    Components.Schemas.FineTuningJob.hyperparametersPayload.n_epochsPayload
                /// Creates a new `hyperparametersPayload`.
                ///
                /// - Parameters:
                ///   - n_epochs: The number of epochs to train the model for. An epoch refers to one full cycle through the training dataset.
                public init(
                    n_epochs: Components.Schemas.FineTuningJob.hyperparametersPayload
                        .n_epochsPayload
                ) {
                    self.n_epochs = n_epochs
                }
                public enum CodingKeys: String, CodingKey {
                    case n_epochs
                }
            }
            /// The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/hyperparameters`.
            public var hyperparameters: Components.Schemas.FineTuningJob.hyperparametersPayload
            /// The base model that is being fine-tuned.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/model`.
            public var model: Swift.String
            /// The object type, which is always "fine_tuning.job".
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case fine_tuning_period_job = "fine_tuning.job"
            }
            /// The object type, which is always "fine_tuning.job".
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/object`.
            public var object: Components.Schemas.FineTuningJob.objectPayload
            /// The organization that owns the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/organization_id`.
            public var organization_id: Swift.String
            /// The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/result_files`.
            public var result_files: [Swift.String]
            /// The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/status`.
            @frozen public enum statusPayload: String, Codable, Hashable, Sendable {
                case validating_files = "validating_files"
                case queued = "queued"
                case running = "running"
                case succeeded = "succeeded"
                case failed = "failed"
                case cancelled = "cancelled"
            }
            /// The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/status`.
            public var status: Components.Schemas.FineTuningJob.statusPayload
            /// The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/trained_tokens`.
            public var trained_tokens: Swift.Int?
            /// The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/training_file`.
            public var training_file: Swift.String
            /// The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).
            ///
            /// - Remark: Generated from `#/components/schemas/FineTuningJob/validation_file`.
            public var validation_file: Swift.String?
            /// Creates a new `FineTuningJob`.
            ///
            /// - Parameters:
            ///   - id: The object identifier, which can be referenced in the API endpoints.
            ///   - created_at: The Unix timestamp (in seconds) for when the fine-tuning job was created.
            ///   - error: For fine-tuning jobs that have `failed`, this will contain more information on the cause of the failure.
            ///   - fine_tuned_model: The name of the fine-tuned model that is being created. The value will be null if the fine-tuning job is still running.
            ///   - finished_at: The Unix timestamp (in seconds) for when the fine-tuning job was finished. The value will be null if the fine-tuning job is still running.
            ///   - hyperparameters: The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/fine-tuning) for more details.
            ///   - model: The base model that is being fine-tuned.
            ///   - object: The object type, which is always "fine_tuning.job".
            ///   - organization_id: The organization that owns the fine-tuning job.
            ///   - result_files: The compiled results file ID(s) for the fine-tuning job. You can retrieve the results with the [Files API](/docs/api-reference/files/retrieve-contents).
            ///   - status: The current status of the fine-tuning job, which can be either `validating_files`, `queued`, `running`, `succeeded`, `failed`, or `cancelled`.
            ///   - trained_tokens: The total number of billable tokens processed by this fine-tuning job. The value will be null if the fine-tuning job is still running.
            ///   - training_file: The file ID used for training. You can retrieve the training data with the [Files API](/docs/api-reference/files/retrieve-contents).
            ///   - validation_file: The file ID used for validation. You can retrieve the validation results with the [Files API](/docs/api-reference/files/retrieve-contents).
            public init(
                id: Swift.String,
                created_at: Swift.Int,
                error: Components.Schemas.FineTuningJob.errorPayload? = nil,
                fine_tuned_model: Swift.String? = nil,
                finished_at: Swift.Int? = nil,
                hyperparameters: Components.Schemas.FineTuningJob.hyperparametersPayload,
                model: Swift.String,
                object: Components.Schemas.FineTuningJob.objectPayload,
                organization_id: Swift.String,
                result_files: [Swift.String],
                status: Components.Schemas.FineTuningJob.statusPayload,
                trained_tokens: Swift.Int? = nil,
                training_file: Swift.String,
                validation_file: Swift.String? = nil
            ) {
                self.id = id
                self.created_at = created_at
                self.error = error
                self.fine_tuned_model = fine_tuned_model
                self.finished_at = finished_at
                self.hyperparameters = hyperparameters
                self.model = model
                self.object = object
                self.organization_id = organization_id
                self.result_files = result_files
                self.status = status
                self.trained_tokens = trained_tokens
                self.training_file = training_file
                self.validation_file = validation_file
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case created_at
                case error
                case fine_tuned_model
                case finished_at
                case hyperparameters
                case model
                case object
                case organization_id
                case result_files
                case status
                case trained_tokens
                case training_file
                case validation_file
            }
        }
        /// Fine-tuning job event object
        ///
        /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent`.
        public struct FineTuningJobEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/created_at`.
            public var created_at: Swift.Int
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/level`.
            @frozen public enum levelPayload: String, Codable, Hashable, Sendable {
                case info = "info"
                case warn = "warn"
                case error = "error"
            }
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/level`.
            public var level: Components.Schemas.FineTuningJobEvent.levelPayload
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case fine_tuning_period_job_period_event = "fine_tuning.job.event"
            }
            /// - Remark: Generated from `#/components/schemas/FineTuningJobEvent/object`.
            public var object: Components.Schemas.FineTuningJobEvent.objectPayload
            /// Creates a new `FineTuningJobEvent`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - created_at:
            ///   - level:
            ///   - message:
            ///   - object:
            public init(
                id: Swift.String,
                created_at: Swift.Int,
                level: Components.Schemas.FineTuningJobEvent.levelPayload,
                message: Swift.String,
                object: Components.Schemas.FineTuningJobEvent.objectPayload
            ) {
                self.id = id
                self.created_at = created_at
                self.level = level
                self.message = message
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case created_at
                case level
                case message
                case object
            }
        }
        /// The `FineTune` object represents a legacy fine-tune job that has been created through the API.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/FineTune`.
        @available(*, deprecated)
        public struct FineTune: Codable, Hashable, Sendable {
            /// The object identifier, which can be referenced in the API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/id`.
            public var id: Swift.String
            /// The Unix timestamp (in seconds) for when the fine-tuning job was created.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/created_at`.
            public var created_at: Swift.Int
            /// The list of events that have been observed in the lifecycle of the FineTune job.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/events`.
            public var events: [Components.Schemas.FineTuneEvent]?
            /// The name of the fine-tuned model that is being created.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/fine_tuned_model`.
            public var fine_tuned_model: Swift.String?
            /// The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/hyperparameters) for more details.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams`.
            public struct hyperparamsPayload: Codable, Hashable, Sendable {
                /// The batch size to use for training. The batch size is the number of
                /// training examples used to train a single forward and backward pass.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/batch_size`.
                public var batch_size: Swift.Int
                /// The number of classes to use for computing classification metrics.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/classification_n_classes`.
                public var classification_n_classes: Swift.Int?
                /// The positive class to use for computing classification metrics.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/classification_positive_class`.
                public var classification_positive_class: Swift.String?
                /// The classification metrics to compute using the validation dataset at the end of every epoch.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/compute_classification_metrics`.
                public var compute_classification_metrics: Swift.Bool?
                /// The learning rate multiplier to use for training.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/learning_rate_multiplier`.
                public var learning_rate_multiplier: Swift.Double
                /// The number of epochs to train the model for. An epoch refers to one
                /// full cycle through the training dataset.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/n_epochs`.
                public var n_epochs: Swift.Int
                /// The weight to use for loss on the prompt tokens.
                ///
                ///
                /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams/prompt_loss_weight`.
                public var prompt_loss_weight: Swift.Double
                /// Creates a new `hyperparamsPayload`.
                ///
                /// - Parameters:
                ///   - batch_size: The batch size to use for training. The batch size is the number of
                ///   - classification_n_classes: The number of classes to use for computing classification metrics.
                ///   - classification_positive_class: The positive class to use for computing classification metrics.
                ///   - compute_classification_metrics: The classification metrics to compute using the validation dataset at the end of every epoch.
                ///   - learning_rate_multiplier: The learning rate multiplier to use for training.
                ///   - n_epochs: The number of epochs to train the model for. An epoch refers to one
                ///   - prompt_loss_weight: The weight to use for loss on the prompt tokens.
                public init(
                    batch_size: Swift.Int,
                    classification_n_classes: Swift.Int? = nil,
                    classification_positive_class: Swift.String? = nil,
                    compute_classification_metrics: Swift.Bool? = nil,
                    learning_rate_multiplier: Swift.Double,
                    n_epochs: Swift.Int,
                    prompt_loss_weight: Swift.Double
                ) {
                    self.batch_size = batch_size
                    self.classification_n_classes = classification_n_classes
                    self.classification_positive_class = classification_positive_class
                    self.compute_classification_metrics = compute_classification_metrics
                    self.learning_rate_multiplier = learning_rate_multiplier
                    self.n_epochs = n_epochs
                    self.prompt_loss_weight = prompt_loss_weight
                }
                public enum CodingKeys: String, CodingKey {
                    case batch_size
                    case classification_n_classes
                    case classification_positive_class
                    case compute_classification_metrics
                    case learning_rate_multiplier
                    case n_epochs
                    case prompt_loss_weight
                }
            }
            /// The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/hyperparameters) for more details.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/hyperparams`.
            public var hyperparams: Components.Schemas.FineTune.hyperparamsPayload
            /// The base model that is being fine-tuned.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/model`.
            public var model: Swift.String
            /// The object type, which is always "fine-tune".
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case fine_hyphen_tune = "fine-tune"
            }
            /// The object type, which is always "fine-tune".
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/object`.
            public var object: Components.Schemas.FineTune.objectPayload
            /// The organization that owns the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/organization_id`.
            public var organization_id: Swift.String
            /// The compiled results files for the fine-tuning job.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/result_files`.
            public var result_files: [Components.Schemas.OpenAIFile]
            /// The current status of the fine-tuning job, which can be either `created`, `running`, `succeeded`, `failed`, or `cancelled`.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/status`.
            public var status: Swift.String
            /// The list of files used for training.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/training_files`.
            public var training_files: [Components.Schemas.OpenAIFile]
            /// The Unix timestamp (in seconds) for when the fine-tuning job was last updated.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/updated_at`.
            public var updated_at: Swift.Int
            /// The list of files used for validation.
            ///
            /// - Remark: Generated from `#/components/schemas/FineTune/validation_files`.
            public var validation_files: [Components.Schemas.OpenAIFile]
            /// Creates a new `FineTune`.
            ///
            /// - Parameters:
            ///   - id: The object identifier, which can be referenced in the API endpoints.
            ///   - created_at: The Unix timestamp (in seconds) for when the fine-tuning job was created.
            ///   - events: The list of events that have been observed in the lifecycle of the FineTune job.
            ///   - fine_tuned_model: The name of the fine-tuned model that is being created.
            ///   - hyperparams: The hyperparameters used for the fine-tuning job. See the [fine-tuning guide](/docs/guides/legacy-fine-tuning/hyperparameters) for more details.
            ///   - model: The base model that is being fine-tuned.
            ///   - object: The object type, which is always "fine-tune".
            ///   - organization_id: The organization that owns the fine-tuning job.
            ///   - result_files: The compiled results files for the fine-tuning job.
            ///   - status: The current status of the fine-tuning job, which can be either `created`, `running`, `succeeded`, `failed`, or `cancelled`.
            ///   - training_files: The list of files used for training.
            ///   - updated_at: The Unix timestamp (in seconds) for when the fine-tuning job was last updated.
            ///   - validation_files: The list of files used for validation.
            public init(
                id: Swift.String,
                created_at: Swift.Int,
                events: [Components.Schemas.FineTuneEvent]? = nil,
                fine_tuned_model: Swift.String? = nil,
                hyperparams: Components.Schemas.FineTune.hyperparamsPayload,
                model: Swift.String,
                object: Components.Schemas.FineTune.objectPayload,
                organization_id: Swift.String,
                result_files: [Components.Schemas.OpenAIFile],
                status: Swift.String,
                training_files: [Components.Schemas.OpenAIFile],
                updated_at: Swift.Int,
                validation_files: [Components.Schemas.OpenAIFile]
            ) {
                self.id = id
                self.created_at = created_at
                self.events = events
                self.fine_tuned_model = fine_tuned_model
                self.hyperparams = hyperparams
                self.model = model
                self.object = object
                self.organization_id = organization_id
                self.result_files = result_files
                self.status = status
                self.training_files = training_files
                self.updated_at = updated_at
                self.validation_files = validation_files
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case created_at
                case events
                case fine_tuned_model
                case hyperparams
                case model
                case object
                case organization_id
                case result_files
                case status
                case training_files
                case updated_at
                case validation_files
            }
        }
        /// Fine-tune event object
        ///
        /// - Remark: Generated from `#/components/schemas/FineTuneEvent`.
        @available(*, deprecated)
        public struct FineTuneEvent: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/FineTuneEvent/created_at`.
            public var created_at: Swift.Int
            /// - Remark: Generated from `#/components/schemas/FineTuneEvent/level`.
            public var level: Swift.String
            /// - Remark: Generated from `#/components/schemas/FineTuneEvent/message`.
            public var message: Swift.String
            /// - Remark: Generated from `#/components/schemas/FineTuneEvent/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case fine_hyphen_tune_hyphen_event = "fine-tune-event"
            }
            /// - Remark: Generated from `#/components/schemas/FineTuneEvent/object`.
            public var object: Components.Schemas.FineTuneEvent.objectPayload
            /// Creates a new `FineTuneEvent`.
            ///
            /// - Parameters:
            ///   - created_at:
            ///   - level:
            ///   - message:
            ///   - object:
            public init(
                created_at: Swift.Int,
                level: Swift.String,
                message: Swift.String,
                object: Components.Schemas.FineTuneEvent.objectPayload
            ) {
                self.created_at = created_at
                self.level = level
                self.message = message
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case created_at
                case level
                case message
                case object
            }
        }
        /// Usage statistics for the completion request.
        ///
        /// - Remark: Generated from `#/components/schemas/CompletionUsage`.
        public struct CompletionUsage: Codable, Hashable, Sendable {
            /// Number of tokens in the generated completion.
            ///
            /// - Remark: Generated from `#/components/schemas/CompletionUsage/completion_tokens`.
            public var completion_tokens: Swift.Int
            /// Number of tokens in the prompt.
            ///
            /// - Remark: Generated from `#/components/schemas/CompletionUsage/prompt_tokens`.
            public var prompt_tokens: Swift.Int
            /// Total number of tokens used in the request (prompt + completion).
            ///
            /// - Remark: Generated from `#/components/schemas/CompletionUsage/total_tokens`.
            public var total_tokens: Swift.Int
            /// Creates a new `CompletionUsage`.
            ///
            /// - Parameters:
            ///   - completion_tokens: Number of tokens in the generated completion.
            ///   - prompt_tokens: Number of tokens in the prompt.
            ///   - total_tokens: Total number of tokens used in the request (prompt + completion).
            public init(
                completion_tokens: Swift.Int,
                prompt_tokens: Swift.Int,
                total_tokens: Swift.Int
            ) {
                self.completion_tokens = completion_tokens
                self.prompt_tokens = prompt_tokens
                self.total_tokens = total_tokens
            }
            public enum CodingKeys: String, CodingKey {
                case completion_tokens
                case prompt_tokens
                case total_tokens
            }
        }
        /// Represents an `assistant` that can call the model and use tools.
        ///
        /// - Remark: Generated from `#/components/schemas/AssistantObject`.
        public struct AssistantObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/id`.
            public var id: Swift.String
            /// The object type, which is always `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case assistant = "assistant"
            }
            /// The object type, which is always `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/object`.
            public var object: Components.Schemas.AssistantObject.objectPayload
            /// The Unix timestamp (in seconds) for when the assistant was created.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/created_at`.
            public var created_at: Swift.Int
            /// The name of the assistant. The maximum length is 256 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/name`.
            public var name: Swift.String?
            /// The description of the assistant. The maximum length is 512 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/description`.
            public var description: Swift.String?
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/model`.
            public var model: Swift.String
            /// The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/instructions`.
            public var instructions: Swift.String?
            /// - Remark: Generated from `#/components/schemas/AssistantObject/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/AssistantObject/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/AssistantObject/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/AssistantObject/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/tools`.
            public typealias toolsPayload = [Components.Schemas.AssistantObject.toolsPayloadPayload]
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/tools`.
            public var tools: Components.Schemas.AssistantObject.toolsPayload
            /// A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/file_ids`.
            public var file_ids: [Swift.String]
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantObject/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `AssistantObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `assistant`.
            ///   - created_at: The Unix timestamp (in seconds) for when the assistant was created.
            ///   - name: The name of the assistant. The maximum length is 256 characters.
            ///   - description: The description of the assistant. The maximum length is 512 characters.
            ///   - model: ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///   - instructions: The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///   - tools: A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///   - file_ids: A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                id: Swift.String,
                object: Components.Schemas.AssistantObject.objectPayload,
                created_at: Swift.Int,
                name: Swift.String? = nil,
                description: Swift.String? = nil,
                model: Swift.String,
                instructions: Swift.String? = nil,
                tools: Components.Schemas.AssistantObject.toolsPayload,
                file_ids: [Swift.String],
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.name = name
                self.description = description
                self.model = model
                self.instructions = instructions
                self.tools = tools
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case name
                case description
                case model
                case instructions
                case tools
                case file_ids
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest`.
        public struct CreateAssistantRequest: Codable, Hashable, Sendable {
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/model/value1`.
                public var value1: Swift.String?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                public init(value1: Swift.String? = nil) {
                    self.value1 = value1
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1
                    ])
                }
            }
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/model`.
            public var model: Components.Schemas.CreateAssistantRequest.modelPayload
            /// The name of the assistant. The maximum length is 256 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/name`.
            public var name: Swift.String?
            /// The description of the assistant. The maximum length is 512 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/description`.
            public var description: Swift.String?
            /// The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/instructions`.
            public var instructions: Swift.String?
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/tools`.
            public typealias toolsPayload = [Components.Schemas.CreateAssistantRequest
                .toolsPayloadPayload]
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/tools`.
            public var tools: Components.Schemas.CreateAssistantRequest.toolsPayload?
            /// A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/file_ids`.
            public var file_ids: [Swift.String]?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `CreateAssistantRequest`.
            ///
            /// - Parameters:
            ///   - model: ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///   - name: The name of the assistant. The maximum length is 256 characters.
            ///   - description: The description of the assistant. The maximum length is 512 characters.
            ///   - instructions: The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///   - tools: A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///   - file_ids: A list of [file](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                model: Components.Schemas.CreateAssistantRequest.modelPayload,
                name: Swift.String? = nil,
                description: Swift.String? = nil,
                instructions: Swift.String? = nil,
                tools: Components.Schemas.CreateAssistantRequest.toolsPayload? = nil,
                file_ids: [Swift.String]? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.model = model
                self.name = name
                self.description = description
                self.instructions = instructions
                self.tools = tools
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case model
                case name
                case description
                case instructions
                case tools
                case file_ids
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                model = try container.decode(
                    Components.Schemas.CreateAssistantRequest.modelPayload.self,
                    forKey: .model
                )
                name = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .name
                )
                description = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .description
                )
                instructions = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .instructions
                )
                tools = try container.decodeIfPresent(
                    Components.Schemas.CreateAssistantRequest.toolsPayload.self,
                    forKey: .tools
                )
                file_ids = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .file_ids
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "model",
                    "name",
                    "description",
                    "instructions",
                    "tools",
                    "file_ids",
                    "metadata",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest`.
        public struct ModifyAssistantRequest: Codable, Hashable, Sendable {
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/model`.
            public struct modelPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/model/value1`.
                public var value1: Swift.String?
                /// Creates a new `modelPayload`.
                ///
                /// - Parameters:
                ///   - value1:
                public init(value1: Swift.String? = nil) {
                    self.value1 = value1
                }
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        value1 = try decoder.decodeFromSingleValueContainer()
                    } catch {
                        errors.append(error)
                    }
                    try Swift.DecodingError.verifyAtLeastOneSchemaIsNotNil(
                        [
                            value1
                        ],
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    try encoder.encodeFirstNonNilValueToSingleValueContainer([
                        value1
                    ])
                }
            }
            /// ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/model`.
            public var model: Components.Schemas.ModifyAssistantRequest.modelPayload?
            /// The name of the assistant. The maximum length is 256 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/name`.
            public var name: Swift.String?
            /// The description of the assistant. The maximum length is 512 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/description`.
            public var description: Swift.String?
            /// The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/instructions`.
            public var instructions: Swift.String?
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/tools`.
            public typealias toolsPayload = [Components.Schemas.ModifyAssistantRequest
                .toolsPayloadPayload]
            /// A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/tools`.
            public var tools: Components.Schemas.ModifyAssistantRequest.toolsPayload?
            /// A list of [File](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order. If a file was previosuly attached to the list but does not show up in the list, it will be deleted from the assistant.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/file_ids`.
            public var file_ids: [Swift.String]?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyAssistantRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `ModifyAssistantRequest`.
            ///
            /// - Parameters:
            ///   - model: ID of the model to use. You can use the [List models](/docs/api-reference/models/list) API to see all of your available models, or see our [Model overview](/docs/models/overview) for descriptions of them.
            ///   - name: The name of the assistant. The maximum length is 256 characters.
            ///   - description: The description of the assistant. The maximum length is 512 characters.
            ///   - instructions: The system instructions that the assistant uses. The maximum length is 32768 characters.
            ///   - tools: A list of tool enabled on the assistant. There can be a maximum of 128 tools per assistant. Tools can be of types `code_interpreter`, `retrieval`, or `function`.
            ///   - file_ids: A list of [File](/docs/api-reference/files) IDs attached to this assistant. There can be a maximum of 20 files attached to the assistant. Files are ordered by their creation date in ascending order. If a file was previosuly attached to the list but does not show up in the list, it will be deleted from the assistant.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                model: Components.Schemas.ModifyAssistantRequest.modelPayload? = nil,
                name: Swift.String? = nil,
                description: Swift.String? = nil,
                instructions: Swift.String? = nil,
                tools: Components.Schemas.ModifyAssistantRequest.toolsPayload? = nil,
                file_ids: [Swift.String]? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.model = model
                self.name = name
                self.description = description
                self.instructions = instructions
                self.tools = tools
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case model
                case name
                case description
                case instructions
                case tools
                case file_ids
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                model = try container.decodeIfPresent(
                    Components.Schemas.ModifyAssistantRequest.modelPayload.self,
                    forKey: .model
                )
                name = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .name
                )
                description = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .description
                )
                instructions = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .instructions
                )
                tools = try container.decodeIfPresent(
                    Components.Schemas.ModifyAssistantRequest.toolsPayload.self,
                    forKey: .tools
                )
                file_ids = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .file_ids
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "model",
                    "name",
                    "description",
                    "instructions",
                    "tools",
                    "file_ids",
                    "metadata",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/DeleteAssistantResponse`.
        public struct DeleteAssistantResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantResponse/deleted`.
            public var deleted: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case assistant_period_deleted = "assistant.deleted"
            }
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantResponse/object`.
            public var object: Components.Schemas.DeleteAssistantResponse.objectPayload
            /// Creates a new `DeleteAssistantResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - deleted:
            ///   - object:
            public init(
                id: Swift.String,
                deleted: Swift.Bool,
                object: Components.Schemas.DeleteAssistantResponse.objectPayload
            ) {
                self.id = id
                self.deleted = deleted
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case deleted
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse`.
        public struct ListAssistantsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse/data`.
            public var data: [Components.Schemas.AssistantObject]
            /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantsResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListAssistantsResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.AssistantObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// - Remark: Generated from `#/components/schemas/AssistantToolsCode`.
        public struct AssistantToolsCode: Codable, Hashable, Sendable {
            /// The type of tool being defined: `code_interpreter`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsCode/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case code_interpreter = "code_interpreter"
            }
            /// The type of tool being defined: `code_interpreter`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsCode/type`.
            public var _type: Components.Schemas.AssistantToolsCode._typePayload
            /// Creates a new `AssistantToolsCode`.
            ///
            /// - Parameters:
            ///   - _type: The type of tool being defined: `code_interpreter`
            public init(_type: Components.Schemas.AssistantToolsCode._typePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// - Remark: Generated from `#/components/schemas/AssistantToolsRetrieval`.
        public struct AssistantToolsRetrieval: Codable, Hashable, Sendable {
            /// The type of tool being defined: `retrieval`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsRetrieval/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case retrieval = "retrieval"
            }
            /// The type of tool being defined: `retrieval`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsRetrieval/type`.
            public var _type: Components.Schemas.AssistantToolsRetrieval._typePayload
            /// Creates a new `AssistantToolsRetrieval`.
            ///
            /// - Parameters:
            ///   - _type: The type of tool being defined: `retrieval`
            public init(_type: Components.Schemas.AssistantToolsRetrieval._typePayload) {
                self._type = _type
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
            }
        }
        /// - Remark: Generated from `#/components/schemas/AssistantToolsFunction`.
        public struct AssistantToolsFunction: Codable, Hashable, Sendable {
            /// The type of tool being defined: `function`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsFunction/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of tool being defined: `function`
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantToolsFunction/type`.
            public var _type: Components.Schemas.AssistantToolsFunction._typePayload
            /// - Remark: Generated from `#/components/schemas/AssistantToolsFunction/function`.
            public var function: Components.Schemas.FunctionObject
            /// Creates a new `AssistantToolsFunction`.
            ///
            /// - Parameters:
            ///   - _type: The type of tool being defined: `function`
            ///   - function:
            public init(
                _type: Components.Schemas.AssistantToolsFunction._typePayload,
                function: Components.Schemas.FunctionObject
            ) {
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case function
            }
        }
        /// Represents an execution run on a [thread](/docs/api-reference/threads).
        ///
        /// - Remark: Generated from `#/components/schemas/RunObject`.
        public struct RunObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/id`.
            public var id: Swift.String
            /// The object type, which is always `thread.run`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_run = "thread.run"
            }
            /// The object type, which is always `thread.run`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/object`.
            public var object: Components.Schemas.RunObject.objectPayload
            /// The Unix timestamp (in seconds) for when the run was created.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/created_at`.
            public var created_at: Swift.Int
            /// The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/thread_id`.
            public var thread_id: Swift.String
            /// The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/assistant_id`.
            public var assistant_id: Swift.String
            /// The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/status`.
            @frozen public enum statusPayload: String, Codable, Hashable, Sendable {
                case queued = "queued"
                case in_progress = "in_progress"
                case requires_action = "requires_action"
                case cancelling = "cancelling"
                case cancelled = "cancelled"
                case failed = "failed"
                case completed = "completed"
                case expired = "expired"
            }
            /// The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/status`.
            public var status: Components.Schemas.RunObject.statusPayload
            /// Details on the action required to continue the run. Will be `null` if no action is required.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/required_action`.
            public struct required_actionPayload: Codable, Hashable, Sendable {
                /// For now, this is always `submit_tool_outputs`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/required_action/type`.
                @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                    case submit_tool_outputs = "submit_tool_outputs"
                }
                /// For now, this is always `submit_tool_outputs`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/required_action/type`.
                public var _type: Components.Schemas.RunObject.required_actionPayload._typePayload
                /// Details on the tool outputs needed for this run to continue.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/required_action/submit_tool_outputs`.
                public struct submit_tool_outputsPayload: Codable, Hashable, Sendable {
                    /// A list of the relevant tool calls.
                    ///
                    /// - Remark: Generated from `#/components/schemas/RunObject/required_action/submit_tool_outputs/tool_calls`.
                    public var tool_calls: [Components.Schemas.RunToolCallObject]
                    /// Creates a new `submit_tool_outputsPayload`.
                    ///
                    /// - Parameters:
                    ///   - tool_calls: A list of the relevant tool calls.
                    public init(tool_calls: [Components.Schemas.RunToolCallObject]) {
                        self.tool_calls = tool_calls
                    }
                    public enum CodingKeys: String, CodingKey {
                        case tool_calls
                    }
                }
                /// Details on the tool outputs needed for this run to continue.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/required_action/submit_tool_outputs`.
                public var submit_tool_outputs:
                    Components.Schemas.RunObject.required_actionPayload.submit_tool_outputsPayload
                /// Creates a new `required_actionPayload`.
                ///
                /// - Parameters:
                ///   - _type: For now, this is always `submit_tool_outputs`.
                ///   - submit_tool_outputs: Details on the tool outputs needed for this run to continue.
                public init(
                    _type: Components.Schemas.RunObject.required_actionPayload._typePayload,
                    submit_tool_outputs: Components.Schemas.RunObject.required_actionPayload
                        .submit_tool_outputsPayload
                ) {
                    self._type = _type
                    self.submit_tool_outputs = submit_tool_outputs
                }
                public enum CodingKeys: String, CodingKey {
                    case _type = "type"
                    case submit_tool_outputs
                }
            }
            /// Details on the action required to continue the run. Will be `null` if no action is required.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/required_action`.
            public var required_action: Components.Schemas.RunObject.required_actionPayload?
            /// The last error associated with this run. Will be `null` if there are no errors.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/last_error`.
            public struct last_errorPayload: Codable, Hashable, Sendable {
                /// One of `server_error` or `rate_limit_exceeded`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/last_error/code`.
                @frozen public enum codePayload: String, Codable, Hashable, Sendable {
                    case server_error = "server_error"
                    case rate_limit_exceeded = "rate_limit_exceeded"
                }
                /// One of `server_error` or `rate_limit_exceeded`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/last_error/code`.
                public var code: Components.Schemas.RunObject.last_errorPayload.codePayload
                /// A human-readable description of the error.
                ///
                /// - Remark: Generated from `#/components/schemas/RunObject/last_error/message`.
                public var message: Swift.String
                /// Creates a new `last_errorPayload`.
                ///
                /// - Parameters:
                ///   - code: One of `server_error` or `rate_limit_exceeded`.
                ///   - message: A human-readable description of the error.
                public init(
                    code: Components.Schemas.RunObject.last_errorPayload.codePayload,
                    message: Swift.String
                ) {
                    self.code = code
                    self.message = message
                }
                public enum CodingKeys: String, CodingKey {
                    case code
                    case message
                }
            }
            /// The last error associated with this run. Will be `null` if there are no errors.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/last_error`.
            public var last_error: Components.Schemas.RunObject.last_errorPayload?
            /// The Unix timestamp (in seconds) for when the run will expire.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/expires_at`.
            public var expires_at: Swift.Int
            /// The Unix timestamp (in seconds) for when the run was started.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/started_at`.
            public var started_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run was cancelled.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/cancelled_at`.
            public var cancelled_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run failed.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/failed_at`.
            public var failed_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run was completed.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/completed_at`.
            public var completed_at: Swift.Int?
            /// The model that the [assistant](/docs/api-reference/assistants) used for this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/model`.
            public var model: Swift.String
            /// The instructions that the [assistant](/docs/api-reference/assistants) used for this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/instructions`.
            public var instructions: Swift.String
            /// - Remark: Generated from `#/components/schemas/RunObject/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/RunObject/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/RunObject/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/RunObject/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/tools`.
            public typealias toolsPayload = [Components.Schemas.RunObject.toolsPayloadPayload]
            /// The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/tools`.
            public var tools: Components.Schemas.RunObject.toolsPayload
            /// The list of [File](/docs/api-reference/files) IDs the [assistant](/docs/api-reference/assistants) used for this run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/file_ids`.
            public var file_ids: [Swift.String]
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/RunObject/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `RunObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `thread.run`.
            ///   - created_at: The Unix timestamp (in seconds) for when the run was created.
            ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) that was executed on as a part of this run.
            ///   - assistant_id: The ID of the [assistant](/docs/api-reference/assistants) used for execution of this run.
            ///   - status: The status of the run, which can be either `queued`, `in_progress`, `requires_action`, `cancelling`, `cancelled`, `failed`, `completed`, or `expired`.
            ///   - required_action: Details on the action required to continue the run. Will be `null` if no action is required.
            ///   - last_error: The last error associated with this run. Will be `null` if there are no errors.
            ///   - expires_at: The Unix timestamp (in seconds) for when the run will expire.
            ///   - started_at: The Unix timestamp (in seconds) for when the run was started.
            ///   - cancelled_at: The Unix timestamp (in seconds) for when the run was cancelled.
            ///   - failed_at: The Unix timestamp (in seconds) for when the run failed.
            ///   - completed_at: The Unix timestamp (in seconds) for when the run was completed.
            ///   - model: The model that the [assistant](/docs/api-reference/assistants) used for this run.
            ///   - instructions: The instructions that the [assistant](/docs/api-reference/assistants) used for this run.
            ///   - tools: The list of tools that the [assistant](/docs/api-reference/assistants) used for this run.
            ///   - file_ids: The list of [File](/docs/api-reference/files) IDs the [assistant](/docs/api-reference/assistants) used for this run.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                id: Swift.String,
                object: Components.Schemas.RunObject.objectPayload,
                created_at: Swift.Int,
                thread_id: Swift.String,
                assistant_id: Swift.String,
                status: Components.Schemas.RunObject.statusPayload,
                required_action: Components.Schemas.RunObject.required_actionPayload? = nil,
                last_error: Components.Schemas.RunObject.last_errorPayload? = nil,
                expires_at: Swift.Int,
                started_at: Swift.Int? = nil,
                cancelled_at: Swift.Int? = nil,
                failed_at: Swift.Int? = nil,
                completed_at: Swift.Int? = nil,
                model: Swift.String,
                instructions: Swift.String,
                tools: Components.Schemas.RunObject.toolsPayload,
                file_ids: [Swift.String],
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.thread_id = thread_id
                self.assistant_id = assistant_id
                self.status = status
                self.required_action = required_action
                self.last_error = last_error
                self.expires_at = expires_at
                self.started_at = started_at
                self.cancelled_at = cancelled_at
                self.failed_at = failed_at
                self.completed_at = completed_at
                self.model = model
                self.instructions = instructions
                self.tools = tools
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case thread_id
                case assistant_id
                case status
                case required_action
                case last_error
                case expires_at
                case started_at
                case cancelled_at
                case failed_at
                case completed_at
                case model
                case instructions
                case tools
                case file_ids
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateRunRequest`.
        public struct CreateRunRequest: Codable, Hashable, Sendable {
            /// The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/assistant_id`.
            public var assistant_id: Swift.String
            /// The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/model`.
            public var model: Swift.String?
            /// Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/instructions`.
            public var instructions: Swift.String?
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateRunRequest/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/CreateRunRequest/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/CreateRunRequest/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/tools`.
            public typealias toolsPayload = [Components.Schemas.CreateRunRequest
                .toolsPayloadPayload]
            /// Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/tools`.
            public var tools: Components.Schemas.CreateRunRequest.toolsPayload?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateRunRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `CreateRunRequest`.
            ///
            /// - Parameters:
            ///   - assistant_id: The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
            ///   - model: The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
            ///   - instructions: Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
            ///   - tools: Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                assistant_id: Swift.String,
                model: Swift.String? = nil,
                instructions: Swift.String? = nil,
                tools: Components.Schemas.CreateRunRequest.toolsPayload? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.assistant_id = assistant_id
                self.model = model
                self.instructions = instructions
                self.tools = tools
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case assistant_id
                case model
                case instructions
                case tools
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                assistant_id = try container.decode(
                    Swift.String.self,
                    forKey: .assistant_id
                )
                model = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .model
                )
                instructions = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .instructions
                )
                tools = try container.decodeIfPresent(
                    Components.Schemas.CreateRunRequest.toolsPayload.self,
                    forKey: .tools
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "assistant_id",
                    "model",
                    "instructions",
                    "tools",
                    "metadata",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListRunsResponse`.
        public struct ListRunsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListRunsResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunsResponse/data`.
            public var data: [Components.Schemas.RunObject]
            /// - Remark: Generated from `#/components/schemas/ListRunsResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunsResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunsResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListRunsResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.RunObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// - Remark: Generated from `#/components/schemas/ModifyRunRequest`.
        public struct ModifyRunRequest: Codable, Hashable, Sendable {
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyRunRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `ModifyRunRequest`.
            ///
            /// - Parameters:
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil) {
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "metadata"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest`.
        public struct SubmitToolOutputsRunRequest: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest/tool_outputsPayload`.
            public struct tool_outputsPayloadPayload: Codable, Hashable, Sendable {
                /// The ID of the tool call in the `required_action` object within the run object the output is being submitted for.
                ///
                /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest/tool_outputsPayload/tool_call_id`.
                public var tool_call_id: Swift.String?
                /// The output of the tool call to be submitted to continue the run.
                ///
                /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest/tool_outputsPayload/output`.
                public var output: Swift.String?
                /// Creates a new `tool_outputsPayloadPayload`.
                ///
                /// - Parameters:
                ///   - tool_call_id: The ID of the tool call in the `required_action` object within the run object the output is being submitted for.
                ///   - output: The output of the tool call to be submitted to continue the run.
                public init(
                    tool_call_id: Swift.String? = nil,
                    output: Swift.String? = nil
                ) {
                    self.tool_call_id = tool_call_id
                    self.output = output
                }
                public enum CodingKeys: String, CodingKey {
                    case tool_call_id
                    case output
                }
            }
            /// A list of tools for which the outputs are being submitted.
            ///
            /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest/tool_outputs`.
            public typealias tool_outputsPayload = [Components.Schemas.SubmitToolOutputsRunRequest
                .tool_outputsPayloadPayload]
            /// A list of tools for which the outputs are being submitted.
            ///
            /// - Remark: Generated from `#/components/schemas/SubmitToolOutputsRunRequest/tool_outputs`.
            public var tool_outputs:
                Components.Schemas.SubmitToolOutputsRunRequest.tool_outputsPayload
            /// Creates a new `SubmitToolOutputsRunRequest`.
            ///
            /// - Parameters:
            ///   - tool_outputs: A list of tools for which the outputs are being submitted.
            public init(
                tool_outputs: Components.Schemas.SubmitToolOutputsRunRequest.tool_outputsPayload
            ) {
                self.tool_outputs = tool_outputs
            }
            public enum CodingKeys: String, CodingKey {
                case tool_outputs
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                tool_outputs = try container.decode(
                    Components.Schemas.SubmitToolOutputsRunRequest.tool_outputsPayload.self,
                    forKey: .tool_outputs
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "tool_outputs"
                ])
            }
        }
        /// Tool call objects
        ///
        /// - Remark: Generated from `#/components/schemas/RunToolCallObject`.
        public struct RunToolCallObject: Codable, Hashable, Sendable {
            /// The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.
            ///
            /// - Remark: Generated from `#/components/schemas/RunToolCallObject/id`.
            public var id: Swift.String
            /// The type of tool call the output is required for. For now, this is always `function`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunToolCallObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of tool call the output is required for. For now, this is always `function`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunToolCallObject/type`.
            public var _type: Components.Schemas.RunToolCallObject._typePayload
            /// The function definition.
            ///
            /// - Remark: Generated from `#/components/schemas/RunToolCallObject/function`.
            public struct functionPayload: Codable, Hashable, Sendable {
                /// The name of the function.
                ///
                /// - Remark: Generated from `#/components/schemas/RunToolCallObject/function/name`.
                public var name: Swift.String
                /// The arguments that the model expects you to pass to the function.
                ///
                /// - Remark: Generated from `#/components/schemas/RunToolCallObject/function/arguments`.
                public var arguments: Swift.String
                /// Creates a new `functionPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the function.
                ///   - arguments: The arguments that the model expects you to pass to the function.
                public init(
                    name: Swift.String,
                    arguments: Swift.String
                ) {
                    self.name = name
                    self.arguments = arguments
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case arguments
                }
            }
            /// The function definition.
            ///
            /// - Remark: Generated from `#/components/schemas/RunToolCallObject/function`.
            public var function: Components.Schemas.RunToolCallObject.functionPayload
            /// Creates a new `RunToolCallObject`.
            ///
            /// - Parameters:
            ///   - id: The ID of the tool call. This ID must be referenced when you submit the tool outputs in using the [Submit tool outputs to run](/docs/api-reference/runs/submitToolOutputs) endpoint.
            ///   - _type: The type of tool call the output is required for. For now, this is always `function`.
            ///   - function: The function definition.
            public init(
                id: Swift.String,
                _type: Components.Schemas.RunToolCallObject._typePayload,
                function: Components.Schemas.RunToolCallObject.functionPayload
            ) {
                self.id = id
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case function
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest`.
        public struct CreateThreadAndRunRequest: Codable, Hashable, Sendable {
            /// The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/assistant_id`.
            public var assistant_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/thread`.
            public var thread: Components.Schemas.CreateThreadRequest?
            /// The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/model`.
            public var model: Swift.String?
            /// Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/instructions`.
            public var instructions: Swift.String?
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/toolsPayload`.
            @frozen public enum toolsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/toolsPayload/case1`.
                case AssistantToolsCode(Components.Schemas.AssistantToolsCode)
                /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/toolsPayload/case2`.
                case AssistantToolsRetrieval(Components.Schemas.AssistantToolsRetrieval)
                /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/toolsPayload/case3`.
                case AssistantToolsFunction(Components.Schemas.AssistantToolsFunction)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .AssistantToolsCode(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsRetrieval(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .AssistantToolsFunction(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .AssistantToolsCode(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsRetrieval(value):
                        try value.encode(to: encoder)
                    case let .AssistantToolsFunction(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/tools`.
            public typealias toolsPayload = [Components.Schemas.CreateThreadAndRunRequest
                .toolsPayloadPayload]
            /// Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/tools`.
            public var tools: Components.Schemas.CreateThreadAndRunRequest.toolsPayload?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadAndRunRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `CreateThreadAndRunRequest`.
            ///
            /// - Parameters:
            ///   - assistant_id: The ID of the [assistant](/docs/api-reference/assistants) to use to execute this run.
            ///   - thread:
            ///   - model: The ID of the [Model](/docs/api-reference/models) to be used to execute this run. If a value is provided here, it will override the model associated with the assistant. If not, the model associated with the assistant will be used.
            ///   - instructions: Override the default system message of the assistant. This is useful for modifying the behavior on a per-run basis.
            ///   - tools: Override the tools the assistant can use for this run. This is useful for modifying the behavior on a per-run basis.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                assistant_id: Swift.String,
                thread: Components.Schemas.CreateThreadRequest? = nil,
                model: Swift.String? = nil,
                instructions: Swift.String? = nil,
                tools: Components.Schemas.CreateThreadAndRunRequest.toolsPayload? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.assistant_id = assistant_id
                self.thread = thread
                self.model = model
                self.instructions = instructions
                self.tools = tools
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case assistant_id
                case thread
                case model
                case instructions
                case tools
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                assistant_id = try container.decode(
                    Swift.String.self,
                    forKey: .assistant_id
                )
                thread = try container.decodeIfPresent(
                    Components.Schemas.CreateThreadRequest.self,
                    forKey: .thread
                )
                model = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .model
                )
                instructions = try container.decodeIfPresent(
                    Swift.String.self,
                    forKey: .instructions
                )
                tools = try container.decodeIfPresent(
                    Components.Schemas.CreateThreadAndRunRequest.toolsPayload.self,
                    forKey: .tools
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "assistant_id",
                    "thread",
                    "model",
                    "instructions",
                    "tools",
                    "metadata",
                ])
            }
        }
        /// Represents a thread that contains [messages](/docs/api-reference/messages).
        ///
        /// - Remark: Generated from `#/components/schemas/ThreadObject`.
        public struct ThreadObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/ThreadObject/id`.
            public var id: Swift.String
            /// The object type, which is always `thread`.
            ///
            /// - Remark: Generated from `#/components/schemas/ThreadObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread = "thread"
            }
            /// The object type, which is always `thread`.
            ///
            /// - Remark: Generated from `#/components/schemas/ThreadObject/object`.
            public var object: Components.Schemas.ThreadObject.objectPayload
            /// The Unix timestamp (in seconds) for when the thread was created.
            ///
            /// - Remark: Generated from `#/components/schemas/ThreadObject/created_at`.
            public var created_at: Swift.Int
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ThreadObject/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `ThreadObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `thread`.
            ///   - created_at: The Unix timestamp (in seconds) for when the thread was created.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                id: Swift.String,
                object: Components.Schemas.ThreadObject.objectPayload,
                created_at: Swift.Int,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateThreadRequest`.
        public struct CreateThreadRequest: Codable, Hashable, Sendable {
            /// A list of [messages](/docs/api-reference/messages) to start the thread with.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadRequest/messages`.
            public var messages: [Components.Schemas.CreateMessageRequest]?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateThreadRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `CreateThreadRequest`.
            ///
            /// - Parameters:
            ///   - messages: A list of [messages](/docs/api-reference/messages) to start the thread with.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                messages: [Components.Schemas.CreateMessageRequest]? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.messages = messages
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case messages
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                messages = try container.decodeIfPresent(
                    [Components.Schemas.CreateMessageRequest].self,
                    forKey: .messages
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "messages",
                    "metadata",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/ModifyThreadRequest`.
        public struct ModifyThreadRequest: Codable, Hashable, Sendable {
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyThreadRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `ModifyThreadRequest`.
            ///
            /// - Parameters:
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil) {
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "metadata"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/DeleteThreadResponse`.
        public struct DeleteThreadResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteThreadResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteThreadResponse/deleted`.
            public var deleted: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/DeleteThreadResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_deleted = "thread.deleted"
            }
            /// - Remark: Generated from `#/components/schemas/DeleteThreadResponse/object`.
            public var object: Components.Schemas.DeleteThreadResponse.objectPayload
            /// Creates a new `DeleteThreadResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - deleted:
            ///   - object:
            public init(
                id: Swift.String,
                deleted: Swift.Bool,
                object: Components.Schemas.DeleteThreadResponse.objectPayload
            ) {
                self.id = id
                self.deleted = deleted
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case deleted
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListThreadsResponse`.
        public struct ListThreadsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListThreadsResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListThreadsResponse/data`.
            public var data: [Components.Schemas.ThreadObject]
            /// - Remark: Generated from `#/components/schemas/ListThreadsResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListThreadsResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListThreadsResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListThreadsResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.ThreadObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// Represents a message within a [thread](/docs/api-reference/threads).
        ///
        /// - Remark: Generated from `#/components/schemas/MessageObject`.
        public struct MessageObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/id`.
            public var id: Swift.String
            /// The object type, which is always `thread.message`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_message = "thread.message"
            }
            /// The object type, which is always `thread.message`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/object`.
            public var object: Components.Schemas.MessageObject.objectPayload
            /// The Unix timestamp (in seconds) for when the message was created.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/created_at`.
            public var created_at: Swift.Int
            /// The [thread](/docs/api-reference/threads) ID that this message belongs to.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/thread_id`.
            public var thread_id: Swift.String
            /// The entity that produced the message. One of `user` or `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case user = "user"
                case assistant = "assistant"
            }
            /// The entity that produced the message. One of `user` or `assistant`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/role`.
            public var role: Components.Schemas.MessageObject.rolePayload
            /// - Remark: Generated from `#/components/schemas/MessageObject/contentPayload`.
            @frozen public enum contentPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/MessageObject/contentPayload/case1`.
                case MessageContentImageFileObject(Components.Schemas.MessageContentImageFileObject)
                /// - Remark: Generated from `#/components/schemas/MessageObject/contentPayload/case2`.
                case MessageContentTextObject(Components.Schemas.MessageContentTextObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .MessageContentImageFileObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .MessageContentTextObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .MessageContentImageFileObject(value):
                        try value.encode(to: encoder)
                    case let .MessageContentTextObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// The content of the message in array of text and/or images.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/content`.
            public typealias contentPayload = [Components.Schemas.MessageObject
                .contentPayloadPayload]
            /// The content of the message in array of text and/or images.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/content`.
            public var content: Components.Schemas.MessageObject.contentPayload
            /// If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/assistant_id`.
            public var assistant_id: Swift.String?
            /// If applicable, the ID of the [run](/docs/api-reference/runs) associated with the authoring of this message.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/run_id`.
            public var run_id: Swift.String?
            /// A list of [file](/docs/api-reference/files) IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access files. A maximum of 10 files can be attached to a message.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/file_ids`.
            public var file_ids: [Swift.String]
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/MessageObject/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `MessageObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `thread.message`.
            ///   - created_at: The Unix timestamp (in seconds) for when the message was created.
            ///   - thread_id: The [thread](/docs/api-reference/threads) ID that this message belongs to.
            ///   - role: The entity that produced the message. One of `user` or `assistant`.
            ///   - content: The content of the message in array of text and/or images.
            ///   - assistant_id: If applicable, the ID of the [assistant](/docs/api-reference/assistants) that authored this message.
            ///   - run_id: If applicable, the ID of the [run](/docs/api-reference/runs) associated with the authoring of this message.
            ///   - file_ids: A list of [file](/docs/api-reference/files) IDs that the assistant should use. Useful for tools like retrieval and code_interpreter that can access files. A maximum of 10 files can be attached to a message.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                id: Swift.String,
                object: Components.Schemas.MessageObject.objectPayload,
                created_at: Swift.Int,
                thread_id: Swift.String,
                role: Components.Schemas.MessageObject.rolePayload,
                content: Components.Schemas.MessageObject.contentPayload,
                assistant_id: Swift.String? = nil,
                run_id: Swift.String? = nil,
                file_ids: [Swift.String],
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.thread_id = thread_id
                self.role = role
                self.content = content
                self.assistant_id = assistant_id
                self.run_id = run_id
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case thread_id
                case role
                case content
                case assistant_id
                case run_id
                case file_ids
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateMessageRequest`.
        public struct CreateMessageRequest: Codable, Hashable, Sendable {
            /// The role of the entity that is creating the message. Currently only `user` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateMessageRequest/role`.
            @frozen public enum rolePayload: String, Codable, Hashable, Sendable {
                case user = "user"
            }
            /// The role of the entity that is creating the message. Currently only `user` is supported.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateMessageRequest/role`.
            public var role: Components.Schemas.CreateMessageRequest.rolePayload
            /// The content of the message.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateMessageRequest/content`.
            public var content: Swift.String
            /// A list of [File](/docs/api-reference/files) IDs that the message should use. There can be a maximum of 10 files attached to a message. Useful for tools like `retrieval` and `code_interpreter` that can access and use files.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateMessageRequest/file_ids`.
            public var file_ids: [Swift.String]?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/CreateMessageRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `CreateMessageRequest`.
            ///
            /// - Parameters:
            ///   - role: The role of the entity that is creating the message. Currently only `user` is supported.
            ///   - content: The content of the message.
            ///   - file_ids: A list of [File](/docs/api-reference/files) IDs that the message should use. There can be a maximum of 10 files attached to a message. Useful for tools like `retrieval` and `code_interpreter` that can access and use files.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                role: Components.Schemas.CreateMessageRequest.rolePayload,
                content: Swift.String,
                file_ids: [Swift.String]? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.role = role
                self.content = content
                self.file_ids = file_ids
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case role
                case content
                case file_ids
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                role = try container.decode(
                    Components.Schemas.CreateMessageRequest.rolePayload.self,
                    forKey: .role
                )
                content = try container.decode(
                    Swift.String.self,
                    forKey: .content
                )
                file_ids = try container.decodeIfPresent(
                    [Swift.String].self,
                    forKey: .file_ids
                )
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "role",
                    "content",
                    "file_ids",
                    "metadata",
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/ModifyMessageRequest`.
        public struct ModifyMessageRequest: Codable, Hashable, Sendable {
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/ModifyMessageRequest/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `ModifyMessageRequest`.
            ///
            /// - Parameters:
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil) {
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case metadata
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                metadata = try container.decodeIfPresent(
                    OpenAPIRuntime.OpenAPIObjectContainer.self,
                    forKey: .metadata
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "metadata"
                ])
            }
        }
        /// - Remark: Generated from `#/components/schemas/DeleteMessageResponse`.
        public struct DeleteMessageResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteMessageResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteMessageResponse/deleted`.
            public var deleted: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/DeleteMessageResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_message_period_deleted = "thread.message.deleted"
            }
            /// - Remark: Generated from `#/components/schemas/DeleteMessageResponse/object`.
            public var object: Components.Schemas.DeleteMessageResponse.objectPayload
            /// Creates a new `DeleteMessageResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - deleted:
            ///   - object:
            public init(
                id: Swift.String,
                deleted: Swift.Bool,
                object: Components.Schemas.DeleteMessageResponse.objectPayload
            ) {
                self.id = id
                self.deleted = deleted
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case deleted
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListMessagesResponse`.
        public struct ListMessagesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListMessagesResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessagesResponse/data`.
            public var data: [Components.Schemas.MessageObject]
            /// - Remark: Generated from `#/components/schemas/ListMessagesResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessagesResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessagesResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListMessagesResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.MessageObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// References an image [File](/docs/api-reference/files) in the content of a message.
        ///
        /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject`.
        public struct MessageContentImageFileObject: Codable, Hashable, Sendable {
            /// Always `image_file`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case image_file = "image_file"
            }
            /// Always `image_file`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject/type`.
            public var _type: Components.Schemas.MessageContentImageFileObject._typePayload
            /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject/image_file`.
            public struct image_filePayload: Codable, Hashable, Sendable {
                /// The [File](/docs/api-reference/files) ID of the image in the message content.
                ///
                /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject/image_file/file_id`.
                public var file_id: Swift.String
                /// Creates a new `image_filePayload`.
                ///
                /// - Parameters:
                ///   - file_id: The [File](/docs/api-reference/files) ID of the image in the message content.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
                public enum CodingKeys: String, CodingKey {
                    case file_id
                }
            }
            /// - Remark: Generated from `#/components/schemas/MessageContentImageFileObject/image_file`.
            public var image_file:
                Components.Schemas.MessageContentImageFileObject.image_filePayload
            /// Creates a new `MessageContentImageFileObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `image_file`.
            ///   - image_file:
            public init(
                _type: Components.Schemas.MessageContentImageFileObject._typePayload,
                image_file: Components.Schemas.MessageContentImageFileObject.image_filePayload
            ) {
                self._type = _type
                self.image_file = image_file
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case image_file
            }
        }
        /// The text content that is part of a message.
        ///
        /// - Remark: Generated from `#/components/schemas/MessageContentTextObject`.
        public struct MessageContentTextObject: Codable, Hashable, Sendable {
            /// Always `text`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case text = "text"
            }
            /// Always `text`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/type`.
            public var _type: Components.Schemas.MessageContentTextObject._typePayload
            /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text`.
            public struct textPayload: Codable, Hashable, Sendable {
                /// The data that makes up the text.
                ///
                /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/value`.
                public var value: Swift.String
                /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/annotationsPayload`.
                @frozen public enum annotationsPayloadPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/annotationsPayload/case1`.
                    case MessageContentTextAnnotationsFileCitationObject(
                        Components.Schemas.MessageContentTextAnnotationsFileCitationObject)
                    /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/annotationsPayload/case2`.
                    case MessageContentTextAnnotationsFilePathObject(
                        Components.Schemas.MessageContentTextAnnotationsFilePathObject)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .MessageContentTextAnnotationsFileCitationObject(
                                try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .MessageContentTextAnnotationsFilePathObject(
                                try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .MessageContentTextAnnotationsFileCitationObject(value):
                            try value.encode(to: encoder)
                        case let .MessageContentTextAnnotationsFilePathObject(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/annotations`.
                public typealias annotationsPayload = [Components.Schemas.MessageContentTextObject
                    .textPayload.annotationsPayloadPayload]
                /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text/annotations`.
                public var annotations:
                    Components.Schemas.MessageContentTextObject.textPayload.annotationsPayload
                /// Creates a new `textPayload`.
                ///
                /// - Parameters:
                ///   - value: The data that makes up the text.
                ///   - annotations:
                public init(
                    value: Swift.String,
                    annotations: Components.Schemas.MessageContentTextObject.textPayload
                        .annotationsPayload
                ) {
                    self.value = value
                    self.annotations = annotations
                }
                public enum CodingKeys: String, CodingKey {
                    case value
                    case annotations
                }
            }
            /// - Remark: Generated from `#/components/schemas/MessageContentTextObject/text`.
            public var text: Components.Schemas.MessageContentTextObject.textPayload
            /// Creates a new `MessageContentTextObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `text`.
            ///   - text:
            public init(
                _type: Components.Schemas.MessageContentTextObject._typePayload,
                text: Components.Schemas.MessageContentTextObject.textPayload
            ) {
                self._type = _type
                self.text = text
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case text
            }
        }
        /// A citation within the message that points to a specific quote from a specific File associated with the assistant or the message. Generated when the assistant uses the "retrieval" tool to search files.
        ///
        /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject`.
        public struct MessageContentTextAnnotationsFileCitationObject: Codable, Hashable, Sendable {
            /// Always `file_citation`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case file_citation = "file_citation"
            }
            /// Always `file_citation`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/type`.
            public var _type:
                Components.Schemas.MessageContentTextAnnotationsFileCitationObject._typePayload
            /// The text in the message content that needs to be replaced.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/text`.
            public var text: Swift.String
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/file_citation`.
            public struct file_citationPayload: Codable, Hashable, Sendable {
                /// The ID of the specific File the citation is from.
                ///
                /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/file_citation/file_id`.
                public var file_id: Swift.String
                /// The specific quote in the file.
                ///
                /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/file_citation/quote`.
                public var quote: Swift.String
                /// Creates a new `file_citationPayload`.
                ///
                /// - Parameters:
                ///   - file_id: The ID of the specific File the citation is from.
                ///   - quote: The specific quote in the file.
                public init(
                    file_id: Swift.String,
                    quote: Swift.String
                ) {
                    self.file_id = file_id
                    self.quote = quote
                }
                public enum CodingKeys: String, CodingKey {
                    case file_id
                    case quote
                }
            }
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/file_citation`.
            public var file_citation:
                Components.Schemas.MessageContentTextAnnotationsFileCitationObject
                    .file_citationPayload
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/start_index`.
            public var start_index: Swift.Int
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFileCitationObject/end_index`.
            public var end_index: Swift.Int
            /// Creates a new `MessageContentTextAnnotationsFileCitationObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `file_citation`.
            ///   - text: The text in the message content that needs to be replaced.
            ///   - file_citation:
            ///   - start_index:
            ///   - end_index:
            public init(
                _type: Components.Schemas.MessageContentTextAnnotationsFileCitationObject
                    ._typePayload,
                text: Swift.String,
                file_citation: Components.Schemas.MessageContentTextAnnotationsFileCitationObject
                    .file_citationPayload,
                start_index: Swift.Int,
                end_index: Swift.Int
            ) {
                self._type = _type
                self.text = text
                self.file_citation = file_citation
                self.start_index = start_index
                self.end_index = end_index
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case text
                case file_citation
                case start_index
                case end_index
            }
        }
        /// A URL for the file that's generated when the assistant used the `code_interpreter` tool to generate a file.
        ///
        /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject`.
        public struct MessageContentTextAnnotationsFilePathObject: Codable, Hashable, Sendable {
            /// Always `file_path`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case file_path = "file_path"
            }
            /// Always `file_path`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/type`.
            public var _type:
                Components.Schemas.MessageContentTextAnnotationsFilePathObject._typePayload
            /// The text in the message content that needs to be replaced.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/text`.
            public var text: Swift.String
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/file_path`.
            public struct file_pathPayload: Codable, Hashable, Sendable {
                /// The ID of the file that was generated.
                ///
                /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/file_path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `file_pathPayload`.
                ///
                /// - Parameters:
                ///   - file_id: The ID of the file that was generated.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
                public enum CodingKeys: String, CodingKey {
                    case file_id
                }
            }
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/file_path`.
            public var file_path:
                Components.Schemas.MessageContentTextAnnotationsFilePathObject.file_pathPayload
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/start_index`.
            public var start_index: Swift.Int
            /// - Remark: Generated from `#/components/schemas/MessageContentTextAnnotationsFilePathObject/end_index`.
            public var end_index: Swift.Int
            /// Creates a new `MessageContentTextAnnotationsFilePathObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `file_path`.
            ///   - text: The text in the message content that needs to be replaced.
            ///   - file_path:
            ///   - start_index:
            ///   - end_index:
            public init(
                _type: Components.Schemas.MessageContentTextAnnotationsFilePathObject._typePayload,
                text: Swift.String,
                file_path: Components.Schemas.MessageContentTextAnnotationsFilePathObject
                    .file_pathPayload,
                start_index: Swift.Int,
                end_index: Swift.Int
            ) {
                self._type = _type
                self.text = text
                self.file_path = file_path
                self.start_index = start_index
                self.end_index = end_index
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case text
                case file_path
                case start_index
                case end_index
            }
        }
        /// Represents a step in execution of a run.
        ///
        ///
        /// - Remark: Generated from `#/components/schemas/RunStepObject`.
        public struct RunStepObject: Codable, Hashable, Sendable {
            /// The identifier of the run step, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/id`.
            public var id: Swift.String
            /// The object type, which is always `thread.run.step``.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_run_period_step = "thread.run.step"
            }
            /// The object type, which is always `thread.run.step``.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/object`.
            public var object: Components.Schemas.RunStepObject.objectPayload
            /// The Unix timestamp (in seconds) for when the run step was created.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/created_at`.
            public var created_at: Swift.Int
            /// The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/assistant_id`.
            public var assistant_id: Swift.String
            /// The ID of the [thread](/docs/api-reference/threads) that was run.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/thread_id`.
            public var thread_id: Swift.String
            /// The ID of the [run](/docs/api-reference/runs) that this run step is a part of.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/run_id`.
            public var run_id: Swift.String
            /// The type of run step, which can be either `message_creation` or `tool_calls`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case message_creation = "message_creation"
                case tool_calls = "tool_calls"
            }
            /// The type of run step, which can be either `message_creation` or `tool_calls`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/type`.
            public var _type: Components.Schemas.RunStepObject._typePayload
            /// The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/status`.
            @frozen public enum statusPayload: String, Codable, Hashable, Sendable {
                case in_progress = "in_progress"
                case cancelled = "cancelled"
                case failed = "failed"
                case completed = "completed"
                case expired = "expired"
            }
            /// The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/status`.
            public var status: Components.Schemas.RunStepObject.statusPayload
            /// The details of the run step.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/step_details`.
            @frozen public enum step_detailsPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/RunStepObject/step_details/case1`.
                case RunStepDetailsMessageCreationObject(
                    Components.Schemas.RunStepDetailsMessageCreationObject)
                /// - Remark: Generated from `#/components/schemas/RunStepObject/step_details/case2`.
                case RunStepDetailsToolCallsObject(Components.Schemas.RunStepDetailsToolCallsObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .RunStepDetailsMessageCreationObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .RunStepDetailsToolCallsObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .RunStepDetailsMessageCreationObject(value):
                        try value.encode(to: encoder)
                    case let .RunStepDetailsToolCallsObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// The details of the run step.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/step_details`.
            public var step_details: Components.Schemas.RunStepObject.step_detailsPayload
            /// The last error associated with this run step. Will be `null` if there are no errors.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/last_error`.
            public struct last_errorPayload: Codable, Hashable, Sendable {
                /// One of `server_error` or `rate_limit_exceeded`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepObject/last_error/code`.
                @frozen public enum codePayload: String, Codable, Hashable, Sendable {
                    case server_error = "server_error"
                    case rate_limit_exceeded = "rate_limit_exceeded"
                }
                /// One of `server_error` or `rate_limit_exceeded`.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepObject/last_error/code`.
                public var code: Components.Schemas.RunStepObject.last_errorPayload.codePayload
                /// A human-readable description of the error.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepObject/last_error/message`.
                public var message: Swift.String
                /// Creates a new `last_errorPayload`.
                ///
                /// - Parameters:
                ///   - code: One of `server_error` or `rate_limit_exceeded`.
                ///   - message: A human-readable description of the error.
                public init(
                    code: Components.Schemas.RunStepObject.last_errorPayload.codePayload,
                    message: Swift.String
                ) {
                    self.code = code
                    self.message = message
                }
                public enum CodingKeys: String, CodingKey {
                    case code
                    case message
                }
            }
            /// The last error associated with this run step. Will be `null` if there are no errors.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/last_error`.
            public var last_error: Components.Schemas.RunStepObject.last_errorPayload?
            /// The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/expired_at`.
            public var expired_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run step was cancelled.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/cancelled_at`.
            public var cancelled_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run step failed.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/failed_at`.
            public var failed_at: Swift.Int?
            /// The Unix timestamp (in seconds) for when the run step completed.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/completed_at`.
            public var completed_at: Swift.Int?
            /// Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepObject/metadata`.
            public var metadata: OpenAPIRuntime.OpenAPIObjectContainer?
            /// Creates a new `RunStepObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier of the run step, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `thread.run.step``.
            ///   - created_at: The Unix timestamp (in seconds) for when the run step was created.
            ///   - assistant_id: The ID of the [assistant](/docs/api-reference/assistants) associated with the run step.
            ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) that was run.
            ///   - run_id: The ID of the [run](/docs/api-reference/runs) that this run step is a part of.
            ///   - _type: The type of run step, which can be either `message_creation` or `tool_calls`.
            ///   - status: The status of the run step, which can be either `in_progress`, `cancelled`, `failed`, `completed`, or `expired`.
            ///   - step_details: The details of the run step.
            ///   - last_error: The last error associated with this run step. Will be `null` if there are no errors.
            ///   - expired_at: The Unix timestamp (in seconds) for when the run step expired. A step is considered expired if the parent run is expired.
            ///   - cancelled_at: The Unix timestamp (in seconds) for when the run step was cancelled.
            ///   - failed_at: The Unix timestamp (in seconds) for when the run step failed.
            ///   - completed_at: The Unix timestamp (in seconds) for when the run step completed.
            ///   - metadata: Set of 16 key-value pairs that can be attached to an object. This can be useful for storing additional information about the object in a structured format. Keys can be a maximum of 64 characters long and values can be a maxium of 512 characters long.
            public init(
                id: Swift.String,
                object: Components.Schemas.RunStepObject.objectPayload,
                created_at: Swift.Int,
                assistant_id: Swift.String,
                thread_id: Swift.String,
                run_id: Swift.String,
                _type: Components.Schemas.RunStepObject._typePayload,
                status: Components.Schemas.RunStepObject.statusPayload,
                step_details: Components.Schemas.RunStepObject.step_detailsPayload,
                last_error: Components.Schemas.RunStepObject.last_errorPayload? = nil,
                expired_at: Swift.Int? = nil,
                cancelled_at: Swift.Int? = nil,
                failed_at: Swift.Int? = nil,
                completed_at: Swift.Int? = nil,
                metadata: OpenAPIRuntime.OpenAPIObjectContainer? = nil
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.assistant_id = assistant_id
                self.thread_id = thread_id
                self.run_id = run_id
                self._type = _type
                self.status = status
                self.step_details = step_details
                self.last_error = last_error
                self.expired_at = expired_at
                self.cancelled_at = cancelled_at
                self.failed_at = failed_at
                self.completed_at = completed_at
                self.metadata = metadata
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case assistant_id
                case thread_id
                case run_id
                case _type = "type"
                case status
                case step_details
                case last_error
                case expired_at
                case cancelled_at
                case failed_at
                case completed_at
                case metadata
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse`.
        public struct ListRunStepsResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse/data`.
            public var data: [Components.Schemas.RunStepObject]
            /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListRunStepsResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListRunStepsResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.RunStepObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// Details of the message creation by the run step.
        ///
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject`.
        public struct RunStepDetailsMessageCreationObject: Codable, Hashable, Sendable {
            /// Always `message_creation``.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case message_creation = "message_creation"
            }
            /// Always `message_creation``.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject/type`.
            public var _type: Components.Schemas.RunStepDetailsMessageCreationObject._typePayload
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject/message_creation`.
            public struct message_creationPayload: Codable, Hashable, Sendable {
                /// The ID of the message that was created by this run step.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject/message_creation/message_id`.
                public var message_id: Swift.String
                /// Creates a new `message_creationPayload`.
                ///
                /// - Parameters:
                ///   - message_id: The ID of the message that was created by this run step.
                public init(message_id: Swift.String) {
                    self.message_id = message_id
                }
                public enum CodingKeys: String, CodingKey {
                    case message_id
                }
            }
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsMessageCreationObject/message_creation`.
            public var message_creation:
                Components.Schemas.RunStepDetailsMessageCreationObject.message_creationPayload
            /// Creates a new `RunStepDetailsMessageCreationObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `message_creation``.
            ///   - message_creation:
            public init(
                _type: Components.Schemas.RunStepDetailsMessageCreationObject._typePayload,
                message_creation: Components.Schemas.RunStepDetailsMessageCreationObject
                    .message_creationPayload
            ) {
                self._type = _type
                self.message_creation = message_creation
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case message_creation
            }
        }
        /// Details of the tool call.
        ///
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject`.
        public struct RunStepDetailsToolCallsObject: Codable, Hashable, Sendable {
            /// Always `tool_calls`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case tool_calls = "tool_calls"
            }
            /// Always `tool_calls`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/type`.
            public var _type: Components.Schemas.RunStepDetailsToolCallsObject._typePayload
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_callsPayload`.
            @frozen public enum tool_callsPayloadPayload: Codable, Hashable, Sendable {
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_callsPayload/case1`.
                case RunStepDetailsToolCallsCodeObject(
                    Components.Schemas.RunStepDetailsToolCallsCodeObject)
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_callsPayload/case2`.
                case RunStepDetailsToolCallsRetrievalObject(
                    Components.Schemas.RunStepDetailsToolCallsRetrievalObject)
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_callsPayload/case3`.
                case RunStepDetailsToolCallsFunctionObject(
                    Components.Schemas.RunStepDetailsToolCallsFunctionObject)
                public init(from decoder: any Decoder) throws {
                    var errors: [any Error] = []
                    do {
                        self = .RunStepDetailsToolCallsCodeObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .RunStepDetailsToolCallsRetrievalObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    do {
                        self = .RunStepDetailsToolCallsFunctionObject(try .init(from: decoder))
                        return
                    } catch {
                        errors.append(error)
                    }
                    throw Swift.DecodingError.failedToDecodeOneOfSchema(
                        type: Self.self,
                        codingPath: decoder.codingPath,
                        errors: errors
                    )
                }
                public func encode(to encoder: any Encoder) throws {
                    switch self {
                    case let .RunStepDetailsToolCallsCodeObject(value):
                        try value.encode(to: encoder)
                    case let .RunStepDetailsToolCallsRetrievalObject(value):
                        try value.encode(to: encoder)
                    case let .RunStepDetailsToolCallsFunctionObject(value):
                        try value.encode(to: encoder)
                    }
                }
            }
            /// An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_calls`.
            public typealias tool_callsPayload = [Components.Schemas.RunStepDetailsToolCallsObject
                .tool_callsPayloadPayload]
            /// An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `retrieval`, or `function`.
            ///
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsObject/tool_calls`.
            public var tool_calls:
                Components.Schemas.RunStepDetailsToolCallsObject.tool_callsPayload
            /// Creates a new `RunStepDetailsToolCallsObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `tool_calls`.
            ///   - tool_calls: An array of tool calls the run step was involved in. These can be associated with one of three types of tools: `code_interpreter`, `retrieval`, or `function`.
            public init(
                _type: Components.Schemas.RunStepDetailsToolCallsObject._typePayload,
                tool_calls: Components.Schemas.RunStepDetailsToolCallsObject.tool_callsPayload
            ) {
                self._type = _type
                self.tool_calls = tool_calls
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case tool_calls
            }
        }
        /// Details of the Code Interpreter tool call the run step was involved in.
        ///
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject`.
        public struct RunStepDetailsToolCallsCodeObject: Codable, Hashable, Sendable {
            /// The ID of the tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/id`.
            public var id: Swift.String
            /// The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case code_interpreter = "code_interpreter"
            }
            /// The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/type`.
            public var _type: Components.Schemas.RunStepDetailsToolCallsCodeObject._typePayload
            /// The Code Interpreter tool call definition.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter`.
            public struct code_interpreterPayload: Codable, Hashable, Sendable {
                /// The input to the Code Interpreter tool call.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/input`.
                public var input: Swift.String
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/outputsPayload`.
                @frozen public enum outputsPayloadPayload: Codable, Hashable, Sendable {
                    /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/outputsPayload/case1`.
                    case RunStepDetailsToolCallsCodeOutputLogsObject(
                        Components.Schemas.RunStepDetailsToolCallsCodeOutputLogsObject)
                    /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/outputsPayload/case2`.
                    case RunStepDetailsToolCallsCodeOutputImageObject(
                        Components.Schemas.RunStepDetailsToolCallsCodeOutputImageObject)
                    public init(from decoder: any Decoder) throws {
                        var errors: [any Error] = []
                        do {
                            self = .RunStepDetailsToolCallsCodeOutputLogsObject(
                                try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        do {
                            self = .RunStepDetailsToolCallsCodeOutputImageObject(
                                try .init(from: decoder))
                            return
                        } catch {
                            errors.append(error)
                        }
                        throw Swift.DecodingError.failedToDecodeOneOfSchema(
                            type: Self.self,
                            codingPath: decoder.codingPath,
                            errors: errors
                        )
                    }
                    public func encode(to encoder: any Encoder) throws {
                        switch self {
                        case let .RunStepDetailsToolCallsCodeOutputLogsObject(value):
                            try value.encode(to: encoder)
                        case let .RunStepDetailsToolCallsCodeOutputImageObject(value):
                            try value.encode(to: encoder)
                        }
                    }
                }
                /// The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/outputs`.
                public typealias outputsPayload = [Components.Schemas
                    .RunStepDetailsToolCallsCodeObject.code_interpreterPayload
                    .outputsPayloadPayload]
                /// The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter/outputs`.
                public var outputs:
                    Components.Schemas.RunStepDetailsToolCallsCodeObject.code_interpreterPayload
                        .outputsPayload
                /// Creates a new `code_interpreterPayload`.
                ///
                /// - Parameters:
                ///   - input: The input to the Code Interpreter tool call.
                ///   - outputs: The outputs from the Code Interpreter tool call. Code Interpreter can output one or more items, including text (`logs`) or images (`image`). Each of these are represented by a different object type.
                public init(
                    input: Swift.String,
                    outputs: Components.Schemas.RunStepDetailsToolCallsCodeObject
                        .code_interpreterPayload.outputsPayload
                ) {
                    self.input = input
                    self.outputs = outputs
                }
                public enum CodingKeys: String, CodingKey {
                    case input
                    case outputs
                }
            }
            /// The Code Interpreter tool call definition.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeObject/code_interpreter`.
            public var code_interpreter:
                Components.Schemas.RunStepDetailsToolCallsCodeObject.code_interpreterPayload
            /// Creates a new `RunStepDetailsToolCallsCodeObject`.
            ///
            /// - Parameters:
            ///   - id: The ID of the tool call.
            ///   - _type: The type of tool call. This is always going to be `code_interpreter` for this type of tool call.
            ///   - code_interpreter: The Code Interpreter tool call definition.
            public init(
                id: Swift.String,
                _type: Components.Schemas.RunStepDetailsToolCallsCodeObject._typePayload,
                code_interpreter: Components.Schemas.RunStepDetailsToolCallsCodeObject
                    .code_interpreterPayload
            ) {
                self.id = id
                self._type = _type
                self.code_interpreter = code_interpreter
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case code_interpreter
            }
        }
        /// Text output from the Code Interpreter tool call as part of a run step.
        ///
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputLogsObject`.
        public struct RunStepDetailsToolCallsCodeOutputLogsObject: Codable, Hashable, Sendable {
            /// Always `logs`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputLogsObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case logs = "logs"
            }
            /// Always `logs`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputLogsObject/type`.
            public var _type:
                Components.Schemas.RunStepDetailsToolCallsCodeOutputLogsObject._typePayload
            /// The text output from the Code Interpreter tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputLogsObject/logs`.
            public var logs: Swift.String
            /// Creates a new `RunStepDetailsToolCallsCodeOutputLogsObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `logs`.
            ///   - logs: The text output from the Code Interpreter tool call.
            public init(
                _type: Components.Schemas.RunStepDetailsToolCallsCodeOutputLogsObject._typePayload,
                logs: Swift.String
            ) {
                self._type = _type
                self.logs = logs
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case logs
            }
        }
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject`.
        public struct RunStepDetailsToolCallsCodeOutputImageObject: Codable, Hashable, Sendable {
            /// Always `image`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case image = "image"
            }
            /// Always `image`.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject/type`.
            public var _type:
                Components.Schemas.RunStepDetailsToolCallsCodeOutputImageObject._typePayload
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject/image`.
            public struct imagePayload: Codable, Hashable, Sendable {
                /// The [file](/docs/api-reference/files) ID of the image.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject/image/file_id`.
                public var file_id: Swift.String
                /// Creates a new `imagePayload`.
                ///
                /// - Parameters:
                ///   - file_id: The [file](/docs/api-reference/files) ID of the image.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
                public enum CodingKeys: String, CodingKey {
                    case file_id
                }
            }
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsCodeOutputImageObject/image`.
            public var image:
                Components.Schemas.RunStepDetailsToolCallsCodeOutputImageObject.imagePayload
            /// Creates a new `RunStepDetailsToolCallsCodeOutputImageObject`.
            ///
            /// - Parameters:
            ///   - _type: Always `image`.
            ///   - image:
            public init(
                _type: Components.Schemas.RunStepDetailsToolCallsCodeOutputImageObject._typePayload,
                image: Components.Schemas.RunStepDetailsToolCallsCodeOutputImageObject.imagePayload
            ) {
                self._type = _type
                self.image = image
            }
            public enum CodingKeys: String, CodingKey {
                case _type = "type"
                case image
            }
        }
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsRetrievalObject`.
        public struct RunStepDetailsToolCallsRetrievalObject: Codable, Hashable, Sendable {
            /// The ID of the tool call object.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsRetrievalObject/id`.
            public var id: Swift.String
            /// The type of tool call. This is always going to be `retrieval` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsRetrievalObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case retrieval = "retrieval"
            }
            /// The type of tool call. This is always going to be `retrieval` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsRetrievalObject/type`.
            public var _type: Components.Schemas.RunStepDetailsToolCallsRetrievalObject._typePayload
            /// For now, this is always going to be an empty object.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsRetrievalObject/retrieval`.
            public var retrieval: OpenAPIRuntime.OpenAPIObjectContainer
            /// Creates a new `RunStepDetailsToolCallsRetrievalObject`.
            ///
            /// - Parameters:
            ///   - id: The ID of the tool call object.
            ///   - _type: The type of tool call. This is always going to be `retrieval` for this type of tool call.
            ///   - retrieval: For now, this is always going to be an empty object.
            public init(
                id: Swift.String,
                _type: Components.Schemas.RunStepDetailsToolCallsRetrievalObject._typePayload,
                retrieval: OpenAPIRuntime.OpenAPIObjectContainer
            ) {
                self.id = id
                self._type = _type
                self.retrieval = retrieval
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case retrieval
            }
        }
        /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject`.
        public struct RunStepDetailsToolCallsFunctionObject: Codable, Hashable, Sendable {
            /// The ID of the tool call object.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/id`.
            public var id: Swift.String
            /// The type of tool call. This is always going to be `function` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/type`.
            @frozen public enum _typePayload: String, Codable, Hashable, Sendable {
                case function = "function"
            }
            /// The type of tool call. This is always going to be `function` for this type of tool call.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/type`.
            public var _type: Components.Schemas.RunStepDetailsToolCallsFunctionObject._typePayload
            /// The definition of the function that was called.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/function`.
            public struct functionPayload: Codable, Hashable, Sendable {
                /// The name of the function.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/function/name`.
                public var name: Swift.String
                /// The arguments passed to the function.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/function/arguments`.
                public var arguments: Swift.String
                /// The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
                ///
                /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/function/output`.
                public var output: Swift.String?
                /// Creates a new `functionPayload`.
                ///
                /// - Parameters:
                ///   - name: The name of the function.
                ///   - arguments: The arguments passed to the function.
                ///   - output: The output of the function. This will be `null` if the outputs have not been [submitted](/docs/api-reference/runs/submitToolOutputs) yet.
                public init(
                    name: Swift.String,
                    arguments: Swift.String,
                    output: Swift.String? = nil
                ) {
                    self.name = name
                    self.arguments = arguments
                    self.output = output
                }
                public enum CodingKeys: String, CodingKey {
                    case name
                    case arguments
                    case output
                }
            }
            /// The definition of the function that was called.
            ///
            /// - Remark: Generated from `#/components/schemas/RunStepDetailsToolCallsFunctionObject/function`.
            public var function:
                Components.Schemas.RunStepDetailsToolCallsFunctionObject.functionPayload
            /// Creates a new `RunStepDetailsToolCallsFunctionObject`.
            ///
            /// - Parameters:
            ///   - id: The ID of the tool call object.
            ///   - _type: The type of tool call. This is always going to be `function` for this type of tool call.
            ///   - function: The definition of the function that was called.
            public init(
                id: Swift.String,
                _type: Components.Schemas.RunStepDetailsToolCallsFunctionObject._typePayload,
                function: Components.Schemas.RunStepDetailsToolCallsFunctionObject.functionPayload
            ) {
                self.id = id
                self._type = _type
                self.function = function
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case _type = "type"
                case function
            }
        }
        /// A list of [Files](/docs/api-reference/files) attached to an `assistant`.
        ///
        /// - Remark: Generated from `#/components/schemas/AssistantFileObject`.
        public struct AssistantFileObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantFileObject/id`.
            public var id: Swift.String
            /// The object type, which is always `assistant.file`.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantFileObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case assistant_period_file = "assistant.file"
            }
            /// The object type, which is always `assistant.file`.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantFileObject/object`.
            public var object: Components.Schemas.AssistantFileObject.objectPayload
            /// The Unix timestamp (in seconds) for when the assistant file was created.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantFileObject/created_at`.
            public var created_at: Swift.Int
            /// The assistant ID that the file is attached to.
            ///
            /// - Remark: Generated from `#/components/schemas/AssistantFileObject/assistant_id`.
            public var assistant_id: Swift.String
            /// Creates a new `AssistantFileObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `assistant.file`.
            ///   - created_at: The Unix timestamp (in seconds) for when the assistant file was created.
            ///   - assistant_id: The assistant ID that the file is attached to.
            public init(
                id: Swift.String,
                object: Components.Schemas.AssistantFileObject.objectPayload,
                created_at: Swift.Int,
                assistant_id: Swift.String
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.assistant_id = assistant_id
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case assistant_id
            }
        }
        /// - Remark: Generated from `#/components/schemas/CreateAssistantFileRequest`.
        public struct CreateAssistantFileRequest: Codable, Hashable, Sendable {
            /// A [File](/docs/api-reference/files) ID (with `purpose="assistants"`) that the assistant should use. Useful for tools like `retrieval` and `code_interpreter` that can access files.
            ///
            /// - Remark: Generated from `#/components/schemas/CreateAssistantFileRequest/file_id`.
            public var file_id: Swift.String
            /// Creates a new `CreateAssistantFileRequest`.
            ///
            /// - Parameters:
            ///   - file_id: A [File](/docs/api-reference/files) ID (with `purpose="assistants"`) that the assistant should use. Useful for tools like `retrieval` and `code_interpreter` that can access files.
            public init(file_id: Swift.String) {
                self.file_id = file_id
            }
            public enum CodingKeys: String, CodingKey {
                case file_id
            }
            public init(from decoder: any Decoder) throws {
                let container = try decoder.container(keyedBy: CodingKeys.self)
                file_id = try container.decode(
                    Swift.String.self,
                    forKey: .file_id
                )
                try decoder.ensureNoAdditionalProperties(knownKeys: [
                    "file_id"
                ])
            }
        }
        /// Deletes the association between the assistant and the file, but does not delete the [File](/docs/api-reference/files) object itself.
        ///
        /// - Remark: Generated from `#/components/schemas/DeleteAssistantFileResponse`.
        public struct DeleteAssistantFileResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantFileResponse/id`.
            public var id: Swift.String
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantFileResponse/deleted`.
            public var deleted: Swift.Bool
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantFileResponse/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case assistant_period_file_period_deleted = "assistant.file.deleted"
            }
            /// - Remark: Generated from `#/components/schemas/DeleteAssistantFileResponse/object`.
            public var object: Components.Schemas.DeleteAssistantFileResponse.objectPayload
            /// Creates a new `DeleteAssistantFileResponse`.
            ///
            /// - Parameters:
            ///   - id:
            ///   - deleted:
            ///   - object:
            public init(
                id: Swift.String,
                deleted: Swift.Bool,
                object: Components.Schemas.DeleteAssistantFileResponse.objectPayload
            ) {
                self.id = id
                self.deleted = deleted
                self.object = object
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case deleted
                case object
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse`.
        public struct ListAssistantFilesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse/data`.
            public var data: [Components.Schemas.AssistantFileObject]
            /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListAssistantFilesResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListAssistantFilesResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.AssistantFileObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
        /// A list of files attached to a `message`.
        ///
        /// - Remark: Generated from `#/components/schemas/MessageFileObject`.
        public struct MessageFileObject: Codable, Hashable, Sendable {
            /// The identifier, which can be referenced in API endpoints.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageFileObject/id`.
            public var id: Swift.String
            /// The object type, which is always `thread.message.file`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageFileObject/object`.
            @frozen public enum objectPayload: String, Codable, Hashable, Sendable {
                case thread_period_message_period_file = "thread.message.file"
            }
            /// The object type, which is always `thread.message.file`.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageFileObject/object`.
            public var object: Components.Schemas.MessageFileObject.objectPayload
            /// The Unix timestamp (in seconds) for when the message file was created.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageFileObject/created_at`.
            public var created_at: Swift.Int
            /// The ID of the [message](/docs/api-reference/messages) that the [File](/docs/api-reference/files) is attached to.
            ///
            /// - Remark: Generated from `#/components/schemas/MessageFileObject/message_id`.
            public var message_id: Swift.String
            /// Creates a new `MessageFileObject`.
            ///
            /// - Parameters:
            ///   - id: The identifier, which can be referenced in API endpoints.
            ///   - object: The object type, which is always `thread.message.file`.
            ///   - created_at: The Unix timestamp (in seconds) for when the message file was created.
            ///   - message_id: The ID of the [message](/docs/api-reference/messages) that the [File](/docs/api-reference/files) is attached to.
            public init(
                id: Swift.String,
                object: Components.Schemas.MessageFileObject.objectPayload,
                created_at: Swift.Int,
                message_id: Swift.String
            ) {
                self.id = id
                self.object = object
                self.created_at = created_at
                self.message_id = message_id
            }
            public enum CodingKeys: String, CodingKey {
                case id
                case object
                case created_at
                case message_id
            }
        }
        /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse`.
        public struct ListMessageFilesResponse: Codable, Hashable, Sendable {
            /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse/object`.
            public var object: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse/data`.
            public var data: [Components.Schemas.MessageFileObject]
            /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse/first_id`.
            public var first_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse/last_id`.
            public var last_id: Swift.String
            /// - Remark: Generated from `#/components/schemas/ListMessageFilesResponse/has_more`.
            public var has_more: Swift.Bool
            /// Creates a new `ListMessageFilesResponse`.
            ///
            /// - Parameters:
            ///   - object:
            ///   - data:
            ///   - first_id:
            ///   - last_id:
            ///   - has_more:
            public init(
                object: Swift.String,
                data: [Components.Schemas.MessageFileObject],
                first_id: Swift.String,
                last_id: Swift.String,
                has_more: Swift.Bool
            ) {
                self.object = object
                self.data = data
                self.first_id = first_id
                self.last_id = last_id
                self.has_more = has_more
            }
            public enum CodingKeys: String, CodingKey {
                case object
                case data
                case first_id
                case last_id
                case has_more
            }
        }
    }
    /// Types generated from the `#/components/parameters` section of the OpenAPI document.
    public enum Parameters {}
    /// Types generated from the `#/components/requestBodies` section of the OpenAPI document.
    public enum RequestBodies {}
    /// Types generated from the `#/components/responses` section of the OpenAPI document.
    public enum Responses {}
    /// Types generated from the `#/components/headers` section of the OpenAPI document.
    public enum Headers {}
}

/// API operations, with input and output types, generated from `#/paths` in the OpenAPI document.
public enum Operations {
    /// Creates a model response for the given chat conversation.
    ///
    /// - Remark: HTTP `POST /chat/completions`.
    /// - Remark: Generated from `#/paths//chat/completions/post(createChatCompletion)`.
    public enum createChatCompletion {
        public static let id: Swift.String = "createChatCompletion"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/chat/completions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createChatCompletion.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createChatCompletion.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createChatCompletion.Input.Headers
            /// - Remark: Generated from `#/paths/chat/completions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/chat/completions/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateChatCompletionRequest)
            }
            public var body: Operations.createChatCompletion.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createChatCompletion.Input.Headers = .init(),
                body: Operations.createChatCompletion.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/chat/completions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/chat/completions/POST/responses/200/content/text\/event-stream`.
                    case text_event_hyphen_stream(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.text_event_hyphen_stream`.
                    ///
                    /// - Throws: An error if `self` is not `.text_event_hyphen_stream`.
                    /// - SeeAlso: `.text_event_hyphen_stream`.
                    public var text_event_hyphen_stream: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .text_event_hyphen_stream(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "text/event-stream",
                                    body: self
                                )
                            }
                        }
                    }
                    /// - Remark: Generated from `#/paths/chat/completions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateChatCompletionResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateChatCompletionResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            default:
                                try throwUnexpectedResponseBody(
                                    expectedContent: "application/json",
                                    body: self
                                )
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createChatCompletion.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createChatCompletion.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//chat/completions/post(createChatCompletion)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createChatCompletion.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createChatCompletion.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case text_event_hyphen_stream
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "text/event-stream":
                    self = .text_event_hyphen_stream
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .text_event_hyphen_stream:
                    return "text/event-stream"
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .text_event_hyphen_stream,
                    .json,
                ]
            }
        }
    }
    /// Creates a completion for the provided prompt and parameters.
    ///
    /// - Remark: HTTP `POST /completions`.
    /// - Remark: Generated from `#/paths//completions/post(createCompletion)`.
    public enum createCompletion {
        public static let id: Swift.String = "createCompletion"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/completions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createCompletion.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createCompletion.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createCompletion.Input.Headers
            /// - Remark: Generated from `#/paths/completions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/completions/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateCompletionRequest)
            }
            public var body: Operations.createCompletion.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createCompletion.Input.Headers = .init(),
                body: Operations.createCompletion.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/completions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/completions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateCompletionResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateCompletionResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createCompletion.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createCompletion.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//completions/post(createCompletion)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createCompletion.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createCompletion.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates a new edit for the provided input, instruction, and parameters.
    ///
    /// - Remark: HTTP `POST /edits`.
    /// - Remark: Generated from `#/paths//edits/post(createEdit)`.
    public enum createEdit {
        public static let id: Swift.String = "createEdit"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/edits/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createEdit.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createEdit.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createEdit.Input.Headers
            /// - Remark: Generated from `#/paths/edits/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/edits/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateEditRequest)
            }
            public var body: Operations.createEdit.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createEdit.Input.Headers = .init(),
                body: Operations.createEdit.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/edits/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/edits/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateEditResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateEditResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createEdit.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createEdit.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//edits/post(createEdit)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createEdit.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createEdit.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates an image given a prompt.
    ///
    /// - Remark: HTTP `POST /images/generations`.
    /// - Remark: Generated from `#/paths//images/generations/post(createImage)`.
    public enum createImage {
        public static let id: Swift.String = "createImage"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/images/generations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImage.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImage.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createImage.Input.Headers
            /// - Remark: Generated from `#/paths/images/generations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/generations/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateImageRequest)
            }
            public var body: Operations.createImage.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createImage.Input.Headers = .init(),
                body: Operations.createImage.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/generations/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/images/generations/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.ImagesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ImagesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createImage.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createImage.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//images/generations/post(createImage)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createImage.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createImage.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates an edited or extended image given an original image and a prompt.
    ///
    /// - Remark: HTTP `POST /images/edits`.
    /// - Remark: Generated from `#/paths//images/edits/post(createImageEdit)`.
    public enum createImageEdit {
        public static let id: Swift.String = "createImageEdit"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/images/edits/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImageEdit.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImageEdit.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createImageEdit.Input.Headers
            /// - Remark: Generated from `#/paths/images/edits/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/edits/POST/requestBody/content/multipart\/form-data`.
                case multipartForm(
                    OpenAPIRuntime.MultipartBody<Components.Schemas.CreateImageEditRequest>)
            }
            public var body: Operations.createImageEdit.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createImageEdit.Input.Headers = .init(),
                body: Operations.createImageEdit.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/edits/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/images/edits/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.ImagesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ImagesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createImageEdit.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createImageEdit.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//images/edits/post(createImageEdit)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createImageEdit.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createImageEdit.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates a variation of a given image.
    ///
    /// - Remark: HTTP `POST /images/variations`.
    /// - Remark: Generated from `#/paths//images/variations/post(createImageVariation)`.
    public enum createImageVariation {
        public static let id: Swift.String = "createImageVariation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/images/variations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImageVariation.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createImageVariation.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createImageVariation.Input.Headers
            /// - Remark: Generated from `#/paths/images/variations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/variations/POST/requestBody/content/multipart\/form-data`.
                case multipartForm(
                    OpenAPIRuntime.MultipartBody<Components.Schemas.CreateImageVariationRequest>)
            }
            public var body: Operations.createImageVariation.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createImageVariation.Input.Headers = .init(),
                body: Operations.createImageVariation.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/images/variations/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/images/variations/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.ImagesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ImagesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createImageVariation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createImageVariation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//images/variations/post(createImageVariation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createImageVariation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createImageVariation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates an embedding vector representing the input text.
    ///
    /// - Remark: HTTP `POST /embeddings`.
    /// - Remark: Generated from `#/paths//embeddings/post(createEmbedding)`.
    public enum createEmbedding {
        public static let id: Swift.String = "createEmbedding"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/embeddings/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createEmbedding.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createEmbedding.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createEmbedding.Input.Headers
            /// - Remark: Generated from `#/paths/embeddings/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/embeddings/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateEmbeddingRequest)
            }
            public var body: Operations.createEmbedding.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createEmbedding.Input.Headers = .init(),
                body: Operations.createEmbedding.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/embeddings/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/embeddings/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateEmbeddingResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateEmbeddingResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createEmbedding.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createEmbedding.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//embeddings/post(createEmbedding)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createEmbedding.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createEmbedding.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Generates audio from the input text.
    ///
    /// - Remark: HTTP `POST /audio/speech`.
    /// - Remark: Generated from `#/paths//audio/speech/post(createSpeech)`.
    public enum createSpeech {
        public static let id: Swift.String = "createSpeech"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/audio/speech/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createSpeech.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createSpeech.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createSpeech.Input.Headers
            /// - Remark: Generated from `#/paths/audio/speech/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/speech/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateSpeechRequest)
            }
            public var body: Operations.createSpeech.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createSpeech.Input.Headers = .init(),
                body: Operations.createSpeech.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/speech/POST/responses/200/headers`.
                public struct Headers: Sendable, Hashable {
                    /// chunked
                    ///
                    /// - Remark: Generated from `#/paths/audio/speech/POST/responses/200/headers/Transfer-Encoding`.
                    public var Transfer_hyphen_Encoding: Swift.String?
                    /// Creates a new `Headers`.
                    ///
                    /// - Parameters:
                    ///   - Transfer_hyphen_Encoding: chunked
                    public init(Transfer_hyphen_Encoding: Swift.String? = nil) {
                        self.Transfer_hyphen_Encoding = Transfer_hyphen_Encoding
                    }
                }
                /// Received HTTP response headers
                public var headers: Operations.createSpeech.Output.Ok.Headers
                /// - Remark: Generated from `#/paths/audio/speech/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/audio/speech/POST/responses/200/content/*\/*`.
                    case any(OpenAPIRuntime.HTTPBody)
                    /// The associated value of the enum case if `self` is `.any`.
                    ///
                    /// - Throws: An error if `self` is not `.any`.
                    /// - SeeAlso: `.any`.
                    public var any: OpenAPIRuntime.HTTPBody {
                        get throws {
                            switch self {
                            case let .any(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createSpeech.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - headers: Received HTTP response headers
                ///   - body: Received HTTP response body
                public init(
                    headers: Operations.createSpeech.Output.Ok.Headers = .init(),
                    body: Operations.createSpeech.Output.Ok.Body
                ) {
                    self.headers = headers
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//audio/speech/post(createSpeech)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createSpeech.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createSpeech.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case any
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "*/*":
                    self = .any
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .any:
                    return "*/*"
                }
            }
            public static var allCases: [Self] {
                [
                    .any
                ]
            }
        }
    }
    /// Transcribes audio into the input language.
    ///
    /// - Remark: HTTP `POST /audio/transcriptions`.
    /// - Remark: Generated from `#/paths//audio/transcriptions/post(createTranscription)`.
    public enum createTranscription {
        public static let id: Swift.String = "createTranscription"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/audio/transcriptions/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createTranscription.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createTranscription.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createTranscription.Input.Headers
            /// - Remark: Generated from `#/paths/audio/transcriptions/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/transcriptions/POST/requestBody/content/multipart\/form-data`.
                case multipartForm(
                    OpenAPIRuntime.MultipartBody<Components.Schemas.CreateTranscriptionRequest>)
            }
            public var body: Operations.createTranscription.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createTranscription.Input.Headers = .init(),
                body: Operations.createTranscription.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/transcriptions/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/audio/transcriptions/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateTranscriptionResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateTranscriptionResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createTranscription.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createTranscription.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//audio/transcriptions/post(createTranscription)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createTranscription.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createTranscription.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Translates audio into English.
    ///
    /// - Remark: HTTP `POST /audio/translations`.
    /// - Remark: Generated from `#/paths//audio/translations/post(createTranslation)`.
    public enum createTranslation {
        public static let id: Swift.String = "createTranslation"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/audio/translations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createTranslation.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createTranslation.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createTranslation.Input.Headers
            /// - Remark: Generated from `#/paths/audio/translations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/translations/POST/requestBody/content/multipart\/form-data`.
                case multipartForm(
                    OpenAPIRuntime.MultipartBody<Components.Schemas.CreateTranslationRequest>)
            }
            public var body: Operations.createTranslation.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createTranslation.Input.Headers = .init(),
                body: Operations.createTranslation.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/audio/translations/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/audio/translations/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateTranslationResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateTranslationResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createTranslation.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createTranslation.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//audio/translations/post(createTranslation)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createTranslation.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createTranslation.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of files that belong to the user's organization.
    ///
    /// - Remark: HTTP `GET /files`.
    /// - Remark: Generated from `#/paths//files/get(listFiles)`.
    public enum listFiles {
        public static let id: Swift.String = "listFiles"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/files/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Only return files with the given purpose.
                ///
                /// - Remark: Generated from `#/paths/files/GET/query/purpose`.
                public var purpose: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - purpose: Only return files with the given purpose.
                public init(purpose: Swift.String? = nil) {
                    self.purpose = purpose
                }
            }
            public var query: Operations.listFiles.Input.Query
            /// - Remark: Generated from `#/paths/files/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFiles.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFiles.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listFiles.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.listFiles.Input.Query = .init(),
                headers: Operations.listFiles.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/files/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListFilesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListFilesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listFiles.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listFiles.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//files/get(listFiles)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listFiles.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listFiles.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Upload a file that can be used across various endpoints/features. The size of all the files uploaded by one organization can be up to 100 GB.
    ///
    /// The size of individual files for can be a maximum of 512MB. See the [Assistants Tools guide](/docs/assistants/tools) to learn more about the types of files supported. The Fine-tuning API only supports `.jsonl` files.
    ///
    /// Please [contact us](https://help.openai.com/) if you need to increase these storage limits.
    ///
    ///
    /// - Remark: HTTP `POST /files`.
    /// - Remark: Generated from `#/paths//files/post(createFile)`.
    public enum createFile {
        public static let id: Swift.String = "createFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/files/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createFile.Input.Headers
            /// - Remark: Generated from `#/paths/files/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/POST/requestBody/content/multipart\/form-data`.
                case multipartForm(
                    OpenAPIRuntime.MultipartBody<Components.Schemas.CreateFileRequest>)
            }
            public var body: Operations.createFile.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createFile.Input.Headers = .init(),
                body: Operations.createFile.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/files/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.OpenAIFile)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OpenAIFile {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//files/post(createFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns information about a specific file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/get(retrieveFile)`.
    public enum retrieveFile {
        public static let id: Swift.String = "retrieveFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/files/{file_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the file to use for this request.
                ///
                /// - Remark: Generated from `#/paths/files/{file_id}/GET/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - file_id: The ID of the file to use for this request.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
            }
            public var path: Operations.retrieveFile.Input.Path
            /// - Remark: Generated from `#/paths/files/{file_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.retrieveFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.retrieveFile.Input.Path,
                headers: Operations.retrieveFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/{file_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/files/{file_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.OpenAIFile)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.OpenAIFile {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.retrieveFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.retrieveFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//files/{file_id}/get(retrieveFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.retrieveFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.retrieveFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a file.
    ///
    /// - Remark: HTTP `DELETE /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/delete(deleteFile)`.
    public enum deleteFile {
        public static let id: Swift.String = "deleteFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/files/{file_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the file to use for this request.
                ///
                /// - Remark: Generated from `#/paths/files/{file_id}/DELETE/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - file_id: The ID of the file to use for this request.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
            }
            public var path: Operations.deleteFile.Input.Path
            /// - Remark: Generated from `#/paths/files/{file_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.deleteFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.deleteFile.Input.Path,
                headers: Operations.deleteFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/{file_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/files/{file_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.DeleteFileResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DeleteFileResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.deleteFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.deleteFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//files/{file_id}/delete(deleteFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.deleteFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.deleteFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns the contents of the specified file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}/content`.
    /// - Remark: Generated from `#/paths//files/{file_id}/content/get(downloadFile)`.
    public enum downloadFile {
        public static let id: Swift.String = "downloadFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/files/{file_id}/content/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the file to use for this request.
                ///
                /// - Remark: Generated from `#/paths/files/{file_id}/content/GET/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - file_id: The ID of the file to use for this request.
                public init(file_id: Swift.String) {
                    self.file_id = file_id
                }
            }
            public var path: Operations.downloadFile.Input.Path
            /// - Remark: Generated from `#/paths/files/{file_id}/content/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.downloadFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.downloadFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.downloadFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.downloadFile.Input.Path,
                headers: Operations.downloadFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/files/{file_id}/content/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/files/{file_id}/content/GET/responses/200/content/application\/json`.
                    case json(Swift.String)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Swift.String {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.downloadFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.downloadFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//files/{file_id}/content/get(downloadFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.downloadFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.downloadFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/get(listPaginatedFineTuningJobs)`.
    public enum listPaginatedFineTuningJobs {
        public static let id: Swift.String = "listPaginatedFineTuningJobs"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Identifier for the last job from the previous pagination request.
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/query/after`.
                public var after: Swift.String?
                /// Number of fine-tuning jobs to retrieve.
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/query/limit`.
                public var limit: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - after: Identifier for the last job from the previous pagination request.
                ///   - limit: Number of fine-tuning jobs to retrieve.
                public init(
                    after: Swift.String? = nil,
                    limit: Swift.Int? = nil
                ) {
                    self.after = after
                    self.limit = limit
                }
            }
            public var query: Operations.listPaginatedFineTuningJobs.Input.Query
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listPaginatedFineTuningJobs.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listPaginatedFineTuningJobs.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listPaginatedFineTuningJobs.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.listPaginatedFineTuningJobs.Input.Query = .init(),
                headers: Operations.listPaginatedFineTuningJobs.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine_tuning/jobs/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListPaginatedFineTuningJobsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListPaginatedFineTuningJobsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listPaginatedFineTuningJobs.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listPaginatedFineTuningJobs.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine_tuning/jobs/get(listPaginatedFineTuningJobs)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listPaginatedFineTuningJobs.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listPaginatedFineTuningJobs.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/post(createFineTuningJob)`.
    public enum createFineTuningJob {
        public static let id: Swift.String = "createFineTuningJob"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFineTuningJob.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFineTuningJob.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createFineTuningJob.Input.Headers
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateFineTuningJobRequest)
            }
            public var body: Operations.createFineTuningJob.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createFineTuningJob.Input.Headers = .init(),
                body: Operations.createFineTuningJob.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine_tuning/jobs/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTuningJob)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTuningJob {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createFineTuningJob.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createFineTuningJob.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine_tuning/jobs/post(createFineTuningJob)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createFineTuningJob.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createFineTuningJob.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get info about a fine-tuning job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/get(retrieveFineTuningJob)`.
    public enum retrieveFineTuningJob {
        public static let id: Swift.String = "retrieveFineTuningJob"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tuning job.
                ///
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/GET/path/fine_tuning_job_id`.
                public var fine_tuning_job_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tuning_job_id: The ID of the fine-tuning job.
                public init(fine_tuning_job_id: Swift.String) {
                    self.fine_tuning_job_id = fine_tuning_job_id
                }
            }
            public var path: Operations.retrieveFineTuningJob.Input.Path
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFineTuningJob.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFineTuningJob.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.retrieveFineTuningJob.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.retrieveFineTuningJob.Input.Path,
                headers: Operations.retrieveFineTuningJob.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTuningJob)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTuningJob {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.retrieveFineTuningJob.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.retrieveFineTuningJob.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/get(retrieveFineTuningJob)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.retrieveFineTuningJob.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.retrieveFineTuningJob.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get status updates for a fine-tuning job.
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}/events`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/events/get(listFineTuningEvents)`.
    public enum listFineTuningEvents {
        public static let id: Swift.String = "listFineTuningEvents"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tuning job to get events for.
                ///
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/path/fine_tuning_job_id`.
                public var fine_tuning_job_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tuning_job_id: The ID of the fine-tuning job to get events for.
                public init(fine_tuning_job_id: Swift.String) {
                    self.fine_tuning_job_id = fine_tuning_job_id
                }
            }
            public var path: Operations.listFineTuningEvents.Input.Path
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Identifier for the last event from the previous pagination request.
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/query/after`.
                public var after: Swift.String?
                /// Number of events to retrieve.
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/query/limit`.
                public var limit: Swift.Int?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - after: Identifier for the last event from the previous pagination request.
                ///   - limit: Number of events to retrieve.
                public init(
                    after: Swift.String? = nil,
                    limit: Swift.Int? = nil
                ) {
                    self.after = after
                    self.limit = limit
                }
            }
            public var query: Operations.listFineTuningEvents.Input.Query
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTuningEvents.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTuningEvents.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listFineTuningEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listFineTuningEvents.Input.Path,
                query: Operations.listFineTuningEvents.Input.Query = .init(),
                headers: Operations.listFineTuningEvents.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/events/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListFineTuningJobEventsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListFineTuningJobEventsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listFineTuningEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listFineTuningEvents.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/events/get(listFineTuningEvents)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listFineTuningEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listFineTuningEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs/{fine_tuning_job_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/cancel/post(cancelFineTuningJob)`.
    public enum cancelFineTuningJob {
        public static let id: Swift.String = "cancelFineTuningJob"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/cancel/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tuning job to cancel.
                ///
                ///
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/cancel/POST/path/fine_tuning_job_id`.
                public var fine_tuning_job_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tuning_job_id: The ID of the fine-tuning job to cancel.
                public init(fine_tuning_job_id: Swift.String) {
                    self.fine_tuning_job_id = fine_tuning_job_id
                }
            }
            public var path: Operations.cancelFineTuningJob.Input.Path
            /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/cancel/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelFineTuningJob.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelFineTuningJob.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.cancelFineTuningJob.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.cancelFineTuningJob.Input.Path,
                headers: Operations.cancelFineTuningJob.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/cancel/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine_tuning/jobs/{fine_tuning_job_id}/cancel/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTuningJob)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTuningJob {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.cancelFineTuningJob.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.cancelFineTuningJob.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/cancel/post(cancelFineTuningJob)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.cancelFineTuningJob.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.cancelFineTuningJob.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/get(listFineTunes)`.
    public enum listFineTunes {
        public static let id: Swift.String = "listFineTunes"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine-tunes/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTunes.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTunes.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listFineTunes.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.listFineTunes.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine-tunes/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListFineTunesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListFineTunesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listFineTunes.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listFineTunes.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine-tunes/get(listFineTunes)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listFineTunes.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listFineTunes.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/post(createFineTune)`.
    public enum createFineTune {
        public static let id: Swift.String = "createFineTune"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine-tunes/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFineTune.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createFineTune.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createFineTune.Input.Headers
            /// - Remark: Generated from `#/paths/fine-tunes/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateFineTuneRequest)
            }
            public var body: Operations.createFineTune.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createFineTune.Input.Headers = .init(),
                body: Operations.createFineTune.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine-tunes/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTune)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTune {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createFineTune.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createFineTune.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine-tunes/post(createFineTune)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createFineTune.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createFineTune.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Gets info about the fine-tune job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/get(retrieveFineTune)`.
    public enum retrieveFineTune {
        public static let id: Swift.String = "retrieveFineTune"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tune job
                ///
                ///
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/GET/path/fine_tune_id`.
                public var fine_tune_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tune_id: The ID of the fine-tune job
                public init(fine_tune_id: Swift.String) {
                    self.fine_tune_id = fine_tune_id
                }
            }
            public var path: Operations.retrieveFineTune.Input.Path
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFineTune.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveFineTune.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.retrieveFineTune.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.retrieveFineTune.Input.Path,
                headers: Operations.retrieveFineTune.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTune)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTune {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.retrieveFineTune.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.retrieveFineTune.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/get(retrieveFineTune)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.retrieveFineTune.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.retrieveFineTune.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes/{fine_tune_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/cancel/post(cancelFineTune)`.
    public enum cancelFineTune {
        public static let id: Swift.String = "cancelFineTune"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/cancel/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tune job to cancel
                ///
                ///
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/cancel/POST/path/fine_tune_id`.
                public var fine_tune_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tune_id: The ID of the fine-tune job to cancel
                public init(fine_tune_id: Swift.String) {
                    self.fine_tune_id = fine_tune_id
                }
            }
            public var path: Operations.cancelFineTune.Input.Path
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/cancel/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelFineTune.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelFineTune.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.cancelFineTune.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.cancelFineTune.Input.Path,
                headers: Operations.cancelFineTune.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/cancel/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/cancel/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.FineTune)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.FineTune {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.cancelFineTune.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.cancelFineTune.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/cancel/post(cancelFineTune)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.cancelFineTune.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.cancelFineTune.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Get fine-grained status updates for a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}/events`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/events/get(listFineTuneEvents)`.
    public enum listFineTuneEvents {
        public static let id: Swift.String = "listFineTuneEvents"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the fine-tune job to get events for.
                ///
                ///
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/path/fine_tune_id`.
                public var fine_tune_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - fine_tune_id: The ID of the fine-tune job to get events for.
                public init(fine_tune_id: Swift.String) {
                    self.fine_tune_id = fine_tune_id
                }
            }
            public var path: Operations.listFineTuneEvents.Input.Path
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/query`.
            public struct Query: Sendable, Hashable {
                /// Whether to stream events for the fine-tune job. If set to true,
                /// events will be sent as data-only
                /// [server-sent events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events#Event_stream_format)
                /// as they become available. The stream will terminate with a
                /// `data: [DONE]` message when the job is finished (succeeded, cancelled,
                /// or failed).
                ///
                /// If set to false, only events generated so far will be returned.
                ///
                ///
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/query/stream`.
                public var stream: Swift.Bool?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - stream: Whether to stream events for the fine-tune job. If set to true,
                public init(stream: Swift.Bool? = nil) {
                    self.stream = stream
                }
            }
            public var query: Operations.listFineTuneEvents.Input.Query
            /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTuneEvents.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listFineTuneEvents.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listFineTuneEvents.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listFineTuneEvents.Input.Path,
                query: Operations.listFineTuneEvents.Input.Query = .init(),
                headers: Operations.listFineTuneEvents.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/fine-tunes/{fine_tune_id}/events/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListFineTuneEventsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListFineTuneEventsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listFineTuneEvents.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listFineTuneEvents.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/events/get(listFineTuneEvents)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listFineTuneEvents.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listFineTuneEvents.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Lists the currently available models, and provides basic information about each one such as the owner and availability.
    ///
    /// - Remark: HTTP `GET /models`.
    /// - Remark: Generated from `#/paths//models/get(listModels)`.
    public enum listModels {
        public static let id: Swift.String = "listModels"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/models/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listModels.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listModels.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listModels.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            public init(headers: Operations.listModels.Input.Headers = .init()) {
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/models/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/models/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListModelsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListModelsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listModels.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listModels.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//models/get(listModels)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listModels.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listModels.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
    ///
    /// - Remark: HTTP `GET /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/get(retrieveModel)`.
    public enum retrieveModel {
        public static let id: Swift.String = "retrieveModel"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/models/{model}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the model to use for this request
                ///
                /// - Remark: Generated from `#/paths/models/{model}/GET/path/model`.
                public var model: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - model: The ID of the model to use for this request
                public init(model: Swift.String) {
                    self.model = model
                }
            }
            public var path: Operations.retrieveModel.Input.Path
            /// - Remark: Generated from `#/paths/models/{model}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveModel.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.retrieveModel.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.retrieveModel.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.retrieveModel.Input.Path,
                headers: Operations.retrieveModel.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/models/{model}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/models/{model}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.Model)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.Model {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.retrieveModel.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.retrieveModel.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//models/{model}/get(retrieveModel)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.retrieveModel.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.retrieveModel.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a fine-tuned model. You must have the Owner role in your organization to delete a model.
    ///
    /// - Remark: HTTP `DELETE /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/delete(deleteModel)`.
    public enum deleteModel {
        public static let id: Swift.String = "deleteModel"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/models/{model}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The model to delete
                ///
                /// - Remark: Generated from `#/paths/models/{model}/DELETE/path/model`.
                public var model: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - model: The model to delete
                public init(model: Swift.String) {
                    self.model = model
                }
            }
            public var path: Operations.deleteModel.Input.Path
            /// - Remark: Generated from `#/paths/models/{model}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteModel.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteModel.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.deleteModel.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.deleteModel.Input.Path,
                headers: Operations.deleteModel.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/models/{model}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/models/{model}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.DeleteModelResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DeleteModelResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.deleteModel.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.deleteModel.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//models/{model}/delete(deleteModel)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.deleteModel.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.deleteModel.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Classifies if text violates OpenAI's Content Policy
    ///
    /// - Remark: HTTP `POST /moderations`.
    /// - Remark: Generated from `#/paths//moderations/post(createModeration)`.
    public enum createModeration {
        public static let id: Swift.String = "createModeration"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/moderations/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createModeration.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createModeration.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createModeration.Input.Headers
            /// - Remark: Generated from `#/paths/moderations/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/moderations/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateModerationRequest)
            }
            public var body: Operations.createModeration.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createModeration.Input.Headers = .init(),
                body: Operations.createModeration.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/moderations/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/moderations/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.CreateModerationResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.CreateModerationResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createModeration.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createModeration.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//moderations/post(createModeration)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createModeration.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createModeration.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of assistants.
    ///
    /// - Remark: HTTP `GET /assistants`.
    /// - Remark: Generated from `#/paths//assistants/get(listAssistants)`.
    public enum listAssistants {
        public static let id: Swift.String = "listAssistants"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/assistants/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/GET/query/order`.
                public var order: Operations.listAssistants.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listAssistants.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listAssistants.Input.Query
            /// - Remark: Generated from `#/paths/assistants/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listAssistants.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listAssistants.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listAssistants.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - query:
            ///   - headers:
            public init(
                query: Operations.listAssistants.Input.Query = .init(),
                headers: Operations.listAssistants.Input.Headers = .init()
            ) {
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListAssistantsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListAssistantsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listAssistants.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listAssistants.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/get(listAssistants)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listAssistants.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listAssistants.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an assistant with a model and instructions.
    ///
    /// - Remark: HTTP `POST /assistants`.
    /// - Remark: Generated from `#/paths//assistants/post(createAssistant)`.
    public enum createAssistant {
        public static let id: Swift.String = "createAssistant"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createAssistant.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createAssistant.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createAssistant.Input.Headers
            /// - Remark: Generated from `#/paths/assistants/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateAssistantRequest)
            }
            public var body: Operations.createAssistant.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createAssistant.Input.Headers = .init(),
                body: Operations.createAssistant.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.AssistantObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.AssistantObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createAssistant.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createAssistant.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/post(createAssistant)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createAssistant.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createAssistant.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves an assistant.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/get(getAssistant)`.
    public enum getAssistant {
        public static let id: Swift.String = "getAssistant"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant to retrieve.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/GET/path/assistant_id`.
                public var assistant_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant to retrieve.
                public init(assistant_id: Swift.String) {
                    self.assistant_id = assistant_id
                }
            }
            public var path: Operations.getAssistant.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getAssistant.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getAssistant.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getAssistant.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getAssistant.Input.Path,
                headers: Operations.getAssistant.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.AssistantObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.AssistantObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getAssistant.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getAssistant.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/get(getAssistant)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getAssistant.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getAssistant.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Modifies an assistant.
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/post(modifyAssistant)`.
    public enum modifyAssistant {
        public static let id: Swift.String = "modifyAssistant"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant to modify.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/path/assistant_id`.
                public var assistant_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant to modify.
                public init(assistant_id: Swift.String) {
                    self.assistant_id = assistant_id
                }
            }
            public var path: Operations.modifyAssistant.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyAssistant.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyAssistant.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.modifyAssistant.Input.Headers
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.ModifyAssistantRequest)
            }
            public var body: Operations.modifyAssistant.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.modifyAssistant.Input.Path,
                headers: Operations.modifyAssistant.Input.Headers = .init(),
                body: Operations.modifyAssistant.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.AssistantObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.AssistantObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.modifyAssistant.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.modifyAssistant.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/post(modifyAssistant)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.modifyAssistant.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.modifyAssistant.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an assistant.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/delete(deleteAssistant)`.
    public enum deleteAssistant {
        public static let id: Swift.String = "deleteAssistant"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant to delete.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/DELETE/path/assistant_id`.
                public var assistant_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant to delete.
                public init(assistant_id: Swift.String) {
                    self.assistant_id = assistant_id
                }
            }
            public var path: Operations.deleteAssistant.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteAssistant.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteAssistant.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.deleteAssistant.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.deleteAssistant.Input.Path,
                headers: Operations.deleteAssistant.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.DeleteAssistantResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DeleteAssistantResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.deleteAssistant.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.deleteAssistant.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/delete(deleteAssistant)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.deleteAssistant.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.deleteAssistant.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a thread.
    ///
    /// - Remark: HTTP `POST /threads`.
    /// - Remark: Generated from `#/paths//threads/post(createThread)`.
    public enum createThread {
        public static let id: Swift.String = "createThread"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createThread.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createThread.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createThread.Input.Headers
            /// - Remark: Generated from `#/paths/threads/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateThreadRequest)
            }
            public var body: Operations.createThread.Input.Body?
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createThread.Input.Headers = .init(),
                body: Operations.createThread.Input.Body? = nil
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.ThreadObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ThreadObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createThread.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createThread.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/post(createThread)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createThread.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createThread.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/get(getThread)`.
    public enum getThread {
        public static let id: Swift.String = "getThread"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to retrieve.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to retrieve.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.getThread.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getThread.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getThread.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getThread.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getThread.Input.Path,
                headers: Operations.getThread.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ThreadObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ThreadObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getThread.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getThread.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/get(getThread)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getThread.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getThread.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Modifies a thread.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/post(modifyThread)`.
    public enum modifyThread {
        public static let id: Swift.String = "modifyThread"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to modify. Only the `metadata` can be modified.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to modify. Only the `metadata` can be modified.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.modifyThread.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyThread.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyThread.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.modifyThread.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.ModifyThreadRequest)
            }
            public var body: Operations.modifyThread.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.modifyThread.Input.Path,
                headers: Operations.modifyThread.Input.Headers = .init(),
                body: Operations.modifyThread.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.ThreadObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ThreadObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.modifyThread.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.modifyThread.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/post(modifyThread)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.modifyThread.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.modifyThread.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete a thread.
    ///
    /// - Remark: HTTP `DELETE /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/delete(deleteThread)`.
    public enum deleteThread {
        public static let id: Swift.String = "deleteThread"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to delete.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/DELETE/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to delete.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.deleteThread.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteThread.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteThread.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.deleteThread.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.deleteThread.Input.Path,
                headers: Operations.deleteThread.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.DeleteThreadResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DeleteThreadResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.deleteThread.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.deleteThread.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/delete(deleteThread)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.deleteThread.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.deleteThread.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of messages for a given thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/get(listMessages)`.
    public enum listMessages {
        public static let id: Swift.String = "listMessages"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) the messages belong to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) the messages belong to.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.listMessages.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query/order`.
                public var order: Operations.listMessages.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listMessages.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listMessages.Input.Query
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listMessages.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listMessages.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listMessages.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listMessages.Input.Path,
                query: Operations.listMessages.Input.Query = .init(),
                headers: Operations.listMessages.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListMessagesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListMessagesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listMessages.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listMessages.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/get(listMessages)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listMessages.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listMessages.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/post(createMessage)`.
    public enum createMessage {
        public static let id: Swift.String = "createMessage"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) to create a message for.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) to create a message for.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.createMessage.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createMessage.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createMessage.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createMessage.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateMessageRequest)
            }
            public var body: Operations.createMessage.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.createMessage.Input.Path,
                headers: Operations.createMessage.Input.Headers = .init(),
                body: Operations.createMessage.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.MessageObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MessageObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createMessage.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createMessage.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/post(createMessage)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createMessage.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createMessage.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieve a message.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/get(getMessage)`.
    public enum getMessage {
        public static let id: Swift.String = "getMessage"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) to which this message belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the message to retrieve.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/path/message_id`.
                public var message_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) to which this message belongs.
                ///   - message_id: The ID of the message to retrieve.
                public init(
                    thread_id: Swift.String,
                    message_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.message_id = message_id
                }
            }
            public var path: Operations.getMessage.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getMessage.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getMessage.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getMessage.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getMessage.Input.Path,
                headers: Operations.getMessage.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.MessageObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MessageObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getMessage.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getMessage.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/get(getMessage)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getMessage.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getMessage.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Modifies a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/post(modifyMessage)`.
    public enum modifyMessage {
        public static let id: Swift.String = "modifyMessage"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to which this message belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the message to modify.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/path/message_id`.
                public var message_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to which this message belongs.
                ///   - message_id: The ID of the message to modify.
                public init(
                    thread_id: Swift.String,
                    message_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.message_id = message_id
                }
            }
            public var path: Operations.modifyMessage.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyMessage.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyMessage.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.modifyMessage.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.ModifyMessageRequest)
            }
            public var body: Operations.modifyMessage.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.modifyMessage.Input.Path,
                headers: Operations.modifyMessage.Input.Headers = .init(),
                body: Operations.modifyMessage.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.MessageObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MessageObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.modifyMessage.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.modifyMessage.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/post(modifyMessage)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.modifyMessage.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.modifyMessage.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a thread and run it in one request.
    ///
    /// - Remark: HTTP `POST /threads/runs`.
    /// - Remark: Generated from `#/paths//threads/runs/post(createThreadAndRun)`.
    public enum createThreadAndRun {
        public static let id: Swift.String = "createThreadAndRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/runs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createThreadAndRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createThreadAndRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createThreadAndRun.Input.Headers
            /// - Remark: Generated from `#/paths/threads/runs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/runs/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateThreadAndRunRequest)
            }
            public var body: Operations.createThreadAndRun.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - headers:
            ///   - body:
            public init(
                headers: Operations.createThreadAndRun.Input.Headers = .init(),
                body: Operations.createThreadAndRun.Input.Body
            ) {
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/runs/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/runs/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createThreadAndRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createThreadAndRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/runs/post(createThreadAndRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createThreadAndRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createThreadAndRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of runs belonging to a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/get(listRuns)`.
    public enum listRuns {
        public static let id: Swift.String = "listRuns"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread the run belongs to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread the run belongs to.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.listRuns.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query/order`.
                public var order: Operations.listRuns.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listRuns.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listRuns.Input.Query
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listRuns.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listRuns.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listRuns.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listRuns.Input.Path,
                query: Operations.listRuns.Input.Query = .init(),
                headers: Operations.listRuns.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListRunsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListRunsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listRuns.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listRuns.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/get(listRuns)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listRuns.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listRuns.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/post(createRun)`.
    public enum createRun {
        public static let id: Swift.String = "createRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to run.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to run.
                public init(thread_id: Swift.String) {
                    self.thread_id = thread_id
                }
            }
            public var path: Operations.createRun.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createRun.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateRunRequest)
            }
            public var body: Operations.createRun.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.createRun.Input.Path,
                headers: Operations.createRun.Input.Headers = .init(),
                body: Operations.createRun.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/post(createRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/get(getRun)`.
    public enum getRun {
        public static let id: Swift.String = "getRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) that was run.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run to retrieve.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/path/run_id`.
                public var run_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) that was run.
                ///   - run_id: The ID of the run to retrieve.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                }
            }
            public var path: Operations.getRun.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getRun.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getRun.Input.Path,
                headers: Operations.getRun.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/get(getRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Modifies a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/post(modifyRun)`.
    public enum modifyRun {
        public static let id: Swift.String = "modifyRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) that was run.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run to modify.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/path/run_id`.
                public var run_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) that was run.
                ///   - run_id: The ID of the run to modify.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                }
            }
            public var path: Operations.modifyRun.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.modifyRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.modifyRun.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.ModifyRunRequest)
            }
            public var body: Operations.modifyRun.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.modifyRun.Input.Path,
                headers: Operations.modifyRun.Input.Headers = .init(),
                body: Operations.modifyRun.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.modifyRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.modifyRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/post(modifyRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.modifyRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.modifyRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// When a run has the `status: "requires_action"` and `required_action.type` is `submit_tool_outputs`, this endpoint can be used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single request.
    ///
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/submit_tool_outputs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/submit_tool_outputs/post(submitToolOuputsToRun)`.
    public enum submitToolOuputsToRun {
        public static let id: Swift.String = "submitToolOuputsToRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the [thread](/docs/api-reference/threads) to which this run belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run that requires the tool output submission.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/path/run_id`.
                public var run_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the [thread](/docs/api-reference/threads) to which this run belongs.
                ///   - run_id: The ID of the run that requires the tool output submission.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                }
            }
            public var path: Operations.submitToolOuputsToRun.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.submitToolOuputsToRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.submitToolOuputsToRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.submitToolOuputsToRun.Input.Headers
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.SubmitToolOutputsRunRequest)
            }
            public var body: Operations.submitToolOuputsToRun.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.submitToolOuputsToRun.Input.Path,
                headers: Operations.submitToolOuputsToRun.Input.Headers = .init(),
                body: Operations.submitToolOuputsToRun.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/submit_tool_outputs/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.submitToolOuputsToRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.submitToolOuputsToRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/submit_tool_outputs/post(submitToolOuputsToRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.submitToolOuputsToRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.submitToolOuputsToRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Cancels a run that is `in_progress`.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/cancel/post(cancelRun)`.
    public enum cancelRun {
        public static let id: Swift.String = "cancelRun"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to which this run belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run to cancel.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/path/run_id`.
                public var run_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to which this run belongs.
                ///   - run_id: The ID of the run to cancel.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                }
            }
            public var path: Operations.cancelRun.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelRun.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.cancelRun.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.cancelRun.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.cancelRun.Input.Path,
                headers: Operations.cancelRun.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/cancel/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.cancelRun.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.cancelRun.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/cancel/post(cancelRun)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.cancelRun.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.cancelRun.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of run steps belonging to a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/get(listRunSteps)`.
    public enum listRunSteps {
        public static let id: Swift.String = "listRunSteps"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread the run and run steps belong to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run the run steps belong to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/path/run_id`.
                public var run_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread the run and run steps belong to.
                ///   - run_id: The ID of the run the run steps belong to.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                }
            }
            public var path: Operations.listRunSteps.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query/order`.
                public var order: Operations.listRunSteps.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listRunSteps.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listRunSteps.Input.Query
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listRunSteps.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listRunSteps.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listRunSteps.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listRunSteps.Input.Path,
                query: Operations.listRunSteps.Input.Query = .init(),
                headers: Operations.listRunSteps.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListRunStepsResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListRunStepsResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listRunSteps.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listRunSteps.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/get(listRunSteps)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listRunSteps.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listRunSteps.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves a run step.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps/{step_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/{step_id}/get(getRunStep)`.
    public enum getRunStep {
        public static let id: Swift.String = "getRunStep"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to which the run and run step belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the run to which the run step belongs.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/path/run_id`.
                public var run_id: Swift.String
                /// The ID of the run step to retrieve.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/path/step_id`.
                public var step_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to which the run and run step belongs.
                ///   - run_id: The ID of the run to which the run step belongs.
                ///   - step_id: The ID of the run step to retrieve.
                public init(
                    thread_id: Swift.String,
                    run_id: Swift.String,
                    step_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.run_id = run_id
                    self.step_id = step_id
                }
            }
            public var path: Operations.getRunStep.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getRunStep.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getRunStep.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getRunStep.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getRunStep.Input.Path,
                headers: Operations.getRunStep.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/runs/{run_id}/steps/{step_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.RunStepObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.RunStepObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getRunStep.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getRunStep.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/{step_id}/get(getRunStep)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getRunStep.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getRunStep.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of assistant files.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/get(listAssistantFiles)`.
    public enum listAssistantFiles {
        public static let id: Swift.String = "listAssistantFiles"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant the file belongs to.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/path/assistant_id`.
                public var assistant_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant the file belongs to.
                public init(assistant_id: Swift.String) {
                    self.assistant_id = assistant_id
                }
            }
            public var path: Operations.listAssistantFiles.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query/order`.
                public var order: Operations.listAssistantFiles.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listAssistantFiles.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listAssistantFiles.Input.Query
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listAssistantFiles.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listAssistantFiles.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listAssistantFiles.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listAssistantFiles.Input.Path,
                query: Operations.listAssistantFiles.Input.Query = .init(),
                headers: Operations.listAssistantFiles.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListAssistantFilesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListAssistantFilesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listAssistantFiles.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listAssistantFiles.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/get(listAssistantFiles)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listAssistantFiles.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listAssistantFiles.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Create an assistant file by attaching a [File](/docs/api-reference/files) to an [assistant](/docs/api-reference/assistants).
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/post(createAssistantFile)`.
    public enum createAssistantFile {
        public static let id: Swift.String = "createAssistantFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant for which to create a File.
                ///
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/path/assistant_id`.
                public var assistant_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant for which to create a File.
                public init(assistant_id: Swift.String) {
                    self.assistant_id = assistant_id
                }
            }
            public var path: Operations.createAssistantFile.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createAssistantFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.createAssistantFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.createAssistantFile.Input.Headers
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/requestBody`.
            @frozen public enum Body: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/requestBody/content/application\/json`.
                case json(Components.Schemas.CreateAssistantFileRequest)
            }
            public var body: Operations.createAssistantFile.Input.Body
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            ///   - body:
            public init(
                path: Operations.createAssistantFile.Input.Path,
                headers: Operations.createAssistantFile.Input.Headers = .init(),
                body: Operations.createAssistantFile.Input.Body
            ) {
                self.path = path
                self.headers = headers
                self.body = body
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/POST/responses/200/content/application\/json`.
                    case json(Components.Schemas.AssistantFileObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.AssistantFileObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.createAssistantFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.createAssistantFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/post(createAssistantFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.createAssistantFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.createAssistantFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves an AssistantFile.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/get(getAssistantFile)`.
    public enum getAssistantFile {
        public static let id: Swift.String = "getAssistantFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant who the file belongs to.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/path/assistant_id`.
                public var assistant_id: Swift.String
                /// The ID of the file we're getting.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant who the file belongs to.
                ///   - file_id: The ID of the file we're getting.
                public init(
                    assistant_id: Swift.String,
                    file_id: Swift.String
                ) {
                    self.assistant_id = assistant_id
                    self.file_id = file_id
                }
            }
            public var path: Operations.getAssistantFile.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getAssistantFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getAssistantFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getAssistantFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getAssistantFile.Input.Path,
                headers: Operations.getAssistantFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.AssistantFileObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.AssistantFileObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getAssistantFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getAssistantFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/get(getAssistantFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getAssistantFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getAssistantFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Delete an assistant file.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/delete(deleteAssistantFile)`.
    public enum deleteAssistantFile {
        public static let id: Swift.String = "deleteAssistantFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the assistant that the file belongs to.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/path/assistant_id`.
                public var assistant_id: Swift.String
                /// The ID of the file to delete.
                ///
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - assistant_id: The ID of the assistant that the file belongs to.
                ///   - file_id: The ID of the file to delete.
                public init(
                    assistant_id: Swift.String,
                    file_id: Swift.String
                ) {
                    self.assistant_id = assistant_id
                    self.file_id = file_id
                }
            }
            public var path: Operations.deleteAssistantFile.Input.Path
            /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteAssistantFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.deleteAssistantFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.deleteAssistantFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.deleteAssistantFile.Input.Path,
                headers: Operations.deleteAssistantFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/assistants/{assistant_id}/files/{file_id}/DELETE/responses/200/content/application\/json`.
                    case json(Components.Schemas.DeleteAssistantFileResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.DeleteAssistantFileResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.deleteAssistantFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.deleteAssistantFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/delete(deleteAssistantFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.deleteAssistantFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.deleteAssistantFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Returns a list of message files.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/get(listMessageFiles)`.
    public enum listMessageFiles {
        public static let id: Swift.String = "listMessageFiles"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread that the message and files belong to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the message that the files belongs to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/path/message_id`.
                public var message_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread that the message and files belong to.
                ///   - message_id: The ID of the message that the files belongs to.
                public init(
                    thread_id: Swift.String,
                    message_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.message_id = message_id
                }
            }
            public var path: Operations.listMessageFiles.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query`.
            public struct Query: Sendable, Hashable {
                /// A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query/limit`.
                public var limit: Swift.Int?
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query/order`.
                @frozen public enum orderPayload: String, Codable, Hashable, Sendable {
                    case asc = "asc"
                    case desc = "desc"
                }
                /// Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query/order`.
                public var order: Operations.listMessageFiles.Input.Query.orderPayload?
                /// A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query/after`.
                public var after: Swift.String?
                /// A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                ///
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/query/before`.
                public var before: Swift.String?
                /// Creates a new `Query`.
                ///
                /// - Parameters:
                ///   - limit: A limit on the number of objects to be returned. Limit can range between 1 and 100, and the default is 20.
                ///   - order: Sort order by the `created_at` timestamp of the objects. `asc` for ascending order and `desc` for descending order.
                ///   - after: A cursor for use in pagination. `after` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include after=obj_foo in order to fetch the next page of the list.
                ///   - before: A cursor for use in pagination. `before` is an object ID that defines your place in the list. For instance, if you make a list request and receive 100 objects, ending with obj_foo, your subsequent call can include before=obj_foo in order to fetch the previous page of the list.
                public init(
                    limit: Swift.Int? = nil,
                    order: Operations.listMessageFiles.Input.Query.orderPayload? = nil,
                    after: Swift.String? = nil,
                    before: Swift.String? = nil
                ) {
                    self.limit = limit
                    self.order = order
                    self.after = after
                    self.before = before
                }
            }
            public var query: Operations.listMessageFiles.Input.Query
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listMessageFiles.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.listMessageFiles.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.listMessageFiles.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - query:
            ///   - headers:
            public init(
                path: Operations.listMessageFiles.Input.Path,
                query: Operations.listMessageFiles.Input.Query = .init(),
                headers: Operations.listMessageFiles.Input.Headers = .init()
            ) {
                self.path = path
                self.query = query
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.ListMessageFilesResponse)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.ListMessageFilesResponse {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.listMessageFiles.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.listMessageFiles.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/get(listMessageFiles)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.listMessageFiles.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.listMessageFiles.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
    /// Retrieves a message file.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/{file_id}/get(getMessageFile)`.
    public enum getMessageFile {
        public static let id: Swift.String = "getMessageFile"
        public struct Input: Sendable, Hashable {
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/path`.
            public struct Path: Sendable, Hashable {
                /// The ID of the thread to which the message and File belong.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/path/thread_id`.
                public var thread_id: Swift.String
                /// The ID of the message the file belongs to.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/path/message_id`.
                public var message_id: Swift.String
                /// The ID of the file being retrieved.
                ///
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/path/file_id`.
                public var file_id: Swift.String
                /// Creates a new `Path`.
                ///
                /// - Parameters:
                ///   - thread_id: The ID of the thread to which the message and File belong.
                ///   - message_id: The ID of the message the file belongs to.
                ///   - file_id: The ID of the file being retrieved.
                public init(
                    thread_id: Swift.String,
                    message_id: Swift.String,
                    file_id: Swift.String
                ) {
                    self.thread_id = thread_id
                    self.message_id = message_id
                    self.file_id = file_id
                }
            }
            public var path: Operations.getMessageFile.Input.Path
            /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/header`.
            public struct Headers: Sendable, Hashable {
                public var accept:
                    [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getMessageFile.AcceptableContentType
                    >]
                /// Creates a new `Headers`.
                ///
                /// - Parameters:
                ///   - accept:
                public init(
                    accept: [OpenAPIRuntime.AcceptHeaderContentType<
                        Operations.getMessageFile.AcceptableContentType
                    >] = .defaultValues()
                ) {
                    self.accept = accept
                }
            }
            public var headers: Operations.getMessageFile.Input.Headers
            /// Creates a new `Input`.
            ///
            /// - Parameters:
            ///   - path:
            ///   - headers:
            public init(
                path: Operations.getMessageFile.Input.Path,
                headers: Operations.getMessageFile.Input.Headers = .init()
            ) {
                self.path = path
                self.headers = headers
            }
        }
        @frozen public enum Output: Sendable, Hashable {
            public struct Ok: Sendable, Hashable {
                /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/responses/200/content`.
                @frozen public enum Body: Sendable, Hashable {
                    /// - Remark: Generated from `#/paths/threads/{thread_id}/messages/{message_id}/files/{file_id}/GET/responses/200/content/application\/json`.
                    case json(Components.Schemas.MessageFileObject)
                    /// The associated value of the enum case if `self` is `.json`.
                    ///
                    /// - Throws: An error if `self` is not `.json`.
                    /// - SeeAlso: `.json`.
                    public var json: Components.Schemas.MessageFileObject {
                        get throws {
                            switch self {
                            case let .json(body):
                                return body
                            }
                        }
                    }
                }
                /// Received HTTP response body
                public var body: Operations.getMessageFile.Output.Ok.Body
                /// Creates a new `Ok`.
                ///
                /// - Parameters:
                ///   - body: Received HTTP response body
                public init(body: Operations.getMessageFile.Output.Ok.Body) {
                    self.body = body
                }
            }
            /// OK
            ///
            /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/{file_id}/get(getMessageFile)/responses/200`.
            ///
            /// HTTP response code: `200 ok`.
            case ok(Operations.getMessageFile.Output.Ok)
            /// The associated value of the enum case if `self` is `.ok`.
            ///
            /// - Throws: An error if `self` is not `.ok`.
            /// - SeeAlso: `.ok`.
            public var ok: Operations.getMessageFile.Output.Ok {
                get throws {
                    switch self {
                    case let .ok(response):
                        return response
                    default:
                        try throwUnexpectedResponseStatus(
                            expectedStatus: "ok",
                            response: self
                        )
                    }
                }
            }
            /// Undocumented response.
            ///
            /// A response with a code that is not documented in the OpenAPI document.
            case undocumented(statusCode: Swift.Int, OpenAPIRuntime.UndocumentedPayload)
        }
        @frozen public enum AcceptableContentType: AcceptableProtocol {
            case json
            case other(Swift.String)
            public init?(rawValue: Swift.String) {
                switch rawValue.lowercased() {
                case "application/json":
                    self = .json
                default:
                    self = .other(rawValue)
                }
            }
            public var rawValue: Swift.String {
                switch self {
                case let .other(string):
                    return string
                case .json:
                    return "application/json"
                }
            }
            public static var allCases: [Self] {
                [
                    .json
                ]
            }
        }
    }
}
