// Generated by swift-openapi-generator, do not modify.
@_spi(Generated) import OpenAPIRuntime
#if os(Linux)
@preconcurrency import struct Foundation.URL
@preconcurrency import struct Foundation.Data
@preconcurrency import struct Foundation.Date
#else
import struct Foundation.URL
import struct Foundation.Data
import struct Foundation.Date
#endif
import HTTPTypes
/// The OpenAI REST API. Please see https://platform.openai.com/docs/api-reference for more details.
public struct Client: APIProtocol {
    /// The underlying HTTP client.
    private let client: UniversalClient
    /// Creates a new client.
    /// - Parameters:
    ///   - serverURL: The server URL that the client connects to. Any server
    ///   URLs defined in the OpenAPI document are available as static methods
    ///   on the ``Servers`` type.
    ///   - configuration: A set of configuration values for the client.
    ///   - transport: A transport that performs HTTP operations.
    ///   - middlewares: A list of middlewares to call before the transport.
    public init(
        serverURL: Foundation.URL,
        configuration: Configuration = .init(),
        transport: any ClientTransport,
        middlewares: [any ClientMiddleware] = []
    ) {
        self.client = .init(
            serverURL: serverURL,
            configuration: configuration,
            transport: transport,
            middlewares: middlewares
        )
    }
    private var converter: Converter {
        client.converter
    }
    /// Creates a model response for the given chat conversation.
    ///
    /// - Remark: HTTP `POST /chat/completions`.
    /// - Remark: Generated from `#/paths//chat/completions/post(createChatCompletion)`.
    public func createChatCompletion(_ input: Operations.createChatCompletion.Input) async throws -> Operations.createChatCompletion.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createChatCompletion.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/chat/completions",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createChatCompletion.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "text/event-stream",
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "text/event-stream":
                        body = try converter.getResponseBodyAsBinary(
                            OpenAPIRuntime.HTTPBody.self,
                            from: responseBody,
                            transforming: { value in
                                .text_event_hyphen_stream(value)
                            }
                        )
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateChatCompletionResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates a completion for the provided prompt and parameters.
    ///
    /// - Remark: HTTP `POST /completions`.
    /// - Remark: Generated from `#/paths//completions/post(createCompletion)`.
    public func createCompletion(_ input: Operations.createCompletion.Input) async throws -> Operations.createCompletion.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createCompletion.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/completions",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createCompletion.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateCompletionResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates a new edit for the provided input, instruction, and parameters.
    ///
    /// - Remark: HTTP `POST /edits`.
    /// - Remark: Generated from `#/paths//edits/post(createEdit)`.
    @available(*, deprecated)
    public func createEdit(_ input: Operations.createEdit.Input) async throws -> Operations.createEdit.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createEdit.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/edits",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createEdit.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateEditResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates an image given a prompt.
    ///
    /// - Remark: HTTP `POST /images/generations`.
    /// - Remark: Generated from `#/paths//images/generations/post(createImage)`.
    public func createImage(_ input: Operations.createImage.Input) async throws -> Operations.createImage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createImage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/images/generations",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createImage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ImagesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates an edited or extended image given an original image and a prompt.
    ///
    /// - Remark: HTTP `POST /images/edits`.
    /// - Remark: Generated from `#/paths//images/edits/post(createImageEdit)`.
    public func createImageEdit(_ input: Operations.createImageEdit.Input) async throws -> Operations.createImageEdit.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createImageEdit.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/images/edits",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .multipartForm(value):
                    body = try converter.setRequiredRequestBodyAsMultipart(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "multipart/form-data",
                        allowsUnknownParts: true,
                        requiredExactlyOncePartNames: [
                            "image",
                            "prompt"
                        ],
                        requiredAtLeastOncePartNames: [],
                        atMostOncePartNames: [
                            "mask",
                            "model",
                            "n",
                            "response_format",
                            "size",
                            "user"
                        ],
                        zeroOrMoreTimesPartNames: [],
                        encoding: { part in
                            switch part {
                            case let .image(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "image",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .prompt(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "prompt",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .mask(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "mask",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .model(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "model",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .n(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "n",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .size(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "size",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .response_format(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "response_format",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .user(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "user",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .undocumented(value):
                                return value
                            }
                        }
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createImageEdit.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ImagesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates a variation of a given image.
    ///
    /// - Remark: HTTP `POST /images/variations`.
    /// - Remark: Generated from `#/paths//images/variations/post(createImageVariation)`.
    public func createImageVariation(_ input: Operations.createImageVariation.Input) async throws -> Operations.createImageVariation.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createImageVariation.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/images/variations",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .multipartForm(value):
                    body = try converter.setRequiredRequestBodyAsMultipart(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "multipart/form-data",
                        allowsUnknownParts: true,
                        requiredExactlyOncePartNames: [
                            "image"
                        ],
                        requiredAtLeastOncePartNames: [],
                        atMostOncePartNames: [
                            "model",
                            "n",
                            "response_format",
                            "size",
                            "user"
                        ],
                        zeroOrMoreTimesPartNames: [],
                        encoding: { part in
                            switch part {
                            case let .image(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "image",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .model(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "model",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .n(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "n",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .response_format(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "response_format",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .size(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "size",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .user(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "user",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .undocumented(value):
                                return value
                            }
                        }
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createImageVariation.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ImagesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates an embedding vector representing the input text.
    ///
    /// - Remark: HTTP `POST /embeddings`.
    /// - Remark: Generated from `#/paths//embeddings/post(createEmbedding)`.
    public func createEmbedding(_ input: Operations.createEmbedding.Input) async throws -> Operations.createEmbedding.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createEmbedding.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/embeddings",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createEmbedding.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateEmbeddingResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Generates audio from the input text.
    ///
    /// - Remark: HTTP `POST /audio/speech`.
    /// - Remark: Generated from `#/paths//audio/speech/post(createSpeech)`.
    public func createSpeech(_ input: Operations.createSpeech.Input) async throws -> Operations.createSpeech.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createSpeech.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/audio/speech",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let headers: Operations.createSpeech.Output.Ok.Headers = .init(Transfer_hyphen_Encoding: try converter.getOptionalHeaderFieldAsURI(
                        in: response.headerFields,
                        name: "Transfer-Encoding",
                        as: Swift.String.self
                    ))
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createSpeech.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "*/*"
                        ]
                    )
                    switch chosenContentType {
                    case "*/*":
                        body = try converter.getResponseBodyAsBinary(
                            OpenAPIRuntime.HTTPBody.self,
                            from: responseBody,
                            transforming: { value in
                                .any(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(
                        headers: headers,
                        body: body
                    ))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Transcribes audio into the input language.
    ///
    /// - Remark: HTTP `POST /audio/transcriptions`.
    /// - Remark: Generated from `#/paths//audio/transcriptions/post(createTranscription)`.
    public func createTranscription(_ input: Operations.createTranscription.Input) async throws -> Operations.createTranscription.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createTranscription.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/audio/transcriptions",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .multipartForm(value):
                    body = try converter.setRequiredRequestBodyAsMultipart(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "multipart/form-data",
                        allowsUnknownParts: false,
                        requiredExactlyOncePartNames: [
                            "file",
                            "model"
                        ],
                        requiredAtLeastOncePartNames: [],
                        atMostOncePartNames: [
                            "language",
                            "prompt",
                            "response_format",
                            "temperature"
                        ],
                        zeroOrMoreTimesPartNames: [],
                        encoding: { part in
                            switch part {
                            case let .file(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "file",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .model(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "model",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .language(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "language",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .prompt(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "prompt",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .response_format(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "response_format",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .temperature(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "temperature",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            }
                        }
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createTranscription.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateTranscriptionResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Translates audio into English.
    ///
    /// - Remark: HTTP `POST /audio/translations`.
    /// - Remark: Generated from `#/paths//audio/translations/post(createTranslation)`.
    public func createTranslation(_ input: Operations.createTranslation.Input) async throws -> Operations.createTranslation.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createTranslation.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/audio/translations",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .multipartForm(value):
                    body = try converter.setRequiredRequestBodyAsMultipart(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "multipart/form-data",
                        allowsUnknownParts: false,
                        requiredExactlyOncePartNames: [
                            "file",
                            "model"
                        ],
                        requiredAtLeastOncePartNames: [],
                        atMostOncePartNames: [
                            "prompt",
                            "response_format",
                            "temperature"
                        ],
                        zeroOrMoreTimesPartNames: [],
                        encoding: { part in
                            switch part {
                            case let .file(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "file",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .model(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "model",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .prompt(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "prompt",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .response_format(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "response_format",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .temperature(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "temperature",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            }
                        }
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createTranslation.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateTranslationResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of files that belong to the user's organization.
    ///
    /// - Remark: HTTP `GET /files`.
    /// - Remark: Generated from `#/paths//files/get(listFiles)`.
    public func listFiles(_ input: Operations.listFiles.Input) async throws -> Operations.listFiles.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listFiles.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/files",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "purpose",
                    value: input.query.purpose
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listFiles.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListFilesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Upload a file that can be used across various endpoints/features. The size of all the files uploaded by one organization can be up to 100 GB.
    ///
    /// The size of individual files for can be a maximum of 512MB. See the [Assistants Tools guide](/docs/assistants/tools) to learn more about the types of files supported. The Fine-tuning API only supports `.jsonl` files.
    ///
    /// Please [contact us](https://help.openai.com/) if you need to increase these storage limits.
    ///
    ///
    /// - Remark: HTTP `POST /files`.
    /// - Remark: Generated from `#/paths//files/post(createFile)`.
    public func createFile(_ input: Operations.createFile.Input) async throws -> Operations.createFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/files",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .multipartForm(value):
                    body = try converter.setRequiredRequestBodyAsMultipart(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "multipart/form-data",
                        allowsUnknownParts: false,
                        requiredExactlyOncePartNames: [
                            "file",
                            "purpose"
                        ],
                        requiredAtLeastOncePartNames: [],
                        atMostOncePartNames: [],
                        zeroOrMoreTimesPartNames: [],
                        encoding: { part in
                            switch part {
                            case let .file(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "application/octet-stream"
                                )
                                return .init(
                                    name: "file",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            case let .purpose(wrapped):
                                var headerFields: HTTPTypes.HTTPFields = .init()
                                let value = wrapped.payload
                                let body = try converter.setRequiredRequestBodyAsBinary(
                                    value.body,
                                    headerFields: &headerFields,
                                    contentType: "text/plain"
                                )
                                return .init(
                                    name: "purpose",
                                    filename: wrapped.filename,
                                    headerFields: headerFields,
                                    body: body
                                )
                            }
                        }
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OpenAIFile.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns information about a specific file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/get(retrieveFile)`.
    public func retrieveFile(_ input: Operations.retrieveFile.Input) async throws -> Operations.retrieveFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.retrieveFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/files/{}",
                    parameters: [
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.retrieveFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.OpenAIFile.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a file.
    ///
    /// - Remark: HTTP `DELETE /files/{file_id}`.
    /// - Remark: Generated from `#/paths//files/{file_id}/delete(deleteFile)`.
    public func deleteFile(_ input: Operations.deleteFile.Input) async throws -> Operations.deleteFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.deleteFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/files/{}",
                    parameters: [
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.deleteFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.DeleteFileResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns the contents of the specified file.
    ///
    /// - Remark: HTTP `GET /files/{file_id}/content`.
    /// - Remark: Generated from `#/paths//files/{file_id}/content/get(downloadFile)`.
    public func downloadFile(_ input: Operations.downloadFile.Input) async throws -> Operations.downloadFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.downloadFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/files/{}/content",
                    parameters: [
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.downloadFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Swift.String.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/get(listPaginatedFineTuningJobs)`.
    public func listPaginatedFineTuningJobs(_ input: Operations.listPaginatedFineTuningJobs.Input) async throws -> Operations.listPaginatedFineTuningJobs.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listPaginatedFineTuningJobs.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine_tuning/jobs",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listPaginatedFineTuningJobs.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListPaginatedFineTuningJobsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/post(createFineTuningJob)`.
    public func createFineTuningJob(_ input: Operations.createFineTuningJob.Input) async throws -> Operations.createFineTuningJob.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createFineTuningJob.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine_tuning/jobs",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createFineTuningJob.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTuningJob.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get info about a fine-tuning job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/get(retrieveFineTuningJob)`.
    public func retrieveFineTuningJob(_ input: Operations.retrieveFineTuningJob.Input) async throws -> Operations.retrieveFineTuningJob.Output {
        try await client.send(
            input: input,
            forOperation: Operations.retrieveFineTuningJob.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine_tuning/jobs/{}",
                    parameters: [
                        input.path.fine_tuning_job_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.retrieveFineTuningJob.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTuningJob.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get status updates for a fine-tuning job.
    ///
    ///
    /// - Remark: HTTP `GET /fine_tuning/jobs/{fine_tuning_job_id}/events`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/events/get(listFineTuningEvents)`.
    public func listFineTuningEvents(_ input: Operations.listFineTuningEvents.Input) async throws -> Operations.listFineTuningEvents.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listFineTuningEvents.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine_tuning/jobs/{}/events",
                    parameters: [
                        input.path.fine_tuning_job_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listFineTuningEvents.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListFineTuningJobEventsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine_tuning/jobs/{fine_tuning_job_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine_tuning/jobs/{fine_tuning_job_id}/cancel/post(cancelFineTuningJob)`.
    public func cancelFineTuningJob(_ input: Operations.cancelFineTuningJob.Input) async throws -> Operations.cancelFineTuningJob.Output {
        try await client.send(
            input: input,
            forOperation: Operations.cancelFineTuningJob.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine_tuning/jobs/{}/cancel",
                    parameters: [
                        input.path.fine_tuning_job_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.cancelFineTuningJob.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTuningJob.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// List your organization's fine-tuning jobs
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/get(listFineTunes)`.
    @available(*, deprecated)
    public func listFineTunes(_ input: Operations.listFineTunes.Input) async throws -> Operations.listFineTunes.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listFineTunes.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine-tunes",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listFineTunes.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListFineTunesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Creates a job that fine-tunes a specified model from a given dataset.
    ///
    /// Response includes details of the enqueued job including job status and the name of the fine-tuned models once complete.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes`.
    /// - Remark: Generated from `#/paths//fine-tunes/post(createFineTune)`.
    @available(*, deprecated)
    public func createFineTune(_ input: Operations.createFineTune.Input) async throws -> Operations.createFineTune.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createFineTune.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine-tunes",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createFineTune.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTune.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Gets info about the fine-tune job.
    ///
    /// [Learn more about fine-tuning](/docs/guides/legacy-fine-tuning)
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/get(retrieveFineTune)`.
    @available(*, deprecated)
    public func retrieveFineTune(_ input: Operations.retrieveFineTune.Input) async throws -> Operations.retrieveFineTune.Output {
        try await client.send(
            input: input,
            forOperation: Operations.retrieveFineTune.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine-tunes/{}",
                    parameters: [
                        input.path.fine_tune_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.retrieveFineTune.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTune.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Immediately cancel a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `POST /fine-tunes/{fine_tune_id}/cancel`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/cancel/post(cancelFineTune)`.
    @available(*, deprecated)
    public func cancelFineTune(_ input: Operations.cancelFineTune.Input) async throws -> Operations.cancelFineTune.Output {
        try await client.send(
            input: input,
            forOperation: Operations.cancelFineTune.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine-tunes/{}/cancel",
                    parameters: [
                        input.path.fine_tune_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.cancelFineTune.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.FineTune.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Get fine-grained status updates for a fine-tune job.
    ///
    ///
    /// - Remark: HTTP `GET /fine-tunes/{fine_tune_id}/events`.
    /// - Remark: Generated from `#/paths//fine-tunes/{fine_tune_id}/events/get(listFineTuneEvents)`.
    @available(*, deprecated)
    public func listFineTuneEvents(_ input: Operations.listFineTuneEvents.Input) async throws -> Operations.listFineTuneEvents.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listFineTuneEvents.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/fine-tunes/{}/events",
                    parameters: [
                        input.path.fine_tune_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "stream",
                    value: input.query.stream
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listFineTuneEvents.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListFineTuneEventsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Lists the currently available models, and provides basic information about each one such as the owner and availability.
    ///
    /// - Remark: HTTP `GET /models`.
    /// - Remark: Generated from `#/paths//models/get(listModels)`.
    public func listModels(_ input: Operations.listModels.Input) async throws -> Operations.listModels.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listModels.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/models",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listModels.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListModelsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves a model instance, providing basic information about the model such as the owner and permissioning.
    ///
    /// - Remark: HTTP `GET /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/get(retrieveModel)`.
    public func retrieveModel(_ input: Operations.retrieveModel.Input) async throws -> Operations.retrieveModel.Output {
        try await client.send(
            input: input,
            forOperation: Operations.retrieveModel.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/models/{}",
                    parameters: [
                        input.path.model
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.retrieveModel.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.Model.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a fine-tuned model. You must have the Owner role in your organization to delete a model.
    ///
    /// - Remark: HTTP `DELETE /models/{model}`.
    /// - Remark: Generated from `#/paths//models/{model}/delete(deleteModel)`.
    public func deleteModel(_ input: Operations.deleteModel.Input) async throws -> Operations.deleteModel.Output {
        try await client.send(
            input: input,
            forOperation: Operations.deleteModel.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/models/{}",
                    parameters: [
                        input.path.model
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.deleteModel.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.DeleteModelResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Classifies if text violates OpenAI's Content Policy
    ///
    /// - Remark: HTTP `POST /moderations`.
    /// - Remark: Generated from `#/paths//moderations/post(createModeration)`.
    public func createModeration(_ input: Operations.createModeration.Input) async throws -> Operations.createModeration.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createModeration.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/moderations",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createModeration.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.CreateModerationResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of assistants.
    ///
    /// - Remark: HTTP `GET /assistants`.
    /// - Remark: Generated from `#/paths//assistants/get(listAssistants)`.
    public func listAssistants(_ input: Operations.listAssistants.Input) async throws -> Operations.listAssistants.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listAssistants.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listAssistants.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListAssistantsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an assistant with a model and instructions.
    ///
    /// - Remark: HTTP `POST /assistants`.
    /// - Remark: Generated from `#/paths//assistants/post(createAssistant)`.
    public func createAssistant(_ input: Operations.createAssistant.Input) async throws -> Operations.createAssistant.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createAssistant.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createAssistant.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AssistantObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves an assistant.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/get(getAssistant)`.
    public func getAssistant(_ input: Operations.getAssistant.Input) async throws -> Operations.getAssistant.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getAssistant.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}",
                    parameters: [
                        input.path.assistant_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getAssistant.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AssistantObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Modifies an assistant.
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/post(modifyAssistant)`.
    public func modifyAssistant(_ input: Operations.modifyAssistant.Input) async throws -> Operations.modifyAssistant.Output {
        try await client.send(
            input: input,
            forOperation: Operations.modifyAssistant.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}",
                    parameters: [
                        input.path.assistant_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.modifyAssistant.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AssistantObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an assistant.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/delete(deleteAssistant)`.
    public func deleteAssistant(_ input: Operations.deleteAssistant.Input) async throws -> Operations.deleteAssistant.Output {
        try await client.send(
            input: input,
            forOperation: Operations.deleteAssistant.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}",
                    parameters: [
                        input.path.assistant_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.deleteAssistant.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.DeleteAssistantResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a thread.
    ///
    /// - Remark: HTTP `POST /threads`.
    /// - Remark: Generated from `#/paths//threads/post(createThread)`.
    public func createThread(_ input: Operations.createThread.Input) async throws -> Operations.createThread.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createThread.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case .none:
                    body = nil
                case let .json(value):
                    body = try converter.setOptionalRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createThread.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ThreadObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/get(getThread)`.
    public func getThread(_ input: Operations.getThread.Input) async throws -> Operations.getThread.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getThread.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getThread.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ThreadObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Modifies a thread.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/post(modifyThread)`.
    public func modifyThread(_ input: Operations.modifyThread.Input) async throws -> Operations.modifyThread.Output {
        try await client.send(
            input: input,
            forOperation: Operations.modifyThread.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.modifyThread.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ThreadObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete a thread.
    ///
    /// - Remark: HTTP `DELETE /threads/{thread_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/delete(deleteThread)`.
    public func deleteThread(_ input: Operations.deleteThread.Input) async throws -> Operations.deleteThread.Output {
        try await client.send(
            input: input,
            forOperation: Operations.deleteThread.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.deleteThread.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.DeleteThreadResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of messages for a given thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/get(listMessages)`.
    public func listMessages(_ input: Operations.listMessages.Input) async throws -> Operations.listMessages.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listMessages.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listMessages.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListMessagesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/post(createMessage)`.
    public func createMessage(_ input: Operations.createMessage.Input) async throws -> Operations.createMessage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createMessage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createMessage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.MessageObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieve a message.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/get(getMessage)`.
    public func getMessage(_ input: Operations.getMessage.Input) async throws -> Operations.getMessage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getMessage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.message_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getMessage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.MessageObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Modifies a message.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/messages/{message_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/post(modifyMessage)`.
    public func modifyMessage(_ input: Operations.modifyMessage.Input) async throws -> Operations.modifyMessage.Output {
        try await client.send(
            input: input,
            forOperation: Operations.modifyMessage.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.message_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.modifyMessage.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.MessageObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a thread and run it in one request.
    ///
    /// - Remark: HTTP `POST /threads/runs`.
    /// - Remark: Generated from `#/paths//threads/runs/post(createThreadAndRun)`.
    public func createThreadAndRun(_ input: Operations.createThreadAndRun.Input) async throws -> Operations.createThreadAndRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createThreadAndRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/runs",
                    parameters: []
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createThreadAndRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of runs belonging to a thread.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/get(listRuns)`.
    public func listRuns(_ input: Operations.listRuns.Input) async throws -> Operations.listRuns.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listRuns.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listRuns.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListRunsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/post(createRun)`.
    public func createRun(_ input: Operations.createRun.Input) async throws -> Operations.createRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs",
                    parameters: [
                        input.path.thread_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/get(getRun)`.
    public func getRun(_ input: Operations.getRun.Input) async throws -> Operations.getRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Modifies a run.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/post(modifyRun)`.
    public func modifyRun(_ input: Operations.modifyRun.Input) async throws -> Operations.modifyRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.modifyRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.modifyRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// When a run has the `status: "requires_action"` and `required_action.type` is `submit_tool_outputs`, this endpoint can be used to submit the outputs from the tool calls once they're all completed. All outputs must be submitted in a single request.
    ///
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/submit_tool_outputs`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/submit_tool_outputs/post(submitToolOuputsToRun)`.
    public func submitToolOuputsToRun(_ input: Operations.submitToolOuputsToRun.Input) async throws -> Operations.submitToolOuputsToRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.submitToolOuputsToRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}/submit_tool_outputs",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.submitToolOuputsToRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Cancels a run that is `in_progress`.
    ///
    /// - Remark: HTTP `POST /threads/{thread_id}/runs/{run_id}/cancel`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/cancel/post(cancelRun)`.
    public func cancelRun(_ input: Operations.cancelRun.Input) async throws -> Operations.cancelRun.Output {
        try await client.send(
            input: input,
            forOperation: Operations.cancelRun.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}/cancel",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.cancelRun.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of run steps belonging to a run.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/get(listRunSteps)`.
    public func listRunSteps(_ input: Operations.listRunSteps.Input) async throws -> Operations.listRunSteps.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listRunSteps.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}/steps",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listRunSteps.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListRunStepsResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves a run step.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/runs/{run_id}/steps/{step_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/runs/{run_id}/steps/{step_id}/get(getRunStep)`.
    public func getRunStep(_ input: Operations.getRunStep.Input) async throws -> Operations.getRunStep.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getRunStep.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/runs/{}/steps/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.run_id,
                        input.path.step_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getRunStep.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.RunStepObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of assistant files.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/get(listAssistantFiles)`.
    public func listAssistantFiles(_ input: Operations.listAssistantFiles.Input) async throws -> Operations.listAssistantFiles.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listAssistantFiles.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}/files",
                    parameters: [
                        input.path.assistant_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listAssistantFiles.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListAssistantFilesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Create an assistant file by attaching a [File](/docs/api-reference/files) to an [assistant](/docs/api-reference/assistants).
    ///
    /// - Remark: HTTP `POST /assistants/{assistant_id}/files`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/post(createAssistantFile)`.
    public func createAssistantFile(_ input: Operations.createAssistantFile.Input) async throws -> Operations.createAssistantFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.createAssistantFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}/files",
                    parameters: [
                        input.path.assistant_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .post
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                let body: OpenAPIRuntime.HTTPBody?
                switch input.body {
                case let .json(value):
                    body = try converter.setRequiredRequestBodyAsJSON(
                        value,
                        headerFields: &request.headerFields,
                        contentType: "application/json; charset=utf-8"
                    )
                }
                return (request, body)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.createAssistantFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AssistantFileObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves an AssistantFile.
    ///
    /// - Remark: HTTP `GET /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/get(getAssistantFile)`.
    public func getAssistantFile(_ input: Operations.getAssistantFile.Input) async throws -> Operations.getAssistantFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getAssistantFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}/files/{}",
                    parameters: [
                        input.path.assistant_id,
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getAssistantFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.AssistantFileObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Delete an assistant file.
    ///
    /// - Remark: HTTP `DELETE /assistants/{assistant_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//assistants/{assistant_id}/files/{file_id}/delete(deleteAssistantFile)`.
    public func deleteAssistantFile(_ input: Operations.deleteAssistantFile.Input) async throws -> Operations.deleteAssistantFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.deleteAssistantFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/assistants/{}/files/{}",
                    parameters: [
                        input.path.assistant_id,
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .delete
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.deleteAssistantFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.DeleteAssistantFileResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Returns a list of message files.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/get(listMessageFiles)`.
    public func listMessageFiles(_ input: Operations.listMessageFiles.Input) async throws -> Operations.listMessageFiles.Output {
        try await client.send(
            input: input,
            forOperation: Operations.listMessageFiles.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages/{}/files",
                    parameters: [
                        input.path.thread_id,
                        input.path.message_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "limit",
                    value: input.query.limit
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "order",
                    value: input.query.order
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "after",
                    value: input.query.after
                )
                try converter.setQueryItemAsURI(
                    in: &request,
                    style: .form,
                    explode: true,
                    name: "before",
                    value: input.query.before
                )
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.listMessageFiles.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.ListMessageFilesResponse.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
    /// Retrieves a message file.
    ///
    /// - Remark: HTTP `GET /threads/{thread_id}/messages/{message_id}/files/{file_id}`.
    /// - Remark: Generated from `#/paths//threads/{thread_id}/messages/{message_id}/files/{file_id}/get(getMessageFile)`.
    public func getMessageFile(_ input: Operations.getMessageFile.Input) async throws -> Operations.getMessageFile.Output {
        try await client.send(
            input: input,
            forOperation: Operations.getMessageFile.id,
            serializer: { input in
                let path = try converter.renderedPath(
                    template: "/threads/{}/messages/{}/files/{}",
                    parameters: [
                        input.path.thread_id,
                        input.path.message_id,
                        input.path.file_id
                    ]
                )
                var request: HTTPTypes.HTTPRequest = .init(
                    soar_path: path,
                    method: .get
                )
                suppressMutabilityWarning(&request)
                converter.setAcceptHeader(
                    in: &request.headerFields,
                    contentTypes: input.headers.accept
                )
                return (request, nil)
            },
            deserializer: { response, responseBody in
                switch response.status.code {
                case 200:
                    let contentType = converter.extractContentTypeIfPresent(in: response.headerFields)
                    let body: Operations.getMessageFile.Output.Ok.Body
                    let chosenContentType = try converter.bestContentType(
                        received: contentType,
                        options: [
                            "application/json"
                        ]
                    )
                    switch chosenContentType {
                    case "application/json":
                        body = try await converter.getResponseBodyAsJSON(
                            Components.Schemas.MessageFileObject.self,
                            from: responseBody,
                            transforming: { value in
                                .json(value)
                            }
                        )
                    default:
                        preconditionFailure("bestContentType chose an invalid content type.")
                    }
                    return .ok(.init(body: body))
                default:
                    return .undocumented(
                        statusCode: response.status.code,
                        .init(
                            headerFields: response.headerFields,
                            body: responseBody
                        )
                    )
                }
            }
        )
    }
}
