# StartupToolbox
The curated crowdsourced collection of 700+ tools for startups makers.

Created by Alexander Isora ([Telegram](https://t.me/serene_startup), [Twitter](https://twitter.com/alexanderisorax)). Fillied in by the community.


<img width="480" src="https://github.com/alexanderisora/startuptoolbox/blob/master/media/startup-toolbox-header.png">


# Table of contents
- [Website](#website)
	- [Hosted website builders](#hosted-website-builders)
	- [Static generators](#static-generators)
	- [Lead generation](#lead-generation)
- [Design](#design)
	- [Prototypes and wireframes (UX and user flow)](#prototypes-and-wireframes-ux-and-user-flow)
	- [Logo and branding](#logo-and-branding)
	- [Graphics](#graphics)
	- [UI libraries](#ui-libraries)
	- [Data Visualisation, diagrams and infographics](#data-visualisation-diagrams-and-infographics)
	- [Presentations and slides](#presentations-and-slides)
	- [Stocks](#stocks)
		- [Images stocks](#images-stocks)
		- [Icons stocks](#icons-stocks)
		- [Videos stocks](#videos-stocks)
		- [Other stocks](#other-stocks)
	- [Mockups](#mockups)
	- [Other design tools](#other-design-tools)
- [Support and customer communication](#support-and-customer-communication)
	- [Live customer chats](#live-customer-chats)
	- [Helpdesk](#helpdesk)
	- [Onboarding](#onboarding)
	- [Other](#other)
- [Payments, billing and distribution](#payments-billing-and-distribution)
- [User Analytics and Reporting](#user-analytics-and-reporting)
	- [Mobile only](#mobile-only)
- [Business Analytics](#business-analytics)
	- [Finance](#finance)
- [Automation](#automation)
- [HR and Payroll](#hr-and-payroll)
- [Forms and Surveys](#forms-and-surveys)
	- [Endpoints](#endpoints)
	- [Other forms](#other-forms)
- [Tech](#tech)
	- [Status, Monitoring and Ping](#status-monitoring-and-ping)
	- [Bug tracking](#bug-tracking)
	- [Log inspectors](#log-inspectors)
	- [Cloud Hosting](#cloud-hosting)
	- [Scapping check each](#scapping-check-each)
	- [Email services (SMTP and Transactional)](#email-services-smtp-and-transactional)
	- [Deploy](#deploy)
	- [Tech stack explorer](#tech-stack-explorer)
	- [Site performance](#site-performance)
	- [Other tech tools](#other-tech-tools)
- [Product building](#product-building)
	- [Drag-and-drop programming tools](#drag-and-drop-programming-tools)
	- [Comments as a sevice](#comments-as-a-sevice)
	- [Voice and speech recognition](#voice-and-speech-recognition)
	- [Files uploading and processing](#files-uploading-and-processing)
	- [User testing](#user-testing)
- [Marketing and growth](#marketing-and-growth)
	- [Email](#email)
		- [Mailing services](#mailing-services)
		- [Email validators (list verification)](#email-validators-list-verification)
		- [Email templates](#email-templates)
		- [Other email services](#other-email-services)
	- [Blogging](#blogging)
	- [SEO](#seo)
	- [Keyword research tools](#keyword-research-tools)
	- [Content Marketing](#content-marketing)
	- [Growth and marketing automation](#growth-and-marketing-automation)
	- [Paid promotion](#paid-promotion)
	- [Copy](#copy)
	- [Video and animation creation](#video-and-animation-creation)
	- [Social media management (SMM)](#social-media-management-smm)
		- [Planners (content managers and schedulers)](#planners-content-managers-and-schedulers)
		- [Instagram tools](#instagram-tools)
	- [Track mentions](#track-mentions)
	- [affiliate](#affiliate)
	- [referral](#referral)
	- [market research](#market-research)
	- [Paid ads](#paid-ads)
	- [Affiliates](#affiliates)
	- [Other marketing tools](#other-marketing-tools)
- [Collaboration](#collaboration)
	- [project and task management](#project-and-task-management)
	- [Product Roadmaps](#product-roadmaps)
	- [Todo lists](#todo-lists)
	- [team communication](#team-communication)
		- [Video calls, meetings and screen sharing](#video-calls-meetings-and-screen-sharing)
	- [file sharing](#file-sharing)
	- [Screen shots and video capture and sharing](#screen-shots-and-video-capture-and-sharing)
	- [Bug tracking](#bug-tracking-1)
	- [Data, knowledge base, notes and documents](#data-knowledge-base-notes-and-documents)
	- [Email inbox](#email-inbox)
	- [Collective coding](#collective-coding)
	- [Git](#git)
	- [Time tracking](#time-tracking)
	- [Other collaboration tools](#other-collaboration-tools)
- [Build a chatbot](#build-a-chatbot)
- [Domains and naming](#domains-and-naming)
	- [Find a domain name](#find-a-domain-name)
	- [Naming](#naming)
	- [Other](#other-1)
- [Legal, Account and Invoicing](#legal-account-and-invoicing)
	- [GDPR](#gdpr)
	- [Invoicing](#invoicing)
	- [Documents](#documents)
- [Funding](#funding)
	- [Investors and Accelerators](#investors-and-accelerators)
	- [Crowdfunding](#crowdfunding)
- [Sales](#sales)
	- [CRM](#crm)
- [Communities](#communities)
- [Learn](#learn)
	- [Books](#books)
	- [Video](#video)
- [A/B testing](#ab-testing)
- [Launch](#launch)
- [Other](#other-2)
- [Sponsors](#sponsors)
- [Contribute](#contribute)
- [License](#license)



# Website

## Hosted website builders
* [Unicorn Platform](https://unicornplatform.com) [_[PH]_](https://www.producthunt.com/posts/unicorn-platform-v2-0) - Modern landing page builder for startups. Founded by the author of this list 💙
* [ProductHunt Ship](https://www.producthunt.com/ship) [_[PH]_](https://www.producthunt.com/posts/ship-by-product-hunt) - Create a pretty 'coming soon' page to get a more powerful PH launch.
* [Shopify](https://www.shopify.com/) [_[PH]_](https://www.producthunt.com/posts/shopify) - The leading e-commerce site builder with a large ecosystem.
* [Webflow](https://webflow.com) [_[PH]_](https://www.producthunt.com/posts/webflow) - A complicated yet powerful builder for professionals.
* [Weblium](https://weblium.com) [_[PH]_](https://www.producthunt.com/posts/weblium-2-0) - A flexible builder with a nice editor.
* [Landen](https://landen.co) [_[PH]_](https://www.producthunt.com/posts/landen) - An indie project by a talented Canadian solopreneur.
* [Tilda](https://tilda.cc) [_[PH]_](https://www.producthunt.com/posts/tilda-publishing) - Extremely powerful landing page builder from Russia 💙
* [Carrd](https://carrd.co) [_[PH]_](https://www.producthunt.com/posts/carrd) - Slick and cheap site builder. Made by an indie.
* [Strikingly](https://www.strikingly.com/) [_[PH]_](https://www.producthunt.com/posts/strikingly) - An old well-funded website builder created by YC alumni.

## Static generators
* [Frontnd](http://frontnd.io/) [_[PH]_](https://www.producthunt.com/posts/frontnd) - A frontend developer's assistand. Prototype and code faster.
* [Jekyll](https://jekyllrb.com/) [_[PH]_](https://www.producthunt.com/posts/jekyll-2-0) - A static website and blog generator with lots of tempaltes.
* [Designmodo](http://designmodo.com/startup) [_[PH]_](https://www.producthunt.com/posts/startup-3-2) - Beautifully designed yet pricey HTML landing pages.
* [Hugo](https://gohugo.io/) - The fastest static site generator.
* [Gatsby](https://www.gatsbyjs.org/) [_[PH]_](https://www.producthunt.com/posts/gatsby-2) - A React-based framework that helps developers to build websites.

## Lead generation
* [Proof](https://useproof.com/) [_[PH]_](https://www.producthunt.com/posts/proof-7) - Adds some social proof to your website.
* [TrustPulse](https://trustpulse.com/) - Another social proof widget service.


# Design

## Prototypes and wireframes (UX and user flow)
* [Sketch](https://www.sketch.com/) [_[PH]_](https://www.producthunt.com/posts/sketch-40) - Industry leading design toolkit. OSX only.
* [Figma](https://www.figma.com/) [_[PH]_](https://www.producthunt.com/posts/figma-3-0) - Online design tool. Powerful and fast. Written in C++.
* [Adobe XD](https://www.adobe.com/products/xd.html) [_[PH]_](https://www.producthunt.com/posts/adobe-xd-19-0) - Slick design platform. Adobe's effort to stay in trend.
* [Flinto](https://www.flinto.com/) [_[PH]_](https://www.producthunt.com/posts/flinto) - Quickly Create iOS Prototypes.
* [Invision](https://www.invisionapp.com/) [_[PH]_](https://www.producthunt.com/posts/invision) - A prototyping tool for teams. Invision is a well-funded and large company.
* [Marvel](https://marvelapp.com/) [_[PH]_](https://www.producthunt.com/posts/marvel-2-0-2) - All-in-one design solution.
* [Proto](https://proto.io/) [_[PH]_](https://www.producthunt.com/posts/proto-io-6) - Interactive, high-fidelity mobile prototypes.
* [Axure](https://www.axure.com/) - Prototype and build interactions. Provides a Sketch plugin.
* [Mockflow](https://www.mockflow.com/) [_[PH]_](https://www.producthunt.com/posts/mockflow) - Online wireframing tool with a handful of collaborationl integrations.
* [Whimsical](https://whimsical.com/) [_[PH]_](https://www.producthunt.com/posts/whimsical) - Create diagrams, flowcharts and wireframes.
* [Overflow](https://overflow.io/) [_[PH]_](https://www.producthunt.com/posts/overflow) - The user flow diagramming tool for designers.
* [Origami](https://origami.design/) [_[PH]_](https://www.producthunt.com/posts/origami) - A free design prototyping toolkit.
* [Balsamiq](https://balsamiq.com/) [_[PH]_](https://www.producthunt.com/posts/balsamiq-mockups-3) - An old popular prototyping tool.
* [Flowmapp](https://flowmapp.com/) [_[PH]_](https://www.producthunt.com/posts/flowmapp-3) - UX planning tool for creating a visual sitemap.
* [Gloomaps](https://www.gloomaps.com/) - Visual sitemaps made easy.
* [Moqups](https://moqups.com/) [_[PH]_](https://www.producthunt.com/posts/moqups) - Mockup and wireframing tool.

## Logo and branding
* [Brandcrowd's Maker](https://www.brandcrowd.com/maker) - Make a beautiful logo in seconds.
* [Looka](https://looka.com/) - AI-powered platform to create brand assets.
* [Logopony](https://www.logopony.com/) [_[PH]_](https://www.producthunt.com/posts/logopony) - Make your own beautiful logo with AI.
* [Tailorbrands](https://www.tailorbrands.com/) [_[PH]_](https://www.producthunt.com/posts/tailor-brands) - AI logo maker and brand builder.
* [Graphic Springs](https://www.graphicsprings.com/) - Free logo maker (pay for high-resolution assets).
* [Brandbuilder](https://brandbuilder.ai/) - Build a beautiful brand assets online.
* [Hatchful by Shopify](https://hatchful.shopify.com/) [_[PH]_](https://www.producthunt.com/posts/hatchful) - Free stunning logo generator by Shopify.

## Graphics
* [Canva](https://canva.com/) [_[PH]_](https://www.producthunt.com/posts/canva) Amazingly simple graphic design tool💙
* [Pablo by Buffer](https://pablo.buffer.com/) [_[PH]_](https://www.producthunt.com/posts/pablo-by-buffer) - Create engaging images for your social media posts.
* [Designbold](https://www.designbold.com/) - Create a stunning design (posters, social networks etc).
* [Pixteller](https://pixteller.com/) [_[PH]_](https://www.producthunt.com/posts/pixteller) - Free Online Photo & Animation Maker.
* [Stencil](https://getstencil.com/) [_[PH]_](https://www.producthunt.com/posts/stencil) - The fastest way to create and share visual content.
* [Snappa](https://snappa.com) [_[PH]_](https://www.producthunt.com/posts/snappa-2) - Create online graphics in a snap.
* [RemoveBg](https://remove.bg) [_[PH]_](https://www.producthunt.com/posts/remove-bg) Remove the background of any image. API or online 💙
* [EzGIF](https://ezgif.com/) [_[PH]_](https://www.producthunt.com/posts/ezgif) - Resize, crop, and edit GIFs in your browser 💙
* [BannerSnack](https://www.bannersnack.com/) - The Original Online Banner Maker.

## UI libraries
* [Ant.design](https://ant.design) - Stunning ready-to-use ReactJS components library. Sketch files included. By Alibaba 💙
* [Bulma](https://bulma.io/) [_[PH]_](https://www.producthunt.com/posts/bulma) - Neat flexbox-based CSS framework.
* [Bootstrap](https://getbootstrap.com/) - World’s most popular front-end component library.

## Data Visualisation, diagrams and infographics
* [Miro](https://miro.com/) [_[PH]_](https://www.producthunt.com/posts/realtimeboard-3-0) - Enhanced whiteboard. Various use cases. Ex. Realtimeboard 💙
* [Mindmeister](https://www.mindmeister.com/) [_[PH]_](https://www.producthunt.com/posts/mindmeister) - Create and share mind maps on mobile devices or the web.
* [Gliffy](https://www.gliffy.com/) [_[PH]_](https://www.producthunt.com/posts/gliffy) - Create diagrams online. Atlassian prodcuts integration.
* [Lucidchart](https://www.lucidchart.com/) [_[PH]_](https://www.producthunt.com/posts/lucidchart) - Easily draw diagrams & collaborate with others online.
* [Visme](https://www.visme.co/) [_[PH]_](https://www.producthunt.com/posts/visme-3-0) - Create visual content, infographics and presentations.
* [Infogram](https://infogram.com/) [_[PH]_](https://www.producthunt.com/posts/infogram-2-0) - Create data-driven reports, maps and infographics.
* [Xara](https://www.xara.com/) - Create visual and engaging business and marketing documents.
* [Datastudio by Google](https://datastudio.google.com/u/0/) [_[PH]_](https://www.producthunt.com/posts/google-data-studio-3) - Live, interactive reports and dashboards for Google data.
* [Witeboard](https://witeboard.com/) [_[PH]_](https://www.producthunt.com/posts/witeboard) - Witeboard (not wHiteboard) is a real-time whiteboard for a team.

## Presentations and slides
* [Beautiful.ai](https://www.beautiful.ai/) [_[PH]_](https://www.producthunt.com/posts/beautiful-ai) - AI-powered presentations.
* [Shower](https://github.com/shower/shower) [_[PH]_](https://www.producthunt.com/posts/shower) Open source HTML slide creation and presentation engine.
* [Slidecamp](https://www.slidecamp.io/) [_[PH]_](https://www.producthunt.com/posts/slidecamp) - Library of PowerPoint slides to kickstart your presentation.
* [Haikudeck](https://www.haikudeck.com/) [_[PH]_](https://www.producthunt.com/posts/haiku-deck) - Create an amazing presentation on the web, iPad, or iPhone.
* [Visme](https://www.visme.co/) [_[PH]_](https://www.producthunt.com/posts/visme-3-0) - Create interactive online presentations in HTML5.

## Stocks

### Images stocks
* [Unsplash](https://unsplash.com/) [_[PH]_](https://www.producthunt.com/posts/unsplash-5-0) - Free (do whatever you want) high-resolution photos 💙
* [Pexels](https://www.pexels.com/) [_[PH]_](https://www.producthunt.com/posts/pexels-3-0) - Free high quality photos you can use everywhere 💙
* [Everypixel](https://www.everypixel.com/) - AI to find images that suit to your project.
* [Pixabay](https://pixabay.com/) [_[PH]_](https://www.producthunt.com/posts/pixabay-2-0) - Royalty-free high-quality images for commercial use.
* [StockSnap](https://stocksnap.io/) [_[PH]_](https://www.producthunt.com/posts/stocksnap) - Beautiful, free stock photos.
* [Burst by Shopify](https://burst.shopify.com) [_[PH]_](https://www.producthunt.com/posts/burst-2) - Free stock photos for everyone.
* [StickPNG](http://www.stickpng.com/) [_[PH]_](https://www.producthunt.com/posts/stick-png) - Catalogue of free transparent PNGs.
* [Foter](https://foter.com/) - Millions of premium Royalty-Free stock photos.
* [IsoRepublic](https://isorepublic.com/) - Thousands of Free High-Resolution CC0 Photos and Videos.

### Icons stocks
* [Flaticon](https://flaticon.com) [_[PH]_](https://www.producthunt.com/posts/flaticon) - Thousands of free vector icons.
* [Icons8](https://icons8.com/) [_[PH]_](https://www.producthunt.com/posts/icons8-web-app-2-0) - 85,000 icons + powerful icon tools.
* [Linea.io](http://www.linea.io/) - A free outline iconset featuring 730+ Icons 💙
* [Nucleo app](https://www.nucleoapp.com/) [_[PH]_](https://www.producthunt.com/posts/nucleo) - Icon organizer & icon library.
* [TheNounProject](https://thenounproject.com) [_[PH]_](https://www.producthunt.com/posts/the-noun-project) - Big database of icons/symbols.
* [Glyphicons](https://glyphicons.com/) [_[PH]_](https://www.producthunt.com/posts/glyphicons-2-0) - Icons for web & mobile (font, vector, & image based).
* [Iconstore](https://iconstore.co/) [_[PH]_](https://www.producthunt.com/posts/iconstore) - Free icon packs by first-class designers.
* [IconFinder](https://www.iconfinder.com/) [_[PH]_](https://www.producthunt.com/posts/iconfinder) - Awesome icon search engine & marketplace.
* [Icons by Freepik](https://www.freepik.com/popular-icons) - Free icons for designers and developers.
* [Ionicons](https://ionicons.com/) - Beautifully crafted open source icons by the Ionic Framework team.

### Videos stocks
* [Coverr](https://coverr.co/) [_[PH]_](https://www.producthunt.com/posts/coverr-2-0) - Beautiful, free videos for your homepage background.
* [Videos by Pexels](https://www.pexels.com/videos/) [_[PH]_](https://www.producthunt.com/posts/pexels-videos-2-0) - Completely free, high quality stock videos.
* [Videvo](https://www.videvo.net/) [_[PH]_](https://www.producthunt.com/posts/videvo) - Free HD stock footage & motion graphics for any project.
* [Life of Vids](https://www.lifeofvids.com/) - Free videos, clips & loops.
* [Videoblocks](https://www.videoblocks.com/) [_[PH]_](https://www.producthunt.com/posts/videoblocks-by-storyblocks) - Quality stock video clips.
* [Mixkit](https://mixkit.co/) [_[PH]_](https://www.producthunt.com/posts/mixkit) - High-quality stock videos that are completely free.
* [Dissolve](https://dissolve.com/) [_[PH]_](https://www.producthunt.com/posts/dissolve) - Stock footage and photography from inspiring and exclusive.
* [Provideofactory](https://provideofactory.com/) - Unlimited video downloads.

### Other stocks
* [All the Free Stock](https://allthefreestock.com/) - All the free stock images, videos and icons in one location.

## Mockups
* [Artboard Studio](https://artboard.studio/) [_[PH]_](https://www.producthunt.com/posts/artboard-studio-2-0) - Online graphic design app mainly focused on product mockups.
* [ScreenPeek](https://screenpeek.io/) [_[PH]_](https://www.producthunt.com/posts/screenpeek) - Paste URL, create device mockup.
* [ScreenSpace](https://www.screenspace.io/) [_[PH]_](https://www.producthunt.com/posts/screenspace-studio) - Create quality 3D device videos in minutes.

## Other design tools
* [Pttrns](https://pttrns.com/) [_[PH]_](https://www.producthunt.com/posts/pttrns) - iPhone and iPad user interface patterns.
* [Wake](https://wake.com/) - Share, search, store design files.
* [Zeplin](https://zeplin.io/) [_[PH]_](https://www.producthunt.com/posts/zeplin-2-0) - Collaboration & handoff for UI designers/frontend developers.


# Support and customer communication

## Live customer chats
* [Chatra](https://chatra.io) [_[PH]_](https://www.producthunt.com/posts/chatra) - Live chat software done right.
* [Intercom](https://intercom.com) [_[PH]_](https://www.producthunt.com/posts/intercom-4) - Live chat, support, knowledge base and more.
* [Crisp](https://crisp.chat) [_[PH]_](https://www.producthunt.com/posts/crisp-2-0) - Live chat and live support for your product.
* [Olark](https://www.olark.com/) [_[PH]_](https://www.producthunt.com/posts/olark-2-0) - Easy to use live chat software.
* [Drift](https://www.drift.com/) [_[PH]_](https://www.producthunt.com/posts/drift-2-0) - Live chat and bots for leads verification.
* [Small.chat](https://small.chat/) [_[PH]_](https://www.producthunt.com/posts/smallchat-2-0) - Slack app for chatting with visitors to your website.
* [Helpcrunch](https://helpcrunch.com/) [_[PH]_](https://www.producthunt.com/posts/helpcrunch) - Live chat email marketing.
* [Tawk](https://www.tawk.to/) - Free live chat widget (pay only for chat agents if you want).
* [Live Chat by Acquire](https://acquire.io/live-chat) - Live chat and in-app messaging.
* [User](https://user.com/) [_[PH]_](https://www.producthunt.com/posts/user-com) - Affordable marketing automation with quick setup.
* [Tidio](https://www.tidio.com/) - Live chat widget + chat bot builder.
* [Livechat](https://www.livechatinc.com/) [_[PH]_](https://www.producthunt.com/posts/livechat-2) - Live chat and help desk software.
* [Userlike](https://www.userlike.com/en/) [_[PH]_](https://www.producthunt.com/posts/userlike) - Fully customizable live chat for website & mobile support.
* [Facebook Messenger](https://web.facebook.com/business/products/messenger-for-business) - Talk to your customers through Facebook Messenger.

## Helpdesk
* [Freshdesk](https://freshdesk.com/) [_[PH]_](https://www.producthunt.com/posts/freshdesk) - Customer support software with built in survey tool.
* [Zendesk](https://www.zendesk.com/) [_[PH]_](https://www.producthunt.com/posts/zendesk) - Customer service and engagement products.
* [Bubble IQ](https://www.bubbleiq.com/) [_[PH]_](https://www.producthunt.com/posts/bubbleiq) - Integrate Zendesk with Slack to supercharge customer support.
* [Dixa](https://dixa.com/) [_[PH]_](https://www.producthunt.com/posts/dixa) - Support all of your customers from one platform.
* [Kayako](https://www.kayako.com/) [_[PH]_](https://www.producthunt.com/posts/kayako) - Unified customer service platform.
* [Response](https://www.useresponse.com/) - Customer help center and knowledge base.
* [Uservoice](https://www.uservoice.com/) [_[PH]_](https://www.producthunt.com/posts/uservoice) - Collect, rank, and act on customer feedback.
* [Support Bee](https://supportbee.com/) - Ticketing system for collaborative customer support.
* [Help Scout](https://www.helpscout.com/) [_[PH]_](https://www.producthunt.com/posts/help-scout-2-0) - Help desk software for a more human & helpful experience.
* [Elev](https://elev.io/) [_[PH]_](https://www.producthunt.com/posts/elevio-2) - Self-served support & support driven knowledge management.

## Onboarding
* [App Cues](https://www.appcues.com/) [_[PH]_](https://www.producthunt.com/posts/appcues-2-0) - Better user onboarding. Code free.
* [User Guiding](https://userguiding.com/) [_[PH]_](https://www.producthunt.com/posts/userguiding-2-0) - An easy way to show how your product works.
* [Intro JS](https://introjs.com/) [_[PH]_](https://www.producthunt.com/posts/intro-js-v2-0) - Javascript framework for adding guide and screen tips.

## Other support services
* [Instabug](https://instabug.com/) [_[PH]_](https://www.producthunt.com/posts/instabug-2) - Bug reporting and in-app feedback for mobile apps.
* [Canny](https://canny.io/) [_[PH]_](https://www.producthunt.com/posts/canny-3) - The easiest way to collect & manage feedback.
* [Surfly](https://www.surfly.com/) [_[PH]_](https://www.producthunt.com/posts/surfly-2) - Simple, fast, and secure co-browsing.


# Payments, billing and distribution
* [Stripe](https://stripe.com) [_[PH]_](https://www.producthunt.com/posts/stripe-2) - The default payment integration and management.
* [Paddle](https://paddle.com) [_[PH]_](https://www.producthunt.com/posts/paddle) - Everything you need to sell apps and content 💙
* [Gumroad](https://gumroad.com) [_[PH]_](https://www.producthunt.com/posts/gumroad) - Sell anything directly to anyone.
* [Podia](https://podia.com) [_[PH]_](https://www.producthunt.com/posts/podia-2) - Easily sell memberships, online courses & digital downloads.
* [Sellfy](https://sellfy.com) [_[PH]_](https://www.producthunt.com/posts/sellfy-v3) - E-commerce platform for creators.
* [Braintree](https://www.braintreepayments.com/) [_[PH]_](https://www.producthunt.com/posts/braintree) - Accept payments online a division of PayPal.
* [Recurly](https://recurly.com/) [_[PH]_](https://www.producthunt.com/posts/recurly) - Subscription billing automation.
* [Square](https://squareup.com) - Online and offline payment solutions.
* [Paypal](https://paypal.com) [_[PH]_](https://www.producthunt.com/posts/paypal-for-business) - Accept payments online.
* [Dwolla](https://www.dwolla.com/) - Payment platform for technologists.
* [Paymentwall](https://www.paymentwall.com) - Payments platform to accept payments and prevent fraud.
* [Fastspring](https://fastspring.com/) - Subscriptions & payments for companies selling software, content or apps online.


# User Analytics and Reporting
* [Google Analytics](https://analytics.google.com/) - Collect data about your website visitors and their interactions on your website.
* [New Relic](https://newrelic.com/) - Essential business insights.
* [Kissmetrics](https://www.kissmetrics.com/) [_[PH]_](https://www.producthunt.com/posts/kissmetrics-3) - Customer engagement automation.
* [Segment](https://segment.com/) [_[PH]_](https://www.producthunt.com/posts/segment) - Collect your data once, then send it to 200+ tools.
* [Mixpanel](https://mixpanel.com/) [_[PH]_](https://www.producthunt.com/posts/mixpanel-2) - Powerful product analytics.
* [Hotjar](https://www.hotjar.com) [_[PH]_](https://www.producthunt.com/posts/hotjar) - See how your visitors are really using your site.
* [Heap](https://heap.io/) - Captures every web, mobile, and cloud interaction.
* [Keen](https://keen.io/) - Provide analytics dashboards to your customers.
* [Localytics](https://www.localytics.com/) - Collect data and start personalizing your marketing campaigns.
* [Usefathom](https://usefathom.com/) [_[PH]_](https://www.producthunt.com/posts/fathom-analytics) - Simple, trustworthy website analytics.
* [Prodlytic](https://prodlytic.com/) [_[PH]_](https://www.producthunt.com/posts/prodlytic) - Analytics that auto-surfaces, stores, and exports user data.
* [Matomo](https://matomo.org/) [_[PH]_](https://www.producthunt.com/posts/matomo-2) - Open web analytics platform. Ex. Piwik.
* [Inspectlet](https://www.inspectlet.com/) [_[PH]_](https://www.producthunt.com/posts/inspectlet) - Record and watch everything your visitors do.
* [Cyfe](https://www.cyfe.com/) [_[PH]_](https://www.producthunt.com/posts/cyfe) - All-in-one business dashboard.
* [Quantcast](https://www.quantcast.com/) - AI-driven audience insights, targeting and measurement.
* [Tableau](https://www.tableau.com/) - Business intelligence and analytics software.
* [Clari](https://www.clari.com/) - Full funnel accountability across sales, marketing and customer success.
* [Median](https://median.tech/) [_[PH]_](https://www.producthunt.com/posts/median-for-mac) - OSX app for displaying analytics data.
* [Upsight](https://www.upsight.com/) [_[PH]_](https://www.producthunt.com/posts/upsight) - Analytics and ad network for game developers.
* [Smartlook](https://www.smartlook.com/) - Qualitative analytics for websites and mobile apps.
* [Fullstory](https://www.fullstory.com/) [_[PH]_](https://www.producthunt.com/posts/fullstory-2) - See every click, swipe and scroll on your site.
* [Snitcher](https://www.snitcher.com/) [_[PH]_](https://www.producthunt.com/posts/snitcher-2) - See which companies are visiting your website.
* [Count.ly](https://count.ly/) [_[PH]_](https://www.producthunt.com/posts/countly-analytics) - Open source, enterprise mobile & web analytics platform.
* [Woopra](https://www.woopra.com/) [_[PH]_](https://www.producthunt.com/posts/woopra) - Event tracking, funnels and cohort analysis in real time.
* [Taplytics](https://taplytics.com/) [_[PH]_](https://www.producthunt.com/posts/taplytics) - A/B testing for mobile, web & more.
* [Context by Sweetlabs](https://context.sweetlabs.io/google-analytics-annotations-extension/) - Enhanced Google Analytics annotations.

## Mobile only
* [Adjust](https://www.adjust.com/) - Unify all your marketing activities into one powerful platform.
* [Kochava](https://www.kochava.com/) - Mobile attribution platform and mobile app analytics.
* [Appsamurai](https://appsamurai.com/) [_[PH]_](https://www.producthunt.com/posts/app-samurai) - Self-service app marketing tool for startups.
* [Sensortower](https://sensortower.com/) [_[PH]_](https://www.producthunt.com/posts/sensor-tower) - App Marketing made simple, using market intelligence.
* [Applause](https://www.applause.com/) - Test any device/OS combination in the world.
* [Appfigures](https://appfigures.com/) [_[PH]_](https://www.producthunt.com/posts/appfigures-for-iphone) - App analytics and ASO.
* [Appannie](https://www.appannie.com/) [_[PH]_](https://www.producthunt.com/posts/app-annie-for-ios) - App Store and Google Play Analytics client on mobile.
* [Amplitude](https://amplitude.com/) [_[PH]_](https://www.producthunt.com/posts/amplitude-mobile-analytics) - Mobile analytics without worrying about data volume.
* [Apptopia](https://apptopia.com/) [_[PH]_](https://www.producthunt.com/posts/apptopia) - Competitive intelligence for the mobile app economy.
* [Inapptics](https://inapptics.com/) [_[PH]_](https://www.producthunt.com/posts/inapptics-2) - Visually analyze actual user behavior inside your mobile app.
* [Flurry](https://www.flurry.com/) - App analytics for iOS & Android.
* [Marketing Platform by Google](https://marketingplatform.google.com/about) [_[PH]_](https://www.producthunt.com/posts/google-marketing-platform-2) - Google's unified and improved marketing and analytics tools.
* [App Analytics by Apple](https://developer.apple.com/app-store-connect/analytics/) - App’s performance and unique insights with data.
* [Fabric](https://get.fabric.io/) - Understand how your app is doing in real-time.


# Business Analytics
* [Scoro](https://www.scoro.com/) [_[PH]_](https://www.producthunt.com/posts/scoro) - Manage time, sales, finances and reporting in one platform.
* [Baremetrics](https://baremetrics.com/) [_[PH]_](https://www.producthunt.com/posts/baremetrics) - Tool for forecasting the your product's growth.
* [Chartmogul](https://chartmogul.com/) [_[PH]_](https://www.producthunt.com/posts/chartmogul) - Recurring revenue analytics for Stripe, Braintree, Recurly.
* [Vitally](https://vitally.io/) [_[PH]_](https://www.producthunt.com/posts/vitally) - Analytics and insights to drive B2B startup success.

## Finance
* [Poindexter](https://getpoindexter.com/) [_[PH]_](https://www.producthunt.com/posts/poindexter-2) - Automated financial projections for startups.
* [Paperworks](https://paperworks.io/) [_[PH]_](https://www.producthunt.com/posts/paperworks) - All your receipts, invoices, and payments in one place.


# Automation
* [Zapier](https://zapier.com/) [_[PH]_](https://www.producthunt.com/posts/zapier) - Connect and automate 500+ web apps 💙
* [IFTTT](https://ifttt.com/) [_[PH]_](https://www.producthunt.com/posts/ifttt) - Get all your apps and devices talking to each other.
* [Tray](https://tray.io/) [_[PH]_](https://www.producthunt.com/posts/tray-io-2) - Build powerful integrations between any service.
* [Flow by Microsoft](https://flow.microsoft.com/en-us/) [_[PH]_](https://www.producthunt.com/posts/microsoft-flow) - Alternative to IFTTT & Zappier from MS.
* [Automate](https://automate.io/) - Integrate your cloud applications. Automate marketing, sales and business processes.
* [SheetGo](https://www.sheetgo.com/) [_[PH]_](https://www.producthunt.com/posts/sheetgo-workflows) - Create workflows from your spreadsheet.
* [PieSync](https://www.piesync.com/) [_[PH]_](https://www.producthunt.com/posts/piesync) - Two-way sync between your CRM, Google Apps and more.
* [Flowxo](https://flowxo.com/) [_[PH]_](https://www.producthunt.com/posts/flowxo) - Build automated workflows on top of your existing cloud apps.


# HR and Payroll
* [Gusto](https://gusto.com/) [_[PH]_](https://www.producthunt.com/posts/gusto-2) - Payroll, benefits, and HR.
* [Jazzhr](https://www.jazzhr.com/) [_[PH]_](https://www.producthunt.com/posts/jazz-hr) - Streamline every stage of your recruitment process.


# Forms and Surveys
* [Typeform](https://typeform.com) [_[PH]_](https://www.producthunt.com/posts/typeform-v2-beta) - Build beautiful conversational forms, surveys and more.
* [Jotform](https://www.jotform.com/) [_[PH]_](https://www.producthunt.com/posts/jotform-4-0-2) - Build forms on any device.
* [Google Forms](https://www.google.ru/intl/en/forms/about/) - Create online surveys and quizzes and send them to other people.
* [Fieldboom](https://www.fieldboom.com/) - Collect more leads, subscribers and feedback to grow your business faster.
* [Qualaroo](https://qualaroo.com/) [_[PH]_](https://www.producthunt.com/posts/qualaroo) - Realtime feedback platform that helps companies capture customer decisions as they happen.
* [Survicate](https://survicate.com/) [_[PH]_](https://www.producthunt.com/posts/survicate-2-0) - Collect feedback from customers.
* [Metriculator](https://www.metriculator.com/) - Gather actionable feedback from your customers.
* [Paperform](https://paperform.co/) [_[PH]_](https://www.producthunt.com/posts/paperform-v2) - Form builder with intuitive UI.
* [Formsite](https://www.formsite.com/) - Create online forms and surveys.
* [Tellform](https://www.tellform.com/) [_[PH]_](https://www.producthunt.com/posts/tellform) - An opensource alternative to TypeForm.
* [CognitoForms](https://www.cognitoforms.com/) [_[PH]_](https://www.producthunt.com/posts/cognito-forms) - Build advanced forms for any device.
* [SurveyMonkey](https://www.surveymonkey.com/) - Leading survey software.
* [Responster](https://www.responster.com/) - Design and share engaging surveys in minutes.
* [SurveyGizmo](https://www.surveygizmo.com/) - Secure online survey software that empowers.
* [CrowdSignal](https://crowdsignal.com/) - Collect, organize and analyze data from a variety of sources, including social media and mobile.
* [123formbuilder](https://www.123formbuilder.com/) - Build forms & surveys with drag-and-drop in real time.
* [SurveyAnyPlace](https://surveyanyplace.com/) - Interactive questionnaires without the hassle.
* [Formist](https://formist.io/) - Collect feedback. Gather reservations. Take payments.

## Endpoints
* [Getform](https://getform.io/) [_[PH]_](https://www.producthunt.com/posts/getform-2-0) - Form backend platform for designers and developers.
* [Formkeep](https://formkeep.com/) [_[PH]_](https://www.producthunt.com/posts/formkeep) - Form endpoints for designers and developers.

## Other forms
* [Sonadier](https://www.sonadier.com/) [_[PH]_](https://www.producthunt.com/posts/sonadier) - Drag-and-drop editor to build database forms, no programming.


# Tech
## Status, Monitoring and Ping
* [Hyperping](https://hyperping.io/) [_[PH]_](https://www.producthunt.com/posts/hyperping-2-0) - Beautifully simple and reliable uptime monitoring.
* [Updown](https://updown.io/) [_[PH]_](https://www.producthunt.com/posts/updown-io) - Simple and inexpensive website monitoring 💙
* [Rorvswild](https://www.rorvswild.com/) [_[PH]_](https://www.producthunt.com/posts/rorvswild-2) - Performances and errors monitoring for Ruby on Rails apps.
* [Pingdom](https://www.pingdom.com/product/uptime-monitoring/) - Uptime monitoring tests the availability of your website, applications and servers.
* [Cron Hub](https://cronhub.io/) [_[PH]_](https://www.producthunt.com/posts/cronhub) - Painless cron monitoring in a simple dashboard.
* [Website monitoring by Freshworks](https://www.freshworks.com/website-monitoring/) [_[PH]_](https://www.producthunt.com/posts/freshping-by-freshworks) - Website monitoring and status pages.
* [Atatus](https://www.atatus.com/) - Monitor your entire software stack.
* [Statuscake](https://www.statuscake.com/) [_[PH]_](https://www.producthunt.com/posts/statuscake) - Free unlimited website monitoring.
* [Uptimerobot](https://uptimerobot.com/) [_[PH]_](https://www.producthunt.com/posts/uptime-robot-app) - Free uptime monitoring service.

## Bug tracking
* [Rollbar](https://rollbar.com/) [_[PH]_](https://www.producthunt.com/posts/rollbar) - Real-time error tracking for Javascript and more.
* [Sentry](https://sentry.io) [_[PH]_](https://www.producthunt.com/posts/sentry-6) - Open-source error tracking that helps developers monitor and fix crashes in real time 💙
* [Datadog](https://www.datadoghq.com/) [_[PH]_](https://www.producthunt.com/posts/datadog) - Monitor engineering metrics on beautiful dashboards.
* [Bugsnag](https://www.bugsnag.com/) [_[PH]_](https://www.producthunt.com/posts/bugsnag) - Automated crash monitoring for web and mobile apps.
* [Bugsee](https://www.bugsee.com/) [_[PH]_](https://www.producthunt.com/posts/bugsee-2) - See video, network & logs leading up to bugs or crashes. For iOS and Android apps.
* [Logrocket](https://logrocket.com/) [_[PH]_](https://www.producthunt.com/posts/logrocket) - See video, network & logs leading up to bugs in your app.
* [Shake](https://www.shakebugs.com/) [_[PH]_](https://www.producthunt.com/posts/shake-sdk) - Bug reporting and tracking tool for mobile apps.

## Log inspectors
* [Coralogix](https://coralogix.com/) [_[PH]_](https://www.producthunt.com/posts/coralogix-2-0) - Machine learning powered log analytics, made for startups.
* [Logflare](https://logflare.app/) - Affordable log management & event analytics.
* [Papertrail](https://papertrailapp.com/) [_[PH]_](https://www.producthunt.com/posts/papertrail) - Get a flight data recorder for your system & apps 💙

## Cloud Hosting
* [Heroku](https://www.heroku.com/) [_[PH]_](https://www.producthunt.com/posts/heroku) - Cloud application platform. Cut down devops time 💙
* [Firebase by Google](https://firebase.google.com/) [_[PH]_](https://www.producthunt.com/posts/firebase-2) - Hosting, auth, DB and other services for apps.
* [GitHub pages](https://pages.github.com/) [_[PH]_](https://www.producthunt.com/posts/github-pages) - Host a static page for free. With SSL and custom domain.
* [Now.sh](https://zeit.co/now) - Serverless application deployment.
* [Amazon Web Services](https://aws.amazon.com/) - The world's most comprehensive and broadly adopted cloud platform.
* [Microsoft Azure](https://azure.microsoft.com/) - Ever-expanding set of cloud computing services.
* [Digital Ocean](https://www.digitalocean.com/) [_[PH]_](https://www.producthunt.com/posts/digitalocean-2) - Cloud infrastructure provider.
* [Google Cloud](https://cloud.google.com/) - Suite of cloud computing services that runs on the same infrastructure that Google uses internally.
* [OpenShift by Red Hat](http://www.openshift.com/) - Container application platform. Built on Docker and Kubernetes.
* [AppFog](https://console.appfog.com/) - Platform-as-a-service provider of PHP, Ruby, Node.js, and Java solutions.
* [BlueHost](https://www.bluehost.com/) - Reliable hosting provider.
* [Dreamhost](https://www.dreamhost.com/) - Fast, secure & always up web hosting provider.
* [Surge.sh](http://surge.sh/) [_[PH]_](https://www.producthunt.com/posts/surge) - CLI for publishing static web apps to the Surge CDN for free.
* [Netlify](https://www.netlify.com/) [_[PH]_](https://www.producthunt.com/posts/netlify-cms) - Easily deploy modern static websites.
* [Aerobatic](https://www.aerobatic.com/) [_[PH]_](https://www.producthunt.com/posts/aerobatic) - Build feature-rich HTML 5 single page apps in the cloud.
* [GitLab Pages](https://about.gitlab.com/product/pages/) [_[PH]_](https://www.producthunt.com/posts/gitlab-pages) - Websites for your GitLab projects, groups, or user account.
* [Linode](https://www.linode.com/) - Cloud-hosting, backup and other services.

## Scapping check each
* [Import.io](https://www.import.io/) [_[PH]_](https://www.producthunt.com/posts/import-io) - A data extractor that requires no coding.
* [Dexi](https://dexi.io/) - Leading enterprise web scraping software.
* [Parse Hub](https://www.parsehub.com/) [_[PH]_](https://www.producthunt.com/posts/parsehub) - Turn dynamic websites into APIs.
* [80Legs](http://80legs.com/) - Easy web scraping tools and cloud-based web crawling.
* [Scraping Hub](https://scrapinghub.com/) - Open source web scraping tool.
* [Scrapy](https://scrapy.org/) - An open source and collaborative framework for extracting the data from websites.
* [Scraper Chrome Extension](https://chrome.google.com/webstore/detail/scraper/mbigbapnjcgaffohmbkdlecaccepngjd/related) - Scraper gets data out of web pages and into spreadsheets.
* [Web Scraper Chrome Extension](https://chrome.google.com/webstore/detail/web-scraper/jnhgnonknehpejjnehehllkliplmbmhn) - Free web site data extraction tool.

## Email services (SMTP and Transactional)
* [MailGun](http://www.mailgun.com) - API first SMTP service for sending transactional or bulk email 💙
* [SendGrid](https://sendgrid.com/) - Scalable email service for developers and marketers.
* [AWS SES](https://aws.amazon.com/ses/) - Cheap and reliable SMTP service.
* [Mailjet](https://www.mailjet.com/) [_[PH]_](https://www.producthunt.com/posts/mailjet) - Send marketing and transactional emails with one account.
* [Mandrill](http://www.mandrill.com/) - Mandrill is a transactional email API for Mailchimp users.
* [Mail Trap](https://mailtrap.io/) [_[PH]_](https://www.producthunt.com/posts/mailtrap-io) - Fake SMTP. Send Test Emails without spamming real customers.

## Deploy
* [DeployHQ](https://www.deployhq.com/) [_[PH]_](https://www.producthunt.com/posts/deployhq) - Deploy from your repository to your server in minutes.
* [Dokku](https://github.com/dokku/dokku) [_[PH]_](https://www.producthunt.com/posts/dokku) - Docker powered mini-Heroku in around 100 lines of Bash.

## Tech stack explorer
* [Siftery](https://siftery.com/) [_[PH]_](https://www.producthunt.com/posts/siftery) - Share products you use at work. Explore what others are using.
* [Built With](https://builtwith.com/) [_[PH]_](https://www.producthunt.com/posts/built-with) - See technologies behind websites in real-time.
* [Wappalyzer](https://www.wappalyzer.com/) [_[PH]_](https://www.producthunt.com/posts/wappalyzer) - Identify the software used on the websites you visit.
* [Stackshare](https://stackshare.io/) [_[PH]_](https://www.producthunt.com/posts/stackshare-2) - Share your stack, see what other companies are using.

## Site performance
* [Lighthouse](https://developers.google.com/web/tools/lighthouse/) - Automated auditing, performance metrics, and best practices for the web.
* [Google Page Insight](https://developers.google.com/speed/pagespeed/insights) [_[PH]_](https://www.producthunt.com/posts/google-pagespeed-insights) - Measure performance of a page for mobile & desktop devices.
* [Web Page Performance Test](http://www.webpagetest.org/) - Website performance and optimization test.
* [GTMetrix](http://gtmetrix.com/) - Website speed and performance optimization.

## Other tech tools
* [Abstract APIs](https://www.abstractapi.com) - Suite of APIs for everyday needs (validating emails, creating user avatars, calculating VAT, etc).
* [Public APIs list](https://github.com/toddmotto/public-apis) - A collective list of free APIs for use in software and web development.
* [Codacy](https://www.codacy.com/) [_[PH]_](https://www.producthunt.com/posts/codacy-2) - Improve code quality by automating code reviews.
* [Algolia](https://www.algolia.com/) [_[PH]_](https://www.producthunt.com/posts/algolia-hosted-search-api) - Building blocks for creating great search.
* [Cloudflare](https://www.cloudflare.com/) [_[PH]_](https://www.producthunt.com/posts/cloudflare) - The web performance & security company.
* [Let's Encrypt](https://letsencrypt.org/) - Get free SSL. Even *wildcard.


# Product building

## Drag-and-drop programming tools
* [Bubble.is](https://bubble.is/) [_[PH]_](https://www.producthunt.com/posts/bubble-2-0) - Build and host web applications without having to write code.
* [Thunkable](https://thunkable.com/) [_[PH]_](https://www.producthunt.com/posts/thunkable-2) - The platform where anyone can build their own mobile apps.
* [SuperNova](https://supernova.io/) [_[PH]_](https://www.producthunt.com/posts/supernova-v6) - Turn Sketch into iOS, Android, React and Flutter.
* [LightWell](https://lightwell.pro/) [_[PH]_](https://www.producthunt.com/posts/lightwell-2) - A simple tool for creating native iOS apps on Mac.
* [Buildfire](https://buildfire.com/) [_[PH]_](https://www.producthunt.com/posts/buildfire) - App builder for iOS & Android.
* [App Press](https://www.app-press.com/) [_[PH]_](https://www.producthunt.com/posts/app-press) - Build apps code-free. Deploy instantly.
* [Appspotr](https://www.appspotr.com/) [_[PH]_](https://www.producthunt.com/posts/appspotr) - Create, preview & publish your native iOS & Android apps.
* [Appmachine](https://www.appmachine.com/) [_[PH]_](https://www.producthunt.com/posts/appmachine) - Build your own mobile app, no technical knowledge needed.
* [GoodBarber](https://www.goodbarber.com/) - Create a native iOS or Android app and submit it to the stores.
* [Appsgeyser](https://www.appsgeyser.com/) - Create apps for Android without coding.
* [Shoutem](https://new.shoutem.com/) [_[PH]_](https://www.producthunt.com/posts/shoutem-v5) - Create React Native, cross-platform mobile apps easily.
* [Appgyver](https://www.appgyver.com/) [_[PH]_](https://www.producthunt.com/posts/appgyver-composer-2) - Visual builder for rapidly building enterprise apps.
* [Appinstitute](https://appinstitute.com/) [_[PH]_](https://www.producthunt.com/posts/appinstitute) - Create iOS & Android apps quickly with no coding.

## Comments as a sevice
* [Commento](https://commento.io/) - A fast, privacy-focused commenting platform.
* [Disqus](https://disqus.com) - Embeddable commenting platform. Loads tons of tracking scripts.

## Voice and speech recognition
* [VoiceFlow](https://www.voiceflow.com/) [_[PH]_](https://www.producthunt.com/posts/voiceflow-2) - Build voice apps in your browser without coding.
* [Wit.ai](https://wit.ai/) [_[PH]_](https://www.producthunt.com/posts/wit-ai) - Build applications and devices that you can talk or text to.
* [DialogFlow](https://dialogflow.com/) -  Engaging voice and text-based conversational interfaces, such as voice apps and chatbots, powered by AI. Ex api.ai.
* [Textit](https://textit.in/) - Visually build multi-platform messaging & voice bots to engage visitors.

## Files uploading and processing
* [Uploadcare](https://uploadcare.com) [_[PH]_](https://www.producthunt.com/posts/uploadcare-3-0) - File upload and management API for web and mobile apps 💙
* [Filestack](https://www.filestack.com/) [_[PH]_](https://www.producthunt.com/posts/filestack) - A complete file infrastructure for web & mobile apps.
* [Uppy](https://uppy.io/) [_[PH]_](https://www.producthunt.com/posts/uppy) - The next open source file uploader for web browsers.
* [Shubox](https://shubox.io/) [_[PH]_](https://www.producthunt.com/posts/shubox) - Simple, fast, customizable uploads from your web app to S3.

## User testing
* [UserTesting](https://www.usertesting.com/) [_[PH]_](https://www.producthunt.com/posts/usertesting-2) - Get feedback on your website and product.
* [UsabilityHub](https://usabilityhub.com/) [_[PH]_](https://www.producthunt.com/posts/usabilityhub) - Test your designs and mockups on real people.
* [Userbrain](https://userbrain.net/) [_[PH]_](https://www.producthunt.com/posts/userbrain) - Weekly videos of users testing your site.


# Marketing and growth

## Email

### Mailing services
* [Maillerite](https://www.mailerlite.com/) [_[PH]_](https://www.producthunt.com/posts/mailerlite) - Build beautiful email newsletters with drag-and-drop editor. Much cheaper than Mailchimp. 💙
* [Mad Mimi](https://madmimi.com/) - Simple email marketing.
* [Octomail](https://emailoctopus.com/) - Email marketing for less,
via Amazon SES.
* [MailChimp](https://mailchimp.com/) - All-in-one email marketing platform.
* [GetResponce](https://www.getresponse.com/) - Easy email, landing pages, and marketing automation.
* [Elasticmail](https://elasticemail.com/) - Email newsletter service.
* [Benchmarkemail](https://www.benchmarkemail.com/) - Send beautiful, responsive campaigns in minutes with customizable email templates.
* [ActiveCampaign](https://www.activecampaign.com/) - Email Marketing. Marketing Automation. Sales CRM. Messaging.
* [ConvertKit](https://convertkit.com/) [_[PH]_](https://www.producthunt.com/posts/convertkit) - Email marketing software for creators.
* [Aweber](https://www.aweber.com/) - Powefull and simple email marketing.
* [Inbox](https://useinbox.com/) - Send & analyze email marketing campaigns.
* [Revue](https://www.getrevue.co/) [_[PH]_](https://www.producthunt.com/posts/revue-2-0) - The easiest way to create and send a curated newsletter.
* [SendinBlue](https://www.sendinblue.com/) [_[PH]_](https://www.producthunt.com/posts/sendinblue) - Free email marketing solution for entrepreneurs.
* [Elink](https://elink.io/) [_[PH]_](https://www.producthunt.com/posts/elink-2-0-curate-the-web-newsletters-embeds-web-pages) - Turn links into beautiful newsletters & web pages in minutes.

### Email validators (list verification)
* [Proofy](https://proofy.io/) [_[PH]_](https://www.producthunt.com/posts/proofy-2) - Quickly validate and verify your email lists.
* [Verifalia](https://verifalia.com/) - Email list cleaning and real-time email verification service.
* [QuickEmailVerification](https://quickemailverification.com/) - Email Verification Service.
* [Emailable](https://emailable.io/) - Automated email verification.
* [EmailListVerify](https://www.emaillistverify.com/) - Get rid of spam traps, hard bounces, disposable or catch-all emails without breaking your budget.

### Email templates
* [Publicate.it](https://publicate.it/) [_[PH]_](https://www.producthunt.com/posts/publicate-2-0) - Create powerful newsletters & weekly web roundups.
* [Postcards](https://designmodo.com/postcards/) [_[PH]_](https://www.producthunt.com/posts/postcards-2) - Create, edit and manage awesome email newsletters.
* [GoodBits](https://goodbits.io/) [_[PH]_](https://www.producthunt.com/posts/goodbits) - Build email newsletters with drag and drop and send with Goodbits, MailChimp or other with an HTML Export.
* [Stripo.email](https://stripo.email/) [_[PH]_](https://www.producthunt.com/posts/stripo-email) - Free email template builder for designers and developers.
* [Foundation](https://foundation.zurb.com/emails.html) - Responsive HTML emails framework. 
* [Mailto](https://getmailto.com/) - Responsive html email templates to maximize your website sales.

### Other email services
* [ReallyGoodEmails](https://reallygoodemails.com/) - Showcase of email design and resources.
* [Litmus](https://litmus.com/) [_[PH]_](https://www.producthunt.com/posts/litmus) - Test and track your emails.
* [Hull](https://www.hull.io/) - Unify user and account data across tools, databases, and devices.
* [Rich email markup by Google](https://developers.google.com/gmail/markup/) - Increase user engagement with actions in emails.
* [Sendy](https://sendy.co/) [_[PH]_](https://www.producthunt.com/posts/sendy-4) - Send newsletters, 100x cheaper via Amazon SES.
* [UglyEmail](https://uglyemail.com/) [_[PH]_](https://www.producthunt.com/posts/ugly-email) - See if an email is being tracked before you open it in Gmail.
* [Beetle.email](https://beetle.email/) [_[PH]_](https://www.producthunt.com/posts/beetle-email) - Access marketing emails from all the top brands.

## Blogging & publishing
* [Ghost](https://ghost.org/) [_[PH]_](https://www.producthunt.com/posts/ghost-2-0) - Open source publishing platform.
* [teletype.in](https://teletype.in/) [_[PH]_](https://www.producthunt.com/posts/teletype) - A platform for creating corporate blogs.
* [Medium](https://medium.com) [_[PH]_](https://www.producthunt.com/posts/medium-3-0) - Place to read and write.

## SEO
* [Ahrefs](https://ahrefs.com/) [_[PH]_](https://www.producthunt.com/posts/ahrefs) - A powerful service to count and analyze backlinks to a domain.
* [Semrush](https://www.semrush.com/) - Solid SEO toolkit.
* [Moz Tools](https://moz.com/tools) - All your keyword research in one tool.
* [Botify](https://www.botify.com/) [_[PH]_](https://www.producthunt.com/posts/botify) - Unified suite of applications to merge technical SEO, content, and real rankings.
* [SE ranking](https://seranking.com/) [_[PH]_](https://www.producthunt.com/posts/se-ranking-2) - Сloud-based SEO platform for marketers & digital agencies.
* [Oncrawl](https://www.oncrawl.com/) - The technical SEO platform.
* [ContentKing](https://www.contentkingapp.com/) [_[PH]_](https://www.producthunt.com/posts/contentking-2) - Next-generation SEO auditing & content change tracking.
* [DynoMapper](https://dynomapper.com/) - Organize website projects using visual sitemaps, content inventory, content audit, content planning, daily keyword tracking, and website accessibility testing.
* [Varvy](https://varvy.com/) - SEO tool and optimization guide.
* [SERPwatcher](https://serpwatcher.com) [_[PH]_](https://www.producthunt.com/posts/serpwatcher) - SEO tool for tracking keyword positions in Google SERP.
* [RankTracker](https://www.ranktracker.com/) - Research keywords, analyse the competition, and track your search engine ranking.
* [Accuranker](https://www.accuranker.com/) [_[PH]_](https://www.producthunt.com/posts/accuranker) - The world’s fastest keyword rank tracker.
* [Serpbook](https://serpbook.com/) - Tag and categorize keywords for easier client management and faster project setup.
* [Serps](https://serps.com/) - Track thousands of keywords for multiple search engines and languages.
* [Sistrix](https://www.sistrix.com/) - A premier tool used by SEO professionals.
* [AdvancedWebRanking](https://www.advancedwebranking.com/) - Fresh rankings daily, weekly and on demand. For desktop, mobile and local searches.
* [Unamo](https://unamo.com/) - Advanced SEO performance tracking and analytics suite.
* [Google Webmasters](https://www.google.com/webmasters) - Check indexing status and optimize visibility of your website.

## Keyword research tools
* [KeywordsEverywhere](https://keywordseverywhere.com/) [_[PH]_](https://www.producthunt.com/posts/keywords-everywhere-2) - Free browser add-on for keyword volume, CPC & competition.
* [KWfinder](https://kwfinder.com/) [_[PH]_](https://www.producthunt.com/posts/kwfinder) - Find high volume longtail keywords with low SEO competition.
* [KeywordTool](https://keywordtool.io/) [_[PH]_](https://www.producthunt.com/posts/keywordtool-io) - Find great keywords using Google autocomplete.
* [Wordtracker](https://www.wordtracker.com/) - Get competitors' keywords, in-depth PPC and SEO insights, data from Google and more.
* [Serpstat](https://serpstat.com/) [_[PH]_](https://www.producthunt.com/posts/serpstat-2) - Content ideas from autocomplete suggestions.
* [Ubersuggest by Neil Patel](https://neilpatel.com/ubersuggest/) [_[PH]_](https://www.producthunt.com/posts/ubersuggest-3-0) - Ubersuggest is a keyword suggestion tool that now support domain level metrics.

## Content Marketing
* [Buzzsumo](https://buzzsumo.com/) [_[PH]_](https://www.producthunt.com/posts/buzzsumo) - Identify the most shared links and key influencers.
* [Hemingway](http://www.hemingwayapp.com/) [_[PH]_](https://www.producthunt.com/posts/hemingway-editor-3-0) - Make your writing bold and clear, send to Medium or Wordpress.
* [Grammarly](https://www.grammarly.com) [_[PH]_](https://www.producthunt.com/posts/grammarly) - Solves all of your typo problems.
* [AnswerThePublic](http://answerthepublic.com/) - A free visual keyword research and content ideas tool.
* [QuestionDB](https://questiondb.io/) - Enter in a keyword to find the questions that your readers are asking.

## Growth and marketing automation
* [Customer](https://customer.io/) - Send targeted emails, push notifications, and SMS.
* [Adroll](https://www.adroll.com/) [_[PH]_](https://www.producthunt.com/posts/adroll) - Ad re-targetting on mobile and web.
* [Act-on](https://www.act-on.com/) - Marketing automation software and lead generation platform.
* [LeadSquared](https://www.leadsquared.com/) - Makreting automation and CRM software.
* [SalesLoft](https://salesloft.com/) [_[PH]_](https://www.producthunt.com/posts/salesloft) - The sales engagement platform created for salespeople, by salespeople.
* [Mautic](https://www.mautic.org/) [_[PH]_](https://www.producthunt.com/posts/mautic) - Free, open source, marketing automation Highrise alternative.
* [Vero](https://www.getvero.com/) [_[PH]_](https://www.producthunt.com/posts/vero) - The messaging platform that helps you drive customer engagement.
* [Ontraport](https://ontraport.com/) - Emails, SMS, landing pages, forms and CRM.
* [Pardot by Salesforce](https://www.pardot.com/) - B2B marketing automation.
* [Autopilot](https://www.autopilothq.com/) - Marketing automation softwaremade visual.
* [Marketo by Adobe](https://www.marketo.com/) - ABM combined with industry-leading marketing automation.

## Copy
* [GoodEmailCopy](http://www.goodemailcopy.com/) - Email copy from great companies.
* [Nishi](http://www.heynishi.com/) [_[PH]_](https://www.producthunt.com/posts/nishi) - A curated showcase of websites that nail copywriting.
* [DripScripts](https://dripscripts.com/) [_[PH]_](https://www.producthunt.com/posts/drip-scripts) - Create automated email sequences in 60 seconds.
* [GreatEmailcopy](https://greatemailcopy.tumblr.com/) - A dose of well-crafted emails from around the web.
* [GoodSalesEmails](http://goodsalesemails.com/) - Learn how some of the best companies are doing sales, by looking at their email campaigns.
* [CannedEmails](http://www.cannedemails.com/) [_[PH]_](https://www.producthunt.com/posts/canned-emails) - A minimal site with prewritten emails.

## Video and animation creation
* [Powtoon](https://www.powtoon.com/) [_[PH]_](https://www.producthunt.com/posts/powtoon) - Create awesome animated videos and presentations.
* [Offeo](https://offeo.com/) [_[PH]_](https://www.producthunt.com/posts/offeo-3) - An online video maker to create beautiful social videos in minutes.
* [Hustl](https://gohustl.co/) [_[PH]_](https://www.producthunt.com/posts/hustl) - Create awesome time-lapse videos of your Mac screen.
* [Animoto](https://animoto.com/) - Create impressive videos in minutes with a drag-and-drop video maker.
* [Rocketium](https://rocketium.com/) [_[PH]_](https://www.producthunt.com/posts/rocketium) - Transform text & media into stunning videos.
* [Animaker](https://www.animaker.com/) [_[PH]_](https://www.producthunt.com/posts/animaker-2) - Create animated videos with less effort, time and cost.
* [Spark by Adobe](https://spark.adobe.com/) - Create impactful social graphics, web pages, and short videos in minutes.
* [Wave](https://wave.video/) - Create branded video content that will build your audience.
* [Shakr](https://www.shakr.com/) [_[PH]_](https://www.producthunt.com/posts/shakr-2) - Make amazing videos to rock your marketing.
* [Renderforest](https://www.renderforest.com/) [_[PH]_](https://www.producthunt.com/posts/renderforest-video) - Free animation and intro maker, slideshow and video creator.
* [Touchcast](https://www.touchcast.com/) [_[PH]_](https://www.producthunt.com/posts/touchcast) - Create an interactive presentation that mixes video with web content.
* [Biteable](https://biteable.com/) - Create a video from the huge selection of surefire templates.
* [Doodly](https://www.doodly.com/) [_[PH]_](https://www.producthunt.com/posts/doodly) - Create your own doodle video in just 60 seconds.

## Social media management (SMM)
* [Tweetdeck](https://tweetdeck.twitter.com/) [_[PH]_](https://www.producthunt.com/posts/tweetdeck-2) - TweetDeck offers a more convenient Twitter experience by letting you view multiple timelines in one easy interface.
* [Hootsuite](https://hootsuite.com/) - Manage all your social media in one place.
* [Quuu](https://quuu.co/) [_[PH]_](https://www.producthunt.com/posts/quuu-3) - Place to go to find hand-picked quality content to share on social media.
* [EmbedSocial](https://embedsocial.com/) - Display social media feeds, photo galleries and reviews on any website.
* [CrowdFire](https://www.crowdfireapp.com/) [_[PH]_](https://www.producthunt.com/posts/crowdfire-3-0) - Directive and automation for Twitter.
* [Fomo](https://fomo.com/) - Increase trust, traffic, and sales with social proof automation.
* [SimplyMeasured](https://simplymeasured.com/) [_[PH]_](https://www.producthunt.com/posts/simplymeasured) - Snapchat analytics report.
* [Fastory](https://www.fastory.io/) [_[PH]_](https://www.producthunt.com/posts/fastory) - Craft stunning Instagram stories, share them everywhere.
* [Keyhole](https://keyhole.co/) [_[PH]_](https://www.producthunt.com/posts/keyhole) - Realtime hashtag tracking for Twitter, Facebook, etc.
* [SeekMetrics](https://seekmetrics.com/) - Free social media analytics and historical data.
* [SocialInsider](https://www.socialinsider.io/) [_[PH]_](https://www.producthunt.com/posts/socialinsider) - Social media analytics & benchmarking tool for agencies.

### Planners (content managers and schedulers)
* [Buffer](https://buffer.com/) [_[PH]_](https://www.producthunt.com/posts/buffer-for-instagram) - Plan, track, and analyze your SMM.
* [Amplifr](https://amplifr.com/) [_[PH]_](https://www.producthunt.com/posts/amplifr) - Schedule social media & messages, get actionable analytics.
* [Sendible](https://www.sendible.com/) - Powerful social media management software.
* [Edgar](https://meetedgar.com/) - Schedule and automate your content on Facebook, Twitter, Instagram, and LinkedIn.
* [Gain](https://gainapp.com/) - Social media and content collaboration for agencies.
* [Repost](https://repost.elokenz.com/) - An auto-refilling queue which analyzes your content and decide which one to share next on each social media platform.
* [Swello](https://swello.com/)
* [Postfity](https://postfity.com/) - With our post scheduler you can manage social networks, schedule posts and engage your audiences.

### Instagram tools
* [HypeAuditor](https://hypeauditor.com/)
* [MightyScout](https://mightyscout.com/) [_[PH]_](https://www.producthunt.com/posts/mightyscout)
* [Later](https://later.com/)
* [Storyheap](https://storyheap.com/) [_[PH]_](https://www.producthunt.com/posts/storyheap)
* [Instavast](https://instavast.com/) [_[PH]_](https://www.producthunt.com/posts/instavast)

## Track mentions
* [Mention](https://mention.com) [_[PH]_](https://www.producthunt.com/posts/mention-influencers-dashboard) 💙
* [Notify.ly](https://notify.ly/) [_[PH]_](https://www.producthunt.com/posts/notify)
* [Awario](https://awario.com/) [_[PH]_](https://www.producthunt.com/posts/awario)
* [BrandMentions](https://brandmentions.com/) [_[PH]_](https://www.producthunt.com/posts/brandmentions-2-0)
* [Alerts by Google](https://www.google.com/alerts#) [_[PH]_](https://www.producthunt.com/posts/google-alerts)
* [Brand24](https://brand24.com/) [_[PH]_](https://www.producthunt.com/posts/brand24)

## Affiliate
* [Everflow](https://everflow.io/)
* [Strackr](https://strackr.com/) [_[PH]_](https://www.producthunt.com/posts/strackr)

## Referral
* [CloudSponge](https://www.cloudsponge.com/)

## Market research
* [SimilarWeb](https://www.similarweb.com) [_[PH]_](https://www.producthunt.com/posts/similarweb) 💙
* [Google Trends](https://trends.google.com) [_[PH]_](https://www.producthunt.com/posts/google-trends-2)
* [Rank2traffic](https://www.rank2traffic.com)
* [Crunchbase](https://www.crunchbase.com/) [_[PH]_](https://www.producthunt.com/posts/crunchbase-2-2)
* [ThinkWithGoogle](https://www.thinkwithgoogle.com/tools)
* [ConsumerBarometer](https://www.consumerbarometer.com/en) [_[PH]_](https://www.producthunt.com/posts/consumer-barometer)
* [Applyzer](https://www.applyzer.com/) [_[PH]_](https://www.producthunt.com/posts/applyzer)
* [Apptrace](https://www.apptrace.com/)
* [Appfollow](https://appfollow.io) [_[PH]_](https://www.producthunt.com/posts/appfollow-4-0)
* [Alexa](https://www.alexa.com/)

## Paid ads
* [Goa.marketing](https://www.goa.marketing/) - Get actionable data insights on your paid Search in Google Ads.
* [Kenshoo](https://kenshoo.com/) [_[PH]_](https://www.producthunt.com/posts/kensho) - Automate your ad bids and strategies in Google Ads, Bing, Yahoo, Pinterest etc.

## Affiliates
* [PartnerStack](https://www.partnerstack.com/)
* [Refersion](https://www.refersion.com/)
* [Smile](https://smile.io/)
* [ReferralCandy](https://www.referralcandy.com/)
* [Viral-loops](https://viral-loops.com/) [_[PH]_](https://www.producthunt.com/posts/viral-loops-for-startups)

## Other marketing tools
* [WebEngage](https://webengage.com/)
* [Bonjoro](https://www.bonjoro.com/) [_[PH]_](https://www.producthunt.com/posts/bonjoro)
* [Wistia](https://wistia.com/) [_[PH]_](https://www.producthunt.com/posts/wistia)
* [Whatagraph](https://whatagraph.com/) [_[PH]_](https://www.producthunt.com/posts/whatagraph-3)
* [Adespresso](https://adespresso.com/) - Create, manage and analyze Facebook, Instagram, and Google ads.


# Collaboration

## Project and task management
* [Trello](https://trello.com) [_[PH]_](https://www.producthunt.com/posts/trello-66) 💙
* [Flow](https://www.getflow.com/) [_[PH]_](https://www.producthunt.com/posts/flow-adaa408b-3cdf-4d57-97d5-890701242291)
* [Merlin](https://www.projectwizards.net/en/merlin-project) [_[PH]_](https://www.producthunt.com/posts/merlin-project-5)
* [Basecamp](https://basecamp.com/) [_[PH]_](https://www.producthunt.com/posts/basecamp-3-2)
* [Asana](https://asana.com/) [_[PH]_](https://www.producthunt.com/posts/asana-2)
* [Noteplan](https://noteplan.co/) [_[PH]_](https://www.producthunt.com/posts/noteplan)
* [I Done This](https://idonethis.com/) [_[PH]_](https://www.producthunt.com/posts/i-done-this)
* [Meistertask](https://www.meistertask.com/) [_[PH]_](https://www.producthunt.com/posts/meistertask-2)
* [Podio](https://podio.com/site/en) [_[PH]_](https://www.producthunt.com/posts/podio)
* [Proofhub](https://www.proofhub.com/)
* [Projects by Zoho](https://www.zoho.com/projects/) [_[PH]_](https://www.producthunt.com/posts/zoho-projects)
* [Gantt pro](https://ganttpro.com/)
* [RedBooth](https://redbooth.com/) [_[PH]_](https://www.producthunt.com/posts/redbooth-2)
* [Celoxis](https://www.celoxis.com/)
* [MavenLink](https://www.mavenlink.com/)
* [TeamDeck](https://teamdeck.io/) [_[PH]_](https://www.producthunt.com/posts/teamdeck-3)
* [Hive](https://hive.com/) [_[PH]_](https://www.producthunt.com/posts/hive-4784fde3-1269-4f8e-9b6e-7793f53130b1)
* [Wrike](https://www.wrike.com/) [_[PH]_](https://www.producthunt.com/posts/wrike)
* [Metatask](https://metatask.io/) [_[PH]_](https://www.producthunt.com/posts/metatask)
* [Clickup](https://clickup.com/)
* [NutCache](https://www.nutcache.com/)
* [Sunsama](https://sunsama.com/) [_[PH]_](https://www.producthunt.com/posts/sunsama-2)
* [Polydone](https://www.polydone.com/)
* [Scope](https://www.getscope.com/)
* [Zenkit](https://zenkit.com/) [_[PH]_](https://www.producthunt.com/posts/zenkit-3-0) - "A better Trello than Trello"
* [Blossom](https://www.blossom.co/) [_[PH]_](https://www.producthunt.com/posts/blossom)
* [TaskWorld](https://taskworld.com/) [_[PH]_](https://www.producthunt.com/posts/taskworld)
* [Hitask](https://hitask.com/)
* [Standuply](https://standuply.com/) [_[PH]_](https://www.producthunt.com/posts/standuply-3-0)
* [Zube](https://zube.io/) [_[PH]_](https://www.producthunt.com/posts/zube)
* [Paymo](https://www.paymoapp.com/)
* [Avaza](https://www.avaza.com/)
* [TeamWeek](https://teamweek.com/) [_[PH]_](https://www.producthunt.com/posts/teamweek-2-0)
* [Ryver](https://ryver.com/)
* [Hiverhq](https://hiverhq.com/) [_[PH]_](https://www.producthunt.com/posts/hiver-2)
* [Flowdock](https://www.flowdock.com/) [_[PH]_](https://www.producthunt.com/posts/flowdock-1696)
* [Craft](https://craft.io/)
* [Elapseit](https://elapseit.com/)
* [bqe](https://www.bqe.com/)

## Product Roadmaps
* [Onroadmap](https://onroadmap.com/) [_[PH]_](https://www.producthunt.com/posts/roadmap-2-0)
* [ProductBoard](https://www.productboard.com/) [_[PH]_](https://www.producthunt.com/posts/productboard-3-0)
* [Aha](https://www.aha.io/) [_[PH]_](https://www.producthunt.com/posts/aha)
* [Prodpad](https://www.prodpad.com/) [_[PH]_](https://www.producthunt.com/posts/prodpad)
* [OneDesk](https://www.onedesk.com/)
* [ProductPlan](https://www.productplan.com/) [_[PH]_](https://www.producthunt.com/posts/productplan-roadmap-software)
* [Roadmunk](https://roadmunk.com/) [_[PH]_](https://www.producthunt.com/posts/roadmunk)

## Todo lists
* [Any.do](https://www.any.do/) [_[PH]_](https://www.producthunt.com/posts/any-do-to-do-list-calendar-reminders)
* [Wunderlist](https://www.wunderlist.com/) [_[PH]_](https://www.producthunt.com/posts/wunderlist-e39a6306-97ab-4d90-883a-7a5f75af4bcd)
* [Pomotodo](https://pomotodo.com/) [_[PH]_](https://www.producthunt.com/posts/pomotodo)
* [Things](https://culturedcode.com/things/) [_[PH]_](https://www.producthunt.com/posts/things-3-0)

## Team communication
* [Telegram](http://telegram.org/) [_[PH]_](https://www.producthunt.com/posts/telegram-5-6) 💙
* [Slack](https://slack.com) [_[PH]_](https://www.producthunt.com/posts/slack)
* [Discord](https://discordapp.com/)
* [Rocket.chat](https://rocket.chat/) [_[PH]_](https://www.producthunt.com/posts/rocket-chat)
* [Gitter](https://gitter.im/) [_[PH]_](https://www.producthunt.com/posts/gitter)
* [Chanty](https://www.chanty.com/)
* [Riot.im](https://about.riot.im/) [_[PH]_](https://www.producthunt.com/posts/riot-im)
* [Tipihub](https://www.tipihub.com/)
* [Typetalk](https://www.typetalk.com/) [_[PH]_](https://www.producthunt.com/posts/typetalk)
* [Flowdock](https://www.flowdock.com/) [_[PH]_](https://www.producthunt.com/posts/flowdock-1696)
* [Flock](https://flock.com/) [_[PH]_](https://www.producthunt.com/posts/flock-7)

### Video calls, meetings and screen sharing
* [Zoom](https://zoom.us/) [_[PH]_](https://www.producthunt.com/posts/zoom-4)
* [Hangouts by Google](https://hangouts.google.com/) [_[PH]_](https://www.producthunt.com/posts/hangouts-chat-by-google-2)
* [Jitsi](https://jitsi.org/)
* [Appear.in](https://appear.in/) [_[PH]_](https://www.producthunt.com/posts/appear-in)
* [Webex](https://www.webex.com/)
* [Talky](https://talky.io/) [_[PH]_](https://www.producthunt.com/posts/talky)
* [Join.me](https://www.join.me/) [_[PH]_](https://www.producthunt.com/posts/join-me)
* [Wisembly Jam](https://jam.wisembly.com/) [_[PH]_](https://www.producthunt.com/posts/wisembly-jam)

## Screen shots and video capture and sharing
* [Monosnap](https://monosnap.com) [_[PH]_](https://www.producthunt.com/posts/monosnap) 💙
* [Loom](https://www.loom.com/) [_[PH]_](https://www.producthunt.com/posts/loom-4)
* [Droplr](https://droplr.com/) [_[PH]_](https://www.producthunt.com/posts/droplr)
* [Demodesk](https://demodesk.com/) [_[PH]_](https://www.producthunt.com/posts/demodesk)
* [GlobalDelight](https://www.globaldelight.com/)
* [Screencast-o-matic](https://screencast-o-matic.com/) [_[PH]_](https://www.producthunt.com/posts/screencast-o-matic)
* [ViewEdit](https://viewedit.com/) [_[PH]_](https://www.producthunt.com/posts/viewedit)
* [Kap](https://getkap.co/) [_[PH]_](https://www.producthunt.com/posts/kap-2)
* [Clipular](https://www.clipular.com/) [_[PH]_](https://www.producthunt.com/posts/clipular)
* [RecordIt](http://recordit.co/) [_[PH]_](https://www.producthunt.com/posts/recordit)
* [Screen Capture by Techsmith](https://www.techsmith.com/screen-capture.html)

## Bug tracking
* [Jira](https://www.atlassian.com/software/jira)
* [Usersnap](https://usersnap.com/) [_[PH]_](https://www.producthunt.com/posts/usersnap)
* [Marker](https://marker.io/)
* [Bugherd](https://bugherd.com/) [_[PH]_](https://www.producthunt.com/posts/bugherd)

## Data, knowledge base, notes and documents
* [Notion](https://notion.so) [_[PH]_](https://www.producthunt.com/posts/notion-2-3) 💙
* [Coda](https://coda.io/) [_[PH]_](https://www.producthunt.com/posts/coda)
* [Airtable](https://airtable.com/) [_[PH]_](https://www.producthunt.com/posts/airtable)
* [Dropbox Paper](https://www.dropbox.com/paper) [_[PH]_](https://www.producthunt.com/posts/dropbox-paper)
* [Gitbook](https://www.gitbook.com/) [_[PH]_](https://www.producthunt.com/posts/gitbook-2)
* [Google Docs](https://docs.google.com)
* [Bear](https://bear.app/) [_[PH]_](https://www.producthunt.com/posts/bear)
* [MilaNote](https://milanote.com/) [_[PH]_](https://www.producthunt.com/posts/milanote-2)
* [SimpleNote](https://simplenote.com/) [_[PH]_](https://www.producthunt.com/posts/simplenote)
* [Tettra](https://tettra.co/) [_[PH]_](https://www.producthunt.com/posts/tettra-2-0)
* [OneNote](https://www.onenote.com) [_[PH]_](https://www.producthunt.com/posts/onenote-for-mac)

## Email inbox
* [Spark](https://sparkmailapp.com/) [_[PH]_](https://www.producthunt.com/posts/spark-6) 💙
* [Polymail](https://polymail.io/) [_[PH]_](https://www.producthunt.com/posts/polymail-2)
* [Frontapp](https://frontapp.com/) [_[PH]_](https://www.producthunt.com/posts/front-05a37a52-1f65-4ed8-b880-ce87a68786e0)
* [FollowUp](https://followup.cc/)
* [Consider](https://consider.co/) [_[PH]_](https://www.producthunt.com/posts/consider)

## Collective coding
* [CodeSandBox](https://codesandbox.io/) [_[PH]_](https://www.producthunt.com/posts/codesandbox-2)

## Git
* [Gitlab](https://gitlab.com) [_[PH]_](https://www.producthunt.com/posts/gitlab)
* [Github](https://github.com) 💙
* [Bitbucket](https://bitbucket.org/)

## Time tracking
* [Timeneye](https://www.timeneye.com/) [_[PH]_](https://www.producthunt.com/posts/timeneye-1)
* [Everhour](https://everhour.com/) [_[PH]_](https://www.producthunt.com/posts/everhour-3)
* [Toggl](https://toggl.com/) [_[PH]_](https://www.producthunt.com/posts/toggl)
* [Ballpark](https://www.getballpark.com/) [_[PH]_](https://www.producthunt.com/posts/ballpark-2)
* [Clockify](https://clockify.me/) [_[PH]_](https://www.producthunt.com/posts/clockify)
* [Harvest](https://www.getharvest.com/) [_[PH]_](https://www.producthunt.com/posts/harvest)
* [FutureNDA](https://www.futurenda.com/)
* [Timedoctor](https://www.timedoctor.com/)
* [Timecamp](https://www.timecamp.com/) [_[PH]_](https://www.producthunt.com/posts/timecamp)
* [WakaTime](https://wakatime.com/) [_[PH]_](https://www.producthunt.com/posts/wakatime)
* [ClockIt](https://clockit.io/)
* [Tmetric](https://tmetric.com/) [_[PH]_](https://www.producthunt.com/posts/tmetric)

## Other collaboration tools
* [Happy.tools](https://happy.tools/) [_[PH]_](Happy.tools)
* [Bynder](https://www.bynder.com/) [_[PH]_](https://www.producthunt.com/posts/bynder-4)
* [Docsend](https://www.docsend.com/) [_[PH]_](https://www.producthunt.com/posts/docsend-2)


# Build a chatbot
* [ChatFuel](https://chatfuel.com/) [_[PH]_](https://www.producthunt.com/posts/chatfuel)
* [BotSociety](https://botsociety.io/) [_[PH]_](https://www.producthunt.com/posts/botsociety)
* [Bots.co](https://bots.co/)
* [Octane AI](https://octaneai.com/) [_[PH]_](https://www.producthunt.com/posts/octane-ai)
* [Botsify](https://botsify.com/) [_[PH]_](https://www.producthunt.com/posts/botsify-2-0)
* [Howdy.ai](https://howdy.ai/) [_[PH]_](https://www.producthunt.com/posts/howdy-2)
* [Meya](https://www.meya.ai/) [_[PH]_](https://www.producthunt.com/posts/meya-ai)
* [Chatbots by Hasura](https://platform.hasura.io/hub/collections/chatbots) [_[PH]_](https://www.producthunt.com/posts/chatbots-on-hasura)
* [Flowxo](https://flowxo.com/) [_[PH]_](https://www.producthunt.com/posts/flowxo)


# Domains and naming

## Find a domain name
* [Namemesh](https://namemesh.com) [_[PH]_](https://www.producthunt.com/posts/name-mesh) 💙
* [Domainr](https://domainr.com/) [_[PH]_](https://www.producthunt.com/posts/domai-nr)
* [FlameDomain](http://www.flamedomain.com/) [_[PH]_](https://www.producthunt.com/posts/flamedomain)
* [Dofo](https://dofo.com/) [_[PH]_](https://www.producthunt.com/posts/dofo-com)

## Naming
* [Namechk](https://namechk.com/) [_[PH]_](https://www.producthunt.com/posts/namechk)
* [NamingMatters](https://www.namingmatters.com/) [_[PH]_](https://www.producthunt.com/posts/naming-matters)
* [FormalFounder](https://www.formalfounder.com/)
* [Naminum](http://www.naminum.com/) [_[PH]_](https://www.producthunt.com/posts/naminum)
* [TheNameApp](https://thenameapp.com/)

## Other 
* [Trademark Search by Marcaria](https://trademark-search.marcaria.com/en) - 1 search without signing up per IP.


# Legal, Account and Invoicing
* [Stripe Atlas](https://www.producthunt.com/posts/stripe-atlas-5) [_[PH]_](https://www.producthunt.com/posts/stripe-atlas-5) 💙
* [Freshbooks](https://www.freshbooks.com/) [_[PH]_](https://www.producthunt.com/posts/the-new-freshbooks)
* [Equity tool by Gust](https://gust.com/equity)
* [Waveapps](https://www.waveapps.com/)
* [Xero](https://www.xero.com/) [_[PH]_](https://www.producthunt.com/posts/xero)
* [Hubdoc](https://www.hubdoc.com/)
* [Momenteo](https://www.momenteo.com/) [_[PH]_](https://www.producthunt.com/posts/momenteo)
* [Debitoor](https://debitoor.com/)
* [Clerky](https://www.clerky.com/) [_[PH]_](https://www.producthunt.com/posts/clerky)
* [Bench](https://bench.co/) [_[PH]_](https://www.producthunt.com/posts/bench)
* [Pancake](https://www.pancakeapp.com/) [_[PH]_](https://www.producthunt.com/posts/pancake)
* [ZipBooks](https://zipbooks.com/) [_[PH]_](https://www.producthunt.com/posts/zipbooks-3)
* [Freeagent](https://www.freeagent.com/) [_[PH]_](https://www.producthunt.com/posts/freeagent)
* [Pie Slicer](https://thepieslicer.com) [_[PH]_](https://www.producthunt.com/posts/typetalk)

## GDPR
* [GDPR kit by Iubenda](https://www.iubenda.com/en/gdpr) [_[PH]_](https://www.producthunt.com/posts/iubenda-for-gdpr)
* [GDPR form](https://www.gdprform.io) [_[PH]_](https://www.producthunt.com/posts/gdpr-form)
* [GDPR kit by Mailjet](https://www.mailjet.com/blog/guide/gdpr-resource-kit) [_[PH]_](https://www.producthunt.com/posts/gdpr-sos-kit-for-marketers)
* [GDPR quiz](https://ultimategdprquiz.com/) [_[PH]_](https://www.producthunt.com/posts/the-ultimate-gdpr-quiz)

## Invoicing
* [Invoicely](https://invoicely.com/)
* [InvoiceOcean](https://invoiceocean.com/) [_[PH]_](https://www.producthunt.com/posts/invoiceocean)
* [Clearbooks](https://www.clearbooks.co.uk/) [_[PH]_](https://www.producthunt.com/posts/clear-books-accounts)
* [Expensify](https://www.expensify.com/)
* [Invoiced](https://invoiced.com/) [_[PH]_](https://www.producthunt.com/posts/invoiced)
* [Invoices by Squareup](https://squareup.com/us/en/invoices) [_[PH]_](https://www.producthunt.com/posts/square-invoices-2)
* [Blinksale](https://www.blinksale.com/)
* [Invoicehome](https://invoicehome.com/)
* [Slimvoice](https://slimvoice.co/) [_[PH]_](https://www.producthunt.com/posts/slimvoice)
* [Invoicing by Hellobonsai](https://www.hellobonsai.com/freelance-invoice)
* [Docsumo](https://docsumo.com) [_[PH]_](https://www.producthunt.com/posts/docsumo)

## Documents
* [Hellosign](https://www.hellosign.com/) [_[PH]_](https://www.producthunt.com/posts/hellosign)
* [Docracy](https://www.docracy.com/) [_[PH]_](https://www.producthunt.com/posts/docracy)
* [Docusign](https://www.docusign.com/)
* [Docs by Atlassian](https://editorial.atlassian.net/wiki/spaces/ED/pages/262284/The+Atlassian+Term+Sheet?fbclid=IwAR0-w0vYB-58JmcNB7e0Hqu6GoQXgUDWlWEV3wD4WnM96hIuJ7FJn3L7Ts8) - for buyng startups
* [Docs by Upcounsel](https://www.upcounsel.com/free-legal-documents)
* [Wonder.legal](https://www.wonder.legal/) [_[PH]_](https://www.producthunt.com/posts/wonder-legal)
* [Docs by YC](https://www.ycombinator.com/documents)
* [TermsFeed](https://www.termsfeed.com/) [_[PH]_](https://www.producthunt.com/posts/termsfeed)


# Funding
## Investors and Accelerators
* [A list by Gust](https://gust.com/founders/raise)
* [YourFirstInvestor](https://yourfirstinvestor.com/) [_[PH]_](https://www.producthunt.com/posts/yourfirstinvestor)
* [InvestorList](https://investorlist.co/) [_[PH]_](https://www.producthunt.com/posts/investor-list)
* [f6s](https://www.f6s.com/) [_[PH]_](https://www.producthunt.com/posts/f6s)

## Crowdfunding
* [Appsumo](https://appsumo.com)
* [Indiegogo](https://www.indiegogo.com)
* [Kickstarter](https://www.kickstarter.com)
* [PitchGround](https://pitchground.com)
* [OpenCollective](https://opencollective.com) [_[PH]_](https://www.producthunt.com/posts/opencollective)
* [Patreon](https://www.patreon.com/) [_[PH]_](https://www.producthunt.com/posts/patreon)


# Sales
* [Mattermark](https://mattermark.com/) [_[PH]_](https://www.producthunt.com/posts/mattermark-4)
* [Persist IQ](https://www.persistiq.com/) [_[PH]_](https://www.producthunt.com/posts/persistiq)
* [Mailshake](https://mailshake.com/) [_[PH]_](https://www.producthunt.com/posts/mailshake-2)
* [Outreach](https://www.outreach.io/)
* [InsideSales](http://insidesales.com/)
* [Gong](https://www.gong.io/) [_[PH]_](https://www.producthunt.com/posts/gong)
* [Dooly](https://www.dooly.ai/)
* [Guru](https://www.getguru.com/)
* [Chorus](https://www.chorus.ai/)
* [Hunter](https://hunter.io/) [_[PH]_](https://www.producthunt.com/posts/hunter)
* [Reply](https://reply.io/)

## CRM
* [Close](https://close.com/) [_[PH]_](https://www.producthunt.com/posts/close)
* [Salesforce](https://www.salesforce.com/)
* [Streak](https://www.streak.com/) [_[PH]_](https://www.producthunt.com/posts/streak)
* [Drip](https://www.drip.com/) - Powerful e-commerce CRM.
* [Insightly](https://www.insightly.com/)
* [CRM by Freshworks](https://www.freshworks.com/freshsales-crm/)
* [Alore](https://crm.alore.io/)
* [Copper](https://www.copper.com/)
* [Hubspot](https://www.hubspot.com/)
* [Salesseek](https://www.salesseek.com/)
* [CapsuleCRM](https://capsulecrm.com/) [_[PH]_](https://www.producthunt.com/posts/capsule-crm)
* [AgileCRM](https://www.agilecrm.com/)
* [Keap](https://keap.com/)
* [Gmelius](https://gmelius.com/) [_[PH]_](https://www.producthunt.com/posts/gmelius-3)
* [Gist](https://getgist.com/) [_[PH]_](https://www.producthunt.com/posts/gist-platform)
* [vCita](http://www.vcita.com/) [_[PH]_](https://www.producthunt.com/posts/vcita)
* [HelpShift](https://www.helpshift.com/) [_[PH]_](https://www.producthunt.com/posts/helpshift)
* [Nutshell](https://www.nutshell.com/)


# Communities
* [Spectrum.chat](https://spectrum.chat/) [_[PH]_](https://www.producthunt.com/posts/spectrum-6)
* [Discourse](https://www.discourse.org/) [_[PH]_](https://www.producthunt.com/posts/discourse-2-0)
* [Flarum](https://www.flarum.com/) [_[PH]_](https://www.producthunt.com/posts/flarum-pro)


# Learn
* [Julian's handbook on Growth](https://www.julian.com/guide/growth/intro) 💙
* [Google Primer](https://www.yourprimer.com/) [_[PH]_](https://www.producthunt.com/posts/primer-2-0-by-google)
* [SaaS Startup Guide by Hotjar](https://www.producthunt.com/posts/saas-startup-guide-by-hotjar)

## Books
* [Lean Startup by Eric Ries](https://www.amazon.com/Lean-Startup-Innovation-Successful-Businesses-ebook/dp/B005PR422K)
* [Zero to One by Peter Thiel](https://www.amazon.com/Zero-One-Notes-Start-Future-ebook/dp/B00KHX0II4)
* [Hooked by Nir Eyal and Ryan Hoover](https://www.amazon.com/Hooked-How-Build-Habit-Forming-Products-ebook/dp/B00NW01MKM)
* [The Four Steps to the Epiphany by Steve Blank](https://www.amazon.com/gp/product/0989200507)
* [The Mom Test by Rob Fitzpatrick](http://momtestbook.com/)

## Video
* [Startup School by YC](https://www.startupschool.org) [_[PH]_](https://www.producthunt.com/posts/startup-school-2018)


# A/B testing
* [Optimizely](https://www.optimizely.com/) [_[PH]_](https://www.producthunt.com/posts/optimizely-rollouts)
* [Vwo](https://vwo.com/) [_[PH]_](https://www.producthunt.com/posts/vwo-on-page-surveys)
* [Omniconvert](https://www.omniconvert.com/)
* [ABtasty](https://www.abtasty.com/)


# Launch
* [Product Hunt](https://producthunt.com) [_[PH]_](https://www.producthunt.com/posts/product-hunt-4-0) 💙
* [Indie Hackers](https://indiehackers.com) [_[PH]_](https://www.producthunt.com/posts/indie-hackers) 💙
* [Places to Post a Startup](https://github.com/mmccaff/PlacesToPostYourStartup) 
* [Startup Promotion List](https://github.com/trekhleb/promote-your-next-startup) 


# Other
* [Calendly](https://calendly.com/) [_[PH]_](https://www.producthunt.com/posts/calendly) 💙
* [YouCanBook](https://youcanbook.me/)
* [Voicea](https://www.voicea.com/) [_[PH]_](https://www.producthunt.com/posts/voicea)
* [Sheet2site](https://www.sheet2site.com/) [_[PH]_](https://www.producthunt.com/posts/sheet2site-2-0)


# Sponsors
[<img height="100" src="https://github.com/alexanderisora/startuptoolbox/blob/master/sponsors/badge_400x100.png">](https://unicornplatform.com/?ref=startuptoolbox)

# Contribute
Found a nice link? Noticed a bug? Feel free to contribute! You are so much welcome! But read the [CONTRIBUTING.md](https://github.com/alexanderisora/startuptoolbox/blob/master/CONTRIBUTING.md) first.
# License
<a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/"><img alt="Creative Commons License" style="border-width:0" src="https://licensebuttons.net/l/by-sa/4.0/88x31.png" /></a><br />This work is licensed under <a rel="license" href="https://creativecommons.org/licenses/by-sa/4.0/">Creative Commons Attribution-ShareAlike 4.0 International License</a>.
