# 1. Introduction
## a. Find the nearest city to generators
https://drive.google.com/open?id=19-oNlKN8am5oswpUzdlv79jTmGWqRs-q&usp=sharing

## b. GB smart grid network (representative cities)
![bt network.png](https://i.loli.net/2019/09/05/sA2vbSZcYgGajn7.png)

## c. Table of alternative city
| GB network model (gens)          | BT fibre core network (city) |
|----------------------------------|------------------------------|
| 1. Beauly                        | 9. Glasgow                   |
| 2. Peterhead                     | 9. Glasgow                   |
| 3. Errochty                      | 9. Glasgow                   |
| 4. Denny/Bonnybridge             | 9. Glasgow                   |
| 5. Neilston                      | 9. Glasgow                   |
| 6. Strathaven                    | 9. Glasgow                   |
| 7. Torness                       | 10. Clyde Valley             |
| 8. Eccles                        | 11. Newcastle                |
| 9. Harker                        | 11. Newcastle                |
| 10. Stella West                  | 11. Newcastle                |
| 11. Penwortham                   | 12. Preston                  |
| 12. Desside                      | 1. Manchester                |
| 13. Daines                       | 1. Manchester                |
| 14. Th. Marsh/Stocksbridge       | 13. Sheffield                |
| 15. Thornton/Drax/Eggborough     | 2. Leeds                     |
| 16. Keadby                       | 13. Sheffield                |
| 17. Ratcliffe                    | 14. Derby                    |
| 18. Feckenham                    | 8. Birmingham                |
| 19. Walpole                      | 15. Peterborough             |
| 20. Bramford                     | 4. Docklands                 |
| 21. Pelham                       | 6. City of London            |
| 22. Sundon/East Claydon          | 3. Milton Keynes             |
| 23. Melksham                     | 18. Bristol                  |
| 24. Bramley                      | 16. Guildford                |
| 25. London                       | 6. City of London            |
| 26. Kemsley                      | 4. Docklands                 |
| 27. Sellindge                    | 4. Docklands                 |
| 28. Lovedean                     | 16. Guildford                |
| 29. S. W. Penisula               | 19. Cardiff                  |


# 2. Virtual link topology & Communication delay

## a. Default
### a-1. Route the virtual link topology on the physical link topology
```MATLAB
Phy_G.L=[ % defining the physical topology
0	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	1
1	0	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	0	0
1	1	0	1	1	1	1	1	0	0	1	1	0	1	1	0	0	0	0	1
1	1	1	0	1	1	1	1	0	0	0	0	0	0	0	1	1	0	0	0
1	1	1	1	0	1	1	1	0	0	0	0	0	0	1	1	1	1	0	0
1	1	1	1	1	0	1	1	0	0	0	0	0	0	0	0	1	1	1	0
1	1	1	1	1	1	0	1	0	0	0	0	0	0	1	0	1	0	1	1
1	1	1	1	1	1	1	0	0	0	0	1	1	1	0	0	0	1	1	1
1	1	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
1	0	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0
0	0	0	1	1	1	1	0	0	0	0	0	0	0	0	1	0	0	0	0
0	0	0	0	1	1	0	1	0	0	0	0	0	0	0	0	0	0	1	0
0	0	0	0	0	1	1	1	0	0	0	0	0	0	0	0	0	1	0	0
1	0	1	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0
];
```
### a-2. Communication delay (in ms)
|                       | 1\. Manchester | 2\. Leeds | 3\. Milton Keynes | 4\. Docklands | 5\. South Bank | 6\. City of London | 7\. London North West | 8\. Birmingham | 9\. Glasgow | 10\. Clyde Valley | 11\. Newcastle | 12\. Preston | 13\. Sheffield | 14\. Derby | 15\. Peterborough | 16\. Guildford | 17\. Slough | 18\. Bristol | 19\. Cardiff | 20\. Wolverhampton |
|-----------------------|----------------|-----------|-------------------|---------------|----------------|--------------------|-----------------------|----------------|-------------|-------------------|----------------|--------------|----------------|------------|-------------------|----------------|-------------|--------------|--------------|--------------------|
| 1\. Manchester        | 0              | 60        | 61                | 62            | 62             | 62                 | 62                    | 61             | 62          | 62                | 61             | 60           | 60             | 61         | 122               | 122            | 122         | 122          | 122          | 61                 |
| 2\. Leeds             | 60             | 0         | 61                | 61            | 61             | 61                 | 61                    | 61             | 62          | 62                | 61             | 61           | 60             | 121        | 122               | 122            | 122         | 122          | 123          | 121                |
| 3\. Milton Keynes     | 61             | 61        | 0                 | 61            | 61             | 61                 | 60                    | 61             | 123         | 123               | 62             | 61           | 122            | 61         | 60                | 121            | 121         | 121          | 122          | 61                 |
| 4\. Docklands         | 62             | 61        | 61                | 0             | 60             | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 60             | 60          | 122          | 121          | 122                |
| 5\. South Bank        | 62             | 61        | 61                | 60            | 0              | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 60             | 60          | 61           | 121          | 122                |
| 6\. City of London    | 62             | 61        | 61                | 60            | 60             | 0                  | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 121            | 60          | 61           | 61           | 122                |
| 7\. London North West | 62             | 61        | 60                | 60            | 60             | 60                 | 0                     | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 121            | 60          | 121          | 61           | 61                 |
| 8\. Birmingham        | 61             | 61        | 61                | 61            | 61             | 61                 | 61                    | 0              | 122         | 122               | 122            | 61           | 61             | 60         | 122               | 121            | 121         | 61           | 61           | 60                 |
| 9\. Glasgow           | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 0           | 60                | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 10\. Clyde Valley     | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 60          | 0                 | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 11\. Newcastle        | 61             | 61        | 62                | 123           | 123            | 123                | 123                   | 122            | 123         | 123               | 0              | 121          | 121            | 122        | 122               | 183            | 183         | 183          | 183          | 122                |
| 12\. Preston          | 60             | 61        | 61                | 122           | 122            | 122                | 122                   | 61             | 122         | 122               | 121            | 0            | 121            | 121        | 122               | 182            | 182         | 122          | 122          | 121                |
| 13\. Sheffield        | 60             | 60        | 122               | 122           | 122            | 122                | 122                   | 61             | 122         | 122               | 121            | 121          | 0              | 121        | 183               | 182            | 182         | 121          | 122          | 121                |
| 14\. Derby            | 61             | 121       | 61                | 122           | 122            | 122                | 122                   | 60             | 122         | 122               | 122            | 121          | 121            | 0          | 121               | 182            | 182         | 121          | 121          | 121                |
| 15\. Peterborough     | 122            | 122       | 60                | 121           | 61             | 121                | 61                    | 121            | 183         | 183               | 122            | 122          | 182            | 121        | 0                 | 121            | 121         | 122          | 122          | 121                |
| 16\. Guildford        | 122            | 122       | 121               | 60            | 60             | 121                | 121                   | 121            | 184         | 184               | 183            | 182          | 182            | 182        | 121               | 0              | 60          | 121          | 182          | 182                |
| 17\. Slough           | 122            | 122       | 121               | 60            | 60             | 60                 | 60                    | 121            | 183         | 183               | 183            | 182          | 182            | 183        | 121               | 60             | 0           | 121          | 121          | 121                |
| 18\. Bristol          | 122            | 122       | 121               | 121           | 61             | 61                 | 121                   | 61             | 184         | 184               | 183            | 122          | 121            | 121        | 122               | 121            | 121         | 0            | 60           | 121                |
| 19\. Cardiff          | 123            | 123       | 122               | 121           | 121            | 61                 | 61                    | 61             | 184         | 184               | 183            | 122          | 122            | 121        | 122               | 182            | 121         | 60           | 0            | 122                |
| 20\. Wolverhampton    | 61             | 121       | 61                | 122           | 122            | 122                | 61                    | 60             | 122         | 122               | 122            | 121          | 121            | 121        | 121               | 182            | 121         | 121          | 121          | 0                  |



## b. Disconnect line: 2.Leeds - 6. City of London
### b-1. Route the virtual link topology on the physical link topology
```MATLAB
Phy_G.L=[ % defining the physical topology
0	1	1	1	1	1	1	1	1	1	1	1	1	1	0	0	0	0	0	1
1	0	1	1	1	0	1	1	1	1	1	1	1	0	0	0	0	0	0	0
1	1	0	1	1	1	1	1	0	0	1	1	0	1	1	0	0	0	0	1
1	1	1	0	1	1	1	1	0	0	0	0	0	0	0	1	1	0	0	0
1	1	1	1	0	1	1	1	0	0	0	0	0	0	1	1	1	1	0	0
1	0	1	1	1	0	1	1	0	0	0	0	0	0	0	0	1	1	1	0
1	1	1	1	1	1	0	1	0	0	0	0	0	0	1	0	1	0	1	1
1	1	1	1	1	1	1	0	0	0	0	1	1	1	0	0	0	1	1	1
1	1	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
1	0	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0
0	0	0	1	1	1	1	0	0	0	0	0	0	0	0	1	0	0	0	0
0	0	0	0	1	1	0	1	0	0	0	0	0	0	0	0	0	0	1	0
0	0	0	0	0	1	1	1	0	0	0	0	0	0	0	0	0	1	0	0
1	0	1	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0
];
```
### b-2. Communication delay (in ms)

|                       | 1\. Manchester | 2\. Leeds | 3\. Milton Keynes | 4\. Docklands | 5\. South Bank | 6\. City of London | 7\. London North West | 8\. Birmingham | 9\. Glasgow | 10\. Clyde Valley | 11\. Newcastle | 12\. Preston | 13\. Sheffield | 14\. Derby | 15\. Peterborough | 16\. Guildford | 17\. Slough | 18\. Bristol | 19\. Cardiff | 20\. Wolverhampton |
|-----------------------|----------------|-----------|-------------------|---------------|----------------|--------------------|-----------------------|----------------|-------------|-------------------|----------------|--------------|----------------|------------|-------------------|----------------|-------------|--------------|--------------|--------------------|
| 1\. Manchester        | 0              | 60        | 61                | 62            | 62             | 62                 | 62                    | 61             | 62          | 62                | 61             | 60           | 60             | 61         | 122               | 122            | 122         | 122          | 122          | 61                 |
| 2\. Leeds             | 60             | 0         | 61                | 61            | 61             | 122                | 61                    | 61             | 62          | 62                | 61             | 61           | 60             | 121        | 122               | 122            | 122         | 122          | 122          | 121                |
| 3\. Milton Keynes     | 61             | 61        | 0                 | 61            | 61             | 61                 | 60                    | 61             | 123         | 123               | 62             | 61           | 122            | 61         | 60                | 121            | 121         | 121          | 122          | 61                 |
| 4\. Docklands         | 62             | 61        | 61                | 0             | 60             | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 60             | 60          | 122          | 121          | 122                |
| 5\. South Bank        | 62             | 61        | 61                | 60            | 0              | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 60             | 60          | 61           | 121          | 122                |
| 6\. City of London    | 62             | 122       | 61                | 60            | 60             | 0                  | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 121            | 60          | 61           | 61           | 122                |
| 7\. London North West | 62             | 61        | 60                | 60            | 60             | 60                 | 0                     | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 121            | 60          | 121          | 61           | 61                 |
| 8\. Birmingham        | 61             | 61        | 61                | 61            | 61             | 61                 | 61                    | 0              | 122         | 122               | 122            | 61           | 61             | 60         | 122               | 121            | 121         | 61           | 61           | 60                 |
| 9\. Glasgow           | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 0           | 60                | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 10\. Clyde Valley     | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 60          | 0                 | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 11\. Newcastle        | 61             | 61        | 62                | 123           | 123            | 123                | 123                   | 122            | 123         | 123               | 0              | 121          | 121            | 122        | 122               | 183            | 183         | 183          | 183          | 122                |
| 12\. Preston          | 60             | 61        | 61                | 122           | 122            | 122                | 122                   | 61             | 122         | 122               | 121            | 0            | 121            | 121        | 122               | 182            | 182         | 122          | 122          | 121                |
| 13\. Sheffield        | 60             | 60        | 122               | 122           | 122            | 122                | 122                   | 61             | 122         | 122               | 121            | 121          | 0              | 121        | 183               | 182            | 182         | 121          | 122          | 121                |
| 14\. Derby            | 61             | 121       | 61                | 122           | 122            | 122                | 122                   | 60             | 122         | 122               | 122            | 121          | 121            | 0          | 121               | 182            | 182         | 121          | 121          | 121                |
| 15\. Peterborough     | 122            | 122       | 60                | 121           | 61             | 121                | 61                    | 121            | 183         | 183               | 122            | 122          | 182            | 121        | 0                 | 121            | 121         | 122          | 122          | 121                |
| 16\. Guildford        | 122            | 122       | 121               | 60            | 60             | 121                | 121                   | 121            | 184         | 184               | 183            | 182          | 182            | 182        | 121               | 0              | 60          | 121          | 182          | 182                |
| 17\. Slough           | 122            | 122       | 121               | 60            | 60             | 60                 | 60                    | 121            | 183         | 183               | 183            | 182          | 182            | 183        | 121               | 60             | 0           | 121          | 121          | 121                |
| 18\. Bristol          | 122            | 122       | 121               | 121           | 61             | 61                 | 121                   | 61             | 184         | 184               | 183            | 122          | 121            | 121        | 122               | 121            | 121         | 0            | 60           | 121                |
| 19\. Cardiff          | 123            | 123       | 122               | 121           | 121            | 61                 | 61                    | 61             | 184         | 184               | 183            | 122          | 122            | 121        | 122               | 182            | 121         | 60           | 0            | 122                |
| 20\. Wolverhampton    | 61             | 121       | 61                | 122           | 122            | 122                | 61                    | 60             | 122         | 122               | 122            | 121          | 121            | 121        | 121               | 182            | 121         | 121          | 121          | 0                  |


## c. Disconnect line: 2.Leeds - 6. City of London & 13. Sheffield - 1. Manchester & 13. Sheffield - 8. Birmingham
### c-1. Route the virtual link topology on the physical link topology
```MATLAB
Phy_G.L=[ % defining the physical topology
0	1	1	1	1	1	1	1	1	1	1	1	0	1	0	0	0	0	0	1
1	0	1	1	1	0	1	1	1	1	1	1	1	0	0	0	0	0	0	0
1	1	0	1	1	1	1	1	0	0	1	1	0	1	1	0	0	0	0	1
1	1	1	0	1	1	1	1	0	0	0	0	0	0	0	1	1	0	0	0
1	1	1	1	0	1	1	1	0	0	0	0	0	0	1	1	1	1	0	0
1	0	1	1	1	0	1	1	0	0	0	0	0	0	0	0	1	1	1	0
1	1	1	1	1	1	0	1	0	0	0	0	0	0	1	0	1	0	1	1
1	1	1	1	1	1	1	0	0	0	0	1	0	1	0	0	0	1	1	1
1	1	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	0	1	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0
0	0	0	1	1	1	1	0	0	0	0	0	0	0	0	1	0	0	0	0
0	0	0	0	1	1	0	1	0	0	0	0	0	0	0	0	0	0	1	0
0	0	0	0	0	1	1	1	0	0	0	0	0	0	0	0	0	1	0	0
1	0	1	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0
];
```
### c-2. Communication delay (in ms)
|                       | 1\. Manchester | 2\. Leeds | 3\. Milton Keynes | 4\. Docklands | 5\. South Bank | 6\. City of London | 7\. London North West | 8\. Birmingham | 9\. Glasgow | 10\. Clyde Valley | 11\. Newcastle | 12\. Preston | 13\. Sheffield | 14\. Derby | 15\. Peterborough | 16\. Guildford | 17\. Slough | 18\. Bristol | 19\. Cardiff | 20\. Wolverhampton |
|-----------------------|----------------|-----------|-------------------|---------------|----------------|--------------------|-----------------------|----------------|-------------|-------------------|----------------|--------------|----------------|------------|-------------------|----------------|-------------|--------------|--------------|--------------------|
| 1\. Manchester        | 0              | 60        | 61                | 62            | 62             | 62                 | 62                    | 61             | 62          | 62                | 61             | 60           | 121            | 61         | 122               | 122            | 122         | 122          | 123          | 61                 |
| 2\. Leeds             | 60             | 0         | 61                | 61            | 61             | 122                | 61                    | 61             | 62          | 62                | 61             | 61           | 60             | 121        | 122               | 122            | 122         | 122          | 122          | 121                |
| 3\. Milton Keynes     | 61             | 61        | 0                 | 61            | 61             | 61                 | 60                    | 61             | 123         | 123               | 62             | 61           | 121            | 61         | 60                | 121            | 121         | 121          | 122          | 61                 |
| 4\. Docklands         | 62             | 61        | 61                | 0             | 60             | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 60             | 60          | 122          | 121          | 122                |
| 5\. South Bank        | 62             | 61        | 61                | 60            | 0              | 60                 | 60                    | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 60             | 60          | 61           | 121          | 122                |
| 6\. City of London    | 62             | 122       | 61                | 60            | 60             | 0                  | 60                    | 61             | 123         | 123               | 123            | 122          | 182            | 122        | 121               | 121            | 60          | 61           | 61           | 122                |
| 7\. London North West | 62             | 61        | 60                | 60            | 60             | 60                 | 0                     | 61             | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 121            | 60          | 121          | 61           | 61                 |
| 8\. Birmingham        | 61             | 61        | 61                | 61            | 61             | 61                 | 61                    | 0              | 122         | 122               | 122            | 61           | 121            | 60         | 122               | 121            | 121         | 61           | 61           | 60                 |
| 9\. Glasgow           | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 0           | 60                | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 10\. Clyde Valley     | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 122            | 60          | 0                 | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 183          | 183          | 122                |
| 11\. Newcastle        | 61             | 61        | 62                | 123           | 123            | 123                | 123                   | 122            | 123         | 123               | 0              | 121          | 121            | 122        | 122               | 183            | 183         | 183          | 183          | 122                |
| 12\. Preston          | 60             | 61        | 61                | 122           | 122            | 122                | 122                   | 61             | 122         | 122               | 121            | 0            | 121            | 121        | 122               | 182            | 182         | 122          | 122          | 121                |
| 13\. Sheffield        | 121            | 60        | 121               | 122           | 122            | 182                | 122                   | 121            | 122         | 122               | 121            | 121          | 0              | 181        | 182               | 182            | 182         | 182          | 182          | 182                |
| 14\. Derby            | 61             | 121       | 61                | 122           | 122            | 122                | 122                   | 60             | 122         | 122               | 122            | 121          | 181            | 0          | 121               | 182            | 182         | 121          | 121          | 121                |
| 15\. Peterborough     | 122            | 122       | 60                | 121           | 61             | 121                | 61                    | 121            | 183         | 183               | 122            | 122          | 182            | 121        | 0                 | 121            | 121         | 122          | 122          | 121                |
| 16\. Guildford        | 122            | 122       | 121               | 60            | 60             | 121                | 121                   | 121            | 184         | 184               | 183            | 182          | 182            | 182        | 121               | 0              | 60          | 121          | 182          | 182                |
| 17\. Slough           | 122            | 122       | 121               | 60            | 60             | 60                 | 60                    | 121            | 183         | 183               | 183            | 182          | 182            | 183        | 121               | 60             | 0           | 121          | 121          | 121                |
| 18\. Bristol          | 122            | 122       | 121               | 121           | 61             | 61                 | 121                   | 61             | 184         | 184               | 183            | 122          | 183            | 121        | 122               | 121            | 121         | 0            | 60           | 121                |
| 19\. Cardiff          | 123            | 123       | 122               | 121           | 121            | 61                 | 61                    | 61             | 184         | 184               | 183            | 122          | 183            | 121        | 122               | 182            | 121         | 60           | 0            | 122                |
| 20\. Wolverhampton    | 61             | 121       | 61                | 122           | 122            | 122                | 61                    | 60             | 122         | 122               | 122            | 121          | 182            | 121        | 121               | 182            | 121         | 121          | 121          | 0                  |


## d. Disconnect node: 8. Birmingham
### d-1. Route the virtual link topology on the physical link topology
```MATLAB
Phy_G.L=[ % defining the physical topology
0	1	1	1	1	1	1	0	1	1	1	1	1	1	0	0	0	0	0	1
1	0	1	1	1	1	1	0	1	1	1	1	1	0	0	0	0	0	0	0
1	1	0	1	1	1	1	0	0	0	1	1	0	1	1	0	0	0	0	1
1	1	1	0	1	1	1	0	0	0	0	0	0	0	0	1	1	0	0	0
1	1	1	1	0	1	1	0	0	0	0	0	0	0	1	1	1	1	0	0
1	1	1	1	1	0	1	0	0	0	0	0	0	0	0	0	1	1	1	0
1	1	1	1	1	1	0	0	0	0	0	0	0	0	1	0	1	0	1	1
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0
0	0	0	1	1	1	1	0	0	0	0	0	0	0	0	1	0	0	0	0
0	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	1	0
0	0	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	1	0	0
1	0	1	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
];
```
### d-2. Communication delay (in ms)
|                       | 1\. Manchester | 2\. Leeds | 3\. Milton Keynes | 4\. Docklands | 5\. South Bank | 6\. City of London | 7\. London North West | 8\. Birmingham | 9\. Glasgow | 10\. Clyde Valley | 11\. Newcastle | 12\. Preston | 13\. Sheffield | 14\. Derby | 15\. Peterborough | 16\. Guildford | 17\. Slough | 18\. Bristol | 19\. Cardiff | 20\. Wolverhampton |
|-----------------------|----------------|-----------|-------------------|---------------|----------------|--------------------|-----------------------|----------------|-------------|-------------------|----------------|--------------|----------------|------------|-------------------|----------------|-------------|--------------|--------------|--------------------|
| 1\. Manchester        | 0              | 60        | 61                | 62            | 62             | 62                 | 62                    | 0              | 62          | 62                | 61             | 60           | 60             | 61         | 122               | 122            | 122         | 122          | 123          | 61                 |
| 2\. Leeds             | 60             | 0         | 61                | 61            | 61             | 61                 | 61                    | 0              | 62          | 62                | 61             | 61           | 60             | 121        | 122               | 122            | 122         | 122          | 123          | 121                |
| 3\. Milton Keynes     | 61             | 61        | 0                 | 61            | 61             | 61                 | 60                    | 0              | 123         | 123               | 62             | 61           | 122            | 61         | 60                | 121            | 121         | 121          | 122          | 61                 |
| 4\. Docklands         | 62             | 61        | 61                | 0             | 60             | 60                 | 60                    | 0              | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 60             | 60          | 121          | 121          | 122                |
| 5\. South Bank        | 62             | 61        | 61                | 60            | 0              | 60                 | 60                    | 0              | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 60             | 60          | 61           | 121          | 122                |
| 6\. City of London    | 62             | 61        | 61                | 60            | 60             | 0                  | 60                    | 0              | 123         | 123               | 123            | 122          | 122            | 122        | 121               | 121            | 60          | 61           | 61           | 122                |
| 7\. London North West | 62             | 61        | 60                | 60            | 60             | 60                 | 0                     | 0              | 123         | 123               | 123            | 122          | 122            | 122        | 61                | 121            | 60          | 121          | 61           | 61                 |
| 8\. Birmingham        | 0              | 0         | 0                 | 0             | 0              | 0                  | 0                     | 0              | 0           | 0                 | 0              | 0            | 0              | 0          | 0                 | 0              | 0           | 0            | 0            | 0                  |
| 9\. Glasgow           | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 0              | 0           | 60                | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 184          | 184          | 122                |
| 10\. Clyde Valley     | 62             | 62        | 123               | 123           | 123            | 123                | 123                   | 0              | 60          | 0                 | 123            | 122          | 122            | 122        | 184               | 184            | 183         | 184          | 184          | 122                |
| 11\. Newcastle        | 61             | 61        | 62                | 123           | 123            | 123                | 123                   | 0              | 123         | 123               | 0              | 121          | 121            | 122        | 122               | 183            | 183         | 184          | 184          | 122                |
| 12\. Preston          | 60             | 61        | 61                | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 121            | 0            | 121            | 121        | 122               | 182            | 182         | 183          | 183          | 121                |
| 13\. Sheffield        | 60             | 60        | 122               | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 121            | 121          | 0              | 121        | 183               | 182            | 182         | 183          | 183          | 121                |
| 14\. Derby            | 61             | 121       | 61                | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 122            | 121          | 121            | 0          | 121               | 183            | 182         | 183          | 183          | 121                |
| 15\. Peterborough     | 122            | 122       | 60                | 121           | 61             | 121                | 61                    | 0              | 183         | 183               | 122            | 122          | 182            | 121        | 0                 | 121            | 121         | 122          | 122          | 121                |
| 16\. Guildford        | 122            | 122       | 121               | 60            | 60             | 121                | 121                   | 0              | 184         | 184               | 183            | 182          | 182            | 183        | 121               | 0              | 60          | 121          | 182          | 182                |
| 17\. Slough           | 122            | 122       | 121               | 60            | 60             | 60                 | 60                    | 0              | 183         | 183               | 183            | 182          | 182            | 183        | 121               | 60             | 0           | 121          | 121          | 121                |
| 18\. Bristol          | 122            | 122       | 121               | 121           | 61             | 61                 | 121                   | 0              | 184         | 184               | 183            | 183          | 183            | 182        | 122               | 121            | 121         | 0            | 60           | 182                |
| 19\. Cardiff          | 123            | 123       | 122               | 121           | 121            | 61                 | 61                    | 0              | 184         | 184               | 183            | 183          | 183            | 182        | 122               | 182            | 121         | 60           | 0            | 122                |
| 20\. Wolverhampton    | 61             | 121       | 61                | 122           | 122            | 122                | 61                    | 0              | 122         | 122               | 122            | 121          | 121            | 121        | 122               | 182            | 121         | 183          | 122          | 0                  |


## e. Disconnect node: 8. Birmingham & 1. Manchester
### e-1. Route the virtual link topology on the physical link topology
```MATLAB
Phy_G.L=[ % defining the physical topology
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	1	1	1	1	0	1	1	1	1	1	0	0	0	0	0	0	0
0	1	0	1	1	1	1	0	0	0	1	1	0	1	1	0	0	0	0	1
0	1	1	0	1	1	1	0	0	0	0	0	0	0	0	1	1	0	0	0
0	1	1	1	0	1	1	0	0	0	0	0	0	0	1	1	1	1	0	0
0	1	1	1	1	0	1	0	0	0	0	0	0	0	0	0	1	1	1	0
0	1	1	1	1	1	0	0	0	0	0	0	0	0	1	0	1	0	1	1
0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	1	0	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0
0	1	0	0	0	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0
0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	1	0	1	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	1	0	0	0
0	0	0	1	1	1	1	0	0	0	0	0	0	0	0	1	0	0	0	0
0	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	0	0	1	0
0	0	0	0	0	1	1	0	0	0	0	0	0	0	0	0	0	1	0	0
0	0	1	0	0	0	1	0	0	0	0	0	0	0	0	0	0	0	0	0
];
```
### e-2. Communication delay (in ms)
|                       | 1\. Manchester | 2\. Leeds | 3\. Milton Keynes | 4\. Docklands | 5\. South Bank | 6\. City of London | 7\. London North West | 8\. Birmingham | 9\. Glasgow | 10\. Clyde Valley | 11\. Newcastle | 12\. Preston | 13\. Sheffield | 14\. Derby | 15\. Peterborough | 16\. Guildford | 17\. Slough | 18\. Bristol | 19\. Cardiff | 20\. Wolverhampton |
|-----------------------|----------------|-----------|-------------------|---------------|----------------|--------------------|-----------------------|----------------|-------------|-------------------|----------------|--------------|----------------|------------|-------------------|----------------|-------------|--------------|--------------|--------------------|
| 1\. Manchester        | 0              | 0         | 0                 | 0             | 0              | 0                  | 0                     | 0              | 0           | 0                 | 0              | 0            | 0              | 0          | 0                 | 0              | 0           | 0            | 0            | 0                  |
| 2\. Leeds             | 0              | 0         | 61                | 61            | 61             | 61                 | 61                    | 0              | 62          | 62                | 61             | 61           | 60             | 122        | 122               | 122            | 122         | 122          | 123          | 122                |
| 3\. Milton Keynes     | 0              | 61        | 0                 | 61            | 61             | 61                 | 60                    | 0              | 123         | 123               | 62             | 61           | 121            | 61         | 60                | 121            | 121         | 121          | 122          | 61                 |
| 4\. Docklands         | 0              | 61        | 61                | 0             | 60             | 60                 | 60                    | 0              | 123         | 123               | 122            | 122          | 122            | 121        | 121               | 60             | 60          | 121          | 121          | 121                |
| 5\. South Bank        | 0              | 61        | 61                | 60            | 0              | 60                 | 60                    | 0              | 123         | 123               | 122            | 122          | 122            | 121        | 61                | 60             | 60          | 61           | 121          | 121                |
| 6\. City of London    | 0              | 61        | 61                | 60            | 60             | 0                  | 60                    | 0              | 123         | 123               | 122            | 122          | 122            | 121        | 121               | 121            | 60          | 61           | 61           | 121                |
| 7\. London North West | 0              | 61        | 60                | 60            | 60             | 60                 | 0                     | 0              | 123         | 123               | 122            | 122          | 122            | 121        | 61                | 121            | 60          | 122          | 61           | 61                 |
| 8\. Birmingham        | 0              | 0         | 0                 | 0             | 0              | 0                  | 0                     | 0              | 0           | 0                 | 0              | 0            | 0              | 0          | 0                 | 0              | 0           | 0            | 0            | 0                  |
| 9\. Glasgow           | 0              | 62        | 123               | 123           | 123            | 123                | 123                   | 0              | 0           | 60                | 122            | 122          | 122            | 183        | 184               | 183            | 183         | 184          | 184          | 184                |
| 10\. Clyde Valley     | 0              | 62        | 123               | 123           | 123            | 123                | 123                   | 0              | 60          | 0                 | 122            | 122          | 122            | 183        | 184               | 183            | 183         | 184          | 184          | 184                |
| 11\. Newcastle        | 0              | 61        | 62                | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 0              | 121          | 121            | 122        | 122               | 183            | 183         | 183          | 183          | 122                |
| 12\. Preston          | 0              | 61        | 61                | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 121            | 0            | 121            | 122        | 122               | 182            | 182         | 183          | 183          | 122                |
| 13\. Sheffield        | 0              | 60        | 121               | 122           | 122            | 122                | 122                   | 0              | 122         | 122               | 121            | 121          | 0              | 182        | 182               | 182            | 182         | 183          | 183          | 182                |
| 14\. Derby            | 0              | 122       | 61                | 121           | 121            | 121                | 121                   | 0              | 183         | 183               | 122            | 122          | 182            | 0          | 121               | 182            | 182         | 182          | 182          | 121                |
| 15\. Peterborough     | 0              | 122       | 60                | 121           | 61             | 121                | 61                    | 0              | 183         | 183               | 122            | 122          | 182            | 121        | 0                 | 121            | 121         | 122          | 122          | 121                |
| 16\. Guildford        | 0              | 122       | 121               | 60            | 60             | 121                | 121                   | 0              | 183         | 183               | 183            | 182          | 182            | 182        | 121               | 0              | 60          | 121          | 182          | 182                |
| 17\. Slough           | 0              | 122       | 121               | 60            | 60             | 60                 | 60                    | 0              | 183         | 183               | 183            | 182          | 182            | 182        | 121               | 60             | 0           | 121          | 121          | 121                |
| 18\. Bristol          | 0              | 122       | 121               | 121           | 61             | 61                 | 121                   | 0              | 184         | 184               | 183            | 183          | 183            | 182        | 122               | 121            | 121         | 0            | 60           | 182                |
| 19\. Cardiff          | 0              | 123       | 122               | 121           | 121            | 61                 | 61                    | 0              | 184         | 184               | 183            | 183          | 183            | 182        | 122               | 182            | 121         | 60           | 0            | 122                |
| 20\. Wolverhampton    | 0              | 122       | 61                | 121           | 121            | 121                | 61                    | 0              | 183         | 183               | 122            | 122          | 182            | 121        | 121               | 182            | 121         | 183          | 122          | 0                  |
