# Modules and Packages

In Python, modules and packages are essential for organizing and reusing code. Let's break down what they are and how to use them.

## Importing Modules

A module is simply a file containing Python code. This code can define functions, classes, and variables. You can import a module into another Python script to use its functionality.

### Example:
```python
# math_module.py
def add(a, b):
    return a + b

def subtract(a, b):
    return a - b
```

To use this module in another script:
```python
# main.py
import math_module

result = math_module.add(5, 3)
print(result)  # Output: 8
```

## Standard Library Overview

Python comes with a vast standard library that includes many modules for various tasks, such as file I/O, system calls, and even web programming.

### Example:
```python
import math

print(math.sqrt(16))  # Output: 4.0
```

## Creating and Using Packages

A package is a way of organizing related modules into a directory hierarchy. A package must contain a special `__init__.py` file, which can be empty, to be recognized as a package.

### Example:
```
my_package/
    __init__.py
    module1.py
    module2.py
```

To use a package:
```python
# my_package/module1.py
def greet(name):
    return f"Hello, {name}!"

# main.py
from my_package import module1

print(module1.greet("Alice"))  # Output: Hello, Alice!
```

## Summary

- **Modules**: Files containing Python code that can be imported and reused.
- **Standard Library**: A collection of modules included with Python for various tasks.
- **Packages**: Directories containing multiple related modules, organized with an `__init__.py` file.

Understanding modules and packages helps you write cleaner, more maintainable code by organizing it into reusable components.

<div style="text-align: right;">
    <a href="9.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="7.md">Prev</a>
</div>