## 6. Data Structures

### Lists
Lists are a type of data structure in Python that can store multiple values in a single variable. They are defined by enclosing a sequence of values in square brackets `[]`. Lists are mutable, meaning they can be modified after creation.

- Creating a list:
  ```python
  my_list = [1, 2, 3, 4, 5]
  print(my_list)  # Output: [1, 2, 3, 4, 5]
  ```

- Indexing and slicing:
  ```python
  my_list = [1, 2, 3, 4, 5]
  print(my_list[0])  # Output: 1
  print(my_list[1:3])  # Output: [2, 3]
  ```

- Modifying a list:
  ```python
  my_list = [1, 2, 3, 4, 5]
  my_list.append(6)
  print(my_list)  # Output: [1, 2, 3, 4, 5, 6]
  my_list[0] = 10
  print(my_list)  # Output: [10, 2, 3, 4, 5, 6]
  ```

### Tuples
Tuples are similar to lists, but they are immutable, meaning they cannot be modified after creation. They are defined by enclosing a sequence of values in parentheses `()`.

- Creating a tuple:
  ```python
  my_tuple = (1, 2, 3, 4, 5)
  print(my_tuple)  # Output: (1, 2, 3, 4, 5)
  ```

- Indexing and slicing:
  ```python
  my_tuple = (1, 2, 3, 4, 5)
  print(my_tuple[0])  # Output: 1
  print(my_tuple[1:3])  # Output: (2, 3)
  ```

- Attempting to modify a tuple:
  ```python
  my_tuple = (1, 2, 3, 4, 5)
  try:
      my_tuple[0] = 10
  except TypeError:
      print("Tuples are immutable.")
  ```

### Sets
Sets are an unordered collection of unique elements. They are defined by enclosing a sequence of values in curly braces `{}`.

- Creating a set:
  ```python
  my_set = {1, 2, 3, 4, 5}
  print(my_set)  # Output: {1, 2, 3, 4, 5}
  ```

- Adding and removing elements:
  ```python
  my_set = {1, 2, 3, 4, 5}
  my_set.add(6)
  print(my_set)  # Output: {1, 2, 3, 4, 5, 6}
  my_set.remove(5)
  print(my_set)  # Output: {1, 2, 3, 4, 6}
  ```

### Dictionaries
Dictionaries are a type of data structure that stores key-value pairs. They are defined by enclosing a sequence of key-value pairs in curly braces `{}`.

- Creating a dictionary:
  ```python
  my_dict = {"name": "Alice", "age": 25}
  print(my_dict)  # Output: {'name': 'Alice', 'age': 25}
  ```

- Accessing and modifying values:
  ```python
  my_dict = {"name": "Alice", "age": 25}
  print(my_dict["name"])  # Output: 'Alice'
  my_dict["age"] = 30
  print(my_dict)  # Output: {'name': 'Alice', 'age': 30}
  ```

Understanding and using these data structures will help you store and manipulate data more effectively in your Python programs.

<div style="text-align: right;">
    <a href="7.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="5.md">Prev</a>
</div>