## 5. Data Structures

Data structures are ways to store and organize data so that it can be used efficiently. In Python, there are several built-in data structures that you will use frequently. Let's explore the most common ones: Lists, Tuples, Sets, and Dictionaries.

### Lists
- **Definition**: A list is an ordered collection of items that can be of different types.
- **Syntax**: Lists are defined using square brackets `[]`.
- **Example**:
  ```python
  fruits = ["apple", "banana", "cherry"]
  print(fruits)  # Output: ['apple', 'banana', 'cherry']
  ```
- **Common Operations**:
  - Accessing elements: `fruits[0]` gives `"apple"`
  - Adding elements: `fruits.append("orange")`
  - Removing elements: `fruits.remove("banana")`

### Tuples
- **Definition**: A tuple is similar to a list but is immutable, meaning it cannot be changed after creation.
- **Syntax**: Tuples are defined using parentheses `()`.
- **Example**:
  ```python
  coordinates = (10, 20)
  print(coordinates)  # Output: (10, 20)
  ```
- **Common Operations**:
  - Accessing elements: `coordinates[0]` gives `10`
  - Tuples are immutable, so you cannot add or remove elements.

### Sets
- **Definition**: A set is an unordered collection of unique items.
- **Syntax**: Sets are defined using curly braces `{}`.
- **Example**:
  ```python
  unique_numbers = {1, 2, 3, 4, 4, 5}
  print(unique_numbers)  # Output: {1, 2, 3, 4, 5}
  ```
- **Common Operations**:
  - Adding elements: `unique_numbers.add(6)`
  - Removing elements: `unique_numbers.remove(3)`

### Dictionaries
- **Definition**: A dictionary is an unordered collection of key-value pairs.
- **Syntax**: Dictionaries are defined using curly braces `{}` with key-value pairs separated by colons `:`.
- **Example**:
  ```python
  student = {"name": "John", "age": 25, "major": "Computer Science"}
  print(student)  # Output: {'name': 'John', 'age': 25, 'major': 'Computer Science'}
  ```
- **Common Operations**:
  - Accessing values: `student["name"]` gives `"John"`
  - Adding key-value pairs: `student["graduation_year"] = 2022`
  - Removing key-value pairs: `del student["age"]`

Understanding these data structures is crucial as they form the foundation for more complex data manipulation and storage in Python. Practice using them in different scenarios to get comfortable with their syntax and operations.

<div style="text-align: right;">
    <a href="6.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="4.md">Prev</a>
</div>