## 4. Control Flow

Control flow in Python allows you to control the order in which your code is executed. This is essential for making decisions and repeating actions. Let's break down the key components of control flow:

### Conditional Statements (if, elif, else)

Conditional statements let you execute certain parts of your code based on specific conditions.

#### `if` Statement
The `if` statement checks a condition and executes the code block if the condition is true.
```python
age = 18
if age >= 18:
    print("You are an adult.")
```

#### `elif` Statement
The `elif` (else if) statement checks another condition if the previous `if` condition was false.
```python
age = 16
if age >= 18:
    print("You are an adult.")
elif age >= 13:
    print("You are a teenager.")
```

#### `else` Statement
The `else` statement executes a code block if none of the previous conditions were true.
```python
age = 10
if age >= 18:
    print("You are an adult.")
elif age >= 13:
    print("You are a teenager.")
else:
    print("You are a child.")
```

### Loops (for, while)

Loops allow you to repeat a block of code multiple times.

#### `for` Loop
The `for` loop iterates over a sequence (like a list or a range).
```python
for i in range(5):
    print(i)
```

#### `while` Loop
The `while` loop continues to execute as long as a condition is true.
```python
count = 0
while count < 5:
    print(count)
    count += 1
```

### Break and Continue Statements

These statements help control the flow of loops.

#### `break` Statement
The `break` statement exits the loop immediately.
```python
for i in range(10):
    if i == 5:
        break
    print(i)
```

#### `continue` Statement
The `continue` statement skips the current iteration and moves to the next one.
```python
for i in range(10):
    if i % 2 == 0:
        continue
    print(i)
```

### Functions

Functions are reusable blocks of code that perform a specific task.

#### Defining Functions
You define a function using the `def` keyword.
```python
def greet(name):
    print(f"Hello, {name}!")
```

#### Function Arguments and Return Values
Functions can take arguments and return values.
```python
def add(a, b):
    return a + b

result = add(3, 4)
print(result)  # Output: 7
```

#### Lambda Functions
Lambda functions are small anonymous functions defined with the `lambda` keyword.
```python
add = lambda a, b: a + b
print(add(3, 4))  # Output: 7
```

#### Scope and Lifetime of Variables
Variables defined inside a function are local to that function and cannot be accessed outside.
```python
def my_function():
    local_var = 10
    print(local_var)

my_function()
# print(local_var)  # This will cause an error because local_var is not accessible here.
```

Understanding control flow is crucial for writing effective and efficient Python programs. Practice these concepts to get comfortable with making decisions and repeating actions in your code.


<div style="text-align: right;">
    <a href="5.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="3.md">Prev</a>
</div>