## 3. Operators

Operators in Python are special symbols that perform operations on variables and values. They are the building blocks of any programming language and are used to manipulate data and variables. Let's explore the different types of operators in Python.

### Arithmetic Operators
Arithmetic operators are used to perform mathematical operations such as addition, subtraction, multiplication, and division.

- `+` : Addition
  ```python
  x = 5
  y = 3
  print(x + y)  # Output: 8
  ```

- `-` : Subtraction
  ```python
  x = 5
  y = 3
  print(x - y)  # Output: 2
  ```

- `*` : Multiplication
  ```python
  x = 5
  y = 3
  print(x * y)  # Output: 15
  ```

- `/` : Division
  ```python
  x = 5
  y = 3
  print(x / y)  # Output: 1.6666666666666667
  ```

- `%` : Modulus (remainder of the division)
  ```python
  x = 5
  y = 3
  print(x % y)  # Output: 2
  ```

- `**` : Exponentiation (power)
  ```python
  x = 5
  y = 3
  print(x ** y)  # Output: 125
  ```

- `//` : Floor division (division that rounds down to the nearest integer)
  ```python
  x = 5
  y = 3
  print(x // y)  # Output: 1
  ```

### Comparison Operators
Comparison operators are used to compare two values. They return either `True` or `False`.

- `==` : Equal to
  ```python
  x = 5
  y = 3
  print(x == y)  # Output: False
  ```

- `!=` : Not equal to
  ```python
  x = 5
  y = 3
  print(x != y)  # Output: True
  ```

- `>` : Greater than
  ```python
  x = 5
  y = 3
  print(x > y)  # Output: True
  ```

- `<` : Less than
  ```python
  x = 5
  y = 3
  print(x < y)  # Output: False
  ```

- `>=` : Greater than or equal to
  ```python
  x = 5
  y = 3
  print(x >= y)  # Output: True
  ```

- `<=` : Less than or equal to
  ```python
  x = 5
  y = 3
  print(x <= y)  # Output: False
  ```

### Logical Operators
Logical operators are used to combine conditional statements.

- `and` : Returns `True` if both statements are true
  ```python
  x = 5
  print(x > 3 and x < 10)  # Output: True
  ```

- `or` : Returns `True` if one of the statements is true
  ```python
  x = 5
  print(x > 3 or x < 4)  # Output: True
  ```

- `not` : Reverses the result, returns `False` if the result is true
  ```python
  x = 5
  print(not(x > 3 and x < 10))  # Output: False
  ```

### Assignment Operators
Assignment operators are used to assign values to variables.

- `=` : Assigns a value to a variable
  ```python
  x = 5
  ```

- `+=` : Adds a value and assigns the result to the variable
  ```python
  x = 5
  x += 3  # Equivalent to x = x + 3
  print(x)  # Output: 8
  ```

- `-=` : Subtracts a value and assigns the result to the variable
  ```python
  x = 5
  x -= 3  # Equivalent to x = x - 3
  print(x)  # Output: 2
  ```

- `*=` : Multiplies a value and assigns the result to the variable
  ```python
  x = 5
  x *= 3  # Equivalent to x = x * 3
  print(x)  # Output: 15
  ```

- `/=` : Divides a value and assigns the result to the variable
  ```python
  x = 5
  x /= 3  # Equivalent to x = x / 3
  print(x)  # Output: 1.6666666666666667
  ```

- `%=` : Takes modulus and assigns the result to the variable
  ```python
  x = 5
  x %= 3  # Equivalent to x = x % 3
  print(x)  # Output: 2
  ```

- `**=` : Takes exponent and assigns the result to the variable
  ```python
  x = 5
  x **= 3  # Equivalent to x = x ** 3
  print(x)  # Output: 125
  ```

- `//=` : Takes floor division and assigns the result to the variable
  ```python
  x = 5
  x //= 3  # Equivalent to x = x // 3
  print(x)  # Output: 1
  ```

Understanding these operators is crucial for performing various operations in Python. Practice using them in different scenarios to get comfortable with their functionality.


<div style="text-align: right;">
    <a href="4.md">Next</a> 
</div>
<div style="text-align: left;">
    <a href="2.md">Prev</a>
</div>