## 2. Basic Syntax

### Python Syntax and Indentation
Python is known for its clean and readable syntax. Unlike many other programming languages, Python uses indentation to define the structure of the code. This means that the way you indent your code (using spaces or tabs) is very important.

**Example:**
```python
if True:
    print("This is indented correctly")
```

If you don't indent correctly, Python will throw an error.

### Variables and Data Types
Variables are used to store data. In Python, you don't need to declare the type of a variable. You just assign a value to a variable, and Python automatically knows the type.

**Example:**
```python
x = 5       # Integer
y = 3.14    # Float
name = "Alice"  # String
is_student = True  # Boolean
```

### Basic Input and Output
Python provides simple functions for input and output.

- **Output:** You can use the `print()` function to display output.
- **Input:** You can use the `input()` function to get input from the user.

**Example:**
```python
# Output
print("Hello, World!")

# Input
name = input("Enter your name: ")
print("Hello, " + name + "!")
```

In this example, `input()` takes a string as a prompt and waits for the user to type something and press Enter. The entered value is then stored in the variable `name`.

### Summary
- **Indentation:** Use consistent indentation to define code blocks.
- **Variables:** Assign values to variables without declaring their type.
- **Input/Output:** Use `print()` for output and `input()` for user input.

Understanding these basics will help you write clean and efficient Python code.

<div style="text-align: right;">
    <a href="3.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="1.md">Prev</a>
</div>
