# Project: Building a Simple Application

In this section, we will put together everything we've learned so far to build a simple Python application. This project will help you understand how to apply your knowledge in a practical scenario. Let's break it down into manageable steps:

## Planning the Project

Before we start coding, it's important to plan what we want to build. Here are the steps to plan your project:

1. **Define the Purpose**: Decide what your application will do. For this project, let's create a simple "To-Do List" application.
2. **List the Features**: Write down the features you want in your application. For example:
   - Add a new task
   - View all tasks
   - Mark a task as completed
   - Delete a task
3. **Design the User Interface**: Since this is a beginner project, we'll keep the interface simple and text-based.

## Writing the Code

Now that we have a plan, let's start coding. We'll break the code into small functions to make it easier to manage.

### Step 1: Create a List to Store Tasks

First, we'll create a list to store our tasks.

```python
tasks = []
```

### Step 2: Define Functions for Each Feature

Next, we'll define functions for each feature of our To-Do List application.

#### Add a New Task

```python
def add_task(task):
    tasks.append({"task": task, "completed": False})
    print(f"Task '{task}' added.")
```

#### View All Tasks

```python
def view_tasks():
    if not tasks:
        print("No tasks available.")
    else:
        for index, task in enumerate(tasks, start=1):
            status = "Done" if task["completed"] else "Not Done"
            print(f"{index}. {task['task']} - {status}")
```

#### Mark a Task as Completed

```python
def complete_task(task_number):
    if 0 < task_number <= len(tasks):
        tasks[task_number - 1]["completed"] = True
        print(f"Task {task_number} marked as completed.")
    else:
        print("Invalid task number.")
```

#### Delete a Task

```python
def delete_task(task_number):
    if 0 < task_number <= len(tasks):
        removed_task = tasks.pop(task_number - 1)
        print(f"Task '{removed_task['task']}' deleted.")
    else:
        print("Invalid task number.")
```

### Step 3: Create a Menu to Interact with the User

We'll create a simple menu to interact with the user and call the appropriate functions based on user input.

```python
def show_menu():
    print("\nTo-Do List Application")
    print("1. Add a new task")
    print("2. View all tasks")
    print("3. Mark a task as completed")
    print("4. Delete a task")
    print("5. Exit")

while True:
    show_menu()
    choice = input("Enter your choice: ")
    
    if choice == "1":
        task = input("Enter the task: ")
        add_task(task)
    elif choice == "2":
        view_tasks()
    elif choice == "3":
        task_number = int(input("Enter the task number to mark as completed: "))
        complete_task(task_number)
    elif choice == "4":
        task_number = int(input("Enter the task number to delete: "))
        delete_task(task_number)
    elif choice == "5":
        print("Exiting the application. Goodbye!")
        break
    else:
        print("Invalid choice. Please try again.")
```

## Testing and Debugging

After writing the code, it's important to test each feature to ensure it works as expected. Run your application and try adding, viewing, completing, and deleting tasks. If you encounter any issues, debug the code by checking for errors and fixing them.

## Conclusion

Congratulations! You've built a simple To-Do List application using Python. This project helped you practice working with lists, functions, and user input. Keep experimenting and adding new features to your application to enhance your skills.

In the next section, we'll recap what we've learned and discuss resources for further learning.

<div style="text-align: right;">
    <a href="14.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="12.md">Prev</a>
</div>