# Object-Oriented Programming (OOP)

Object-Oriented Programming (OOP) is a programming paradigm that revolves around the concept of objects and classes. It is a way to organize and structure code in a modular and reusable way.

## Classes and Objects

In OOP, a class is a blueprint or a template that defines the properties and behavior of an object. An object is an instance of a class, and it has its own set of attributes (data) and methods (functions).

### Example:
```python
class Dog:
    def __init__(self, name, age):
        self.name = name
        self.age = age

    def bark(self):
        print("Woof!")

my_dog = Dog("Fido", 3)
print(my_dog.name)  # Output: Fido
my_dog.bark()  # Output: Woof!
```

## Methods and Attributes

Methods are functions that belong to a class or object. They are used to perform actions on the object's attributes. Attributes are the data associated with an object.

### Example:
```python
class Car:
    def __init__(self, color, mileage):
        self.color = color
        self.mileage = mileage

    def drive(self, miles):
        self.mileage += miles

my_car = Car("red", 0)
print(my_car.color)  # Output: red
print(my_car.mileage)  # Output: 0
my_car.drive(100)
print(my_car.mileage)  # Output: 100
```

## Inheritance

Inheritance is a mechanism in OOP that allows one class to inherit the properties and behavior of another class. The child class inherits all the attributes and methods of the parent class and can also add new attributes and methods or override the ones inherited from the parent class.

### Example:
```python
class Animal:
    def __init__(self, name):
        self.name = name

    def eat(self):
        print(f"{self.name} is eating.")

class Dog(Animal):
    def __init__(self, name, age):
        super().__init__(name)
        self.age = age

    def bark(self):
        print("Woof!")

my_dog = Dog("Fido", 3)
print(my_dog.name)  # Output: Fido
my_dog.eat()  # Output: Fido is eating.
my_dog.bark()  # Output: Woof!
```

## Polymorphism

Polymorphism is the ability of an object to take on multiple forms. In OOP, polymorphism is achieved through method overriding or method overloading.

### Example:
```python
class Shape:
    def area(self):
        pass

class Circle(Shape):
    def __init__(self, radius):
        self.radius = radius

    def area(self):
        return 3.14 * self.radius ** 2

class Rectangle(Shape):
    def __init__(self, width, height):
        self.width = width
        self.height = height

    def area(self):
        return self.width * self.height

circle = Circle(5)
print(circle.area())  # Output: 78.5

rectangle = Rectangle(4, 5)
print(rectangle.area())  # Output: 20
```

Object-Oriented Programming is a powerful tool for organizing and structuring code. It allows for code reuse, modularity, and flexibility, making it a fundamental concept in software development.

<div style="text-align: right;">
    <a href="12.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="10.md">Prev</a>
</div>