# 10. Object-Oriented Programming (OOP)

## Classes and Objects
- **Class**: A blueprint for creating objects. It defines a set of attributes and methods that the created objects will have.
- **Object**: An instance of a class. It is created using the class blueprint and can have its own unique values for the attributes defined in the class.

### Example:
```python
class Dog:
    def __init__(self, name, age):
        self.name = name
        self.age = age

    def bark(self):
        print(f"{self.name} says woof!")

# Creating an object of the Dog class
my_dog = Dog("Buddy", 3)
my_dog.bark()  # Output: Buddy says woof!
```

## Methods and Attributes
- **Attributes**: Variables that belong to a class. They are defined in the class and describe the properties of the objects.
- **Methods**: Functions that belong to a class. They define the behaviors of the objects.

### Example:
```python
class Car:
    def __init__(self, make, model, year):
        self.make = make
        self.model = model
        self.year = year

    def start_engine(self):
        print(f"The {self.year} {self.make} {self.model}'s engine is now running.")

# Creating an object of the Car class
my_car = Car("Toyota", "Corolla", 2020)
my_car.start_engine()  # Output: The 2020 Toyota Corolla's engine is now running.
```

## Inheritance
- **Inheritance**: A way to create a new class using details of an existing class without modifying it. The new class inherits attributes and methods from the existing class.

### Example:
```python
class Animal:
    def __init__(self, name):
        self.name = name

    def speak(self):
        pass

class Cat(Animal):
    def speak(self):
        print(f"{self.name} says meow!")

# Creating an object of the Cat class
my_cat = Cat("Whiskers")
my_cat.speak()  # Output: Whiskers says meow!
```

## Polymorphism
- **Polymorphism**: The ability to use a common interface for multiple forms (data types). It allows methods to do different things based on the object it is acting upon.

### Example:
```python
class Bird:
    def __init__(self, name):
        self.name = name

    def speak(self):
        print(f"{self.name} says chirp!")

# Using the same method name 'speak' for different classes
animals = [Dog("Buddy", 3), Cat("Whiskers"), Bird("Tweety")]

for animal in animals:
    animal.speak()
# Output:
# Buddy says woof!
# Whiskers says meow!
# Tweety says chirp!
```

This content introduces the basic concepts of Object-Oriented Programming (OOP) in Python, including classes, objects, methods, attributes, inheritance, and polymorphism, with simple examples to help students understand each concept.

<div style="text-align: right;">
    <a href="11.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="9.md">Prev</a>
</div>