# 1. Introduction to Python

## What is Python?
Python is a high-level, interpreted programming language known for its simplicity and readability. It was created by Guido van Rossum and first released in 1991. Python is widely used in various fields such as web development, data analysis, artificial intelligence, scientific computing, and more. Its syntax is designed to be easy to read and write, making it an excellent choice for beginners.

## Installing Python
To start coding in Python, you need to install it on your computer. Follow these steps to install Python:

1. **Download Python:**
   - Go to the official Python website: [python.org](https://www.python.org/)
   - Click on the "Downloads" section.
   - Choose the version suitable for your operating system (Windows, macOS, or Linux) and download the installer.

2. **Run the Installer:**
   - Open the downloaded installer file.
   - Follow the installation instructions. Make sure to check the box that says "Add Python to PATH" before clicking "Install Now."

3. **Verify the Installation:**
   - Open a command prompt (Windows) or terminal (macOS/Linux).
   - Type `python --version` and press Enter. You should see the installed Python version number.

## Running Python Code
There are several ways to run Python code:

1. **Interactive Mode:**
   - Open a command prompt or terminal.
   - Type `python` and press Enter. This will open the Python interactive shell.
   - You can type Python commands directly and see the results immediately.

   Example:
   ```python
   >>> print("Hello, World!")
   Hello, World!
   ```

2. **Script Mode:**
   - Write your Python code in a text editor and save the file with a `.py` extension (e.g., `hello.py`).
   - Open a command prompt or terminal.
   - Navigate to the directory where your Python file is saved.
   - Type `python filename.py` and press Enter to run the script.

   Example:
   ```python
   # hello.py
   print("Hello, World!")
   ```

   Run the script:
   ```sh
   python hello.py
   ```

3. **Integrated Development Environment (IDE):**
   - You can use an IDE like PyCharm, VS Code, or Jupyter Notebook to write and run Python code. These tools provide additional features like syntax highlighting, debugging, and code completion to enhance your coding experience.

By following these steps, you will have Python installed and be ready to start writing and running Python code. Happy coding!

<div style="text-align: right;">
    <a href="2.md">Next</a>
</div>
<div style="text-align: left;">
    <a href="README.md">Prev</a>
</div>

