---
uid: resources
title: Resources
---

# Resources

## Akka.NET Bootcamp

[Akka.NET Bootcamp](http://learnakka.net/) is a free, self-directed learning course brought to you by the folks at [Petabridge](https://petabridge.com). Over the three units of this bootcamp you will learn how to create fully-functional, real-world programs using Akka.NET actors and many other parts of the core Akka.NET framework.

[**Start Bootcamp here.**](http://learnakka.net/)

## Blog Posts

### Petabridge

* [Akka.NET: What is an Actor?](https://petabridge.com/blog/akkadotnet-what-is-an-actor/) (Aaron Stannard on January 25, 2015)
* [How to Do Asynchronous I/O with Akka.NET Actors Using PipeTo](https://petabridge.com/blog/akkadotnet-async-actors-using-pipeto/) (Aaron Stannard on January 27, 2015)
* [How actors recover from failure](https://petabridge.com/blog/how-actors-recover-from-failure-hierarchy-and-supervision/) (Andrew Skotzko on February 6, 2015)
* [Akka.NET Internals: How Akka.Remote Connections Work](https://petabridge.com/blog/akka-internals-how-akka-remote-connections-work/) (Andrew Skotzko on May 6, 2015)
* [When Should I Use Actor Selection?](https://petabridge.com/blog/when-should-I-use-actor-selection/) (Andrew Skotzko on May 20, 2015)
* [Akka.NET: How to Remotely Deploy Actors Using Akka.Remote](https://petabridge.com/blog/akkadotnet-remote-deploy-actors/) (Aaron Stannard on June 1, 2015)
* [How to Create Scalable Clustered Applications Using Akka.Cluster](https://petabridge.com/blog/intro-to-akka-cluster/) (June 13, 2015)
* [Meet the Top Akka.NET Design Patterns](https://petabridge.com/blog/top-akkadotnet-design-patterns/) (Andrew Skotzko on June 30, 2015)
* [Large Messages and Sockets in Akka.NET](https://petabridge.com/blog/large-messages-and-sockets-in-akkadotnet/) (Andrew Skotzko on July 15, 2015)
* [Akka.NET Goes to Wall Street](https://petabridge.com/blog/akkadotnet-goes-to-wall-street/) (Andrew Skotzko on August 11, 2015)
* [How to Integrate Akka.NET and ASP.NET (and Nancy!)](https://petabridge.com/blog/akkadotnet-aspnet/) (Aaron Stannard on August 20, 2015)
* [The Top 7 Mistakes Newbies Make with Akka.NET](https://petabridge.com/blog/top-7-akkadotnet-stumbling-blocks/) (Aaron Stannard on September 7, 2015)
* [How to Stop an Actor... the Right Way](https://petabridge.com/blog/how-to-stop-an-actor-akkadotnet/) (Andrew Skotzko on September 9, 2015)
* [The New .NET Stack](https://petabridge.com/blog/the-new-dot-net-stack/) (Aaron Stannard on September 23, 2015)
* [How to Unit Test Akka.NET Actors with Akka.TestKit](https://petabridge.com/blog/how-to-unit-test-akkadotnet-actors-akka-testkit/) (November 13, 2015)
* [Creating Persistent Actors in Akka.NET with Akka.Persistence](https://petabridge.com/blog/intro-to-persistent-actors/) (Aaron Stannard on January 7, 2016)
* [How to Guarantee Delivery of Messages in Akka.NET](https://petabridge.com/blog/akkadotnet-at-least-once-message-delivery/) (Aaron Stannard on March 11, 2016)
* [The Business Case for Actors and Akka.NET](https://petabridge.com/blog/akkadotnet-business-case/) (Aaron Stannard on May 10, 2016)
* [Distributing State in Akka.Cluster Applications](https://petabridge.com/blog/akkacluster-state-distribution/) (Aaron Stannard on July 26, 2016)
* [Designing Akka.NET Applications from Scratch Part 1: Go with the Flow](https://petabridge.com/blog/akkadotnet-application-design-part1/) (Aaron Stannard on September 1, 2016)
* [Designing Akka.NET Applications from Scratch Part 2: Hierarchies and SOLID Principles](https://petabridge.com/blog/akkadotnet-application-design-part2/) (Aaron Stannard on November 30, 2016)
* [Introduction to Akka.Cluster.Sharding in Akka.NET](https://petabridge.com/blog/introduction-to-cluster-sharding-akkadotnet/) (Bartosz Sypytkowski on January 17, 2017)
* [Technical Overview of Akka.Cluster.Sharding in Akka.NET](https://petabridge.com/blog/cluster-sharding-technical-overview-akkadotnet/) (Bartosz Sypytkowski on January 31, 2017)
* [Introduction to Distributed Publish-Subscribe in Akka.NET](https://petabridge.com/blog/distributed-pub-sub-intro-akkadotnet/) (Bartosz Sypytkowski on February 14, 2017)
* [Introducing Petabridge.Cmd - a Command-line Management Tool for Akka.NET Applications](https://petabridge.com/blog/petabridgecmd-release/) (Aaron Stannard on June 7, 2017)

### Others

* [Deploying actors with Akka.NET](https://rogeralsing.com/2014/03/09/deploying-actors-with-akka-net/) (Roger Johansson on March 9, 2014)
* [FSharp and Akka.net - the functional way](http://bartoszsypytkowski.com/fsharp-and-akka-net-the-functional-way/) (Bartosz Sypytkowski on July 5th, 2014)
* [Map reduce with FSharp and Akka.net](http://bartoszsypytkowski.com/map-reduce-with-fsharp-and-akka-net/) (Bartosz Sypytkowski on July 8th, 2014)
* [Actor supervisors in Akka.NET FSharp API](http://bartoszsypytkowski.com/actor-supervisors-in-akka-net-fsharp-api/) (Bartosz Sypytkowski on August 6th, 2014)
* [Hipsterize your backend for The Greater Good with Akka.NET, F# and some DDD flavor](http://bartoszsypytkowski.com/hipsterize-your-backend-for-the-greater-good-with-akka-net-f-and-some-ddd-flavor/) (Bartosz Sypytkowski on October 26th, 2014)
* [Akka.NET – Concurrency control](https://rogeralsing.com/2014/11/10/akka-net-concurrency-control/) (Roger Johansson on November 10th, 2014)
* [Akka.NET remote deployment with F#](http://bartoszsypytkowski.com/akka-net-remote-deployment-with-f/) (Bartosz Sypytkowski on December 14th, 2014)
* [An Actor Model Example with Akka.NET](http://blog.geist.no/an-actor-model-example-with-akka-net/) (Claus Sørensen on February 24th, 2015)
* [Create your own Akka.NET persistence plugin](http://bartoszsypytkowski.com/create-your-own-akka-net-persistence-plugin/) (Bartosz Sypytkowski on March 28th, 2015)
* [Starting Akka.NET](http://blog.jaywayco.co.uk/starting-akka-net/) (James Conway on April 7, 2015)
* [Akka.NET + Azure: Azure ServiceBus integration](https://rogeralsing.com/2015/04/13/akka-net-azure-azure-servicebus-integration/) (Roger Johansson on April 13, 2015)
* [Akka.NET application logging in your browser](http://bartoszsypytkowski.com/log-your-akka-net-application-in-your-browser/) (Bartosz Sypytkowski on July 22nd, 2015)
* [Building a framework – The early Akka.NET history](https://rogeralsing.com/2015/07/26/building-a-framework-the-early-akka-net-history/) (Roger Johansson on July 26, 2015)
* [How to create an Akka.NET cluster in F#](http://bartoszsypytkowski.com/how-create-an-akka-net-cluster-in-f/) (Bartosz Sypytkowski on August 8th, 2015)
* [How Akka.NET persistence works?](http://bartoszsypytkowski.com/how-akka-net-persistence-works/) (Bartosz Sypytkowski on September 12th, 2015)
* [Akka.NET underestimated features - Akka.IO](http://bartoszsypytkowski.com/akka-net-underestimated-feature-akka-io/) (Bartosz Sypytkowski on November 14th, 2015)
* [Random things learned building Akka.NET – Part 1](https://rogeralsing.com/2016/03/13/random-things-learned-building-akka-net-part-1/) (Roger Johansson on March 13, 2016)
* [Don't Ask, Tell](http://bartoszsypytkowski.com/dont-ask-tell-2/) (Bartosz Sypytkowski on May 3rd, 2016)
* [Monitoring Akka.NET Systems with Datadog](https://gregshackles.com/monitoring-akka-net-systems-with-datadog/) (Creg Shackles on May 25th, 2017)
* [Actor model and using of Akka.NET](https://rubikscode.net/2017/05/28/actor-model-and-using-of-akka-net/) (Nikola Živković on May 28th, 2017)

## Videos

* [The Actor Model in F# and Akka.Net](https://www.youtube.com/watch?v=RiWXo_5CAvg) (March 17, 2015)
* [Streaming ETL w/ Akka.NET](https://vimeo.com/123452527) (Andrew Skotzko on March 18, 2015)
* [Akka.NET Internals: How Akka.Remote Connections Work](https://www.youtube.com/watch?v=6c1gVLyYcMM) (Aaron Stannard on May 5, 2015)
* [Full-Stack, Message-Oriented Programming with Akka.NET Actors](https://www.youtube.com/watch?v=nPGMVhI7zyk) (Andrew Skotzko on 8th December, 2015)
* [Akka.NET: The Future of Distributed Programming in .NET](https://www.youtube.com/watch?v=ozelpjr9SXE) (Aaron Stannard on August 31, 2016)
* [Life with actors: experience report](https://www.youtube.com/watch?v=KQwskUjsSi8) (Vagif Abilov and Erlend Wiig on February 16th, 2017)
* [Akka.NET: The Future of Distributed Programming in .NET](https://www.youtube.com/watch?v=Q3SzfO8jloc) (Aaron Stannard on June 8th, 2017)
* [Easy Eventual Consistency with Actor Models + Amazon Web Services](https://www.youtube.com/watch?v=PJT9D_4uUEg) (Philip Laureano on July 5th, 2017)
* [Composing high performance process workflows with Akka Streams](https://www.youtube.com/watch?v=kWU_LxYXMjE) (Vagif Abilov on July 5th, 2017)
* [Getting real(time) with Akka.NET, React and Redux](https://www.youtube.com/watch?v=irvm5EdHQc0) (Francis Paulin on July 5th, 2017)
* [Channel 9: Building distributed applications with Akka.NET](https://channel9.msdn.com/Shows/On-NET/Building-distributed-applications-with-AkkaNET) (Aaron Stannard on April 3, 2018)

## Courses

* [Building Concurrent Applications with the Actor Model in Akka.NET (Pluralsight)](https://www.pluralsight.com/courses/akka-dotnet-actor-model-building-concurrent-applications) (Jason Roberts on 5 August 2015)
* [Implementing Logging and Dependency Injection in Akka.NET](https://www.pluralsight.com/courses/akka-dotnet-implementing-logging-dependency-injection) (Jason Roberts on 22 August 2015)
* [Building Reactive Concurrent WPF Applications with Akka.NET](https://www.pluralsight.com/courses/akka-dotnet-building-reactive-concurrent-wpf-applications) (Jason Roberts on 10 September 2015)
* [Improving Message Throughput in Akka.NET](https://www.pluralsight.com/courses/akka-dotnet-improving-messaging-throughput) (Jason Roberts on 1 October 2015)
* [Stateful Reactive Concurrent SPAs with SignalR and Akka.NET](https://www.pluralsight.com/courses/akkadotnet-signalr-stateful-reactive-concurrent-spas) (Jason Roberts on 4 November 2015)
* [Akka.NET Testing Fundamentals](https://www.pluralsight.com/courses/akka-dotnet-testing-fundamentals) (Jason Roberts on 8 December 2015)
* [Building Distributed Systems with Akka.NET Clustering](https://www.pluralsight.com/courses/akka-dotnet-building-distributed-systems-clustering) (Simon Anderson on 23 March 2016)
* [Akka.NET Persistence Fundamentals](https://www.pluralsight.com/courses/akka-dotnet-persistence-fundamentals) (Jason Roberts on 23 Jul 2016)

## Podcasts

* [.NET Rocks! (August 2016)](http://dotnetrocks.com/default.aspx?showNum=1338) — [Aaron Stannard](https://twitter.com/aaronontheweb) introduces Akka.NET v1.1
* [.NET Rocks! (May 2015)](http://dotnetrocks.com/default.aspx?showNum=1134) — [Aaron Stannard](https://twitter.com/aaronontheweb) introduces Akka.NET v1.0
* [Hanselminutes (April 2015)](http://hanselminutes.com/472/inside-the-akkanet-open-source-project-and-the-actor-model-with-aaron-stannard) — Good overview of concepts in Akka.NET and high-level discussion with [Aaron Stannard](https://twitter.com/aaronontheweb).
* [.NET Rocks! (November 2014)](http://www.dotnetrocks.com/default.aspx?showNum=1058) — Overview of the project discussed w/ [Roger Alsing](https://twitter.com/rogeralsing).

## Code Samples / Demos

* [Using Akka.Cluster to build a web crawler](https://github.com/petabridge/akkadotnet-code-samples/tree/master/Cluster.WebCrawler)

## Non-English Resources

* [Distributed Programming Using Akka.NET Framework (in Polish)](https://www.youtube.com/watch?v=_6vDp2-VCjc) (Bartosz Sypytkowski on March 6, 2015)
* [Intro to Akka.NET (in Swedish)](https://www.youtube.com/watch?v=Ta6qLA9OsjE) (Håkan Canberger on March 23, 2015)
* [Writing scalable and distributed systems with Akka.NET](https://www.youtube.com/watch?v=fwWA6Bugg_c) (Nikita Tsukanov on June 5, 2015)
* [Actor Model on .NET (in Russian)](https://www.youtube.com/watch?v=jek8Qmc3ZjQ) (Anton Moldovan on October 30, 2015)
* [Actor-based Concurrency with F# and Akka.NET (in Russian)](https://www.youtube.com/watch?v=LLG8_0XtD4o) (Akim Boyko on 19 December, 2015)
