---
uid: community-standups
title: Akka.NET Community Stand-Ups
---

# Akka.NET Community Stand-Ups

Akka.NET Community Stand-ups are a once-a-month meeting that happens on the second Wednesday of each month and is live-streamed via [Petabridge’s YouTube channel](https://www.youtube.com/c/PetabridgeAcademy).

> [!TIP]
> [Click here to subscribe for future Akka.NET Community Stand-up notifications on YouTube](https://www.youtube.com/c/PetabridgeAcademy?sub_confirmation=1)

## Structure of Each Stand-Up

1. **Recap of most recent Akka.NET releases (10 min)** - we should talk about the work that was performed since the last stand-up, its impact on end-users, and what we learned in the course of performing that work.
2. **Plans for future work (10 min)** - what are we working on next, why, and why should users care?
3. **Opportunities to contribute (5 min)** - what help would we like from the Akka.NET end-user community?
4. **Show and Tell (20 min)** - give members of the Akka.NET team and community opportunities to showcase their work built on top of Akka.NET.
5. **Q&A (10 min)** - show and tell presenters along with the Akka.NET team should take questions via YouTube Live from the audience.

### Current Schedule

**Stand-ups are second Wednesday of each month starting at 12pm CST.**

> [!TIP]
> See our [schedule of upcoming 2022 Akka.NET Community Stand-ups here](https://github.com/akkadotnet/akka.net/discussions/5691).

## Show and Tell Presentations

The AKka.NET team features members of the Akka.NET community at each stand-up, where they their stories about how they use Akka.NET at work. e call these "Show and Tell" presentations and they are featured in our Community Stand-ups going forward.

> [!IMPORTANT]
> Show and Tell is a great way to attract talented .NET developers in the Akka.NET community who love to work on the sorts of interesting and important problems that Akka.NET solves well. Use this as a platform to showcase your company and attract great talent to it!

You can participate in the Show and Tell process by filling out this form: [Akka.NET Community Stand-up Submission](https://forms.gle/zR1K2pygCFhdCG7v5) - someone from our team will respond, help you with your presentation, and get you scheduled for one of our upcoming 2022 Akka.NET Community Stand-ups.

### Show and Tell Structure

Show and tell is an important component of each set of community stand-ups as it gives members of the Akka.NET Community a chance to share their experiences and success with Akka.NET.

Here is what makes for a compelling show and tell presentation:

1. Presenter Background - who are you, who do you work for, and what do you do?
2. Project Background - why is this project important to you and your company?
3. Requirements - what requirements did this project have?
4. Why Akka.NET - why did you choose Akka.NET? What was the criteria? What alternatives did you consider?
5. Which parts of Akka.NET do you use and why?
6. Was this a greenfield project or an update to a legacy system? What were the key implementation challenges with Akka.NET?
7. How has the system been performing for you since?
8. Visualization - do you have some diagrams that can help show how the system runs?
9. Any future plans for Akka.NET on your project or at your company?

### Production

After you've submitted the form, a member of the Akka.NET team will contact you and help you put together a PowerPoint presentation or a live demo that helps "show" all of the answers to your questions above. This is a great opportunity for you and your company to showcase the interesting work that you do and attract potential Akka.NET talent to your company.

### Past Show and Tells

Examples of past show and tells:

* [Game Plumbing Framework on Akka.NET](https://youtu.be/6AoDlK8LtFU?t=958) - July 7th, 2021

### Submit a “Show and Tell”

Want to share your experience with Akka.NET? Fill out our Google Form here and someone from our team will contact you about participating in an upcoming Akka.NET Community Stand-up!

> [!TIP]
> Click here to submit a "Show and Tell" proposal to the Akka.NET team: [Akka.NET Community Stand-up Submission](https://forms.gle/zR1K2pygCFhdCG7v5)
