---
uid: users-and-use-cases
title: Akka.NET Users and Use Cases
---

# Akka.NET Users and Use Cases

Akka.NET is used by many large organizations and in industries such as investment and merchant banking, retail and social media, simulation, gaming and betting, automobile and traffic systems, health care, data analytics, and much more.
Any system that has the need for high-throughput and low latency is a good candidate for using Akka.NET.

## Akka.NET Users

### Transaction Processing (Online Gaming, Finance/Banking, Trading, Statistics, Betting, Social Media, Telecom)

* [CellularSales](https://youtu.be/G3ZafPNI-hk?t=31m6s)

### Service Backend (Any Industry, Any App)

[IVC Business Systems](http://ivcbusinesssystems.com/):

> Sam Covington, IVC Business Systems: We had an in-house "Actor" system that we replaced with Akka.Net, which allowed us to innovate and be productive elsewhere, and not reinvent the wheel(not to mention test it to death). This back end of Microservices forms the basis of all of our products and services. We're using it in our Enterprise Social Product, and our new Livescan Office product for Livescan fingerprinting customers.

### Concurrency/Parallelism (Any App)

Share of an article by Joel Mueller, Software Architect, SNL Financial

* [SNL Financial (a subsidiary of McGraw Hill): Akka.NET Goes to Wall Street](https://petabridge.com/blog/akkadotnet-goes-to-wall-street/)

### Simulation

* [Vertech Using Akka.NET for Device Simulation](https://petabridge.com/blog/akkadotnet-vertech-device-simulation/)

Master/Worker, Compute Grid, MapReduce etc.

### Batch Processing (Any Industry)

Camel integration to hook up with batch data sources Actors divide and conquer the batch workloads

### Communications Hub (Telecom, Web Media, Mobile Media)

* [EventDay: real-time conference and event management at scale with Akka.NET](https://youtu.be/G3ZafPNI-hk?t=6m16s)

### Gaming and Betting (MOM, Online Gaming, Betting)

Scale up, scale out, fault-tolerance / HA

### Business Intelligence/Data Mining/General Purpose Crunching

Tweet from Philip Laureano with links.

* [Real-time Clickstream Processing at Domain.au with Octopus Deploy and Akka.NET](https://twitter.com/philiplaureano/status/735976018993778688)

### Internet of Things

* [Synchromatics: Real-time public transit tracking and analytics using Akka.NET](https://youtu.be/YuY1ziEqifU?t=3m38s)

### Complex Event Stream Processing

Archive of a blog post by Aaron Stannard from July 2014.

* [MarkedUp Analytics: Real-time Marketing Automation with Distributed Actor Systems and Akka.NET](http://www.aaronstannard.com/markedup-akkadotnet/)

### Blockchain

"NEO is a non-profit community-driven blockchain project. It utilizes blockchain technology and digital identity to digitize assets and automate the management of digital assets using smart contracts." (source: neo.org)

* [Website](https://neo.org)
* [Documentation](http://docs.neo.org/en-us/index.html)
* [Github](https://github.com/neo-project)
* [Protocol](https://github.com/neo-project/neo)
* [Video](https://www.youtube.com/channel/UCl1AwEDN0w5lTmfJEMsY5Vw)
