---
uid: AK2001
title: Akka.Analyzers Rule AK2001 - "Do not use automatically handled messages in inside `Akka.Cluster.Sharding.IMessageExtractor`s."
---

# AK2001 - Warning

Do not use automatically handled messages in inside [`Akka.Cluster.Sharding.IMessageExtractor`](xref:Akka.Cluster.Sharding.IMessageExtractor)s.

## Cause

As of Akka.NET v1.5.15, [Akka.Cluster.Sharding is guaranteed to automatically handle the following built-in messages](https://github.com/akkadotnet/akka.net/pull/6863):

* [`ShardRegion.StartEntity`](xref:Akka.Cluster.Sharding.ShardRegion.StartEntity) - used whenever [Akka.Cluster.Sharding's `remember-entities` feature](xref:cluster-sharding#remembering-entities) is enabled.
* [`ShardingEnvelope`](xref:Akka.Cluster.Sharding.ShardingEnvelope) - a generic envelope type that can be used to send arbitrary messages to entity actors.

Whenever a user tries to manually handle either of these messages, they're performing duplicate work - this rule is in effect to spot wasteful situations and to automatically provide a Roslyn code fix to resolve them.

An example:

```csharp
using Akka.Cluster.Sharding;

public sealed class MessageExtractor : HashCodeMessageExtractor
{
    public MessageExtractor() : base(maxNumberOfShards: 100) { }

    public string EntityId(object message) 
    {
        return message switch
        {
            string sharded => sharded,
            ShardingEnvelope e => e.EntityId,
            ShardRegion.StartEntity start => start.EntityId,
            _ => null,
        };
    } 
}
```

## Resolution

Akka.Analyzers comes with a code fix for this issue, which if accepted by the end user, will rewrite the previous example to the following:

```csharp
using Akka.Cluster.Sharding;

public sealed class MessageExtractor : HashCodeMessageExtractor
{
    public MessageExtractor() : base(maxNumberOfShards: 100) { }

public string EntityId(object message) 
    {
        return message switch
        {
            string sharded => sharded,
            _ => null,
        };
    } 
}
```
