---
uid: AK2000
title: Akka.Analyzers Rule AK2000 - "Do not use `Ask` with `TimeSpan.Zero` for timeout."
---

# AK2000 - Error

Do not use [`Ask<T>`](xref:Akka.Actor.Futures#Akka_Actor_Futures_Ask__1_Akka_Actor_ICanTell_System_Object_System_Nullable_System_TimeSpan__) or [`Ask`](xref:Akka.Actor.Futures#Akka_Actor_Futures_Ask_Akka_Actor_ICanTell_System_Object_System_Nullable_System_TimeSpan__) with `TimeSpan.Zero` for timeout.

## Cause

When using `Ask`, you must always specify a timeout value greater than `TimeSpan.Zero` otherwise the process might deadlock. See [https://github.com/akkadotnet/akka.net/issues/6131](https://github.com/akkadotnet/akka.net/issues/6131) for details.

> [!IMPORTANT]
> This rule is not exhaustive - Roslyn can't scan every possible variable value at compilation time, so it's still possible to pass in a `TimeSpan.Zero` value even with this rule present.

An example:

```csharp
using Akka.Actor;
using System.Threading.Tasks;
using System;

public static class MyActorCaller{
 public static Task<string> Call(IActorRef actor){
     return actor.Ask<string>(""hello"", TimeSpan.Zero);
 }
}
```

## Resolution

The right way to fix this issue is to pass in a non-zero value or to use the `Ask<T>` overload that accepts a `CancellationToken`.

Here's an example below:

```csharp
using Akka.Actor;
using System.Threading.Tasks;
using System;

public static class MyActorCaller{
    public static Task<string> Call(IActorRef actor){
        return actor.Ask<string>(""hello"", TimeSpan.FromSeconds(1));
    }
}
```
