---
uid: AK1001
title: Akka.Analyzers Rule AK1001 - "Should always close over `Sender` when using `PipeTo`"
---

# AK1001 - Error

> [!WARNING]
> This error has been deprecated because it is not valid, as pointed out in [this issue](https://github.com/akkadotnet/akka.analyzers/issues/65).
>
> Upgrade your Akka.Analyzer version to 0.2.3.1 if this error shows up in your Akka.NET solution.

~~You should always close over [`Context.Sender`](xref:Akka.Actor.IActorContext#Akka_Actor_IActorContext_Sender) when using [`PipeTo`](xref:Akka.Actor.PipeToSupport#Akka_Actor_PipeToSupport_PipeTo_System_Threading_Tasks_Task_Akka_Actor_ICanTell_Akka_Actor_IActorRef_System_Func_System_Object__System_Func_System_Exception_System_Object__)~~

## Cause

~~When using `PipeTo`, you must always close over `Sender` to ensure that the actor's `Sender` property is captured at the time you're scheduling the `PipeTo`, as this value may change asynchronously.~~

~~This is a concurrent programming problem: `PipeTo` will be evaluated and executed at some point in the future because it's an asynchronous continuation, therefore the `Context.Sender` property, which is _mutable and changes each time the original actor processes a message_, may change.~~

~~An example:~~

```csharp
using Akka.Actor;
using System.Threading.Tasks;
using System;

public sealed class MyActor : UntypedActor{

    protected override void OnReceive(object message){
        async Task<int> LocalFunction(){
            await Task.Delay(10);
            return message.ToString().Length;
        }

        // potentially unsafe use of Context.Sender
        LocalFunction().PipeTo(Sender); 
    }
}
```

## Resolution

~~To avoid this entire category of problem, we should close over the `Context.Sender` property in a local variable.~~

~~Here's an example below:~~

```csharp
using Akka.Actor;
using System.Threading.Tasks;
using System;

public sealed class MyActor : UntypedActor{

    protected override void OnReceive(object message){
        async Task<int> LocalFunction(){
            await Task.Delay(10);
            return message.ToString().Length;
        }

        var sender = Sender;
        LocalFunction().PipeTo(sender); 
    }
}
```
